/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.cls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import org.protege.editor.core.ui.menu.PopupMenuId;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.ui.action.AbstractOWLTreeAction;
import org.protege.editor.owl.ui.action.DeleteClassAction;
import org.protege.editor.owl.ui.renderer.AddChildIcon;
import org.protege.editor.owl.ui.renderer.AddSiblingIcon;
import org.protege.editor.owl.ui.renderer.OWLClassIcon;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;
import org.protege.editor.owl.ui.tree.OWLObjectTreeNode;
import org.protege.editor.owl.ui.tree.OWLTreeDragAndDropHandler;
import org.protege.editor.owl.ui.tree.OWLTreePreferences;
import org.protege.editor.owl.ui.view.CreateNewChildTarget;
import org.protege.editor.owl.ui.view.CreateNewSiblingTarget;
import org.protege.editor.owl.ui.view.CreateNewTarget;
import org.protege.editor.owl.ui.view.cls.AbstractOWLClassHierarchyViewComponent;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;

public class ToldOWLClassHierarchyViewComponent
extends AbstractOWLClassHierarchyViewComponent
implements CreateNewTarget,
CreateNewChildTarget,
CreateNewSiblingTarget,
SelectionDriver {
    private static final OWLEntityIcon OWL_CLASS_ICON = new OWLClassIcon();
    private static final Icon ADD_SUB_ICON = new AddChildIcon(OWL_CLASS_ICON);
    private static final Icon ADD_SIBLING_ICON = new AddSiblingIcon(OWL_CLASS_ICON);
    private static final String ADD_GROUP = "A";
    private static final String DELETE_GROUP = "B";
    private static final String FIRST_SLOT = "A";
    private static final String SECOND_SLOT = "B";

    @Override
    public void performExtraInitialisation() throws Exception {
        AbstractOWLTreeAction<OWLClass> addSubClassAction = new AbstractOWLTreeAction<OWLClass>("Add subclass", ADD_SUB_ICON, this.getTree().getSelectionModel()){

            public void actionPerformed(ActionEvent event) {
                ToldOWLClassHierarchyViewComponent.this.createNewChild();
            }

            @Override
            protected boolean canPerform(OWLClass cls) {
                return ToldOWLClassHierarchyViewComponent.this.canCreateNewChild();
            }
        };
        this.addAction(addSubClassAction, "A", "A");
        AbstractOWLTreeAction<OWLClass> addSiblingClassAction = new AbstractOWLTreeAction<OWLClass>("Add sibling class", ADD_SIBLING_ICON, this.getTree().getSelectionModel()){

            public void actionPerformed(ActionEvent event) {
                ToldOWLClassHierarchyViewComponent.this.createNewSibling();
            }

            @Override
            protected boolean canPerform(OWLClass cls) {
                return ToldOWLClassHierarchyViewComponent.this.canCreateNewSibling();
            }
        };
        this.addAction(addSiblingClassAction, "A", "B");
        DeleteClassAction deleteClassAction = new DeleteClassAction(this.getOWLEditorKit(), () -> new HashSet(this.getTree().getSelectedOWLObjects())){

            @Override
            public void updateState() {
                super.updateState();
                if (this.isEnabled()) {
                    this.setEnabled(ToldOWLClassHierarchyViewComponent.this.isInAssertedMode());
                }
            }
        };
        this.addAction(deleteClassAction, "B", "A");
        this.getTree().setDragAndDropHandler(new OWLTreeDragAndDropHandler<OWLClass>(){

            @Override
            public boolean canDrop(Object child, Object parent) {
                return OWLTreePreferences.getInstance().isTreeDragAndDropEnabled() && child instanceof OWLClass;
            }

            @Override
            public void move(OWLClass child, OWLClass fromParent, OWLClass toParent) {
                if (!OWLTreePreferences.getInstance().isTreeDragAndDropEnabled()) {
                    return;
                }
                ToldOWLClassHierarchyViewComponent.this.handleMove(child, fromParent, toParent);
            }

            @Override
            public void add(OWLClass child, OWLClass parent) {
                if (!OWLTreePreferences.getInstance().isTreeDragAndDropEnabled()) {
                    return;
                }
                ToldOWLClassHierarchyViewComponent.this.handleAdd(child, parent);
            }
        });
        this.getAssertedTree().setPopupMenuId(new PopupMenuId("[AssertedClassHierarchy]"));
    }

    private void handleAdd(OWLClass child, OWLClass parent) {
        if (child.equals(this.getOWLModelManager().getOWLDataFactory().getOWLThing())) {
            return;
        }
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
        changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)df.getOWLDeclarationAxiom((OWLEntity)child)));
        if (!df.getOWLThing().equals(parent)) {
            changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)parent)));
        }
        this.getOWLModelManager().applyChanges(changes);
    }

    private void handleMove(OWLClass child, OWLClass fromParent, OWLClass toParent) {
        OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
        if (child.equals(df.getOWLThing())) {
            return;
        }
        ArrayList<Object> changes = new ArrayList<Object>();
        OWLOntology activeOntology = this.getOWLModelManager().getActiveOntology();
        OWLSubClassOfAxiom existingNonAnnotatedAxiom = df.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)fromParent);
        if (fromParent.isOWLThing() && activeOntology.getAxiomsIgnoreAnnotations((OWLAxiom)existingNonAnnotatedAxiom, Imports.INCLUDED).isEmpty()) {
            if (!toParent.isOWLThing()) {
                changes.add(new AddAxiom(activeOntology, (OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)toParent)));
            }
        } else {
            for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
                Set axiomsToRemove = ont.getAxiomsIgnoreAnnotations((OWLAxiom)existingNonAnnotatedAxiom);
                for (OWLAxiom ax : axiomsToRemove) {
                    changes.add(new RemoveAxiom(ont, ax));
                    if (ax.getAnnotations().isEmpty() && toParent.isOWLThing()) continue;
                    OWLSubClassOfAxiom axToAdd = df.getOWLSubClassOfAxiom((OWLClassExpression)child, (OWLClassExpression)toParent, ax.getAnnotations());
                    changes.add(new AddAxiom(ont, (OWLAxiom)axToAdd));
                }
            }
        }
        this.getOWLModelManager().applyChanges(changes);
    }

    @Override
    protected OWLObjectHierarchyProvider<OWLClass> getHierarchyProvider() {
        return this.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider();
    }

    @Override
    protected Optional<OWLObjectHierarchyProvider<OWLClass>> getInferredHierarchyProvider() {
        return Optional.of(this.getOWLModelManager().getOWLHierarchyManager().getInferredOWLClassHierarchyProvider());
    }

    @Override
    public boolean canCreateNew() {
        return this.isInAssertedMode();
    }

    @Override
    public boolean canCreateNewChild() {
        return this.isInAssertedMode() && !this.getSelectedEntities().isEmpty();
    }

    @Override
    public boolean canCreateNewSibling() {
        return this.isInAssertedMode() && !this.getSelectedEntities().isEmpty() && !((OWLClass)this.getSelectedEntity()).equals(this.getOWLModelManager().getOWLDataFactory().getOWLThing());
    }

    @Override
    public void createNewChild() {
        OWLEntityCreationSet<OWLClass> set = this.getOWLWorkspace().createOWLClass();
        if (set != null) {
            OWLClass newClass = set.getOWLEntity();
            OWLClass selectedClass = (OWLClass)this.getSelectedEntity();
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.addAll(set.getOntologyChanges());
            OWLModelManager mngr = this.getOWLEditorKit().getModelManager();
            OWLDataFactory df = mngr.getOWLDataFactory();
            if (!df.getOWLThing().equals(selectedClass)) {
                OWLSubClassOfAxiom ax = df.getOWLSubClassOfAxiom((OWLClassExpression)set.getOWLEntity(), (OWLClassExpression)selectedClass);
                changes.add(new AddAxiom(mngr.getActiveOntology(), (OWLAxiom)ax));
            }
            mngr.applyChanges(changes);
            this.getTree().setSelectedOWLObject(newClass);
        }
    }

    @Override
    public void createNewObject() {
        OWLEntityCreationSet<OWLClass> set = this.getOWLWorkspace().createOWLClass();
        if (set != null) {
            OWLClass newClass = set.getOWLEntity();
            this.getOWLModelManager().applyChanges(set.getOntologyChanges());
            this.getTree().setSelectedOWLObject(newClass);
        }
    }

    @Override
    public void createNewSibling() {
        OWLClass cls = (OWLClass)this.getTree().getSelectedOWLObject();
        if (cls == null) {
            return;
        }
        OWLEntityCreationSet<OWLClass> creationSet = this.getOWLWorkspace().createOWLClass();
        if (creationSet != null) {
            OWLObjectTreeNode parentNode = (OWLObjectTreeNode)this.getTree().getSelectionPath().getParentPath().getLastPathComponent();
            if (parentNode == null || parentNode.getOWLObject() == null) {
                return;
            }
            OWLClass parentCls = (OWLClass)parentNode.getOWLObject();
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.addAll(creationSet.getOntologyChanges());
            OWLModelManager mngr = this.getOWLModelManager();
            OWLDataFactory df = mngr.getOWLDataFactory();
            if (!df.getOWLThing().equals(parentCls)) {
                changes.add(new AddAxiom(mngr.getActiveOntology(), (OWLAxiom)df.getOWLSubClassOfAxiom((OWLClassExpression)creationSet.getOWLEntity(), (OWLClassExpression)parentCls)));
            }
            mngr.applyChanges(changes);
            this.getTree().setSelectedOWLObject(creationSet.getOWLEntity());
        }
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public Optional<OWLObject> getSelection() {
        return Optional.ofNullable(this.getSelectedEntity());
    }

    @Override
    public void disposeView() {
        super.disposeView();
    }
}

