/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.view.annotationproperty;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.swing.Icon;
import org.protege.editor.core.ui.menu.PopupMenuId;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.selection.SelectionDriver;
import org.protege.editor.owl.ui.action.AbstractDeleteEntityAction;
import org.protege.editor.owl.ui.action.AbstractOWLTreeAction;
import org.protege.editor.owl.ui.renderer.AddChildIcon;
import org.protege.editor.owl.ui.renderer.AddSiblingIcon;
import org.protege.editor.owl.ui.renderer.DeleteEntityIcon;
import org.protege.editor.owl.ui.renderer.OWLAnnotationPropertyIcon;
import org.protege.editor.owl.ui.renderer.OWLEntityIcon;
import org.protege.editor.owl.ui.view.AbstractOWLEntityHierarchyViewComponent;
import org.protege.editor.owl.ui.view.CreateNewChildTarget;
import org.protege.editor.owl.ui.view.CreateNewSiblingTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public class OWLAnnotationPropertyHierarchyViewComponent
extends AbstractOWLEntityHierarchyViewComponent<OWLAnnotationProperty>
implements CreateNewChildTarget,
CreateNewSiblingTarget,
SelectionDriver {
    @Override
    protected void performExtraInitialisation() throws Exception {
        this.addAction(new AbstractOWLTreeAction<OWLAnnotationProperty>("Add sub property", (Icon)new AddChildIcon(new OWLAnnotationPropertyIcon()), this.getTree().getSelectionModel()){

            public void actionPerformed(ActionEvent event) {
                OWLAnnotationPropertyHierarchyViewComponent.this.createNewChild();
            }

            @Override
            protected boolean canPerform(OWLAnnotationProperty prop) {
                return OWLAnnotationPropertyHierarchyViewComponent.this.canCreateNewChild();
            }
        }, "A", "A");
        this.addAction(new AbstractOWLTreeAction<OWLAnnotationProperty>("Add sibling property", (Icon)new AddSiblingIcon(new OWLAnnotationPropertyIcon()), this.getTree().getSelectionModel()){

            public void actionPerformed(ActionEvent event) {
                OWLAnnotationPropertyHierarchyViewComponent.this.createNewSibling();
            }

            @Override
            protected boolean canPerform(OWLAnnotationProperty cls) {
                return OWLAnnotationPropertyHierarchyViewComponent.this.canCreateNewSibling();
            }
        }, "A", "B");
        this.addAction(new DeleteAnnotationPropertyAction(), "B", "A");
        this.getTree().setPopupMenuId(new PopupMenuId("[AnnotationPropertyHierarchy]"));
    }

    @Override
    protected OWLObjectHierarchyProvider<OWLAnnotationProperty> getHierarchyProvider() {
        return this.getOWLModelManager().getOWLHierarchyManager().getOWLAnnotationPropertyHierarchyProvider();
    }

    @Override
    protected Optional<OWLObjectHierarchyProvider<OWLAnnotationProperty>> getInferredHierarchyProvider() {
        return Optional.empty();
    }

    @Override
    protected OWLObject updateView() {
        return this.updateView(this.getOWLWorkspace().getOWLSelectionModel().getLastSelectedAnnotationProperty());
    }

    @Override
    public List<OWLAnnotationProperty> find(String match) {
        return new ArrayList<OWLAnnotationProperty>(this.getOWLModelManager().getOWLEntityFinder().getMatchingOWLAnnotationProperties(match));
    }

    @Override
    public boolean canCreateNewChild() {
        return true;
    }

    @Override
    public void createNewChild() {
        ArrayList<Object> changes = new ArrayList<Object>();
        OWLEntityCreationSet<OWLAnnotationProperty> set = this.getOWLWorkspace().createOWLAnnotationProperty();
        changes.addAll(set.getOntologyChanges());
        OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
        OWLAnnotationProperty selProp = (OWLAnnotationProperty)this.getSelectedEntity();
        if (selProp != null) {
            OWLSubAnnotationPropertyOfAxiom ax = df.getOWLSubAnnotationPropertyOfAxiom(set.getOWLEntity(), selProp);
            changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
        }
        this.getOWLModelManager().applyChanges(changes);
        this.setGlobalSelection((OWLEntity)set.getOWLEntity());
    }

    @Override
    public boolean canCreateNewSibling() {
        return this.getSelectedEntity() != null;
    }

    @Override
    public void createNewSibling() {
        OWLAnnotationProperty property = (OWLAnnotationProperty)this.getTree().getSelectedOWLObject();
        if (property == null) {
            return;
        }
        OWLEntityCreationSet<OWLAnnotationProperty> creationSet = this.getOWLWorkspace().createOWLAnnotationProperty();
        if (creationSet != null) {
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.addAll(creationSet.getOntologyChanges());
            OWLModelManager mngr = this.getOWLModelManager();
            OWLDataFactory df = mngr.getOWLDataFactory();
            for (OWLAnnotationProperty par : this.getHierarchyProvider().getParents(property)) {
                OWLSubAnnotationPropertyOfAxiom ax = df.getOWLSubAnnotationPropertyOfAxiom(creationSet.getOWLEntity(), par);
                changes.add(new AddAxiom(mngr.getActiveOntology(), (OWLAxiom)ax));
            }
            mngr.applyChanges(changes);
            this.setGlobalSelection((OWLEntity)creationSet.getOWLEntity());
        }
    }

    @Override
    public Component asComponent() {
        return this;
    }

    @Override
    public Optional<OWLObject> getSelection() {
        return Optional.ofNullable(this.getSelectedEntity());
    }

    public class DeleteAnnotationPropertyAction
    extends AbstractDeleteEntityAction<OWLAnnotationProperty> {
        public DeleteAnnotationPropertyAction() {
            super("Delete selected properties", new DeleteEntityIcon(new OWLAnnotationPropertyIcon(OWLEntityIcon.FillType.HOLLOW)), OWLAnnotationPropertyHierarchyViewComponent.this.getOWLEditorKit(), OWLAnnotationPropertyHierarchyViewComponent.this.getHierarchyProvider(), new InternalOWLEntitySetProvider());
        }

        @Override
        protected String getPluralDescription() {
            return "properties";
        }
    }

    private class InternalOWLEntitySetProvider
    implements OWLEntitySetProvider<OWLAnnotationProperty> {
        private InternalOWLEntitySetProvider() {
        }

        public Set<OWLAnnotationProperty> getEntities() {
            return new HashSet<OWLAnnotationProperty>(OWLAnnotationPropertyHierarchyViewComponent.this.getTree().getSelectedOWLObjects());
        }
    }
}

