/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.swing.table.AbstractTableModel;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.search.SearchResult;
import org.protege.editor.owl.model.search.SearchResultComparator;
import org.protege.editor.owl.model.search.SearchResultSet;
import org.protege.editor.owl.model.util.OboUtilities;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObject;

public class SearchResultsTableModel
extends AbstractTableModel {
    public static final int DEFAULT_CATEGORY_SIZE_LIMIT = 10;
    private static final String FOUND_IN = "Found in";
    private static final String ENTITY = "Entity";
    private static final String OBO_ID = "Id";
    private static final String MATCH = "Match";
    private OWLEditorKit editorKit;
    private int categorySizeLimit = 10;
    private boolean showDeprecated = true;
    private List<ResultsTableModelRow> rows = new ArrayList<ResultsTableModelRow>();
    private boolean hasOboIdsInResults = false;

    public SearchResultsTableModel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    public void clear() {
        this.rows.clear();
        if (this.hasOboIdsInResults) {
            this.hasOboIdsInResults = false;
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public int getOboIdColumn() {
        if (this.hasOboIds()) {
            return 2;
        }
        return -1;
    }

    private boolean hasOboIds() {
        return this.rows.stream().map(ResultsTableModelRow::getSearchResult).filter(Objects::nonNull).map(SearchResult::getSubject).filter(subject -> subject instanceof OWLEntity).map(subject -> (OWLEntity)subject).map(OWLNamedObject::getIRI).anyMatch(OboUtilities::isOboIri);
    }

    public int getResultsColumn() {
        if (this.hasOboIds()) {
            return 3;
        }
        return 2;
    }

    public int getCategorySizeLimit() {
        return this.categorySizeLimit;
    }

    public void setCategorySizeLimit(int categorySizeLimit) {
        if (categorySizeLimit != this.categorySizeLimit) {
            this.categorySizeLimit = categorySizeLimit;
            this.fireTableDataChanged();
        }
    }

    public void setShowDeprecated(boolean showDeprecated) {
        if (showDeprecated != this.showDeprecated) {
            this.showDeprecated = showDeprecated;
            this.fireTableDataChanged();
        }
    }

    public void clearCategorySizeLimit() {
        if (this.categorySizeLimit != Integer.MAX_VALUE) {
            this.categorySizeLimit = Integer.MAX_VALUE;
            this.fireTableDataChanged();
        }
    }

    public void setResultList(Collection<SearchResult> resultList) {
        this.rows.clear();
        SearchResultSet resultSet = new SearchResultSet(resultList);
        for (String category : resultSet.getCategories()) {
            List<SearchResult> categoryResult = resultSet.getCategoryResults(category);
            Collections.sort(categoryResult, new SearchResultComparator(this.editorKit));
            int count = 0;
            int categoryResultsCount = resultSet.getCategoryResultsCount(category);
            for (SearchResult searchResult : categoryResult) {
                if (!this.showDeprecated && this.editorKit.getModelManager().isDeprecated(searchResult.getSubject())) continue;
                this.rows.add(new ResultsTableModelRow(searchResult, count, categoryResultsCount));
                if (++count != this.categorySizeLimit) continue;
                break;
            }
            if (categoryResultsCount <= this.categorySizeLimit) continue;
            this.rows.add(new PlaceHolderRow(categoryResultsCount));
        }
        boolean containsOboIds = this.hasOboIds();
        if (containsOboIds != this.hasOboIdsInResults) {
            this.hasOboIdsInResults = containsOboIds;
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    public ResultsTableModelRow getRow(int rowIndex) {
        return this.rows.get(rowIndex);
    }

    public SearchResult getSearchResult(int rowIndex) {
        ResultsTableModelRow row = this.rows.get(rowIndex);
        return row.searchResult;
    }

    @Override
    public String getColumnName(int column) {
        if (column == 0) {
            return FOUND_IN;
        }
        if (column == 1) {
            return ENTITY;
        }
        if (this.hasOboIds()) {
            if (column == 2) {
                return OBO_ID;
            }
            if (column == 3) {
                return MATCH;
            }
        } else if (column == 2) {
            return MATCH;
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.hasOboIds() ? 4 : 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ResultsTableModelRow row = this.rows.get(rowIndex);
        return row.getRenderableObject(columnIndex);
    }

    public boolean isFirstRowInCategory(int rowIndex) {
        return this.rows.get(rowIndex).isFirstRowInCategory();
    }

    private class PlaceHolderRow
    extends ResultsTableModelRow {
        private PlaceHolderRow(int categoryResultCount) {
            super(null, 0, categoryResultCount);
        }

        @Override
        public boolean isFirstRowInCategory() {
            return false;
        }

        @Override
        public Object getRenderableObject(int columnIndex) {
            if (columnIndex == 1) {
                return "    + " + (this.getCategoryResultCount() - SearchResultsTableModel.this.categorySizeLimit) + " more results...";
            }
            return "";
        }
    }

    private class ResultsTableModelRow {
        private SearchResult searchResult;
        private int categoryRowIndex;
        private int categoryResultCount;

        private ResultsTableModelRow(SearchResult searchResult, int categoryRowIndex, int categoryResultCount) {
            this.searchResult = searchResult;
            this.categoryRowIndex = categoryRowIndex;
            this.categoryResultCount = categoryResultCount;
        }

        @Nullable
        public SearchResult getSearchResult() {
            return this.searchResult;
        }

        public boolean isFirstRowInCategory() {
            return this.categoryRowIndex == 0;
        }

        public int getCategoryResultCount() {
            return this.categoryResultCount;
        }

        public Object getRenderableObject(int columnIndex) {
            if (columnIndex == 0) {
                return this.searchResult.getGroupDescription();
            }
            if (columnIndex == 1) {
                return this.searchResult.getSubject();
            }
            if (SearchResultsTableModel.this.hasOboIds()) {
                OWLObject subject;
                if (columnIndex == 2 && (subject = this.searchResult.getSubject()) instanceof OWLEntity) {
                    return OboUtilities.getOboIdFromIri(((OWLEntity)subject).getIRI()).orElse("");
                }
                if (columnIndex == 3) {
                    return this.searchResult.getSearchString();
                }
            } else if (columnIndex == 2) {
                return this.searchResult.getSearchString();
            }
            return "";
        }
    }
}

