/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.find.OWLEntityFinderPreferences;
import org.protege.editor.owl.model.search.SearchCategory;
import org.protege.editor.owl.ui.search.SearchOptionsChangedListener;
import org.semanticweb.owlapi.util.ProgressMonitor;

public class SearchOptionsPanel
extends JPanel {
    private final JCheckBox useRegexCheckBox;
    private final JCheckBox caseSensitive;
    private final JCheckBox wholeWordsCheckbox;
    private final JCheckBox ignoreWhiteSpaceCheckbox;
    private final JCheckBox showAllResultsCheckBox;
    private final List<SearchOptionsChangedListener> listeners = new ArrayList<SearchOptionsChangedListener>();
    private final JCheckBox searchInAnnotationValues;
    private final JCheckBox searchInLogicalAxioms;
    private final OWLEditorKit editorKit;
    private final JCheckBox searchInIRIs;
    private final JCheckBox showDeprecatedCheckbox;
    private final JProgressBar searchProgressBar;
    private final JLabel searchProgressLabel = new JLabel();
    private final Timer visibilityTimer = new Timer(200, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchOptionsPanel.this.searchProgressBar.setVisible(true);
            SearchOptionsPanel.this.searchProgressLabel.setVisible(true);
        }
    });

    public SearchOptionsPanel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        Box box = new Box(1);
        this.add((Component)box, "North");
        JPanel topPanel = new JPanel(new FlowLayout(0, 4, 0));
        box.add(topPanel);
        this.caseSensitive = new JCheckBox(new AbstractAction("Case sensitive"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityFinderPreferences.getInstance().setCaseSensitive(SearchOptionsPanel.this.caseSensitive.isSelected());
                SearchOptionsPanel.this.fireSearchRequestOptionChanged();
            }
        });
        topPanel.add(this.caseSensitive);
        this.wholeWordsCheckbox = new JCheckBox(new AbstractAction("Whole words"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityFinderPreferences.getInstance().setWholeWords(SearchOptionsPanel.this.wholeWordsCheckbox.isSelected());
                SearchOptionsPanel.this.fireSearchRequestOptionChanged();
            }
        });
        topPanel.add(this.wholeWordsCheckbox);
        this.ignoreWhiteSpaceCheckbox = new JCheckBox(new AbstractAction("Ignore white space"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityFinderPreferences.getInstance().setIgnoreWhiteSpace(SearchOptionsPanel.this.ignoreWhiteSpaceCheckbox.isSelected());
                SearchOptionsPanel.this.fireSearchRequestOptionChanged();
            }
        });
        topPanel.add(this.ignoreWhiteSpaceCheckbox);
        this.useRegexCheckBox = new JCheckBox(new AbstractAction("Regular expression"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityFinderPreferences.getInstance().setUseRegularExpressions(SearchOptionsPanel.this.useRegexCheckBox.isSelected());
                SearchOptionsPanel.this.fireSearchRequestOptionChanged();
            }
        });
        topPanel.add(this.useRegexCheckBox);
        this.showAllResultsCheckBox = new JCheckBox(new AbstractAction("Show all results"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchOptionsPanel.this.fireSearchResultsPresentationOptionChanged();
            }
        });
        topPanel.add(this.showAllResultsCheckBox);
        this.showDeprecatedCheckbox = new JCheckBox(new AbstractAction("Show deprecated"){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLEntityFinderPreferences.getInstance().setShowDeprecated(SearchOptionsPanel.this.showDeprecatedCheckbox.isSelected());
                SearchOptionsPanel.this.fireSearchResultsPresentationOptionChanged();
            }
        });
        topPanel.add(this.showDeprecatedCheckbox);
        box.add(Box.createVerticalStrut(5));
        JPanel bottomPanel = new JPanel(new FlowLayout(0, 4, 0));
        box.add(bottomPanel);
        this.searchInIRIs = new JCheckBox(new AbstractAction("Search in IRIs"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchOptionsPanel.this.handleSearchTypeChanged();
            }
        });
        this.searchInIRIs.setSelected(editorKit.getSearchManager().isSearchType(SearchCategory.IRI));
        bottomPanel.add(this.searchInIRIs);
        this.searchInAnnotationValues = new JCheckBox(new AbstractAction("Search in annotation values"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchOptionsPanel.this.handleSearchTypeChanged();
            }
        });
        this.searchInAnnotationValues.setSelected(editorKit.getSearchManager().isSearchType(SearchCategory.ANNOTATION_VALUE));
        bottomPanel.add(this.searchInAnnotationValues);
        this.searchInLogicalAxioms = new JCheckBox(new AbstractAction("Search in logical axioms"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchOptionsPanel.this.handleSearchTypeChanged();
            }
        });
        this.searchInLogicalAxioms.setSelected(editorKit.getSearchManager().isSearchType(SearchCategory.LOGICAL_AXIOM));
        bottomPanel.add(this.searchInLogicalAxioms);
        bottomPanel.add(Box.createHorizontalStrut(10));
        this.searchProgressBar = new JProgressBar();
        this.searchProgressBar.putClientProperty("JComponent.sizeVariant", "small");
        this.searchProgressLabel.setFont(new Font("verdana", 0, 9));
        this.searchProgressLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        bottomPanel.add(this.searchProgressBar);
        bottomPanel.add(this.searchProgressLabel);
        editorKit.getSearchManager().addProgressMonitor(new ProgressMonitor(){

            public void setStarted() {
                SearchOptionsPanel.this.searchProgressBar.setValue(0);
                SearchOptionsPanel.this.visibilityTimer.restart();
            }

            public void setSize(long l) {
                SearchOptionsPanel.this.searchProgressBar.setMinimum(0);
                SearchOptionsPanel.this.searchProgressBar.setMaximum((int)l);
            }

            public void setProgress(long l) {
                SearchOptionsPanel.this.searchProgressBar.setValue((int)l);
            }

            public void setMessage(String s) {
                SearchOptionsPanel.this.searchProgressBar.setToolTipText(s);
                SearchOptionsPanel.this.searchProgressLabel.setText(s);
            }

            public void setIndeterminate(boolean b) {
                SearchOptionsPanel.this.searchProgressBar.setIndeterminate(b);
            }

            public void setFinished() {
                SearchOptionsPanel.this.visibilityTimer.stop();
                SearchOptionsPanel.this.searchProgressBar.setVisible(false);
                SearchOptionsPanel.this.searchProgressLabel.setVisible(false);
            }

            public boolean isCancelled() {
                return false;
            }
        });
        this.refresh();
    }

    private void handleSearchTypeChanged() {
        this.editorKit.getSearchManager().setCategories(this.getSearchTypes());
        this.fireSearchRequestOptionChanged();
    }

    public Collection<SearchCategory> getSearchTypes() {
        HashSet<SearchCategory> result = new HashSet<SearchCategory>();
        result.add(SearchCategory.DISPLAY_NAME);
        if (this.searchInIRIs.isSelected()) {
            result.add(SearchCategory.IRI);
        }
        if (this.searchInAnnotationValues.isSelected()) {
            result.add(SearchCategory.ANNOTATION_VALUE);
        }
        if (this.searchInLogicalAxioms.isSelected()) {
            result.add(SearchCategory.LOGICAL_AXIOM);
        }
        return result;
    }

    public void addListener(SearchOptionsChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(SearchOptionsChangedListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isShowAllResults() {
        return this.showAllResultsCheckBox.isSelected();
    }

    public boolean isShowDeprecated() {
        return this.showDeprecatedCheckbox.isSelected();
    }

    private void fireSearchRequestOptionChanged() {
        for (SearchOptionsChangedListener listener : new ArrayList<SearchOptionsChangedListener>(this.listeners)) {
            listener.searchRequestOptionChanged();
        }
    }

    private void fireSearchResultsPresentationOptionChanged() {
        for (SearchOptionsChangedListener listener : new ArrayList<SearchOptionsChangedListener>(this.listeners)) {
            listener.searchResultsPresentationOptionChanged();
        }
    }

    public void refresh() {
        OWLEntityFinderPreferences prefs = OWLEntityFinderPreferences.getInstance();
        this.caseSensitive.setSelected(prefs.isCaseSensitive());
        this.useRegexCheckBox.setSelected(prefs.isUseRegularExpressions());
        this.wholeWordsCheckbox.setSelected(prefs.isWholeWords());
        this.ignoreWhiteSpaceCheckbox.setSelected(prefs.isIgnoreWhiteSpace());
        this.showDeprecatedCheckbox.setSelected(prefs.isShowDeprecated());
    }
}

