/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.protege.editor.owl.ui.renderer.context.NullClassSatisfiabilityChecker;
import org.protege.editor.owl.ui.renderer.context.NullDataPropertySatisfiabilityChecker;
import org.protege.editor.owl.ui.renderer.context.NullDeprecatedObjectChecker;
import org.protege.editor.owl.ui.renderer.context.NullLinkFactory;
import org.protege.editor.owl.ui.renderer.context.NullObjectPropertySatisfiabilityChecker;
import org.protege.editor.owl.ui.renderer.context.OWLObjectRenderingContext;
import org.protege.editor.owl.ui.renderer.styledstring.BracketingStrategy;
import org.protege.editor.owl.ui.renderer.styledstring.ComplexClassExpressionBracketingStrategy;
import org.protege.editor.owl.ui.renderer.styledstring.ForegroundAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.NullBracketingStrategy;
import org.protege.editor.owl.ui.renderer.styledstring.ProtegeStyles;
import org.protege.editor.owl.ui.renderer.styledstring.Style;
import org.protege.editor.owl.ui.renderer.styledstring.StyleAttribute;
import org.protege.editor.owl.ui.renderer.styledstring.StyledString;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLHasValueRestriction;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class OWLObjectStyledStringRenderer {
    public static final Style BLANK_STYLE = new Style(new StyleAttribute[0]);
    private OWLObjectRenderingContext renderingContext;

    public OWLObjectStyledStringRenderer() {
        this(new OWLObjectRenderingContext(new NullDeprecatedObjectChecker(), new NullClassSatisfiabilityChecker(), new NullObjectPropertySatisfiabilityChecker(), new NullDataPropertySatisfiabilityChecker(), new NullLinkFactory(), (ShortFormProvider)new SimpleShortFormProvider(), new OntologyIRIShortFormProvider()));
    }

    public OWLObjectStyledStringRenderer(OWLObjectRenderingContext renderingContext) {
        this.renderingContext = renderingContext;
    }

    public StyledString getRendering(OWLObject owlObject) {
        ObjectRenderer renderer = new ObjectRenderer();
        owlObject.accept((OWLObjectVisitor)renderer);
        return renderer.builder.build();
    }

    private class ObjectRenderer
    implements OWLObjectVisitor {
        public static final String COMMA_SEPARATOR = ", ";
        private StyledString.Builder builder = new StyledString.Builder();

        private ObjectRenderer() {
        }

        private void renderKeywordWithSpaces(ManchesterOWLSyntax keyword) {
            this.builder.appendSpace();
            this.renderKeyword(keyword);
            this.builder.appendSpace();
        }

        private void renderKeyword(ManchesterOWLSyntax keyword) {
            Style style = ProtegeStyles.getStyles().getKeywordStyle(keyword);
            this.builder.appendWithStyle(keyword.toString(), style);
        }

        private void renderSpace() {
            this.builder.appendSpace();
        }

        private void renderColonSpace() {
            this.builder.append(": ");
        }

        private void renderKeywordColonSpace(ManchesterOWLSyntax keyword) {
            this.renderKeyword(keyword);
            this.renderColonSpace();
        }

        private void renderCollection(OWLObject parentObject, Collection<? extends OWLObject> collection, ManchesterOWLSyntax separator, BracketingStrategy bracketingStrategy) {
            Iterator<? extends OWLObject> it = collection.iterator();
            while (it.hasNext()) {
                OWLObject o = it.next();
                boolean bracket = bracketingStrategy.shouldBracket(parentObject, o);
                if (bracket) {
                    this.builder.append("(");
                }
                o.accept((OWLObjectVisitor)this);
                if (bracket) {
                    this.builder.append(")");
                }
                if (!it.hasNext()) continue;
                this.renderKeywordWithSpaces(separator);
            }
        }

        private void renderCollection(OWLObject parentObject, Collection<? extends OWLObject> collection, String separator, BracketingStrategy bracketingStrategy) {
            Iterator<? extends OWLObject> it = collection.iterator();
            while (it.hasNext()) {
                OWLObject o = it.next();
                boolean bracket = bracketingStrategy.shouldBracket(parentObject, o);
                if (bracket) {
                    this.builder.append("(");
                }
                o.accept((OWLObjectVisitor)this);
                if (bracket) {
                    this.builder.append(")");
                }
                if (!it.hasNext()) continue;
                this.builder.append(separator);
            }
        }

        public void visit(@Nonnull OWLAnnotation annotation) {
            int propStart = this.builder.mark();
            annotation.getProperty().accept((OWLObjectVisitor)this);
            int propEnd = this.builder.mark();
            this.builder.applyStyle(propStart, propEnd, ProtegeStyles.getStyles().getAnnotationPropertyStyle());
            this.renderSpace();
            if (annotation.getValue() instanceof OWLLiteral) {
                OWLLiteral literal = (OWLLiteral)annotation.getValue();
                Style langStyle = ProtegeStyles.getStyles().getAnnotationLangStyle();
                if (literal.isRDFPlainLiteral()) {
                    if (!literal.getLang().isEmpty()) {
                        this.builder.appendWithStyle("[language: ", langStyle);
                        this.builder.appendWithStyle(literal.getLang(), langStyle);
                        this.builder.appendWithStyle("] ", langStyle);
                    }
                } else {
                    this.builder.appendWithStyle("[type: ", langStyle);
                    int dtStart = this.builder.mark();
                    literal.getDatatype().accept((OWLObjectVisitor)this);
                    int dtEnd = this.builder.mark();
                    this.builder.applyStyle(dtStart, dtEnd, langStyle);
                    this.builder.appendWithStyle("] ", langStyle);
                }
                this.builder.append(literal.getLiteral());
            } else {
                annotation.getValue().accept((OWLObjectVisitor)this);
            }
        }

        public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
            axiom.getSubClass().accept((OWLObjectVisitor)this);
            this.renderSpace();
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.SUBCLASS_OF);
            this.renderSpace();
            axiom.getSuperClass().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLNegativeObjectPropertyAssertionAxiom axiom) {
        }

        public void visit(@Nonnull OWLAsymmetricObjectPropertyAxiom axiom) {
            this.renderKeywordColonSpace(ManchesterOWLSyntax.ASYMMETRIC);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLReflexiveObjectPropertyAxiom axiom) {
            this.renderKeywordColonSpace(ManchesterOWLSyntax.REFLEXIVE);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        }

        private <O> List<O> toList(Collection<O> collection) {
            if (collection instanceof List) {
                return (List)collection;
            }
            return new ArrayList<O>(collection);
        }

        private void renderBinaryOrNaryList(Collection<? extends OWLObject> collection, ManchesterOWLSyntax binaryKeyword, ManchesterOWLSyntax naryKeyword, String separator) {
            if (collection.size() == 2) {
                List<? extends OWLObject> list = this.toList(collection);
                list.get(0).accept((OWLObjectVisitor)this);
                this.renderKeywordWithSpaces(binaryKeyword);
                list.get(1).accept((OWLObjectVisitor)this);
            } else {
                this.renderKeywordColonSpace(naryKeyword);
                Iterator<? extends OWLObject> it = collection.iterator();
                while (it.hasNext()) {
                    OWLObject o = it.next();
                    o.accept((OWLObjectVisitor)this);
                    if (!it.hasNext()) continue;
                    this.builder.append(separator);
                }
            }
        }

        public void visit(@Nonnull OWLDisjointClassesAxiom axiom) {
            this.renderBinaryOrNaryList(axiom.getClassExpressionsAsList(), ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DISJOINT_CLASSES, COMMA_SEPARATOR);
        }

        private void renderDomainAxiom(OWLPropertyDomainAxiom<?> axiom) {
            axiom.getProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.DOMAIN);
            axiom.getDomain().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLDataPropertyDomainAxiom axiom) {
            this.renderDomainAxiom((OWLPropertyDomainAxiom<?>)axiom);
        }

        public void visit(@Nonnull OWLObjectPropertyDomainAxiom axiom) {
            this.renderDomainAxiom((OWLPropertyDomainAxiom<?>)axiom);
        }

        public void visit(@Nonnull OWLEquivalentObjectPropertiesAxiom axiom) {
            this.renderBinaryOrNaryList(axiom.getProperties(), ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, COMMA_SEPARATOR);
        }

        public void visit(@Nonnull OWLNegativeDataPropertyAssertionAxiom axiom) {
        }

        public void visit(@Nonnull OWLDifferentIndividualsAxiom axiom) {
            this.renderBinaryOrNaryList(axiom.getIndividuals(), ManchesterOWLSyntax.SAME_AS, ManchesterOWLSyntax.SAME_INDIVIDUAL, COMMA_SEPARATOR);
        }

        public void visit(@Nonnull OWLDisjointDataPropertiesAxiom axiom) {
            this.renderBinaryOrNaryList(axiom.getProperties(), ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DISJOINT_PROPERTIES, COMMA_SEPARATOR);
        }

        public void visit(@Nonnull OWLDisjointObjectPropertiesAxiom axiom) {
            this.renderBinaryOrNaryList(axiom.getProperties(), ManchesterOWLSyntax.DISJOINT_WITH, ManchesterOWLSyntax.DISJOINT_PROPERTIES, COMMA_SEPARATOR);
        }

        private void renderRangeAxiom(OWLPropertyRangeAxiom<?, ?> axiom) {
            axiom.getProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.RANGE);
            axiom.getRange().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLObjectPropertyRangeAxiom axiom) {
            this.renderRangeAxiom((OWLPropertyRangeAxiom<?, ?>)axiom);
        }

        public void visit(@Nonnull OWLObjectPropertyAssertionAxiom axiom) {
            this.renderPropertyAssertion((OWLPropertyAssertionAxiom<?, ?>)axiom);
        }

        public void visit(@Nonnull OWLFunctionalObjectPropertyAxiom axiom) {
            this.renderKeywordColonSpace(ManchesterOWLSyntax.FUNCTIONAL);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLSubObjectPropertyOfAxiom axiom) {
            ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.SUB_PROPERTY_OF);
            ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLDisjointUnionAxiom axiom) {
            axiom.getOWLClass().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.DISJOINT_UNION_OF);
            this.renderCollection((OWLObject)axiom, (Collection<? extends OWLObject>)axiom.getClassExpressions(), COMMA_SEPARATOR, (BracketingStrategy)ComplexClassExpressionBracketingStrategy.get());
        }

        public void visit(@Nonnull OWLDeclarationAxiom axiom) {
            axiom.getEntity().accept(new OWLEntityVisitor(){

                public void visit(@Nonnull OWLClass owlClass) {
                    ObjectRenderer.this.renderKeywordColonSpace(ManchesterOWLSyntax.CLASS);
                }

                public void visit(@Nonnull OWLObjectProperty property) {
                    ObjectRenderer.this.renderKeywordColonSpace(ManchesterOWLSyntax.OBJECT_PROPERTY);
                }

                public void visit(@Nonnull OWLDataProperty dataProperty) {
                    ObjectRenderer.this.renderKeywordColonSpace(ManchesterOWLSyntax.DATA_PROPERTY);
                }

                public void visit(@Nonnull OWLNamedIndividual individual) {
                    ObjectRenderer.this.renderKeywordColonSpace(ManchesterOWLSyntax.INDIVIDUAL);
                }

                public void visit(@Nonnull OWLDatatype owlDatatype) {
                    ObjectRenderer.this.renderKeywordColonSpace(ManchesterOWLSyntax.DATATYPE);
                }

                public void visit(@Nonnull OWLAnnotationProperty property) {
                    ObjectRenderer.this.renderKeywordColonSpace(ManchesterOWLSyntax.ANNOTATION_PROPERTY);
                }
            });
        }

        private void renderPropertyAssertion(OWLPropertyAssertionAxiom<?, ?> axiom) {
            axiom.getSubject().accept((OWLObjectVisitor)this);
            this.renderSpace();
            axiom.getProperty().accept((OWLObjectVisitor)this);
            this.renderSpace();
            axiom.getObject().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLAnnotationAssertionAxiom axiom) {
            if (axiom.getSubject() instanceof IRI) {
                this.builder.append(OWLObjectStyledStringRenderer.this.renderingContext.getIriShortFormProvider().getShortForm((IRI)axiom.getSubject()));
            } else {
                axiom.getSubject().accept((OWLObjectVisitor)this);
            }
            this.renderSpace();
            axiom.getAnnotation().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLSymmetricObjectPropertyAxiom axiom) {
            this.renderKeywordColonSpace(ManchesterOWLSyntax.SYMMETRIC);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLDataPropertyRangeAxiom axiom) {
            this.renderRangeAxiom((OWLPropertyRangeAxiom<?, ?>)axiom);
        }

        public void visit(@Nonnull OWLFunctionalDataPropertyAxiom axiom) {
            this.renderKeywordColonSpace(ManchesterOWLSyntax.FUNCTIONAL);
            ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLEquivalentDataPropertiesAxiom axiom) {
            this.renderBinaryOrNaryList(axiom.getProperties(), ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.EQUIVALENT_PROPERTIES, COMMA_SEPARATOR);
        }

        public void visit(@Nonnull OWLClassAssertionAxiom axiom) {
            axiom.getIndividual().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.TYPE);
            axiom.getClassExpression().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLEquivalentClassesAxiom axiom) {
            this.renderBinaryOrNaryList(axiom.getClassExpressions(), ManchesterOWLSyntax.EQUIVALENT_TO, ManchesterOWLSyntax.EQUIVALENT_CLASSES, COMMA_SEPARATOR);
        }

        public void visit(@Nonnull OWLDataPropertyAssertionAxiom axiom) {
            this.renderPropertyAssertion((OWLPropertyAssertionAxiom<?, ?>)axiom);
        }

        public void visit(@Nonnull OWLTransitiveObjectPropertyAxiom axiom) {
            this.renderKeywordColonSpace(ManchesterOWLSyntax.TRANSITIVE);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLIrreflexiveObjectPropertyAxiom axiom) {
            this.renderKeywordColonSpace(ManchesterOWLSyntax.IRREFLEXIVE);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLSubDataPropertyOfAxiom axiom) {
            ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.SUB_PROPERTY_OF);
            ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLInverseFunctionalObjectPropertyAxiom axiom) {
            this.renderKeywordColonSpace(ManchesterOWLSyntax.INVERSE_FUNCTIONAL);
            ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLSameIndividualAxiom axiom) {
            this.renderBinaryOrNaryList(axiom.getIndividuals(), ManchesterOWLSyntax.SAME_AS, ManchesterOWLSyntax.SAME_INDIVIDUAL, COMMA_SEPARATOR);
        }

        public void visit(@Nonnull OWLSubPropertyChainOfAxiom axiom) {
            this.renderCollection((OWLObject)axiom, (Collection<? extends OWLObject>)axiom.getPropertyChain(), " o ", (BracketingStrategy)NullBracketingStrategy.get());
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.SUB_PROPERTY_OF);
            axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLInverseObjectPropertiesAxiom axiom) {
            axiom.getFirstProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.INVERSE_OF);
            axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLHasKeyAxiom axiom) {
        }

        public void visit(@Nonnull OWLDatatypeDefinitionAxiom axiom) {
        }

        public void visit(@Nonnull SWRLRule swrlRule) {
            this.renderCollection((OWLObject)swrlRule, (Collection<? extends OWLObject>)swrlRule.getBody(), COMMA_SEPARATOR, (BracketingStrategy)NullBracketingStrategy.get());
            this.builder.append(" -> ");
            this.renderCollection((OWLObject)swrlRule, (Collection<? extends OWLObject>)swrlRule.getHead(), COMMA_SEPARATOR, (BracketingStrategy)NullBracketingStrategy.get());
        }

        public void visit(@Nonnull OWLSubAnnotationPropertyOfAxiom axiom) {
            axiom.getSubProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.SUB_PROPERTY_OF);
            axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLAnnotationPropertyDomainAxiom axiom) {
            axiom.getProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.DOMAIN);
            axiom.getDomain().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLAnnotationPropertyRangeAxiom axiom) {
            axiom.getProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.RANGE);
            axiom.getRange().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull IRI iri) {
            this.builder.append(iri.toQuotedString());
        }

        public void visit(@Nonnull OWLAnonymousIndividual individual) {
            this.builder.append(individual.getID().getID());
        }

        private void renderEntity(OWLEntity entity) {
            ShortFormProvider sfp = OWLObjectStyledStringRenderer.this.renderingContext.getShortFormProvider();
            String rendering = sfp.getShortForm(entity);
            int renderingStart = this.builder.mark();
            this.builder.append(rendering);
            int renderingEnd = this.builder.mark();
            Style style = new Style(ForegroundAttribute.get(Color.BLACK));
            if (OWLObjectStyledStringRenderer.this.renderingContext.getDeprecatedObjectChecker().isDeprecated(entity)) {
                style = style.append(ProtegeStyles.getStyles().getDeprecatedEntityStyle());
            }
            if (entity.isOWLClass() && !OWLObjectStyledStringRenderer.this.renderingContext.getClassSatisfiabilityChecker().isSatisfiable(entity.asOWLClass())) {
                style = style.append(ProtegeStyles.getStyles().getUnsatisfiableClassStyle());
            }
            this.builder.applyStyle(renderingStart, renderingEnd, style);
        }

        public void visit(@Nonnull OWLClass owlClass) {
            this.renderEntity((OWLEntity)owlClass);
        }

        public void visit(@Nonnull OWLObjectIntersectionOf owlObjectIntersectionOf) {
            this.renderCollection((OWLObject)owlObjectIntersectionOf, (Collection<? extends OWLObject>)owlObjectIntersectionOf.getOperands(), ManchesterOWLSyntax.AND, (BracketingStrategy)ComplexClassExpressionBracketingStrategy.get());
        }

        public void visit(@Nonnull OWLObjectUnionOf owlObjectUnionOf) {
            this.renderCollection((OWLObject)owlObjectUnionOf, (Collection<? extends OWLObject>)owlObjectUnionOf.getOperands(), ManchesterOWLSyntax.OR, (BracketingStrategy)ComplexClassExpressionBracketingStrategy.get());
        }

        public void visit(@Nonnull OWLObjectComplementOf owlObjectComplementOf) {
            this.renderKeyword(ManchesterOWLSyntax.NOT);
            this.renderSpace();
            owlObjectComplementOf.getOperand().accept((OWLObjectVisitor)this);
        }

        private boolean isAtomic(OWLObject object) {
            return object instanceof OWLEntity || object instanceof OWLLiteral || object instanceof OWLObjectOneOf || object instanceof OWLDataOneOf;
        }

        private void renderRestrictionFiller(OWLObject filler) {
            if (!this.isAtomic(filler)) {
                this.builder.append("(");
                filler.accept((OWLObjectVisitor)this);
                this.builder.append(")");
            } else {
                filler.accept((OWLObjectVisitor)this);
            }
        }

        private void renderQuantifiedRestriction(OWLQuantifiedRestriction restriction, ManchesterOWLSyntax keyword) {
            restriction.getProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(keyword);
            this.renderRestrictionFiller((OWLObject)restriction.getFiller());
        }

        public void visit(@Nonnull OWLObjectSomeValuesFrom owlObjectSomeValuesFrom) {
            this.renderQuantifiedRestriction((OWLQuantifiedRestriction)owlObjectSomeValuesFrom, ManchesterOWLSyntax.SOME);
        }

        public void visit(@Nonnull OWLObjectAllValuesFrom owlObjectAllValuesFrom) {
            this.renderQuantifiedRestriction((OWLQuantifiedRestriction)owlObjectAllValuesFrom, ManchesterOWLSyntax.ONLY);
        }

        private void renderHasValueRestriction(OWLHasValueRestriction<?> restriction) {
            restriction.getProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(ManchesterOWLSyntax.VALUE);
            restriction.getValue().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLObjectHasValue owlObjectHasValue) {
            this.renderHasValueRestriction((OWLHasValueRestriction<?>)owlObjectHasValue);
        }

        private void renderCardinalityRestriction(OWLCardinalityRestriction<?> restriction, ManchesterOWLSyntax keyword) {
            restriction.getProperty().accept((OWLObjectVisitor)this);
            this.renderKeywordWithSpaces(keyword);
            this.builder.append(restriction.getCardinality());
            this.renderSpace();
            this.renderRestrictionFiller((OWLObject)restriction.getFiller());
        }

        public void visit(@Nonnull OWLObjectMinCardinality owlObjectMinCardinality) {
            this.renderCardinalityRestriction((OWLCardinalityRestriction<?>)owlObjectMinCardinality, ManchesterOWLSyntax.MIN);
        }

        public void visit(@Nonnull OWLObjectExactCardinality owlObjectExactCardinality) {
            this.renderCardinalityRestriction((OWLCardinalityRestriction<?>)owlObjectExactCardinality, ManchesterOWLSyntax.EXACTLY);
        }

        public void visit(@Nonnull OWLObjectMaxCardinality owlObjectMaxCardinality) {
            this.renderCardinalityRestriction((OWLCardinalityRestriction<?>)owlObjectMaxCardinality, ManchesterOWLSyntax.MAX);
        }

        public void visit(@Nonnull OWLObjectHasSelf owlObjectHasSelf) {
            owlObjectHasSelf.getProperty().accept((OWLObjectVisitor)this);
            this.renderSpace();
            this.renderKeyword(ManchesterOWLSyntax.SELF);
        }

        public void visit(@Nonnull OWLObjectOneOf owlObjectOneOf) {
            this.builder.append("{");
            this.renderCollection((OWLObject)owlObjectOneOf, (Collection<? extends OWLObject>)owlObjectOneOf.getIndividuals(), COMMA_SEPARATOR, (BracketingStrategy)NullBracketingStrategy.get());
            this.builder.append("}");
        }

        public void visit(@Nonnull OWLDataSomeValuesFrom owlDataSomeValuesFrom) {
            this.renderQuantifiedRestriction((OWLQuantifiedRestriction)owlDataSomeValuesFrom, ManchesterOWLSyntax.SOME);
        }

        public void visit(@Nonnull OWLDataAllValuesFrom owlDataAllValuesFrom) {
            this.renderQuantifiedRestriction((OWLQuantifiedRestriction)owlDataAllValuesFrom, ManchesterOWLSyntax.ONLY);
        }

        public void visit(@Nonnull OWLDataHasValue owlDataHasValue) {
            this.renderHasValueRestriction((OWLHasValueRestriction<?>)owlDataHasValue);
        }

        public void visit(@Nonnull OWLDataMinCardinality owlDataMinCardinality) {
            this.renderCardinalityRestriction((OWLCardinalityRestriction<?>)owlDataMinCardinality, ManchesterOWLSyntax.MIN);
        }

        public void visit(@Nonnull OWLDataExactCardinality owlDataExactCardinality) {
            this.renderCardinalityRestriction((OWLCardinalityRestriction<?>)owlDataExactCardinality, ManchesterOWLSyntax.EXACTLY);
        }

        public void visit(@Nonnull OWLDataMaxCardinality owlDataMaxCardinality) {
            this.renderCardinalityRestriction((OWLCardinalityRestriction<?>)owlDataMaxCardinality, ManchesterOWLSyntax.MAX);
        }

        public void visit(@Nonnull OWLDatatype owlDatatype) {
            this.renderEntity((OWLEntity)owlDatatype);
        }

        public void visit(@Nonnull OWLDataComplementOf owlDataComplementOf) {
            this.renderKeyword(ManchesterOWLSyntax.NOT);
            this.renderSpace();
            owlDataComplementOf.getDataRange().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLDataOneOf owlDataOneOf) {
            this.builder.append("{");
            this.renderCollection((OWLObject)owlDataOneOf, (Collection<? extends OWLObject>)owlDataOneOf.getValues(), COMMA_SEPARATOR, (BracketingStrategy)NullBracketingStrategy.get());
            this.builder.append("}");
        }

        public void visit(@Nonnull OWLDataIntersectionOf owlDataIntersectionOf) {
            this.renderCollection((OWLObject)owlDataIntersectionOf, (Collection<? extends OWLObject>)owlDataIntersectionOf.getOperands(), ManchesterOWLSyntax.AND, (BracketingStrategy)NullBracketingStrategy.get());
        }

        public void visit(@Nonnull OWLDataUnionOf owlDataUnionOf) {
            this.renderCollection((OWLObject)owlDataUnionOf, (Collection<? extends OWLObject>)owlDataUnionOf.getOperands(), ManchesterOWLSyntax.OR, (BracketingStrategy)NullBracketingStrategy.get());
        }

        public void visit(@Nonnull OWLDatatypeRestriction owlDatatypeRestriction) {
            owlDatatypeRestriction.getDatatype().accept((OWLObjectVisitor)this);
            this.renderSpace();
            this.builder.append("[");
            this.renderCollection((OWLObject)owlDatatypeRestriction, (Collection<? extends OWLObject>)owlDatatypeRestriction.getFacetRestrictions(), ManchesterOWLSyntax.COMMA, (BracketingStrategy)NullBracketingStrategy.get());
            this.builder.append("]");
        }

        public void visit(@Nonnull OWLLiteral owlLiteral) {
            if (owlLiteral.isBoolean()) {
                this.builder.append(owlLiteral.getLiteral());
            } else if (owlLiteral.isDouble()) {
                this.builder.append(owlLiteral.getLiteral());
            } else if (owlLiteral.isFloat()) {
                this.builder.append(owlLiteral.getLiteral());
            } else if (owlLiteral.isInteger()) {
                this.builder.append(owlLiteral.getLiteral());
            } else {
                this.builder.append("\"");
                this.builder.append(owlLiteral.getLiteral());
                this.builder.append("\"^^");
                owlLiteral.getDatatype().accept((OWLObjectVisitor)this);
            }
        }

        public void visit(@Nonnull OWLFacetRestriction owlFacetRestriction) {
            this.builder.append(owlFacetRestriction.getFacet().getPrefixedName());
            this.renderSpace();
            owlFacetRestriction.getFacetValue().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLNamedIndividual individual) {
            this.renderEntity((OWLEntity)individual);
        }

        public void visit(@Nonnull OWLAnnotationProperty property) {
            this.renderEntity((OWLEntity)property);
        }

        public void visit(@Nonnull OWLOntology owlOntology) {
            OntologyIRIShortFormProvider ontSfp = OWLObjectStyledStringRenderer.this.renderingContext.getOntologyIRIShortFormProvider();
            String ontShortForm = ontSfp.getShortForm(owlOntology);
            this.builder.append(ontShortForm);
            this.builder.appendSpace();
            OWLOntologyID id = owlOntology.getOntologyID();
            if (!id.isAnonymous()) {
                this.builder.appendWithStyle(((IRI)id.getOntologyIRI().get()).toQuotedString(), Style.getForeground(Color.DARK_GRAY));
                if (id.getVersionIRI().isPresent()) {
                    this.builder.appendSpace();
                    this.builder.appendWithStyle(((IRI)id.getVersionIRI().get()).toQuotedString(), Style.getForeground(Color.GRAY));
                }
            }
        }

        public void visit(@Nonnull OWLObjectProperty property) {
            this.renderEntity((OWLEntity)property);
        }

        public void visit(@Nonnull OWLObjectInverseOf owlObjectInverseOf) {
            this.renderKeyword(ManchesterOWLSyntax.INVERSE_OF);
            this.renderSpace();
            owlObjectInverseOf.getInverse().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull OWLDataProperty dataProperty) {
            this.renderEntity((OWLEntity)dataProperty);
        }

        private void renderSWRLAtom(SWRLAtom atom, OWLObject predicate) {
            predicate.accept((OWLObjectVisitor)this);
            this.builder.append("(");
            this.renderCollection((OWLObject)atom, (Collection<? extends OWLObject>)atom.getAllArguments(), COMMA_SEPARATOR, (BracketingStrategy)NullBracketingStrategy.get());
            this.builder.append(")");
        }

        public void visit(@Nonnull SWRLClassAtom swrlClassAtom) {
            this.renderSWRLAtom((SWRLAtom)swrlClassAtom, (OWLObject)swrlClassAtom.getPredicate());
        }

        public void visit(@Nonnull SWRLDataRangeAtom swrlDataRangeAtom) {
            this.renderSWRLAtom((SWRLAtom)swrlDataRangeAtom, (OWLObject)swrlDataRangeAtom.getPredicate());
        }

        public void visit(@Nonnull SWRLObjectPropertyAtom swrlObjectPropertyAtom) {
            this.renderSWRLAtom((SWRLAtom)swrlObjectPropertyAtom, (OWLObject)swrlObjectPropertyAtom.getPredicate());
        }

        public void visit(@Nonnull SWRLDataPropertyAtom swrlDataPropertyAtom) {
            this.renderSWRLAtom((SWRLAtom)swrlDataPropertyAtom, (OWLObject)swrlDataPropertyAtom.getPredicate());
        }

        public void visit(@Nonnull SWRLBuiltInAtom atom) {
            atom.getPredicate().accept((OWLObjectVisitor)this);
            this.builder.append("(");
            this.renderCollection((OWLObject)atom, (Collection<? extends OWLObject>)atom.getAllArguments(), COMMA_SEPARATOR, (BracketingStrategy)NullBracketingStrategy.get());
            this.builder.append(")");
        }

        public void visit(@Nonnull SWRLVariable swrlVariable) {
            this.builder.append("?");
            this.builder.append((String)swrlVariable.getIRI().getRemainder().or((Object)swrlVariable.getIRI().toString()));
        }

        public void visit(@Nonnull SWRLIndividualArgument swrlIndividualArgument) {
            swrlIndividualArgument.getIndividual().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull SWRLLiteralArgument swrlLiteralArgument) {
            swrlLiteralArgument.getLiteral().accept((OWLObjectVisitor)this);
        }

        public void visit(@Nonnull SWRLSameIndividualAtom atom) {
            this.builder.append(ManchesterOWLSyntax.SAME_INDIVIDUAL.toString());
            this.builder.append("(");
            this.renderCollection((OWLObject)atom, (Collection<? extends OWLObject>)atom.getAllArguments(), COMMA_SEPARATOR, (BracketingStrategy)NullBracketingStrategy.get());
            this.builder.append(")");
        }

        public void visit(@Nonnull SWRLDifferentIndividualsAtom atom) {
            this.builder.append(ManchesterOWLSyntax.DIFFERENT_INDIVIDUALS.toString());
            this.builder.append("(");
            this.renderCollection((OWLObject)atom, (Collection<? extends OWLObject>)atom.getAllArguments(), COMMA_SEPARATOR, (BracketingStrategy)NullBracketingStrategy.get());
            this.builder.append(")");
        }
    }
}

