/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.conf;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.protege.editor.core.Fonts;
import org.protege.editor.core.ui.preferences.PreferencesLayoutPanel;
import org.protege.editor.owl.ui.preferences.OWLPreferencesPanel;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.plugin.RendererPlugin;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererPreferencesPanel
extends OWLPreferencesPanel {
    private final Logger logger = LoggerFactory.getLogger(RendererPreferencesPanel.class);
    private Map<JRadioButton, RendererPlugin> buttonToRendererMap = new LinkedHashMap<JRadioButton, RendererPlugin>();
    private JList annotationPropertiesList;
    private JCheckBox highlightAOStatementsCheckBox;
    private JCheckBox showHyperlinksCheckBox;
    private JCheckBox highlightKeyWordsCheckBox;
    private JCheckBox useOnlineLinkExtractorsCheckBox;
    private JSpinner fontSizeSpinner;
    private JButton configureButton;
    private RendererPlugin originalRendererPlugin;
    private boolean dirty = false;

    public void applyChanges() {
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        prefs.setHighlightActiveOntologyStatements(this.highlightAOStatementsCheckBox.isSelected());
        prefs.setRenderHyperlinks(this.showHyperlinksCheckBox.isSelected());
        prefs.setHighlightKeyWords(this.highlightKeyWordsCheckBox.isSelected());
        prefs.setUseOnlineLinkExtractors(this.useOnlineLinkExtractorsCheckBox.isSelected());
        Integer fontSize = (Integer)this.fontSizeSpinner.getValue();
        prefs.setFontSize(fontSize);
        if (this.isDirty()) {
            RendererPlugin plugin = this.getSelectedRendererPlugin();
            try {
                prefs.setRendererPlugin(plugin);
                OWLModelManagerEntityRenderer ren = plugin.newInstance();
                this.getOWLModelManager().refreshRenderer();
                Fonts.updateUIDefaultsFontSize((int)fontSize);
            }
            catch (Exception e) {
                throw new OWLRuntimeException((Throwable)e);
            }
        }
        SwingUtilities.updateComponentTreeUI((Component)((Object)this.getOWLEditorKit().getWorkspace()));
    }

    public void initialise() throws Exception {
        this.setLayout(new BorderLayout());
        PreferencesLayoutPanel layoutPanel = new PreferencesLayoutPanel();
        this.add((Component)layoutPanel, "North");
        this.createRendererSelectionPanel(layoutPanel);
        layoutPanel.addSeparator();
        layoutPanel.addGroup("Appearance");
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        this.highlightAOStatementsCheckBox = new JCheckBox("Highlight active ontology statements", prefs.isHighlightActiveOntologyStatements());
        this.showHyperlinksCheckBox = new JCheckBox("Show hyperlinks in components that support them", prefs.isRenderHyperlinks());
        this.highlightKeyWordsCheckBox = new JCheckBox("Highlight keywords", prefs.isHighlightKeyWords());
        this.useOnlineLinkExtractorsCheckBox = new JCheckBox("Use online link extractors", prefs.isUseOnlineLinkExtractors());
        layoutPanel.addGroupComponent((JComponent)this.highlightAOStatementsCheckBox);
        layoutPanel.addGroupComponent((JComponent)this.showHyperlinksCheckBox);
        layoutPanel.addGroupComponent((JComponent)this.highlightKeyWordsCheckBox);
        layoutPanel.addGroupComponent((JComponent)this.useOnlineLinkExtractorsCheckBox);
        layoutPanel.addSeparator();
        layoutPanel.addGroup("Font size");
        this.fontSizeSpinner = new JSpinner(new SpinnerNumberModel(prefs.getFontSize(), 1, 120, 1));
        layoutPanel.addGroupComponent((JComponent)this.fontSizeSpinner);
        JButton resetFontSizeButton = new JButton("Reset font");
        resetFontSizeButton.addActionListener(e -> this.resetFont());
        layoutPanel.addIndentedGroupComponent((JComponent)resetFontSizeButton);
    }

    protected void resetFont() {
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        prefs.setFontSize(OWLRendererPreferences.DEFAULT_FONT_SIZE);
        this.fontSizeSpinner.setValue(OWLRendererPreferences.DEFAULT_FONT_SIZE);
    }

    private void createRendererSelectionPanel(PreferencesLayoutPanel layoutPanel) {
        OWLRendererPreferences prefs = OWLRendererPreferences.getInstance();
        for (RendererPlugin plugin : prefs.getRendererPlugins()) {
            this.addRenderer(plugin.getName(), plugin);
        }
        layoutPanel.addGroup("Entity rendering");
        ButtonGroup bg = new ButtonGroup();
        for (JRadioButton button : this.buttonToRendererMap.keySet()) {
            bg.add(button);
            layoutPanel.addGroupComponent((JComponent)button);
            button.addChangeListener(e -> this.updateRendererButtons());
        }
        this.configureButton = new JButton("Configure...");
        this.configureButton.addActionListener(e -> {
            RendererPlugin plugin = this.getSelectedRendererPlugin();
            try {
                if (plugin != null && plugin.newInstance().configure(this.getOWLEditorKit())) {
                    this.dirty = true;
                }
            }
            catch (Exception cnfe) {
                this.logger.error("An error occurred whilst instantiating a renderer preferences panel plugin: {}", (Throwable)cnfe);
            }
        });
        layoutPanel.addIndentedGroupComponent((JComponent)this.configureButton);
        this.updateRendererButtons();
    }

    private void addRenderer(String label, RendererPlugin plugin) {
        RendererPlugin currentPlugin = OWLRendererPreferences.getInstance().getRendererPlugin();
        JRadioButton button = new JRadioButton(label, plugin.equals(currentPlugin));
        this.buttonToRendererMap.put(button, plugin);
    }

    private void updateRendererButtons() {
        RendererPlugin plugin = this.getSelectedRendererPlugin();
        if (plugin != null) {
            try {
                this.configureButton.setEnabled(plugin.newInstance().isConfigurable());
            }
            catch (Exception e) {
                this.logger.error("An error occurred whilst updating the state of a renderer plugin: {}", (Throwable)e);
                this.configureButton.setEnabled(false);
            }
        }
    }

    public void dispose() {
    }

    public boolean isDirty() {
        return this.dirty || this.getSelectedRendererPlugin() != null && !this.getSelectedRendererPlugin().equals(this.originalRendererPlugin);
    }

    public RendererPlugin getSelectedRendererPlugin() {
        for (JRadioButton button : this.buttonToRendererMap.keySet()) {
            if (!button.isSelected()) continue;
            return this.buttonToRendererMap.get(button);
        }
        return null;
    }
}

