/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.awt.Font;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.owl.ui.renderer.OWLEntityAnnotationValueRenderer;
import org.protege.editor.owl.ui.renderer.plugin.RendererPlugin;
import org.protege.editor.owl.ui.renderer.plugin.RendererPluginLoader;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLRendererPreferences {
    public static final String DEFAULT_RENDERER_CLASS_NAME = OWLEntityAnnotationValueRenderer.class.getName();
    public static final String ALLOW_PROTEGE_TO_OVERRIDE_RENDERER = "allow.protege.renderer.override";
    public static final String RENDER_HYPERLINKS = "RENDER_HYPERLINKS";
    public static final String HIGHLIGHT_ACTIVE_ONTOLOGY_STATEMENTS = "HIGHLIGHT_ACTIVE_ONTOLOGY_STATEMENTS";
    public static final String HIGHLIGHT_CHANGED_ENTITIES = "HIGHLIGHT_CHANGED_ENTITIES";
    public static final String HIGHLIGHT_KEY_WORDS = "HIGHLIGHT_KEY_WORDS";
    public static final String RENDERER_CLASS = "RENDERER_CLASS";
    public static final String USE_THAT_KEYWORD = "USE_THAT_KEYWORD";
    public static final String RENDER_DOMAIN_AXIOMS_AS_GCIS = "RENDER_DOMAIN_AXIOMS_AS_GCIS";
    public static final String FONT_SIZE = "FONT_SIZE";
    public static final String FONT_NAME = "FONT_NAME";
    public static final String ANNOTATIONS = "ANNOTATIONS";
    public static final String DISPLAY_ANNOTATION_ANNOTATIONS_INLINE = "DISPLAY_ANNOTATION_ANNOTATIONS_INLINE";
    public static final String DISPLAY_LITERAL_DATATYPES_INLINE = "DISPLAY_LITERAL_DATATYPES_INLINE";
    public static final String DISPLAY_THUMBNAILS_INLINE = "DISPLAY_THUMBNAILS_INLINE";
    public static final String USE_ONLINE_LINK_EXTRACTORS = "USE_ONLINE_LINK_EXTRACTORS";
    public static final int DEFAULT_FONT_SIZE = OWLRendererPreferences.getDefaultFontSize();
    public static final String DEFAULT_FONT_NAME = OWLRendererPreferences.getDefaultFontName();
    public static final String NO_LANGUAGE_SET_USER_TOKEN = "!";
    public static final String NO_LANGUAGE_SET = "";
    private static OWLRendererPreferences instance;
    private boolean renderHyperlinks;
    private boolean highlightActiveOntologyStatements;
    private boolean highlightChangedEntities;
    private boolean highlightKeyWords;
    private boolean useThatKeyword;
    private boolean renderDomainAxiomsAsGCIs;
    private int fontSize;
    private String fontName = DEFAULT_FONT_NAME;
    private Font font;
    private List<IRI> annotationIRIS;
    private List<String> annotationLanguages;
    private List<RendererPlugin> rendererPlugins;
    private RendererPlugin currentRendererPlugin;
    private boolean allowProtegeToOverrideRenderer;
    private boolean displayAnnotationAnnotationsInline;
    private boolean displayLiteralDatatypesInline;
    private boolean displayThumbnailsInline;
    private boolean useOnlineLinkExtractors;

    public Font getFont() {
        return this.font;
    }

    public String getFontName() {
        return this.fontName;
    }

    private static String getDefaultFontName() {
        return "SansSerif";
    }

    private static int getDefaultFontSize() {
        return 12;
    }

    @Deprecated
    public void setFontName(String fontName) {
        this.fontName = fontName;
        this.getPreferences().putString(FONT_NAME, fontName);
        this.resetFont();
    }

    private void resetFont() {
        this.font = new Font(this.fontName, 0, this.fontSize);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.getPreferences().putInt(FONT_SIZE, fontSize);
        this.resetFont();
    }

    public boolean isDisplayAnnotationAnnotationsInline() {
        return this.displayAnnotationAnnotationsInline;
    }

    public void setDisplayAnnotationAnnotationsInline(boolean displayAnnotationAnnotationsInline) {
        this.displayAnnotationAnnotationsInline = displayAnnotationAnnotationsInline;
        this.getPreferences().putBoolean(DISPLAY_ANNOTATION_ANNOTATIONS_INLINE, displayAnnotationAnnotationsInline);
    }

    public boolean isDisplayLiteralDatatypesInline() {
        return this.displayLiteralDatatypesInline;
    }

    public void setDisplayLiteralDatatypesInline(boolean displayLiteralDatatypesInline) {
        this.displayLiteralDatatypesInline = displayLiteralDatatypesInline;
        this.getPreferences().putBoolean(DISPLAY_LITERAL_DATATYPES_INLINE, displayLiteralDatatypesInline);
    }

    public boolean isDisplayThumbnailsInline() {
        return this.displayThumbnailsInline;
    }

    public void setDisplayThumbnailsInline(boolean displayThumbnailsInline) {
        this.displayThumbnailsInline = displayThumbnailsInline;
        this.getPreferences().putBoolean(DISPLAY_THUMBNAILS_INLINE, displayThumbnailsInline);
    }

    public boolean isUseOnlineLinkExtractors() {
        return this.useOnlineLinkExtractors;
    }

    public void setUseOnlineLinkExtractors(boolean useOnlineLinkExtractors) {
        this.useOnlineLinkExtractors = useOnlineLinkExtractors;
        this.getPreferences().putBoolean(USE_ONLINE_LINK_EXTRACTORS, useOnlineLinkExtractors);
    }

    public void setAnnotations(List<IRI> iris) {
        this.annotationIRIS = iris;
        this.writeAnnotations();
    }

    public void setAnnotationLanguages(List<String> annotationLanguages) {
        this.annotationLanguages = new ArrayList<String>(annotationLanguages);
        this.writeAnnotations();
    }

    public List<IRI> getAnnotationIRIs() {
        return new ArrayList<IRI>(this.annotationIRIS);
    }

    public List<String> getAnnotationLangs() {
        return Collections.unmodifiableList(this.annotationLanguages);
    }

    public ListMultimap<IRI, String> getAnnotationLangMap() {
        ArrayListMultimap langMap = ArrayListMultimap.create();
        for (IRI iri : this.annotationIRIS) {
            langMap.putAll((Object)iri, Collections.unmodifiableList(this.annotationLanguages));
        }
        return langMap;
    }

    private OWLRendererPreferences() {
        this.load();
    }

    public static synchronized OWLRendererPreferences getInstance() {
        if (instance == null) {
            instance = new OWLRendererPreferences();
        }
        return instance;
    }

    private Preferences getPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences(this.getClass());
    }

    private void load() {
        Preferences p = this.getPreferences();
        this.renderHyperlinks = p.getBoolean(RENDER_HYPERLINKS, true);
        this.highlightActiveOntologyStatements = p.getBoolean(HIGHLIGHT_ACTIVE_ONTOLOGY_STATEMENTS, true);
        this.highlightChangedEntities = p.getBoolean(HIGHLIGHT_CHANGED_ENTITIES, false);
        this.highlightKeyWords = p.getBoolean(HIGHLIGHT_KEY_WORDS, true);
        this.useThatKeyword = p.getBoolean(USE_THAT_KEYWORD, false);
        this.allowProtegeToOverrideRenderer = p.getBoolean(ALLOW_PROTEGE_TO_OVERRIDE_RENDERER, true);
        this.setRendererPlugin(p.getString(RENDERER_CLASS, DEFAULT_RENDERER_CLASS_NAME));
        this.renderDomainAxiomsAsGCIs = false;
        p.putBoolean(RENDER_DOMAIN_AXIOMS_AS_GCIS, false);
        this.fontSize = p.getInt(FONT_SIZE, DEFAULT_FONT_SIZE);
        this.fontName = p.getString(FONT_NAME, DEFAULT_FONT_NAME);
        this.displayAnnotationAnnotationsInline = p.getBoolean(DISPLAY_ANNOTATION_ANNOTATIONS_INLINE, true);
        this.displayLiteralDatatypesInline = p.getBoolean(DISPLAY_LITERAL_DATATYPES_INLINE, true);
        this.displayThumbnailsInline = p.getBoolean(DISPLAY_THUMBNAILS_INLINE, true);
        this.useOnlineLinkExtractors = p.getBoolean(USE_ONLINE_LINK_EXTRACTORS, true);
        this.loadAnnotations();
        this.resetFont();
    }

    private void loadAnnotations() {
        this.annotationIRIS = new ArrayList<IRI>();
        this.annotationLanguages = new ArrayList<String>();
        List defaultValues = Collections.emptyList();
        List values = this.getPreferences().getStringList(ANNOTATIONS, defaultValues);
        if (values.equals(defaultValues)) {
            this.annotationIRIS.add(OWLRDFVocabulary.RDFS_LABEL.getIRI());
            this.annotationIRIS.add(IRI.create((String)"http://www.w3.org/2004/02/skos/core#prefLabel"));
            this.annotationLanguages = this.getDefaultLanguages();
        } else {
            for (String value : values) {
                String[] tokens = value.split(",");
                try {
                    IRI iri = IRI.create((URI)new URI(tokens[0].trim()));
                    for (int i = 1; i < tokens.length; ++i) {
                        String token = tokens[i].trim();
                        if (token.equals(NO_LANGUAGE_SET_USER_TOKEN)) {
                            token = NO_LANGUAGE_SET;
                        }
                        if (this.annotationLanguages.contains(token)) continue;
                        this.annotationLanguages.add(token);
                    }
                    this.annotationIRIS.add(iri);
                }
                catch (URISyntaxException e) {
                    ErrorLogPanel.showErrorDialog((Throwable)e);
                }
            }
        }
        if (!this.annotationLanguages.contains(NO_LANGUAGE_SET)) {
            this.annotationLanguages.add(NO_LANGUAGE_SET);
        }
    }

    private void writeAnnotations() {
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder langStringBuilder = new StringBuilder();
        for (String lang : this.annotationLanguages) {
            if (lang == null || lang.equals(NO_LANGUAGE_SET)) {
                lang = NO_LANGUAGE_SET_USER_TOKEN;
            }
            langStringBuilder.append(", ").append(lang);
        }
        for (IRI iri : this.annotationIRIS) {
            StringBuilder str = new StringBuilder(iri.toString());
            str.append(langStringBuilder.toString());
            values.add(str.toString());
        }
        this.getPreferences().putStringList(ANNOTATIONS, values);
    }

    private List<String> getDefaultLanguages() {
        ArrayList<String> langs = new ArrayList<String>();
        Locale locale = Locale.getDefault();
        if (locale != null && locale.getLanguage() != null && !locale.getLanguage().equals(NO_LANGUAGE_SET)) {
            langs.add(locale.getLanguage());
            if (locale.getCountry() != null && !locale.getCountry().equals(NO_LANGUAGE_SET)) {
                langs.add(locale.getLanguage() + "-" + locale.getCountry());
            }
        }
        langs.add(NO_LANGUAGE_SET);
        String en = Locale.ENGLISH.getLanguage();
        if (!langs.contains(en)) {
            langs.add(en);
        }
        return langs;
    }

    public void reset() {
        this.renderHyperlinks = true;
        this.highlightActiveOntologyStatements = true;
        this.highlightChangedEntities = false;
        this.highlightKeyWords = true;
        this.useThatKeyword = false;
        this.displayAnnotationAnnotationsInline = true;
        this.displayLiteralDatatypesInline = true;
        this.useOnlineLinkExtractors = true;
        this.fontSize = DEFAULT_FONT_SIZE;
    }

    public boolean isRenderHyperlinks() {
        return this.renderHyperlinks;
    }

    public List<RendererPlugin> getRendererPlugins() {
        if (this.rendererPlugins == null) {
            RendererPluginLoader loader = new RendererPluginLoader();
            this.rendererPlugins = new ArrayList<RendererPlugin>(loader.getPlugins());
            Collections.sort(this.rendererPlugins);
        }
        return this.rendererPlugins;
    }

    public RendererPlugin getRendererPlugin() {
        return this.currentRendererPlugin;
    }

    public RendererPlugin getRendererPluginByClassName(String javaClassName) {
        for (RendererPlugin plugin : this.getRendererPlugins()) {
            if (!plugin.getRendererClassName().equals(javaClassName)) continue;
            return plugin;
        }
        return null;
    }

    public void setRendererPlugin(RendererPlugin plugin) {
        String rendererClass = plugin.getRendererClassName();
        this.getPreferences().putString(RENDERER_CLASS, rendererClass);
        this.currentRendererPlugin = plugin;
    }

    private void setRendererPlugin(String rendererClass) {
        this.currentRendererPlugin = null;
        for (RendererPlugin plugin : this.getRendererPlugins()) {
            String pluginClassName = plugin.getRendererClassName();
            if (pluginClassName.equals(rendererClass)) {
                this.currentRendererPlugin = plugin;
                break;
            }
            if (this.currentRendererPlugin != null || !pluginClassName.equals(DEFAULT_RENDERER_CLASS_NAME)) continue;
            this.currentRendererPlugin = plugin;
        }
    }

    public boolean isProtegeAllowedToOverrideRenderer() {
        return this.allowProtegeToOverrideRenderer;
    }

    public boolean isUseThatKeyword() {
        return this.useThatKeyword;
    }

    public void setUseThatKeyword(boolean useThatKeyword) {
        this.useThatKeyword = useThatKeyword;
        this.getPreferences().putBoolean(USE_THAT_KEYWORD, useThatKeyword);
    }

    public void setRenderHyperlinks(boolean renderHyperlinks) {
        this.renderHyperlinks = renderHyperlinks;
        this.getPreferences().putBoolean(RENDER_HYPERLINKS, renderHyperlinks);
    }

    public boolean isHighlightActiveOntologyStatements() {
        return this.highlightActiveOntologyStatements;
    }

    public void setHighlightActiveOntologyStatements(boolean highlightActiveOntologyStatements) {
        this.highlightActiveOntologyStatements = highlightActiveOntologyStatements;
        this.getPreferences().putBoolean(HIGHLIGHT_ACTIVE_ONTOLOGY_STATEMENTS, highlightActiveOntologyStatements);
    }

    public boolean isHighlightChangedEntities() {
        return this.highlightChangedEntities;
    }

    public void setHighlightChangedEntities(boolean highlightChangedEntities) {
        this.highlightChangedEntities = highlightChangedEntities;
        this.getPreferences().putBoolean(HIGHLIGHT_CHANGED_ENTITIES, highlightChangedEntities);
    }

    public boolean isHighlightKeyWords() {
        return this.highlightKeyWords;
    }

    public void setHighlightKeyWords(boolean highlightKeyWords) {
        this.highlightKeyWords = highlightKeyWords;
        this.getPreferences().putBoolean(HIGHLIGHT_KEY_WORDS, highlightKeyWords);
    }

    public void setRenderDomainAxiomsAsGCIs(boolean b) {
        this.renderDomainAxiomsAsGCIs = b;
        this.getPreferences().putBoolean(RENDER_DOMAIN_AXIOMS_AS_GCIS, b);
    }

    public boolean isRenderDomainAxiomsAsGCIs() {
        return this.renderDomainAxiomsAsGCIs;
    }
}

