/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import com.google.common.base.Optional;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.OntologyIRIShortFormProvider;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLOntologyCellRenderer
extends DefaultListCellRenderer {
    private static final IRI DCTERM_TITLE = IRI.create((String)"http://purl.org/dc/terms/title");
    private OWLEditorKit editorKit;

    public OWLOntologyCellRenderer(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, "", index, isSelected, cellHasFocus);
        if (value instanceof OWLOntology) {
            label.setText(OWLOntologyCellRenderer.getOntologyLabelText((OWLOntology)value, this.editorKit.getModelManager()));
            label.setIcon(this.editorKit.getWorkspace().getOWLIconProvider().getIcon((OWLObject)((OWLOntology)value)));
        } else if (value instanceof IRI) {
            label.setText(OWLOntologyCellRenderer.getOntologyLabelText((Optional<IRI>)Optional.of((Object)((IRI)value)), this.editorKit.getModelManager()));
        }
        return label;
    }

    public static String getOntologyLabelText(OWLOntology ont, OWLModelManager mngr) {
        if (ont.getOntologyID().isAnonymous()) {
            return ont.getOntologyID().toString();
        }
        Optional iri = ont.getOntologyID().getDefaultDocumentIRI();
        String name = OWLOntologyCellRenderer.getOntologyDisplayName(ont);
        return OWLOntologyCellRenderer.formatOntologyLabelText((Optional<IRI>)iri, name);
    }

    public static String getOntologyLabelText(Optional<IRI> iri, OWLModelManager mngr) {
        return OWLOntologyCellRenderer.formatOntologyLabelText(iri, null);
    }

    private static String formatOntologyLabelText(Optional<IRI> iri, String name) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        if (name != null) {
            sb.append(name);
        } else if (iri.isPresent()) {
            sb.append(new OntologyIRIShortFormProvider().getShortForm((IRI)iri.get()));
        } else {
            sb.append("Anonymous ontology");
        }
        if (iri.isPresent()) {
            sb.append(" <font color=\"gray\">(");
            sb.append(((IRI)iri.get()).toString());
            sb.append(")</font>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }

    private static String getOntologyDisplayName(OWLOntology ont) {
        String label = null;
        String title = null;
        for (OWLAnnotation annot : ont.getAnnotations()) {
            if (!annot.getValue().isLiteral()) continue;
            IRI property = annot.getProperty().getIRI();
            if (property.equals((Object)OWLRDFVocabulary.RDFS_LABEL.getIRI())) {
                label = ((OWLLiteral)annot.getValue().asLiteral().get()).getLiteral();
                continue;
            }
            if (property.equals((Object)DublinCoreVocabulary.TITLE.getIRI())) {
                title = ((OWLLiteral)annot.getValue().asLiteral().get()).getLiteral();
                continue;
            }
            if (!property.equals((Object)DCTERM_TITLE)) continue;
            title = ((OWLLiteral)annot.getValue().asLiteral().get()).getLiteral();
        }
        return label != null ? label : title;
    }
}

