/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.deprecation;

import com.google.common.base.Preconditions;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.deprecation.DeprecateEntityWizardState;
import org.protege.editor.owl.ui.deprecation.DeprecationWizardEntityRenderer;
import org.semanticweb.owlapi.model.OWLEntity;

public class DeprecationReasonPage
extends AbstractOWLWizardPanel {
    public static final String ID = "DeprecationReason";
    private final JTextArea reasonTextArea = new JTextArea();
    @Nonnull
    private final DeprecateEntityWizardState wizardState;

    public DeprecationReasonPage(@Nonnull OWLEditorKit editorKit, @Nonnull DeprecateEntityWizardState wizardState, @Nonnull OWLEntity entityToDeprecate) {
        super(ID, "Reason for deprecation", editorKit);
        this.wizardState = (DeprecateEntityWizardState)Preconditions.checkNotNull((Object)wizardState);
        JPanel contentPanel = new JPanel(new BorderLayout(7, 7));
        this.setContent(contentPanel);
        this.setInstructions(new DeprecationWizardEntityRenderer(this.getOWLModelManager()).getHtmlRendering(entityToDeprecate) + "\n\nPlease specify a reason that explains why this entity is to be deprecated.\n\nThe deprecated entity will be annotated with this reason so that consumers of this ontology understand why the entity was deprecated.");
        this.reasonTextArea.setLineWrap(true);
        contentPanel.add((Component)this.reasonTextArea, "Center");
    }

    public String getReasonForDeprecation() {
        return this.reasonTextArea.getText().trim();
    }

    public void aboutToHidePanel() {
        this.wizardState.setReasonForDeprecation(this.getReasonForDeprecation());
    }

    @Nullable
    public Object getBackPanelDescriptor() {
        return "DeprecationProfilePage";
    }

    @Nullable
    public Object getNextPanelDescriptor() {
        if (this.wizardState.getDeprecationProfile().map(profile -> profile.getDeprecationCode().isPresent()).orElse(false).booleanValue()) {
            return "DeprecationCodePage";
        }
        return "DeprecationReplacementEntityPage";
    }

    public void displayingPanel() {
        super.displayingPanel();
        this.reasonTextArea.requestFocus();
    }
}

