/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.lang.LangCode;
import org.protege.editor.owl.model.lang.LangCodeRegistry;
import org.protege.editor.owl.model.util.OWLDataTypeUtils;
import org.protege.editor.owl.ui.Extensions;
import org.protege.editor.owl.ui.lang.LangCodeEditor;
import org.protege.editor.owl.ui.lang.LangCodeRenderer;
import org.protege.editor.owl.ui.list.OWLEntityListPanel;
import org.protege.editor.owl.ui.renderer.OWLCellRendererSimple;
import org.protege.editor.owl.ui.selector.OWLAnnotationPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLClassSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataTypeSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLIndividualSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLOntologySelectorPanel;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

public class UIHelper {
    private OWLEditorKit owlEditorKit;
    public static final Set<String> OWL_EXTENSIONS = Collections.unmodifiableSet(new HashSet<String>(Extensions.getExtensions()));

    public UIHelper(OWLEditorKit owlEditorKit) {
        this.owlEditorKit = owlEditorKit;
    }

    private JComponent getParent() {
        return this.owlEditorKit.getWorkspace();
    }

    private OWLModelManager getOWLModelManager() {
        return this.owlEditorKit.getModelManager();
    }

    public URI getURI(String title, String message) throws URISyntaxException {
        String uriString = JOptionPane.showInputDialog(this.getParent(), message, title, 1);
        if (uriString == null) {
            return null;
        }
        return new URI(uriString);
    }

    public OWLClass pickOWLClass() {
        OWLClassSelectorPanel clsPanel = new OWLClassSelectorPanel(this.owlEditorKit);
        int ret = this.showDialog("Select a class", clsPanel);
        clsPanel.dispose();
        if (ret == 0) {
            return clsPanel.getSelectedObject();
        }
        return null;
    }

    public OWLIndividual pickOWLIndividual() {
        OWLIndividualSelectorPanel indPanel = this.owlEditorKit.getOWLWorkspace().getOWLComponentFactory().getOWLIndividualSelectorPanel();
        int ret = this.showDialog("Select an individual", indPanel);
        if (ret == 0) {
            OWLNamedIndividual ind = indPanel.getSelectedObject();
            indPanel.dispose();
            return ind;
        }
        return null;
    }

    public OWLOntology pickOWLOntology() {
        OWLOntologySelectorPanel ontPanel = new OWLOntologySelectorPanel(this.owlEditorKit);
        ontPanel.setMultipleSelectionEnabled(false);
        int ret = this.showDialog("Select an ontology", ontPanel);
        if (ret == 0) {
            return ontPanel.getSelectedOntology();
        }
        return null;
    }

    public Set<OWLOntology> pickOWLOntologies() {
        OWLOntologySelectorPanel ontPanel = new OWLOntologySelectorPanel(this.owlEditorKit);
        int ret = this.showDialog("Select ontologies", ontPanel);
        if (ret == 0) {
            return ontPanel.getSelectedOntologies();
        }
        return Collections.emptySet();
    }

    public int showDialog(String title, JComponent component) {
        return JOptionPaneEx.showConfirmDialog((Component)this.getParent(), (String)title, (JComponent)component, (int)-1, (int)2, null);
    }

    public int showDialog(String title, JComponent component, int options) {
        return JOptionPaneEx.showConfirmDialog((Component)this.getParent(), (String)title, (JComponent)component, (int)-1, (int)options, null);
    }

    public int showDialog(String title, JComponent component, JComponent focusedComponent) {
        return JOptionPaneEx.showConfirmDialog((Component)this.getParent(), (String)title, (JComponent)component, (int)-1, (int)2, (JComponent)focusedComponent);
    }

    public int showValidatingDialog(String title, JComponent component, JComponent focusedComponent) {
        return JOptionPaneEx.showValidatingConfirmDialog((Component)this.getParent(), (String)title, (JComponent)component, (int)-1, (int)2, (JComponent)focusedComponent);
    }

    public OWLObjectProperty pickOWLObjectProperty() {
        OWLObjectPropertySelectorPanel objPropPanel = this.owlEditorKit.getOWLWorkspace().getOWLComponentFactory().getOWLObjectPropertySelectorPanel();
        if (this.showDialog("Select an object property", objPropPanel) == 0) {
            return objPropPanel.getSelectedObject();
        }
        return null;
    }

    public OWLDataProperty pickOWLDataProperty() {
        OWLDataPropertySelectorPanel panel = this.owlEditorKit.getOWLWorkspace().getOWLComponentFactory().getOWLDataPropertySelectorPanel();
        if (this.showDialog("Select an object property", panel) == 0) {
            return panel.getSelectedObject();
        }
        return null;
    }

    public OWLDatatype pickOWLDatatype() {
        OWLDataTypeSelectorPanel panel = new OWLDataTypeSelectorPanel(this.owlEditorKit);
        if (this.showDialog("Select a datatype", panel) == 0) {
            return panel.getSelectedObject();
        }
        return null;
    }

    public <E extends OWLEntity> E pickOWLEntity(String message, Set<E> entities, OWLModelManager owlModelManager) {
        OWLEntityListPanel<E> panel = new OWLEntityListPanel<E>(message, entities, this.owlEditorKit);
        if (this.showDialog("Select an entity", panel) == 0) {
            return (E)((OWLEntity)panel.getSelectedObject());
        }
        return null;
    }

    public OWLAnnotationProperty pickAnnotationProperty() {
        OWLAnnotationPropertySelectorPanel panel = new OWLAnnotationPropertySelectorPanel(this.owlEditorKit);
        try {
            if (this.showDialog("Select an annotation property", panel) == 0) {
                OWLAnnotationProperty oWLAnnotationProperty = panel.getSelectedObject();
                return oWLAnnotationProperty;
            }
            OWLAnnotationProperty oWLAnnotationProperty = null;
            return oWLAnnotationProperty;
        }
        finally {
            panel.dispose();
        }
    }

    public String getHTMLOntologyList(Collection<OWLOntology> ontologies) {
        StringBuilder result = new StringBuilder();
        for (OWLOntology ont : ontologies) {
            Optional defaultDocumentIRI = ont.getOntologyID().getDefaultDocumentIRI();
            if (defaultDocumentIRI.isPresent()) {
                if (this.getOWLModelManager().getActiveOntology().equals(ont)) {
                    result.append("<font color=\"0000ff\"><b>");
                    result.append((CharSequence)defaultDocumentIRI.get());
                    result.append("</font></b>");
                } else {
                    result.append((CharSequence)defaultDocumentIRI.get());
                }
            }
            if (!this.getOWLModelManager().isMutable(ont)) {
                result.append("&nbsp;");
                result.append(" <font color=\"ff0000\">(Not editable)</font>");
            }
            result.append("<br>");
        }
        return result.toString();
    }

    public int showOptionPane(String title, String message, int optionType, int messageType) {
        return JOptionPane.showConfirmDialog(this.getParent(), message, title, optionType, messageType);
    }

    public File chooseOWLFile(String title) {
        JFrame f = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.getParent());
        if (f == null) {
            f = new JFrame();
        }
        return UIUtil.openFile((Component)f, (String)title, (String)"OWL File", OWL_EXTENSIONS);
    }

    public File saveOWLFile(String title) {
        return this.saveOWLFile(title, OWL_EXTENSIONS);
    }

    public File saveOWLFile(String title, Set<String> extensions) {
        return UIUtil.saveFile((Window)((JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, this.getParent())), (String)title, (String)"OWL File", extensions);
    }

    public OWLLiteral createConstant() {
        return null;
    }

    public JComboBox<String> getLanguageSelector() {
        JComboBox<String> c = new JComboBox<String>();
        c.setSelectedItem(null);
        c.setEditable(true);
        c.setModel(new DefaultComboBoxModel<String>(new String[]{null, "en", "de", "es", "fr", "pt"}));
        return c;
    }

    public JComboBox<LangCode> getLangCodeSelector() {
        LangCodeRegistry registry = LangCodeRegistry.get();
        JComboBox<LangCode> comboBox = new JComboBox<LangCode>();
        comboBox.setSelectedItem(null);
        comboBox.setEditable(true);
        ImmutableList<LangCode> langCodes = registry.getLangCodes();
        ArrayList<LangCode> langCodeList = new ArrayList<LangCode>((Collection<LangCode>)langCodes);
        langCodeList.add(0, null);
        comboBox.setModel(new DefaultComboBoxModel<Object>(langCodeList.toArray()));
        comboBox.setEditor(new LangCodeEditor(registry));
        comboBox.setRenderer(new LangCodeRenderer());
        return comboBox;
    }

    public JComboBox<OWLDatatype> getDatatypeSelector() {
        OWLModelManager mngr = this.getOWLModelManager();
        OWLDataFactory dataFactory = mngr.getOWLDataFactory();
        Set<OWLDatatype> datatypes = new OWLDataTypeUtils(mngr.getOWLOntologyManager()).getKnownDatatypes(mngr.getActiveOntologies());
        OWLDatatype decimal = OWL2Datatype.XSD_DECIMAL.getDatatype(dataFactory);
        datatypes.remove(decimal);
        OWLDatatype integer = OWL2Datatype.XSD_INTEGER.getDatatype(dataFactory);
        datatypes.remove(integer);
        OWLDatatype string = OWL2Datatype.XSD_STRING.getDatatype(dataFactory);
        datatypes.remove(string);
        OWLDatatype bool = OWL2Datatype.XSD_BOOLEAN.getDatatype(dataFactory);
        datatypes.remove(bool);
        OWLDatatype datetime = OWL2Datatype.XSD_DATE_TIME.getDatatype(dataFactory);
        datatypes.remove(datetime);
        ArrayList<OWLDatatype> datatypeList = new ArrayList<OWLDatatype>(datatypes);
        datatypeList.sort(mngr.getOWLObjectComparator());
        datatypeList.add(0, null);
        datatypeList.add(0, bool);
        datatypeList.add(0, datetime);
        datatypeList.add(0, integer);
        datatypeList.add(0, string);
        datatypeList.add(0, decimal);
        datatypeList.add(0, null);
        JComboBox<OWLDatatype> c = new JComboBox<OWLDatatype>(new DefaultComboBoxModel<OWLDatatype>(datatypeList.toArray(new OWLDatatype[0])));
        c.setPreferredSize(new Dimension(120, c.getPreferredSize().height));
        c.setRenderer(new OWLCellRendererSimple(this.owlEditorKit));
        return c;
    }
}

