/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor.ontology;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntologyMerger {
    private static final Logger logger = LoggerFactory.getLogger(OntologyMerger.class);
    private OWLOntologyManager owlOntologyManager;
    private Set<OWLOntology> ontologies;
    private OWLOntology targetOntology;

    public OntologyMerger(OWLOntologyManager owlOntologyManager, Set<OWLOntology> ontologies, OWLOntology targetOntology) {
        this.ontologies = new HashSet<OWLOntology>(ontologies);
        this.owlOntologyManager = owlOntologyManager;
        this.targetOntology = targetOntology;
    }

    public void mergeOntologies() {
        ArrayList<Object> changes = new ArrayList<Object>();
        for (OWLOntology ont : this.ontologies) {
            if (ont.equals(this.targetOntology)) continue;
            for (OWLAxiom ax : ont.getAxioms()) {
                changes.add(new AddAxiom(this.targetOntology, ax));
            }
            for (OWLAnnotation annot : ont.getAnnotations()) {
                changes.add(new AddOntologyAnnotation(this.targetOntology, annot));
            }
            if (this.targetOntology.getOntologyID().isAnonymous()) continue;
            for (OWLImportsDeclaration decl : ont.getImportsDeclarations()) {
                if (this.ontologies.contains(ont.getOWLOntologyManager().getImportedOntology(decl))) continue;
                Optional defaultDocumentIRI = this.targetOntology.getOntologyID().getDefaultDocumentIRI();
                if (defaultDocumentIRI.isPresent() && !decl.getIRI().equals(defaultDocumentIRI.get())) {
                    changes.add(new AddImport(this.targetOntology, decl));
                    continue;
                }
                logger.warn("Merge: ignoring import declaration for ontology " + String.valueOf(this.targetOntology.getOntologyID()) + " (would result in target ontology importing itself).");
            }
        }
        try {
            this.owlOntologyManager.applyChanges(changes);
        }
        catch (OWLOntologyChangeException e) {
            ErrorLogPanel.showErrorDialog((Throwable)e);
        }
    }
}

