/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.obofoundry;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.obofoundry.OboFoundryRegistry;
import org.protege.editor.owl.model.obofoundry.OboFoundryRegistryParser;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OboFoundryRegistryManager {
    private static final Logger logger = LoggerFactory.getLogger(OboFoundryRegistryManager.class);
    private static OboFoundryRegistry registry = null;

    private static OboFoundryRegistry parse() {
        if (OWLRendererPreferences.getInstance().isUseOnlineLinkExtractors()) {
            try {
                return OboFoundryRegistryParser.parseRegistryFromStandardLocation();
            }
            catch (IOException e) {
                logger.warn("Could not parse OBO Foundry registry from {}.  Reason: {}", (Object)OboFoundryRegistryParser.getStandardRegistryLocation(), (Object)e.getMessage());
            }
        }
        try {
            return OboFoundryRegistryParser.parseRegistryFromLocalCopy();
        }
        catch (IOException e) {
            logger.warn("Could not parse OBO Foundry registry from local copy.  Reason: {}", (Object)e.getMessage());
            return OboFoundryRegistry.empty();
        }
    }

    @Nonnull
    public static synchronized OboFoundryRegistry getRegistry() {
        int n;
        if (registry == null && (n = (registry = OboFoundryRegistryManager.parse()).getOntologies().size()) > 0) {
            logger.info("OBO Foundry registry loaded: {} entries", (Object)n);
        }
        return registry;
    }
}

