/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.identifiers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.protege.editor.owl.model.identifiers.IdentifiersDotOrg;
import org.protege.editor.owl.model.identifiers.IdentifiersDotOrgManager;
import org.protege.editor.owl.ui.renderer.LinkExtractor;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.layout.HTTPLink;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifiersDotOrgLinkExtractor
implements LinkExtractor {
    private static final Logger logger = LoggerFactory.getLogger(IdentifiersDotOrgLinkExtractor.class);

    public static IdentifiersDotOrgLinkExtractor createExtractor() {
        return new IdentifiersDotOrgLinkExtractor();
    }

    @Override
    public Optional<Link> extractLink(String s) {
        if (!OWLRendererPreferences.getInstance().isUseOnlineLinkExtractors()) {
            return Optional.empty();
        }
        IdentifiersDotOrg identifiersDotOrg = IdentifiersDotOrgManager.get();
        return identifiersDotOrg.getCollection(s).flatMap(collection -> {
            try {
                return Optional.of(new HTTPLink(new URI("http://identifiers.org/" + s)));
            }
            catch (URISyntaxException e) {
                logger.warn("Link extractor (Identifiers.org) returned invalid URI: {}", (Object)e.getMessage());
                return Optional.empty();
            }
        });
    }
}

