/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.find;

import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;

public class OWLEntityFinderPreferences {
    public static final String PREFERENCES_KEY = "org.protege.editor.owl.finder";
    public static final String USE_REGULAR_EXPRESSIONS_KEY = "USE_REGULAR_EXPRESSIONS";
    public static final String SEARCH_DELAY_KEY = "SEARCH_DELAY_KEY";
    public static final String CASE_SENSITIVE_KEY = "CASE_SENSITIVE_KEY";
    public static final String WHOLE_WORDS_KEY = "WHOLE_WORDS_KEY";
    public static final String IGNORE_WHITE_SPACE_KEY = "IGNORE_WHITE_SPACE_KEY";
    public static final String SHOW_DEPRECATED_KEY = "SHOW_DEPRECATED";
    private static final boolean DEFAULT_CASE_SENSITIVE_VALUE = false;
    private static OWLEntityFinderPreferences instance;
    private boolean useRegularExpressions = false;
    private long searchDelay = 500L;
    private boolean caseSensitive = false;
    private boolean wholeWords;
    private boolean ignoreWhiteSpace;
    private boolean showDeprecated;

    private OWLEntityFinderPreferences() {
        this.load();
    }

    private static Preferences getPreferences() {
        return PreferencesManager.getInstance().getApplicationPreferences(PREFERENCES_KEY);
    }

    private void load() {
        Preferences prefs = OWLEntityFinderPreferences.getPreferences();
        this.useRegularExpressions = prefs.getBoolean(USE_REGULAR_EXPRESSIONS_KEY, false);
        this.searchDelay = prefs.getLong(SEARCH_DELAY_KEY, 500L);
        this.caseSensitive = prefs.getBoolean(CASE_SENSITIVE_KEY, false);
        this.wholeWords = prefs.getBoolean(WHOLE_WORDS_KEY, false);
        this.ignoreWhiteSpace = prefs.getBoolean(IGNORE_WHITE_SPACE_KEY, true);
        this.showDeprecated = prefs.getBoolean(SHOW_DEPRECATED_KEY, true);
    }

    public boolean isUseRegularExpressions() {
        return this.useRegularExpressions;
    }

    public void setUseRegularExpressions(boolean useRegularExpressions) {
        this.useRegularExpressions = useRegularExpressions;
        OWLEntityFinderPreferences.getPreferences().putBoolean(USE_REGULAR_EXPRESSIONS_KEY, useRegularExpressions);
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean ignoreCase) {
        this.caseSensitive = ignoreCase;
        OWLEntityFinderPreferences.getPreferences().putBoolean(CASE_SENSITIVE_KEY, ignoreCase);
    }

    public boolean isWholeWords() {
        return this.wholeWords;
    }

    public void setWholeWords(boolean wholeWords) {
        this.wholeWords = wholeWords;
        OWLEntityFinderPreferences.getPreferences().putBoolean(WHOLE_WORDS_KEY, wholeWords);
    }

    public boolean isIgnoreWhiteSpace() {
        return this.ignoreWhiteSpace;
    }

    public void setIgnoreWhiteSpace(boolean ignoreWhiteSpace) {
        this.ignoreWhiteSpace = ignoreWhiteSpace;
        OWLEntityFinderPreferences.getPreferences().putBoolean(IGNORE_WHITE_SPACE_KEY, ignoreWhiteSpace);
    }

    public boolean isShowDeprecated() {
        return this.showDeprecated;
    }

    public void setShowDeprecated(boolean showDeprecated) {
        this.showDeprecated = showDeprecated;
        OWLEntityFinderPreferences.getPreferences().putBoolean(SHOW_DEPRECATED_KEY, showDeprecated);
    }

    public long getSearchDelay() {
        return this.searchDelay;
    }

    public void setSearchDelay(long searchDelay) {
        this.searchDelay = searchDelay;
        OWLEntityFinderPreferences.getPreferences().putLong(SEARCH_DELAY_KEY, searchDelay);
    }

    public static synchronized OWLEntityFinderPreferences getInstance() {
        if (instance == null) {
            instance = new OWLEntityFinderPreferences();
        }
        return instance;
    }
}

