/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.bioregistry;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class Resource {
    private String uriFormat;
    private Pattern idPattern;
    private List<String> prefixes = new ArrayList<String>();

    public Resource(@Nonnull @JsonProperty(value="prefix") String prefix, @Nonnull @JsonProperty(value="uri_format") String uriFormat, @JsonProperty(value="pattern") String pattern, @JsonProperty(value="synonyms") List<String> synonyms) {
        if (prefix == null) {
            throw new IllegalArgumentException("Missing prefix");
        }
        if (uriFormat == null) {
            throw new IllegalArgumentException("Missing URI format");
        }
        this.prefixes.add(prefix);
        this.uriFormat = uriFormat;
        if (pattern != null) {
            this.idPattern = Pattern.compile(pattern);
        }
        if (synonyms != null) {
            this.prefixes.addAll(synonyms);
        }
    }

    public String formatURI(@Nonnull String id) {
        if (this.idPattern == null || this.idPattern.matcher(id).matches()) {
            return this.uriFormat.replace("$1", id);
        }
        return null;
    }

    public List<String> getPrefixes() {
        return this.prefixes;
    }
}

