/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.bioregistry;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import org.protege.editor.owl.model.bioregistry.Bioregistry;
import org.protege.editor.owl.ui.renderer.LinkExtractor;
import org.protege.editor.owl.ui.renderer.layout.HTTPLink;
import org.protege.editor.owl.ui.renderer.layout.Link;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BioregistryLinkExtractor
implements LinkExtractor {
    private static final Logger logger = LoggerFactory.getLogger(BioregistryLinkExtractor.class);

    public static BioregistryLinkExtractor createExtractor() {
        return new BioregistryLinkExtractor();
    }

    @Override
    public Optional<Link> extractLink(String s) {
        String uri;
        if (s != null && (uri = Bioregistry.getInstance().resolve(s)) != null) {
            try {
                return Optional.of(new HTTPLink(new URI(uri)));
            }
            catch (URISyntaxException e) {
                logger.warn("Link extractor (Bioregistry) returned invalid URI: {}", (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }
}

