/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.bioregistry;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.HttpClientBuilder;
import org.protege.editor.owl.model.bioregistry.Resource;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bioregistry {
    private static final Logger logger = LoggerFactory.getLogger(Bioregistry.class);
    private static final String API_ENDPOINT = "http://bioregistry.io/api/registry/%s?format=json";
    private static final int MAX_ERRORS = 6;
    private static Bioregistry instance;
    private Map<String, Resource> cache = new HashMap<String, Resource>();
    private final HttpClient client = HttpClientBuilder.create().useSystemProperties().build();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private int errors = 0;

    public static synchronized Bioregistry getInstance() {
        if (instance == null) {
            instance = new Bioregistry();
        }
        return instance;
    }

    public Bioregistry() {
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.loadBundledBioregistry();
    }

    public String resolve(@Nonnull String id) {
        String[] items = id.split(":");
        if (items.length == 2) {
            return this.resolve(items[0], items[1]);
        }
        return null;
    }

    public String resolve(@Nonnull String prefix, @Nonnull String localIdentifier) {
        Resource resource = this.getResource(prefix);
        if (resource != null) {
            return resource.formatURI(localIdentifier);
        }
        return null;
    }

    private Resource getResource(@Nonnull String prefix) {
        if (!this.cache.containsKey(prefix) && OWLRendererPreferences.getInstance().isUseOnlineLinkExtractors() && this.errors < 6) {
            Resource resource = null;
            HttpGet request = new HttpGet(String.format(API_ENDPOINT, prefix));
            request.addHeader("Accept", "application/json");
            try {
                HttpResponse response = this.client.execute(request);
                if (response.getStatusLine().getStatusCode() == 200) {
                    InputStream stream = response.getEntity().getContent();
                    resource = this.objectMapper.readValue(stream, Resource.class);
                }
            }
            catch (IOException e) {
                logger.warn("Error when querying the bioregistry for '{}': {}", (Object)prefix, (Object)e.getMessage());
                ++this.errors;
            }
            request.releaseConnection();
            this.cache.put(prefix, resource);
            if (resource != null) {
                for (String pfx : resource.getPrefixes()) {
                    this.cache.put(pfx, resource);
                }
            }
        }
        return this.cache.get(prefix);
    }

    private void loadBundledBioregistry() {
        InputStream is = Bioregistry.class.getResourceAsStream("/bioregistry/bioregistry.json");
        if (is == null) {
            logger.warn("Cannot find bundled Bioregistry data");
            return;
        }
        try {
            MappingIterator it = this.objectMapper.readerFor(Resource.class).readValues(is);
            int nResources = 0;
            int nPrefixes = 0;
            while (it.hasNext()) {
                Resource res = (Resource)it.next();
                ++nResources;
                for (String pfx : res.getPrefixes()) {
                    this.cache.put(pfx, res);
                    ++nPrefixes;
                }
            }
            logger.info("Cached {} Bioregistry resources ({} prefixes)", (Object)nResources, (Object)nPrefixes);
        }
        catch (IOException e) {
            logger.warn("Cannot parse bundled Bioregistry data: {}", (Object)e.getMessage());
        }
    }
}

