/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.BookMarkedURIManager;
import org.protege.editor.core.ui.list.MList;
import org.protege.editor.core.ui.list.MListItem;
import org.protege.editor.core.ui.list.MListSectionHeader;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.util.FormLabel;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.util.VerifiedInputEditor;

public class OpenFromURLPanel
extends JPanel
implements VerifiedInputEditor {
    private static final int PREF_WIDTH = 500;
    private static final int PREF_HEIGHT = 300;
    private static final String TITLE = "Enter or select a URL";
    private static final String URL_FIELD_PLACEHOLDER = "Enter URL to open from";
    private static final String URL_FIELD_LABEL = "URL";
    private static final String BOOKMARKED_URLS_LABEL = "Bookmarked URLs";
    private JTextField uriField;
    private MList bookmarksList;
    private List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();

    public OpenFromURLPanel() {
        this.createUI();
    }

    private void createUI() {
        this.uriField = new AugmentedJTextField("", 45, URL_FIELD_PLACEHOLDER);
        this.uriField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent event) {
                OpenFromURLPanel.this.handleValueChanged();
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                OpenFromURLPanel.this.handleValueChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                OpenFromURLPanel.this.handleValueChanged();
            }
        });
        JPanel upperGroup = new JPanel(new BorderLayout());
        upperGroup.add((Component)new FormLabel(URL_FIELD_LABEL), "North");
        upperGroup.add((Component)this.uriField, "South");
        JPanel lowerGroup = new JPanel(new BorderLayout());
        lowerGroup.add((Component)new FormLabel(BOOKMARKED_URLS_LABEL), "North");
        this.bookmarksList = new MList(){

            @Override
            protected void handleAdd() {
                OpenFromURLPanel.this.addURI();
            }

            @Override
            protected void handleDelete() {
                OpenFromURLPanel.this.deleteSelectedBookmark();
            }
        };
        this.bookmarksList.setCellRenderer((ListCellRenderer)new BookmarkedItemListRenderer());
        JScrollPane scrollPane = new JScrollPane(this.bookmarksList);
        lowerGroup.add(scrollPane);
        this.fillList();
        this.bookmarksList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                this.updateTextField();
            }
        });
        this.setLayout(new BorderLayout(7, 7));
        this.add((Component)upperGroup, "North");
        this.add((Component)lowerGroup, "Center");
        this.setPreferredSize(new Dimension(500, 300));
    }

    private void handleValueChanged() {
        boolean validURI = this.isValidURI();
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(validURI);
        }
    }

    protected boolean isValidURI() {
        URI uri = this.getURI(false);
        return uri != null && uri.isAbsolute() && uri.getScheme() != null;
    }

    public URI getURI() {
        return this.getURI(true);
    }

    private URI getURI(boolean showMessage) {
        try {
            return new URI(this.uriField.getText().trim());
        }
        catch (URISyntaxException e) {
            if (showMessage) {
                this.showURIErrorMessage(e);
            }
            return null;
        }
    }

    private void updateTextField() {
        UrlListItem item = this.getSelUriListItem();
        if (item != null) {
            this.uriField.setText(item.uri.toString());
        }
    }

    private void addURI() {
        String uriString = JOptionPane.showInputDialog(this, "Please enter a URL", URL_FIELD_LABEL, -1);
        if (uriString != null) {
            try {
                URI uri = new URI(uriString);
                BookMarkedURIManager.getInstance().add(uri);
            }
            catch (URISyntaxException e) {
                this.showURIErrorMessage(e);
            }
            this.fillList();
        }
    }

    private void showURIErrorMessage(URISyntaxException e) {
        JOptionPane.showMessageDialog(this, e.getMessage(), "Invalid URL", 0);
    }

    private void fillList() {
        ArrayList<AddUrlItem> listData = new ArrayList<AddUrlItem>();
        listData.add(new AddUrlItem());
        OpenFromURLPanel.getBookmarkedUrls().sorted().map(UrlListItem::new).forEach(listData::add);
        this.bookmarksList.setListData(listData.toArray());
    }

    private static Stream<URI> getBookmarkedUrls() {
        BookMarkedURIManager man = BookMarkedURIManager.getInstance();
        return man.getBookMarkedURIs().stream();
    }

    private void deleteSelectedBookmark() {
        Object selObj = this.bookmarksList.getSelectedValue();
        if (!(selObj instanceof UrlListItem)) {
            return;
        }
        UrlListItem item = (UrlListItem)selObj;
        BookMarkedURIManager.getInstance().remove(item.uri);
        this.fillList();
    }

    private UrlListItem getSelUriListItem() {
        if (this.bookmarksList.getSelectedValue() instanceof UrlListItem) {
            return (UrlListItem)this.bookmarksList.getSelectedValue();
        }
        return null;
    }

    @Override
    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
        listener.verifiedStatusChanged(this.isValidURI());
    }

    @Override
    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public static URI showDialog() {
        OpenFromURLPanel panel = new OpenFromURLPanel();
        int ret = JOptionPaneEx.showValidatingConfirmDialog(null, TITLE, panel, -1, 2, panel.uriField);
        if (ret == 0) {
            return panel.getURI();
        }
        return null;
    }

    public static void main(String[] args) {
        OpenFromURLPanel.showDialog();
    }

    private static class UrlListItem
    implements MListItem {
        private final URI uri;

        public UrlListItem(URI uri) {
            this.uri = uri;
        }

        @Override
        public boolean isEditable() {
            return false;
        }

        @Override
        public void handleEdit() {
        }

        @Override
        public boolean isDeleteable() {
            return true;
        }

        @Override
        public boolean handleDelete() {
            return true;
        }

        @Override
        public String getTooltip() {
            return this.uri.toString();
        }
    }

    private static class AddUrlItem
    implements MListSectionHeader {
        private AddUrlItem() {
        }

        @Override
        public String getName() {
            return OpenFromURLPanel.BOOKMARKED_URLS_LABEL;
        }

        @Override
        public boolean canAdd() {
            return true;
        }
    }

    private static class BookmarkedItemListRenderer
    extends DefaultListCellRenderer {
        private BookmarkedItemListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof UrlListItem) {
                UrlListItem item = (UrlListItem)value;
                label.setText(item.uri.toString());
            }
            label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            return label;
        }
    }
}

