#!/usr/bin/bash
#
#   sccache.sh - Confirm presence of sccache binary
#
#   Copyright (c) 2011-2022 Pacman Development Team <pacman-dev@lists.archlinux.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

[[ -n "$LIBMAKEPKG_EXECUTABLE_SCCACHE_SH" ]] && return
LIBMAKEPKG_EXECUTABLE_SCCACHE_SH=1

MAKEPKG_LIBRARY=${MAKEPKG_LIBRARY:-'/usr/share/makepkg'}

source "$MAKEPKG_LIBRARY/util/message.sh"
source "$MAKEPKG_LIBRARY/util/option.sh"

executable_functions+=('executable_sccache')

executable_sccache() {
	if (( BUILDPKG )) && check_buildoption "sccache" "y"; then
		if ! type -p sccache >/dev/null; then
			error "$(gettext "Cannot find the %s binary required for compiler cache usage.")" "sccache"
			return 1
		fi
	fi
}
