#!/usr/bin/bash
#
#   sccache.sh - use sccache to cache Rust compilation
#
#   Copyright (c) 2024 Pacman Development Team <pacman-dev@lists.archlinux.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

[[ -n "$LIBMAKEPKG_BUILDENV_SCCACHE_SH" ]] && return
LIBMAKEPKG_BUILDENV_SCCACHE_SH=1

MAKEPKG_LIBRARY=${MAKEPKG_LIBRARY:-'/usr/share/makepkg'}

source "$MAKEPKG_LIBRARY/util/option.sh"

build_options+=('sccache')
buildenv_functions+=('buildenv_sccache')

buildenv_sccache() {
	if check_buildoption "sccache" "y"; then
		local sccache
		sccache="$(type -p sccache)"
		if [[ $RUSTC_WRAPPER == "$sccache" ]]; then
			return 0
		elif [[ ${RUSTC_WRAPPER+set} ]]; then
			error "$(gettext "%s option was requested but %s environment variable is already set to %s.")" "sccache" '$RUSTC_WRAPPER' "${RUSTC_WRAPPER@Q}"
			return 1
		fi
		export RUSTC_WRAPPER="$sccache"
	fi
}
