/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice.stylestatistic;

import com.sun.star.linguistic2.SingleProofreadingError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.ResultCache;
import org.languagetool.openoffice.stylestatistic.StatAnCache;
import org.languagetool.rules.AbstractStyleTooOftenUsedWordRule;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.TextLevelRule;

public class UsedWordRule {
    private static final int MAX_LIST_LENGTH = 50;
    private boolean debugMode = false;
    private static final ResourceBundle MESSAGES = JLanguageTool.getMessageBundle();
    private final TextLevelRule rule;
    private int procentualStep;
    private int optimalNumberWords;
    private boolean withDirectSpeech;
    private List<Map<String, Integer>> wordMapList = new ArrayList<Map<String, Integer>>();
    private List<String> excludedWords = new ArrayList<String>();
    private List<WordFrequency> mostUsed = new ArrayList<WordFrequency>();
    private String selectedWord;

    public UsedWordRule(TextLevelRule rule, StatAnCache cache) {
        this.rule = rule;
        this.withDirectSpeech = true;
        this.procentualStep = this.getDefaultRuleStep();
        this.optimalNumberWords = 3 * this.procentualStep;
    }

    public void generateBasicNumbers(StatAnCache cache) {
        try {
            if (this.rule instanceof AbstractStyleTooOftenUsedWordRule) {
                if (this.debugMode) {
                    MessageHandler.printToLogFile("withDirectSpeech: " + this.withDirectSpeech);
                }
                String langCode = cache.getDocShortCodeLanguage();
                for (int i = 0; i < cache.size(); ++i) {
                    if (langCode.equals(cache.getLanguageFlatParagraph(i))) {
                        this.rule.match(cache.getAnalysedParagraph(i), null);
                        this.wordMapList.add(new HashMap<String, Integer>(((AbstractStyleTooOftenUsedWordRule)this.rule).getWordMap()));
                        if (!this.debugMode) continue;
                        MessageHandler.printToLogFile("Paragraph " + i + ": Number of words: " + this.wordMapList.get(i).size());
                        continue;
                    }
                    this.wordMapList.add(new HashMap());
                }
                this.mostUsed = this.getMostUsed(0, cache.size());
            }
            cache.setNewResultcache(null, null);
        }
        catch (IOException e) {
            MessageHandler.showError(e);
        }
    }

    public void setWithDirectSpeach(boolean wDirectSpeech, StatAnCache cache) {
        if (this.debugMode) {
            MessageHandler.printToLogFile("withDirectSpeech: " + this.withDirectSpeech + ", wDirectSpeech: " + wDirectSpeech);
        }
        if (this.withDirectSpeech != wDirectSpeech) {
            this.withDirectSpeech = wDirectSpeech;
            ((AbstractStyleTooOftenUsedWordRule)this.rule).setWithoutDirectSpeech(!this.withDirectSpeech);
            if (this.debugMode) {
                MessageHandler.printToLogFile("Generate basic numbers");
            }
            this.generateBasicNumbers(cache);
        }
    }

    public void setListExcludedWords(List<String> words) {
        this.excludedWords.clear();
        if (words != null) {
            this.excludedWords.addAll(words);
        }
    }

    public boolean getDefaultDirectSpeach() {
        return true;
    }

    public static boolean isUsedWordRule(TextLevelRule rule) {
        return rule instanceof AbstractStyleTooOftenUsedWordRule;
    }

    private List<WordFrequency> getMostUsed(int from, int to) {
        HashMap<String, Integer> wordMap = new HashMap<String, Integer>();
        ArrayList<WordFrequency> wordList = new ArrayList<WordFrequency>();
        for (int i = from; i < to; ++i) {
            if (this.debugMode) {
                MessageHandler.printToLogFile("i = " + i + ": Number of words: " + this.wordMapList.get(i).keySet().size());
            }
            for (String word : this.wordMapList.get(i).keySet()) {
                if (this.excludedWords.contains(word)) continue;
                if (wordMap.containsKey(word)) {
                    int nWords = (Integer)wordMap.get(word);
                    wordMap.put(word, nWords += this.wordMapList.get(i).get(word).intValue());
                    continue;
                }
                wordMap.put(word, this.wordMapList.get(i).get(word));
            }
        }
        if (this.debugMode) {
            MessageHandler.printToLogFile("Number of words: " + wordMap.size());
        }
        int nWords = 0;
        for (String word : wordMap.keySet()) {
            nWords += ((Integer)wordMap.get(word)).intValue();
        }
        if (this.debugMode) {
            MessageHandler.printToLogFile("Number of words: " + nWords);
        }
        if (nWords < 1) {
            return wordList;
        }
        HashSet words = new HashSet(wordMap.keySet());
        int limit = 50 <= words.size() ? 50 : words.size();
        for (int i = 0; i < limit; ++i) {
            String mostUsed = null;
            int num = 0;
            for (String word : words) {
                int wordNum = (Integer)wordMap.get(word);
                if (wordNum <= num) continue;
                mostUsed = word;
                num = wordNum;
            }
            double percent = (double)num * 100.0 / (double)nWords;
            wordList.add(new WordFrequency(mostUsed, percent));
            words.remove(mostUsed);
        }
        return wordList;
    }

    public void refreshMostUsed(int from, int to) {
        this.mostUsed = this.getMostUsed(from, to);
    }

    public String[] getMostUsedWords() throws Throwable {
        String[] words = new String[this.mostUsed.size()];
        for (int i = 0; i < this.mostUsed.size(); ++i) {
            words[i] = String.format("%s (%.1f%%)", this.mostUsed.get((int)i).word, this.mostUsed.get((int)i).percent);
        }
        return words;
    }

    public String getMostUsedWord(int n) throws Throwable {
        return this.mostUsed.get((int)n).word;
    }

    public boolean isRelevantParagraph(int nTPara) {
        if (this.wordMapList.get(nTPara).get(this.selectedWord) == null) {
            return false;
        }
        return this.wordMapList.get(nTPara).get(this.selectedWord) > 0;
    }

    private int getDefaultRuleStep() {
        int defValue = this.rule.getDefaultValue();
        int defStep = (int)((double)defValue / 3.0 + 0.5);
        if (defStep < 1) {
            defStep = 1;
        }
        return defStep;
    }

    public int getDefaultStep() {
        int defStep = this.getDefaultRuleStep();
        if (this.debugMode) {
            MessageHandler.printToLogFile("default step: " + defStep);
        }
        return defStep;
    }

    public void setCurrentStep(int step) {
        if (step > 0) {
            this.procentualStep = step;
            this.optimalNumberWords = 3 * this.procentualStep;
        }
    }

    String getUnitString() {
        return "%";
    }

    public String getMessageOfLevel(int level) {
        String sLevel = null;
        if (this.rule instanceof ReadabilityRule) {
            return ((ReadabilityRule)this.rule).printMessageLevel(level);
        }
        int percent = this.optimalNumberWords + (3 - level) * this.procentualStep;
        if (level == 0) {
            sLevel = MESSAGES.getString("loStatisticalAnalysisNumber") + ": &gt " + percent + this.getUnitString();
        } else if (level >= 1 && level <= 5) {
            sLevel = MESSAGES.getString("loStatisticalAnalysisNumber") + ": " + (percent - this.procentualStep) + " - " + percent + this.getUnitString();
        } else if (level == 6) {
            sLevel = MESSAGES.getString("loStatisticalAnalysisNumber") + ": 0" + this.getUnitString();
        }
        return sLevel;
    }

    protected int getFoundWordsLevel(double percent) throws Throwable {
        if (percent > (double)(this.optimalNumberWords + 2 * this.procentualStep)) {
            return 0;
        }
        if (percent > (double)(this.optimalNumberWords + this.procentualStep)) {
            return 1;
        }
        if (percent > (double)this.optimalNumberWords) {
            return 2;
        }
        if (percent > (double)(this.optimalNumberWords - this.procentualStep)) {
            return 3;
        }
        if (percent > (double)(this.optimalNumberWords - 2 * this.procentualStep)) {
            return 4;
        }
        if (percent > (double)(this.optimalNumberWords - 3 * this.procentualStep)) {
            return 5;
        }
        return 6;
    }

    public int getLevel(int from, int to) throws Throwable {
        List<WordFrequency> mostUsed = this.getMostUsed(from, to);
        if (mostUsed.isEmpty()) {
            return 7;
        }
        double percent = 0.0;
        for (WordFrequency used : mostUsed) {
            if (!this.selectedWord.equals(used.word)) continue;
            percent = used.percent;
            break;
        }
        return this.getFoundWordsLevel(percent);
    }

    public void setWord(String word) {
        this.selectedWord = word;
    }

    public void setCacheForParagraph(int nFPara, int nTPara, StatAnCache cache) {
        ResultCache statAnalysisCache = new ResultCache();
        List<AnalyzedSentence> analyzedSentences = cache.getAnalysedParagraph(nTPara);
        if (analyzedSentences != null) {
            ArrayList<SingleProofreadingError> wordMatches = new ArrayList<SingleProofreadingError>();
            int nSentPos = 0;
            for (AnalyzedSentence sentence : analyzedSentences) {
                for (AnalyzedTokenReadings token : sentence.getTokens()) {
                    if (!token.hasLemma(this.selectedWord)) continue;
                    wordMatches.add(cache.createLoError(token.getStartPos() + nSentPos, token.getEndPos() - token.getStartPos(), this.rule.getId(), this.selectedWord, null));
                }
                nSentPos += sentence.getCorrectedTextLength();
            }
            statAnalysisCache.put(nFPara, wordMatches.toArray(new SingleProofreadingError[wordMatches.size()]));
        }
        cache.setNewResultcache(this.rule.getId(), statAnalysisCache);
    }

    public class WordFrequency {
        public String word;
        public double percent;

        WordFrequency(String word, double percent) {
            this.word = word;
            this.percent = percent;
        }
    }
}

