/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice.stylestatistic;

import com.sun.star.lang.XComponent;
import java.awt.AWTError;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.ViewCursorTools;
import org.languagetool.openoffice.stylestatistic.LevelRule;
import org.languagetool.openoffice.stylestatistic.StatAnCache;
import org.languagetool.openoffice.stylestatistic.StatAnConfiguration;
import org.languagetool.openoffice.stylestatistic.UsedWordRule;
import org.languagetool.rules.AbstractStatisticSentenceStyleRule;
import org.languagetool.rules.AbstractStatisticStyleRule;
import org.languagetool.rules.AbstractStyleTooOftenUsedWordRule;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.TextLevelRule;

public class StatAnDialog
extends Thread {
    private static final ResourceBundle MESSAGES = JLanguageTool.getMessageBundle();
    private static final boolean debugMode = false;
    private static final String dialogName = MESSAGES.getString("loStatisticalAnalysis");
    private static final int MIN_DIALOG_WIDTH = 640;
    private static final int MIN_DIALOG_HEIGHT = 420;
    private static final int MIN_OPTION_WIDTH = 260;
    private static final int MIN_OPTION_HEIGHT = 400;
    private JDialog dialog;
    private Container contentPane;
    private JPanel chapterPanel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel mainPanel;
    private JPanel colorPanel;
    private JScrollPane subChapterPane;
    private JLabel optionLabel;
    private JCheckBox withoutDirectSpeech;
    private JCheckBox showAdditionalOptions;
    private JCheckBox showParagraphsWithoutMatch;
    private JLabel stepLabel1;
    private JTextField stepField;
    private JLabel stepLabel2;
    private JButton defaultButton;
    private JButton setButton;
    private JButton ignore;
    private JButton removeAllIgnored;
    private JComboBox<String> function;
    private JComboBox<String> usedWords;
    private int from = 0;
    private int to = 1;
    private int hierarchy = 1;
    private int lastSinglePara = -1;
    private String lastParaText = null;
    private Chapter chapter = null;
    private static final List<TextLevelRule> rules = new ArrayList<TextLevelRule>();
    private StatAnCache cache = null;
    private StatAnConfiguration config = null;
    private XComponent lastComponent = null;
    private TextLevelRule selectedRule;
    private LevelRule levelRule;
    private UsedWordRule usedWordRule;
    private XComponent xComponent;
    private SingleDocument document;
    private int method = 0;
    private boolean isLevelRule = true;

    public StatAnDialog(SingleDocument document) {
        this.xComponent = document.getXComponent();
        this.document = document;
        document.getMultiDocumentsHandler().setStatAnDialogRunning(true);
        rules.clear();
        Language lang = document.getLanguage();
        if (lang != null) {
            try {
                HashMap<String, Integer> ruleValues = new HashMap<String, Integer>();
                for (Rule rule : lang.getRelevantRules(JLanguageTool.getMessageBundle(), null, lang, null)) {
                    if (!(rule instanceof AbstractStatisticSentenceStyleRule) && !(rule instanceof AbstractStatisticStyleRule) && !(rule instanceof ReadabilityRule) && !(rule instanceof AbstractStyleTooOftenUsedWordRule)) continue;
                    ruleValues.put(rule.getId(), 0);
                }
                UserConfig userConfig = new UserConfig(ruleValues);
                for (Rule rule : lang.getRelevantRules(JLanguageTool.getMessageBundle(), userConfig, lang, null)) {
                    if (!(rule instanceof AbstractStatisticSentenceStyleRule) && !(rule instanceof AbstractStatisticStyleRule) && (!(rule instanceof ReadabilityRule) || this.hasReadabilityRule()) && !(rule instanceof AbstractStyleTooOftenUsedWordRule)) continue;
                    rules.add((TextLevelRule)rule);
                }
            }
            catch (IOException e) {
                MessageHandler.showError(e);
            }
        }
    }

    private void closeDialog(MultiDocumentsHandler.WaitDialogThread waitdialog) {
        this.cache.setNewResultcache(null, null);
        this.dialog.setVisible(false);
        this.document.getMultiDocumentsHandler().setStatAnDialogRunning(false);
        waitdialog.close();
    }

    private boolean hasReadabilityRule() {
        for (Rule rule : rules) {
            if (!(rule instanceof ReadabilityRule)) continue;
            return true;
        }
        return false;
    }

    private void runDialog(final MultiDocumentsHandler.WaitDialogThread waitdialog) {
        if (rules.isEmpty()) {
            Language lang = this.document.getLanguage();
            String shortCode = lang == null ? "unknown" : lang.getShortCode();
            MessageHandler.printToLogFile("Statistical Rules are not supported for language: " + shortCode);
        }
        this.dialog = new JDialog();
        this.dialog.setName(dialogName);
        this.dialog.setTitle(dialogName);
        this.dialog.setMinimumSize(new Dimension(640, 420));
        this.dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                StatAnDialog.this.closeDialog(waitdialog);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.dialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                if (StatAnDialog.this.lastSinglePara < 0 || StatAnDialog.this.lastParaText.equals(StatAnDialog.this.document.getDocumentCache().getFlatParagraph(StatAnDialog.this.lastSinglePara))) {
                    return;
                }
                try {
                    if (StatAnDialog.this.isLevelRule) {
                        StatAnDialog.this.levelRule.generateBasicNumbers(StatAnDialog.this.cache);
                        StatAnDialog.this.setLeftLevelRulePanel();
                    } else {
                        StatAnDialog.this.usedWordRule.generateBasicNumbers(StatAnDialog.this.cache);
                        StatAnDialog.this.setLeftUsedWordRulePanel();
                    }
                    StatAnDialog.this.setRightRulePanel();
                    StatAnDialog.this.dialog.repaint();
                }
                catch (Throwable e1) {
                    MessageHandler.showError(e1);
                }
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (StatAnDialog.this.lastSinglePara >= 0) {
                    StatAnDialog.this.lastParaText = new String(StatAnDialog.this.document.getDocumentCache().getFlatParagraph(StatAnDialog.this.lastSinglePara));
                }
            }
        });
        try {
            this.config = new StatAnConfiguration(rules);
            if (this.cache == null || this.lastComponent == null || !this.lastComponent.equals(this.xComponent)) {
                this.lastComponent = this.xComponent;
                this.refreshCache(this.document, waitdialog);
            }
            this.selectedRule = rules.get(this.method);
            this.isLevelRule = this.isLevelRule(this.selectedRule);
            if (this.isLevelRule) {
                this.levelRule = new LevelRule(this.selectedRule, this.cache);
            } else {
                this.usedWordRule = new UsedWordRule(this.selectedRule, this.cache);
            }
            this.configRule();
            if (this.isLevelRule) {
                this.levelRule.generateBasicNumbers(this.cache);
            } else {
                this.usedWordRule.generateBasicNumbers(this.cache);
            }
        }
        catch (Throwable e1) {
            MessageHandler.showError(e1);
            this.closeDialog(waitdialog);
        }
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons2 = new GridBagConstraints();
        cons2.insets = new Insets(2, 4, 2, 4);
        cons2.gridx = 0;
        cons2.gridy = 0;
        cons2.fill = 1;
        cons2.anchor = 18;
        cons2.weightx = 10.0;
        cons2.weighty = 10.0;
        this.leftPanel = new JPanel();
        this.rightPanel = new JPanel();
        if (this.isLevelRule) {
            this.levelRule = new LevelRule(this.selectedRule, this.cache);
            this.configRule();
            this.levelRule.generateBasicNumbers(this.cache);
            this.setLeftLevelRulePanel();
        } else {
            this.usedWordRule = new UsedWordRule(this.selectedRule, this.cache);
            this.configRule();
            this.usedWordRule.generateBasicNumbers(this.cache);
            this.setLeftUsedWordRulePanel();
        }
        this.setRightRulePanel();
        this.mainPanel.add((Component)this.leftPanel, cons2);
        ++cons2.gridx;
        cons2.fill = 0;
        cons2.anchor = 12;
        cons2.weightx = 0.0;
        cons2.weighty = 0.0;
        this.rightPanel.setMinimumSize(new Dimension(260, 400));
        this.mainPanel.add((Component)this.rightPanel, cons2);
        this.contentPane = this.dialog.getContentPane();
        this.contentPane.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        cons.anchor = 18;
        cons.insets = new Insets(2, 6, 2, 6);
        this.function = new JComboBox<String>(this.getAllRuleNames());
        this.function.setSelectedIndex(this.method);
        this.function.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String selectedRuleName = (String)this.function.getSelectedItem();
                if (!this.selectedRule.getDescription().equals(selectedRuleName)) {
                    this.selectedRule = this.getRuleByName(selectedRuleName);
                    this.method = this.getMethodByRule(selectedRuleName);
                    this.isLevelRule = this.isLevelRule(this.selectedRule);
                    try {
                        if (this.isLevelRule) {
                            this.levelRule = new LevelRule(this.selectedRule, this.cache);
                            this.configRule();
                            this.levelRule.generateBasicNumbers(this.cache);
                            this.setLeftLevelRulePanel();
                        } else {
                            this.usedWordRule = new UsedWordRule(this.selectedRule, this.cache);
                            this.configRule();
                            this.usedWordRule.generateBasicNumbers(this.cache);
                            this.setLeftUsedWordRulePanel();
                        }
                        this.setRightRulePanel();
                        this.dialog.repaint();
                    }
                    catch (Throwable e1) {
                        MessageHandler.showError(e1);
                    }
                }
            }
        });
        this.contentPane.add(this.function, cons);
        ++cons.gridy;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        cons.fill = 1;
        cons.anchor = 18;
        cons.insets = new Insets(2, 6, 2, 6);
        this.contentPane.add((Component)this.mainPanel, cons);
        ++cons.gridy;
        cons.fill = 0;
        cons.anchor = 14;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        ++cons.gridy;
        JButton closeButton = new JButton(MESSAGES.getString("loStatisticalAnalysisCloseButton"));
        closeButton.addActionListener(e -> this.closeDialog(waitdialog));
        this.contentPane.add((Component)closeButton, cons);
        this.dialog.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.dialog.getSize();
        this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
        this.dialog.setLocationByPlatform(true);
    }

    private void setLeftLevelRulePanel() {
        if (this.chapter == null && LevelRule.hasStatisticalOptions(this.selectedRule)) {
            this.levelRule.setWithDirectSpeach(!this.config.isWithoutDirectSpeech(this.selectedRule), this.cache);
            this.levelRule.setCurrentStep(this.config.getLevelStep(this.selectedRule));
        }
        this.leftPanel.removeAll();
        this.leftPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons11 = new GridBagConstraints();
        cons11.insets = new Insets(14, 6, 2, 6);
        cons11.gridx = 0;
        cons11.gridy = 0;
        cons11.anchor = 18;
        cons11.fill = 2;
        cons11.weightx = 0.0;
        cons11.weighty = 0.0;
        this.leftPanel.add((Component)new JLabel(MESSAGES.getString("loStatisticalAnalysisChapterLabel") + ":"), cons11);
        ++cons11.gridy;
        cons11.weightx = 0.0;
        cons11.weighty = 0.0;
        cons11.insets = new Insets(2, 6, 2, 6);
        cons11.anchor = 18;
        cons11.fill = 2;
        this.chapterPanel = new JPanel();
        try {
            this.setChapterPanel(this.chapter);
        }
        catch (Throwable e1) {
            MessageHandler.showError(e1);
        }
        this.leftPanel.add((Component)this.chapterPanel, cons11);
        ++cons11.gridy;
        cons11.weightx = 0.0;
        cons11.weighty = 0.0;
        cons11.insets = new Insets(14, 6, 2, 6);
        JLabel subChapterLabel = new JLabel(MESSAGES.getString("loStatisticalAnalysisSubchapterLabel") + ":");
        this.leftPanel.add((Component)subChapterLabel, cons11);
        ++cons11.gridy;
        cons11.weightx = 1.0;
        cons11.weighty = 1.0;
        cons11.anchor = 18;
        cons11.fill = 1;
        cons11.insets = new Insets(2, 6, 2, 6);
        this.subChapterPane = new JScrollPane();
        this.subChapterPane.setMinimumSize(new Dimension(0, 30));
        try {
            this.subChapterPane.setViewportView(this.getSubChapterPanel(0, this.cache.size(), 1, null));
        }
        catch (Throwable e1) {
            MessageHandler.showError(e1);
        }
        this.leftPanel.add((Component)this.subChapterPane, cons11);
        this.leftPanel.validate();
    }

    private void setLeftUsedWordRulePanel() {
        try {
            this.usedWordRule.setWithDirectSpeach(!this.config.isWithoutDirectSpeech(this.selectedRule), this.cache);
            this.usedWordRule.setListExcludedWords(this.config.getExcludedWords(this.selectedRule));
            this.leftPanel.removeAll();
            this.leftPanel.setLayout(new GridBagLayout());
            GridBagConstraints cons11 = new GridBagConstraints();
            cons11.insets = new Insets(14, 6, 2, 6);
            cons11.gridx = 0;
            cons11.gridy = 0;
            cons11.anchor = 18;
            cons11.fill = 2;
            cons11.weightx = 0.0;
            cons11.weighty = 0.0;
            this.leftPanel.add((Component)new JLabel(MESSAGES.getString("loStatisticalAnalysisMostUsedWords") + ":"), cons11);
            String[] mostUsedWords = null;
            mostUsedWords = this.usedWordRule.getMostUsedWords();
            this.usedWords = new JComboBox<String>(mostUsedWords);
            this.usedWords.addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    int selectedIndex = this.usedWords.getSelectedIndex();
                    try {
                        this.usedWordRule.setWord(this.usedWordRule.getMostUsedWord(selectedIndex));
                        this.setChapterPanel(this.chapter);
                        this.subChapterPane.setViewportView(this.getSubChapterPanel(0, this.cache.size(), 1, null));
                        this.dialog.repaint();
                    }
                    catch (Throwable e1) {
                        MessageHandler.showError(e1);
                    }
                }
            });
            if (mostUsedWords != null && mostUsedWords.length > 0) {
                this.usedWords.setSelectedIndex(0);
                this.usedWordRule.setWord(this.usedWordRule.getMostUsedWord(0));
            }
            ++cons11.gridy;
            cons11.weightx = 0.0;
            cons11.weighty = 0.0;
            cons11.anchor = 18;
            cons11.fill = 1;
            cons11.insets = new Insets(2, 6, 2, 6);
            this.leftPanel.add(this.usedWords, cons11);
            ++cons11.gridy;
            cons11.anchor = 18;
            cons11.fill = 2;
            cons11.weightx = 0.0;
            cons11.weighty = 0.0;
            this.leftPanel.add((Component)new JLabel(MESSAGES.getString("loStatisticalAnalysisChapterLabel") + ":"), cons11);
            ++cons11.gridy;
            cons11.weightx = 0.0;
            cons11.weighty = 0.0;
            cons11.insets = new Insets(2, 6, 2, 6);
            cons11.anchor = 18;
            cons11.fill = 2;
            this.chapterPanel = new JPanel();
            this.setChapterPanel(this.chapter);
            this.leftPanel.add((Component)this.chapterPanel, cons11);
            ++cons11.gridy;
            cons11.weightx = 0.0;
            cons11.weighty = 0.0;
            cons11.insets = new Insets(14, 6, 2, 6);
            JLabel subChapterLabel = new JLabel(MESSAGES.getString("loStatisticalAnalysisSubchapterLabel") + ":");
            this.leftPanel.add((Component)subChapterLabel, cons11);
            ++cons11.gridy;
            cons11.weightx = 1.0;
            cons11.weighty = 1.0;
            cons11.anchor = 18;
            cons11.fill = 1;
            cons11.insets = new Insets(2, 6, 2, 6);
            this.subChapterPane = new JScrollPane();
            this.subChapterPane.setMinimumSize(new Dimension(0, 30));
            this.subChapterPane.setViewportView(this.getSubChapterPanel(0, this.cache.size(), 1, null));
            this.leftPanel.add((Component)this.subChapterPane, cons11);
            this.leftPanel.validate();
        }
        catch (Throwable e1) {
            MessageHandler.showError(e1);
        }
    }

    private void setRightRulePanel() {
        this.rightPanel.removeAll();
        this.rightPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons20 = new GridBagConstraints();
        cons20.insets = new Insets(2, 4, 2, 4);
        cons20.gridx = 0;
        cons20.gridy = 0;
        cons20.fill = 0;
        cons20.anchor = 18;
        cons20.weightx = 0.0;
        cons20.weighty = 0.0;
        JPanel optionPanel = new JPanel();
        optionPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons21 = new GridBagConstraints();
        cons21.insets = new Insets(4, 4, 4, 4);
        cons21.gridx = 0;
        cons21.gridy = 0;
        cons21.fill = 0;
        cons21.anchor = 18;
        cons21.weightx = 0.0;
        cons21.weighty = 0.0;
        this.optionLabel = new JLabel(MESSAGES.getString("loStatisticalAnalysisOptionsLabel") + ":");
        optionPanel.add((Component)this.optionLabel, cons21);
        this.withoutDirectSpeech = new JCheckBox(MESSAGES.getString("loStatisticalAnalysisWithoutDirectSpreech"));
        if (this.config == null) {
            MessageHandler.showMessage("config == null");
        }
        JPanel stepPanel = new JPanel();
        stepPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons22 = new GridBagConstraints();
        cons22.insets = new Insets(0, 2, 0, 2);
        cons22.gridx = 0;
        cons22.gridy = 0;
        cons22.fill = 0;
        cons22.anchor = 18;
        cons22.weightx = 0.0;
        cons22.weighty = 0.0;
        this.stepLabel1 = new JLabel(MESSAGES.getString("loStatisticalAnalysisLevels") + ": ");
        this.stepField = new JTextField("", 3);
        this.stepLabel2 = new JLabel();
        this.setButton = new JButton(MESSAGES.getString("loStatisticalAnalysisSetButton"));
        stepPanel.add((Component)this.stepLabel1, cons22);
        ++cons22.gridx;
        stepPanel.add((Component)this.stepField, cons22);
        ++cons22.gridx;
        stepPanel.add((Component)this.stepLabel2, cons22);
        ++cons21.gridy;
        optionPanel.add((Component)stepPanel, cons21);
        ++cons21.gridx;
        optionPanel.add((Component)this.setButton, cons21);
        cons21.gridx = 0;
        ++cons21.gridy;
        optionPanel.add((Component)this.withoutDirectSpeech, cons21);
        ++cons21.gridx;
        this.defaultButton = new JButton(MESSAGES.getString("loStatisticalAnalysisDefaultButton"));
        optionPanel.add((Component)this.defaultButton, cons21);
        this.rightPanel.add((Component)optionPanel, cons20);
        if (this.isLevelRule) {
            this.setLevelRuleOptions();
        } else {
            cons20.gridx = 0;
            ++cons20.gridy;
            this.ignore = new JButton(MESSAGES.getString("loStatisticalAnalysisIgnoreWordButton"));
            this.removeAllIgnored = new JButton(MESSAGES.getString("loStatisticalAnalysisResetIgnoredWordsButton"));
            this.removeAllIgnored.setEnabled(this.config.getExcludedWords(this.selectedRule).size() > 0);
            this.rightPanel.add((Component)this.removeAllIgnored, cons20);
            ++cons20.gridy;
            this.rightPanel.add((Component)this.ignore, cons20);
            this.setUsedWordRuleOptions();
        }
        ++cons20.gridy;
        this.showAdditionalOptions = new JCheckBox("Show additional Options");
        this.showParagraphsWithoutMatch = new JCheckBox("Show paragraphs without matches");
        this.showParagraphsWithoutMatch.setVisible(false);
        this.showAdditionalOptions.setSelected(this.config.showAdditionalOptions());
        this.showAdditionalOptions.addActionListener(e -> {
            this.colorPanel.setVisible(this.showAdditionalOptions.isSelected());
            this.showParagraphsWithoutMatch.setVisible(this.showAdditionalOptions.isSelected());
            this.config.setShowAdditionalOptions(this.showAdditionalOptions.isSelected());
        });
        this.showParagraphsWithoutMatch.setSelected(this.config.showAllParagraphs());
        this.showParagraphsWithoutMatch.addActionListener(e -> {
            this.config.setShowAllParagraphs(this.showParagraphsWithoutMatch.isSelected());
            try {
                this.runLevelSubDialog(null);
            }
            catch (Throwable e1) {
                MessageHandler.printException(e1);
            }
        });
        ++cons20.gridy;
        this.rightPanel.add((Component)this.showAdditionalOptions, cons20);
        ++cons20.gridy;
        this.rightPanel.add((Component)this.showParagraphsWithoutMatch, cons20);
        ++cons20.gridy;
        cons20.insets = new Insets(6, 4, 2, 4);
        this.rightPanel.add((Component)this.getColorOptionsPanel(), cons20);
        this.rightPanel.validate();
    }

    private void setLevelRuleOptions() {
        if (LevelRule.isLevelRule(this.selectedRule) && LevelRule.hasStatisticalOptions(this.selectedRule)) {
            this.defaultButton.addActionListener(e -> {
                if (this.levelRule.getDefaultDirectSpeach() == this.withoutDirectSpeech.isSelected() || this.levelRule.getDefaultStep() != this.config.getLevelStep(this.selectedRule)) {
                    this.withoutDirectSpeech.setSelected(!this.levelRule.getDefaultDirectSpeach());
                    this.config.setWithoutDirectSpeech(this.selectedRule, !this.levelRule.getDefaultDirectSpeach());
                    this.config.setLevelStep(this.selectedRule, this.levelRule.getDefaultStep());
                    this.stepField.setText(Integer.toString(this.levelRule.getDefaultStep()));
                    try {
                        this.config.saveConfiguration();
                        this.levelRule.setWithDirectSpeach(!this.levelRule.getDefaultDirectSpeach(), this.cache);
                        this.levelRule.setCurrentStep(this.levelRule.getDefaultStep());
                        this.runLevelSubDialog(null);
                    }
                    catch (Throwable t) {
                        MessageHandler.showError(t);
                    }
                }
            });
            this.setButton.addActionListener(e -> {
                int levelStep = Integer.parseInt(this.stepField.getText().trim());
                if (levelStep > 0 && levelStep < 100) {
                    this.config.setLevelStep(this.selectedRule, levelStep);
                    try {
                        this.config.saveConfiguration();
                        this.levelRule.setCurrentStep(levelStep);
                        this.runLevelSubDialog(null);
                    }
                    catch (Throwable t) {
                        MessageHandler.showError(t);
                    }
                } else {
                    this.stepField.setText(Integer.toString(this.config.getLevelStep(this.selectedRule)));
                }
            });
            this.withoutDirectSpeech.setSelected(this.config.isWithoutDirectSpeech(this.selectedRule));
            this.withoutDirectSpeech.addActionListener(e -> {
                this.config.setWithoutDirectSpeech(this.selectedRule, this.withoutDirectSpeech.isSelected());
                try {
                    this.config.saveConfiguration();
                    this.levelRule.setWithDirectSpeach(!this.withoutDirectSpeech.isSelected(), this.cache);
                    this.runLevelSubDialog(null);
                }
                catch (Throwable t) {
                    MessageHandler.showError(t);
                }
            });
            int nStep = 0;
            String sStep = "%";
            if (LevelRule.hasStatisticalOptions(this.selectedRule)) {
                nStep = this.config.getLevelStep(this.selectedRule);
                sStep = this.levelRule.getUnitString();
            }
            this.stepField.setText(Integer.toString(nStep));
            this.stepLabel2.setText(sStep);
            this.defaultButton.setEnabled(true);
            this.stepLabel1.setEnabled(true);
            this.stepField.setEnabled(true);
            this.stepLabel2.setEnabled(true);
            this.setButton.setEnabled(true);
            this.withoutDirectSpeech.setEnabled(true);
            this.optionLabel.setEnabled(true);
        } else {
            this.defaultButton.setEnabled(false);
            this.stepLabel1.setEnabled(false);
            this.stepField.setEnabled(false);
            this.stepLabel2.setEnabled(false);
            this.setButton.setEnabled(false);
            this.withoutDirectSpeech.setEnabled(false);
            this.optionLabel.setEnabled(false);
        }
    }

    private void setUsedWordRuleOptions() {
        this.defaultButton.addActionListener(e -> {
            if (this.usedWordRule.getDefaultDirectSpeach() == this.withoutDirectSpeech.isSelected() || this.usedWordRule.getDefaultStep() != this.config.getLevelStep(this.selectedRule)) {
                this.withoutDirectSpeech.setSelected(!this.usedWordRule.getDefaultDirectSpeach());
                this.config.setWithoutDirectSpeech(this.selectedRule, !this.usedWordRule.getDefaultDirectSpeach());
                this.config.setLevelStep(this.selectedRule, this.usedWordRule.getDefaultStep());
                this.stepField.setText(Integer.toString(this.usedWordRule.getDefaultStep()));
                try {
                    this.config.saveConfiguration();
                    this.usedWordRule.setWithDirectSpeach(!this.usedWordRule.getDefaultDirectSpeach(), this.cache);
                    this.usedWordRule.setCurrentStep(this.usedWordRule.getDefaultStep());
                    this.runLevelSubDialog(null);
                }
                catch (Throwable t) {
                    MessageHandler.showError(t);
                }
            }
        });
        this.setButton.addActionListener(e -> {
            int levelStep = Integer.parseInt(this.stepField.getText().trim());
            if (levelStep > 0 && levelStep < 100) {
                this.config.setLevelStep(this.selectedRule, levelStep);
                try {
                    this.config.saveConfiguration();
                    this.usedWordRule.setCurrentStep(levelStep);
                    this.runLevelSubDialog(null);
                }
                catch (Throwable t) {
                    MessageHandler.showError(t);
                }
            } else {
                this.stepField.setText(Integer.toString(this.config.getLevelStep(this.selectedRule)));
            }
        });
        this.withoutDirectSpeech.setSelected(this.config.isWithoutDirectSpeech(this.selectedRule));
        this.withoutDirectSpeech.addActionListener(e -> {
            this.config.setWithoutDirectSpeech(this.selectedRule, this.withoutDirectSpeech.isSelected());
            try {
                this.config.saveConfiguration();
                this.usedWordRule.setWithDirectSpeach(!this.withoutDirectSpeech.isSelected(), this.cache);
                this.runLevelSubDialog(null);
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        });
        this.ignore.addActionListener(e -> {
            if (this.usedWords.getItemCount() > 0) {
                try {
                    String word = this.usedWordRule.getMostUsedWord(this.usedWords.getSelectedIndex());
                    this.config.addExcludedWord(this.selectedRule, word);
                    this.config.saveConfiguration();
                    this.usedWordRule.setListExcludedWords(this.config.getExcludedWords(this.selectedRule));
                    this.usedWordRule.refreshMostUsed(0, this.cache.size());
                    this.usedWords.removeAllItems();
                    for (String usedWord : this.usedWordRule.getMostUsedWords()) {
                        this.usedWords.addItem(usedWord);
                    }
                    this.usedWords.setSelectedIndex(0);
                    this.removeAllIgnored.setEnabled(true);
                }
                catch (Throwable t) {
                    MessageHandler.showError(t);
                }
            }
        });
        this.removeAllIgnored.addActionListener(e -> {
            try {
                this.config.removeAllExcludedWords(this.selectedRule);
                this.config.saveConfiguration();
                this.usedWordRule.setListExcludedWords(this.config.getExcludedWords(this.selectedRule));
                this.usedWordRule.refreshMostUsed(0, this.cache.size());
                this.usedWords.removeAllItems();
                for (String usedWord : this.usedWordRule.getMostUsedWords()) {
                    this.usedWords.addItem(usedWord);
                }
                this.usedWords.setSelectedIndex(0);
                this.removeAllIgnored.setEnabled(false);
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        });
        int nStep = 0;
        String sStep = "%";
        nStep = this.config.getLevelStep(this.selectedRule);
        this.stepField.setText(Integer.toString(nStep));
        this.stepLabel2.setText(sStep);
        this.defaultButton.setEnabled(true);
        this.stepLabel1.setEnabled(true);
        this.stepField.setEnabled(true);
        this.stepLabel2.setEnabled(true);
        this.setButton.setEnabled(true);
        this.withoutDirectSpeech.setEnabled(true);
        this.optionLabel.setEnabled(true);
        if (this.usedWords.getItemCount() > 0) {
            this.ignore.setEnabled(true);
        } else {
            this.ignore.setEnabled(false);
        }
        List<String> exWords = this.config.getExcludedWords(this.selectedRule);
        if (exWords != null && !exWords.isEmpty()) {
            this.removeAllIgnored.setEnabled(true);
        } else {
            this.removeAllIgnored.setEnabled(false);
        }
    }

    @Override
    public void run() {
        try {
            MultiDocumentsHandler multiDocumentsHandler = this.document.getMultiDocumentsHandler();
            multiDocumentsHandler.getClass();
            MultiDocumentsHandler.WaitDialogThread waitdialog = new MultiDocumentsHandler.WaitDialogThread(multiDocumentsHandler, "Please wait", MESSAGES.getString("loWaitMessage"));
            waitdialog.start();
            this.runDialog(waitdialog);
            waitdialog.close();
            this.dialog.setVisible(true);
        }
        catch (Throwable e) {
            MessageHandler.showError(e);
        }
    }

    private void configRule() {
        if (UsedWordRule.isUsedWordRule(this.selectedRule)) {
            this.usedWordRule.setWithDirectSpeach(!this.config.isWithoutDirectSpeech(this.selectedRule), this.cache);
            this.usedWordRule.setListExcludedWords(this.config.getExcludedWords(this.selectedRule));
            int step = this.config.getLevelStep(this.selectedRule);
            if (step > 0) {
                this.usedWordRule.setCurrentStep(step);
            }
        } else if (LevelRule.isLevelRule(this.selectedRule) && LevelRule.hasStatisticalOptions(this.selectedRule)) {
            this.levelRule.setWithDirectSpeach(!this.config.isWithoutDirectSpeech(this.selectedRule), this.cache);
            int step = this.config.getLevelStep(this.selectedRule);
            if (step > 0) {
                this.levelRule.setCurrentStep(step);
            }
        }
    }

    public void refreshCache(SingleDocument document, MultiDocumentsHandler.WaitDialogThread waitdialog) throws Throwable {
        StatAnDialog.setJavaLookAndFeel();
        this.cache = new StatAnCache(document, this.config, waitdialog);
    }

    private void runLevelSubDialog(Chapter chapter) throws Throwable {
        if (chapter != null && chapter.hierarchy < 0) {
            ViewCursorTools viewCursor = new ViewCursorTools(this.xComponent);
            DocumentCache.TextParagraph tPara = new DocumentCache.TextParagraph(4, chapter.from);
            viewCursor.setTextViewCursor(0, tPara);
            this.lastSinglePara = this.document.getDocumentCache().getFlatParagraphNumber(tPara);
            if (!this.isLevelRule) {
                this.usedWordRule.setCacheForParagraph(this.lastSinglePara, chapter.from, this.cache);
            }
            this.cache.markParagraph(this.lastSinglePara, this.config.getUnderlineType(), this.config.getUnderlineColor());
            return;
        }
        this.lastSinglePara = -1;
        UIManager.put("ToolTip.foreground", Color.black);
        UIManager.put("ToolTip.background", Color.yellow);
        this.hierarchy = chapter == null ? 0 : chapter.hierarchy;
        this.setChapterPanel(chapter);
        if (chapter == null) {
            this.from = 0;
            this.to = this.cache.size();
            this.hierarchy = 1;
        } else {
            this.from = chapter.from + 1;
            this.to = chapter.to;
            this.hierarchy = chapter.hierarchy + 1;
        }
        this.subChapterPane.setViewportView(this.getSubChapterPanel(this.from, this.to, this.hierarchy, chapter));
        this.dialog.repaint();
    }

    private Color getBackgroundColor(int weight) {
        Color col = weight == 0 ? new Color(255, 0, 0) : (weight == 1 ? new Color(255, 150, 0) : (weight == 2 ? new Color(255, 200, 0) : (weight == 3 ? new Color(255, 255, 150) : (weight == 4 ? new Color(200, 255, 150) : (weight == 5 ? new Color(150, 255, 200) : (weight == 6 ? new Color(0, 0, 255) : new Color(255, 255, 255)))))));
        return col;
    }

    private Color getForegroundColor(int weight) {
        Color col = weight == 0 || weight == 6 ? Color.WHITE : Color.BLACK;
        return col;
    }

    private void setChapterPanel(final Chapter chapter) throws Throwable {
        String chapterTitle;
        int weight;
        this.chapterPanel.removeAll();
        this.chapterPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(4, 0, 4, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.0;
        cons.weighty = 0.0;
        cons.anchor = 18;
        cons.fill = 0;
        if (chapter == null) {
            weight = this.getWeight(0, this.cache.size());
            chapterTitle = MESSAGES.getString("loStatisticalAnalysisEntireDocument");
        } else {
            weight = this.getWeight(chapter.from + 1, chapter.to);
            chapterTitle = chapter.name;
        }
        final JLabel fullChapter = new JLabel(chapterTitle);
        fullChapter.setOpaque(true);
        fullChapter.setBackground(this.getBackgroundColor(weight));
        fullChapter.setForeground(this.getForegroundColor(weight));
        fullChapter.setMinimumSize(new Dimension(300, 60));
        fullChapter.setHorizontalAlignment(0);
        fullChapter.setToolTipText(this.getToolTippText(weight));
        if (chapter != null) {
            fullChapter.setCursor(Cursor.getPredefinedCursor(12));
            fullChapter.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        StatAnDialog.this.runLevelSubDialog(chapter.parent);
                    }
                    catch (Throwable e1) {
                        MessageHandler.showError(e1);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    fullChapter.setForeground(Color.GRAY);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    fullChapter.setForeground(StatAnDialog.this.getForegroundColor(weight));
                }
            });
        }
        this.chapterPanel.add((Component)fullChapter, cons);
        this.chapterPanel.setBackground(this.getBackgroundColor(weight));
        this.chapterPanel.revalidate();
    }

    private JPanel getSubChapterPanel(int from, int to, int hierarchy, Chapter parent) throws Throwable {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(2, 0, 2, 0);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.anchor = 18;
        cons.fill = 1;
        cons.weightx = 10.0;
        cons.weighty = 10.0;
        List<Chapter> chapters = this.getChapters(from, to, hierarchy, parent);
        ArrayList<JLabel> chapterButton = new ArrayList<JLabel>();
        int nButton = 0;
        for (final Chapter chapter : chapters) {
            if (chapter.hierarchy < 0 && !this.config.showAllParagraphs() && !this.cache.isRelevantParagraph(chapter.from, this.selectedRule, this.usedWordRule)) continue;
            chapterButton.add(new JLabel(chapter.name));
            final JLabel label = (JLabel)chapterButton.get(nButton);
            ((JLabel)chapterButton.get(nButton)).setOpaque(true);
            ((JLabel)chapterButton.get(nButton)).setCursor(Cursor.getPredefinedCursor(12));
            ((JLabel)chapterButton.get(nButton)).setHorizontalAlignment(0);
            ((JLabel)chapterButton.get(nButton)).setBackground(this.getBackgroundColor(chapter.weight));
            ((JLabel)chapterButton.get(nButton)).setForeground(this.getForegroundColor(chapter.weight));
            ((JLabel)chapterButton.get(nButton)).setBorder(BorderFactory.createLineBorder(this.getBackgroundColor(chapter.weight)));
            ((JLabel)chapterButton.get(nButton)).setToolTipText(this.getToolTippText(chapter.weight));
            ((JLabel)chapterButton.get(nButton)).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    try {
                        StatAnDialog.this.runLevelSubDialog(chapter);
                    }
                    catch (Throwable e1) {
                        MessageHandler.showError(e1);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    label.setForeground(Color.GRAY);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    label.setForeground(StatAnDialog.this.getForegroundColor(chapter.weight));
                }
            });
            panel.add((Component)chapterButton.get(nButton), cons);
            ++cons.gridy;
            ++nButton;
        }
        return panel;
    }

    private int getWeight(int from, int to) throws Throwable {
        if (UsedWordRule.isUsedWordRule(this.selectedRule)) {
            return this.usedWordRule.getLevel(from, to);
        }
        return this.levelRule.getLevel(from, to);
    }

    private String getToolTippText(int weight) {
        String txt;
        String string = txt = UsedWordRule.isUsedWordRule(this.selectedRule) ? this.usedWordRule.getMessageOfLevel(weight) : this.levelRule.getMessageOfLevel(weight);
        if (txt == null) {
            txt = MESSAGES.getString("loStatisticalAnalysisNotAnalyzed");
        }
        return "<html><div style='color:black;'>" + txt + "</html>";
    }

    private List<Chapter> getChaptersOfHierarchy(int from, int to, int hierarchy, Chapter parent) throws Throwable {
        int start;
        ArrayList<Chapter> sameHeadings = new ArrayList<Chapter>();
        List<StatAnCache.Paragraph> paragraphs = this.cache.getParagraphsfrom(from, to);
        String lastHeading = null;
        int lastNum = 0;
        for (StatAnCache.Paragraph paragraph : paragraphs) {
            if (paragraph.hierarchy != hierarchy) continue;
            if (lastHeading != null) {
                start = lastNum + (hierarchy < 0 ? 0 : 1);
                long startTime = System.currentTimeMillis();
                int weight = this.getWeight(start, paragraph.paraNum);
                sameHeadings.add(new Chapter(lastHeading, lastNum, paragraph.paraNum, hierarchy, weight, parent));
            }
            lastHeading = paragraph.name;
            lastNum = paragraph.paraNum;
        }
        if (lastHeading != null) {
            long startTime = System.currentTimeMillis();
            start = lastNum + (hierarchy < 0 ? 0 : 1);
            int end = paragraphs.get((int)(paragraphs.size() - 1)).paraNum + 1;
            if (end > this.cache.size()) {
                end = this.cache.size();
            }
            int weight = this.getWeight(start, end);
            sameHeadings.add(new Chapter(lastHeading, lastNum, end, hierarchy, weight, parent));
        }
        return sameHeadings;
    }

    private List<Chapter> getChapters(int from, int to, int hierarchy, Chapter parent) throws Throwable {
        List<StatAnCache.Heading> headings = this.cache.getAllHeadings();
        if (hierarchy == 0) {
            hierarchy = 1;
        }
        int minHierarchy = 10000;
        for (StatAnCache.Heading heading : headings) {
            if (heading.hierarchy >= hierarchy && heading.hierarchy < minHierarchy) {
                minHierarchy = heading.hierarchy;
            }
            if (minHierarchy != hierarchy) continue;
            break;
        }
        hierarchy = minHierarchy < 10000 ? minHierarchy : -1;
        List<Chapter> chapters = this.getChaptersOfHierarchy(from, to, hierarchy, parent);
        return chapters;
    }

    String[] getAllRuleNames() {
        String[] ruleNames = new String[rules.size()];
        for (int i = 0; i < rules.size(); ++i) {
            ruleNames[i] = rules.get(i).getDescription();
        }
        return ruleNames;
    }

    boolean isLevelRule(Rule rule) {
        return LevelRule.isLevelRule(rule);
    }

    String[] getAllLevelRuleNames() {
        ArrayList<String> levelRules = new ArrayList<String>();
        for (Rule rule : rules) {
            if (!LevelRule.isLevelRule(rule)) continue;
            levelRules.add(rule.getDescription());
        }
        return levelRules.toArray(new String[levelRules.size()]);
    }

    TextLevelRule getRuleByName(String name) {
        for (TextLevelRule rule : rules) {
            if (!name.equals(rule.getDescription())) continue;
            return rule;
        }
        return null;
    }

    int getMethodByRule(String name) {
        int method = 0;
        for (Rule rule : rules) {
            if (name.equals(rule.getDescription())) {
                return method;
            }
            ++method;
        }
        return -1;
    }

    public static void setJavaLookAndFeel() {
        try {
            if (!System.getProperty("os.name").contains("OS X")) {
                if (System.getProperty("os.name").contains("Linux")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (AWTError | Exception throwable) {
            // empty catch block
        }
    }

    private String[] getUnderlineTypes() {
        String[] types = new String[]{MESSAGES.getString("guiUTypeWave"), MESSAGES.getString("guiUTypeBoldWave"), MESSAGES.getString("guiUTypeBold"), MESSAGES.getString("guiUTypeDash")};
        return types;
    }

    private int getUnderlineType() {
        short nType = this.config.getUnderlineType();
        if (nType == 18) {
            return 1;
        }
        if (nType == 12) {
            return 2;
        }
        if (nType == 5) {
            return 3;
        }
        return 0;
    }

    private void setUnderlineType(int index) {
        if (index == 1) {
            this.config.setUnderlineType((short)18);
        } else if (index == 2) {
            this.config.setUnderlineType((short)12);
        } else if (index == 3) {
            this.config.setUnderlineType((short)5);
        } else {
            this.config.setUnderlineType((short)0);
        }
    }

    @NotNull
    private JPanel getColorOptionsPanel() {
        this.colorPanel = new JPanel();
        this.colorPanel.setLayout(null);
        this.colorPanel.setBounds(0, 0, 120, 10);
        this.colorPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.colorPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons1 = new GridBagConstraints();
        cons1.insets = new Insets(5, 5, 5, 5);
        cons1.gridx = 0;
        cons1.gridy = 0;
        cons1.weightx = 0.0;
        cons1.fill = 0;
        cons1.anchor = 18;
        JLabel underlineStyle = new JLabel(MESSAGES.getString("guiUColorStyleLabel") + " ");
        this.colorPanel.add(underlineStyle);
        final JLabel underlineLabel = new JLabel(" \u2588\u2588\u2588 ");
        underlineLabel.setForeground(this.config.getUnderlineColor());
        underlineLabel.setBackground(this.config.getUnderlineColor());
        JComboBox<String> underlineType = new JComboBox<String>(this.getUnderlineTypes());
        underlineType.setSelectedIndex(this.getUnderlineType());
        underlineType.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                this.setUnderlineType(underlineType.getSelectedIndex());
                try {
                    this.config.saveConfiguration();
                }
                catch (Throwable e1) {
                    MessageHandler.showError(e1);
                }
            }
        });
        JPanel showPanel = new JPanel();
        showPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons11 = new GridBagConstraints();
        cons11.insets = new Insets(0, 0, 0, 0);
        cons11.gridx = 0;
        cons11.gridy = 0;
        cons11.weightx = 0.0;
        cons11.fill = 0;
        cons11.anchor = 18;
        showPanel.add(underlineType, cons11);
        ++cons11.gridx;
        showPanel.add((Component)underlineLabel, cons11);
        ++cons1.gridy;
        this.colorPanel.add((Component)showPanel, cons1);
        JPanel buttonPanel = new JPanel();
        showPanel.setLayout(new GridBagLayout());
        GridBagConstraints cons12 = new GridBagConstraints();
        cons12.insets = new Insets(0, 0, 0, 0);
        cons12.gridx = 0;
        cons12.gridy = 0;
        cons12.weightx = 0.0;
        cons12.fill = 0;
        cons12.anchor = 18;
        JButton changeButton = new JButton(MESSAGES.getString("guiUColorChange"));
        changeButton.addActionListener(e -> {
            final Color oldColor = underlineLabel.getForeground();
            this.dialog.setAlwaysOnTop(false);
            final JColorChooser colorChooser = new JColorChooser(oldColor);
            ActionListener okActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Color newColor = colorChooser.getColor();
                    if (newColor != null && !newColor.equals(oldColor)) {
                        underlineLabel.setForeground(newColor);
                        underlineLabel.setBackground(newColor);
                        StatAnDialog.this.config.setUnderlineColor(newColor);
                        try {
                            StatAnDialog.this.config.saveConfiguration();
                        }
                        catch (Throwable e1) {
                            MessageHandler.showError(e1);
                        }
                    }
                    StatAnDialog.this.dialog.setAlwaysOnTop(true);
                }
            };
            ActionListener cancelActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StatAnDialog.this.dialog.setAlwaysOnTop(true);
                }
            };
            JDialog colorDialog = JColorChooser.createDialog(this.dialog, MESSAGES.getString("guiUColorDialogHeader"), true, colorChooser, okActionListener, cancelActionListener);
            colorDialog.setAlwaysOnTop(true);
            colorDialog.toFront();
            colorDialog.setVisible(true);
        });
        buttonPanel.add((Component)changeButton, cons12);
        JButton defaultButton = new JButton(MESSAGES.getString("guiUColorDefault"));
        defaultButton.addActionListener(e -> {
            this.config.setDefaultUnderlineColor();
            underlineLabel.setForeground(this.config.getUnderlineColor());
            this.config.setUnderlineType((short)0);
            underlineType.setSelectedIndex(this.getUnderlineType());
        });
        ++cons12.gridx;
        buttonPanel.add((Component)defaultButton, cons12);
        ++cons1.gridy;
        this.colorPanel.add((Component)buttonPanel, cons1);
        this.colorPanel.setVisible(this.showAdditionalOptions.isSelected());
        return this.colorPanel;
    }

    public static String getStatisticalRulesSupportedLanguages() {
        String out = "Statistical Style Rules are supported by the following Languages:\n";
        for (Language lang : Languages.get()) {
            if (!OfficeTools.hasStatisticalStyleRules(lang)) continue;
            out = out + lang.getShortCodeWithCountryAndVariant() + "\n";
        }
        return out;
    }

    class Chapter {
        String name;
        int from;
        int to;
        int hierarchy;
        int weight;
        Chapter parent;

        Chapter(String name, int from, int to, int hierarchy, int weight, Chapter parent) {
            this.name = name;
            this.from = from;
            this.to = to;
            this.hierarchy = hierarchy;
            this.weight = weight;
            this.parent = parent;
        }
    }
}

