/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice.stylestatistic;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.languagetool.JLanguageTool;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.stylestatistic.LevelRule;
import org.languagetool.rules.AbstractStatisticSentenceStyleRule;
import org.languagetool.rules.AbstractStatisticStyleRule;
import org.languagetool.rules.AbstractStyleTooOftenUsedWordRule;
import org.languagetool.rules.TextLevelRule;

public class StatAnConfiguration {
    private final boolean WITHOUT_DIRECT_SPEECH_DEFAULT = false;
    private final boolean SHOW_ALLPARAGRAPHS_DEFAULT = false;
    private final short UNDERLINE_TYPE_DEFAULT = 0;
    private final Color UNDERLINE_COLOR_DEFAULT = new Color(75, 0, 255);
    private final String UNDERLINE_TYPE_PROP = "UnderlineType";
    private final String UNDERLINE_COLOR_PROP = "UnderlineColor";
    private final String SHOW_ALL_PARAGRAPH_PROP = "ShowAllParagraphs";
    private final List<TextLevelRule> rules;
    private final Map<String, Boolean> withoutDirectSpeech = new HashMap<String, Boolean>();
    private final Map<String, Integer> levelStep = new HashMap<String, Integer>();
    private final Map<String, List<String>> excludedWords = new HashMap<String, List<String>>();
    private short underlineType = 0;
    private Color underlineColor = this.UNDERLINE_COLOR_DEFAULT;
    private boolean showAllParagraphs = false;
    private boolean showAdditionalOptions = false;

    StatAnConfiguration(List<TextLevelRule> rules) throws Throwable {
        this.rules = rules;
        this.loadConfiguration();
    }

    boolean isWithoutDirectSpeech(TextLevelRule rule) {
        if (!this.withoutDirectSpeech.containsKey(rule.getId())) {
            return false;
        }
        return this.withoutDirectSpeech.get(rule.getId());
    }

    void setWithoutDirectSpeech(TextLevelRule rule, boolean wDS) {
        this.withoutDirectSpeech.put(rule.getId(), wDS);
    }

    int getLevelStep(TextLevelRule rule) {
        if (!this.levelStep.containsKey(rule.getId())) {
            return 0;
        }
        return this.levelStep.get(rule.getId());
    }

    void setLevelStep(TextLevelRule rule, int step) {
        this.levelStep.put(rule.getId(), step);
    }

    List<String> getExcludedWords(TextLevelRule rule) {
        List<String> exWords = this.excludedWords.get(rule.getId());
        if (exWords == null) {
            return new ArrayList<String>();
        }
        return exWords;
    }

    void setAllExcludedWords(TextLevelRule rule, List<String> words) {
        this.excludedWords.put(rule.getId(), words);
    }

    void removeAllExcludedWords(TextLevelRule rule) {
        List<String> exWords = this.excludedWords.get(rule.getId());
        if (exWords != null) {
            exWords.clear();
            this.excludedWords.put(rule.getId(), exWords);
        }
    }

    void addExcludedWord(TextLevelRule rule, String word) {
        List<String> words = this.excludedWords.get(rule.getId());
        if (words == null) {
            words = new ArrayList<String>();
        }
        words.add(word);
        this.excludedWords.put(rule.getId(), words);
    }

    short getUnderlineType() {
        return this.underlineType;
    }

    void setUnderlineType(short underlineType) {
        this.underlineType = underlineType;
    }

    boolean showAllParagraphs() {
        return this.showAllParagraphs;
    }

    void setShowAllParagraphs(boolean showAllParagraphs) {
        this.showAllParagraphs = showAllParagraphs;
    }

    boolean showAdditionalOptions() {
        return this.showAdditionalOptions;
    }

    void setShowAdditionalOptions(boolean showAdditionalOptions) {
        this.showAdditionalOptions = showAdditionalOptions;
    }

    Color getUnderlineColor() {
        return this.underlineColor;
    }

    void setDefaultUnderlineColor() {
        this.underlineColor = this.UNDERLINE_COLOR_DEFAULT;
    }

    void setUnderlineColor(Color underlineColor) {
        this.underlineColor = underlineColor;
    }

    private String createLevelRuleProperties(String ruleId) throws Throwable {
        return Boolean.toString(this.withoutDirectSpeech.get(ruleId)) + ";" + Integer.toString(this.levelStep.get(ruleId));
    }

    private String createUsedWordRuleProperties(String ruleId) throws Throwable {
        String txt = Boolean.toString(this.withoutDirectSpeech.get(ruleId)) + ";" + Integer.toString(this.levelStep.get(ruleId)) + ";";
        List<String> excWords = this.excludedWords.get(ruleId);
        for (int i = 0; i < excWords.size(); ++i) {
            txt = txt + excWords.get(i);
            if (i >= excWords.size() - 1) continue;
            txt = txt + ",";
        }
        return txt;
    }

    private int getDefaultStep(TextLevelRule rule) {
        int defaultStep;
        if (rule instanceof AbstractStatisticSentenceStyleRule) {
            defaultStep = (int)((double)(((AbstractStatisticSentenceStyleRule)rule).getDefaultValue() - 1) / 3.0 + 0.5);
        } else if (rule instanceof AbstractStatisticStyleRule) {
            defaultStep = (int)((double)(((AbstractStatisticStyleRule)rule).getDefaultValue() - 1) / 3.0 + 0.5);
        } else if (rule instanceof AbstractStyleTooOftenUsedWordRule) {
            defaultStep = (int)((double)(((AbstractStyleTooOftenUsedWordRule)rule).getDefaultValue() - 1) / 3.0 + 0.5);
        } else {
            return -1;
        }
        return defaultStep;
    }

    private void setLevelRuleProperties(TextLevelRule rule, String propString) throws Throwable {
        int defaultStep = this.getDefaultStep(rule);
        if (defaultStep < 0) {
            return;
        }
        if (propString == null) {
            this.withoutDirectSpeech.put(rule.getId(), false);
            this.levelStep.put(rule.getId(), defaultStep);
        } else {
            String[] props = propString.split(";");
            if (props.length > 0 && !props[0].isEmpty()) {
                this.withoutDirectSpeech.put(rule.getId(), Boolean.parseBoolean(props[0]));
            } else {
                this.withoutDirectSpeech.put(rule.getId(), false);
            }
            if (props.length > 1 && props[1] != null && !props[1].isEmpty()) {
                this.levelStep.put(rule.getId(), Integer.parseInt(props[1]));
            } else {
                this.levelStep.put(rule.getId(), defaultStep);
            }
        }
    }

    private void setUsedWordRuleProperties(TextLevelRule rule, String propString) throws Throwable {
        try {
            AbstractStyleTooOftenUsedWordRule usedWordRule = (AbstractStyleTooOftenUsedWordRule)rule;
            ArrayList<String> excWords = new ArrayList<String>();
            int defaultStep = this.getDefaultStep(rule);
            if (propString == null) {
                this.withoutDirectSpeech.put(usedWordRule.getId(), false);
                this.levelStep.put(rule.getId(), defaultStep);
                this.excludedWords.put(usedWordRule.getId(), excWords);
            } else {
                String[] props = propString.split(";");
                if (props.length > 0 && !props[0].isEmpty()) {
                    this.withoutDirectSpeech.put(usedWordRule.getId(), Boolean.parseBoolean(props[0]));
                } else {
                    this.withoutDirectSpeech.put(usedWordRule.getId(), false);
                }
                if (props.length > 1 && props[1] != null && !props[1].isEmpty()) {
                    this.levelStep.put(rule.getId(), Integer.parseInt(props[1]));
                } else {
                    this.levelStep.put(rule.getId(), defaultStep);
                }
                if (props.length > 2 && props[2] != null && !props[2].isEmpty()) {
                    String[] words;
                    for (String word : words = props[2].split(",")) {
                        excWords.add(word);
                    }
                }
                this.excludedWords.put(usedWordRule.getId(), excWords);
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    void saveConfiguration() throws Throwable {
        Properties props = new Properties();
        for (TextLevelRule rule : this.rules) {
            if (rule instanceof AbstractStyleTooOftenUsedWordRule) {
                if (!this.withoutDirectSpeech.get(rule.getId()).booleanValue() && this.levelStep.get(rule.getId()).intValue() == this.getDefaultStep(rule) && this.excludedWords.get(rule.getId()) == null) continue;
                props.setProperty(rule.getId(), this.createUsedWordRuleProperties(rule.getId()));
                continue;
            }
            if (!LevelRule.hasStatisticalOptions(rule) || !this.withoutDirectSpeech.get(rule.getId()).booleanValue() && this.levelStep.get(rule.getId()).intValue() == this.getDefaultStep(rule)) continue;
            props.setProperty(rule.getId(), this.createLevelRuleProperties(rule.getId()));
        }
        if (this.underlineType != 0) {
            props.setProperty("UnderlineType", Short.toString(this.underlineType));
        }
        if (!this.underlineColor.equals(this.UNDERLINE_COLOR_DEFAULT)) {
            props.setProperty("UnderlineColor", Integer.toString(this.underlineColor.getRGB()));
        }
        if (this.showAllParagraphs) {
            props.setProperty("ShowAllParagraphs", Boolean.toString(this.showAllParagraphs));
        }
        try (FileOutputStream fos = new FileOutputStream(OfficeTools.getStatisticalConfigFilePath());){
            props.store(fos, "LT statistical analyzes configuration (" + JLanguageTool.VERSION + "/" + JLanguageTool.BUILD_DATE + ")");
        }
        catch (Throwable e) {
            MessageHandler.showError(e);
        }
    }

    void loadConfiguration() throws Throwable {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(OfficeTools.getStatisticalConfigFilePath());){
            props.load(fis);
        }
        catch (Throwable e) {
            MessageHandler.printException(e);
        }
        this.withoutDirectSpeech.clear();
        this.levelStep.clear();
        this.excludedWords.clear();
        for (TextLevelRule rule : this.rules) {
            if (rule instanceof AbstractStyleTooOftenUsedWordRule) {
                this.setUsedWordRuleProperties(rule, props.getProperty(rule.getId()));
                continue;
            }
            boolean hasOptions = LevelRule.hasStatisticalOptions(rule);
            if (!hasOptions) continue;
            this.setLevelRuleProperties(rule, props.getProperty(rule.getId()));
        }
        String propString = props.getProperty("UnderlineType");
        if (propString != null) {
            this.underlineType = Short.parseShort(propString);
        }
        if ((propString = props.getProperty("UnderlineColor")) != null) {
            this.underlineColor = Color.decode(propString);
        }
        if ((propString = props.getProperty("ShowAllParagraphs")) != null) {
            this.showAllParagraphs = Boolean.parseBoolean(propString);
        }
        MessageHandler.printToLogFile("Config load done");
    }
}

