/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice.stylestatistic;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.Locale;
import com.sun.star.linguistic2.SingleProofreadingError;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.gui.Tools;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.DocumentCursorTools;
import org.languagetool.openoffice.FlatParagraphTools;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.ResultCache;
import org.languagetool.openoffice.SingleCheck;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.SwJLanguageTool;
import org.languagetool.openoffice.stylestatistic.StatAnConfiguration;
import org.languagetool.openoffice.stylestatistic.UsedWordRule;
import org.languagetool.rules.AbstractStyleTooOftenUsedWordRule;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tools.StringTools;

public class StatAnCache {
    private static final int MAX_NAME_LENGTH = 80;
    private static final boolean debugMode = false;
    private final Map<Integer, List<AnalyzedSentence>> analyzedParagraphs;
    private final String langCode;
    private List<Heading> headings = new ArrayList<Heading>();
    private List<Paragraph> paragraphs = new ArrayList<Paragraph>();
    private SingleDocument document;
    private DocumentCache docCache;
    private ResultCache statAnCache = null;
    private String actRuleId = null;
    private int lastPara = -1;
    private SwJLanguageTool lt;
    private StatAnConfiguration config;

    public StatAnCache(SingleDocument document, StatAnConfiguration conf, MultiDocumentsHandler.WaitDialogThread waitdialog) {
        this.document = document;
        this.langCode = document.getLanguage().getShortCode();
        this.config = conf;
        this.lt = document.getMultiDocumentsHandler().getLanguageTool();
        this.docCache = document.getDocumentCache();
        this.analyzedParagraphs = this.docCache.getAllAnalyzedParagraphs();
        while (this.docCache.getHeadingMap() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                MessageHandler.showError(e);
            }
        }
        if (waitdialog != null) {
            waitdialog.initializeProgressBar(0, 100);
        }
        int textSize = this.docCache.textSize(4);
        for (int i = 0; i < textSize; ++i) {
            try {
                Language lang;
                int nFPara = this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(4, i));
                Locale locale = this.docCache.getFlatParagraphLocale(nFPara);
                if (this.docCache.getAnalyzedParagraph(nFPara) == null && locale != null && this.langCode.equals(locale.Language) && (lang = MultiDocumentsHandler.getLanguage(this.docCache.getFlatParagraphLocale(nFPara))) != null) {
                    SwJLanguageTool tmpLt = this.lt;
                    if (!lang.equals(tmpLt.getLanguage()) && !lang.equals((tmpLt = document.getMultiDocumentsHandler().getLanguageTool()).getLanguage())) {
                        tmpLt = document.getMultiDocumentsHandler().initLanguageTool(lang, false);
                    }
                    this.docCache.createAnalyzedParagraph(nFPara, tmpLt);
                }
            }
            catch (IOException e) {
                MessageHandler.showError(e);
            }
            if (waitdialog == null) continue;
            waitdialog.setValueForProgressBar(90 * i / textSize);
        }
        this.setHeadings();
        this.setParagraphs();
    }

    private void setHeadings() {
        Map<Integer, Integer> headingMap = this.docCache.getHeadingMap();
        ArrayList<Integer> headParas = new ArrayList<Integer>();
        for (int nPara : headingMap.keySet()) {
            headParas.add(nPara);
        }
        headParas.sort(null);
        for (int nPara : headParas) {
            this.headings.add(new Heading(this.getNameOfParagraph(nPara), headingMap.get(nPara), nPara));
        }
    }

    private void setParagraphs() {
        for (int i = 0; i < this.docCache.textSize(4); ++i) {
            this.paragraphs.add(new Paragraph(this.getNameOfParagraph(i), this.getHeadingHierarchy(i), i));
        }
    }

    public int size() {
        return this.docCache.textSize(4);
    }

    public List<AnalyzedSentence> getAnalysedParagraph(int n) {
        int nFPara = this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(4, n));
        return this.analyzedParagraphs.get(nFPara);
    }

    public List<List<AnalyzedSentence>> getAnalysedParagraphsfrom(int from, int to) {
        ArrayList<List<AnalyzedSentence>> tmpParagraphs = new ArrayList<List<AnalyzedSentence>>();
        for (int i = from; i < to; ++i) {
            int nFPara = this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(4, i));
            tmpParagraphs.add(this.analyzedParagraphs.get(nFPara));
        }
        return tmpParagraphs;
    }

    public List<Paragraph> getParagraphsfrom(int from, int to) {
        ArrayList<Paragraph> tmpParagraphs = new ArrayList<Paragraph>();
        for (int i = from; i < to; ++i) {
            tmpParagraphs.add(this.paragraphs.get(i));
        }
        return tmpParagraphs;
    }

    public int getNumFlatParagraph(int textPara) {
        return this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(4, textPara));
    }

    public String getLanguageFlatParagraph(int textPara) {
        Locale locale = this.docCache.getTextParagraphLocale(new DocumentCache.TextParagraph(4, textPara));
        if (locale == null) {
            return "zxx";
        }
        return locale.Language;
    }

    public String getDocShortCodeLanguage() {
        return this.langCode;
    }

    public String getNameOfParagraph(int nPara) {
        String tPara = this.docCache.getTextParagraph(new DocumentCache.TextParagraph(4, nPara));
        return this.getNameOfParagraph(tPara);
    }

    public String getNameOfParagraph(String text) {
        if (text.length() > 80) {
            text = text.substring(0, 77) + "...";
        }
        return text;
    }

    private int getHeadingHierarchy(int nPara) {
        for (int i = 0; i < this.headings.size(); ++i) {
            if (this.headings.get((int)i).paraNum != nPara) continue;
            return this.headings.get((int)i).hierarchy;
        }
        return -1;
    }

    public List<Heading> getAllHeadings() {
        return this.headings;
    }

    private SingleProofreadingError[] mergeErrors(List<SingleProofreadingError[]> pErrors, SingleProofreadingError[] statAnErrors, String statAnRuleId, int nPara) {
        SingleProofreadingError[] errorArray = this.document.mergeErrors(pErrors, nPara);
        if (statAnRuleId != null && statAnErrors != null && statAnErrors.length > 0) {
            errorArray = SingleDocument.addStatAnalysisErrors(errorArray, statAnErrors, statAnRuleId);
        }
        return errorArray;
    }

    private List<SingleCheck.SentenceErrors> getSentencesErrosAsList(int numberOfParagraph, String sRuleId, short lineType, Color lineColor, ResultCache sCache) {
        ArrayList<SingleCheck.SentenceErrors> sentenceErrors = new ArrayList<SingleCheck.SentenceErrors>();
        List<ResultCache> paragraphsCache = this.document.getParagraphsCache();
        ResultCache.CacheEntry entry = paragraphsCache.get(0).getCacheEntry(numberOfParagraph);
        List<Integer> nextSentencePositions = null;
        if (entry != null) {
            nextSentencePositions = entry.nextSentencePositions;
        }
        if (nextSentencePositions == null) {
            nextSentencePositions = new ArrayList<Integer>();
        }
        if (nextSentencePositions.size() == 0 && this.docCache != null && numberOfParagraph >= 0 && numberOfParagraph < this.docCache.size()) {
            nextSentencePositions = SingleCheck.getNextSentencePositions(this.docCache.getFlatParagraph(numberOfParagraph), this.lt);
        }
        SingleProofreadingError[] sErrors = null;
        int startPosition = 0;
        if (nextSentencePositions.size() == 1) {
            ArrayList<SingleProofreadingError[]> errorList = new ArrayList<SingleProofreadingError[]>();
            for (ResultCache cache : paragraphsCache) {
                errorList.add(cache.getMatches(numberOfParagraph, OfficeTools.LoErrorType.GRAMMAR));
            }
            if (sRuleId != null && sCache != null) {
                sErrors = sCache.getMatches(numberOfParagraph, OfficeTools.LoErrorType.GRAMMAR);
                sErrors = this.addPropertiesToErrors(sErrors, lineType, lineColor);
            }
            sentenceErrors.add(new SingleCheck.SentenceErrors(startPosition, nextSentencePositions.get(0), this.mergeErrors(errorList, sErrors, sRuleId, numberOfParagraph)));
        } else {
            for (int nextPosition : nextSentencePositions) {
                ArrayList<SingleProofreadingError[]> errorList = new ArrayList<SingleProofreadingError[]>();
                for (ResultCache cache : paragraphsCache) {
                    errorList.add(cache.getFromPara(numberOfParagraph, startPosition, nextPosition, OfficeTools.LoErrorType.GRAMMAR));
                }
                if (sRuleId != null && sCache != null) {
                    sErrors = sCache.getFromPara(numberOfParagraph, startPosition, nextPosition, OfficeTools.LoErrorType.GRAMMAR);
                    sErrors = this.addPropertiesToErrors(sErrors, lineType, lineColor);
                }
                sentenceErrors.add(new SingleCheck.SentenceErrors(startPosition, nextPosition, this.mergeErrors(errorList, sErrors, sRuleId, numberOfParagraph)));
                startPosition = nextPosition;
            }
        }
        return sentenceErrors;
    }

    public void setNewResultcache(String ruleId, ResultCache sCache) {
        if (this.actRuleId != null && this.lastPara >= 0) {
            this.remarkChangedParagraph(this.lastPara, null, (short)0, null, null);
            this.lastPara = -1;
        }
        this.actRuleId = ruleId;
        this.document.setStatAnCache(sCache);
        this.statAnCache = sCache;
    }

    public void markParagraph(int nPara, short lineType, Color lineColor) {
        if (this.actRuleId != null) {
            if (this.lastPara >= 0) {
                this.remarkChangedParagraph(this.lastPara, null, (short)0, null, null);
            }
            this.lastPara = nPara;
            this.remarkChangedParagraph(this.lastPara, this.actRuleId, lineType, lineColor, this.statAnCache);
            this.document.setStatAnRuleId(this.actRuleId);
        }
    }

    public boolean isRelevantParagraph(int nTPara, TextLevelRule rule, UsedWordRule uRule) {
        if (rule instanceof ReadabilityRule) {
            return true;
        }
        if (rule instanceof AbstractStyleTooOftenUsedWordRule) {
            return uRule.isRelevantParagraph(nTPara);
        }
        int nFPara = this.getNumFlatParagraph(nTPara);
        SingleProofreadingError[] sErrors = this.statAnCache.getSafeMatches(nFPara);
        return sErrors != null && sErrors.length != 0;
    }

    private void remarkChangedParagraph(int nFPara, String sRuleId, short lineType, Color lineColor, ResultCache sCache) {
        FlatParagraphTools flatPara;
        if (sCache == null) {
            this.document.setStatAnRuleId(null);
        }
        HashMap<Integer, List<SingleCheck.SentenceErrors>> changedParasMap = new HashMap<Integer, List<SingleCheck.SentenceErrors>>();
        ArrayList<DocumentCache.TextParagraph> toRemarkTextParas = new ArrayList<DocumentCache.TextParagraph>();
        List<SingleCheck.SentenceErrors> sentencesErrors = this.getSentencesErrosAsList(nFPara, sRuleId, lineType, lineColor, sCache);
        changedParasMap.put(nFPara, sentencesErrors);
        toRemarkTextParas.add(this.docCache.getNumberOfTextParagraph(nFPara));
        DocumentCursorTools docCursor = this.document.getDocumentCursorTools();
        if (docCursor != null) {
            docCursor.removeMarks(toRemarkTextParas);
        }
        if ((flatPara = this.document.getFlatParagraphTools()) != null) {
            flatPara.markParagraphs(changedParasMap);
        }
    }

    public SingleProofreadingError[] createLoErrors(RuleMatch[] ruleMatches) {
        if (ruleMatches == null || ruleMatches.length == 0) {
            return new SingleProofreadingError[0];
        }
        SingleProofreadingError[] errors = new SingleProofreadingError[ruleMatches.length];
        for (int i = 0; i < ruleMatches.length; ++i) {
            errors[i] = this.createLoError(ruleMatches[i]);
        }
        return errors;
    }

    public SingleProofreadingError[] createLoErrors(List<RuleMatch> ruleMatches) {
        if (ruleMatches == null || ruleMatches.size() == 0) {
            return new SingleProofreadingError[0];
        }
        SingleProofreadingError[] errors = new SingleProofreadingError[ruleMatches.size()];
        for (int i = 0; i < ruleMatches.size(); ++i) {
            errors[i] = this.createLoError(ruleMatches.get(i));
        }
        return errors;
    }

    private SingleProofreadingError[] addPropertiesToErrors(SingleProofreadingError[] errors, short lineType, Color lineColor) {
        if (errors == null) {
            return null;
        }
        for (int i = 0; i < errors.length; ++i) {
            errors[i] = this.addPropertiesToError(errors[i], lineType, lineColor);
        }
        return errors;
    }

    private SingleProofreadingError addPropertiesToError(SingleProofreadingError error, short lineType, Color lineColor) {
        int ucolor = lineColor.getRGB() & 0xFFFFFF;
        PropertyValue[] propertyValues = new PropertyValue[]{new PropertyValue("LineColor", -1, (Object)ucolor, PropertyState.DIRECT_VALUE), new PropertyValue("LineType", -1, (Object)lineType, PropertyState.DIRECT_VALUE)};
        error.aProperties = propertyValues;
        return error;
    }

    private SingleProofreadingError createLoError(RuleMatch ruleMatch) {
        SingleProofreadingError aError = new SingleProofreadingError();
        aError.nErrorType = 2;
        String msg = ruleMatch.getMessage();
        Language docLanguage = this.lt.getLanguage();
        if (docLanguage != null) {
            msg = docLanguage.toAdvancedTypography(msg);
        }
        aError.aFullComment = msg = msg.replaceAll("<suggestion>", docLanguage == null ? "\"" : docLanguage.getOpeningDoubleQuote()).replaceAll("</suggestion>", docLanguage == null ? "\"" : docLanguage.getClosingDoubleQuote()).replaceAll("([\r]*\n)", " ");
        aError.aShortComment = !StringTools.isEmpty(ruleMatch.getShortMessage()) ? ruleMatch.getShortMessage() : aError.aFullComment;
        aError.aShortComment = Tools.shortenComment(aError.aShortComment);
        int numSuggestions = ruleMatch.getSuggestedReplacements().size();
        String[] allSuggestions = ruleMatch.getSuggestedReplacements().toArray(new String[numSuggestions]);
        aError.aSuggestions = numSuggestions > 25 ? Arrays.copyOfRange(allSuggestions, 0, 25) : allSuggestions;
        aError.nErrorStart = ruleMatch.getFromPos();
        aError.nErrorLength = ruleMatch.getToPos() - ruleMatch.getFromPos();
        aError.aRuleIdentifier = ruleMatch.getRule().getId();
        return this.addPropertiesToError(aError, this.config.getUnderlineType(), this.config.getUnderlineColor());
    }

    public SingleProofreadingError createLoError(int errorStart, int errorLength, String ruleId, String msg, String[] allSuggestions) {
        int numSuggestions;
        SingleProofreadingError aError = new SingleProofreadingError();
        aError.nErrorType = 2;
        Language docLanguage = this.lt.getLanguage();
        if (docLanguage != null) {
            msg = docLanguage.toAdvancedTypography(msg);
        }
        aError.aFullComment = msg;
        aError.aShortComment = Tools.shortenComment(msg);
        if (allSuggestions == null) {
            allSuggestions = new String[]{};
        }
        aError.aSuggestions = (numSuggestions = allSuggestions.length) > 25 ? Arrays.copyOfRange(allSuggestions, 0, 25) : allSuggestions;
        aError.nErrorStart = errorStart;
        aError.nErrorLength = errorLength;
        aError.aRuleIdentifier = ruleId;
        return this.addPropertiesToError(aError, this.config.getUnderlineType(), this.config.getUnderlineColor());
    }

    public class Heading {
        String name;
        int hierarchy;
        int paraNum;

        Heading(String name, int hierarchy, int paraNum) {
            this.name = new String(name);
            this.hierarchy = hierarchy;
            this.paraNum = paraNum;
        }
    }

    public class Paragraph {
        public String name;
        public int hierarchy;
        public int paraNum;

        Paragraph(String name, int hierarchy, int paraNum) {
            this.name = new String(name);
            this.hierarchy = hierarchy;
            this.paraNum = paraNum;
        }
    }
}

