/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice.stylestatistic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.JLanguageTool;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.ResultCache;
import org.languagetool.openoffice.stylestatistic.StatAnCache;
import org.languagetool.rules.AbstractStatisticSentenceStyleRule;
import org.languagetool.rules.AbstractStatisticStyleRule;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

public class LevelRule {
    private boolean debugMode = false;
    private static final ResourceBundle MESSAGES = JLanguageTool.getMessageBundle();
    private final TextLevelRule rule;
    private boolean withDirectSpeech;
    private int procentualStep;
    private int optimalNumberWords;
    private List<Integer> numSyllables = new ArrayList<Integer>();
    private List<Integer> numFound = new ArrayList<Integer>();
    private List<Integer> numBase = new ArrayList<Integer>();
    private double unitFactor;

    public LevelRule(TextLevelRule rule, StatAnCache cache) {
        this.rule = rule;
        this.withDirectSpeech = true;
        this.procentualStep = this.getDefaultRuleStep();
        this.optimalNumberWords = 3 * this.procentualStep;
        this.unitFactor = this.getUnitFactor();
    }

    public void generateBasicNumbers(StatAnCache cache) {
        try {
            ResultCache statAnalysisCache = new ResultCache();
            this.numFound.clear();
            this.numBase.clear();
            this.numSyllables.clear();
            if (this.debugMode) {
                MessageHandler.printToLogFile("withDirectSpeech: " + this.withDirectSpeech);
            }
            String langCode = cache.getDocShortCodeLanguage();
            for (int i = 0; i < cache.size(); ++i) {
                if (langCode.equals(cache.getLanguageFlatParagraph(i))) {
                    RuleMatch[] matches = this.rule.match(cache.getAnalysedParagraph(i), null);
                    if (matches != null && matches.length > 0) {
                        int n = cache.getNumFlatParagraph(i);
                        statAnalysisCache.put(n, cache.createLoErrors(matches));
                    }
                    if (this.rule instanceof AbstractStatisticSentenceStyleRule) {
                        this.numFound.add(((AbstractStatisticSentenceStyleRule)this.rule).getNumberOfMatches());
                        this.numBase.add(((AbstractStatisticSentenceStyleRule)this.rule).getSentenceCount());
                        continue;
                    }
                    if (this.rule instanceof AbstractStatisticStyleRule) {
                        this.numFound.add(((AbstractStatisticStyleRule)this.rule).getNumberOfMatches());
                        this.numBase.add(((AbstractStatisticStyleRule)this.rule).getWordCount());
                        continue;
                    }
                    if (!(this.rule instanceof ReadabilityRule)) continue;
                    this.numFound.add(((ReadabilityRule)this.rule).getAllWords());
                    this.numSyllables.add(((ReadabilityRule)this.rule).getAllSyllables());
                    this.numBase.add(((ReadabilityRule)this.rule).getAllSentences());
                    continue;
                }
                this.numFound.add(0);
                this.numBase.add(0);
                if (!(this.rule instanceof ReadabilityRule)) continue;
                this.numSyllables.add(0);
            }
            cache.setNewResultcache(this.rule.getId(), statAnalysisCache);
            if (this.debugMode) {
                MessageHandler.printToLogFile("Number of: numFound: " + this.numFound.size() + ", numBase: " + this.numBase.size() + ", numSyllables: " + this.numSyllables.size());
            }
        }
        catch (IOException e) {
            MessageHandler.showError(e);
        }
    }

    protected int getFoundWordsLevel(double percent) throws Throwable {
        if (percent > (double)(this.optimalNumberWords + 2 * this.procentualStep)) {
            return 0;
        }
        if (percent > (double)(this.optimalNumberWords + this.procentualStep)) {
            return 1;
        }
        if (percent > (double)this.optimalNumberWords) {
            return 2;
        }
        if (percent > (double)(this.optimalNumberWords - this.procentualStep)) {
            return 3;
        }
        if (percent > (double)(this.optimalNumberWords - 2 * this.procentualStep)) {
            return 4;
        }
        if (percent > (double)(this.optimalNumberWords - 3 * this.procentualStep)) {
            return 5;
        }
        return 6;
    }

    private int getReadabilityLevel(double fre) {
        if (fre < 30.0) {
            return 0;
        }
        if (fre < 50.0) {
            return 1;
        }
        if (fre < 60.0) {
            return 2;
        }
        if (fre < 70.0) {
            return 3;
        }
        if (fre < 80.0) {
            return 4;
        }
        if (fre < 90.0) {
            return 5;
        }
        return 6;
    }

    public int getLevel(int from, int to) throws Throwable {
        if (this.rule instanceof AbstractStatisticSentenceStyleRule || this.rule instanceof AbstractStatisticStyleRule) {
            int nBase = 0;
            int nFound = 0;
            for (int i = from; i < to && i < this.numBase.size(); ++i) {
                nFound += this.numFound.get(i).intValue();
                nBase += this.numBase.get(i).intValue();
            }
            if (nBase == 0) {
                return 7;
            }
            double percent = (double)nFound * this.unitFactor / (double)nBase;
            return this.getFoundWordsLevel(percent);
        }
        if (this.rule instanceof ReadabilityRule) {
            int nAllSentences = 0;
            int nAllSyllables = 0;
            int nAllWords = 0;
            for (int i = from; i < to; ++i) {
                nAllWords += this.numFound.get(i).intValue();
                nAllSentences += this.numBase.get(i).intValue();
                nAllSyllables += this.numSyllables.get(i).intValue();
            }
            if (nAllSentences == 0 || nAllWords == 0) {
                return 7;
            }
            double asl = (double)nAllWords / (double)nAllSentences;
            double asw = (double)nAllSyllables / (double)nAllWords;
            double fre = ((ReadabilityRule)this.rule).getFleschReadingEase(asl, asw);
            return this.getReadabilityLevel(fre);
        }
        return 7;
    }

    public double getUnitFactor() {
        if (this.rule instanceof AbstractStatisticSentenceStyleRule) {
            return ((AbstractStatisticSentenceStyleRule)this.rule).denominator();
        }
        if (this.rule instanceof AbstractStatisticStyleRule) {
            return ((AbstractStatisticStyleRule)this.rule).denominator();
        }
        return 1.0;
    }

    private int getDefaultRuleStep() {
        int defValue = this.rule.getDefaultValue();
        int defStep = (int)((double)defValue / 3.0 + 0.5);
        if (defStep < 1) {
            defStep = 1;
        }
        return defStep;
    }

    public int getDefaultStep() {
        int defStep = this.getDefaultRuleStep();
        if (this.debugMode) {
            MessageHandler.printToLogFile("default step: " + defStep);
        }
        return defStep;
    }

    public void setWithDirectSpeach(boolean wDirectSpeech, StatAnCache cache) {
        if (this.debugMode) {
            MessageHandler.printToLogFile("withDirectSpeech: " + this.withDirectSpeech + ", wDirectSpeech: " + wDirectSpeech);
        }
        if (this.withDirectSpeech != wDirectSpeech) {
            this.withDirectSpeech = wDirectSpeech;
            if (this.rule instanceof AbstractStatisticSentenceStyleRule) {
                ((AbstractStatisticSentenceStyleRule)this.rule).setWithoutDirectSpeech(!this.withDirectSpeech);
            } else if (this.rule instanceof AbstractStatisticStyleRule) {
                ((AbstractStatisticStyleRule)this.rule).setWithoutDirectSpeech(!this.withDirectSpeech);
            }
            if (this.debugMode) {
                MessageHandler.printToLogFile("Generate basic numbers");
            }
            this.generateBasicNumbers(cache);
        }
    }

    public void setCurrentStep(int step) {
        if (step > 0) {
            this.procentualStep = step;
            this.optimalNumberWords = 3 * this.procentualStep;
        }
    }

    public boolean getDefaultDirectSpeach() {
        return true;
    }

    public String getUnitString() {
        if (this.unitFactor == 10000.0) {
            return "\u2031";
        }
        if (this.unitFactor == 1000.0) {
            return "\u2030";
        }
        return "%";
    }

    public String getMessageOfLevel(int level) {
        String sLevel = null;
        if (this.rule instanceof ReadabilityRule) {
            return ((ReadabilityRule)this.rule).printMessageLevel(level);
        }
        int percent = this.optimalNumberWords + (3 - level) * this.procentualStep;
        if (level == 0) {
            sLevel = MESSAGES.getString("loStatisticalAnalysisNumber") + ": &gt " + percent + this.getUnitString();
        } else if (level >= 1 && level <= 5) {
            sLevel = MESSAGES.getString("loStatisticalAnalysisNumber") + ": " + (percent - this.procentualStep) + " - " + percent + this.getUnitString();
        } else if (level == 6) {
            sLevel = MESSAGES.getString("loStatisticalAnalysisNumber") + ": 0" + this.getUnitString();
        }
        return sLevel;
    }

    public static boolean hasStatisticalOptions(Rule rule) {
        return rule instanceof AbstractStatisticSentenceStyleRule || rule instanceof AbstractStatisticStyleRule;
    }

    public static boolean isLevelRule(Rule rule) {
        return rule instanceof AbstractStatisticSentenceStyleRule || rule instanceof AbstractStatisticStyleRule || rule instanceof ReadabilityRule;
    }
}

