/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XEndnotesSupplier;
import com.sun.star.text.XFootnote;
import com.sun.star.text.XFootnotesSupplier;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.DocumentCursorTools;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;

public class ViewCursorTools {
    private static int isBusy = 0;
    private XComponent xComponent;

    public ViewCursorTools(XComponent xComponent) {
        this.xComponent = xComponent;
    }

    public void setDisposed() {
        this.xComponent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public XTextViewCursor getViewCursor() {
        ++isBusy;
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)this.xComponent);
            if (xModel == null) {
                XTextViewCursor xTextViewCursor = null;
                return xTextViewCursor;
            }
            XController xController = xModel.getCurrentController();
            if (xController == null) {
                XTextViewCursor xTextViewCursor = null;
                return xTextViewCursor;
            }
            XTextViewCursorSupplier xViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)xController);
            if (xViewCursorSupplier == null) {
                XTextViewCursor xTextViewCursor = null;
                return xTextViewCursor;
            }
            XTextViewCursor xTextViewCursor = xViewCursorSupplier.getViewCursor();
            return xTextViewCursor;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            XTextViewCursor xTextViewCursor = null;
            return xTextViewCursor;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XTextCursor getTextCursorFromViewCursor(boolean getEnd) {
        ++isBusy;
        try {
            List<XPropertySet> xPagePropertySets;
            XEndnotesSupplier xEndnotesSupplier;
            XIndexAccess xEndnotes;
            XFootnotesSupplier xFootnoteSupplier;
            XIndexAccess xFootnotes;
            XText xShapeText;
            XDrawPage xDrawPage;
            XDrawPageSupplier xDrawPageSupplier;
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor == null) {
                XTextCursor xTextCursor = null;
                return xTextCursor;
            }
            XText xViewCursorText = vCursor.getText();
            if (xViewCursorText == null) {
                XTextCursor xTextCursor = null;
                return xTextCursor;
            }
            XTextDocument curDoc = this.getTextDocument();
            if (curDoc == null) {
                XTextCursor xTextCursor = null;
                return xTextCursor;
            }
            XText xText = curDoc.getText();
            if (xText != null && xViewCursorText.equals(xText)) {
                XTextRange range = getEnd ? vCursor.getEnd() : vCursor.getStart();
                XTextCursor xTextCursor = range == null ? null : xText.createTextCursorByRange(range);
                return xTextCursor;
            }
            XTextTablesSupplier xTableSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)curDoc);
            XIndexAccess xTables = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xTableSupplier.getTextTables());
            if (xTables != null) {
                for (int i = 0; i < xTables.getCount(); ++i) {
                    XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                    if (xTable == null) continue;
                    for (String cellName : xTable.getCellNames()) {
                        XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                        if (xTableText == null || !xViewCursorText.equals(xTableText)) continue;
                        XTextRange range = getEnd ? vCursor.getEnd() : vCursor.getStart();
                        XTextCursor xTextCursor = range == null ? null : xTableText.createTextCursorByRange(range);
                        return xTextCursor;
                    }
                }
            }
            if ((xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)curDoc)) != null && (xDrawPage = xDrawPageSupplier.getDrawPage()) != null) {
                XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
                int nShapes = xShapes.getCount();
                for (int j = 0; j < nShapes; ++j) {
                    Object oShape = xShapes.getByIndex(j);
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                    if (xShape == null || (xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape)) == null || !xViewCursorText.equals(xShapeText)) continue;
                    XTextRange range = getEnd ? vCursor.getEnd() : vCursor.getStart();
                    XTextCursor xTextCursor = range == null ? null : xShapeText.createTextCursorByRange(range);
                    return xTextCursor;
                }
            }
            if ((xFootnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)(xFootnoteSupplier = (XFootnotesSupplier)UnoRuntime.queryInterface(XFootnotesSupplier.class, (Object)curDoc)).getFootnotes())) != null) {
                for (int i = 0; i < xFootnotes.getCount(); ++i) {
                    XText xFootnoteText;
                    XFootnote XFootnote2 = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xFootnotes.getByIndex(i));
                    if (XFootnote2 == null || (xFootnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)XFootnote2)) == null || !xViewCursorText.equals(xFootnoteText)) continue;
                    XTextRange range = getEnd ? vCursor.getEnd() : vCursor.getStart();
                    xShapeText = range == null ? null : xFootnoteText.createTextCursorByRange(range);
                    return xShapeText;
                }
            }
            if ((xEndnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)(xEndnotesSupplier = (XEndnotesSupplier)UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)curDoc)).getEndnotes())) != null) {
                for (int i = 0; i < xEndnotes.getCount(); ++i) {
                    XText xEndnoteText;
                    XFootnote xEndnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xEndnotes.getByIndex(i));
                    if (xEndnote == null || (xEndnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xEndnote)) == null || !xViewCursorText.equals(xEndnoteText)) continue;
                    XTextRange range = getEnd ? vCursor.getEnd() : vCursor.getStart();
                    XTextCursor xTextCursor = range == null ? null : xEndnoteText.createTextCursorByRange(range);
                    return xTextCursor;
                }
            }
            if ((xPagePropertySets = this.getPagePropertySets()) != null) {
                for (XPropertySet xPagePropertySet : xPagePropertySets) {
                    if (xPagePropertySet == null) continue;
                    boolean firstIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FirstIsShared"));
                    boolean headerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsOn"));
                    boolean headerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsShared"));
                    boolean footerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsOn"));
                    boolean footerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsShared"));
                    for (int i = 0; i < DocumentCursorTools.HeaderFooterTypes.length; ++i) {
                        XText xHeaderText;
                        if (!(headerIsOn && (i == 0 && headerIsShared || (i == 1 || i == 2) && !headerIsShared || i == 3 && !firstIsShared)) && (!footerIsOn || (i != 4 || !footerIsShared) && (i != 5 && i != 6 || footerIsShared) && (i != 7 || firstIsShared)) || (xHeaderText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPagePropertySet.getPropertyValue(DocumentCursorTools.HeaderFooterTypes[i]))) == null || xHeaderText.getString().isEmpty() || !xViewCursorText.equals(xHeaderText)) continue;
                        XTextRange range = getEnd ? vCursor.getEnd() : vCursor.getStart();
                        XTextCursor xTextCursor = range == null ? null : xHeaderText.createTextCursorByRange(range);
                        return xTextCursor;
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
        return null;
    }

    XTextCursor getTextCursorBeginn() {
        return this.getTextCursorFromViewCursor(false);
    }

    XTextCursor getTextCursorEnd() {
        return this.getTextCursorFromViewCursor(true);
    }

    XParagraphCursor getParagraphCursorFromViewCursor() {
        ++isBusy;
        try {
            XTextCursor xTextCursor = this.getTextCursorFromViewCursor(false);
            if (xTextCursor == null) {
                XParagraphCursor xParagraphCursor = null;
                return xParagraphCursor;
            }
            XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
            return xParagraphCursor;
        }
        catch (Throwable t) {
            XParagraphCursor xParagraphCursor = null;
            return xParagraphCursor;
        }
        finally {
            --isBusy;
        }
    }

    String getViewCursorParagraphText() {
        ++isBusy;
        try {
            XParagraphCursor xParagraphCursor = this.getParagraphCursorFromViewCursor();
            if (xParagraphCursor == null) {
                String string = null;
                return string;
            }
            xParagraphCursor.gotoStartOfParagraph(false);
            xParagraphCursor.gotoEndOfParagraph(true);
            String string = new String(xParagraphCursor.getString());
            return string;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            String string = null;
            return string;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setViewCursorParagraphText(int nStart, int nLength, String replace) {
        ++isBusy;
        try {
            XParagraphCursor xParagraphCursor = this.getParagraphCursorFromViewCursor();
            if (xParagraphCursor == null) {
                return;
            }
            xParagraphCursor.gotoStartOfParagraph(false);
            xParagraphCursor.goRight((short)nStart, false);
            if (nLength > 0) {
                xParagraphCursor.goRight((short)nLength, true);
            }
            xParagraphCursor.setString(replace);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    private XTextDocument getTextDocument() {
        if (this.xComponent == null) {
            return null;
        }
        return (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)this.xComponent);
    }

    private List<XPropertySet> getPagePropertySets() {
        try {
            ArrayList<XPropertySet> propertySets = new ArrayList<XPropertySet>();
            XTextDocument curDoc = this.getTextDocument();
            if (curDoc == null) {
                return null;
            }
            XStyleFamiliesSupplier xSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)curDoc);
            XNameAccess xNameAccess = xSupplier.getStyleFamilies();
            if (xNameAccess == null) {
                return null;
            }
            XNameContainer pageStyleCon = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xNameAccess.getByName("PageStyles"));
            if (pageStyleCon == null) {
                return null;
            }
            for (String name : pageStyleCon.getElementNames()) {
                XPropertySet xPageStandardProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)pageStyleCon.getByName(name));
                if (xPageStandardProps == null) continue;
                propertySets.add((XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPageStandardProps));
            }
            return propertySets;
        }
        catch (Throwable e) {
            MessageHandler.printException(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentCache.TextParagraph getViewCursorParagraph() {
        ++isBusy;
        try {
            XEndnotesSupplier xEndnotesSupplier;
            XIndexAccess xEndnotes;
            XFootnotesSupplier xFootnoteSupplier;
            XIndexAccess xFootnotes;
            Object xParagraphCursor;
            XTextCursor xTextCursor;
            XDrawPage xDrawPage;
            XDrawPageSupplier xDrawPageSupplier;
            XIndexAccess xTables;
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor == null) {
                DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(-1, -1);
                return textParagraph;
            }
            XText xViewCursorText = vCursor.getText();
            if (xViewCursorText == null) {
                DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(-1, -1);
                return textParagraph;
            }
            XTextDocument curDoc = this.getTextDocument();
            if (curDoc == null) {
                DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(-1, -1);
                return textParagraph;
            }
            XText xText = curDoc.getText();
            if (xText != null && xViewCursorText.equals(xText)) {
                XTextCursor xTextCursor2 = xText.createTextCursorByRange(vCursor.getStart());
                if (xTextCursor2 == null) {
                    DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(-1, -1);
                    return textParagraph;
                }
                XParagraphCursor xParagraphCursor2 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor2);
                if (xParagraphCursor2 == null) {
                    DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(-1, -1);
                    return textParagraph;
                }
                int pos = 0;
                while (xParagraphCursor2.gotoPreviousParagraph(false)) {
                    ++pos;
                }
                DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(4, pos);
                return textParagraph;
            }
            XTextTablesSupplier xTableSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)curDoc);
            XIndexAccess xIndexAccess = xTables = xTableSupplier == null ? null : (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xTableSupplier.getTextTables());
            if (xTables != null) {
                int nLastPara = 0;
                for (int i = 0; i < xTables.getCount(); ++i) {
                    XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                    if (xTable == null) continue;
                    for (String cellName : xTable.getCellNames()) {
                        XParagraphCursor xParagraphCursor3;
                        XTextCursor xTextCursor3;
                        XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                        if (xTableText == null) continue;
                        if (xViewCursorText.equals(xTableText)) {
                            xTextCursor3 = xTableText.createTextCursorByRange(vCursor.getStart());
                            xParagraphCursor3 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor3);
                            int pos = 0;
                            while (xParagraphCursor3.gotoPreviousParagraph(false)) {
                                ++pos;
                            }
                            DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(5, pos + nLastPara);
                            return textParagraph;
                        }
                        xTextCursor3 = xTableText.createTextCursor();
                        xParagraphCursor3 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor3);
                        xParagraphCursor3.gotoStart(false);
                        ++nLastPara;
                        while (xParagraphCursor3.gotoNextParagraph(false)) {
                            ++nLastPara;
                        }
                    }
                }
            }
            if ((xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)curDoc)) != null && (xDrawPage = xDrawPageSupplier.getDrawPage()) != null) {
                XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
                int nLastPara = 0;
                int nShapes = xShapes.getCount();
                for (int j = 0; j < nShapes; ++j) {
                    XText xShapeText;
                    Object oShape = xShapes.getByIndex(j);
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                    if (xShape == null || (xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape)) == null) continue;
                    if (xViewCursorText.equals(xShapeText)) {
                        xTextCursor = xShapeText.createTextCursorByRange(vCursor.getStart());
                        xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                        int pos = 0;
                        while (xParagraphCursor.gotoPreviousParagraph(false)) {
                            ++pos;
                        }
                        DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(3, pos + nLastPara);
                        return textParagraph;
                    }
                    xTextCursor = xShapeText.createTextCursor();
                    xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                    xParagraphCursor.gotoStart(false);
                    ++nLastPara;
                    while (xParagraphCursor.gotoNextParagraph(false)) {
                        ++nLastPara;
                    }
                }
            }
            XIndexAccess xIndexAccess2 = xFootnotes = (xFootnoteSupplier = (XFootnotesSupplier)UnoRuntime.queryInterface(XFootnotesSupplier.class, (Object)curDoc)) == null ? null : (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xFootnoteSupplier.getFootnotes());
            if (xFootnotes != null) {
                int nLastPara = 0;
                for (int i = 0; i < xFootnotes.getCount(); ++i) {
                    XParagraphCursor xParagraphCursor4;
                    XTextCursor xTextCursor4;
                    XText xFootnoteText;
                    XFootnote XFootnote2 = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xFootnotes.getByIndex(i));
                    XText xText2 = xFootnoteText = XFootnote2 == null ? null : (XText)UnoRuntime.queryInterface(XText.class, (Object)XFootnote2);
                    if (xFootnoteText == null) continue;
                    if (xViewCursorText.equals(xFootnoteText)) {
                        xTextCursor4 = xFootnoteText.createTextCursorByRange(vCursor.getStart());
                        xParagraphCursor4 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor4);
                        int pos = 0;
                        while (xParagraphCursor4.gotoPreviousParagraph(false)) {
                            ++pos;
                        }
                        xParagraphCursor = new DocumentCache.TextParagraph(1, pos + nLastPara);
                        return xParagraphCursor;
                    }
                    xTextCursor4 = xFootnoteText.createTextCursor();
                    xParagraphCursor4 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor4);
                    xParagraphCursor4.gotoStart(false);
                    ++nLastPara;
                    while (xParagraphCursor4.gotoNextParagraph(false)) {
                        ++nLastPara;
                    }
                }
            }
            XIndexAccess xIndexAccess3 = xEndnotes = (xEndnotesSupplier = (XEndnotesSupplier)UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)curDoc)) == null ? null : (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xEndnotesSupplier.getEndnotes());
            if (xEndnotes != null) {
                int nLastPara = 0;
                for (int i = 0; i < xEndnotes.getCount(); ++i) {
                    XText xEndnoteText;
                    XFootnote xEndnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xEndnotes.getByIndex(i));
                    XText xText3 = xEndnoteText = xEndnote == null ? null : (XText)UnoRuntime.queryInterface(XText.class, (Object)xEndnote);
                    if (xEndnoteText == null) continue;
                    if (xViewCursorText.equals(xEndnoteText)) {
                        xTextCursor = xEndnoteText.createTextCursorByRange(vCursor.getStart());
                        xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                        int pos = 0;
                        while (xParagraphCursor.gotoPreviousParagraph(false)) {
                            ++pos;
                        }
                        DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(0, pos + nLastPara);
                        return textParagraph;
                    }
                    xTextCursor = xEndnoteText.createTextCursor();
                    xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                    xParagraphCursor.gotoStart(false);
                    ++nLastPara;
                    while (xParagraphCursor.gotoNextParagraph(false)) {
                        ++nLastPara;
                    }
                }
            }
            List<XPropertySet> xPagePropertySets = this.getPagePropertySets();
            int nLastPara = 0;
            if (xPagePropertySets != null) {
                for (XPropertySet xPagePropertySet : xPagePropertySets) {
                    if (xPagePropertySet == null) continue;
                    boolean firstIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FirstIsShared"));
                    boolean headerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsOn"));
                    boolean headerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsShared"));
                    boolean footerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsOn"));
                    boolean footerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsShared"));
                    for (int i = 0; i < DocumentCursorTools.HeaderFooterTypes.length; ++i) {
                        XParagraphCursor xParagraphCursor5;
                        XTextCursor xTextCursor5;
                        XText xHeaderText;
                        if (!(headerIsOn && (i == 0 && headerIsShared || (i == 1 || i == 2) && !headerIsShared || i == 3 && !firstIsShared)) && (!footerIsOn || (i != 4 || !footerIsShared) && (i != 5 && i != 6 || footerIsShared) && (i != 7 || firstIsShared)) || (xHeaderText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPagePropertySet.getPropertyValue(DocumentCursorTools.HeaderFooterTypes[i]))) == null || xHeaderText.getString().isEmpty()) continue;
                        if (xViewCursorText.equals(xHeaderText)) {
                            xTextCursor5 = xHeaderText.createTextCursorByRange(vCursor.getStart());
                            xParagraphCursor5 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor5);
                            int pos = 0;
                            while (xParagraphCursor5.gotoPreviousParagraph(false)) {
                                ++pos;
                            }
                            DocumentCache.TextParagraph textParagraph = new DocumentCache.TextParagraph(2, pos + nLastPara);
                            return textParagraph;
                        }
                        xTextCursor5 = xHeaderText.createTextCursor();
                        xParagraphCursor5 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor5);
                        xParagraphCursor5.gotoStart(false);
                        ++nLastPara;
                        while (xParagraphCursor5.gotoNextParagraph(false)) {
                            ++nLastPara;
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            --isBusy;
        }
        return new DocumentCache.TextParagraph(-1, -1);
    }

    int getViewCursorCharacter() {
        ++isBusy;
        try {
            XParagraphCursor xParagraphCursor = this.getParagraphCursorFromViewCursor();
            if (xParagraphCursor == null) {
                int n = -1;
                return n;
            }
            xParagraphCursor.collapseToStart();
            xParagraphCursor.gotoStartOfParagraph(true);
            int n = xParagraphCursor.getString().length();
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = -2;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getViewCursorSelectedArea() {
        ++isBusy;
        try {
            XTextTablesSupplier xTableSupplier;
            XIndexAccess xTables;
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor == null) {
                String string = null;
                return string;
            }
            XText xViewCursorText = vCursor.getText();
            if (xViewCursorText == null) {
                String string = null;
                return string;
            }
            XTextDocument curDoc = this.getTextDocument();
            if (curDoc != null && (xTables = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)(xTableSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)curDoc)).getTextTables())) != null) {
                for (int i = 0; i < xTables.getCount(); ++i) {
                    XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                    if (xTable == null) continue;
                    for (String cellName : xTable.getCellNames()) {
                        XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                        if (xTableText == null || !xViewCursorText.equals(xTableText)) continue;
                        XTextViewCursor range = vCursor;
                        String string = new String(xTableText.createTextCursorByRange((XTextRange)range).getString());
                        return string;
                    }
                }
            }
            String string = new String(vCursor.getString());
            return string;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            String string = null;
            return string;
        }
        finally {
            --isBusy;
        }
    }

    private static int setViewCursorToParaIfFits(int xChar, int numPara, int nLastPara, XText xText, XTextViewCursor vCursor) {
        XTextCursor xTextCursor = xText.createTextCursor();
        XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
        if (xParagraphCursor != null) {
            xParagraphCursor.gotoStart(false);
            while (nLastPara < numPara && xParagraphCursor.gotoNextParagraph(false)) {
                ++nLastPara;
            }
            if (numPara == nLastPara) {
                xParagraphCursor.gotoStartOfParagraph(false);
                xParagraphCursor.gotoEndOfParagraph(true);
                vCursor.gotoRange(xParagraphCursor.getStart(), false);
                vCursor.goRight((short)xChar, false);
            }
        } else {
            MessageHandler.printToLogFile("ViewCursorTools: setViewCursorToParaIfFits: xParagraphCursor == null");
        }
        return nLastPara;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewCursorToHeaderFooter(int xChar, int numPara) {
        ++isBusy;
        try {
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor != null) {
                List<XPropertySet> xPagePropertySets = this.getPagePropertySets();
                int nLastPara = 0;
                for (XPropertySet xPagePropertySet : xPagePropertySets) {
                    if (xPagePropertySet == null) continue;
                    boolean firstIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FirstIsShared"));
                    boolean headerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsOn"));
                    boolean headerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsShared"));
                    boolean footerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsOn"));
                    boolean footerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsShared"));
                    for (int i = 0; i < DocumentCursorTools.HeaderFooterTypes.length; ++i) {
                        XText xHeaderText;
                        if (!(headerIsOn && (i == 0 && headerIsShared || (i == 1 || i == 2) && !headerIsShared || i == 3 && !firstIsShared)) && (!footerIsOn || (i != 4 || !footerIsShared) && (i != 5 && i != 6 || footerIsShared) && (i != 7 || firstIsShared)) || (xHeaderText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPagePropertySet.getPropertyValue(DocumentCursorTools.HeaderFooterTypes[i]))) == null || xHeaderText.getString().isEmpty()) continue;
                        if ((nLastPara = ViewCursorTools.setViewCursorToParaIfFits(xChar, numPara, nLastPara, xHeaderText, vCursor)) >= numPara) {
                            return;
                        }
                        ++nLastPara;
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XIndexAccess getIndexAccessOfAllTables() {
        ++isBusy;
        try {
            XTextDocument curDoc = this.getTextDocument();
            if (curDoc == null) {
                XIndexAccess xIndexAccess = null;
                return xIndexAccess;
            }
            XTextTablesSupplier xTableSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)curDoc);
            XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xTableSupplier.getTextTables());
            return xIndexAccess;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            XIndexAccess xIndexAccess = null;
            return xIndexAccess;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewCursorToParagraphOfTable(int xChar, int numPara) {
        ++isBusy;
        try {
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor != null) {
                XIndexAccess xTables = this.getIndexAccessOfAllTables();
                if (xTables == null) {
                    return;
                }
                int nLastPara = 0;
                for (int i = 0; i < xTables.getCount(); ++i) {
                    XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                    for (String cellName : xTable.getCellNames()) {
                        XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                        if ((nLastPara = ViewCursorTools.setViewCursorToParaIfFits(xChar, numPara, nLastPara, xTableText, vCursor)) == numPara) {
                            return;
                        }
                        ++nLastPara;
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewCursorToParagraphOfFootnote(int xChar, int numPara) {
        ++isBusy;
        try {
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor != null) {
                XTextDocument curDoc = this.getTextDocument();
                if (curDoc == null) {
                    return;
                }
                XFootnotesSupplier xFootnoteSupplier = (XFootnotesSupplier)UnoRuntime.queryInterface(XFootnotesSupplier.class, (Object)curDoc);
                XIndexAccess xFootnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xFootnoteSupplier.getFootnotes());
                int nLastPara = 0;
                for (int i = 0; i < xFootnotes.getCount(); ++i) {
                    XFootnote XFootnote2 = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xFootnotes.getByIndex(i));
                    XText xFootnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)XFootnote2);
                    if ((nLastPara = ViewCursorTools.setViewCursorToParaIfFits(xChar, numPara, nLastPara, xFootnoteText, vCursor)) >= numPara) {
                        return;
                    }
                    ++nLastPara;
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewCursorToParagraphOfEndnote(int xChar, int numPara) {
        ++isBusy;
        try {
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor != null) {
                XTextDocument curDoc = this.getTextDocument();
                if (curDoc == null) {
                    return;
                }
                XEndnotesSupplier xEndnotesSupplier = (XEndnotesSupplier)UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)curDoc);
                XIndexAccess xFootnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xEndnotesSupplier.getEndnotes());
                int nLastPara = 0;
                for (int i = 0; i < xFootnotes.getCount(); ++i) {
                    XFootnote xEndnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xFootnotes.getByIndex(i));
                    XText xEndnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xEndnote);
                    if ((nLastPara = ViewCursorTools.setViewCursorToParaIfFits(xChar, numPara, nLastPara, xEndnoteText, vCursor)) >= numPara) {
                        return;
                    }
                    ++nLastPara;
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewCursorToParagraphOfShape(int xChar, int numPara) {
        ++isBusy;
        try {
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor != null) {
                XTextDocument curDoc = this.getTextDocument();
                if (curDoc == null) {
                    return;
                }
                XDrawPageSupplier xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)curDoc);
                if (xDrawPageSupplier == null) {
                    return;
                }
                XDrawPage xDrawPage = xDrawPageSupplier.getDrawPage();
                if (xDrawPage == null) {
                    return;
                }
                XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
                int nLastPara = 0;
                int nShapes = xShapes.getCount();
                for (int j = 0; j < nShapes; ++j) {
                    XText xShapeText;
                    Object oShape = xShapes.getByIndex(j);
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                    if (xShape == null || (xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape)) == null) continue;
                    if ((nLastPara = ViewCursorTools.setViewCursorToParaIfFits(xChar, numPara, nLastPara, xShapeText, vCursor)) == numPara) {
                        return;
                    }
                    ++nLastPara;
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDocumentTextViewCursor(int xChar, int paraNum) {
        ++isBusy;
        try {
            XTextDocument curDoc;
            XText xText;
            XTextCursor xTextCursor;
            XParagraphCursor pCursor;
            XTextViewCursor vCursor = this.getViewCursor();
            if (vCursor != null && (pCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)(xTextCursor = (xText = (curDoc = this.getTextDocument()).getText()).createTextCursor()))) != null) {
                pCursor.gotoStart(false);
                for (int i = 0; i < paraNum && pCursor.gotoNextParagraph(false); ++i) {
                }
                pCursor.gotoStartOfParagraph(false);
                vCursor.gotoRange(pCursor.getStart(), false);
                vCursor.goRight((short)xChar, false);
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTextViewCursor(int xChar, DocumentCache.TextParagraph yPara) {
        ++isBusy;
        try {
            if (yPara.type == 4) {
                this.setDocumentTextViewCursor(xChar, yPara.number);
            } else if (yPara.type == 5) {
                this.setViewCursorToParagraphOfTable(xChar, yPara.number);
            } else if (yPara.type == 3) {
                this.setViewCursorToParagraphOfShape(xChar, yPara.number);
            } else if (yPara.type == 1) {
                this.setViewCursorToParagraphOfFootnote(xChar, yPara.number);
            } else if (yPara.type == 0) {
                this.setViewCursorToParagraphOfEndnote(xChar, yPara.number);
            } else if (yPara.type == 2) {
                this.setViewCursorToHeaderFooter(xChar, yPara.number);
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    public static boolean isBusy() {
        return isBusy > 0;
    }

    public static void reset() {
        isBusy = 0;
    }
}

