/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.lang.Locale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.SortedTextRules;
import org.languagetool.openoffice.SwJLanguageTool;

public class TextLevelCheckQueue {
    public static final int NO_FLAG = 0;
    public static final int RESET_FLAG = 1;
    public static final int STOP_FLAG = 2;
    public static final int DISPOSE_FLAG = 3;
    private static final int HEAP_CHECK_INTERVAL = 50;
    private static final int MAX_CHECK_PER_THREAD = 50;
    private List<QueueEntry> textRuleQueue = Collections.synchronizedList(new ArrayList());
    private MultiDocumentsHandler multiDocHandler;
    private SortedTextRules sortedTextRules = null;
    private QueueIterator queueIterator = null;
    private DocumentCache.TextParagraph lastStart = null;
    private DocumentCache.TextParagraph lastEnd = null;
    private int lastCache = -1;
    private String lastDocId = null;
    private Language lastLanguage = null;
    private boolean interruptCheck = false;
    private boolean queueRuns = false;
    private int numSinceHeapTest = 0;
    private static boolean debugMode = false;
    private static boolean debugModeTm;

    TextLevelCheckQueue(MultiDocumentsHandler multiDocumentsHandler) {
        this.multiDocHandler = multiDocumentsHandler;
        debugMode = OfficeTools.DEBUG_MODE_TQ;
        debugModeTm = OfficeTools.DEBUG_MODE_TM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueEntry(DocumentCache.TextParagraph nStart, DocumentCache.TextParagraph nEnd, int nCache, int nCheck, String docId, boolean overrideRunning) {
        List<QueueEntry> list;
        if (nStart == null || nEnd == null || nStart.type != nEnd.type || nStart.number < 0 || nEnd.number <= nStart.number || nCache < 0 || docId == null || this.interruptCheck) {
            if (debugMode) {
                MessageHandler.printToLogFile("TextLevelCheckQueue: addQueueEntry: Return without add to queue: nCache = " + nCache + ", nStart = " + nStart + ", nEnd = " + nEnd + ", nCheck = " + nCheck + ", docId = " + docId + ", overrideRunning = " + overrideRunning);
            }
            return;
        }
        QueueEntry queueEntry = new QueueEntry(nStart, nEnd, nCache, nCheck, docId, overrideRunning);
        if (!this.textRuleQueue.isEmpty()) {
            if (!overrideRunning && this.lastStart != null && nStart.type == this.lastStart.type && nStart.number >= this.lastStart.number && nEnd.number <= this.lastEnd.number && nCache == this.lastCache && this.lastDocId != null && docId.equals(this.lastDocId)) {
                return;
            }
            list = this.textRuleQueue;
            synchronized (list) {
                QueueEntry entry;
                int i;
                for (i = 0; i < this.textRuleQueue.size(); ++i) {
                    entry = this.textRuleQueue.get(i);
                    if (!entry.isObsolete(queueEntry)) continue;
                    if (!overrideRunning) {
                        return;
                    }
                    this.textRuleQueue.remove(i);
                    if (!debugMode) continue;
                    MessageHandler.printToLogFile("TextLevelCheckQueue: addQueueEntry: remove queue entry: docId = " + entry.docId + ", nStart.type = " + entry.nStart.type + ", nStart.number = " + entry.nStart.number + ", nEnd.number = " + entry.nEnd.number + ", nCache = " + entry.nCache + ", nCheck = " + entry.nCheck + ", overrideRunning = " + entry.overrideRunning);
                }
                if (overrideRunning) {
                    for (i = 0; i < this.textRuleQueue.size(); ++i) {
                        entry = this.textRuleQueue.get(i);
                        if (entry.isEqualButSmallerCacheNumber(queueEntry)) continue;
                        this.textRuleQueue.add(i, queueEntry);
                        if (debugMode) {
                            MessageHandler.printToLogFile("TextLevelCheckQueue: addQueueEntry: add queue entry at position: " + i + "; docId = " + queueEntry.docId + ", nStart.type = " + queueEntry.nStart.type + ", nStart.number = " + queueEntry.nStart.number + ", nEnd.number = " + queueEntry.nEnd.number + ", nCache = " + queueEntry.nCache + ", nCheck = " + queueEntry.nCheck + ", overrideRunning = " + queueEntry.overrideRunning);
                        }
                        return;
                    }
                }
            }
        }
        list = this.textRuleQueue;
        synchronized (list) {
            this.textRuleQueue.add(queueEntry);
            if (debugMode) {
                MessageHandler.printToLogFile("TextLevelCheckQueue: addQueueEntry: add queue entry at position: " + (this.textRuleQueue.size() - 1) + "; docId = " + queueEntry.docId + ", nStart.type = " + queueEntry.nStart.type + ", nStart.number = " + queueEntry.nStart.number + ", nEnd.number = " + queueEntry.nEnd.number + ", nCache = " + queueEntry.nCache + ", nCheck = " + queueEntry.nCheck + ", overrideRunning = " + queueEntry.overrideRunning);
            }
        }
        this.interruptCheck = false;
        this.wakeupQueue();
    }

    public QueueEntry createQueueEntry(DocumentCache.TextParagraph nStart, DocumentCache.TextParagraph nEnd, int nCache, int nCheck, String docId, boolean overrideRunning) {
        return new QueueEntry(nStart, nEnd, nCache, nCheck, docId, overrideRunning);
    }

    public QueueEntry createQueueEntry(DocumentCache.TextParagraph nStart, DocumentCache.TextParagraph nEnd, int cacheNum, int nCheck, String docId) {
        return this.createQueueEntry(nStart, nEnd, cacheNum, nCheck, docId, false);
    }

    private void wakeupQueue() {
        if (debugMode) {
            MessageHandler.printToLogFile("TextLevelCheckQueue: wakeupQueue: wake queue");
        }
        if (this.queueIterator == null) {
            this.queueIterator = new QueueIterator();
            this.queueIterator.start();
        }
    }

    public void wakeupQueue(String docId) {
        if (this.lastDocId == null) {
            this.lastDocId = docId;
        }
        this.wakeupQueue();
    }

    public void setStop() {
        if (this.queueRuns) {
            this.interruptCheck = true;
            QueueEntry queueEntry = new QueueEntry();
            queueEntry.setStop();
            if (debugMode) {
                MessageHandler.printToLogFile("TextLevelCheckQueue: setStop: stop queue");
            }
            this.textRuleQueue.add(0, queueEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReset() {
        if (this.queueRuns) {
            this.interruptCheck = true;
            QueueEntry queueEntry = new QueueEntry();
            queueEntry.setReset();
            if (debugMode) {
                MessageHandler.printToLogFile("TextLevelCheckQueue: setReset: reset queue");
            }
            List<QueueEntry> list = this.textRuleQueue;
            synchronized (list) {
                this.textRuleQueue.clear();
            }
            this.textRuleQueue.add(queueEntry);
        }
        this.wakeupQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptCheck(String docId, boolean wait) {
        if (debugMode) {
            MessageHandler.printToLogFile("TextLevelCheckQueue: interruptCheck: interrupt queue");
        }
        if (!this.textRuleQueue.isEmpty()) {
            List<QueueEntry> list = this.textRuleQueue;
            synchronized (list) {
                for (int i = this.textRuleQueue.size() - 1; i >= 0; --i) {
                    QueueEntry queueEntry = this.textRuleQueue.get(i);
                    if (!docId.equals(queueEntry.docId)) continue;
                    this.textRuleQueue.remove(queueEntry);
                }
            }
        }
        if (wait && this.queueRuns && this.lastStart != null && this.lastDocId != null && this.lastDocId.equals(docId)) {
            this.lastDocId = null;
        }
    }

    SingleDocument getSingleDocument(String docId) {
        for (SingleDocument document : this.multiDocHandler.getDocuments()) {
            if (!docId.equals(document.getDocID())) continue;
            return document;
        }
        return null;
    }

    Language getLanguage(String docId, DocumentCache.TextParagraph nStart) {
        SingleDocument document = this.getSingleDocument(docId);
        DocumentCache docCache = null;
        if (document != null && (docCache = document.getDocumentCache()) != null && nStart.number < docCache.textSize(nStart)) {
            if (docCache.isAutomaticGenerated(docCache.getFlatParagraphNumber(nStart), true)) {
                return null;
            }
            Locale locale = docCache.getTextParagraphLocale(nStart);
            if (locale != null && MultiDocumentsHandler.hasLocale(locale)) {
                return MultiDocumentsHandler.getLanguage(locale);
            }
            MessageHandler.printToLogFile("TextLevelCheckQueue: getLanguage: return null: locale = " + (locale == null ? "null" : OfficeTools.localeToString(locale)));
        }
        if (debugMode) {
            if (document == null) {
                MessageHandler.printToLogFile("TextLevelCheckQueue: getLanguage: document == null: return null");
            } else if (docCache == null) {
                MessageHandler.printToLogFile("TextLevelCheckQueue: getLanguage: docCache == null: return null");
            } else if (nStart.number >= docCache.textSize(nStart)) {
                MessageHandler.printToLogFile("TextLevelCheckQueue: getLanguage: nStart.number >= docCache.textSize(nStart): return null");
            }
        }
        return null;
    }

    public boolean isInterrupted() {
        return this.interruptCheck;
    }

    public boolean isRunning() {
        return this.queueRuns;
    }

    public boolean isWaiting() {
        return !this.queueRuns;
    }

    QueueEntry getNextQueueEntry(DocumentCache.TextParagraph nPara, String docId) {
        int i;
        QueueEntry queueEntry;
        int n;
        List<SingleDocument> documents = this.multiDocHandler.getDocuments();
        int nDoc = 0;
        for (n = 0; n < documents.size(); ++n) {
            if (docId != null && !docId.equals(documents.get(n).getDocID()) || documents.get(n).isDisposed() || documents.get(n).getDocumentType() != OfficeTools.DocumentType.WRITER) continue;
            queueEntry = documents.get(n).getNextQueueEntry(nPara);
            if (queueEntry != null) {
                return queueEntry;
            }
            nDoc = n;
            break;
        }
        for (n = 0; n < documents.size(); ++n) {
            if (docId == null || !docId.equals(documents.get(n).getDocID()) || documents.get(n).isDisposed() || documents.get(n).getDocumentType() != OfficeTools.DocumentType.WRITER) continue;
            queueEntry = documents.get(n).getQueueEntryForChangedParagraph();
            if (queueEntry != null) {
                return queueEntry;
            }
            nDoc = n;
            break;
        }
        for (i = nDoc + 1; i < documents.size(); ++i) {
            if (documents.get(i).isDisposed() || documents.get(i).getDocumentType() != OfficeTools.DocumentType.WRITER || (queueEntry = documents.get(i).getNextQueueEntry(null)) == null) continue;
            return queueEntry;
        }
        for (i = 0; i < nDoc; ++i) {
            if (documents.get(i).isDisposed() || documents.get(i).getDocumentType() != OfficeTools.DocumentType.WRITER || (queueEntry = documents.get(i).getNextQueueEntry(null)) == null) continue;
            return queueEntry;
        }
        return null;
    }

    private boolean testHeapSpace() {
        if (this.numSinceHeapTest > 50) {
            this.numSinceHeapTest = 0;
            if (!this.multiDocHandler.isEnoughHeapSpace()) {
                return false;
            }
        } else {
            ++this.numSinceHeapTest;
        }
        return true;
    }

    void runQueueEntry(QueueEntry qEntry, MultiDocumentsHandler multiDocHandler, SwJLanguageTool lt) throws Throwable {
        if (this.testHeapSpace()) {
            SingleDocument document = this.getSingleDocument(qEntry.docId);
            if (document != null && !document.isDisposed()) {
                if (debugMode) {
                    MessageHandler.printToLogFile("TextLevelCheckQueue: runQueueEntry: nstart = " + qEntry.nStart.number + "; nEnd = " + qEntry.nEnd.number + "; nCache = " + qEntry.nCache + "; nCheck = " + qEntry.nCheck + "; overrideRunning = " + qEntry.overrideRunning);
                }
                document.runQueueEntry(qEntry.nStart, qEntry.nEnd, qEntry.nCache, qEntry.nCheck, qEntry.overrideRunning, lt);
            }
        } else {
            MessageHandler.printToLogFile("Warning: Not enough heap space; text level queue stopped!");
            this.setStop();
        }
    }

    private class QueueIterator
    extends Thread {
        private SwJLanguageTool lt;
        private int numCheck = 0;

        public void initLangtool(Language language) throws Throwable {
            if (debugMode) {
                MessageHandler.printToLogFile("TextLevelCheckQueue: initLangtool: language = " + (language == null ? "null" : language.getShortCodeWithCountryAndVariant()));
            }
            this.lt = TextLevelCheckQueue.this.multiDocHandler.initLanguageTool(language, false);
            if (this.lt != null) {
                TextLevelCheckQueue.this.multiDocHandler.initCheck(this.lt);
                String langCode = OfficeTools.localeToString(TextLevelCheckQueue.this.multiDocHandler.getLocale());
                TextLevelCheckQueue.this.sortedTextRules = new SortedTextRules(this.lt, TextLevelCheckQueue.this.multiDocHandler.getConfiguration(), TextLevelCheckQueue.this.multiDocHandler.getDisabledRules(langCode), false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = 0L;
                TextLevelCheckQueue.this.queueRuns = true;
                if (debugMode) {
                    MessageHandler.printToLogFile("TextLevelCheckQueue: run: queue started");
                }
                while (this.numCheck < 50) {
                    QueueEntry queueEntry;
                    long runTime;
                    Object queueEntry2;
                    if (TextLevelCheckQueue.this.interruptCheck) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException e) {
                            MessageHandler.printException(e);
                        }
                        TextLevelCheckQueue.this.interruptCheck = false;
                        continue;
                    }
                    if (TextLevelCheckQueue.this.textRuleQueue.isEmpty()) {
                        List e = TextLevelCheckQueue.this.textRuleQueue;
                        synchronized (e) {
                            if (TextLevelCheckQueue.this.lastDocId != null) {
                                queueEntry2 = null;
                                try {
                                    if (debugModeTm) {
                                        startTime = System.currentTimeMillis();
                                    }
                                    if (!TextLevelCheckQueue.this.interruptCheck) {
                                        queueEntry2 = TextLevelCheckQueue.this.getNextQueueEntry(TextLevelCheckQueue.this.lastStart, TextLevelCheckQueue.this.lastDocId);
                                    }
                                    if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                                        MessageHandler.printToLogFile("Time to run Text Level Check Queue (get Next Queue Entry): " + runTime);
                                    }
                                }
                                catch (Throwable e2) {
                                    if (debugMode) {
                                        MessageHandler.showError(e2);
                                    }
                                    MessageHandler.printException(e2);
                                }
                                if (queueEntry2 != null && !TextLevelCheckQueue.this.interruptCheck) {
                                    TextLevelCheckQueue.this.textRuleQueue.add(queueEntry2);
                                    queueEntry2 = null;
                                    continue;
                                }
                            }
                        }
                        try {
                            if (debugMode) {
                                MessageHandler.printToLogFile("TextLevelCheckQueue: run: queue waits");
                            }
                            TextLevelCheckQueue.this.lastStart = null;
                            TextLevelCheckQueue.this.lastEnd = null;
                            TextLevelCheckQueue.this.queueRuns = false;
                            TextLevelCheckQueue.this.queueIterator = null;
                            return;
                        }
                        catch (Throwable e2) {
                            MessageHandler.showError(e2);
                            TextLevelCheckQueue.this.queueRuns = false;
                            TextLevelCheckQueue.this.queueIterator = null;
                            return;
                        }
                    }
                    queueEntry2 = TextLevelCheckQueue.this.textRuleQueue;
                    synchronized (queueEntry2) {
                        if (TextLevelCheckQueue.this.textRuleQueue.isEmpty()) {
                            continue;
                        }
                        queueEntry = (QueueEntry)TextLevelCheckQueue.this.textRuleQueue.get(0);
                        TextLevelCheckQueue.this.textRuleQueue.remove(0);
                    }
                    if (queueEntry.special == 2) {
                        if (debugMode) {
                            MessageHandler.printToLogFile("TextLevelCheckQueue: run: queue ended");
                        }
                        TextLevelCheckQueue.this.queueRuns = false;
                        TextLevelCheckQueue.this.queueIterator = null;
                        TextLevelCheckQueue.this.interruptCheck = false;
                        return;
                    }
                    if (queueEntry.special == 1) {
                        if (debugMode) {
                            MessageHandler.printToLogFile("TextLevelCheckQueue: run: reset queue");
                        }
                        try {
                            if (debugMode) {
                                MessageHandler.printToLogFile("TextLevelCheckQueue: run: queue waits");
                            }
                            TextLevelCheckQueue.this.lastStart = null;
                            TextLevelCheckQueue.this.lastEnd = null;
                            TextLevelCheckQueue.this.lastLanguage = null;
                            TextLevelCheckQueue.this.interruptCheck = false;
                            continue;
                        }
                        catch (Throwable e) {
                            MessageHandler.showError(e);
                            TextLevelCheckQueue.this.queueRuns = false;
                            TextLevelCheckQueue.this.queueIterator = null;
                            return;
                        }
                    }
                    if (debugMode) {
                        MessageHandler.printToLogFile("TextLevelCheckQueue: run: run queue entry: docId = " + queueEntry.docId + ", nStart.type = " + queueEntry.nStart.type + ", nStart.number = " + queueEntry.nStart.number + ", nEnd.number = " + queueEntry.nEnd.number + ", nCheck = " + queueEntry.nCheck + ", overrideRunning = " + queueEntry.overrideRunning);
                        if (queueEntry.nStart.number + 1 == queueEntry.nEnd.number) {
                            SingleDocument document = TextLevelCheckQueue.this.getSingleDocument(queueEntry.docId);
                            MessageHandler.printToLogFile("TextLevelCheckQueue: run: Paragraph(" + queueEntry.nStart.number + "): '" + document.getDocumentCache().getTextParagraph(queueEntry.nStart) + "'");
                        }
                    }
                    try {
                        if (debugModeTm) {
                            startTime = System.currentTimeMillis();
                        }
                        Language entryLanguage = null;
                        if (!TextLevelCheckQueue.this.interruptCheck) {
                            entryLanguage = TextLevelCheckQueue.this.getLanguage(queueEntry.docId, queueEntry.nStart);
                        }
                        if (entryLanguage != null) {
                            if (this.lt == null || TextLevelCheckQueue.this.lastLanguage == null || !TextLevelCheckQueue.this.lastLanguage.equals(entryLanguage)) {
                                TextLevelCheckQueue.this.lastLanguage = entryLanguage;
                                if (!TextLevelCheckQueue.this.interruptCheck) {
                                    this.initLangtool(TextLevelCheckQueue.this.lastLanguage);
                                    if (this.lt == null) {
                                        MessageHandler.printToLogFile("TextLevelCheckQueue: run: lt == null: lastLanguage == " + (TextLevelCheckQueue.this.lastLanguage == null ? "null" : TextLevelCheckQueue.this.lastLanguage.getShortCodeWithCountryAndVariant()));
                                        TextLevelCheckQueue.this.queueRuns = false;
                                        TextLevelCheckQueue.this.queueIterator = null;
                                        return;
                                    }
                                }
                                if (!TextLevelCheckQueue.this.interruptCheck) {
                                    TextLevelCheckQueue.this.sortedTextRules.activateTextRulesByIndex(queueEntry.nCache, this.lt);
                                }
                            } else if (TextLevelCheckQueue.this.lastCache != queueEntry.nCache && !TextLevelCheckQueue.this.interruptCheck) {
                                TextLevelCheckQueue.this.sortedTextRules.activateTextRulesByIndex(queueEntry.nCache, this.lt);
                            }
                        }
                        TextLevelCheckQueue.this.lastDocId = queueEntry.docId;
                        TextLevelCheckQueue.this.lastStart = queueEntry.nStart;
                        TextLevelCheckQueue.this.lastEnd = queueEntry.nEnd;
                        TextLevelCheckQueue.this.lastCache = queueEntry.nCache;
                        if (debugMode && entryLanguage == null) {
                            MessageHandler.printToLogFile("TextLevelCheckQueue: run: entryLanguage == null: lt set to null");
                        }
                        if (!TextLevelCheckQueue.this.interruptCheck) {
                            ++this.numCheck;
                            TextLevelCheckQueue.this.runQueueEntry(queueEntry, TextLevelCheckQueue.this.multiDocHandler, entryLanguage == null ? null : this.lt);
                        }
                        queueEntry = null;
                        if (!debugModeTm || (runTime = System.currentTimeMillis() - startTime) <= (long)OfficeTools.TIME_TOLERANCE) continue;
                        MessageHandler.printToLogFile("Time to run Text Level Check Queue (run Queue Entry): " + runTime);
                    }
                    catch (Throwable e) {
                        if (debugMode) {
                            MessageHandler.showError(e);
                            continue;
                        }
                        MessageHandler.printException(e);
                    }
                }
            }
            catch (Throwable e) {
                MessageHandler.showError(e);
                TextLevelCheckQueue.this.queueRuns = false;
                TextLevelCheckQueue.this.queueIterator = null;
            }
            TextLevelCheckQueue.this.queueRuns = false;
            TextLevelCheckQueue.this.queueIterator = null;
            if (this.numCheck >= 50) {
                TextLevelCheckQueue.this.wakeupQueue();
            }
        }
    }

    static class QueueEntry {
        DocumentCache.TextParagraph nStart;
        DocumentCache.TextParagraph nEnd;
        int nCache;
        int nCheck;
        String docId;
        boolean overrideRunning;
        int special = 0;

        QueueEntry(DocumentCache.TextParagraph nStart, DocumentCache.TextParagraph nEnd, int nCache, int nCheck, String docId, boolean overrideRunning) {
            this.nStart = nStart;
            this.nEnd = nEnd;
            this.nCache = nCache;
            this.nCheck = nCheck;
            this.docId = docId;
            this.overrideRunning = overrideRunning;
        }

        QueueEntry(DocumentCache.TextParagraph nStart, DocumentCache.TextParagraph nEnd, int nCache, int nCheck, String docId) {
            this(nStart, nEnd, nCache, nCheck, docId, false);
        }

        QueueEntry() {
        }

        void setReset() {
            this.special = 1;
        }

        void setStop() {
            this.special = 2;
        }

        void setDispose(String docId) {
            this.special = 3;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof QueueEntry)) {
                return false;
            }
            QueueEntry e = (QueueEntry)o;
            if (this.nStart == null || this.nEnd == null || e.nStart == null || e.nEnd == null) {
                return false;
            }
            return this.nStart.type == e.nStart.type && this.nStart.number == e.nStart.number && this.nEnd.number == e.nEnd.number && this.nCache == e.nCache && this.nCheck == e.nCheck && this.docId.equals(e.docId);
        }

        public boolean isEqualButSmallerCacheNumber(QueueEntry e) {
            if (e == null || this.nStart == null || this.nEnd == null || e.nStart == null || e.nEnd == null || this.nStart.type != e.nStart.type) {
                return false;
            }
            return this.nStart.number >= e.nStart.number && this.nEnd.number <= e.nEnd.number && this.nCache < e.nCache && this.docId.equals(e.docId);
        }

        public boolean isObsolete(QueueEntry e) {
            if (e == null || this.nStart == null || this.nEnd == null || e.nStart == null || e.nEnd == null || this.nCheck != e.nCheck || this.nCache != e.nCache || this.nStart.type != e.nStart.type || this.docId == null || !this.docId.equals(e.docId)) {
                return false;
            }
            return this.nCheck < -1 || this.nCheck == -1 && e.nStart.number >= this.nStart.number && e.nStart.number <= this.nEnd.number || this.nCheck >= 0 && this.nStart.number == e.nStart.number && this.nEnd.number == e.nEnd.number;
        }
    }
}

