/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.MultiThreadedJLanguageTool;
import org.languagetool.ResultCache;
import org.languagetool.ToneTag;
import org.languagetool.UserConfig;
import org.languagetool.gui.Configuration;
import org.languagetool.markup.AnnotatedTextBuilder;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.LORemoteLanguageTool;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class SwJLanguageTool {
    private static final ResourceBundle MESSAGES = JLanguageTool.getMessageBundle();
    private final MultiThreadedJLanguageToolLo mlt;
    private final LORemoteLanguageTool rlt;
    private JLanguageToolLo lt;
    private boolean isMultiThread;
    private boolean isRemote;
    private boolean doReset;
    private Configuration config;

    public SwJLanguageTool(Language language, Language motherTongue, UserConfig userConfig, Configuration config, List<Rule> extraRemoteRules, boolean testMode) throws MalformedURLException {
        this.config = config;
        this.isMultiThread = config.isMultiThread();
        this.isRemote = config.doRemoteCheck() && !testMode;
        this.doReset = false;
        if (this.isRemote) {
            this.lt = null;
            this.mlt = null;
            this.rlt = new LORemoteLanguageTool(language, motherTongue, config, extraRemoteRules, userConfig);
            if (!this.rlt.remoteRun()) {
                MessageHandler.showMessage(MESSAGES.getString("loRemoteSwitchToLocal"));
                this.isRemote = false;
                this.isMultiThread = false;
                this.lt = new JLanguageToolLo(language, motherTongue, null, userConfig);
            }
        } else if (this.isMultiThread) {
            this.lt = null;
            this.mlt = new MultiThreadedJLanguageToolLo(language, motherTongue, userConfig);
            this.rlt = null;
        } else {
            this.lt = new JLanguageToolLo(language, motherTongue, null, userConfig);
            this.mlt = null;
            this.rlt = null;
        }
    }

    public boolean isRemote() {
        return this.isRemote;
    }

    public List<Rule> getAllRules() {
        if (this.isRemote) {
            return this.rlt.getAllRules();
        }
        if (this.isMultiThread) {
            return this.mlt.getAllRules();
        }
        return this.lt.getAllRules();
    }

    public List<Rule> getAllActiveRules() {
        if (this.isRemote) {
            return this.rlt.getAllActiveRules();
        }
        if (this.isMultiThread) {
            return this.mlt.getAllActiveRules();
        }
        return this.lt.getAllActiveRules();
    }

    public List<Rule> getAllActiveOfficeRules() {
        if (this.isRemote) {
            return this.rlt.getAllActiveOfficeRules();
        }
        if (this.isMultiThread) {
            return this.mlt.getAllActiveOfficeRules();
        }
        return this.lt.getAllActiveOfficeRules();
    }

    public void enableRule(String ruleId) {
        if (this.isRemote) {
            this.rlt.enableRule(ruleId);
        } else if (this.isMultiThread) {
            this.mlt.enableRule(ruleId);
        } else {
            this.lt.enableRule(ruleId);
        }
    }

    public void disableRule(String ruleId) {
        if (this.isRemote) {
            this.rlt.disableRule(ruleId);
        } else if (this.isMultiThread) {
            this.mlt.disableRule(ruleId);
        } else {
            this.lt.disableRule(ruleId);
        }
    }

    public Set<String> getDisabledRules() {
        if (this.isRemote) {
            return this.rlt.getDisabledRules();
        }
        if (this.isMultiThread) {
            return this.mlt.getDisabledRules();
        }
        return this.lt.getDisabledRules();
    }

    public void disableCategory(CategoryId id) {
        if (this.isRemote) {
            this.rlt.disableCategory(id);
        } else if (this.isMultiThread) {
            this.mlt.disableCategory(id);
        } else {
            this.lt.disableCategory(id);
        }
    }

    public void activateLanguageModelRules(File indexDir) throws IOException {
        if (!this.isRemote) {
            if (this.isMultiThread) {
                this.mlt.activateLanguageModelRules(indexDir);
            } else {
                this.lt.activateLanguageModelRules(indexDir);
            }
        }
    }

    public List<RuleMatch> check(DocumentCache.TextParagraph from, DocumentCache.TextParagraph to, String text, JLanguageTool.ParagraphHandling paraMode, SingleDocument document) throws IOException {
        return this.check(from, to, text, paraMode, document, OfficeTools.RemoteCheck.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RuleMatch> check(DocumentCache.TextParagraph from, DocumentCache.TextParagraph to, String text, JLanguageTool.ParagraphHandling paraMode, SingleDocument document, OfficeTools.RemoteCheck checkMode) throws IOException {
        Set<ToneTag> toneTags;
        if (this.isRemote) {
            List<RuleMatch> ruleMatches = this.rlt.check(text, paraMode, checkMode);
            if (ruleMatches == null) {
                this.doReset = true;
                ruleMatches = new ArrayList<RuleMatch>();
            }
            return ruleMatches;
        }
        JLanguageTool.Mode mode = paraMode == JLanguageTool.ParagraphHandling.ONLYNONPARA ? JLanguageTool.Mode.ALL_BUT_TEXTLEVEL_ONLY : (paraMode == JLanguageTool.ParagraphHandling.ONLYPARA ? JLanguageTool.Mode.TEXTLEVEL_ONLY : JLanguageTool.Mode.ALL);
        Set<ToneTag> set = toneTags = this.config.enableGoalSpecificRules() ? Collections.singleton(ToneTag.ALL_TONE_RULES) : Collections.emptySet();
        if (this.isMultiThread) {
            MultiThreadedJLanguageToolLo multiThreadedJLanguageToolLo = this.mlt;
            synchronized (multiThreadedJLanguageToolLo) {
                return this.mlt.check(from, to, paraMode, mode, document, this, toneTags);
            }
        }
        return this.lt.check(from, to, paraMode, mode, document, this, toneTags);
    }

    public List<RuleMatch> check(String text, JLanguageTool.ParagraphHandling paraMode, int nFPara, SingleDocument document) throws IOException {
        return this.check(text, paraMode, nFPara, document, OfficeTools.RemoteCheck.ALL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RuleMatch> check(String text, JLanguageTool.ParagraphHandling paraMode, int nFPara, SingleDocument document, OfficeTools.RemoteCheck checkMode) throws IOException {
        Set<ToneTag> toneTags;
        if (this.isRemote) {
            List<RuleMatch> ruleMatches = this.rlt.check(text, paraMode, checkMode);
            if (ruleMatches == null) {
                this.doReset = true;
                ruleMatches = new ArrayList<RuleMatch>();
            }
            return ruleMatches;
        }
        JLanguageTool.Mode mode = paraMode == JLanguageTool.ParagraphHandling.ONLYNONPARA ? JLanguageTool.Mode.ALL_BUT_TEXTLEVEL_ONLY : (paraMode == JLanguageTool.ParagraphHandling.ONLYPARA ? JLanguageTool.Mode.TEXTLEVEL_ONLY : JLanguageTool.Mode.ALL);
        Set<ToneTag> set = toneTags = this.config.enableGoalSpecificRules() ? Collections.singleton(ToneTag.ALL_TONE_RULES) : Collections.emptySet();
        if (this.isMultiThread) {
            MultiThreadedJLanguageToolLo multiThreadedJLanguageToolLo = this.mlt;
            synchronized (multiThreadedJLanguageToolLo) {
                return this.mlt.check(text, paraMode, mode, nFPara, document, this, toneTags);
            }
        }
        return this.lt.check(text, paraMode, mode, nFPara, document, this, toneTags);
    }

    public List<String> sentenceTokenize(String text) {
        if (this.isRemote) {
            return this.lt.sentenceTokenize(text);
        }
        if (this.isMultiThread) {
            return this.mlt.sentenceTokenize(text);
        }
        return this.lt.sentenceTokenize(text);
    }

    public AnalyzedSentence getAnalyzedSentence(String sentence) throws IOException {
        if (this.isRemote) {
            return this.lt.getAnalyzedSentence(sentence);
        }
        if (this.isMultiThread) {
            return this.mlt.getAnalyzedSentence(sentence);
        }
        return this.lt.getAnalyzedSentence(sentence);
    }

    public List<AnalyzedSentence> analyzeText(String text) throws IOException {
        if (this.isRemote) {
            return this.lt.analyzeText(text);
        }
        if (this.isMultiThread) {
            return this.mlt.analyzeText(text);
        }
        return this.lt.analyzeText(text);
    }

    public List<String> getLemmasOfWord(String word) throws IOException {
        ArrayList<String> lemmas = new ArrayList<String>();
        Language language = this.getLanguage();
        ArrayList<String> words = new ArrayList<String>();
        words.add(word);
        List<AnalyzedTokenReadings> aTokens = language.getTagger().tag(words);
        for (AnalyzedTokenReadings aToken : aTokens) {
            List<AnalyzedToken> readings = aToken.getReadings();
            for (AnalyzedToken reading : readings) {
                String lemma = reading.getLemma();
                if (lemma == null) continue;
                lemmas.add(lemma);
            }
        }
        return lemmas;
    }

    public List<String> getLemmasOfParagraph(String para, int startPos) throws IOException {
        ArrayList<String> lemmas = new ArrayList<String>();
        List<AnalyzedSentence> sentences = this.analyzeText(para);
        int pos = 0;
        for (AnalyzedSentence sentence : sentences) {
            for (AnalyzedTokenReadings token : sentence.getTokens()) {
                if (pos + token.getStartPos() != startPos) continue;
                for (AnalyzedToken reading : token) {
                    String lemma = reading.getLemma();
                    if (lemma == null) continue;
                    lemmas.add(lemma);
                }
            }
            pos += sentence.getCorrectedTextLength();
        }
        return lemmas;
    }

    public Language getLanguage() {
        if (this.isRemote) {
            return this.rlt.getLanguage();
        }
        if (this.isMultiThread) {
            return this.mlt.getLanguage();
        }
        return this.lt.getLanguage();
    }

    public boolean doReset() {
        return this.doReset;
    }

    public class MultiThreadedJLanguageToolLo
    extends MultiThreadedJLanguageTool {
        public MultiThreadedJLanguageToolLo(Language language, Language motherTongue, UserConfig userConfig) {
            super(language, motherTongue, userConfig);
        }

        public List<RuleMatch> check(String text, JLanguageTool.ParagraphHandling paraMode, JLanguageTool.Mode mode, int nFPara, SingleDocument document, SwJLanguageTool lt, @NotNull Set<ToneTag> toneTags) throws IOException {
            List<Object> sentences;
            List<AnalyzedSentence> analyzedSentences;
            if (nFPara < 0) {
                analyzedSentences = this.analyzeText(text);
                sentences = new ArrayList();
                for (AnalyzedSentence analyzedSentence : analyzedSentences) {
                    sentences.add(analyzedSentence.getText());
                }
            } else {
                DocumentCache.AnalysedText analysedText = document.getDocumentCache().getOrCreateAnalyzedParagraph(nFPara, lt);
                analyzedSentences = analysedText.analyzedSentences;
                sentences = analysedText.sentences;
                text = analysedText.text;
            }
            return this.checkInternal(new AnnotatedTextBuilder().addText(text).build(), paraMode, null, mode, JLanguageTool.Level.PICKY, toneTags, null, sentences, analyzedSentences).getRuleMatches();
        }

        public List<RuleMatch> check(DocumentCache.TextParagraph from, DocumentCache.TextParagraph to, JLanguageTool.ParagraphHandling paraMode, JLanguageTool.Mode mode, SingleDocument document, SwJLanguageTool lt, @NotNull Set<ToneTag> toneTags) throws IOException {
            DocumentCache.AnalysedText analysedText = document.getDocumentCache().getAnalyzedParagraphs(from, to, lt);
            if (analysedText == null) {
                return null;
            }
            List<AnalyzedSentence> analyzedSentences = analysedText.analyzedSentences;
            List<String> sentences = analysedText.sentences;
            String text = analysedText.text;
            return this.checkInternal(new AnnotatedTextBuilder().addText(text).build(), paraMode, null, mode, JLanguageTool.Level.PICKY, toneTags, null, sentences, analyzedSentences).getRuleMatches();
        }
    }

    public class JLanguageToolLo
    extends JLanguageTool {
        public JLanguageToolLo(Language language, Language motherTongue, ResultCache cache, UserConfig userConfig) {
            super(language, motherTongue, cache, userConfig);
        }

        public List<RuleMatch> check(String text, JLanguageTool.ParagraphHandling paraMode, JLanguageTool.Mode mode, int nFPara, SingleDocument document, SwJLanguageTool lt, @NotNull Set<ToneTag> toneTags) throws IOException {
            List<Object> sentences;
            List<AnalyzedSentence> analyzedSentences;
            if (nFPara < 0) {
                analyzedSentences = this.analyzeText(text);
                sentences = new ArrayList();
                for (AnalyzedSentence analyzedSentence : analyzedSentences) {
                    sentences.add(analyzedSentence.getText());
                }
            } else {
                DocumentCache.AnalysedText analysedText = document.getDocumentCache().getOrCreateAnalyzedParagraph(nFPara, lt);
                analyzedSentences = analysedText.analyzedSentences;
                sentences = analysedText.sentences;
                text = analysedText.text;
            }
            return this.checkInternal(new AnnotatedTextBuilder().addText(text).build(), paraMode, null, mode, JLanguageTool.Level.PICKY, toneTags, null, sentences, analyzedSentences).getRuleMatches();
        }

        public List<RuleMatch> check(DocumentCache.TextParagraph from, DocumentCache.TextParagraph to, JLanguageTool.ParagraphHandling paraMode, JLanguageTool.Mode mode, SingleDocument document, SwJLanguageTool lt, @NotNull Set<ToneTag> toneTags) throws IOException {
            DocumentCache.AnalysedText analysedText = document.getDocumentCache().getAnalyzedParagraphs(from, to, lt);
            if (analysedText == null) {
                return null;
            }
            List<AnalyzedSentence> analyzedSentences = analysedText.analyzedSentences;
            List<String> sentences = analysedText.sentences;
            String text = analysedText.text;
            return this.checkInternal(new AnnotatedTextBuilder().addText(text).build(), paraMode, null, mode, JLanguageTool.Level.PICKY, toneTags, null, sentences, analyzedSentences).getRuleMatches();
        }
    }
}

