/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.linguistic2.ProofreadingResult;
import com.sun.star.linguistic2.SingleProofreadingError;
import com.sun.star.text.XFlatParagraph;
import com.sun.star.text.XMarkingAccess;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XTextCursor;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.accessibility.Accessible;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.gui.Tools;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.DocumentCursorTools;
import org.languagetool.openoffice.FlatParagraphTools;
import org.languagetool.openoffice.IgnoredMatches;
import org.languagetool.openoffice.LinguisticServices;
import org.languagetool.openoffice.LtDictionary;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeDrawTools;
import org.languagetool.openoffice.OfficeSpreadsheetTools;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.ResultCache;
import org.languagetool.openoffice.SingleCheck;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.SwJLanguageTool;
import org.languagetool.openoffice.ViewCursorTools;
import org.languagetool.rules.Rule;

public class SpellAndGrammarCheckDialog
extends Thread {
    private static boolean debugMode = OfficeTools.DEBUG_MODE_CD;
    private static boolean debugModeTm = OfficeTools.DEBUG_MODE_TM;
    private static final ResourceBundle messages = JLanguageTool.getMessageBundle();
    private static final String spellingError = messages.getString("desc_spelling");
    private static final String spellRuleId = "LO_SPELLING_ERROR";
    private static final int DIALOG_LOOPS = 20;
    private static final int LOOP_WAIT_TIME = 50;
    private static final int TEST_LOOPS = 10;
    private static final String dialogName = messages.getString("guiOOoCheckDialogName");
    private static final String labelLanguage = messages.getString("textLanguage");
    private static final String labelSuggestions = messages.getString("guiOOosuggestions");
    private static final String moreButtonName = messages.getString("guiMore");
    private static final String ignoreButtonName = messages.getString("guiOOoIgnoreButton");
    private static final String ignoreAllButtonName = messages.getString("guiOOoIgnoreAllButton");
    private static final String ignorePermanentButtonName = messages.getString("loContextMenuIgnorePermanent");
    private static final String resetIgnorePermanentButtonName = messages.getString("loMenuResetIgnorePermanent");
    private static final String ignoreRuleButtonName = messages.getString("guiOOoIgnoreRuleButton");
    private static final String deactivateRuleButtonName = messages.getString("loContextMenuDeactivateRule");
    private static final String addToDictionaryName = messages.getString("guiOOoaddToDictionary");
    private static final String changeButtonName = messages.getString("guiOOoChangeButton");
    private static final String changeAllButtonName = messages.getString("guiOOoChangeAllButton");
    private static final String autoCorrectButtonName = messages.getString("guiOOoAutoCorrectButton");
    private static final String helpButtonName = messages.getString("guiOOoHelpButton");
    private static final String optionsButtonName = messages.getString("guiOOoOptionsButton");
    private static final String undoButtonName = messages.getString("guiUndo");
    private static final String closeButtonName = messages.getString("guiOOoCloseButton");
    private static final String[] changeLanguageList = new String[]{messages.getString("guiOOoChangeLanguageRequest"), messages.getString("guiOOoChangeLanguageMatch"), messages.getString("guiOOoChangeLanguageParagraph")};
    private static final String languageHelp = messages.getString("loDialogLanguageHelp");
    private static final String changeLanguageHelp = messages.getString("loDialogChangeLanguageHelp");
    private static final String matchDescriptionHelp = messages.getString("loDialogMatchDescriptionHelp");
    private static final String matchParagraphHelp = messages.getString("loDialogMatchParagraphHelp");
    private static final String suggestionsHelp = messages.getString("loDialogSuggestionsHelp");
    private static final String checkTypeHelp = messages.getString("loDialogCheckTypeHelp");
    private static final String helpButtonHelp = messages.getString("loDialogHelpButtonHelp");
    private static final String optionsButtonHelp = messages.getString("loDialogOptionsButtonHelp");
    private static final String undoButtonHelp = messages.getString("loDialogUndoButtonHelp");
    private static final String closeButtonHelp = messages.getString("loDialogCloseButtonHelp");
    private static final String moreButtonHelp = messages.getString("loDialogMoreButtonHelp");
    private static final String ignoreButtonHelp = messages.getString("loDialogIgnoreButtonHelp");
    private static final String ignoreAllButtonHelp = messages.getString("loDialogIgnoreAllButtonHelp");
    private static final String ignorePermanentButtonHelp = messages.getString("loDialogIgnorePermanentButtonHelp");
    private static final String resetIgnorePermanentButtonHelp = messages.getString("loDialogResetIgnorePermanentButtonHelp");
    private static final String deactivateRuleButtonHelp = messages.getString("loDialogDeactivateRuleButtonHelp");
    private static final String activateRuleButtonHelp = messages.getString("loDialogActivateRuleButtonHelp");
    private static final String addToDictionaryHelp = messages.getString("loDialogAddToDictionaryButtonHelp");
    private static final String changeButtonHelp = messages.getString("loDialogChangeButtonHelp");
    private static final String changeAllButtonHelp = messages.getString("loDialogChangeAllButtonHelp");
    private static final String autoCorrectButtonHelp = messages.getString("loDialogAutoCorrectButtonHelp");
    private static final String checkStatusInitialization = messages.getString("loCheckStatusInitialization");
    private static final String checkStatusCheck = messages.getString("loCheckStatusCheck");
    private static final String labelCheckProgress = messages.getString("loLabelCheckProgress");
    private static final String loBusyMessage = messages.getString("loBusyMessage");
    private static int nLastFlat = 0;
    private final XComponentContext xContext;
    private final MultiDocumentsHandler documents;
    private LinguisticServices linguServices;
    private MultiDocumentsHandler.WaitDialogThread inf;
    private SwJLanguageTool lt = null;
    private Language lastLanguage;
    private Locale locale;
    private int checkType = 0;
    private String checkRuleId = null;
    private DocumentCache docCache;
    private OfficeTools.DocumentType docType = OfficeTools.DocumentType.WRITER;
    private boolean doInit = true;
    private int dialogX = -1;
    private int dialogY = -1;
    private boolean hasUncheckedParas = false;

    SpellAndGrammarCheckDialog(XComponentContext xContext, MultiDocumentsHandler documents, Language language, MultiDocumentsHandler.WaitDialogThread inf) {
        debugMode = OfficeTools.DEBUG_MODE_CD;
        this.xContext = xContext;
        this.documents = documents;
        this.inf = inf;
        this.lastLanguage = language;
        this.locale = LinguisticServices.getLocale(language);
        if (!documents.javaVersionOkay()) {
            return;
        }
        if (documents.noLtSpeller()) {
            this.linguServices = new LinguisticServices(xContext);
        }
    }

    private void setLangTool(SingleDocument document, Language language) {
        try {
            if (document.getDocumentType() == OfficeTools.DocumentType.IMPRESS) {
                this.documents.setCheckImpressDocument(true);
            }
            this.lt = this.documents.initLanguageTool(language, false);
            if (this.lt != null) {
                this.documents.initCheck(this.lt);
                this.documents.resetSortedTextRules(this.lt);
            }
            if (debugMode) {
                for (String id : this.lt.getDisabledRules()) {
                    MessageHandler.printToLogFile("CheckDialog: setLangTool: After init disabled rule: " + id);
                }
            }
            this.doInit = false;
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    @Override
    public void run() {
        try {
            long runTime;
            long startTime = 0L;
            if (debugModeTm) {
                startTime = System.currentTimeMillis();
            }
            SingleDocument currentDocument = this.getCurrentDocument(false);
            if (this.inf.canceled()) {
                return;
            }
            if (currentDocument == null || this.docCache == null || this.docCache.size() <= 0) {
                this.inf.close();
                MessageHandler.showMessage(loBusyMessage);
                this.documents.setLtDialogIsRunning(false);
                return;
            }
            LtCheckDialog checkDialog = new LtCheckDialog(this.xContext, currentDocument, this.inf);
            if (this.inf.canceled()) {
                return;
            }
            this.documents.setLtDialog(checkDialog);
            if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("CheckDialog: Time to initialise dialog: " + runTime);
            }
            this.inf.close();
            checkDialog.show();
        }
        catch (Throwable e) {
            MessageHandler.showError(e);
            this.documents.setLtDialogIsRunning(false);
        }
    }

    private void actualizeNonWriterDocumentCache(SingleDocument document) {
        if (this.docType != OfficeTools.DocumentType.WRITER || this.documents.isBackgroundCheckOff()) {
            DocumentCache oldCache = new DocumentCache(this.docCache);
            this.docCache.refresh(document, null, null, document.getXComponent(), 7);
            if (!oldCache.isEmpty()) {
                boolean isSame = true;
                if (oldCache.size() != this.docCache.size()) {
                    isSame = false;
                } else {
                    for (int i = 0; i < this.docCache.size(); ++i) {
                        if (this.docCache.getFlatParagraph(i).equals(oldCache.getFlatParagraph(i))) continue;
                        isSame = false;
                        break;
                    }
                }
                if (!isSame) {
                    document.resetResultCache(true);
                }
            }
        }
    }

    private SingleDocument getCurrentDocument(boolean actualize) {
        SingleDocument currentDocument = this.documents.getCurrentDocument();
        int nWait = 0;
        while (currentDocument == null) {
            if (this.documents.isNotTextDocument()) {
                return null;
            }
            if (nWait > 400) {
                return null;
            }
            MessageHandler.printToLogFile("CheckDialog: getCurrentDocument: Wait: " + (nWait + 1) * 20);
            ++nWait;
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                MessageHandler.printException(e);
            }
            currentDocument = this.documents.getCurrentDocument();
        }
        if (currentDocument != null) {
            this.docType = currentDocument.getDocumentType();
            this.docCache = currentDocument.getDocumentCache();
            if (this.docType != OfficeTools.DocumentType.WRITER || this.documents.isBackgroundCheckOff()) {
                this.actualizeNonWriterDocumentCache(currentDocument);
            }
        }
        return currentDocument;
    }

    public void nextError() {
        try {
            SingleDocument document = this.getCurrentDocument(false);
            if (document == null || this.docType != OfficeTools.DocumentType.WRITER || !this.documents.isEnoughHeapSpace()) {
                return;
            }
            if (this.docCache == null || this.docCache.size() <= 0) {
                return;
            }
            if (this.lt == null || !this.documents.isCheckImpressDocument()) {
                this.setLangTool(document, this.lastLanguage);
            }
            XComponent xComponent = document.getXComponent();
            DocumentCursorTools docCursor = new DocumentCursorTools(xComponent);
            ViewCursorTools viewCursor = new ViewCursorTools(xComponent);
            int yFlat = this.getCurrentFlatParagraphNumber(viewCursor, this.docCache);
            if (yFlat < 0) {
                MessageHandler.showClosingInformationDialog(messages.getString("loNextErrorUnsupported"));
                return;
            }
            int x = viewCursor.getViewCursorCharacter();
            while (yFlat < this.docCache.size()) {
                CheckError nextError = this.getNextErrorInParagraph(x, yFlat, document, docCursor, false);
                if (nextError != null && this.setFlatViewCursor(nextError.error.nErrorStart + 1, yFlat, viewCursor, this.docCache)) {
                    return;
                }
                x = 0;
                ++yFlat;
            }
            MessageHandler.showClosingInformationDialog(messages.getString("guiCheckComplete"));
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    private int getCurrentFlatParagraphNumber(ViewCursorTools viewCursor, DocumentCache docCache) {
        DocumentCache.TextParagraph textPara = viewCursor.getViewCursorParagraph();
        if (textPara.type == -1) {
            return -1;
        }
        nLastFlat = docCache.getFlatParagraphNumber(textPara);
        return nLastFlat;
    }

    public static void setTextViewCursor(int x, DocumentCache.TextParagraph y, ViewCursorTools viewCursor) {
        viewCursor.setTextViewCursor(x, y);
    }

    private boolean setFlatViewCursor(int xFlat, int yFlat, ViewCursorTools viewCursor, DocumentCache docCache) {
        if (yFlat < 0) {
            return false;
        }
        DocumentCache.TextParagraph para = docCache.getNumberOfTextParagraph(yFlat);
        viewCursor.setTextViewCursor(xFlat, para);
        return true;
    }

    private void changeTextOfParagraph(int nFPara, int nStart, int nLength, String replace, SingleDocument document, ViewCursorTools viewCursor) {
        String sPara = this.docCache.getFlatParagraph(nFPara);
        String sEnd = nStart + nLength < sPara.length() ? sPara.substring(nStart + nLength) : "";
        sPara = sPara.substring(0, nStart) + replace + sEnd;
        if (debugMode) {
            MessageHandler.printToLogFile("CheckDialog: changeTextOfParagraph: set setFlatParagraph: " + sPara);
        }
        if (this.docType == OfficeTools.DocumentType.IMPRESS) {
            OfficeDrawTools.changeTextOfParagraph(nFPara, nStart, nLength, replace, document.getXComponent());
        } else if (this.docType == OfficeTools.DocumentType.CALC) {
            OfficeSpreadsheetTools.setTextofCell(nFPara, sPara, document.getXComponent());
        } else {
            document.getFlatParagraphTools().changeTextOfParagraph(nFPara, nStart, nLength, replace);
        }
        this.docCache.setFlatParagraph(nFPara, sPara);
        document.removeResultCache(nFPara, true);
        document.removeIgnoredMatch(nFPara, true);
        if (this.documents.getConfiguration().useTextLevelQueue() && !this.documents.getConfiguration().noBackgroundCheck()) {
            for (int i = 1; i < this.documents.getNumMinToCheckParas().size(); ++i) {
                document.addQueueEntry(nFPara, i, this.documents.getNumMinToCheckParas().get(i), document.getDocID(), true);
            }
        }
    }

    private Map<Integer, List<Integer>> changeTextInAllParagraph(String word, String ruleID, String replace, SingleDocument document, ViewCursorTools viewCursor) {
        if (word == null || replace == null || word.isEmpty() || replace.isEmpty() || word.equals(replace)) {
            return null;
        }
        HashMap<Integer, List<Integer>> replacePoints = new HashMap<Integer, List<Integer>>();
        int nLength = word.length();
        for (int n = 0; n < this.docCache.size(); ++n) {
            ArrayList<SingleProofreadingError[]> pErrors = new ArrayList<SingleProofreadingError[]>();
            for (ResultCache resultCache : document.getParagraphsCache()) {
                pErrors.add(resultCache.getSafeMatches(n));
            }
            SingleProofreadingError[] errors = document.mergeErrors(pErrors, n);
            if (errors == null) continue;
            ArrayList<Integer> startPoints = null;
            for (int i = errors.length - 1; i >= 0; --i) {
                String sPara;
                String errWord;
                SingleProofreadingError error = errors[i];
                if (nLength != error.nErrorLength || !ruleID.equals(error.aRuleIdentifier) || !word.equals(errWord = (sPara = this.docCache.getFlatParagraph(n)).substring(error.nErrorStart, error.nErrorStart + error.nErrorLength))) continue;
                if (startPoints == null) {
                    startPoints = new ArrayList<Integer>();
                }
                startPoints.add(error.nErrorStart);
                this.changeTextOfParagraph(n, error.nErrorStart, error.nErrorLength, replace, document, viewCursor);
            }
            if (startPoints == null) continue;
            replacePoints.put(n, startPoints);
        }
        return replacePoints;
    }

    private CheckError getNextErrorInParagraph(int x, int nFPara, SingleDocument document, DocumentCursorTools docTools, boolean checkFrames) throws Throwable {
        OfficeTools.LoErrorType errType;
        int[] footnotePosition;
        SingleProofreadingError error;
        if (this.docCache.isAutomaticGenerated(nFPara, true)) {
            return null;
        }
        String text = this.docCache.getFlatParagraph(nFPara);
        this.locale = this.docCache.getFlatParagraphLocale(nFPara);
        if (this.locale.Language.equals("zxx")) {
            this.locale = this.documents.getLocale();
        }
        if ((error = this.getNextGrammatikOrSpellErrorInParagraph(x, nFPara, text, footnotePosition = this.docCache.getFlatParagraphFootnotes(nFPara), this.locale, document, errType = this.checkType == 1 || !checkFrames && this.docCache.getParagraphType(nFPara) == 3 ? OfficeTools.LoErrorType.SPELL : (this.checkType == 2 ? OfficeTools.LoErrorType.GRAMMAR : OfficeTools.LoErrorType.BOTH))) != null) {
            return new CheckError(this.locale, error);
        }
        return null;
    }

    SingleProofreadingError[] getErrorsFromCache(int nFPara) {
        boolean noNull = true;
        SingleDocument document = null;
        ArrayList<SingleProofreadingError[]> errors = new ArrayList<SingleProofreadingError[]>();
        for (int nWait = 0; nWait < 10; ++nWait) {
            document = this.documents.getCurrentDocument();
            for (int cacheNum = 0; cacheNum < this.documents.getNumMinToCheckParas().size(); ++cacheNum) {
                if (!this.docCache.isAutomaticGenerated(nFPara, true) && (cacheNum == 0 || this.documents.isSortedRuleForIndex(cacheNum) && !document.getDocumentCache().isSingleParagraph(nFPara))) {
                    SingleProofreadingError[] pErrors = document.getParagraphsCache().get(cacheNum).getSafeMatches(nFPara);
                    if (pErrors == null) {
                        noNull = false;
                        this.hasUncheckedParas = true;
                        if (debugMode) {
                            MessageHandler.printToLogFile("CheckDialog: getErrorsFromCache: Cache(" + cacheNum + ") is null for Paragraph: " + nFPara);
                        }
                        errors.add(null);
                        continue;
                    }
                    errors.add(pErrors);
                    continue;
                }
                errors.add(new SingleProofreadingError[0]);
            }
            if (noNull) {
                return document.mergeErrors(errors, nFPara);
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                MessageHandler.showError(e);
            }
        }
        for (int cacheNum = 0; cacheNum < this.documents.getNumMinToCheckParas().size(); ++cacheNum) {
            if (!this.documents.isSortedRuleForIndex(cacheNum)) continue;
            document.addQueueEntry(nFPara, cacheNum, this.documents.getNumMinToCheckParas().get(cacheNum), document.getDocID(), false);
        }
        return document.mergeErrors(errors, nFPara);
    }

    public SingleProofreadingError[] getSpellErrors(int nPara, String text, Locale lang, SingleDocument document) throws Throwable {
        try {
            ArrayList<SingleProofreadingError> errorArray = new ArrayList<SingleProofreadingError>();
            if (document == null) {
                return null;
            }
            XFlatParagraph xFlatPara = null;
            if (this.docType == OfficeTools.DocumentType.WRITER && (xFlatPara = document.getFlatParagraphTools().getFlatParagraphAt(nPara)) == null) {
                return null;
            }
            Locale locale = null;
            List<AnalyzedSentence> analyzedSentences = this.docCache.getAnalyzedParagraph(nPara);
            int pos = 0;
            for (AnalyzedSentence analyzedSentence : analyzedSentences) {
                AnalyzedTokenReadings[] tokens = analyzedSentence.getTokensWithoutWhitespace();
                for (int i = 0; i < tokens.length; ++i) {
                    AnalyzedTokenReadings token = tokens[i];
                    String sToken = token.getToken();
                    if (token.isNonWord()) continue;
                    int nStart = token.getStartPos() + pos;
                    int nEnd = token.getEndPos() + pos;
                    if (i < tokens.length - 1) {
                        if (tokens[i + 1].getToken().equals(".")) {
                            sToken = sToken + ".";
                        } else {
                            boolean shouldComposed;
                            String nextToken = tokens[i + 1].getToken();
                            boolean bl = shouldComposed = nextToken.length() > 1 && (nextToken.charAt(0) == '\u2019' || nextToken.charAt(0) == '\'' || nextToken.startsWith("n\u2019") || nextToken.startsWith("n'"));
                            if (shouldComposed) {
                                sToken = sToken + nextToken;
                                nEnd = tokens[i + 1].getEndPos();
                                ++i;
                            }
                        }
                    }
                    if (sToken.length() <= 1) continue;
                    if (xFlatPara != null) {
                        locale = xFlatPara.getLanguageOfText(nStart, nEnd - nStart);
                    }
                    if (locale == null) {
                        locale = lang;
                    }
                    if (this.linguServices == null) {
                        this.linguServices = new LinguisticServices(this.xContext);
                    }
                    if (sToken.contains(" ") || this.linguServices.isCorrectSpell(sToken, locale)) continue;
                    SingleProofreadingError aError = new SingleProofreadingError();
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: getSpellErrors: Spell Error: Word: " + sToken + ", Start: " + nStart + ", End: " + nEnd + ", Token(" + i + "): " + tokens[i].getToken() + (i < tokens.length - 1 ? ", Token(" + (i + 1) + "): " + tokens[i + 1].getToken() : ""));
                    }
                    if (document.isIgnoreOnce(nStart, nEnd, nPara, spellRuleId)) continue;
                    aError.nErrorType = 1;
                    aError.aShortComment = aError.aFullComment = spellingError;
                    aError.nErrorStart = nStart;
                    aError.nErrorLength = nEnd - nStart;
                    aError.aRuleIdentifier = spellRuleId;
                    String[] alternatives = this.linguServices.getSpellAlternatives(token.getToken(), locale);
                    aError.aSuggestions = alternatives != null ? alternatives : new String[0];
                    aError = SingleCheck.correctRuleMatchWithFootnotes(aError, this.docCache.getFlatParagraphFootnotes(nPara), this.docCache.getFlatParagraphDeletedCharacters(nPara));
                    errorArray.add(aError);
                }
                pos = analyzedSentence.getCorrectedTextLength();
            }
            return errorArray.toArray(new SingleProofreadingError[errorArray.size()]);
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
            return null;
        }
    }

    SingleProofreadingError getNextGrammatikOrSpellErrorInParagraph(int x, int nFPara, String text, int[] footnotePosition, Locale locale, SingleDocument document, OfficeTools.LoErrorType errType) throws Throwable {
        block31: {
            block30: {
                if (text == null || text.isEmpty() || x >= text.length() || !MultiDocumentsHandler.hasLocale(locale)) {
                    return null;
                }
                if (document.getDocumentType() != OfficeTools.DocumentType.WRITER || this.documents.getTextLevelCheckQueue() == null || this.documents.noLtSpeller()) break block30;
                SingleProofreadingError[] errors = this.getErrorsFromCache(nFPara);
                if (errors == null) {
                    return null;
                }
                for (SingleProofreadingError error : errors) {
                    String word;
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: getNextGrammatikErrorInParagraph: Start: " + error.nErrorStart + ", ID: " + error.aRuleIdentifier);
                        if (error.nErrorType == 1) {
                            MessageHandler.printToLogFile("CheckDialog: getNextGrammatikErrorInParagraph: Test for correct spell: " + text.substring(error.nErrorStart, error.nErrorStart + error.nErrorLength));
                        }
                    }
                    if (!(this.checkType != 3 && (errType != OfficeTools.LoErrorType.SPELL && error.nErrorType != 1 || errType != OfficeTools.LoErrorType.GRAMMAR && error.nErrorType == 1)) && (this.checkType != 3 || !error.aRuleIdentifier.equals(this.checkRuleId)) || error.nErrorStart < x || error.nErrorType == 1 && ((word = text.substring(error.nErrorStart, error.nErrorStart + error.nErrorLength)).contains(" ") || this.documents.getLinguisticServices().isCorrectSpell(word, locale))) continue;
                    if ((error.aSuggestions == null || error.aSuggestions.length == 0) && this.documents.getLinguisticServices().isThesaurusRelevantRule(error.aRuleIdentifier)) {
                        error.aSuggestions = document.getSynonymArray(error, text, locale, this.lt, false);
                    } else if (error.nErrorType == 1) {
                        ArrayList<String> suggestionList = new ArrayList<String>();
                        for (String suggestion : error.aSuggestions) {
                            suggestionList.add(suggestion);
                        }
                        String[] suggestions = this.documents.getLinguisticServices().getSpellAlternatives(text.substring(error.nErrorStart, error.nErrorStart + error.nErrorLength), locale);
                        if (suggestions != null) {
                            for (String suggestion : suggestions) {
                                if (suggestionList.contains(suggestion)) continue;
                                suggestionList.add(suggestion);
                            }
                        }
                        error.aSuggestions = suggestionList.toArray(new String[0]);
                    }
                    return error;
                }
                break block31;
            }
            PropertyValue[] propertyValues = new PropertyValue[]{new PropertyValue("FootnotePositions", -1, (Object)footnotePosition, PropertyState.DIRECT_VALUE)};
            ProofreadingResult paRes = new ProofreadingResult();
            paRes.nStartOfSentencePosition = 0;
            paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition = 0;
            paRes.xProofreader = null;
            paRes.aLocale = locale;
            paRes.aDocumentIdentifier = document.getDocID();
            paRes.aText = text;
            paRes.aProperties = propertyValues;
            paRes.aErrors = null;
            Language langForShortName = MultiDocumentsHandler.getLanguage(locale);
            if (langForShortName == null) break block31;
            if (this.doInit || !langForShortName.equals(this.lastLanguage) || !this.documents.isCheckImpressDocument()) {
                this.lastLanguage = langForShortName;
                this.setLangTool(document, this.lastLanguage);
                document.removeResultCache(nFPara, true);
            }
            int lastSentenceStart = -1;
            while (paRes.nStartOfNextSentencePosition < text.length() && paRes.nStartOfNextSentencePosition != lastSentenceStart) {
                lastSentenceStart = paRes.nStartOfNextSentencePosition;
                paRes.nStartOfSentencePosition = paRes.nStartOfNextSentencePosition;
                paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition = text.length();
                if (debugMode) {
                    for (String id : this.lt.getDisabledRules()) {
                        MessageHandler.printToLogFile("CheckDialog: getNextGrammatikErrorInParagraph: Dialog disabled rule: " + id);
                    }
                }
                paRes = document.getCheckResults(text, locale, paRes, propertyValues, false, this.lt, nFPara, errType);
                SingleProofreadingError[] spellErrors = null;
                SingleProofreadingError[] allErrors = null;
                if (this.checkType != 3 && errType != OfficeTools.LoErrorType.GRAMMAR) {
                    spellErrors = this.getSpellErrors(nFPara, text, locale, document);
                }
                if (paRes == null || paRes.aErrors == null || paRes.aErrors.length == 0) {
                    allErrors = spellErrors;
                } else if (spellErrors == null || spellErrors.length == 0) {
                    allErrors = paRes.aErrors;
                } else {
                    ArrayList<SingleProofreadingError[]> errorList = new ArrayList<SingleProofreadingError[]>();
                    errorList.add(spellErrors);
                    errorList.add(paRes.aErrors);
                    allErrors = document.mergeErrors(errorList, nFPara);
                }
                if (allErrors == null) continue;
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: getNextGrammatikErrorInParagraph: Number of Errors = " + paRes.aErrors.length + ", Paragraph: " + nFPara + ", Next Position: " + paRes.nStartOfNextSentencePosition + ", Text.length: " + text.length());
                }
                for (SingleProofreadingError error : allErrors) {
                    String word;
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: getNextGrammatikErrorInParagraph: Start: " + error.nErrorStart + ", ID: " + error.aRuleIdentifier);
                        if (error.nErrorType != 1) {
                            MessageHandler.printToLogFile("CheckDialog: getNextGrammatikErrorInParagraph: Test for correct spell: " + text.substring(error.nErrorStart, error.nErrorStart + error.nErrorLength));
                        }
                    }
                    if (!(this.checkType != 3 && (errType != OfficeTools.LoErrorType.SPELL && error.nErrorType != 1 || errType != OfficeTools.LoErrorType.GRAMMAR && error.nErrorType == 1)) && (this.checkType != 3 || !error.aRuleIdentifier.equals(this.checkRuleId)) || error.nErrorStart < x || error.nErrorType == 1 && ((word = text.substring(error.nErrorStart, error.nErrorStart + error.nErrorLength)).contains(" ") || this.documents.getLinguisticServices().isCorrectSpell(word, locale))) continue;
                    if ((error.aSuggestions == null || error.aSuggestions.length == 0) && this.documents.getLinguisticServices().isThesaurusRelevantRule(error.aRuleIdentifier)) {
                        error.aSuggestions = document.getSynonymArray(error, text, locale, this.lt, false);
                    } else if (error.nErrorType == 1) {
                        ArrayList<String> suggestionList = new ArrayList<String>();
                        for (String suggestion : error.aSuggestions) {
                            suggestionList.add(suggestion);
                        }
                        String[] suggestions = this.documents.getLinguisticServices().getSpellAlternatives(text, locale);
                        if (suggestions != null) {
                            for (String suggestion : suggestions) {
                                if (suggestionList.contains(suggestion)) continue;
                                suggestionList.add(suggestion);
                            }
                        }
                        error.aSuggestions = suggestionList.toArray(new String[0]);
                    }
                    return error;
                }
            }
        }
        return null;
    }

    public class LtCheckDialog
    implements ActionListener {
        private static final String ACORR_PREFIX = "acor_";
        private static final String ACORR_SUFFIX = ".dat";
        private static final int CHECK_TYPE_NUM = 4;
        private static final int maxUndos = 50;
        private static final int toolTipWidth = 300;
        private static final int dialogWidth = 640;
        private static final int dialogHeight = 600;
        private static final int MAX_ITEM_LENGTH = 28;
        private OfficeDrawTools.UndoMarkupContainer undoMarkup;
        private Color defaultForeground;
        private final JDialog dialog;
        private final Container contentPane;
        private final JLabel languageLabel;
        private final JComboBox<String> language;
        private final JComboBox<String> changeLanguage;
        private final JTextArea errorDescription;
        private final JTextPane sentenceIncludeError;
        private final JLabel suggestionsLabel;
        private final JList<String> suggestions;
        private final JLabel checkTypeLabel;
        private final JLabel checkProgressLabel;
        private final JLabel cacheStatusLabel;
        private final ButtonGroup checkTypeGroup;
        private final JRadioButton[] checkTypeButtons;
        private final JButton more;
        private final JButton ignoreOnce;
        private final JButton ignorePermanent;
        private final JButton resetIgnorePermanent;
        private final JButton ignoreAll;
        private final JButton deactivateRule;
        private final JComboBox<String> addToDictionary;
        private final JComboBox<String> activateRule;
        private final JComboBox<String> checkRuleBox;
        private final JButton change;
        private final JButton changeAll;
        private final JButton autoCorrect;
        private final JButton help;
        private final JButton options;
        private final JButton undo;
        private final JButton close;
        private JProgressBar checkProgress;
        private final Image ltImage;
        private final List<UndoContainer> undoList;
        private SingleDocument currentDocument;
        private ViewCursorTools viewCursor;
        private SingleProofreadingError error;
        private List<RuleIdentification> allDifferentErrors;
        String docId;
        private String[] userDictionaries;
        private String informationUrl;
        private String lastLang = new String();
        private String endOfDokumentMessage;
        private int x = 0;
        private int y = 0;
        private int startOfRange = -1;
        private int endOfRange = -1;
        private int lastX = 0;
        private int lastY = -1;
        private int lastPara = -1;
        private boolean isSpellError = false;
        private boolean focusLost = false;
        private boolean blockSentenceError = true;
        private boolean isDisposed = false;
        private boolean atWork = false;
        private boolean uncheckedParasLeft = false;
        private String wrongWord;
        private Locale locale;

        public LtCheckDialog(final XComponentContext xContext, SingleDocument document, MultiDocumentsHandler.WaitDialogThread inf) {
            long startTime = 0L;
            if (debugModeTm) {
                startTime = System.currentTimeMillis();
            }
            this.ltImage = OfficeTools.getLtImage();
            if (!SpellAndGrammarCheckDialog.this.documents.isJavaLookAndFeelSet()) {
                SpellAndGrammarCheckDialog.this.documents.setJavaLookAndFeel();
            }
            this.currentDocument = document;
            this.undoList = new ArrayList<UndoContainer>();
            this.dialog = new JDialog();
            this.contentPane = this.dialog.getContentPane();
            this.languageLabel = new JLabel(labelLanguage);
            this.changeLanguage = new JComboBox<String>(changeLanguageList);
            this.language = new JComboBox<String>(this.getPossibleLanguages());
            this.errorDescription = new JTextArea();
            this.sentenceIncludeError = new JTextPane();
            this.suggestionsLabel = new JLabel(labelSuggestions);
            this.suggestions = new JList();
            this.checkTypeLabel = new JLabel(Tools.getLabel(messages.getString("guiOOoCheckTypeLabel")));
            this.checkTypeButtons = new JRadioButton[4];
            this.checkTypeGroup = new ButtonGroup();
            this.help = new JButton(helpButtonName);
            this.options = new JButton(optionsButtonName);
            this.undo = new JButton(undoButtonName);
            this.close = new JButton(closeButtonName);
            this.more = new JButton(moreButtonName);
            this.ignoreOnce = new JButton(ignoreButtonName);
            this.ignorePermanent = new JButton(ignorePermanentButtonName);
            this.resetIgnorePermanent = new JButton(resetIgnorePermanentButtonName);
            this.ignoreAll = new JButton(ignoreAllButtonName);
            this.deactivateRule = new JButton(deactivateRuleButtonName);
            this.addToDictionary = new JComboBox();
            this.change = new JButton(changeButtonName);
            this.changeAll = new JButton(changeAllButtonName);
            this.autoCorrect = new JButton(autoCorrectButtonName);
            this.activateRule = new JComboBox();
            this.checkRuleBox = new JComboBox();
            this.checkProgressLabel = new JLabel(labelCheckProgress);
            this.cacheStatusLabel = new JLabel(" \u2588 ");
            this.cacheStatusLabel.setToolTipText(messages.getString("loDialogCacheLabel"));
            this.checkProgress = new JProgressBar(0, 100);
            try {
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: LtCheckDialog: LtCheckDialog called");
                }
                if (this.dialog == null) {
                    MessageHandler.printToLogFile("CheckDialog: LtCheckDialog: LtCheckDialog == null");
                }
                this.dialog.setName(dialogName);
                this.dialog.setTitle(dialogName + " (LanguageTool " + OfficeTools.getLtInformation() + ")");
                this.dialog.setDefaultCloseOperation(2);
                ((Frame)this.dialog.getOwner()).setIconImage(this.ltImage);
                this.defaultForeground = this.dialog.getForeground() == null ? Color.BLACK : this.dialog.getForeground();
                Font dialogFont = this.languageLabel.getFont();
                this.languageLabel.setFont(dialogFont);
                this.language.setFont(dialogFont);
                this.language.setToolTipText(this.formatToolTipText(languageHelp));
                this.language.addItemListener(e -> {
                    String selectedLang;
                    if (e.getStateChange() == 1 && !this.lastLang.equals(selectedLang = (String)this.language.getSelectedItem())) {
                        this.changeLanguage.setEnabled(true);
                    }
                });
                this.changeLanguage.setFont(dialogFont);
                this.changeLanguage.setToolTipText(this.formatToolTipText(changeLanguageHelp));
                this.changeLanguage.addItemListener(e -> {
                    if (e.getStateChange() == 1 && this.changeLanguage.getSelectedIndex() > 0) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Locale locale = null;
                                    FlatParagraphTools flatPara = null;
                                    LtCheckDialog.this.setAtWorkButtonState();
                                    String selectedLang = (String)LtCheckDialog.this.language.getSelectedItem();
                                    locale = LtCheckDialog.this.getLocaleFromLanguageName(selectedLang);
                                    flatPara = LtCheckDialog.this.currentDocument.getFlatParagraphTools();
                                    LtCheckDialog.this.currentDocument.removeResultCache(LtCheckDialog.this.y, true);
                                    if (LtCheckDialog.this.changeLanguage.getSelectedIndex() == 1) {
                                        if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.IMPRESS) {
                                            OfficeDrawTools.setLanguageOfParagraph(LtCheckDialog.this.y, ((LtCheckDialog)LtCheckDialog.this).error.nErrorStart, ((LtCheckDialog)LtCheckDialog.this).error.nErrorLength, locale, LtCheckDialog.this.currentDocument.getXComponent());
                                        } else if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.CALC) {
                                            OfficeSpreadsheetTools.setLanguageOfSpreadsheet(locale, LtCheckDialog.this.currentDocument.getXComponent());
                                        } else {
                                            flatPara.setLanguageOfParagraph(LtCheckDialog.this.y, ((LtCheckDialog)LtCheckDialog.this).error.nErrorStart, ((LtCheckDialog)LtCheckDialog.this).error.nErrorLength, locale);
                                        }
                                        LtCheckDialog.this.addLanguageChangeUndo(LtCheckDialog.this.y, ((LtCheckDialog)LtCheckDialog.this).error.nErrorStart, ((LtCheckDialog)LtCheckDialog.this).error.nErrorLength, LtCheckDialog.this.lastLang);
                                        SpellAndGrammarCheckDialog.this.docCache.setMultilingualFlatParagraph(LtCheckDialog.this.y);
                                    } else if (LtCheckDialog.this.changeLanguage.getSelectedIndex() == 2) {
                                        if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.IMPRESS) {
                                            OfficeDrawTools.setLanguageOfParagraph(LtCheckDialog.this.y, 0, SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(LtCheckDialog.this.y).length(), locale, LtCheckDialog.this.currentDocument.getXComponent());
                                        } else if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.CALC) {
                                            OfficeSpreadsheetTools.setLanguageOfSpreadsheet(locale, LtCheckDialog.this.currentDocument.getXComponent());
                                        } else {
                                            flatPara.setLanguageOfParagraph(LtCheckDialog.this.y, 0, SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(LtCheckDialog.this.y).length(), locale);
                                        }
                                        SpellAndGrammarCheckDialog.this.docCache.setFlatParagraphLocale(LtCheckDialog.this.y, locale);
                                        LtCheckDialog.this.addLanguageChangeUndo(LtCheckDialog.this.y, 0, SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(LtCheckDialog.this.y).length(), LtCheckDialog.this.lastLang);
                                    }
                                    LtCheckDialog.this.lastLang = selectedLang;
                                    LtCheckDialog.this.changeLanguage.setSelectedIndex(0);
                                    LtCheckDialog.this.gotoNextError();
                                }
                                catch (Throwable t) {
                                    MessageHandler.showError(t);
                                    LtCheckDialog.this.closeDialog();
                                }
                            }
                        });
                        t.start();
                    }
                });
                this.changeLanguage.setSelectedIndex(0);
                this.changeLanguage.setEnabled(false);
                if (debugModeTm) {
                    long runTime = System.currentTimeMillis() - startTime;
                    MessageHandler.printToLogFile("CheckDialog: Time to initialise Languages: " + runTime);
                    startTime = System.currentTimeMillis();
                }
                if (inf.canceled()) {
                    return;
                }
                this.errorDescription.setEditable(false);
                this.errorDescription.setLineWrap(true);
                this.errorDescription.setWrapStyleWord(true);
                this.errorDescription.setBackground(this.dialog.getContentPane().getBackground());
                this.errorDescription.setText(checkStatusInitialization);
                this.errorDescription.setForeground(Color.RED);
                Font descriptionFont = dialogFont.deriveFont(1);
                this.errorDescription.setFont(descriptionFont);
                this.errorDescription.setToolTipText(this.formatToolTipText(matchDescriptionHelp));
                JScrollPane descriptionPane = new JScrollPane(this.errorDescription);
                descriptionPane.setMinimumSize(new Dimension(0, 20));
                this.sentenceIncludeError.setFont(dialogFont);
                this.sentenceIncludeError.setToolTipText(this.formatToolTipText(matchParagraphHelp));
                this.sentenceIncludeError.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        if (!LtCheckDialog.this.blockSentenceError) {
                            if (!LtCheckDialog.this.change.isEnabled()) {
                                LtCheckDialog.this.change.setEnabled(true);
                            }
                            if (LtCheckDialog.this.changeAll.isEnabled()) {
                                LtCheckDialog.this.changeAll.setEnabled(false);
                            }
                            if (LtCheckDialog.this.autoCorrect.isEnabled()) {
                                LtCheckDialog.this.autoCorrect.setEnabled(false);
                            }
                        }
                    }

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        this.changedUpdate(e);
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        this.changedUpdate(e);
                    }
                });
                JScrollPane sentencePane = new JScrollPane(this.sentenceIncludeError);
                sentencePane.setMinimumSize(new Dimension(0, 30));
                this.suggestionsLabel.setFont(dialogFont);
                this.suggestions.setFont(dialogFont);
                this.suggestions.setSelectionMode(0);
                this.suggestions.setFixedCellHeight((int)((double)this.suggestions.getFont().getSize() * 1.2 + 0.5));
                this.suggestions.setToolTipText(this.formatToolTipText(suggestionsHelp));
                JScrollPane suggestionsPane = new JScrollPane(this.suggestions);
                suggestionsPane.setMinimumSize(new Dimension(0, 30));
                this.checkTypeLabel.setFont(dialogFont);
                this.checkTypeLabel.setToolTipText(this.formatToolTipText(checkTypeHelp));
                if (debugModeTm) {
                    long runTime = System.currentTimeMillis() - startTime;
                    MessageHandler.printToLogFile("CheckDialog: Time to initialise suggestions, etc.: " + runTime);
                    startTime = System.currentTimeMillis();
                }
                if (inf.canceled()) {
                    return;
                }
                this.checkTypeButtons[0] = new JRadioButton(Tools.getLabel(messages.getString("guiOOoCheckAllButton")));
                this.checkTypeButtons[0].setSelected(true);
                this.checkTypeButtons[0].addActionListener(e -> {
                    this.setAtWorkButtonState();
                    SpellAndGrammarCheckDialog.this.checkType = 0;
                    this.checkRuleBox.setEnabled(false);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LtCheckDialog.this.setAtWorkButtonState();
                                LtCheckDialog.this.gotoNextError();
                            }
                            catch (Throwable t) {
                                MessageHandler.showError(t);
                                LtCheckDialog.this.closeDialog();
                            }
                        }
                    });
                    t.start();
                });
                this.checkTypeButtons[1] = new JRadioButton(Tools.getLabel(messages.getString("guiOOoCheckSpellingButton")));
                this.checkTypeButtons[1].addActionListener(e -> {
                    this.setAtWorkButtonState();
                    SpellAndGrammarCheckDialog.this.checkType = 1;
                    this.checkRuleBox.setEnabled(false);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LtCheckDialog.this.setAtWorkButtonState();
                                LtCheckDialog.this.gotoNextError();
                            }
                            catch (Throwable t) {
                                MessageHandler.showError(t);
                                LtCheckDialog.this.closeDialog();
                            }
                        }
                    });
                    t.start();
                });
                this.checkTypeButtons[2] = new JRadioButton(Tools.getLabel(messages.getString("guiOOoCheckGrammarButton")));
                this.checkTypeButtons[2].addActionListener(e -> {
                    this.setAtWorkButtonState();
                    SpellAndGrammarCheckDialog.this.checkType = 2;
                    this.checkRuleBox.setEnabled(false);
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                LtCheckDialog.this.setAtWorkButtonState();
                                LtCheckDialog.this.gotoNextError();
                            }
                            catch (Throwable t) {
                                MessageHandler.showError(t);
                                LtCheckDialog.this.closeDialog();
                            }
                        }
                    });
                    t.start();
                });
                this.checkTypeButtons[3] = new JRadioButton(Tools.getLabel(messages.getString("guiOOoCheckOnlyRuleButton")));
                this.checkTypeButtons[3].addActionListener(e -> {
                    if (SpellAndGrammarCheckDialog.this.checkType != 3) {
                        SpellAndGrammarCheckDialog.this.checkType = 3;
                    }
                    this.checkRuleBox.setEnabled(true);
                });
                for (int i = 0; i < 4; ++i) {
                    this.checkTypeGroup.add(this.checkTypeButtons[i]);
                    this.checkTypeButtons[i].setFont(dialogFont);
                    this.checkTypeButtons[i].setToolTipText(this.formatToolTipText(checkTypeHelp));
                }
                this.help.setFont(dialogFont);
                this.help.addActionListener(this);
                this.help.setActionCommand("help");
                this.help.setToolTipText(this.formatToolTipText(helpButtonHelp));
                this.options.setFont(dialogFont);
                this.options.addActionListener(this);
                this.options.setActionCommand("options");
                this.options.setToolTipText(this.formatToolTipText(optionsButtonHelp));
                this.undo.setFont(dialogFont);
                this.undo.addActionListener(this);
                this.undo.setActionCommand("undo");
                this.undo.setToolTipText(this.formatToolTipText(undoButtonHelp));
                this.close.setFont(dialogFont);
                this.close.addActionListener(this);
                this.close.setActionCommand("close");
                this.close.setToolTipText(this.formatToolTipText(closeButtonHelp));
                this.more.setFont(dialogFont);
                this.more.addActionListener(this);
                this.more.setActionCommand("more");
                this.more.setToolTipText(this.formatToolTipText(moreButtonHelp));
                this.ignoreOnce.setFont(dialogFont);
                this.ignoreOnce.addActionListener(this);
                this.ignoreOnce.setActionCommand("ignoreOnce");
                this.ignoreOnce.setToolTipText(this.formatToolTipText(ignoreButtonHelp));
                this.ignorePermanent.setFont(dialogFont);
                this.ignorePermanent.addActionListener(this);
                this.ignorePermanent.setActionCommand("ignorePermanent");
                this.ignorePermanent.setToolTipText(this.formatToolTipText(ignorePermanentButtonHelp));
                this.resetIgnorePermanent.setFont(dialogFont);
                this.resetIgnorePermanent.addActionListener(this);
                this.resetIgnorePermanent.setActionCommand("resetIgnorePermanent");
                this.resetIgnorePermanent.setToolTipText(this.formatToolTipText(resetIgnorePermanentButtonHelp));
                this.ignoreAll.setFont(dialogFont);
                this.ignoreAll.addActionListener(this);
                this.ignoreAll.setActionCommand("ignoreAll");
                this.ignoreAll.setToolTipText(this.formatToolTipText(ignoreAllButtonHelp));
                this.deactivateRule.setFont(dialogFont);
                this.deactivateRule.setVisible(false);
                this.deactivateRule.addActionListener(this);
                this.deactivateRule.setActionCommand("deactivateRule");
                this.deactivateRule.setToolTipText(this.formatToolTipText(deactivateRuleButtonHelp));
                this.addToDictionary.setFont(dialogFont);
                this.addToDictionary.setToolTipText(this.formatToolTipText(addToDictionaryHelp));
                this.addToDictionary.addItemListener(e -> {
                    if (e.getStateChange() == 1 && this.addToDictionary.getSelectedIndex() > 0) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    LtCheckDialog.this.setAtWorkButtonState();
                                    String dictionary = (String)LtCheckDialog.this.addToDictionary.getSelectedItem();
                                    LtDictionary.addWordToDictionary(dictionary, LtCheckDialog.this.wrongWord, xContext);
                                    LtCheckDialog.this.addUndo(LtCheckDialog.this.y, "addToDictionary", dictionary, LtCheckDialog.this.wrongWord);
                                    LtCheckDialog.this.addToDictionary.setSelectedIndex(0);
                                    LtCheckDialog.this.gotoNextError();
                                }
                                catch (Throwable t) {
                                    MessageHandler.showError(t);
                                    LtCheckDialog.this.closeDialog();
                                }
                            }
                        });
                        t.start();
                    }
                });
                this.change.setFont(dialogFont);
                this.change.addActionListener(this);
                this.change.setActionCommand("change");
                this.change.setToolTipText(this.formatToolTipText(changeButtonHelp));
                this.changeAll.setFont(dialogFont);
                this.changeAll.addActionListener(this);
                this.changeAll.setActionCommand("changeAll");
                this.changeAll.setEnabled(false);
                this.changeAll.setToolTipText(this.formatToolTipText(changeAllButtonHelp));
                this.autoCorrect.setFont(dialogFont);
                this.autoCorrect.addActionListener(this);
                this.autoCorrect.setActionCommand("autoCorrect");
                this.autoCorrect.setEnabled(false);
                this.autoCorrect.setToolTipText(this.formatToolTipText(autoCorrectButtonHelp));
                this.activateRule.setFont(dialogFont);
                this.activateRule.setToolTipText(this.formatToolTipText(activateRuleButtonHelp));
                this.activateRule.setVisible(false);
                this.activateRule.addItemListener(e -> {
                    if (e.getStateChange() == 1) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    int selectedIndex = LtCheckDialog.this.activateRule.getSelectedIndex();
                                    if (selectedIndex > 0) {
                                        Map<String, String> deactivatedRulesMap = SpellAndGrammarCheckDialog.this.documents.getDisabledRulesMap(OfficeTools.localeToString(LtCheckDialog.this.locale));
                                        int j = 1;
                                        for (String ruleId : deactivatedRulesMap.keySet()) {
                                            if (j == selectedIndex) {
                                                LtCheckDialog.this.setAtWorkButtonState();
                                                SpellAndGrammarCheckDialog.this.documents.activateRule(ruleId);
                                                LtCheckDialog.this.addUndo(LtCheckDialog.this.y, "activateRule", ruleId, null);
                                                LtCheckDialog.this.activateRule.setSelectedIndex(0);
                                                LtCheckDialog.this.gotoNextError();
                                            }
                                            ++j;
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    MessageHandler.showError(t);
                                    LtCheckDialog.this.closeDialog();
                                }
                            }
                        });
                        t.start();
                    }
                });
                this.checkRuleBox.setFont(dialogFont);
                this.checkRuleBox.setVisible(true);
                this.checkRuleBox.setEnabled(false);
                this.checkRuleBox.addItemListener(e -> {
                    if (e.getStateChange() == 1 && SpellAndGrammarCheckDialog.this.checkType == 3 && this.checkRuleBox.getItemCount() > 0) {
                        final String newRuleId = this.getRuleId((String)this.checkRuleBox.getSelectedItem(), this.allDifferentErrors);
                        if (SpellAndGrammarCheckDialog.this.checkRuleId == null || !SpellAndGrammarCheckDialog.this.checkRuleId.equals(newRuleId)) {
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        MessageHandler.printToLogFile("checkDialog: Set checkRuleId old: " + SpellAndGrammarCheckDialog.this.checkRuleId + ", new: " + newRuleId);
                                        SpellAndGrammarCheckDialog.this.checkRuleId = newRuleId;
                                        LtCheckDialog.this.startOfRange = -1;
                                        LtCheckDialog.this.endOfRange = -1;
                                        LtCheckDialog.this.lastPara = -1;
                                        LtCheckDialog.this.gotoNextError();
                                    }
                                    catch (Throwable t) {
                                        MessageHandler.showError(t);
                                        LtCheckDialog.this.closeDialog();
                                    }
                                }
                            });
                            t.start();
                        }
                    }
                });
                this.dialog.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowGainedFocus(final WindowEvent e) {
                        if (LtCheckDialog.this.focusLost && !LtCheckDialog.this.atWork) {
                            Thread t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Point p = LtCheckDialog.this.dialog.getLocation();
                                        SpellAndGrammarCheckDialog.this.dialogX = p.x;
                                        SpellAndGrammarCheckDialog.this.dialogY = p.y;
                                        if (debugMode) {
                                            MessageHandler.printToLogFile("CheckDialog: LtCheckDialog: Window Focus gained: Event = " + e.paramString());
                                        }
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.currentDocument = SpellAndGrammarCheckDialog.this.getCurrentDocument(true);
                                        if (LtCheckDialog.this.currentDocument == null) {
                                            LtCheckDialog.this.closeDialog();
                                            return;
                                        }
                                        String newDocId = LtCheckDialog.this.currentDocument.getDocID();
                                        if (debugMode) {
                                            MessageHandler.printToLogFile("CheckDialog: LtCheckDialog: Window Focus gained: new docID = " + newDocId + ", old = " + LtCheckDialog.this.docId + ", docType: " + (Object)((Object)SpellAndGrammarCheckDialog.this.docType));
                                        }
                                        if (!LtCheckDialog.this.docId.equals(newDocId)) {
                                            LtCheckDialog.this.docId = newDocId;
                                            LtCheckDialog.this.undoList.clear();
                                        }
                                        if (!LtCheckDialog.this.initCursor(false)) {
                                            LtCheckDialog.this.closeDialog();
                                            return;
                                        }
                                        if (debugMode) {
                                            MessageHandler.printToLogFile("CheckDialog: LtCheckDialog: cache refreshed - size: " + SpellAndGrammarCheckDialog.this.docCache.size());
                                        }
                                        LtCheckDialog.this.gotoNextError();
                                        LtCheckDialog.this.focusLost = false;
                                    }
                                    catch (Throwable t) {
                                        MessageHandler.showError(t);
                                        LtCheckDialog.this.closeDialog();
                                    }
                                }
                            });
                            t.start();
                        }
                    }

                    @Override
                    public void windowLostFocus(final WindowEvent e) {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (debugMode) {
                                        MessageHandler.printToLogFile("CheckDialog: LtCheckDialog: Window Focus lost: Event = " + e.paramString());
                                    }
                                    LtCheckDialog.this.removeMarkups();
                                    LtCheckDialog.this.setAtWorkButtonState(LtCheckDialog.this.atWork);
                                    LtCheckDialog.this.dialog.setEnabled(true);
                                    LtCheckDialog.this.focusLost = true;
                                }
                                catch (Throwable t) {
                                    MessageHandler.showError(t);
                                    LtCheckDialog.this.closeDialog();
                                }
                            }
                        });
                        t.start();
                    }
                });
                this.dialog.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        LtCheckDialog.this.closeDialog();
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }
                });
                this.checkProgress.setStringPainted(true);
                this.checkProgress.setIndeterminate(true);
                Color selectionColor = UIManager.getLookAndFeelDefaults().getColor("ProgressBar.selectionBackground");
                this.suggestions.setSelectionBackground(selectionColor);
                this.setJComboSelectionBackground(this.language, selectionColor);
                this.setJComboSelectionBackground(this.changeLanguage, selectionColor);
                this.setJComboSelectionBackground(this.addToDictionary, selectionColor);
                this.setJComboSelectionBackground(this.activateRule, selectionColor);
                if (debugModeTm) {
                    long runTime = System.currentTimeMillis() - startTime;
                    MessageHandler.printToLogFile("CheckDialog: Time to initialise Buttons: " + runTime);
                    startTime = System.currentTimeMillis();
                }
                if (inf.canceled()) {
                    return;
                }
                JPanel languagePanel = new JPanel();
                languagePanel.setLayout(new GridBagLayout());
                GridBagConstraints cons11 = new GridBagConstraints();
                cons11.insets = new Insets(2, 2, 2, 2);
                cons11.gridx = 0;
                cons11.gridy = 0;
                cons11.anchor = 18;
                cons11.fill = 2;
                cons11.weightx = 0.0;
                cons11.weighty = 0.0;
                languagePanel.add((Component)this.languageLabel, cons11);
                ++cons11.gridx;
                cons11.weightx = 1.0;
                languagePanel.add(this.language, cons11);
                JPanel rightPanel1 = new JPanel();
                rightPanel1.setLayout(new GridBagLayout());
                GridBagConstraints cons21 = new GridBagConstraints();
                cons21.insets = new Insets(2, 0, 2, 0);
                cons21.gridx = 0;
                cons21.gridy = 0;
                cons21.anchor = 18;
                cons21.fill = 1;
                cons21.weightx = 1.0;
                cons21.weighty = 0.0;
                ++cons21.gridy;
                rightPanel1.add((Component)this.ignoreOnce, cons21);
                ++cons21.gridy;
                rightPanel1.add((Component)this.ignorePermanent, cons21);
                ++cons21.gridy;
                rightPanel1.add((Component)this.ignoreAll, cons21);
                ++cons21.gridy;
                rightPanel1.add((Component)this.deactivateRule, cons21);
                rightPanel1.add(this.addToDictionary, cons21);
                JPanel rightPanel2 = new JPanel();
                rightPanel2.setLayout(new GridBagLayout());
                GridBagConstraints cons22 = new GridBagConstraints();
                cons22.insets = new Insets(2, 0, 2, 0);
                cons22.gridx = 0;
                cons22.gridy = 0;
                cons22.anchor = 18;
                cons22.fill = 1;
                cons22.weightx = 1.0;
                cons22.weighty = 0.0;
                ++cons22.gridy;
                ++cons22.gridy;
                rightPanel2.add((Component)this.change, cons22);
                ++cons22.gridy;
                rightPanel2.add((Component)this.changeAll, cons22);
                ++cons22.gridy;
                rightPanel2.add((Component)this.autoCorrect, cons22);
                rightPanel2.add(this.activateRule, cons22);
                ++cons22.gridy;
                rightPanel2.add((Component)this.resetIgnorePermanent, cons22);
                JPanel checkTypePanel = new JPanel();
                checkTypePanel.setLayout(new GridBagLayout());
                GridBagConstraints cons12 = new GridBagConstraints();
                cons12.insets = new Insets(2, 2, 2, 2);
                cons12.gridx = 0;
                cons12.gridy = 0;
                cons12.anchor = 18;
                cons12.fill = 2;
                cons12.weightx = 0.0;
                cons12.weighty = 0.0;
                checkTypePanel.add((Component)this.checkTypeLabel, cons12);
                JPanel checkTypePanel1 = new JPanel();
                checkTypePanel1.setLayout(new GridBagLayout());
                GridBagConstraints cons121 = new GridBagConstraints();
                cons121.insets = new Insets(2, 2, 2, 2);
                cons121.gridx = 0;
                cons121.gridy = 0;
                cons121.anchor = 18;
                cons121.fill = 2;
                cons121.weightx = 1.0;
                cons121.weighty = 0.0;
                for (int i = 0; i < 3; ++i) {
                    checkTypePanel1.add((Component)this.checkTypeButtons[i], cons121);
                    ++cons121.gridx;
                }
                cons12.weightx = 1.0;
                ++cons12.gridx;
                checkTypePanel.add((Component)checkTypePanel1, cons12);
                JPanel checkTypePanel2 = new JPanel();
                checkTypePanel2.setLayout(new GridBagLayout());
                GridBagConstraints cons122 = new GridBagConstraints();
                cons122.insets = new Insets(2, 2, 2, 2);
                cons122.gridx = 0;
                cons122.gridy = 0;
                cons122.anchor = 18;
                cons122.fill = 2;
                cons122.weightx = 0.0;
                cons122.weighty = 0.0;
                checkTypePanel2.add((Component)this.checkTypeButtons[3], cons122);
                ++cons122.gridx;
                cons122.weightx = 1.0;
                checkTypePanel2.add(this.checkRuleBox, cons122);
                ++cons12.gridy;
                checkTypePanel.add((Component)checkTypePanel2, cons12);
                JPanel mainPanel = new JPanel();
                mainPanel.setLayout(new GridBagLayout());
                GridBagConstraints cons1 = new GridBagConstraints();
                cons1.insets = new Insets(4, 4, 4, 4);
                cons1.gridx = 0;
                cons1.gridy = 0;
                cons1.anchor = 18;
                cons1.fill = 1;
                cons1.weightx = 1.0;
                cons1.weighty = 0.0;
                mainPanel.add((Component)languagePanel, cons1);
                cons1.weightx = 0.0;
                ++cons1.gridx;
                mainPanel.add(this.changeLanguage, cons1);
                cons1.gridx = 0;
                ++cons1.gridy;
                cons1.weightx = 1.0;
                cons1.weighty = 1.0;
                mainPanel.add((Component)descriptionPane, cons1);
                ++cons1.gridx;
                cons1.weightx = 0.0;
                cons1.weighty = 0.0;
                mainPanel.add((Component)this.more, cons1);
                cons1.gridx = 0;
                ++cons1.gridy;
                cons1.weightx = 1.0;
                cons1.weighty = 2.0;
                mainPanel.add((Component)sentencePane, cons1);
                ++cons1.gridx;
                cons1.weightx = 0.0;
                cons1.weighty = 0.0;
                mainPanel.add((Component)rightPanel1, cons1);
                cons1.gridx = 0;
                ++cons1.gridy;
                cons1.weightx = 1.0;
                mainPanel.add((Component)this.suggestionsLabel, cons1);
                ++cons1.gridy;
                cons1.weighty = 2.0;
                mainPanel.add((Component)suggestionsPane, cons1);
                ++cons1.gridx;
                cons1.weightx = 0.0;
                cons1.weighty = 0.0;
                mainPanel.add((Component)rightPanel2, cons1);
                cons1.gridx = 0;
                ++cons1.gridy;
                cons1.weightx = 1.0;
                cons1.weighty = 0.0;
                mainPanel.add((Component)checkTypePanel, cons1);
                JPanel generalButtonPanel = new JPanel();
                generalButtonPanel.setLayout(new GridBagLayout());
                GridBagConstraints cons3 = new GridBagConstraints();
                cons3.insets = new Insets(4, 4, 4, 4);
                cons3.gridx = 0;
                cons3.gridy = 0;
                cons3.anchor = 18;
                cons3.fill = 2;
                cons3.weightx = 1.0;
                cons3.weighty = 0.0;
                generalButtonPanel.add((Component)this.help, cons3);
                ++cons3.gridx;
                generalButtonPanel.add((Component)this.options, cons3);
                ++cons3.gridx;
                generalButtonPanel.add((Component)this.undo, cons3);
                ++cons3.gridx;
                generalButtonPanel.add((Component)this.close, cons3);
                JPanel checkProgressPanel = new JPanel();
                checkProgressPanel.setLayout(new GridBagLayout());
                GridBagConstraints cons4 = new GridBagConstraints();
                cons4.insets = new Insets(4, 4, 4, 4);
                cons4.gridx = 0;
                cons4.gridy = 0;
                cons4.anchor = 18;
                cons4.fill = 2;
                cons4.weightx = 0.0;
                cons4.weighty = 0.0;
                checkProgressPanel.add((Component)this.cacheStatusLabel, cons4);
                ++cons4.gridx;
                cons4.weightx = 0.0;
                cons4.weighty = 0.0;
                checkProgressPanel.add((Component)this.checkProgressLabel, cons4);
                ++cons4.gridx;
                cons4.weightx = 4.0;
                checkProgressPanel.add((Component)this.checkProgress, cons4);
                this.contentPane.setLayout(new GridBagLayout());
                GridBagConstraints cons = new GridBagConstraints();
                cons.insets = new Insets(8, 8, 8, 8);
                cons.gridx = 0;
                cons.gridy = 0;
                cons.anchor = 18;
                cons.fill = 1;
                cons.weightx = 1.0;
                cons.weighty = 1.0;
                this.contentPane.add((Component)mainPanel, cons);
                ++cons.gridy;
                cons.weighty = 0.0;
                this.contentPane.add((Component)generalButtonPanel, cons);
                ++cons.gridy;
                this.contentPane.add((Component)checkProgressPanel, cons);
                if (debugModeTm) {
                    long runTime = System.currentTimeMillis() - startTime;
                    MessageHandler.printToLogFile("CheckDialog: Time to initialise panels: " + runTime);
                    startTime = System.currentTimeMillis();
                }
                if (inf.canceled()) {
                    return;
                }
                this.dialog.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension frameSize = new Dimension(640, 600);
                this.dialog.setSize(frameSize);
                this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
                this.dialog.setLocationByPlatform(true);
                ToolTipManager.sharedInstance().setDismissDelay(30000);
                if (debugModeTm) {
                    long runTime = System.currentTimeMillis() - startTime;
                    MessageHandler.printToLogFile("CheckDialog: Time to initialise dialog size: " + runTime);
                }
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
                this.closeDialog();
            }
        }

        private void setJComboSelectionBackground(JComboBox<String> comboBox, Color color) {
            Accessible context = comboBox.getAccessibleContext().getAccessibleChild(0);
            BasicComboPopup popup = (BasicComboPopup)context;
            JList<Object> list = popup.getList();
            list.setSelectionBackground(color);
        }

        void setProgressValue(int value, boolean setText) {
            int val;
            int max = this.checkProgress.getMaximum();
            int n = val = value < 0 ? 1 : value + 1;
            if (val > max) {
                val = max;
            }
            this.checkProgress.setValue(val);
            if (setText) {
                int p = (int)((double)(val * 100 / max) + 0.5);
                this.checkProgress.setString(p + " %  ( " + val + " / " + max + " )");
                this.checkProgress.setStringPainted(true);
            }
        }

        void setCacheStatusColor() {
            int size;
            int fullSize = SpellAndGrammarCheckDialog.this.docCache.size();
            int nSingle = 0;
            int nAuto = 0;
            for (int i = 0; i < SpellAndGrammarCheckDialog.this.docCache.size(); ++i) {
                if (SpellAndGrammarCheckDialog.this.docCache.isAutomaticGenerated(i, true)) {
                    ++nAuto;
                    continue;
                }
                if (!SpellAndGrammarCheckDialog.this.docCache.isSingleParagraph(i)) continue;
                ++nSingle;
            }
            int pSize = 0;
            int numCache = 0;
            for (int i = 0; i < this.currentDocument.getParagraphsCache().size(); ++i) {
                if (!SpellAndGrammarCheckDialog.this.documents.isSortedRuleForIndex(i)) continue;
                pSize += this.currentDocument.getParagraphsCache().get(i).size() + nAuto;
                if (i > 0) {
                    pSize += nSingle;
                }
                ++numCache;
            }
            if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.WRITER) {
                int n = size = fullSize == 0 || numCache == 0 ? 0 : pSize * 100 / (fullSize * numCache);
                if (size < 0) {
                    size = 0;
                } else if (size > 100) {
                    size = 100;
                }
            } else {
                size = 100;
            }
            this.cacheStatusLabel.setToolTipText(messages.getString("loDialogCacheLabel") + ": " + size + "%");
            if (size < 25) {
                this.cacheStatusLabel.setForeground(new Color(this.fitToColorboundaries(145 + 4 * size), 0, 0));
            } else if (size < 50) {
                this.cacheStatusLabel.setForeground(new Color(255, this.fitToColorboundaries(5 + 4 * size), 0));
            } else if (size < 75) {
                this.cacheStatusLabel.setForeground(new Color(this.fitToColorboundaries(255 - 4 * (size - 25)), 255, 0));
            } else {
                this.cacheStatusLabel.setForeground(new Color(0, this.fitToColorboundaries(255 - 4 * (size - 70)), 0));
            }
        }

        private int fitToColorboundaries(int col) {
            if (col < 0 || col > 255) {
                return 255;
            }
            return col;
        }

        void errorReturn() {
            MessageHandler.showMessage(loBusyMessage);
            this.closeDialog();
        }

        public void show() throws Throwable {
            if (debugMode) {
                MessageHandler.printToLogFile("CheckDialog: show: Goto next Error");
            }
            if (SpellAndGrammarCheckDialog.this.dialogX < 0 || SpellAndGrammarCheckDialog.this.dialogY < 0) {
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension frameSize = this.dialog.getSize();
                SpellAndGrammarCheckDialog.this.dialogX = screenSize.width / 2 - frameSize.width / 2;
                SpellAndGrammarCheckDialog.this.dialogY = screenSize.height / 2 - frameSize.height / 2;
            }
            this.dialog.setLocation(SpellAndGrammarCheckDialog.this.dialogX, SpellAndGrammarCheckDialog.this.dialogY);
            this.dialog.setAutoRequestFocus(true);
            this.dialog.setVisible(true);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        long startTime = 0L;
                        if (debugModeTm) {
                            startTime = System.currentTimeMillis();
                        }
                        LtCheckDialog.this.setAtWorkButtonState();
                        LtCheckDialog.this.dialog.toFront();
                        LtCheckDialog.this.docId = LtCheckDialog.this.currentDocument.getDocID();
                        if (SpellAndGrammarCheckDialog.this.lt == null || !SpellAndGrammarCheckDialog.this.documents.isCheckImpressDocument()) {
                            SpellAndGrammarCheckDialog.this.setLangTool(LtCheckDialog.this.currentDocument, SpellAndGrammarCheckDialog.this.lastLanguage);
                        }
                        LtCheckDialog.this.setUserDictionaries();
                        for (String dic : LtCheckDialog.this.userDictionaries) {
                            LtCheckDialog.this.addToDictionary.addItem(dic);
                        }
                        if (!LtCheckDialog.this.initCursor(true)) {
                            LtCheckDialog.this.errorReturn();
                            return;
                        }
                        if (debugModeTm) {
                            long runTime = System.currentTimeMillis() - startTime;
                            MessageHandler.printToLogFile("CheckDialog: Time to initialise run: " + runTime);
                        }
                        LtCheckDialog.this.setCacheStatusColor();
                        LtCheckDialog.this.gotoNextError(false);
                    }
                    catch (Throwable t) {
                        MessageHandler.showError(t);
                        LtCheckDialog.this.closeDialog();
                    }
                }
            });
            t.start();
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean initCursor(boolean isStart) throws Throwable {
            if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.WRITER) {
                XTextCursor tCursor;
                this.viewCursor = new ViewCursorTools(this.currentDocument.getXComponent());
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: initCursor: viewCursor initialized: docId: " + this.docId);
                }
                if ((tCursor = this.viewCursor.getTextCursorBeginn()) == null) {
                    this.closeDialog();
                    MessageHandler.showClosingInformationDialog(messages.getString("loDialogUnsupported"));
                    return false;
                }
                tCursor.gotoStart(true);
                int nBegin = tCursor.getString().length();
                tCursor = this.viewCursor.getTextCursorEnd();
                tCursor.gotoStart(true);
                int nEnd = tCursor.getString().length();
                if (nBegin < nEnd) {
                    this.startOfRange = this.viewCursor.getViewCursorCharacter();
                    this.endOfRange = nEnd - nBegin + this.startOfRange;
                    this.lastX = 0;
                    this.lastY = -1;
                } else {
                    this.startOfRange = -1;
                    this.endOfRange = -1;
                }
            } else {
                this.startOfRange = -1;
                this.endOfRange = -1;
            }
            if (isStart || this.endOfRange > 0) {
                this.lastPara = -1;
            }
            return true;
        }

        List<RuleIdentification> getAllDifferentErrors() {
            ArrayList<RuleIdentification> errors = new ArrayList<RuleIdentification>();
            List<Rule> allRules = SpellAndGrammarCheckDialog.this.lt.getAllRules();
            for (int nFPara = 0; nFPara < SpellAndGrammarCheckDialog.this.docCache.size(); ++nFPara) {
                for (int cacheNum = 0; cacheNum < SpellAndGrammarCheckDialog.this.documents.getNumMinToCheckParas().size(); ++cacheNum) {
                    SingleProofreadingError[] pErrors;
                    if (SpellAndGrammarCheckDialog.this.docCache.isAutomaticGenerated(nFPara, true) || cacheNum != 0 && (!SpellAndGrammarCheckDialog.this.documents.isSortedRuleForIndex(cacheNum) || this.currentDocument.getDocumentCache().isSingleParagraph(nFPara)) || (pErrors = this.currentDocument.getParagraphsCache().get(cacheNum).getSafeMatches(nFPara)) == null) continue;
                    block2: for (SingleProofreadingError pError : pErrors) {
                        if (pError.nErrorType == 1) continue;
                        boolean toAdd = true;
                        for (RuleIdentification error : errors) {
                            if (!pError.aRuleIdentifier.equals(error.ruleId)) continue;
                            toAdd = false;
                            break;
                        }
                        if (!toAdd) continue;
                        for (Rule rule : allRules) {
                            if (!rule.getId().equals(pError.aRuleIdentifier)) continue;
                            int n = 0;
                            for (RuleIdentification error : errors) {
                                if (rule.getDescription().compareToIgnoreCase(error.ruleName) < 0) break;
                                ++n;
                            }
                            errors.add(n, new RuleIdentification(pError.aRuleIdentifier, rule.getDescription()));
                            continue block2;
                        }
                    }
                }
            }
            return errors;
        }

        String getRuleName(String ruleId, List<RuleIdentification> rules) {
            for (RuleIdentification rule : rules) {
                if (!ruleId.equals(rule.ruleId)) continue;
                return rule.ruleName;
            }
            return null;
        }

        String getRuleId(String ruleName, List<RuleIdentification> rules) {
            for (RuleIdentification rule : rules) {
                if (!ruleName.equals(rule.ruleName)) continue;
                return rule.ruleId;
            }
            return null;
        }

        private String formatToolTipText(String Text) {
            String toolTipText = Text;
            int breakIndex = 0;
            int isNum = 0;
            while (breakIndex >= 0) {
                if ((breakIndex = toolTipText.indexOf("\n", breakIndex)) < 0) continue;
                int nextNonBlank = breakIndex + 1;
                while (' ' == toolTipText.charAt(nextNonBlank)) {
                    ++nextNonBlank;
                }
                if (isNum == 0) {
                    if (toolTipText.charAt(nextNonBlank) == '-') {
                        toolTipText = toolTipText.substring(0, breakIndex) + "</p><ul width=\"" + 300 + "\"><li>" + toolTipText.substring(nextNonBlank + 1);
                        isNum = 1;
                        continue;
                    }
                    if (toolTipText.charAt(nextNonBlank) >= '1' && toolTipText.charAt(nextNonBlank) <= '9' && toolTipText.charAt(nextNonBlank + 1) == '.') {
                        toolTipText = toolTipText.substring(0, breakIndex) + "</p><ol width=\"" + 300 + "\"><li>" + toolTipText.substring(nextNonBlank + 2);
                        isNum = 2;
                        continue;
                    }
                    toolTipText = toolTipText.substring(0, breakIndex) + "</p><p width=\"" + 300 + "\">" + toolTipText.substring(breakIndex + 1);
                    continue;
                }
                if (isNum == 1) {
                    if (toolTipText.charAt(nextNonBlank) == '-') {
                        toolTipText = toolTipText.substring(0, breakIndex) + "</li><li>" + toolTipText.substring(nextNonBlank + 1);
                        continue;
                    }
                    toolTipText = toolTipText.substring(0, breakIndex) + "</li></ul><p width=\"" + 300 + "\">" + toolTipText.substring(breakIndex + 1);
                    isNum = 0;
                    continue;
                }
                if (toolTipText.charAt(nextNonBlank) >= '1' && toolTipText.charAt(nextNonBlank) <= '9' && toolTipText.charAt(nextNonBlank + 1) == '.') {
                    toolTipText = toolTipText.substring(0, breakIndex) + "</li><li>" + toolTipText.substring(nextNonBlank + 2);
                    continue;
                }
                toolTipText = toolTipText.substring(0, breakIndex) + "</li></ol><p width=\"" + 300 + "\">" + toolTipText.substring(breakIndex + 1);
                isNum = 0;
            }
            toolTipText = isNum == 0 ? "<html><div style='color:black;'><p width=\"300\">" + toolTipText + "</p></html>" : (isNum == 1 ? "<html><div style='color:black;'><p width=\"300\">" + toolTipText + "</ul></html>" : "<html><div style='color:black;'><p width=\"300\">" + toolTipText + "</ol></html>");
            return toolTipText;
        }

        private void setAtWorkButtonState() {
            this.setAtWorkButtonState(true);
        }

        private void setAtWorkButtonState(boolean work) {
            this.checkProgress.setIndeterminate(true);
            this.ignoreOnce.setEnabled(false);
            this.ignorePermanent.setEnabled(false);
            this.resetIgnorePermanent.setEnabled(false);
            this.ignoreAll.setEnabled(false);
            this.deactivateRule.setEnabled(false);
            this.change.setEnabled(false);
            this.changeAll.setEnabled(false);
            this.autoCorrect.setEnabled(false);
            this.addToDictionary.setEnabled(false);
            this.more.setEnabled(false);
            this.help.setEnabled(false);
            this.options.setEnabled(false);
            this.undo.setEnabled(false);
            this.close.setEnabled(false);
            this.language.setEnabled(false);
            this.changeLanguage.setEnabled(false);
            this.activateRule.setEnabled(false);
            this.checkRuleBox.setEnabled(false);
            this.endOfDokumentMessage = null;
            this.sentenceIncludeError.setBackground(Color.LIGHT_GRAY);
            this.sentenceIncludeError.setEnabled(false);
            this.suggestions.setBackground(Color.LIGHT_GRAY);
            this.suggestions.setEnabled(false);
            this.errorDescription.setText(checkStatusCheck);
            this.errorDescription.setForeground(Color.RED);
            this.errorDescription.setBackground(Color.LIGHT_GRAY);
            this.contentPane.revalidate();
            this.contentPane.repaint();
            this.dialog.setEnabled(false);
            this.atWork = work;
        }

        private void gotoNextError() {
            this.gotoNextError(true);
        }

        private void gotoNextError(boolean startAtBegin) {
            try {
                if (!SpellAndGrammarCheckDialog.this.documents.isEnoughHeapSpace()) {
                    this.closeDialog();
                    return;
                }
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: findNextError: start getNextError");
                }
                this.removeMarkups();
                if (SpellAndGrammarCheckDialog.this.checkType == 3 && SpellAndGrammarCheckDialog.this.checkRuleId == null) {
                    if (this.checkRuleBox.getItemCount() > 0) {
                        SpellAndGrammarCheckDialog.this.checkRuleId = this.getRuleId((String)this.checkRuleBox.getSelectedItem(), this.allDifferentErrors);
                    } else {
                        this.checkTypeButtons[0].setSelected(true);
                        SpellAndGrammarCheckDialog.this.checkType = 0;
                        this.checkRuleBox.setEnabled(false);
                    }
                }
                CheckError checkError = this.getNextError(startAtBegin);
                if (this.isDisposed) {
                    return;
                }
                OfficeTools.waitForLO();
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: findNextError: Error is " + (checkError == null ? "Null" : "NOT Null"));
                }
                this.error = checkError == null ? null : checkError.error;
                this.locale = checkError == null ? null : checkError.locale;
                this.dialog.setEnabled(true);
                this.checkProgress.setIndeterminate(false);
                this.help.setEnabled(true);
                this.options.setEnabled(true);
                this.close.setEnabled(true);
                this.resetIgnorePermanent.setEnabled(true);
                if (this.sentenceIncludeError == null || this.errorDescription == null || this.suggestions == null) {
                    MessageHandler.printToLogFile("CheckDialog: findNextError: SentenceIncludeError == null || errorDescription == null || suggestions == null");
                    this.error = null;
                }
                this.setCacheStatusColor();
                if (this.error != null) {
                    Language lang;
                    this.isSpellError = this.error.nErrorType == 1;
                    this.blockSentenceError = true;
                    this.sentenceIncludeError.setEnabled(true);
                    this.sentenceIncludeError.setBackground(Color.white);
                    this.sentenceIncludeError.setText(SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(this.y));
                    this.setAttributesForErrorText(this.error);
                    this.blockSentenceError = false;
                    this.errorDescription.setEnabled(true);
                    this.errorDescription.setText(this.error.aFullComment);
                    this.errorDescription.setForeground(this.defaultForeground);
                    this.errorDescription.setBackground(Color.white);
                    this.ignoreOnce.setEnabled(true);
                    this.ignoreAll.setEnabled(true);
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: findNextError: Error Text set");
                    }
                    if (this.error.aSuggestions != null && this.error.aSuggestions.length > 0) {
                        this.suggestions.setEnabled(true);
                        this.suggestions.setListData((String[])this.error.aSuggestions);
                        this.suggestions.setSelectedIndex(0);
                        this.suggestions.setBackground(Color.white);
                        this.change.setEnabled(true);
                        this.changeAll.setEnabled(true);
                        this.autoCorrect.setEnabled(true);
                    } else {
                        this.suggestions.setEnabled(true);
                        this.suggestions.setListData((String[])new String[0]);
                        this.change.setEnabled(false);
                        this.changeAll.setEnabled(true);
                        this.autoCorrect.setEnabled(false);
                    }
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: findNextError: Suggestions set");
                    }
                    Language language = lang = this.locale == null ? SpellAndGrammarCheckDialog.this.lt.getLanguage() : MultiDocumentsHandler.getLanguage(this.locale);
                    if (lang == null) {
                        lang = SpellAndGrammarCheckDialog.this.lt.getLanguage();
                    }
                    if (debugMode && SpellAndGrammarCheckDialog.this.lt.getLanguage() == null) {
                        MessageHandler.printToLogFile("CheckDialog: findNextError: LT language == null");
                    }
                    this.lastLang = lang.getTranslatedName(messages);
                    this.language.setEnabled(true);
                    this.language.setSelectedItem(lang.getTranslatedName(messages));
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: findNextError: Language set");
                    }
                    this.allDifferentErrors = this.getAllDifferentErrors();
                    if (this.allDifferentErrors.size() != this.checkRuleBox.getItemCount()) {
                        this.checkRuleBox.removeAllItems();
                        for (RuleIdentification error : this.allDifferentErrors) {
                            this.checkRuleBox.addItem(error.ruleName);
                        }
                    }
                    if (SpellAndGrammarCheckDialog.this.checkType == 3) {
                        if (SpellAndGrammarCheckDialog.this.checkRuleId != null) {
                            this.checkRuleBox.setSelectedItem(this.getRuleName(SpellAndGrammarCheckDialog.this.checkRuleId, this.allDifferentErrors));
                        }
                        this.checkRuleBox.setEnabled(true);
                    }
                    Map<String, String> deactivatedRulesMap = SpellAndGrammarCheckDialog.this.documents.getDisabledRulesMap(OfficeTools.localeToString(this.locale));
                    if (!this.isSpellError && !deactivatedRulesMap.isEmpty()) {
                        this.activateRule.removeAllItems();
                        this.activateRule.addItem(messages.getString("loContextMenuActivateRule"));
                        for (String ruleId : deactivatedRulesMap.keySet()) {
                            String tmpStr = deactivatedRulesMap.get(ruleId);
                            if (tmpStr.length() > 28) {
                                tmpStr = tmpStr.substring(0, 25) + "...";
                            }
                            this.activateRule.addItem(tmpStr);
                        }
                        this.activateRule.setVisible(true);
                        this.activateRule.setEnabled(true);
                        this.autoCorrect.setVisible(false);
                    } else {
                        this.activateRule.setVisible(false);
                        this.autoCorrect.setVisible(true);
                        this.autoCorrect.setEnabled(false);
                    }
                    if (this.isSpellError) {
                        this.ignoreAll.setText(ignoreAllButtonName);
                        this.addToDictionary.setVisible(true);
                        this.deactivateRule.setVisible(false);
                        this.addToDictionary.setEnabled(true);
                        this.changeAll.setEnabled(true);
                        this.autoCorrect.setEnabled(true);
                        this.ignorePermanent.setEnabled(true);
                    } else {
                        this.ignoreAll.setText(ignoreRuleButtonName);
                        this.addToDictionary.setVisible(false);
                        this.changeAll.setEnabled(true);
                        this.deactivateRule.setVisible(true);
                        this.deactivateRule.setEnabled(true);
                        this.autoCorrect.setEnabled(false);
                        this.ignorePermanent.setEnabled(true);
                    }
                    this.informationUrl = this.getUrl(this.error);
                    this.more.setEnabled(this.informationUrl != null);
                    this.undo.setEnabled(this.undoList != null && !this.undoList.isEmpty());
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: findNextError: All set");
                    }
                } else {
                    this.language.setEnabled(true);
                    Language lang = this.locale == null || !MultiDocumentsHandler.hasLocale(this.locale) ? SpellAndGrammarCheckDialog.this.lt.getLanguage() : MultiDocumentsHandler.getLanguage(this.locale);
                    this.language.setSelectedItem(lang.getTranslatedName(messages));
                    this.language.setEnabled(false);
                    this.more.setEnabled(false);
                    this.ignoreOnce.setEnabled(false);
                    this.ignoreAll.setEnabled(false);
                    this.addToDictionary.setVisible(true);
                    this.addToDictionary.setEnabled(false);
                    this.deactivateRule.setVisible(false);
                    this.changeAll.setEnabled(false);
                    this.activateRule.setVisible(false);
                    this.autoCorrect.setVisible(true);
                    this.autoCorrect.setEnabled(false);
                    this.focusLost = false;
                    this.suggestions.setEnabled(true);
                    this.suggestions.setListData((String[])new String[0]);
                    this.undo.setEnabled(this.undoList != null && !this.undoList.isEmpty());
                    this.errorDescription.setEnabled(true);
                    this.errorDescription.setForeground(Color.RED);
                    this.errorDescription.setText(this.endOfDokumentMessage == null ? " " : this.endOfDokumentMessage);
                    this.errorDescription.setBackground(Color.white);
                    this.sentenceIncludeError.setEnabled(false);
                    this.errorDescription.setEnabled(true);
                    this.change.setEnabled(false);
                    if (SpellAndGrammarCheckDialog.this.docCache.size() > 0) {
                        this.locale = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraphLocale(SpellAndGrammarCheckDialog.this.docCache.size() - 1);
                    }
                    this.sentenceIncludeError.setEnabled(false);
                }
            }
            catch (Throwable e) {
                MessageHandler.showError(e);
                this.closeDialog();
            }
            this.atWork = false;
        }

        private void setUserDictionaries() {
            String[] tmpDictionaries = LtDictionary.getUserDictionaries(SpellAndGrammarCheckDialog.this.xContext);
            this.userDictionaries = new String[tmpDictionaries.length + 1];
            this.userDictionaries[0] = addToDictionaryName;
            for (int i = 0; i < tmpDictionaries.length; ++i) {
                String tmpStr = tmpDictionaries[i];
                if (tmpStr.length() > 28) {
                    tmpStr = tmpStr.substring(0, 25) + "...";
                }
                this.userDictionaries[i + 1] = tmpStr;
            }
        }

        private String[] getPossibleLanguages() {
            ArrayList<String> languages = new ArrayList<String>();
            for (Language lang : Languages.get()) {
                languages.add(lang.getTranslatedName(messages));
                languages.sort(null);
            }
            languages.add(0, messages.getString("loDialogDoNotCheck"));
            return languages.toArray(new String[languages.size()]);
        }

        private Locale getLocaleFromLanguageName(String translatedName) {
            if (translatedName.equals(messages.getString("loDialogDoNotCheck"))) {
                return new Locale("zxx", "", "");
            }
            for (Language lang : Languages.get()) {
                if (!translatedName.equals(lang.getTranslatedName(messages))) continue;
                return LinguisticServices.getLocale(lang);
            }
            return null;
        }

        private void setAttributesForErrorText(SingleProofreadingError error) {
            this.sentenceIncludeError.setEnabled(true);
            MutableAttributeSet attrs = this.sentenceIncludeError.getInputAttributes();
            StyledDocument doc = this.sentenceIncludeError.getStyledDocument();
            StyleConstants.setBold(attrs, false);
            StyleConstants.setUnderline(attrs, false);
            StyleConstants.setForeground(attrs, this.defaultForeground);
            doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, true);
            StyleConstants.setBold(attrs, true);
            StyleConstants.setUnderline(attrs, true);
            Color color = null;
            if (this.isSpellError) {
                color = Color.RED;
            } else {
                PropertyValue[] properties;
                for (PropertyValue property : properties = error.aProperties) {
                    if (!"LineColor".equals(property.Name)) continue;
                    color = new Color((Integer)property.Value);
                    break;
                }
                if (color == null) {
                    color = Color.BLUE;
                }
            }
            StyleConstants.setForeground(attrs, color);
            doc.setCharacterAttributes(error.nErrorStart, error.nErrorLength, attrs, true);
        }

        private String getUrl(SingleProofreadingError error) {
            if (!this.isSpellError) {
                PropertyValue[] properties;
                for (PropertyValue property : properties = error.aProperties) {
                    if (!"FullCommentURL".equals(property.Name)) continue;
                    String url = new String((String)property.Value);
                    return url;
                }
            }
            return null;
        }

        private CheckError getNextError(boolean startAtBegin) throws Throwable {
            if (SpellAndGrammarCheckDialog.this.docType != OfficeTools.DocumentType.WRITER) {
                this.currentDocument = SpellAndGrammarCheckDialog.this.getCurrentDocument(false);
            }
            if (this.currentDocument == null) {
                MessageHandler.printToLogFile("CheckDialog: getNextError: currentDocument == null: close dialog");
                MessageHandler.showMessage(messages.getString("loDialogErrorCloseMessage"));
                this.closeDialog();
                return null;
            }
            XComponent xComponent = this.currentDocument.getXComponent();
            DocumentCursorTools docCursor = new DocumentCursorTools(xComponent);
            if (SpellAndGrammarCheckDialog.this.docCache.size() <= 0) {
                MessageHandler.printToLogFile("CheckDialog: getNextError: docCache size == 0: close dialog");
                MessageHandler.showMessage(messages.getString("loDialogErrorCloseMessage"));
                this.closeDialog();
                return null;
            }
            for (int nWhile = 0; nWhile < 20; ++nWhile) {
                if (debugMode) {
                    MessageHandler.printToLogFile("\nCheckDialog: getNextError: Loop: " + nWhile + "\n");
                }
                if (this.uncheckedParasLeft) {
                    this.uncheckedParasLeft = false;
                } else {
                    SpellAndGrammarCheckDialog.this.hasUncheckedParas = false;
                }
                if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.WRITER) {
                    if (nWhile > 0 && SpellAndGrammarCheckDialog.this.hasUncheckedParas && this.endOfRange < 0) {
                        this.y = this.lastPara;
                    } else {
                        DocumentCache.TextParagraph tPara = this.viewCursor.getViewCursorParagraph();
                        this.y = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraphNumber(tPara);
                    }
                } else {
                    this.y = SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.IMPRESS ? OfficeDrawTools.getParagraphFromCurrentPage(xComponent) : OfficeSpreadsheetTools.getParagraphFromCurrentSheet(xComponent);
                }
                if (this.y < 0 || this.y >= SpellAndGrammarCheckDialog.this.docCache.size()) {
                    MessageHandler.printToLogFile("CheckDialog: getNextError: y (= " + this.y + ") >= text size (= " + SpellAndGrammarCheckDialog.this.docCache.size() + "): close dialog");
                    MessageHandler.showMessage(messages.getString("loDialogErrorCloseMessage"));
                    this.closeDialog();
                    return null;
                }
                if (this.lastPara < 0) {
                    this.lastPara = this.y;
                }
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: getNextError: (x/y): (" + this.x + "/" + this.y + ") < text size (= " + SpellAndGrammarCheckDialog.this.docCache.size() + ")");
                }
                this.x = this.endOfRange >= 0 && this.y == this.lastPara ? this.startOfRange : 0;
                int nStart = 0;
                for (int i = this.lastPara; i < this.y && i < SpellAndGrammarCheckDialog.this.docCache.size(); ++i) {
                    nStart += SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(i).length() + 1;
                }
                this.checkProgress.setMaximum(this.endOfRange < 0 ? SpellAndGrammarCheckDialog.this.docCache.size() : this.endOfRange);
                CheckError nextError = null;
                while (this.y < SpellAndGrammarCheckDialog.this.docCache.size() && this.y >= this.lastPara && nextError == null && (this.endOfRange < 0 || nStart < this.endOfRange)) {
                    this.setProgressValue(this.endOfRange < 0 ? this.y - this.lastPara : nStart + (this.lastY == this.y ? this.lastX : 0), this.endOfRange < 0);
                    nextError = SpellAndGrammarCheckDialog.this.getNextErrorInParagraph(this.x, this.y, this.currentDocument, docCursor, true);
                    if (this.isDisposed) {
                        return null;
                    }
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: getNextError: endOfRange = " + this.endOfRange + ", startOfRange = " + this.startOfRange + ", nStart = " + nStart + ", lastX = " + this.lastX + ", lastPara = " + this.lastPara);
                    }
                    int pLength = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(this.y).length() + 1;
                    if (nextError != null && (this.endOfRange < 0 || (nStart += pLength) - pLength + nextError.error.nErrorStart < this.endOfRange)) {
                        if (nextError.error.nErrorType == 1) {
                            this.wrongWord = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(this.y).substring(nextError.error.nErrorStart, nextError.error.nErrorStart + nextError.error.nErrorLength);
                        }
                        if (debugMode) {
                            MessageHandler.printToLogFile("CheckDialog: getNextError: endOfRange: " + this.endOfRange + "; ErrorStart(" + nStart + "/" + pLength + "/" + nextError.error.nErrorStart + "): " + (nStart - pLength + nextError.error.nErrorStart));
                            MessageHandler.printToLogFile("CheckDialog: getNextError: x: " + this.x + "; y: " + this.y);
                        }
                        this.setFlatViewCursor(nextError.error.nErrorStart, this.y, nextError.error, this.viewCursor);
                        this.lastX = nextError.error.nErrorStart;
                        this.lastY = this.y;
                        if (debugMode) {
                            MessageHandler.printToLogFile("CheckDialog: getNextError: FlatViewCursor set");
                        }
                        this.uncheckedParasLeft = SpellAndGrammarCheckDialog.this.hasUncheckedParas;
                        return nextError;
                    }
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: getNextError: Next Error = " + (nextError == null ? "null" : Integer.valueOf(nextError.error.nErrorStart)) + ", endOfRange: " + this.endOfRange + "; x: " + this.x + "; y: " + this.y + "; lastPara:" + this.lastPara);
                    }
                    ++this.y;
                    this.x = 0;
                }
                if (this.endOfRange < 0) {
                    if (this.y == SpellAndGrammarCheckDialog.this.docCache.size()) {
                        this.y = 0;
                    }
                    while (this.y < this.lastPara) {
                        this.setProgressValue(SpellAndGrammarCheckDialog.this.docCache.size() + this.y - this.lastPara, true);
                        nextError = SpellAndGrammarCheckDialog.this.getNextErrorInParagraph(0, this.y, this.currentDocument, docCursor, true);
                        if (this.isDisposed) {
                            return null;
                        }
                        if (nextError != null) {
                            if (nextError.error.nErrorType == 1) {
                                this.wrongWord = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(this.y).substring(nextError.error.nErrorStart, nextError.error.nErrorStart + nextError.error.nErrorLength);
                            }
                            this.setFlatViewCursor(nextError.error.nErrorStart, this.y, nextError.error, this.viewCursor);
                            if (debugMode) {
                                MessageHandler.printToLogFile("CheckDialog: getNextError: y: " + this.y + "lastPara: " + this.lastPara + ", ErrorStart: " + nextError.error.nErrorStart + ", ErrorLength: " + nextError.error.nErrorLength);
                            }
                            this.uncheckedParasLeft = SpellAndGrammarCheckDialog.this.hasUncheckedParas;
                            return nextError;
                        }
                        ++this.y;
                    }
                    this.endOfDokumentMessage = messages.getString("guiCheckComplete");
                    this.setProgressValue(SpellAndGrammarCheckDialog.this.docCache.size() - 1, true);
                    if (SpellAndGrammarCheckDialog.this.hasUncheckedParas) continue;
                    break;
                }
                this.endOfDokumentMessage = messages.getString("guiSelectionCheckComplete");
                this.setProgressValue(this.endOfRange - 1, false);
                break;
            }
            this.uncheckedParasLeft = false;
            this.lastPara = -1;
            if (debugMode) {
                MessageHandler.printToLogFile("CheckDialog: getNextError: Error == null, y: " + this.y + "; lastPara: " + this.lastPara);
            }
            return null;
        }

        @Override
        public void actionPerformed(final ActionEvent action) {
            if (!this.atWork) {
                try {
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: actionPerformed: Action: " + action.getActionCommand());
                    }
                    if (action.getActionCommand().equals("close")) {
                        this.closeDialog();
                    } else if (action.getActionCommand().equals("more")) {
                        Tools.openURL(this.informationUrl);
                    } else if (action.getActionCommand().equals("options")) {
                        SpellAndGrammarCheckDialog.this.documents.runOptionsDialog();
                    } else if (action.getActionCommand().equals("help")) {
                        MessageHandler.showMessage(messages.getString("loDialogHelpText"));
                    } else {
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (action.getActionCommand().equals("ignoreOnce")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.ignoreOnce();
                                    } else if (action.getActionCommand().equals("ignoreAll")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.ignoreAll();
                                    } else if (action.getActionCommand().equals("ignorePermanent")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.ignorePermanent();
                                    } else if (action.getActionCommand().equals("resetIgnorePermanent")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.resetIgnorePermanent();
                                    } else if (action.getActionCommand().equals("deactivateRule")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.deactivateRule();
                                    } else if (action.getActionCommand().equals("change")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.changeText();
                                    } else if (action.getActionCommand().equals("changeAll")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.changeAll();
                                    } else if (action.getActionCommand().equals("autoCorrect")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.autoCorrect();
                                    } else if (action.getActionCommand().equals("undo")) {
                                        LtCheckDialog.this.setAtWorkButtonState();
                                        LtCheckDialog.this.undo();
                                    } else {
                                        MessageHandler.showMessage("Action '" + action.getActionCommand() + "' not supported");
                                    }
                                }
                                catch (Throwable e) {
                                    MessageHandler.showError(e);
                                    LtCheckDialog.this.closeDialog();
                                }
                            }
                        });
                        t.start();
                    }
                }
                catch (Throwable e) {
                    MessageHandler.showError(e);
                    this.closeDialog();
                }
            }
        }

        public void closeDialog() {
            this.isDisposed = true;
            this.removeMarkups();
            this.dialog.setVisible(false);
            if (debugMode) {
                MessageHandler.printToLogFile("CheckDialog: closeDialog: Close Spell And Grammar Check Dialog");
            }
            this.undoList.clear();
            SpellAndGrammarCheckDialog.this.documents.setLtDialog(null);
            SpellAndGrammarCheckDialog.this.documents.setLtDialogIsRunning(false);
            this.atWork = false;
        }

        private void removeSpellingMark(int nFlat) throws Throwable {
            XParagraphCursor pCursor = this.viewCursor.getParagraphCursorFromViewCursor();
            pCursor.gotoStartOfParagraph(false);
            pCursor.goRight((short)this.error.nErrorStart, false);
            pCursor.goRight((short)this.error.nErrorLength, true);
            XMarkingAccess xMarkingAccess = (XMarkingAccess)UnoRuntime.queryInterface(XMarkingAccess.class, (Object)pCursor);
            if (xMarkingAccess == null) {
                MessageHandler.printToLogFile("CheckDialog: removeSpellingMark: xMarkingAccess == null");
            } else {
                xMarkingAccess.invalidateMarkings(1);
            }
        }

        private void ignoreOnce() throws Throwable {
            this.x = this.error.nErrorStart;
            if (this.isSpellError && SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.WRITER) {
                this.removeSpellingMark(this.y);
            }
            this.currentDocument.setIgnoredMatch(this.x, this.y, this.error.aRuleIdentifier, true);
            this.addUndo(this.x, this.y, "ignoreOnce", this.error.aRuleIdentifier);
            this.gotoNextError();
        }

        private void ignorePermanent() throws Throwable {
            this.x = this.error.nErrorStart;
            Locale locale = this.error.nErrorType == 1 ? SpellAndGrammarCheckDialog.this.docCache.getFlatParagraphLocale(this.y) : null;
            int len = this.error.nErrorType == 1 ? this.error.nErrorLength : 0;
            this.currentDocument.setPermanentIgnoredMatch(this.error.nErrorStart, this.y, len, this.error.aRuleIdentifier, locale, false);
            this.addUndo(this.x, this.y, "ignorePermanent", this.error.aRuleIdentifier);
            this.gotoNextError();
        }

        private void resetIgnorePermanent() throws Throwable {
            this.addUndo(this.y, "resetIgnorePermanent", this.currentDocument.getPermanentIgnoredMatches());
            this.currentDocument.resetIgnorePermanent();
            this.gotoNextError();
        }

        private void ignoreAll() throws Throwable {
            if (this.isSpellError) {
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: ignoreAll: Ignored word: " + this.wrongWord);
                }
                LtDictionary.addIgnoredWord(this.wrongWord, SpellAndGrammarCheckDialog.this.xContext);
            } else {
                SpellAndGrammarCheckDialog.this.documents.ignoreRule(this.error.aRuleIdentifier, this.locale);
                SpellAndGrammarCheckDialog.this.documents.initDocuments(true);
                SpellAndGrammarCheckDialog.this.documents.resetDocument();
                SpellAndGrammarCheckDialog.this.doInit = true;
            }
            this.addUndo(this.y, "ignoreAll", this.error.aRuleIdentifier);
            this.gotoNextError();
        }

        private void deactivateRule() throws Throwable {
            if (!this.isSpellError) {
                SpellAndGrammarCheckDialog.this.documents.deactivateRule(this.error.aRuleIdentifier, OfficeTools.localeToString(this.locale), false);
                this.addUndo(this.y, "deactivateRule", this.error.aRuleIdentifier);
                SpellAndGrammarCheckDialog.this.doInit = true;
            }
            this.gotoNextError();
        }

        private int getDifferenceFromBegin(String text1, String text2) {
            for (int i = 0; i < text1.length() && i < text2.length(); ++i) {
                if (text1.charAt(i) == text2.charAt(i)) continue;
                return i;
            }
            return text1.length() < text2.length() ? text1.length() : text2.length();
        }

        private int getDifferenceFromEnd(String text1, String text2) {
            for (int i = 1; i <= text1.length() && i <= text2.length(); ++i) {
                if (text1.charAt(text1.length() - i) == text2.charAt(text2.length() - i)) continue;
                return text1.length() - i + 1;
            }
            return text1.length() < text2.length() ? 0 : text1.length() - text2.length();
        }

        private void changeText() throws Throwable {
            String word = "";
            String replace = "";
            this.removeMarkups();
            if (debugMode) {
                MessageHandler.printToLogFile("CheckDialog: changeText entered - docType: " + (Object)((Object)SpellAndGrammarCheckDialog.this.docType));
            }
            String dialogText = this.sentenceIncludeError.getText();
            if (debugMode) {
                MessageHandler.printToLogFile("CheckDialog: changeText: dialog text: " + dialogText);
            }
            String orgText = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(this.y);
            if (debugMode) {
                MessageHandler.printToLogFile("CheckDialog: changeText: original text: " + orgText);
            }
            if (!orgText.equals(dialogText)) {
                int lastDialogEqual;
                int lastEqual;
                int firstChange = this.getDifferenceFromBegin(orgText, dialogText);
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: changeText: firstChange: " + firstChange);
                }
                if ((lastEqual = this.getDifferenceFromEnd(orgText, dialogText)) < firstChange) {
                    lastEqual = firstChange;
                }
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: changeText: lastEqual: " + lastEqual);
                }
                if ((lastDialogEqual = dialogText.length() - orgText.length() + lastEqual) < firstChange) {
                    firstChange += dialogText.length() - orgText.length();
                }
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: changeText: lastDialogEqual: " + lastDialogEqual);
                }
                word = firstChange < lastEqual ? orgText.substring(firstChange, lastEqual) : "";
                replace = firstChange < lastDialogEqual ? dialogText.substring(firstChange, lastDialogEqual) : "";
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: changeText: word: '" + word + "', replace: '" + replace + "'");
                }
                SpellAndGrammarCheckDialog.this.changeTextOfParagraph(this.y, firstChange, lastEqual - firstChange, replace, this.currentDocument, this.viewCursor);
                this.addSingleChangeUndo(firstChange, this.y, word, replace);
            } else if (this.suggestions.getComponentCount() > 0) {
                if (orgText.length() >= this.error.nErrorStart + this.error.nErrorLength) {
                    word = orgText.substring(this.error.nErrorStart, this.error.nErrorStart + this.error.nErrorLength);
                    replace = this.suggestions.getSelectedValue();
                    SpellAndGrammarCheckDialog.this.changeTextOfParagraph(this.y, this.error.nErrorStart, this.error.nErrorLength, replace, this.currentDocument, this.viewCursor);
                    this.addSingleChangeUndo(this.error.nErrorStart, this.y, word, replace);
                }
            } else {
                MessageHandler.printToLogFile("CheckDialog: changeText: No text selected to change");
                return;
            }
            if (debugMode) {
                MessageHandler.printToLogFile("CheckDialog: changeText: Org: " + word + "\nDia: " + replace);
            }
            this.currentDocument = SpellAndGrammarCheckDialog.this.getCurrentDocument(true);
            this.gotoNextError();
        }

        private void changeAll() throws Throwable {
            if (this.suggestions.getComponentCount() > 0) {
                this.removeMarkups();
                String orgText = this.sentenceIncludeError.getText();
                String word = orgText.substring(this.error.nErrorStart, this.error.nErrorStart + this.error.nErrorLength);
                String replace = this.suggestions.getSelectedValue();
                Map orgParas = SpellAndGrammarCheckDialog.this.changeTextInAllParagraph(word, this.error.aRuleIdentifier, replace, this.currentDocument, this.viewCursor);
                if (orgParas != null) {
                    this.addChangeUndo(this.error.nErrorStart, this.y, word, replace, orgParas);
                }
                this.gotoNextError();
            }
        }

        private void autoCorrect() throws Throwable {
            if (this.suggestions.getComponentCount() > 0) {
                String replace;
                String orgText = this.sentenceIncludeError.getText();
                String word = orgText.substring(this.error.nErrorStart, this.error.nErrorStart + this.error.nErrorLength);
                Map orgParas = SpellAndGrammarCheckDialog.this.changeTextInAllParagraph(word, this.error.aRuleIdentifier, replace = this.suggestions.getSelectedValue(), this.currentDocument, this.viewCursor);
                if (orgParas != null) {
                    this.addChangeUndo(this.error.nErrorStart, this.y, word, replace, orgParas);
                }
                this.addToAutoCorrect(word, replace);
                this.gotoNextError();
            }
        }

        private void addToAutoCorrect(String word, String replace) throws Throwable {
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)SpellAndGrammarCheckDialog.this.xContext.getServiceManager());
            if (xMCF == null) {
                MessageHandler.printToLogFile("Could not get XMultiComponentFactory");
                return;
            }
            Object obj = xMCF.createInstanceWithContext("com.sun.star.util.PathSettings", SpellAndGrammarCheckDialog.this.xContext);
            XPropertySet xPathSettings = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)obj);
            String aCorrPathUri = (String)xPathSettings.getPropertyValue("AutoCorrect_writable");
            URI aCorrUri = new URI(aCorrPathUri);
            String aCorrFile = aCorrUri.getPath() + "/" + ACORR_PREFIX + this.locale.Language + "-" + this.locale.Country + ACORR_SUFFIX;
            String aCorrTmpFile = aCorrUri.getPath() + "/" + ACORR_PREFIX + this.locale.Language + "-" + this.locale.Country + "_tmp" + ACORR_SUFFIX;
            MessageHandler.printToLogFile("AutoCorrect path: " + aCorrFile);
            String tmpDir = aCorrUri.getPath() + "/tmp";
            this.unzipACorr(tmpDir, aCorrFile);
            this.addWordPairToCorFile(tmpDir, word, replace);
            this.zipACorr(tmpDir, aCorrTmpFile);
            File tmpDr = new File(tmpDir);
            this.deleteFullDirectory(tmpDr);
            File file = new File(aCorrFile);
            File newFile = new File(aCorrTmpFile);
            file.delete();
            newFile.renameTo(file);
        }

        boolean deleteFullDirectory(File directory) {
            File[] contents = directory.listFiles();
            if (contents != null) {
                for (File file : contents) {
                    this.deleteFullDirectory(file);
                }
            }
            return directory.delete();
        }

        private void unzipACorr(String destDirPath, String zipFilePath) throws IOException {
            File destDir = new File(destDirPath);
            if (destDir.exists() && destDir.isDirectory() && !this.deleteFullDirectory(destDir)) {
                throw new IOException("Failed to remove directory " + destDirPath);
            }
            if (!destDir.mkdir()) {
                throw new IOException("Failed to create directory " + destDirPath);
            }
            byte[] buffer = new byte[1024];
            try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFilePath));){
                ZipEntry zipEntry = zis.getNextEntry();
                while (zipEntry != null) {
                    File newFile = new File(destDir, zipEntry.getName());
                    if (zipEntry.isDirectory()) {
                        if (!newFile.isDirectory() && !newFile.mkdirs()) {
                            throw new IOException("Failed to create directory " + newFile);
                        }
                    } else {
                        int len;
                        File parent = newFile.getParentFile();
                        if (!parent.isDirectory() && !parent.mkdirs()) {
                            throw new IOException("Failed to create directory " + parent);
                        }
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    zipEntry = zis.getNextEntry();
                }
                zis.closeEntry();
                zis.close();
            }
        }

        private void addWordPairToCorFile(String dirPath, String word, String replace) throws Throwable {
            int len;
            String fileName = "DocumentList.xml";
            String tmpFileName = "DocumentList_tmp.xml";
            File file = new File(dirPath, fileName);
            File newFile = new File(dirPath, tmpFileName);
            FileInputStream fis = new FileInputStream(file);
            FileOutputStream fos = new FileOutputStream(newFile);
            byte[] buffer = new byte[1024];
            for (long maxReadLen = file.length() - 24L; maxReadLen > 0L && (len = fis.read(buffer)) > 0; maxReadLen -= (long)len) {
                if ((long)len > maxReadLen) {
                    len = (int)maxReadLen;
                }
                fos.write(buffer, 0, len);
            }
            fis.close();
            String str = "<block-list:block block-list:abbreviated-name=\"" + word + "\" block-list:name=\"" + replace + "\"/></block-list:block-list>";
            buffer = str.getBytes();
            len = buffer.length;
            fos.write(buffer, 0, len);
            fos.close();
            file.delete();
            newFile.renameTo(file);
        }

        private void zipACorr(String sourceDirPath, String zipFilePath) throws IOException {
            File[] children;
            FileOutputStream fos = new FileOutputStream(zipFilePath);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            File dirToZip = new File(sourceDirPath);
            for (File childFile : children = dirToZip.listFiles()) {
                this.zipFileRec(childFile, childFile.getName(), zipOut);
            }
            zipOut.close();
            fos.close();
        }

        private void zipFileRec(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
            int length;
            if (fileToZip.isHidden()) {
                return;
            }
            if (fileToZip.isDirectory()) {
                File[] children;
                if (fileName.endsWith("/")) {
                    zipOut.putNextEntry(new ZipEntry(fileName));
                    zipOut.closeEntry();
                } else {
                    zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                    zipOut.closeEntry();
                }
                for (File childFile : children = fileToZip.listFiles()) {
                    this.zipFileRec(childFile, fileName + "/" + childFile.getName(), zipOut);
                }
                return;
            }
            FileInputStream fis = new FileInputStream(fileToZip);
            ZipEntry zipEntry = new ZipEntry(fileName);
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
            fis.close();
        }

        private void addUndo(int y, String action, String ruleId) throws Throwable {
            this.addUndo(0, y, action, ruleId);
        }

        private void addUndo(int x, int y, String action, String ruleId) throws Throwable {
            this.addUndo(x, y, action, ruleId, null);
        }

        private void addUndo(int y, String action, String ruleId, String word) throws Throwable {
            this.addUndo(0, y, action, ruleId, word, null, null);
        }

        private void addUndo(int x, int y, String action, String ruleId, Map<Integer, List<Integer>> orgParas) throws Throwable {
            this.addUndo(x, y, action, ruleId, null, orgParas, null);
        }

        private void addUndo(int y, String action, IgnoredMatches ignoredMatches) throws Throwable {
            this.addUndo(0, y, action, null, null, null, ignoredMatches);
        }

        private void addUndo(int x, int y, String action, String ruleId, String word, Map<Integer, List<Integer>> orgParas, IgnoredMatches ignoredMatches) throws Throwable {
            if (this.undoList.size() >= 50) {
                this.undoList.remove(0);
            }
            this.undoList.add(new UndoContainer(x, y, this.isSpellError, action, ruleId, word, orgParas, ignoredMatches));
        }

        private void addChangeUndo(int x, int y, String word, String replace, Map<Integer, List<Integer>> orgParas) throws Throwable {
            this.addUndo(x, y, "change", replace, word, orgParas, null);
        }

        private void addSingleChangeUndo(int x, int y, String word, String replace) throws Throwable {
            HashMap<Integer, List<Integer>> paraMap = new HashMap<Integer, List<Integer>>();
            ArrayList<Integer> xVals = new ArrayList<Integer>();
            xVals.add(x);
            paraMap.put(y, xVals);
            this.addChangeUndo(x, y, word, replace, paraMap);
        }

        private void addLanguageChangeUndo(int nFlat, int nStart, int nLen, String originalLanguage) throws Throwable {
            HashMap<Integer, List<Integer>> paraMap = new HashMap<Integer, List<Integer>>();
            ArrayList<Integer> xVals = new ArrayList<Integer>();
            xVals.add(nStart);
            xVals.add(nLen);
            paraMap.put(nFlat, xVals);
            this.addUndo(0, nFlat, "changeLanguage", originalLanguage, null, paraMap, null);
        }

        private void undo() throws Throwable {
            if (this.undoList == null || this.undoList.isEmpty()) {
                return;
            }
            try {
                this.removeMarkups();
                int nLastUndo = this.undoList.size() - 1;
                UndoContainer lastUndo = this.undoList.get(nLastUndo);
                String action = lastUndo.action;
                int xUndo = lastUndo.x;
                int yUndo = lastUndo.y;
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: Undo: Action: " + action);
                }
                if (action.equals("ignoreOnce")) {
                    this.currentDocument.removeIgnoredMatch(xUndo, yUndo, lastUndo.ruleId, true);
                } else if (action.equals("ignorePermanent")) {
                    this.currentDocument.removePermanentIgnoredMatch(xUndo, yUndo, lastUndo.ruleId, true);
                } else if (action.equals("resetIgnorePermanent")) {
                    this.currentDocument.setPermanentIgnoredMatches(lastUndo.ignoredMatches);
                } else if (action.equals("ignoreAll")) {
                    if (lastUndo.isSpellError) {
                        if (debugMode) {
                            MessageHandler.printToLogFile("CheckDialog: Undo: Ignored word removed: " + this.wrongWord);
                        }
                        LtDictionary.removeIgnoredWord(this.wrongWord, SpellAndGrammarCheckDialog.this.xContext);
                    } else {
                        Locale locale = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraphLocale(yUndo);
                        SpellAndGrammarCheckDialog.this.documents.removeDisabledRule(OfficeTools.localeToString(locale), lastUndo.ruleId);
                        SpellAndGrammarCheckDialog.this.documents.initDocuments(true);
                        SpellAndGrammarCheckDialog.this.documents.resetDocument();
                        SpellAndGrammarCheckDialog.this.doInit = true;
                    }
                } else if (action.equals("deactivateRule")) {
                    this.currentDocument.removeResultCache(yUndo, true);
                    Locale locale = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraphLocale(yUndo);
                    SpellAndGrammarCheckDialog.this.documents.deactivateRule(lastUndo.ruleId, OfficeTools.localeToString(locale), true);
                    SpellAndGrammarCheckDialog.this.doInit = true;
                } else if (action.equals("activateRule")) {
                    this.currentDocument.removeResultCache(yUndo, true);
                    Locale locale = SpellAndGrammarCheckDialog.this.docCache.getFlatParagraphLocale(yUndo);
                    SpellAndGrammarCheckDialog.this.documents.deactivateRule(lastUndo.ruleId, OfficeTools.localeToString(locale), false);
                    SpellAndGrammarCheckDialog.this.doInit = true;
                } else if (action.equals("addToDictionary")) {
                    LtDictionary.removeWordFromDictionary(lastUndo.ruleId, lastUndo.word, SpellAndGrammarCheckDialog.this.xContext);
                } else if (action.equals("changeLanguage")) {
                    Locale locale = this.getLocaleFromLanguageName(lastUndo.ruleId);
                    FlatParagraphTools flatPara = this.currentDocument.getFlatParagraphTools();
                    int nFlat = lastUndo.y;
                    int nStart = lastUndo.orgParas.get(nFlat).get(0);
                    int nLen = lastUndo.orgParas.get(nFlat).get(1);
                    if (debugMode) {
                        MessageHandler.printToLogFile("CheckDialog: Undo: Change Language: Locale: " + locale.Language + "-" + locale.Country + ", nFlat = " + nFlat + ", nStart = " + nStart + ", nLen = " + nLen);
                    }
                    if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.IMPRESS) {
                        OfficeDrawTools.setLanguageOfParagraph(nFlat, nStart, nLen, locale, this.currentDocument.getXComponent());
                    } else if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.CALC) {
                        OfficeSpreadsheetTools.setLanguageOfSpreadsheet(locale, this.currentDocument.getXComponent());
                    } else {
                        flatPara.setLanguageOfParagraph(nFlat, nStart, nLen, locale);
                    }
                    if (nLen == SpellAndGrammarCheckDialog.this.docCache.getFlatParagraph(nFlat).length()) {
                        SpellAndGrammarCheckDialog.this.docCache.setFlatParagraphLocale(nFlat, locale);
                        DocumentCache curDocCache = this.currentDocument.getDocumentCache();
                        if (curDocCache != null) {
                            curDocCache.setFlatParagraphLocale(nFlat, locale);
                        }
                    }
                    this.currentDocument.removeResultCache(nFlat, true);
                } else if (action.equals("change")) {
                    Map<Integer, List<Integer>> paras = lastUndo.orgParas;
                    short length = (short)lastUndo.ruleId.length();
                    for (int nFlat : paras.keySet()) {
                        int xStart;
                        int i;
                        List<Integer> xStarts = paras.get(nFlat);
                        DocumentCache.TextParagraph n = SpellAndGrammarCheckDialog.this.docCache.getNumberOfTextParagraph(nFlat);
                        if (debugMode) {
                            MessageHandler.printToLogFile("CheckDialog: Undo: Ignore change: nFlat = " + nFlat + ", n = (" + n.type + "," + n.number + "), x = " + xStarts.get(0));
                        }
                        if (SpellAndGrammarCheckDialog.this.docType != OfficeTools.DocumentType.WRITER) {
                            for (i = xStarts.size() - 1; i >= 0; --i) {
                                xStart = xStarts.get(i);
                                SpellAndGrammarCheckDialog.this.changeTextOfParagraph(nFlat, xStart, length, lastUndo.word, this.currentDocument, this.viewCursor);
                            }
                        } else {
                            for (i = xStarts.size() - 1; i >= 0; --i) {
                                xStart = xStarts.get(i);
                                SpellAndGrammarCheckDialog.this.changeTextOfParagraph(nFlat, xStart, length, lastUndo.word, this.currentDocument, this.viewCursor);
                            }
                        }
                        this.currentDocument.removeResultCache(nFlat, true);
                    }
                } else {
                    MessageHandler.showMessage("Undo '" + action + "' not supported");
                }
                this.undoList.remove(nLastUndo);
                this.setFlatViewCursor(xUndo, yUndo, null, this.viewCursor);
                if (debugMode) {
                    MessageHandler.printToLogFile("CheckDialog: Undo: yUndo = " + yUndo + ", xUndo = " + xUndo + ", lastPara = " + this.lastPara);
                }
                this.gotoNextError();
            }
            catch (Throwable e) {
                MessageHandler.showError(e);
                this.closeDialog();
            }
        }

        void setFlatViewCursor(int x, int y, SingleProofreadingError error, ViewCursorTools viewCursor) throws Throwable {
            this.x = x;
            this.y = y;
            if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.WRITER) {
                DocumentCache.TextParagraph para = SpellAndGrammarCheckDialog.this.docCache.getNumberOfTextParagraph(y);
                SpellAndGrammarCheckDialog.setTextViewCursor(x, para, viewCursor);
            } else if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.IMPRESS) {
                OfficeDrawTools.setCurrentPage(y, this.currentDocument.getXComponent());
                if (OfficeDrawTools.isParagraphInNotesPage(y, this.currentDocument.getXComponent())) {
                    OfficeTools.dispatchCmd(".uno:NotesMode", SpellAndGrammarCheckDialog.this.xContext);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        MessageHandler.printException(e);
                    }
                    this.dialog.toFront();
                }
                if (error != null) {
                    this.undoMarkup = new OfficeDrawTools.UndoMarkupContainer();
                    OfficeDrawTools.setMarkup(y, error, this.undoMarkup, this.currentDocument.getXComponent());
                }
            } else {
                OfficeSpreadsheetTools.setCurrentSheet(y, this.currentDocument.getXComponent());
            }
        }

        void removeMarkups() {
            if (SpellAndGrammarCheckDialog.this.docType == OfficeTools.DocumentType.IMPRESS && this.undoMarkup != null) {
                OfficeDrawTools.removeMarkup(this.undoMarkup, this.currentDocument.getXComponent());
                this.undoMarkup = null;
            }
        }
    }

    private class RuleIdentification {
        public String ruleId;
        public String ruleName;

        RuleIdentification(String ruleId, String ruleName) {
            this.ruleId = ruleId;
            this.ruleName = ruleName;
        }
    }

    private class CheckError {
        public Locale locale;
        public SingleProofreadingError error;

        CheckError(Locale locale, SingleProofreadingError error) {
            this.locale = locale;
            this.error = error;
        }
    }

    private class UndoContainer {
        public int x;
        public int y;
        public boolean isSpellError;
        public String action;
        public String ruleId;
        public String word;
        public Map<Integer, List<Integer>> orgParas;
        public IgnoredMatches ignoredMatches;

        UndoContainer(int x, int y, boolean isSpellError, String action, String ruleId, String word, Map<Integer, List<Integer>> orgParas, IgnoredMatches ignoredMatches) {
            this.x = x;
            this.y = y;
            this.isSpellError = isSpellError;
            this.action = action;
            this.ruleId = ruleId;
            this.orgParas = orgParas;
            this.word = word;
            this.ignoredMatches = ignoredMatches;
        }
    }
}

