/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.languagetool.gui.Configuration;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SwJLanguageTool;
import org.languagetool.rules.Rule;
import org.languagetool.rules.TextLevelRule;

class SortedTextRules {
    private static boolean debugMode = false;
    List<Integer> minToCheckParagraph = new ArrayList<Integer>(4);
    List<List<String>> textLevelRules = new ArrayList<List<String>>(4);

    SortedTextRules(SwJLanguageTool lt, Configuration config, Set<String> disabledRulesUI, boolean checkImpressDocument) {
        this.minToCheckParagraph.add(0, 0);
        this.minToCheckParagraph.add(1, 1);
        this.minToCheckParagraph.add(2, -1);
        this.minToCheckParagraph.add(3, -2);
        for (int i = 0; i < 4; ++i) {
            this.textLevelRules.add(i, new ArrayList());
            debugMode = OfficeTools.DEBUG_MODE_SR;
        }
        List<Rule> rules = checkImpressDocument ? lt.getAllActiveRules() : lt.getAllActiveOfficeRules();
        int numParasToCheck = config.getNumParasToCheck();
        for (Rule rule : rules) {
            if (!(rule instanceof TextLevelRule) || lt.getDisabledRules().contains(rule.getId()) || disabledRulesUI.contains(rule.getId())) continue;
            this.insertRule(((TextLevelRule)rule).minToCheckParagraph(), numParasToCheck, rule.getId());
        }
        if (debugMode) {
            MessageHandler.printToLogFile("SortedTextRules: Number different minToCheckParagraph: " + this.minToCheckParagraph.size());
            for (int i = 0; i < this.minToCheckParagraph.size(); ++i) {
                MessageHandler.printToLogFile("SortedTextRules: minToCheckParagraph: " + this.minToCheckParagraph.get(i));
                for (int j = 0; j < this.textLevelRules.get(i).size(); ++j) {
                    MessageHandler.printToLogFile("RuleId: " + this.textLevelRules.get(i).get(j));
                }
            }
        }
    }

    private void insertRule(int minPara, int numParasToCheck, String ruleId) {
        if (minPara == 0) {
            this.textLevelRules.get(0).add(ruleId);
        } else if (numParasToCheck >= 0) {
            this.textLevelRules.get(1).add(ruleId);
            if (minPara < 0 && this.minToCheckParagraph.get(1) < numParasToCheck) {
                this.minToCheckParagraph.set(1, numParasToCheck);
            } else if (minPara <= numParasToCheck && minPara > this.minToCheckParagraph.get(1)) {
                this.minToCheckParagraph.set(1, minPara);
            }
        } else if (minPara > 0) {
            this.textLevelRules.get(1).add(ruleId);
            if (minPara > this.minToCheckParagraph.get(1)) {
                this.minToCheckParagraph.set(1, minPara);
            }
        } else if (minPara == -2 && numParasToCheck == -2) {
            this.textLevelRules.get(3).add(ruleId);
        } else {
            this.textLevelRules.get(2).add(ruleId);
        }
    }

    public List<Integer> getMinToCheckParas() {
        return this.minToCheckParagraph;
    }

    public void activateTextRulesByIndex(int nCache, SwJLanguageTool lt) {
        for (int i = 0; i < this.textLevelRules.size(); ++i) {
            if (i == nCache) {
                for (String ruleId : this.textLevelRules.get(i)) {
                    lt.enableRule(ruleId);
                }
                continue;
            }
            for (String ruleId : this.textLevelRules.get(i)) {
                lt.disableRule(ruleId);
            }
        }
    }

    public void reactivateTextRules(SwJLanguageTool lt) {
        for (List<String> textRules : this.textLevelRules) {
            for (String ruleId : textRules) {
                lt.enableRule(ruleId);
            }
        }
    }
}

