/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.awt.MouseEvent;
import com.sun.star.awt.XMouseClickHandler;
import com.sun.star.awt.XUserInputInterception;
import com.sun.star.beans.PropertyValue;
import com.sun.star.document.DocumentEvent;
import com.sun.star.document.XDocumentEventBroadcaster;
import com.sun.star.document.XDocumentEventListener;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.linguistic2.ProofreadingResult;
import com.sun.star.linguistic2.SingleProofreadingError;
import com.sun.star.text.XFlatParagraph;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.openoffice.CacheIO;
import org.languagetool.openoffice.CheckRequestAnalysis;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.DocumentCursorTools;
import org.languagetool.openoffice.ErrorPositionComparator;
import org.languagetool.openoffice.FlatParagraphTools;
import org.languagetool.openoffice.IgnoredMatches;
import org.languagetool.openoffice.LinguisticServices;
import org.languagetool.openoffice.LtMenus;
import org.languagetool.openoffice.LtSpellChecker;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.ResultCache;
import org.languagetool.openoffice.SingleCheck;
import org.languagetool.openoffice.SwJLanguageTool;
import org.languagetool.openoffice.TextLevelCheckQueue;
import org.languagetool.openoffice.ViewCursorTools;

public class SingleDocument {
    private static int debugMode;
    private static boolean debugModeTm;
    private Configuration config;
    private int numParasToCheck = 0;
    private XComponentContext xContext;
    private String docID;
    private XComponent xComponent;
    private final MultiDocumentsHandler mDocHandler;
    private LTDokumentEventListener eventListener = null;
    private final DocumentCache docCache;
    private final List<ResultCache> paragraphsCache;
    private final Map<Integer, String> changedParas;
    private final Set<Integer> runningParas;
    private DocumentCursorTools docCursor = null;
    private FlatParagraphTools flatPara = null;
    private Integer numLastVCPara = 0;
    private final List<Integer> numLastFlPara = new ArrayList<Integer>();
    private CacheIO cacheIO;
    private int changeFrom = 0;
    private int changeTo = 0;
    private int paraNum;
    private int lastChangedPara;
    private List<Integer> lastChangedParas;
    private IgnoredMatches ignoredMatches;
    private IgnoredMatches permanentIgnoredMatches;
    private final OfficeTools.DocumentType docType;
    private boolean disposed = false;
    private boolean resetDocCache = false;
    private boolean hasFootnotes = true;
    private boolean hasSortedTextId = true;
    private boolean isLastIntern = false;
    private boolean isRightButtonPressed = false;
    private boolean isOnUnload = false;
    private String lastSinglePara = null;
    private Language docLanguage;
    private Locale docLocale;
    private final Language fixedLanguage;
    private LtMenus ltMenus = null;
    private ResultCache statAnCache = null;
    private String statAnRuleId = null;

    SingleDocument(XComponentContext xContext, Configuration config, String docID, XComponent xComp, MultiDocumentsHandler mDH, Language lang) {
        for (int i = 0; i < 7; ++i) {
            this.numLastFlPara.add(-1);
        }
        debugMode = OfficeTools.DEBUG_MODE_SD;
        debugModeTm = OfficeTools.DEBUG_MODE_TM;
        if (OfficeTools.DEVELOP_MODE_ST) {
            this.hasSortedTextId = false;
        }
        this.xContext = xContext;
        this.config = config;
        this.docID = docID;
        this.docLanguage = lang;
        this.docLocale = LinguisticServices.getLocale(lang);
        this.docType = docID.charAt(0) == 'I' ? OfficeTools.DocumentType.IMPRESS : (docID.charAt(0) == 'C' ? OfficeTools.DocumentType.CALC : OfficeTools.DocumentType.WRITER);
        this.xComponent = xComp;
        this.mDocHandler = mDH;
        this.fixedLanguage = config == null ? null : config.getDefaultLanguage();
        this.changedParas = new HashMap<Integer, String>();
        this.runningParas = new HashSet<Integer>();
        this.setDokumentListener(this.xComponent);
        ArrayList<ResultCache> paraCache = new ArrayList<ResultCache>();
        for (int i = 0; i < 4; ++i) {
            paraCache.add(new ResultCache());
        }
        this.paragraphsCache = Collections.unmodifiableList(paraCache);
        if (config != null) {
            this.setConfigValues(config);
        }
        this.resetResultCache(true);
        this.ignoredMatches = new IgnoredMatches();
        this.permanentIgnoredMatches = new IgnoredMatches();
        this.docCache = new DocumentCache(this.docType);
        if (config != null && config.saveLoCache() && !config.noBackgroundCheck() && this.xComponent != null && !this.mDocHandler.isTestMode()) {
            this.readCaches();
        }
        if (this.xComponent != null) {
            this.setFlatParagraphTools();
        }
        if (!this.mDocHandler.isOpenOffice && (this.docType == OfficeTools.DocumentType.IMPRESS || mDH.isBackgroundCheckOff() && this.docType == OfficeTools.DocumentType.WRITER) && this.ltMenus == null) {
            this.ltMenus = new LtMenus(xContext, this, config);
        }
    }

    ProofreadingResult getCheckResults(String paraText, Locale locale, ProofreadingResult paRes, PropertyValue[] propertyValues, boolean docReset, SwJLanguageTool lt, OfficeTools.LoErrorType errType) {
        return this.getCheckResults(paraText, locale, paRes, propertyValues, docReset, lt, -1, errType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProofreadingResult getCheckResults(String paraText, Locale locale, ProofreadingResult paRes, PropertyValue[] propertyValues, boolean docReset, SwJLanguageTool lt, int nPara, OfficeTools.LoErrorType errType) {
        try {
            long runTime;
            long runTime2;
            int paraNum;
            boolean isIntern = nPara >= 0;
            boolean isMouseRequest = false;
            if (this.isRightButtonPressed) {
                isMouseRequest = true;
                this.isRightButtonPressed = false;
            }
            int[] footnotePositions = null;
            int proofInfo = 0;
            int sortedTextId = -1;
            int documentElementsCount = -1;
            for (PropertyValue propertyValue : propertyValues) {
                if ("FootnotePositions".equals(propertyValue.Name)) {
                    if (propertyValue.Value instanceof int[]) {
                        footnotePositions = (int[])propertyValue.Value;
                    } else {
                        MessageHandler.printToLogFile("SingleDocument: getCheckResults: Not of expected type int[]: " + propertyValue.Name + ": " + propertyValue.Value.getClass());
                    }
                }
                if ("ProofInfo".equals(propertyValue.Name)) {
                    if (propertyValue.Value instanceof Integer) {
                        proofInfo = (Integer)propertyValue.Value;
                    } else {
                        MessageHandler.printToLogFile("SingleDocument: getCheckResults: Not of expected type int: " + propertyValue.Name + ": " + propertyValue.Value.getClass());
                    }
                }
                if (isIntern || !this.hasSortedTextId) continue;
                if ("SortedTextId".equals(propertyValue.Name)) {
                    if (propertyValue.Value instanceof Integer) {
                        sortedTextId = (Integer)propertyValue.Value;
                    } else {
                        MessageHandler.printToLogFile("SingleDocument: getCheckResults: Not of expected type int: " + propertyValue.Name + ": " + propertyValue.Value.getClass());
                    }
                }
                if (!"DocumentElementsCount".equals(propertyValue.Name)) continue;
                if (propertyValue.Value instanceof Integer) {
                    documentElementsCount = (Integer)propertyValue.Value;
                    continue;
                }
                MessageHandler.printToLogFile("SingleDocument: getCheckResults: Not of expected type int: " + propertyValue.Name + ": " + propertyValue.Value.getClass());
            }
            if (!isIntern && this.hasSortedTextId && sortedTextId < 0) {
                this.hasSortedTextId = false;
                MessageHandler.printToLogFile("SingleDocument: getCheckResults: SortedTextId and DocumentElementsCount are not supported by LO!");
            }
            if (debugMode > 0 && this.hasSortedTextId) {
                MessageHandler.printToLogFile("SingleDocument: getCheckResults: sortedTextId: " + sortedTextId);
                MessageHandler.printToLogFile("SingleDocument: getCheckResults: documentElementsCount: " + documentElementsCount);
            }
            boolean bl = this.hasFootnotes = footnotePositions != null;
            if (!this.hasFootnotes) {
                if (this.numParasToCheck != 0) {
                    if (this.config.useTextLevelQueue()) {
                        this.mDocHandler.getTextLevelCheckQueue().setStop();
                    }
                    this.numParasToCheck = 0;
                    this.config.setNumParasToCheck(this.numParasToCheck);
                    this.config.setUseTextLevelQueue(false);
                    try {
                        this.config.saveConfiguration(this.docLanguage);
                    }
                    catch (IOException e) {
                        MessageHandler.showError(e);
                    }
                    MessageHandler.printToLogFile("Single paragraph check mode set!");
                }
                this.mDocHandler.setUseOriginalCheckDialog();
            }
            if (proofInfo == 1) {
                int nFPara = -1;
                if (this.hasSortedTextId) {
                    nFPara = this.docCache.getFlatparagraphFromSortedTextId(sortedTextId);
                    if (debugMode > 0) {
                        MessageHandler.printToLogFile("SingleDocument: getCheckResults: get errors direct from cache, nFPara: " + nFPara);
                    }
                    if (nFPara >= 0) {
                        ProofreadingResult proofreadingResult = this.getErrorsFromCache(nFPara, paRes, paraText, locale, lt);
                        return proofreadingResult;
                    }
                }
                if (DocumentCursorTools.isBusy() || ViewCursorTools.isBusy() || FlatParagraphTools.isBusy() || this.docCache.isResetRunning()) {
                    SingleCheck singleCheck = new SingleCheck(this, this.paragraphsCache, this.fixedLanguage, this.docLanguage, this.numParasToCheck, true, isMouseRequest, false);
                    paRes.aErrors = singleCheck.checkParaRules(paraText, locale, footnotePositions, -1, paRes.nStartOfSentencePosition, lt, 0, 0, false, false, errType);
                    this.closeDocumentCursor();
                    ProofreadingResult proofreadingResult = paRes;
                    return proofreadingResult;
                }
            }
            if (debugMode > 0 && proofInfo == 1) {
                MessageHandler.printToLogFile("SingleDocument: getCheckResults: start PROOFRESULT");
            }
            if (this.resetDocCache) {
                if (debugMode > 0 && proofInfo == 1) {
                    MessageHandler.printToLogFile("SingleDocument: getCheckResults: is resetDocCache");
                }
                if (this.docCursor == null) {
                    if (debugMode > 0 && proofInfo == 1) {
                        MessageHandler.printToLogFile("SingleDocument: getCheckResults: get docCursor");
                    }
                    this.docCursor = this.getDocumentCursorTools();
                }
                if (debugMode > 0 && proofInfo == 1) {
                    MessageHandler.printToLogFile("SingleDocument: getCheckResults: refresh docCache");
                }
                this.docCache.refresh(this, LinguisticServices.getLocale(this.fixedLanguage), LinguisticServices.getLocale(this.docLanguage), this.xComponent, 6);
                this.resetDocCache = false;
            }
            if (this.docLanguage == null) {
                this.docLanguage = lt.getLanguage();
            }
            if (this.disposed) {
                this.closeDocumentCursor();
                ProofreadingResult nFPara = paRes;
                return nFPara;
            }
            if (docReset) {
                this.numLastVCPara = 0;
                this.ignoredMatches = new IgnoredMatches();
            }
            boolean isDialogRequest = nPara >= 0 || proofInfo == 1;
            CheckRequestAnalysis requestAnalysis = null;
            long startTime = 0L;
            if (debugModeTm) {
                startTime = System.currentTimeMillis();
            }
            if (this.hasSortedTextId) {
                if (isIntern) {
                    paraNum = nPara;
                } else {
                    requestAnalysis = new CheckRequestAnalysis(this.numLastVCPara, this.numLastFlPara, proofInfo, this.numParasToCheck, this.fixedLanguage, this.docLanguage, this, this.paragraphsCache, this.changedParas, this.runningParas);
                    paraNum = requestAnalysis.getNumberOfParagraphFromSortedTextId(sortedTextId, documentElementsCount, paraText, locale, footnotePositions);
                }
            } else {
                requestAnalysis = new CheckRequestAnalysis(this.numLastVCPara, this.numLastFlPara, proofInfo, this.numParasToCheck, this.fixedLanguage, this.docLanguage, this, this.paragraphsCache, this.changedParas, this.runningParas);
                paraNum = requestAnalysis.getNumberOfParagraph(nPara, paraText, locale, paRes.nStartOfSentencePosition, footnotePositions);
            }
            if (this.docCache.isAutomaticGenerated(paraNum, true)) {
                ProofreadingResult proofreadingResult = paRes;
                return proofreadingResult;
            }
            if (debugModeTm && (runTime2 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Single document: Time to run request analyses: " + runTime2);
            }
            if (debugMode > 1) {
                MessageHandler.printToLogFile("Single document: getCheckResults: paraNum = " + paraNum + ", nPara = " + nPara);
            }
            if (paraNum == -2) {
                int n = paraNum = this.isLastIntern ? this.paraNum : -1;
                if (debugMode > 1) {
                    MessageHandler.printToLogFile("Single document: getCheckResults: paraNum set to: " + paraNum + ", isLastIntern = " + this.isLastIntern);
                }
            }
            this.paraNum = paraNum;
            this.runningParas.add(paraNum);
            this.isLastIntern = isIntern;
            boolean textIsChanged = false;
            if (!isIntern && requestAnalysis != null) {
                this.changeFrom = requestAnalysis.getFirstParagraphToChange();
                this.changeTo = requestAnalysis.getLastParagraphToChange();
                this.numLastVCPara = requestAnalysis.getLastParaNumFromViewCursor();
                textIsChanged = requestAnalysis.textIsChanged();
            }
            if (this.disposed) {
                this.closeDocumentCursor();
                ProofreadingResult proofreadingResult = paRes;
                return proofreadingResult;
            }
            if (debugModeTm) {
                startTime = System.currentTimeMillis();
            }
            SingleCheck singleCheck = new SingleCheck(this, this.paragraphsCache, this.fixedLanguage, this.docLanguage, this.numParasToCheck, isDialogRequest, isMouseRequest, isIntern);
            paRes.aErrors = singleCheck.getCheckResults(paraText, footnotePositions, locale, lt, paraNum, paRes.nStartOfSentencePosition, textIsChanged, this.changeFrom, this.changeTo, this.lastSinglePara, this.lastChangedPara, errType);
            this.lastSinglePara = singleCheck.getLastSingleParagraph();
            paRes.nStartOfSentencePosition = this.paragraphsCache.get(0).getStartSentencePosition(paraNum, paRes.nStartOfSentencePosition);
            paRes.nStartOfNextSentencePosition = this.paragraphsCache.get(0).getNextSentencePosition(paraNum, paRes.nStartOfSentencePosition);
            if (paRes.nStartOfNextSentencePosition == 0) {
                paRes.nStartOfNextSentencePosition = paraText.length();
            }
            paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition;
            int n = this.lastChangedPara = textIsChanged && this.numParasToCheck != 0 ? paraNum : -1;
            if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Single document: Time to run single check: " + runTime);
            }
            if (proofInfo == 1 || isIntern) {
                this.addStatAnalysisErrors(paRes, paraNum);
                if (debugModeTm) {
                    startTime = System.currentTimeMillis();
                }
                this.addSynonyms(paRes, paraText, locale, lt);
                if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                    MessageHandler.printToLogFile("Single document: Time to addSynonyms: " + runTime);
                }
            }
            if (textIsChanged && this.numParasToCheck != 0 && this.config.useTextLevelQueue() && !isDialogRequest && this.mDocHandler.getTextLevelCheckQueue() != null && !this.mDocHandler.isTestMode()) {
                this.mDocHandler.getTextLevelCheckQueue().wakeupQueue(this.docID);
            }
            if (this.ltMenus == null && !this.mDocHandler.isOpenOffice && this.docType == OfficeTools.DocumentType.WRITER && paraText.length() > 0) {
                this.ltMenus = new LtMenus(this.xContext, this, this.config);
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        finally {
            this.runningParas.remove(this.paraNum);
        }
        this.closeDocumentCursor();
        return paRes;
    }

    void setConfigValues(Configuration config) {
        this.config = config;
        int n = this.numParasToCheck = this.mDocHandler.isTestMode() || this.mDocHandler.heapLimitIsReached() ? 0 : config.getNumParasToCheck();
        if (this.ltMenus != null) {
            this.ltMenus.setConfigValues(config);
        }
        if (config.noBackgroundCheck() || this.numParasToCheck == 0) {
            this.setFlatParagraphTools();
        }
    }

    void setDocumentCacheForTests(List<String> paragraphs, List<List<String>> textParagraphs, List<int[]> footnotes, List<List<Integer>> chapterBegins, Locale locale) {
        try {
            this.docCache.setForTest(paragraphs, textParagraphs, footnotes, chapterBegins, locale);
            this.numParasToCheck = -1;
            this.mDocHandler.resetSortedTextRules(this.mDocHandler.getLanguageTool());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    LtMenus getLtMenu() {
        return this.ltMenus;
    }

    void dispose(boolean disposed) {
        this.disposed = disposed;
        if (disposed) {
            if (this.docCursor != null) {
                this.docCursor.setDisposed();
            }
            if (this.flatPara != null) {
                this.flatPara.setDisposed();
            }
            if (this.ltMenus != null) {
                this.ltMenus.removeListener();
                this.ltMenus = null;
            }
        }
    }

    OfficeTools.DocumentType getDocumentType() {
        return this.docType;
    }

    boolean isDisposed() {
        return this.disposed;
    }

    boolean isRunning(int nFPara) {
        return this.runningParas.contains(nFPara);
    }

    void setMenuDocId() {
        this.mDocHandler.setMenuDocId(this.getDocID());
    }

    int getCurrentNumberOfParagraph() {
        return this.paraNum;
    }

    public Language getLanguage() {
        Locale locale = this.docCache.getDocumentLocale();
        if (locale == null) {
            return this.docLanguage;
        }
        Language lang = MultiDocumentsHandler.getLanguage(locale);
        if (lang != null && !lang.equals(this.docLanguage)) {
            this.docLanguage = lang;
        }
        return this.docLanguage;
    }

    void setLanguage(Language language) {
        this.docLanguage = language;
        this.docLocale = LinguisticServices.getLocale(language);
    }

    void setXComponent(XComponentContext xContext, XComponent xComponent) {
        this.xContext = xContext;
        this.xComponent = xComponent;
        if (xComponent == null) {
            this.closeDocumentCursor();
        } else {
            this.setDokumentListener(xComponent);
        }
    }

    public XComponent getXComponent() {
        return this.xComponent;
    }

    public MultiDocumentsHandler getMultiDocumentsHandler() {
        return this.mDocHandler;
    }

    String getDocID() {
        return this.docID;
    }

    void setDocID(String docId) {
        this.docID = docId;
    }

    public void setStatAnCache(ResultCache cache) {
        this.statAnCache = cache;
    }

    public void setStatAnRuleId(String ruleId) {
        this.statAnRuleId = ruleId;
    }

    public FlatParagraphTools getFlatParagraphTools() {
        if (this.flatPara == null) {
            this.setFlatParagraphTools();
        }
        return this.flatPara;
    }

    public DocumentCursorTools getDocumentCursorTools() {
        OfficeTools.waitForLO();
        if (this.docCursor == null) {
            this.docCursor = new DocumentCursorTools(this.xComponent);
        }
        return this.docCursor;
    }

    public List<ResultCache> getParagraphsCache() {
        return this.paragraphsCache;
    }

    public DocumentCache getDocumentCache() {
        return this.docCache;
    }

    void resetDocumentCache() {
        this.resetDocCache = true;
    }

    void setLastChangedParas(List<Integer> lastChangedParas) {
        this.lastChangedParas = lastChangedParas;
    }

    List<Integer> getLastChangedParas() {
        return this.lastChangedParas;
    }

    Map<Integer, String> getChangedParasMap() {
        return this.changedParas;
    }

    void resetDocument() {
        this.mDocHandler.resetDocument();
    }

    void readCaches() {
        if (this.numParasToCheck != 0 && this.docType != OfficeTools.DocumentType.CALC) {
            this.cacheIO = new CacheIO(this.xComponent);
            boolean cacheExist = this.cacheIO.readAllCaches(this.config, this.mDocHandler);
            if (cacheExist) {
                this.docCache.put(this.cacheIO.getDocumentCache());
                for (int i = 0; i < this.cacheIO.getParagraphsCache().size(); ++i) {
                    this.paragraphsCache.get(i).replace(this.cacheIO.getParagraphsCache().get(i));
                }
                this.permanentIgnoredMatches = new IgnoredMatches(this.cacheIO.getIgnoredMatches());
                if (this.docType == OfficeTools.DocumentType.WRITER && this.mDocHandler != null) {
                    this.mDocHandler.runShapeCheck(this.docCache.hasUnsupportedText(), 9);
                }
            }
            this.cacheIO.resetAllCache();
        }
    }

    void writeCaches() {
        try {
            if (this.numParasToCheck != 0 && !this.config.noBackgroundCheck() && this.docType != OfficeTools.DocumentType.CALC) {
                if (debugMode > 0) {
                    MessageHandler.printToLogFile("SingleDocument: writeCaches: Copy DocumentCache");
                }
                DocumentCache docCache = new DocumentCache(this.docCache);
                ArrayList<ResultCache> paragraphsCache = new ArrayList<ResultCache>();
                for (int i = 0; i < this.paragraphsCache.size(); ++i) {
                    if (debugMode > 0) {
                        MessageHandler.printToLogFile("SingleDocument: writeCaches: Copy ResultCache " + i);
                    }
                    paragraphsCache.add(new ResultCache(this.paragraphsCache.get(i)));
                }
                MessageHandler.printToLogFile("SingleDocument: writeCaches: Save Caches ...");
                this.cacheIO.saveCaches(docCache, paragraphsCache, this.permanentIgnoredMatches, this.config, this.mDocHandler);
                CacheIO.SpellCache sc = new CacheIO.SpellCache(this.cacheIO);
                sc.write(LtSpellChecker.getWrongWords(), LtSpellChecker.getSuggestions());
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    void resetResultCache(boolean withSingleParagraph) {
        int i;
        int n = i = withSingleParagraph ? 0 : 1;
        while (i < 4) {
            this.paragraphsCache.get(i).removeAll();
            ++i;
        }
    }

    public void removeResultCache(int nPara, boolean alsoParaLevel) {
        if (!this.isDisposed()) {
            if (alsoParaLevel) {
                this.paragraphsCache.get(0).remove(nPara);
            }
            if (!this.docCache.setSingleParagraphsCacheToNull(nPara, this.paragraphsCache)) {
                for (int i = 1; i < this.paragraphsCache.size(); ++i) {
                    this.paragraphsCache.get(i).remove(nPara);
                }
            }
        }
    }

    public void removeRuleError(String ruleId) {
        ArrayList<Integer> allChanged = new ArrayList<Integer>();
        for (ResultCache cache : this.paragraphsCache) {
            List<Integer> changed = cache.removeRuleError(ruleId);
            if (changed.size() <= 0) continue;
            for (int n : changed) {
                if (allChanged.contains(n)) continue;
                allChanged.add(n);
            }
        }
        if (allChanged.size() > 0) {
            allChanged.sort(null);
            this.remarkChangedParagraphs(allChanged, allChanged, true);
        }
    }

    public FlatParagraphTools setFlatParagraphTools() {
        try {
            if (this.disposed) {
                this.flatPara = null;
                return this.flatPara;
            }
            OfficeTools.waitForLO();
            if (this.flatPara == null) {
                this.flatPara = new FlatParagraphTools(this.xComponent);
                if (!this.flatPara.isValid()) {
                    this.flatPara = null;
                }
            } else {
                this.flatPara.init();
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return this.flatPara;
    }

    private void closeDocumentCursor() {
        if (this.docCursor != null) {
            this.docCursor = null;
        }
    }

    public void addQueueEntry(int nFPara, int nCache, int nCheck, String docId, boolean overrideRunning) {
        if (!(this.disposed || this.mDocHandler.getTextLevelCheckQueue() == null || !this.mDocHandler.isSortedRuleForIndex(nCache) || this.docCache == null || nCache != 0 && this.docCache.isSingleParagraph(nFPara))) {
            boolean checkOnlyParagraph = this.docCache.isSingleParagraph(nFPara);
            if (nCache > 0 && checkOnlyParagraph) {
                return;
            }
            DocumentCache.TextParagraph nTPara = this.docCache.getNumberOfTextParagraph(nFPara);
            if (nTPara != null && nTPara.type != -1) {
                int nEnd;
                int nStart;
                if (checkOnlyParagraph) {
                    nStart = nTPara.number;
                    nEnd = nTPara.number + 1;
                } else {
                    nStart = this.docCache.getStartOfParaCheck(nTPara, nCheck, checkOnlyParagraph, true, false);
                    nEnd = this.docCache.getEndOfParaCheck(nTPara, nCheck, checkOnlyParagraph, true, false);
                }
                this.mDocHandler.getTextLevelCheckQueue().addQueueEntry(this.docCache.createTextParagraph(nTPara.type, nStart), this.docCache.createTextParagraph(nTPara.type, nEnd), nCache, nCheck, docId, overrideRunning);
            }
        }
    }

    TextLevelCheckQueue.QueueEntry createQueueEntry(DocumentCache.TextParagraph nPara, int nCache) {
        int nCheck = this.mDocHandler.getNumMinToCheckParas().get(nCache);
        int nStart = this.docCache.getStartOfParaCheck(nPara, nCheck, false, true, false);
        int nEnd = this.docCache.getEndOfParaCheck(nPara, nCheck, false, true, false);
        if (!(nCheck <= 0 || nStart + 1 >= nEnd || nStart != nPara.number && nPara.number != 0 && this.paragraphsCache.get(nCache).getCacheEntry(this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(nPara.type, nPara.number - 1))) == null || nEnd != nPara.number && nPara.number != this.docCache.textSize(nPara) - 1 && this.paragraphsCache.get(nCache).getCacheEntry(this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(nPara.type, nPara.number + 1))) == null)) {
            nStart = nPara.number;
            nEnd = nStart + 1;
        }
        return this.mDocHandler.getTextLevelCheckQueue().createQueueEntry(this.docCache.createTextParagraph(nPara.type, nStart), this.docCache.createTextParagraph(nPara.type, nEnd), nCache, nCheck, this.docID, false);
    }

    public TextLevelCheckQueue.QueueEntry getNextQueueEntry(DocumentCache.TextParagraph nPara) {
        if (!this.disposed && this.docCache != null) {
            int nCache;
            int nStart;
            int i;
            if (nPara != null && nPara.type != -1 && nPara.number < this.docCache.textSize(nPara) && !this.docCache.isSingleParagraph(this.docCache.getFlatParagraphNumber(nPara))) {
                for (int nCache2 = 1; nCache2 < this.paragraphsCache.size(); ++nCache2) {
                    if (!this.mDocHandler.isSortedRuleForIndex(nCache2) || !this.docCache.isFinished() || this.paragraphsCache.get(nCache2).getCacheEntry(this.docCache.getFlatParagraphNumber(nPara)) != null || this.docCache.isSingleParagraph(this.docCache.getFlatParagraphNumber(nPara))) continue;
                    return this.createQueueEntry(nPara, nCache2);
                }
            }
            for (i = nStart = nPara == null || nPara.type == -1 || nPara.number < this.docCache.textSize(nPara) ? 0 : this.docCache.getFlatParagraphNumber(nPara); i < this.docCache.size(); ++i) {
                if (this.docCache.getNumberOfTextParagraph((int)i).type == -1 || this.docCache.isSingleParagraph(i)) continue;
                for (nCache = 1; nCache < this.paragraphsCache.size(); ++nCache) {
                    if (!this.mDocHandler.isSortedRuleForIndex(nCache) || !this.docCache.isFinished() || this.paragraphsCache.get(nCache).getCacheEntry(i) != null || this.docCache.isSingleParagraph(i)) continue;
                    return this.createQueueEntry(this.docCache.getNumberOfTextParagraph(i), nCache);
                }
            }
            for (i = 0; i < nStart && i < this.docCache.size(); ++i) {
                if (this.docCache.getNumberOfTextParagraph((int)i).type == -1 || this.docCache.isSingleParagraph(i)) continue;
                for (nCache = 1; nCache < this.paragraphsCache.size(); ++nCache) {
                    if (!this.mDocHandler.isSortedRuleForIndex(nCache) || !this.docCache.isFinished() || this.paragraphsCache.get(nCache).getCacheEntry(i) != null || this.docCache.isSingleParagraph(i)) continue;
                    return this.createQueueEntry(this.docCache.getNumberOfTextParagraph(i), nCache);
                }
            }
        }
        return null;
    }

    public TextLevelCheckQueue.QueueEntry getQueueEntryForChangedParagraph() {
        if (!this.disposed && this.docCache != null && this.flatPara != null && !this.changedParas.isEmpty()) {
            HashSet<Integer> nParas = new HashSet<Integer>(this.changedParas.keySet());
            if (!nParas.isEmpty()) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    MessageHandler.printException(e);
                }
            }
            Iterator iterator = nParas.iterator();
            while (iterator.hasNext()) {
                String sPara;
                int nPara = (Integer)iterator.next();
                OfficeTools.waitForLO();
                XFlatParagraph xFlatParagraph = this.flatPara.getFlatParagraphAt(nPara);
                if (xFlatParagraph == null || (sPara = xFlatParagraph.getText()) == null) continue;
                if (!this.isRunning(nPara)) {
                    String sChangedPara = this.changedParas.get(nPara);
                    if (sChangedPara != null && (!sChangedPara.equals(sPara) || this.mDocHandler.useAnalyzedSentencesCache() && !this.docCache.isCorrectAnalyzedParagraphLength(nPara, sPara))) {
                        this.docCache.setFlatParagraph(nPara, sPara);
                        for (int i = 1; i < this.mDocHandler.getNumMinToCheckParas().size(); ++i) {
                            this.addQueueEntry(nPara, i, this.mDocHandler.getNumMinToCheckParas().get(i), this.docID, false);
                        }
                        if (!this.changedParas.isEmpty()) {
                            this.addQueueEntry(nPara, 0, 0, this.docID, false);
                            continue;
                        }
                        return this.createQueueEntry(this.docCache.getNumberOfTextParagraph(nPara), 0);
                    }
                    this.changedParas.remove(nPara);
                    ArrayList<Integer> changedParas = new ArrayList<Integer>();
                    if (nPara > 0) {
                        changedParas.add(nPara - 1);
                    }
                    if (nPara < this.docCache.size() - 1) {
                        changedParas.add(nPara + 1);
                    }
                    this.remarkChangedParagraphs(changedParas, changedParas, false);
                    continue;
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    MessageHandler.printException(e);
                }
            }
        }
        return null;
    }

    public void addShapeQueueEntries() {
        int shapeTextSize = this.docCache.textSize(3) + this.docCache.textSize(5);
        if (shapeTextSize > 0) {
            List<Integer> changedParas;
            if (this.docCursor == null) {
                this.docCursor = this.getDocumentCursorTools();
            }
            if ((changedParas = this.docCache.getChangedUnsupportedParagraphs(this.docCursor, this.paragraphsCache.get(0))) != null) {
                for (int i = 0; i < changedParas.size(); ++i) {
                    for (int nCache = 0; nCache < this.paragraphsCache.size(); ++nCache) {
                        int nCheck = this.mDocHandler.getNumMinToCheckParas().get(nCache);
                        this.addQueueEntry(changedParas.get(i), nCache, nCheck, this.docID, true);
                    }
                }
            }
        }
    }

    public void runQueueEntry(DocumentCache.TextParagraph nStart, DocumentCache.TextParagraph nEnd, int cacheNum, int nCheck, boolean override, SwJLanguageTool lt) throws Throwable {
        if (!this.disposed && this.flatPara != null && this.docCache.isFinished() && nStart.number < this.docCache.textSize(nStart)) {
            SingleCheck singleCheck = new SingleCheck(this, this.paragraphsCache, this.fixedLanguage, this.docLanguage, this.numParasToCheck, false, false, false);
            singleCheck.addParaErrorsToCache(this.docCache.getFlatParagraphNumber(nStart), lt, cacheNum, nCheck, nEnd.number == nStart.number + 1, override, false, this.hasFootnotes);
            this.closeDocumentCursor();
        }
    }

    public void remarkChangedParagraphs(List<Integer> changedParas, List<Integer> toRemarkParas, boolean isIntern) {
        if (!this.disposed) {
            SingleCheck singleCheck = new SingleCheck(this, this.paragraphsCache, this.fixedLanguage, this.docLanguage, this.numParasToCheck, false, false, isIntern);
            singleCheck.remarkChangedParagraphs(changedParas, toRemarkParas, this.mDocHandler.getLanguageTool());
            this.closeDocumentCursor();
        }
    }

    public void renewMarkups() {
        if (this.disposed) {
            return;
        }
        ViewCursorTools viewCursor = new ViewCursorTools(this.xComponent);
        int y = this.docCache.getFlatParagraphNumber(viewCursor.getViewCursorParagraph());
        if (debugMode > 0) {
            MessageHandler.printToLogFile("SingleDocument: renewMarkups: Number of Flat Paragraph = " + y);
        }
        ArrayList<Integer> changedParas = new ArrayList<Integer>();
        changedParas.add(y);
        this.remarkChangedParagraphs(changedParas, changedParas, false);
    }

    public boolean isIgnoreOnce(int xFrom, int xTo, int y, String ruleId) {
        return this.ignoredMatches.isIgnored(xFrom, xTo, y, ruleId);
    }

    public void resetIgnoreOnce() {
        this.ignoredMatches = new IgnoredMatches();
    }

    public String ignoreOnce() {
        if (this.disposed) {
            return null;
        }
        ViewCursorTools viewCursor = new ViewCursorTools(this.xComponent);
        int y = this.docCache.getFlatParagraphNumber(viewCursor.getViewCursorParagraph());
        int x = viewCursor.getViewCursorCharacter();
        SingleProofreadingError error = this.getErrorFromCache(y, x);
        this.setIgnoredMatch(x, y, error.aRuleIdentifier, false);
        return this.docID;
    }

    public void setIgnoredMatch(int x, int y, String ruleId, boolean isIntern) {
        this.ignoredMatches.setIgnoredMatch(x, y, 0, ruleId, null, null);
        if (debugMode > 1) {
            MessageHandler.printToLogFile("SingleDocument: setIgnoredMatch: DocumentType = " + (Object)((Object)this.docType) + "; numParasToCheck = " + this.numParasToCheck);
        }
        if (this.docType == OfficeTools.DocumentType.WRITER && this.numParasToCheck != 0) {
            ArrayList<Integer> changedParas = new ArrayList<Integer>();
            changedParas.add(y);
            this.remarkChangedParagraphs(changedParas, changedParas, isIntern);
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("SingleDocument: setIgnoredMatch: Ignore Match added at: paragraph: " + y + "; character: " + x + "; ruleId: " + ruleId);
        }
    }

    public void resetIgnorePermanent() {
        this.permanentIgnoredMatches.resetAllLocale(this.getFlatParagraphTools());
        List<Integer> changedParas = this.permanentIgnoredMatches.getAllParagraphs();
        this.permanentIgnoredMatches = new IgnoredMatches();
        this.remarkChangedParagraphs(changedParas, changedParas, false);
    }

    public String ignorePermanent() {
        if (this.disposed) {
            return null;
        }
        ViewCursorTools viewCursor = new ViewCursorTools(this.xComponent);
        int y = this.docCache.getFlatParagraphNumber(viewCursor.getViewCursorParagraph());
        int x = viewCursor.getViewCursorCharacter();
        SingleProofreadingError error = this.getErrorFromCache(y, x);
        Locale locale = error.nErrorType == 1 ? this.docCache.getFlatParagraphLocale(y) : null;
        int len = error.nErrorType == 1 ? error.nErrorLength : 0;
        this.setPermanentIgnoredMatch(error.nErrorStart, y, len, error.aRuleIdentifier, locale, false);
        return this.docID;
    }

    public void setPermanentIgnoredMatch(int x, int y, int len, String ruleId, Locale locale, boolean isIntern) {
        this.permanentIgnoredMatches.setIgnoredMatch(x, y, len, ruleId, locale, this.getFlatParagraphTools());
        if (debugMode > 1) {
            MessageHandler.printToLogFile("SingleDocument: setPermanentIgnoredMatch: DocumentType = " + (Object)((Object)this.docType) + "; numParasToCheck = " + this.numParasToCheck);
        }
        if (this.docType == OfficeTools.DocumentType.WRITER && this.numParasToCheck != 0) {
            ArrayList<Integer> changedParas = new ArrayList<Integer>();
            changedParas.add(y);
            this.remarkChangedParagraphs(changedParas, changedParas, isIntern);
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("SingleDocument: setPermanentIgnoredMatch: Ignore Match added at: paragraph: " + y + "; character: " + x + "; ruleId: " + ruleId);
        }
    }

    public void setPermanentIgnoredMatches(IgnoredMatches ignoredMatches) {
        List<Integer> changedParas = this.permanentIgnoredMatches.getAllParagraphs();
        this.permanentIgnoredMatches = ignoredMatches;
        this.remarkChangedParagraphs(changedParas, changedParas, false);
        changedParas = this.permanentIgnoredMatches.getAllParagraphs();
        this.remarkChangedParagraphs(changedParas, changedParas, false);
    }

    public IgnoredMatches getPermanentIgnoredMatches() {
        return this.permanentIgnoredMatches;
    }

    public void removeAndShiftIgnoredMatch(int from, int to, int oldSize, int newSize) {
        int n;
        int i;
        IgnoredMatches tmpIgnoredMatches;
        if (!this.ignoredMatches.isEmpty()) {
            tmpIgnoredMatches = new IgnoredMatches();
            for (i = 0; i < from; ++i) {
                if (!this.ignoredMatches.containsParagraph(i)) continue;
                tmpIgnoredMatches.put(i, this.ignoredMatches.get(i));
            }
            for (i = to + 1; i < oldSize; ++i) {
                n = i + newSize - oldSize;
                if (!this.ignoredMatches.containsParagraph(i)) continue;
                tmpIgnoredMatches.put(n, this.ignoredMatches.get(i));
            }
            this.ignoredMatches = tmpIgnoredMatches;
        }
        if (!this.permanentIgnoredMatches.isEmpty()) {
            tmpIgnoredMatches = new IgnoredMatches();
            for (i = 0; i < from; ++i) {
                if (!this.permanentIgnoredMatches.containsParagraph(i)) continue;
                tmpIgnoredMatches.put(i, this.permanentIgnoredMatches.get(i));
            }
            for (i = to + 1; i < oldSize; ++i) {
                n = i + newSize - oldSize;
                if (!this.permanentIgnoredMatches.containsParagraph(i)) continue;
                tmpIgnoredMatches.put(n, this.permanentIgnoredMatches.get(i));
            }
            this.permanentIgnoredMatches = tmpIgnoredMatches;
        }
    }

    public void removeIgnoredMatch(int y, boolean isIntern) {
        this.ignoredMatches.removeIgnoredMatches(y, null);
        if (this.numParasToCheck != 0 && this.flatPara != null) {
            ArrayList<Integer> changedParas = new ArrayList<Integer>();
            changedParas.add(y);
            this.remarkChangedParagraphs(changedParas, changedParas, isIntern);
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("SingleDocument: removeIgnoredMatch: All Ignored Matches removed at: paragraph: " + y);
        }
    }

    public void removeIgnoredMatch(int x, int y, String ruleId, boolean isIntern) {
        this.ignoredMatches.removeIgnoredMatch(x, y, ruleId, null);
        if (this.numParasToCheck != 0) {
            ArrayList<Integer> changedParas = new ArrayList<Integer>();
            changedParas.add(y);
            this.remarkChangedParagraphs(changedParas, changedParas, isIntern);
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("SingleDocument: removeIgnoredMatch: Ignore Match removed at: paragraph: " + y + "; character: " + x);
        }
    }

    public void removePermanentIgnoredMatch(int x, int y, String ruleId, boolean isIntern) {
        this.permanentIgnoredMatches.removeIgnoredMatch(x, y, ruleId, this.getFlatParagraphTools());
        if (this.numParasToCheck != 0) {
            ArrayList<Integer> changedParas = new ArrayList<Integer>();
            changedParas.add(y);
            this.remarkChangedParagraphs(changedParas, changedParas, isIntern);
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("SingleDocument: removePermanentIgnoredMatch: Ignore Match removed at: paragraph: " + y + "; character: " + x);
        }
    }

    private SingleProofreadingError getErrorFromCache(int nPara, int nChar) {
        ArrayList<SingleProofreadingError> tmpErrors = new ArrayList<SingleProofreadingError>();
        if (nPara < 0 || nPara >= this.docCache.size()) {
            MessageHandler.printToLogFile("SingleDocument: getRuleIdFromCache(nPara = " + nPara + ", docCache.size() = " + this.docCache.size() + "): nPara out of range!");
            return null;
        }
        for (ResultCache paraCache : this.paragraphsCache) {
            SingleProofreadingError tError = paraCache.getErrorAtPosition(nPara, nChar);
            if (tError == null) continue;
            tmpErrors.add(tError);
        }
        if (tmpErrors.size() > 0) {
            int i;
            SingleProofreadingError[] errors = new SingleProofreadingError[tmpErrors.size()];
            for (i = 0; i < tmpErrors.size(); ++i) {
                errors[i] = (SingleProofreadingError)tmpErrors.get(i);
            }
            Arrays.sort(errors, new ErrorPositionComparator());
            if (debugMode > 0) {
                for (i = 0; i < errors.length; ++i) {
                    MessageHandler.printToLogFile("SingleDocument: getRuleIdFromCache: Error[" + i + "]: ruleID: " + errors[i].aRuleIdentifier + ", Start = " + errors[i].nErrorStart + ", Length = " + errors[i].nErrorLength);
                }
            }
            return errors[0];
        }
        MessageHandler.printToLogFile("SingleDocument: getRuleIdFromCache(nPara = " + nPara + ", nChar = " + nChar + "): No ruleId found!");
        return null;
    }

    public SingleProofreadingError[] mergeErrors(List<SingleProofreadingError[]> pErrors, int nPara) {
        int errorCount = 0;
        if (pErrors != null) {
            for (SingleProofreadingError[] pError : pErrors) {
                if (pError == null) continue;
                errorCount += pError.length;
            }
        }
        if (errorCount == 0 || pErrors == null) {
            return new SingleProofreadingError[0];
        }
        SingleProofreadingError[] errorArray = new SingleProofreadingError[errorCount];
        if (pErrors != null) {
            errorCount = 0;
            for (SingleProofreadingError[] pError : pErrors) {
                if (pError == null) continue;
                System.arraycopy(pError, 0, errorArray, errorCount, pError.length);
                errorCount += pError.length;
            }
        }
        Arrays.sort(errorArray, new ErrorPositionComparator());
        return this.filterIgnoredMatches(errorArray, nPara);
    }

    private SingleProofreadingError[] filterIgnoredMatches(SingleProofreadingError[] unFilteredErrors, int nPara) {
        if (!this.ignoredMatches.isEmpty() && this.ignoredMatches.containsParagraph(nPara) || !this.permanentIgnoredMatches.isEmpty() && this.permanentIgnoredMatches.containsParagraph(nPara)) {
            ArrayList<SingleProofreadingError> filteredErrors = new ArrayList<SingleProofreadingError>();
            for (SingleProofreadingError error : unFilteredErrors) {
                if (this.ignoredMatches.isIgnored(error.nErrorStart, error.nErrorStart + error.nErrorLength, nPara, error.aRuleIdentifier) || this.permanentIgnoredMatches.isIgnored(error.nErrorStart, error.nErrorStart + error.nErrorLength, nPara, error.aRuleIdentifier)) continue;
                filteredErrors.add(error);
            }
            if (debugMode > 2) {
                MessageHandler.printToLogFile("SingleCheck: filterIgnoredMatches: unFilteredErrors.length: " + unFilteredErrors.length);
                MessageHandler.printToLogFile("SingleCheck: filterIgnoredMatches: filteredErrors.length: " + filteredErrors.size());
            }
            return filteredErrors.toArray(new SingleProofreadingError[0]);
        }
        return unFilteredErrors;
    }

    private RuleDesc getRuleIdFromCheck(int nChar, ViewCursorTools viewCursor) {
        String text = viewCursor.getViewCursorParagraphText();
        if (text == null) {
            return null;
        }
        PropertyValue[] propertyValues = new PropertyValue[]{};
        ProofreadingResult paRes = new ProofreadingResult();
        paRes.nStartOfSentencePosition = 0;
        paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition = 0;
        paRes.xProofreader = null;
        paRes.aLocale = this.mDocHandler.getLocale();
        paRes.aDocumentIdentifier = this.docID;
        paRes.aText = text;
        paRes.aProperties = propertyValues;
        paRes.aErrors = null;
        while (nChar > paRes.nStartOfNextSentencePosition && paRes.nStartOfNextSentencePosition < text.length()) {
            paRes.nStartOfSentencePosition = paRes.nStartOfNextSentencePosition;
            paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition = text.length();
            paRes = this.getCheckResults(text, paRes.aLocale, paRes, propertyValues, false, this.mDocHandler.getLanguageTool(), -1, OfficeTools.LoErrorType.GRAMMAR);
            if (paRes.nStartOfNextSentencePosition <= nChar) continue;
            if (paRes.aErrors == null) {
                return null;
            }
            for (SingleProofreadingError error : paRes.aErrors) {
                if (error.nErrorStart > nChar || nChar >= error.nErrorStart + error.nErrorLength) continue;
                return new RuleDesc(paRes.aLocale, -1, error);
            }
        }
        MessageHandler.printToLogFile("SingleDocument: getRuleIdFromCache: No ruleId found");
        return null;
    }

    public RuleDesc getCurrentRule() {
        if (this.disposed) {
            return null;
        }
        ViewCursorTools viewCursor = new ViewCursorTools(this.xComponent);
        int x = viewCursor.getViewCursorCharacter();
        if (this.numParasToCheck == 0) {
            return this.getRuleIdFromCheck(x, viewCursor);
        }
        int y = this.docCache.getFlatParagraphNumber(viewCursor.getViewCursorParagraph());
        SingleProofreadingError error = this.getErrorFromCache(y, x);
        if (error != null) {
            return new RuleDesc(this.docCache.getFlatParagraphLocale(y), y, error);
        }
        return null;
    }

    public String[] getSynonymArray(SingleProofreadingError error, String para, Locale locale, SwJLanguageTool lt, boolean setLimit) {
        Map<String, List<String>> synonymMap = this.getSynonymMap(error, para, locale, lt);
        if (synonymMap.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> suggestions = new ArrayList<String>();
        int n = 0;
        for (String lemma : synonymMap.keySet()) {
            for (String suggestion : synonymMap.get(lemma)) {
                suggestions.add(suggestion);
                if (!setLimit || ++n < 25) continue;
                break;
            }
            if (!setLimit || n < 25) continue;
            break;
        }
        return suggestions.toArray(new String[suggestions.size()]);
    }

    public Map<String, List<String>> getSynonymMap(SingleProofreadingError error, String para, Locale locale, SwJLanguageTool lt) {
        HashMap<String, List<String>> suggestionMap = new HashMap<String, List<String>>();
        try {
            String word = para.substring(error.nErrorStart, error.nErrorStart + error.nErrorLength);
            boolean startUpperCase = Character.isUpperCase(word.charAt(0));
            if (debugMode > 0) {
                MessageHandler.printToLogFile("SingleDocument: getSynonymMap: Find Synonyms for word:" + word);
            }
            List<String> lemmas = lt.getLemmasOfParagraph(para, error.nErrorStart);
            for (String lemma : lemmas) {
                if (debugMode > 1) {
                    MessageHandler.printToLogFile("SingleDocument: getSynonymMap: Find Synonyms for lemma:" + lemma);
                }
                ArrayList<String> suggestions = new ArrayList<String>();
                List<String> synonyms = this.mDocHandler.getLinguisticServices().getSynonyms(lemma, locale);
                for (String synonym : synonyms) {
                    synonym = synonym.replaceAll("\\(.*\\)", "").trim();
                    if (debugMode > 1) {
                        MessageHandler.printToLogFile("SingleDocument: getSynonymMap: Synonym:" + synonym);
                    }
                    if (synonym.isEmpty() || suggestions.contains(synonym) || (!startUpperCase || !Character.isUpperCase(synonym.charAt(0))) && (startUpperCase || !Character.isLowerCase(synonym.charAt(0)))) continue;
                    suggestions.add(synonym);
                }
                if (suggestions.isEmpty()) continue;
                suggestionMap.put(lemma, suggestions);
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        return suggestionMap;
    }

    private void addSynonyms(ProofreadingResult paRes, String para, Locale locale, SwJLanguageTool lt) throws IOException {
        LinguisticServices linguServices = this.mDocHandler.getLinguisticServices();
        if (linguServices != null) {
            for (SingleProofreadingError error : paRes.aErrors) {
                if (error.aSuggestions != null && error.aSuggestions.length != 0 || !linguServices.isThesaurusRelevantRule(error.aRuleIdentifier)) continue;
                error.aSuggestions = this.getSynonymArray(error, para, locale, lt, true);
            }
        }
    }

    ProofreadingResult getErrorsFromCache(int nFPara, ProofreadingResult paRes, String para, Locale locale, SwJLanguageTool lt) throws IOException {
        ArrayList<SingleProofreadingError[]> errors = new ArrayList<SingleProofreadingError[]>();
        paRes.nStartOfSentencePosition = 0;
        paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition = para.length();
        for (int cacheNum = 0; cacheNum < this.mDocHandler.getNumMinToCheckParas().size(); ++cacheNum) {
            errors.add(this.paragraphsCache.get(cacheNum).getMatches(nFPara, OfficeTools.LoErrorType.GRAMMAR));
        }
        paRes.aErrors = this.mergeErrors(errors, nFPara);
        if (debugMode > 1) {
            MessageHandler.printToLogFile("SingleDocument: getErrorsFromCache: Sentence: start: " + paRes.nStartOfSentencePosition + ", end: " + paRes.nBehindEndOfSentencePosition + ", next: " + paRes.nStartOfNextSentencePosition + ", num errors: " + paRes.aErrors.length);
        }
        this.addStatAnalysisErrors(paRes, nFPara);
        this.addSynonyms(paRes, para, locale, lt);
        return paRes;
    }

    private void setDokumentListener(XComponent xComponent) {
        try {
            if (!this.disposed && xComponent != null && this.eventListener == null) {
                this.eventListener = new LTDokumentEventListener();
                XDocumentEventBroadcaster broadcaster = (XDocumentEventBroadcaster)UnoRuntime.queryInterface(XDocumentEventBroadcaster.class, (Object)xComponent);
                if (!this.disposed && broadcaster != null) {
                    broadcaster.addDocumentEventListener((XDocumentEventListener)this.eventListener);
                } else {
                    MessageHandler.printToLogFile("SingleDocument: setDokumentListener: Could not add document event listener!");
                }
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
                if (this.disposed || xModel == null) {
                    MessageHandler.printToLogFile("SingleDocument: setDokumentListener: XModel not found!");
                    return;
                }
                XController xController = xModel.getCurrentController();
                if (this.disposed || xController == null) {
                    MessageHandler.printToLogFile("SingleDocument: setDokumentListener: XController not found!");
                    return;
                }
                XUserInputInterception xUserInputInterception = (XUserInputInterception)UnoRuntime.queryInterface(XUserInputInterception.class, (Object)xController);
                if (this.disposed || xUserInputInterception == null) {
                    MessageHandler.printToLogFile("SingleDocument: setDokumentListener: XUserInputInterception not found!");
                    return;
                }
                xUserInputInterception.addMouseClickHandler((XMouseClickHandler)this.eventListener);
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
    }

    public void removeDokumentListener(XComponent xComponent) {
        XDocumentEventBroadcaster broadcaster;
        if (this.eventListener != null && (broadcaster = (XDocumentEventBroadcaster)UnoRuntime.queryInterface(XDocumentEventBroadcaster.class, (Object)xComponent)) != null) {
            broadcaster.removeDocumentEventListener((XDocumentEventListener)this.eventListener);
        }
    }

    public static SingleProofreadingError[] addStatAnalysisErrors(SingleProofreadingError[] errors, SingleProofreadingError[] statAnErrors, String statAnRuleId) {
        ArrayList<SingleProofreadingError> errorList = new ArrayList<SingleProofreadingError>();
        for (SingleProofreadingError error : statAnErrors) {
            errorList.add(error);
        }
        for (SingleProofreadingError error : errors) {
            if (error.aRuleIdentifier.equals(statAnRuleId)) continue;
            errorList.add(error);
        }
        return errorList.toArray(new SingleProofreadingError[errorList.size()]);
    }

    private void addStatAnalysisErrors(ProofreadingResult paRes, int nFPara) {
        SingleProofreadingError[] statAnErrors;
        if (this.statAnCache != null && this.statAnRuleId != null && (statAnErrors = this.statAnCache.getSafeMatches(nFPara)) != null && statAnErrors.length > 0) {
            paRes.aErrors = SingleDocument.addStatAnalysisErrors(paRes.aErrors, statAnErrors, this.statAnRuleId);
        }
    }

    private class LTDokumentEventListener
    implements XDocumentEventListener,
    XMouseClickHandler {
        private LTDokumentEventListener() {
        }

        public void disposing(EventObject event) {
        }

        public void documentEventOccured(DocumentEvent event) {
            if (event.EventName.equals("OnUnload")) {
                SingleDocument.this.isOnUnload = true;
                SingleDocument.this.writeCaches();
            } else if (event.EventName.equals("OnUnfocus") && !SingleDocument.this.isOnUnload) {
                SingleDocument.this.mDocHandler.getCurrentDocument();
            } else if (event.EventName.equals("OnSaveDone") && SingleDocument.this.config.saveLoCache()) {
                SingleDocument.this.writeCaches();
            } else if (event.EventName.equals("OnSaveAsDone") && SingleDocument.this.config.saveLoCache()) {
                try {
                    SingleDocument.this.cacheIO.setDocumentPath(SingleDocument.this.xComponent);
                    SingleDocument.this.writeCaches();
                }
                catch (Throwable t) {
                    MessageHandler.showError(t);
                }
            }
        }

        public boolean mousePressed(MouseEvent event) {
            if (event.Buttons == 2) {
                SingleDocument.this.isRightButtonPressed = true;
            }
            return false;
        }

        public boolean mouseReleased(MouseEvent event) {
            return false;
        }
    }

    public static class RuleDesc {
        String langCode;
        int nFPara;
        SingleProofreadingError error;

        RuleDesc(Locale locale, int nFPara, SingleProofreadingError error) {
            this.langCode = OfficeTools.localeToString(locale);
            this.nFPara = nFPara;
            this.error = error;
        }
    }
}

