/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.linguistic2.SingleProofreadingError;
import java.awt.Color;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.Tools;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.DocumentCursorTools;
import org.languagetool.openoffice.FlatParagraphTools;
import org.languagetool.openoffice.LinguisticServices;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.ResultCache;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.SwJLanguageTool;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class SingleCheck {
    private static int debugMode;
    private final SingleDocument singleDocument;
    private final MultiDocumentsHandler mDocHandler;
    private final XComponent xComponent;
    private final Configuration config;
    private final DocumentCache docCache;
    private final List<Integer> minToCheckPara;
    private final List<ResultCache> paragraphsCache;
    private final int numParasToCheck;
    private final OfficeTools.DocumentType docType;
    private final boolean isDialogRequest;
    private final boolean isMouseRequest;
    private final boolean isIntern;
    private final boolean useQueue;
    private final Language docLanguage;
    private final Language fixedLanguage;
    private int changeFrom = 0;
    private int changeTo = 0;
    private String lastSinglePara = null;
    private List<Integer> changedParas;

    SingleCheck(SingleDocument singleDocument, List<ResultCache> paragraphsCache, Language fixedLanguage, Language docLanguage, int numParasToCheck, boolean isDialogRequest, boolean isMouseRequest, boolean isIntern) {
        debugMode = OfficeTools.DEBUG_MODE_SC;
        this.singleDocument = singleDocument;
        this.paragraphsCache = paragraphsCache;
        this.numParasToCheck = numParasToCheck;
        this.isDialogRequest = isDialogRequest;
        this.isMouseRequest = isMouseRequest;
        this.isIntern = isIntern;
        this.docLanguage = docLanguage;
        this.fixedLanguage = fixedLanguage;
        this.mDocHandler = singleDocument.getMultiDocumentsHandler();
        this.xComponent = singleDocument.getXComponent();
        this.docCache = singleDocument.getDocumentCache();
        this.docType = singleDocument.getDocumentType();
        this.config = this.mDocHandler.getConfiguration();
        this.useQueue = numParasToCheck != 0 && !isDialogRequest && !this.mDocHandler.isTestMode() && this.config.useTextLevelQueue();
        this.minToCheckPara = this.mDocHandler.getNumMinToCheckParas();
        this.changedParas = new ArrayList<Integer>();
    }

    public SingleProofreadingError[] getCheckResults(String paraText, int[] footnotePositions, Locale locale, SwJLanguageTool lt, int paraNum, int startOfSentence, boolean textIsChanged, int changeFrom, int changeTo, String lastSinglePara, int lastChangedPara, OfficeTools.LoErrorType errType) throws Throwable {
        if (this.isDisposed()) {
            return new SingleProofreadingError[0];
        }
        if (this.docType == OfficeTools.DocumentType.WRITER && !this.isIntern && lastChangedPara >= 0 && !this.useQueue) {
            List<Integer> changedParas = this.singleDocument.getLastChangedParas();
            if (changedParas == null) {
                changedParas = new ArrayList<Integer>();
            } else {
                this.singleDocument.setLastChangedParas(null);
            }
            if (changedParas.contains(lastChangedPara)) {
                changedParas.add(lastChangedPara);
            }
            this.remarkChangedParagraphs(changedParas, changedParas, lt);
        }
        this.lastSinglePara = lastSinglePara;
        List<SingleProofreadingError[]> pErrors = this.checkTextRules(paraText, locale, footnotePositions, paraNum, startOfSentence, lt, textIsChanged, this.isIntern, errType);
        SingleProofreadingError[] errors = this.singleDocument.mergeErrors(pErrors, paraNum);
        if (debugMode > 1) {
            MessageHandler.printToLogFile("SingleCheck: getCheckResults: paRes.aErrors.length: " + errors.length + "; docID: " + this.singleDocument.getDocID());
        }
        if (!this.isDisposed() && this.docType == OfficeTools.DocumentType.WRITER && this.numParasToCheck != 0 && paraNum >= 0 && !this.useQueue && (textIsChanged || this.isDialogRequest)) {
            if (!this.isIntern && this.isDialogRequest && !textIsChanged) {
                ArrayList<Integer> changedParas = new ArrayList<Integer>();
                changedParas.add(paraNum);
                this.remarkChangedParagraphs(changedParas, changedParas, lt);
            } else if (textIsChanged && (!this.useQueue || this.isDialogRequest)) {
                this.remarkChangedParagraphs(this.changedParas, this.changedParas, lt);
            }
        }
        return errors;
    }

    public void addParaErrorsToCache(int nFPara, SwJLanguageTool lt, int cacheNum, int parasToCheck, boolean checkOnlyParagraph, boolean override, boolean isIntern, boolean hasFootnotes) throws Throwable {
        MultiDocumentsHandler mDH = this.mDocHandler;
        if (this.isDisposed() || this.docCache == null || nFPara < 0 || nFPara >= this.docCache.size()) {
            MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: return: isDisposed = " + this.isDisposed() + ", nFPara = " + nFPara + ", docCache(Size) = " + (this.docCache == null ? "null" : Integer.valueOf(this.docCache.size())));
            return;
        }
        DocumentCache docCache = new DocumentCache(this.docCache);
        if (debugMode > 0 && lt == null && !docCache.isAutomaticGenerated(nFPara, true)) {
            MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: return: lt is null");
        }
        try {
            ResultCache oldCache = null;
            if (this.useQueue && !this.isDialogRequest) {
                oldCache = new ResultCache(this.paragraphsCache.get(cacheNum));
            }
            DocumentCache.TextParagraph tPara = docCache.getNumberOfTextParagraph(nFPara);
            if (tPara.type < 0 || tPara.number < 0) {
                MessageHandler.printToLogFile("WARNING: doc cache corrupted (at SingleCheck: addParaErrorsToCache) : refresh doc cache!");
                this.docCache.refresh(this.singleDocument, LinguisticServices.getLocale(this.fixedLanguage), LinguisticServices.getLocale(this.docLanguage), this.xComponent, 7);
                docCache = new DocumentCache(this.docCache);
                tPara = docCache.getNumberOfTextParagraph(nFPara);
                if (tPara.type < 0 || tPara.number < 0) {
                    MessageHandler.printToLogFile("Error: doc cache problem: error cache(" + cacheNum + ") set empty for nFpara = " + nFPara + "!");
                    this.paragraphsCache.get(cacheNum).put(nFPara, null, new SingleProofreadingError[0]);
                    oldCache = null;
                    return;
                }
            }
            int cursorType = tPara.type;
            int startPara = docCache.getStartOfParaCheck(tPara, parasToCheck, checkOnlyParagraph, this.useQueue, false);
            int endPara = docCache.getEndOfParaCheck(tPara, parasToCheck, checkOnlyParagraph, this.useQueue, false);
            String textToCheck = docCache.getDocAsString(tPara, parasToCheck, checkOnlyParagraph, this.useQueue, hasFootnotes);
            List<RuleMatch> paragraphMatches = null;
            List<Integer> nextSentencePositions = null;
            if (lt != null && this.mDocHandler.isSortedRuleForIndex(cacheNum)) {
                if (!docCache.isAutomaticGenerated(nFPara, true)) {
                    int startText = docCache.getStartOfParaCheck(tPara, parasToCheck, checkOnlyParagraph, this.useQueue, true);
                    int endText = docCache.getEndOfParaCheck(tPara, parasToCheck, checkOnlyParagraph, this.useQueue, true);
                    paragraphMatches = lt.check(new DocumentCache.TextParagraph(tPara.type, startText), new DocumentCache.TextParagraph(tPara.type, endText), textToCheck, cacheNum == 0 ? JLanguageTool.ParagraphHandling.NORMAL : JLanguageTool.ParagraphHandling.ONLYPARA, this.singleDocument);
                }
                if (cacheNum == 0) {
                    nextSentencePositions = SingleCheck.getNextSentencePositions(textToCheck, lt);
                }
            }
            int startPos = docCache.getStartOfParagraph(startPara, tPara, parasToCheck, checkOnlyParagraph, this.useQueue, hasFootnotes);
            if (debugMode > 1) {
                MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: tPara.type = " + tPara.type + "; tPara.number = " + tPara.number);
                MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: nFPara = " + nFPara + "; startPara = " + startPara + "; endPara = " + endPara);
            }
            for (int i = startPara; i < endPara; ++i) {
                if (this.isDisposed() || this.useQueue && !this.isDialogRequest && (mDH.getTextLevelCheckQueue() == null || mDH.getTextLevelCheckQueue().isInterrupted())) {
                    MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: return: isDisposed = " + this.isDisposed() + ", useQueue = " + this.useQueue + ", isDialogRequest = " + this.isDialogRequest + ", TextLevelCheckQueue(isInterrupted) = " + (mDH.getTextLevelCheckQueue() == null ? "null" : Boolean.valueOf(mDH.getTextLevelCheckQueue().isInterrupted())));
                    oldCache = null;
                    return;
                }
                DocumentCache.TextParagraph textPara = docCache.createTextParagraph(cursorType, i);
                int[] footnotePos = docCache.getTextParagraphFootnotes(textPara);
                int endPos = i < endPara - 1 ? docCache.getStartOfParagraph(i + 1, tPara, parasToCheck, checkOnlyParagraph, this.useQueue, hasFootnotes) : textToCheck.length();
                if (paragraphMatches == null || paragraphMatches.isEmpty() || lt == null) {
                    this.paragraphsCache.get(cacheNum).put(docCache.getFlatParagraphNumber(textPara), nextSentencePositions, new SingleProofreadingError[0]);
                    if (debugMode > 1) {
                        MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: Enter to para cache(" + cacheNum + "): Paragraph(" + docCache.getFlatParagraphNumber(textPara) + "): " + docCache.getTextParagraph(textPara) + "; Error number: 0");
                    }
                } else {
                    ArrayList<SingleProofreadingError> errorList = new ArrayList<SingleProofreadingError>();
                    int textPos = startPos;
                    if (textPos < 0) {
                        textPos = 0;
                    }
                    for (RuleMatch myRuleMatch : paragraphMatches) {
                        int toPos;
                        if (!this.isCorrectRuleMatch(myRuleMatch, textToCheck, lt.getLanguage())) continue;
                        int startErrPos = myRuleMatch.getFromPos();
                        if (debugMode > 2) {
                            MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: Cache = " + cacheNum + ", startPos = " + startPos + ", endPos = " + endPos + ", startErrPos = " + startErrPos);
                        }
                        if (startErrPos < startPos || startErrPos >= endPos || (toPos = docCache.getTextParagraph(textPara).length()) <= 0) continue;
                        errorList.add(SingleCheck.correctRuleMatchWithFootnotes(this.createOOoError(myRuleMatch, -textPos, footnotePos), footnotePos, docCache.getTextParagraphDeletedCharacters(textPara)));
                    }
                    if (!errorList.isEmpty()) {
                        this.paragraphsCache.get(cacheNum).put(docCache.getFlatParagraphNumber(textPara), nextSentencePositions, errorList.toArray(new SingleProofreadingError[0]));
                        if (debugMode > 1) {
                            MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: Enter to para cache(" + cacheNum + "): Paragraph(" + docCache.getFlatParagraphNumber(textPara) + "): " + docCache.getTextParagraph(textPara) + "; Error number: " + errorList.size());
                        }
                    } else {
                        this.paragraphsCache.get(cacheNum).put(docCache.getFlatParagraphNumber(textPara), nextSentencePositions, new SingleProofreadingError[0]);
                        if (debugMode > 1) {
                            MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: Enter to para cache(" + cacheNum + "): Paragraph(" + docCache.getFlatParagraphNumber(textPara) + "): " + docCache.getTextParagraph(textPara) + "; Error number: 0");
                        }
                    }
                }
                startPos = endPos;
            }
            if (!this.isDisposed() && this.docType == OfficeTools.DocumentType.WRITER && this.useQueue && !this.isDialogRequest) {
                if (mDH.getTextLevelCheckQueue() == null || mDH.getTextLevelCheckQueue().isInterrupted()) {
                    oldCache = null;
                    return;
                }
                ArrayList<Integer> changedParas = new ArrayList<Integer>();
                ArrayList<Integer> toRemarkParas = new ArrayList<Integer>();
                if (cacheNum == 0) {
                    changedParas.add(nFPara);
                    this.remarkChangedParagraphs(changedParas, changedParas, lt);
                } else if (oldCache != null) {
                    for (int nText = startPara; nText < endPara; ++nText) {
                        int nFlat = docCache.getFlatParagraphNumber(docCache.createTextParagraph(cursorType, nText));
                        if (this.paragraphsCache.get(0).getCacheEntry(nFlat) == null || !ResultCache.areDifferentEntries(this.paragraphsCache.get(cacheNum).getSerialCacheEntry(nFlat), oldCache.getSerialCacheEntry(nFlat))) continue;
                        changedParas.add(nFlat);
                        toRemarkParas.add(nFlat);
                    }
                    if (!changedParas.isEmpty()) {
                        if (debugMode > 1) {
                            MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: Cache(" + cacheNum + "): Mark paragraphs from " + startPara + " to " + endPara + ": " + changedParas.size() + " changes, tPara.type: " + tPara.type + ", tPara.number: " + tPara.number + ", nFPara: " + nFPara);
                            String tmpText = "Changed Paras: ";
                            Iterator iterator = changedParas.iterator();
                            while (iterator.hasNext()) {
                                int n = (Integer)iterator.next();
                                tmpText = tmpText + n + " ";
                            }
                            MessageHandler.printToLogFile(tmpText);
                        }
                        this.singleDocument.setLastChangedParas(changedParas);
                        this.remarkChangedParagraphs(changedParas, toRemarkParas, lt);
                    } else if (debugMode > 1) {
                        MessageHandler.printToLogFile("SingleCheck: addParaErrorsToCache: Cache(" + cacheNum + ") Mark paragraphs from " + startPara + " to " + endPara + ": No Paras to Mark, tPara.type: " + tPara.type + ", tPara.number: " + tPara.number + ", nFPara: " + nFPara);
                    }
                }
            }
            oldCache = null;
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    public void remarkChangedParagraphs(List<Integer> changedParas, List<Integer> toRemarkParas, SwJLanguageTool lt) {
        if (!(this.isDisposed() || this.mDocHandler.isBackgroundCheckOff() || this.isDialogRequest && !this.isIntern)) {
            FlatParagraphTools flatPara;
            DocumentCursorTools docCursor;
            int i;
            HashMap<Integer, List<SentenceErrors>> changedParasMap = new HashMap<Integer, List<SentenceErrors>>();
            ArrayList<DocumentCache.TextParagraph> toRemarkTextParas = new ArrayList<DocumentCache.TextParagraph>();
            for (i = 0; i < changedParas.size(); ++i) {
                int j;
                if (this.singleDocument.isRunning(i)) continue;
                List<SentenceErrors> sentencesErrors = this.getSentencesErrosAsList(changedParas.get(i), lt, OfficeTools.LoErrorType.GRAMMAR);
                changedParasMap.put(changedParas.get(i), sentencesErrors);
                if (debugMode <= 1) continue;
                String message = "SingleCheck: remarkChangedParagraphs: Mark errors: Paragraph: " + changedParas.get(i) + "; Number of sentences: " + sentencesErrors.size();
                for (j = 0; j < sentencesErrors.size(); ++j) {
                    message = message + "; Sentence " + j + ": Start = " + sentencesErrors.get((int)j).sentenceStart + "; End = " + sentencesErrors.get((int)j).sentenceEnd + ", Number of Errors = " + sentencesErrors.get((int)j).sentenceErrors.length;
                }
                MessageHandler.printToLogFile(message);
                message = "SingleCheck: remarkChangedParagraphs: Errors of Sentence 0: ";
                for (j = 0; j < sentencesErrors.get((int)0).sentenceErrors.length; ++j) {
                    message = message + "Error " + j + ": Start = " + sentencesErrors.get((int)0).sentenceErrors[j].nErrorStart + ", Length = " + sentencesErrors.get((int)0).sentenceErrors[j].nErrorLength + "; ErrorID = " + sentencesErrors.get((int)0).sentenceErrors[j].aRuleIdentifier + "; ";
                }
                MessageHandler.printToLogFile(message);
                for (j = 0; j < this.paragraphsCache.size(); ++j) {
                    MessageHandler.printToLogFile("SingleCheck: remarkChangedParagraphs: Paragraph " + changedParas.get(i) + ": Cache " + j + ": Number of Errors = " + (this.paragraphsCache.get(j).getMatches(changedParas.get(i), OfficeTools.LoErrorType.GRAMMAR) == null ? "null" : Integer.valueOf(this.paragraphsCache.get(j).getMatches(changedParas.get(i), OfficeTools.LoErrorType.GRAMMAR).length)));
                }
            }
            for (i = 0; i < toRemarkParas.size(); ++i) {
                if (this.singleDocument.isRunning(i)) continue;
                toRemarkTextParas.add(this.docCache.getNumberOfTextParagraph(toRemarkParas.get(i)));
                if (debugMode <= 1) continue;
                String message = "SingleCheck: remarkChangedParagraphs: Remark: Paragraph: " + toRemarkParas.get(i);
                MessageHandler.printToLogFile(message);
            }
            if (!this.isDisposed() && !toRemarkTextParas.isEmpty() && (docCursor = this.singleDocument.getDocumentCursorTools()) != null) {
                docCursor.removeMarks(toRemarkTextParas);
            }
            if (!this.isDisposed() && (flatPara = this.singleDocument.getFlatParagraphTools()) != null) {
                flatPara.markParagraphs(changedParasMap);
            }
        }
    }

    public String getLastSingleParagraph() {
        return this.lastSinglePara;
    }

    private boolean isDisposed() {
        return this.singleDocument.isDisposed();
    }

    private List<SingleProofreadingError[]> checkTextRules(String paraText, Locale locale, int[] footnotePos, int paraNum, int startSentencePos, SwJLanguageTool lt, boolean textIsChanged, boolean isIntern, OfficeTools.LoErrorType errType) throws Throwable {
        DocumentCache.TextParagraph nTParas;
        ArrayList<SingleProofreadingError[]> pErrors = new ArrayList<SingleProofreadingError[]>();
        if (this.isDisposed()) {
            return pErrors;
        }
        DocumentCache.TextParagraph textParagraph = nTParas = paraNum < 0 ? null : this.docCache.getNumberOfTextParagraph(paraNum);
        if (nTParas == null || nTParas.type == -1 || this.docCache.isSingleParagraph(paraNum)) {
            pErrors.add(this.checkParaRules(paraText, locale, footnotePos, paraNum, startSentencePos, lt, 0, 0, textIsChanged, isIntern, errType));
        } else {
            ResultCache oldCache = null;
            for (int i = 0; i < this.minToCheckPara.size(); ++i) {
                int parasToCheck = this.minToCheckPara.get(i);
                if (i == 0 || this.mDocHandler.isSortedRuleForIndex(i)) {
                    this.mDocHandler.activateTextRulesByIndex(i, lt);
                    if (debugMode > 0) {
                        MessageHandler.printToLogFile("SingleCheck: checkTextRules: Index: " + i + "/" + this.minToCheckPara.size() + "; paraNum: " + paraNum + "; numParasToCheck: " + parasToCheck + "; useQueue: " + this.useQueue);
                    }
                    if (textIsChanged && !this.useQueue && parasToCheck != 0) {
                        if (debugMode > 1) {
                            MessageHandler.printToLogFile("SingleCheck: checkTextRules: Copy old cache!");
                        }
                        oldCache = new ResultCache(this.paragraphsCache.get(i));
                        if (debugMode > 1) {
                            MessageHandler.printToLogFile("SingleCheck: checkTextRules: Old cache copied!");
                        }
                    }
                    pErrors.add(this.checkParaRules(paraText, locale, footnotePos, paraNum, startSentencePos, lt, i, parasToCheck, textIsChanged, isIntern, errType));
                    if (debugMode > 1) {
                        MessageHandler.printToLogFile("SingleCheck: checkTextRules: Error Cache added!");
                    }
                    if (this.isDisposed() || !textIsChanged || this.useQueue) continue;
                    if (parasToCheck != 0) {
                        List<Integer> tmpChangedParas = this.paragraphsCache.get(i).differenceInCaches(oldCache);
                        for (int chPara : tmpChangedParas) {
                            if (this.changedParas.contains(chPara)) continue;
                            this.changedParas.add(chPara);
                        }
                        if (!this.changedParas.contains(paraNum)) {
                            this.changedParas.add(paraNum);
                        }
                        oldCache = null;
                        continue;
                    }
                    this.addChangedParas();
                    continue;
                }
                pErrors.add(new SingleProofreadingError[0]);
            }
            this.mDocHandler.reactivateTextRules(lt);
            if (debugMode > 1) {
                MessageHandler.printToLogFile("SingleCheck: checkTextRules: Text rules reactivated");
            }
        }
        return pErrors;
    }

    private void addChangedParas() {
        int lastPara;
        int firstPara = this.changeFrom;
        if (firstPara < 0) {
            firstPara = 0;
        }
        if ((lastPara = this.changeTo) > this.docCache.size()) {
            lastPara = this.docCache.size();
        }
        for (int n = firstPara; n < lastPara; ++n) {
            if (this.changedParas.contains(n)) continue;
            this.changedParas.add(n);
        }
    }

    @Nullable
    public SingleProofreadingError[] checkParaRules(String paraText, Locale locale, int[] footnotePos, int nFPara, int sentencePos, SwJLanguageTool lt, int cacheNum, int parasToCheck, boolean textIsChanged, boolean isIntern, OfficeTools.LoErrorType errType) {
        SingleProofreadingError[] pErrors = null;
        int startSentencePos = 0;
        int endSentencePos = 0;
        try {
            boolean isTextParagraph;
            boolean isMultiLingual;
            if (this.isDisposed()) {
                return pErrors;
            }
            boolean bl = isMultiLingual = nFPara >= 0 ? this.docCache.isMultilingualFlatParagraph(nFPara) : false;
            if (nFPara >= 0 || sentencePos > 0 && this.lastSinglePara != null && this.lastSinglePara.equals(paraText)) {
                if (this.paragraphsCache.get(0).getCacheEntry(nFPara) != null) {
                    startSentencePos = this.paragraphsCache.get(0).getStartSentencePosition(nFPara, sentencePos);
                    endSentencePos = this.paragraphsCache.get(0).getNextSentencePosition(nFPara, sentencePos);
                    pErrors = this.paragraphsCache.get(cacheNum).getFromPara(nFPara, startSentencePos, endSentencePos, errType);
                    if (debugMode > 0 && pErrors != null) {
                        String eInfo = ", ";
                        for (SingleProofreadingError error : pErrors) {
                            eInfo = eInfo + "(" + error.nErrorStart + "/" + error.nErrorLength + "), ";
                        }
                        MessageHandler.printToLogFile("SingleCheck: checkParaRules: Para: " + nFPara + "; pErrors from cache(" + cacheNum + "): " + pErrors.length + ", start = " + startSentencePos + ", end = " + endSentencePos + eInfo);
                    }
                }
            } else if (sentencePos == 0) {
                this.lastSinglePara = paraText;
            }
            boolean bl2 = isTextParagraph = nFPara >= 0 && this.docCache != null && this.docCache.getNumberOfTextParagraph((int)nFPara).type != -1 && !this.docCache.isSingleParagraph(nFPara);
            if (nFPara >= 0 && (pErrors != null || this.isMouseRequest || this.useQueue && !this.isDialogRequest && parasToCheck != 0)) {
                if (this.useQueue && pErrors == null && parasToCheck != 0 && isTextParagraph) {
                    this.singleDocument.addQueueEntry(nFPara, cacheNum, parasToCheck, this.singleDocument.getDocID(), textIsChanged);
                }
                return pErrors;
            }
            if (!isTextParagraph || parasToCheck == 0) {
                List<RuleMatch> paragraphMatches;
                List<Integer> deletedChars;
                Locale primaryLocale = isMultiLingual ? this.docCache.getFlatParagraphLocale(nFPara) : locale;
                SwJLanguageTool mLt = null;
                if (OfficeTools.isEqualLocale(primaryLocale, locale) || !MultiDocumentsHandler.hasLocale(primaryLocale)) {
                    mLt = lt;
                } else {
                    Language mLang = MultiDocumentsHandler.getLanguage(primaryLocale);
                    if (mLang != null) {
                        mLt = this.mDocHandler.initLanguageTool(mLang, false);
                        this.mDocHandler.initCheck(mLt);
                    }
                }
                List<Integer> nextSentencePositions = SingleCheck.getNextSentencePositions(paraText, mLt);
                List<Integer> list = deletedChars = isTextParagraph ? this.docCache.getFlatParagraphDeletedCharacters(nFPara) : null;
                if (mLt == null || nFPara >= 0 && this.docCache != null && this.docCache.isAutomaticGenerated(nFPara, true)) {
                    paragraphMatches = null;
                } else {
                    paraText = SingleCheck.removeFootnotes(paraText, footnotePos, deletedChars);
                    paragraphMatches = mLt.check(paraText, JLanguageTool.ParagraphHandling.NORMAL, nFPara, this.singleDocument);
                }
                if (this.isDisposed()) {
                    return null;
                }
                if (paragraphMatches == null || paragraphMatches.isEmpty()) {
                    this.paragraphsCache.get(cacheNum).put(nFPara, nextSentencePositions, new SingleProofreadingError[0]);
                    if (debugMode > 1) {
                        MessageHandler.printToLogFile("SingleCheck: checkParaRules: Enter " + (isMultiLingual ? "only para " : " ") + "errors to cache(" + cacheNum + "): Paragraph(" + nFPara + "): " + paraText + "; Error number: " + 0);
                    }
                } else {
                    ArrayList<SingleProofreadingError> errorList = new ArrayList<SingleProofreadingError>();
                    for (RuleMatch myRuleMatch : paragraphMatches) {
                        if (!this.isCorrectRuleMatch(myRuleMatch, paraText, lt.getLanguage())) continue;
                        int toPos = myRuleMatch.getToPos();
                        if (toPos > paraText.length()) {
                            toPos = paraText.length();
                        }
                        errorList.add(SingleCheck.correctRuleMatchWithFootnotes(this.createOOoError(myRuleMatch, 0, footnotePos), footnotePos, deletedChars));
                    }
                    if (!errorList.isEmpty()) {
                        if (debugMode > 1) {
                            MessageHandler.printToLogFile("SingleCheck: checkParaRules: Enter " + (isMultiLingual ? "only para " : " ") + "errors to cache(" + cacheNum + "): Paragraph(" + nFPara + "): " + paraText + "; Error number: " + errorList.size());
                        }
                        this.paragraphsCache.get(cacheNum).put(nFPara, nextSentencePositions, errorList.toArray(new SingleProofreadingError[0]));
                    } else {
                        if (debugMode > 1) {
                            MessageHandler.printToLogFile("SingleCheck: checkParaRules: Enter " + (isMultiLingual ? "only para " : " ") + "errors to cache(" + cacheNum + "): Paragraph(" + nFPara + "): " + nFPara + "): " + paraText + "; Error number: " + 0);
                        }
                        this.paragraphsCache.get(cacheNum).put(nFPara, nextSentencePositions, new SingleProofreadingError[0]);
                    }
                }
                startSentencePos = this.paragraphsCache.get(cacheNum).getStartSentencePosition(nFPara, sentencePos);
                endSentencePos = this.paragraphsCache.get(cacheNum).getNextSentencePosition(nFPara, sentencePos);
                return this.paragraphsCache.get(cacheNum).getFromPara(nFPara, startSentencePos, endSentencePos, errType);
            }
            if (this.isDisposed()) {
                return null;
            }
            this.addParaErrorsToCache(nFPara, lt, cacheNum, parasToCheck, cacheNum == 0, textIsChanged, isIntern, footnotePos != null);
            return this.paragraphsCache.get(cacheNum).getFromPara(nFPara, startSentencePos, endSentencePos, errType);
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
            return null;
        }
    }

    private boolean isCorrectRuleMatch(RuleMatch ruleMatch, String text, Language lang) {
        if (!ruleMatch.getRule().isDictionaryBasedSpellingRule()) {
            return true;
        }
        String word = ruleMatch.getToPos() < text.length() ? text.substring(ruleMatch.getFromPos(), ruleMatch.getToPos()) : text.substring(ruleMatch.getFromPos());
        if (!this.mDocHandler.getLinguisticServices().isCorrectSpell(word, lang)) {
            if (debugMode > 0) {
                MessageHandler.printToLogFile("SingleCheck: checkParaRules: not correct spelled word: " + word + "; lang: " + lang.toString());
            }
            return true;
        }
        return false;
    }

    private SingleProofreadingError createOOoError(RuleMatch ruleMatch, int startIndex, int[] footnotes) {
        String[] allSuggestions;
        int numSuggestions;
        SingleProofreadingError aError = new SingleProofreadingError();
        aError.nErrorType = ruleMatch.getRule().isDictionaryBasedSpellingRule() ? 1 : 2;
        String msg = ruleMatch.getMessage();
        if (this.docLanguage != null) {
            msg = this.docLanguage.toAdvancedTypography(msg);
        }
        aError.aFullComment = msg = msg.replaceAll("<suggestion>", this.docLanguage == null ? "\"" : this.docLanguage.getOpeningDoubleQuote()).replaceAll("</suggestion>", this.docLanguage == null ? "\"" : this.docLanguage.getClosingDoubleQuote()).replaceAll("([\r]*\n)", " ");
        aError.aShortComment = !StringTools.isEmpty(ruleMatch.getShortMessage()) ? ruleMatch.getShortMessage() : aError.aFullComment;
        aError.aShortComment = Tools.shortenComment(aError.aShortComment);
        boolean noSuggestions = false;
        if (footnotes != null && footnotes.length > 0 && !ruleMatch.getSuggestedReplacements().isEmpty()) {
            int cor = 0;
            for (int n : footnotes) {
                if (n + cor <= ruleMatch.getFromPos() + startIndex) {
                    ++cor;
                    continue;
                }
                if (n + cor <= ruleMatch.getFromPos() + startIndex || n + cor > ruleMatch.getToPos() + startIndex) continue;
                noSuggestions = true;
                break;
            }
        }
        if (noSuggestions) {
            numSuggestions = 0;
            allSuggestions = new String[]{};
        } else {
            numSuggestions = ruleMatch.getSuggestedReplacements().size();
            allSuggestions = ruleMatch.getSuggestedReplacements().toArray(new String[numSuggestions]);
        }
        aError.aSuggestions = numSuggestions > 25 ? Arrays.copyOfRange(allSuggestions, 0, 25) : allSuggestions;
        aError.nErrorStart = ruleMatch.getFromPos() + startIndex;
        aError.nErrorLength = ruleMatch.getToPos() - ruleMatch.getFromPos();
        aError.aRuleIdentifier = ruleMatch.getRule().getId();
        Color underlineColor = this.config.getUnderlineColor(ruleMatch.getRule().getCategory().getName(), ruleMatch.getRule().getId());
        short underlineType = this.config.getUnderlineType(ruleMatch.getRule().getCategory().getName(), ruleMatch.getRule().getId());
        URL url = ruleMatch.getUrl();
        if (url == null) {
            url = ruleMatch.getRule().getUrl();
        }
        int nDim = 0;
        if (url != null) {
            ++nDim;
        }
        if (underlineColor != Color.blue || ruleMatch.getRule().isDictionaryBasedSpellingRule()) {
            ++nDim;
        }
        if (underlineType != 10 || this.config.markSingleCharBold() && aError.nErrorLength == 1) {
            ++nDim;
        }
        if (nDim > 0) {
            PropertyValue[] propertyValues = new PropertyValue[nDim];
            int n = 0;
            if (url != null) {
                propertyValues[n] = new PropertyValue("FullCommentURL", -1, (Object)url.toString(), PropertyState.DIRECT_VALUE);
                ++n;
            }
            if (ruleMatch.getRule().isDictionaryBasedSpellingRule()) {
                int ucolor = Color.red.getRGB() & 0xFFFFFF;
                propertyValues[n] = new PropertyValue("LineColor", -1, (Object)ucolor, PropertyState.DIRECT_VALUE);
                ++n;
            } else if (underlineColor != Color.blue) {
                int ucolor = underlineColor.getRGB() & 0xFFFFFF;
                propertyValues[n] = new PropertyValue("LineColor", -1, (Object)ucolor, PropertyState.DIRECT_VALUE);
                ++n;
            }
            if (underlineType != 10) {
                propertyValues[n] = new PropertyValue("LineType", -1, (Object)underlineType, PropertyState.DIRECT_VALUE);
            } else if (this.config.markSingleCharBold() && aError.nErrorLength == 1) {
                propertyValues[n] = new PropertyValue("LineType", -1, (Object)18, PropertyState.DIRECT_VALUE);
            }
            aError.aProperties = propertyValues;
        } else {
            aError.aProperties = new PropertyValue[0];
        }
        return aError;
    }

    public static List<Integer> getNextSentencePositions(String paraText, SwJLanguageTool lt) {
        ArrayList<Integer> nextSentencePositions = new ArrayList<Integer>();
        if (paraText == null || paraText.isEmpty()) {
            nextSentencePositions.add(0);
            return nextSentencePositions;
        }
        if (lt == null || lt.isRemote()) {
            nextSentencePositions.add(paraText.length());
        } else {
            List<String> tokenizedSentences = lt.sentenceTokenize(SingleCheck.cleanFootnotes(paraText));
            int position = 0;
            for (String sentence : tokenizedSentences) {
                nextSentencePositions.add(position += sentence.length());
            }
            if (((Integer)nextSentencePositions.get(nextSentencePositions.size() - 1)).intValue() != paraText.length()) {
                nextSentencePositions.set(nextSentencePositions.size() - 1, paraText.length());
            }
        }
        return nextSentencePositions;
    }

    static String cleanFootnotes(String paraText) {
        return paraText.replaceAll("([^\\d][.!?])\\d ", "$1\u00b9 ");
    }

    static String removeFootnotes(String paraText, int[] footnotes, List<Integer> deletedChars) {
        if (paraText == null) {
            return null;
        }
        if (deletedChars == null || deletedChars.isEmpty()) {
            if (footnotes == null) {
                return SingleCheck.cleanFootnotes(paraText);
            }
            for (int i = footnotes.length - 1; i >= 0; --i) {
                if (footnotes[i] >= paraText.length()) continue;
                paraText = paraText.substring(0, footnotes[i]) + paraText.substring(footnotes[i] + 1);
            }
        } else if (footnotes == null || footnotes.length == 0) {
            if (footnotes == null) {
                paraText = SingleCheck.cleanFootnotes(paraText);
            }
            for (int i = deletedChars.size() - 1; i >= 0; --i) {
                if (deletedChars.get(i) >= paraText.length()) continue;
                paraText = paraText.substring(0, deletedChars.get(i)) + paraText.substring(deletedChars.get(i) + 1);
            }
        } else {
            int idc = deletedChars.size() - 1;
            int ifn = footnotes.length - 1;
            while (idc >= 0 || ifn >= 0) {
                if (idc >= 0 && (ifn < 0 || deletedChars.get(idc) >= footnotes[ifn])) {
                    if (deletedChars.get(idc) < paraText.length()) {
                        paraText = paraText.substring(0, deletedChars.get(idc)) + paraText.substring(deletedChars.get(idc) + 1);
                    }
                    if (ifn >= 0 && deletedChars.get(idc) == footnotes[ifn]) {
                        --ifn;
                    }
                    --idc;
                    continue;
                }
                if (footnotes[ifn] < paraText.length()) {
                    paraText = paraText.substring(0, footnotes[ifn]) + paraText.substring(footnotes[ifn] + 1);
                }
                --ifn;
            }
        }
        return paraText;
    }

    protected static SingleProofreadingError correctRuleMatchWithFootnotes(SingleProofreadingError pError, int[] footnotes, List<Integer> deletedChars) {
        if (deletedChars == null || deletedChars.isEmpty()) {
            if (footnotes == null || footnotes.length == 0) {
                return pError;
            }
            for (int i : footnotes) {
                if (i <= pError.nErrorStart) {
                    ++pError.nErrorStart;
                    continue;
                }
                if (i >= pError.nErrorStart + pError.nErrorLength) continue;
                ++pError.nErrorLength;
            }
        } else if (footnotes == null || footnotes.length == 0) {
            for (int i : deletedChars) {
                if (i <= pError.nErrorStart) {
                    ++pError.nErrorStart;
                    continue;
                }
                if (i >= pError.nErrorStart + pError.nErrorLength) continue;
                ++pError.nErrorLength;
            }
        } else {
            int ifn = 0;
            int idc = 0;
            while (ifn < footnotes.length || idc < deletedChars.size()) {
                if (idc < deletedChars.size() && (ifn >= footnotes.length || deletedChars.get(idc) < footnotes[ifn])) {
                    if (deletedChars.get(idc) <= pError.nErrorStart) {
                        ++pError.nErrorStart;
                    } else if (deletedChars.get(idc) < pError.nErrorStart + pError.nErrorLength) {
                        ++pError.nErrorLength;
                    }
                    if (ifn < footnotes.length && deletedChars.get(idc) == footnotes[ifn]) {
                        ++ifn;
                    }
                    ++idc;
                    continue;
                }
                if (footnotes[ifn] <= pError.nErrorStart) {
                    ++pError.nErrorStart;
                } else if (footnotes[ifn] < pError.nErrorStart + pError.nErrorLength) {
                    ++pError.nErrorLength;
                }
                ++ifn;
            }
        }
        return pError;
    }

    private List<SentenceErrors> getSentencesErrosAsList(int numberOfParagraph, SwJLanguageTool lt, OfficeTools.LoErrorType errType) {
        ArrayList<SentenceErrors> sentenceErrors = new ArrayList<SentenceErrors>();
        if (!this.isDisposed()) {
            ResultCache.CacheEntry entry = this.paragraphsCache.get(0).getCacheEntry(numberOfParagraph);
            List<Integer> nextSentencePositions = null;
            if (entry != null) {
                nextSentencePositions = entry.nextSentencePositions;
            }
            if (nextSentencePositions == null) {
                nextSentencePositions = new ArrayList<Integer>();
            }
            if (nextSentencePositions.size() == 0 && this.docCache != null && numberOfParagraph >= 0 && numberOfParagraph < this.docCache.size()) {
                nextSentencePositions = SingleCheck.getNextSentencePositions(this.docCache.getFlatParagraph(numberOfParagraph), lt);
            }
            int startPosition = 0;
            if (nextSentencePositions.size() == 1) {
                ArrayList<SingleProofreadingError[]> errorList = new ArrayList<SingleProofreadingError[]>();
                for (ResultCache cache : this.paragraphsCache) {
                    errorList.add(cache.getMatches(numberOfParagraph, errType));
                }
                sentenceErrors.add(new SentenceErrors(startPosition, nextSentencePositions.get(0), this.singleDocument.mergeErrors(errorList, numberOfParagraph)));
            } else {
                for (int nextPosition : nextSentencePositions) {
                    ArrayList<SingleProofreadingError[]> errorList = new ArrayList<SingleProofreadingError[]>();
                    for (ResultCache cache : this.paragraphsCache) {
                        errorList.add(cache.getFromPara(numberOfParagraph, startPosition, nextPosition, errType));
                    }
                    sentenceErrors.add(new SentenceErrors(startPosition, nextPosition, this.singleDocument.mergeErrors(errorList, numberOfParagraph)));
                    startPosition = nextPosition;
                }
            }
        }
        return sentenceErrors;
    }

    public static class SentenceErrors {
        final int sentenceStart;
        final int sentenceEnd;
        final SingleProofreadingError[] sentenceErrors;

        public SentenceErrors(int start, int end, SingleProofreadingError[] errors) {
            this.sentenceStart = start;
            this.sentenceEnd = end;
            this.sentenceErrors = errors;
        }
    }
}

