/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.linguistic2.SingleProofreadingError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.languagetool.openoffice.OfficeTools;

public class ResultCache
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final Map<Integer, SerialCacheEntry> entries = new HashMap<Integer, SerialCacheEntry>();
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public ResultCache() {
        this(null);
    }

    public ResultCache(ResultCache cache) {
        this.replace(cache);
    }

    private Map<Integer, SerialCacheEntry> getMap() {
        this.rwLock.readLock().lock();
        try {
            HashMap<Integer, SerialCacheEntry> hashMap = new HashMap<Integer, SerialCacheEntry>(this.entries);
            return hashMap;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void replace(ResultCache cache) {
        this.rwLock.writeLock().lock();
        try {
            this.entries.clear();
            if (cache != null && !cache.entries.isEmpty()) {
                this.entries.putAll(cache.getMap());
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void remove(int numberOfParagraph) {
        this.rwLock.writeLock().lock();
        try {
            this.entries.remove(numberOfParagraph);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(int firstParagraph, int lastParagraph) {
        this.rwLock.writeLock().lock();
        try {
            for (int i = firstParagraph; i <= lastParagraph; ++i) {
                this.entries.remove(i);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAndShift(int fromParagraph, int toParagraph, int oldSize, int newSize) {
        int shift = newSize - oldSize;
        if (fromParagraph < 0 && toParagraph >= newSize) {
            return;
        }
        this.rwLock.writeLock().lock();
        try {
            HashMap<Integer, SerialCacheEntry> tmpEntries = new HashMap<Integer, SerialCacheEntry>(this.entries);
            this.entries.clear();
            if (shift < 0) {
                Iterator iterator = tmpEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (i < fromParagraph) {
                        this.entries.put(i, (SerialCacheEntry)tmpEntries.get(i));
                        continue;
                    }
                    if (i < toParagraph - shift) continue;
                    this.entries.put(i + shift, (SerialCacheEntry)tmpEntries.get(i));
                }
            } else {
                Iterator iterator = tmpEntries.keySet().iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (i < fromParagraph) {
                        this.entries.put(i, (SerialCacheEntry)tmpEntries.get(i));
                        continue;
                    }
                    if (i < toParagraph) continue;
                    this.entries.put(i + shift, (SerialCacheEntry)tmpEntries.get(i));
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(int numberOfParagraph, List<Integer> nextSentencePositions, SingleProofreadingError[] errorArray) {
        this.rwLock.writeLock().lock();
        try {
            this.entries.put(numberOfParagraph, new SerialCacheEntry(nextSentencePositions, errorArray));
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void put(int numberOfParagraph, SingleProofreadingError[] errorArray) {
        this.rwLock.writeLock().lock();
        try {
            this.entries.put(numberOfParagraph, new SerialCacheEntry(null, errorArray));
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int numberOfParagraph, SingleProofreadingError[] errorArray) {
        this.rwLock.writeLock().lock();
        try {
            SerialCacheEntry cacheEntry = this.entries.get(numberOfParagraph);
            cacheEntry.addErrorArray(errorArray);
            this.entries.put(numberOfParagraph, cacheEntry);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void removeAll() {
        this.rwLock.writeLock().lock();
        try {
            this.entries.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public int size() {
        this.rwLock.readLock().lock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberofNotNullEntries() {
        this.rwLock.readLock().lock();
        try {
            int num = 0;
            for (int n : this.entries.keySet()) {
                if (this.entries.get(n) == null) continue;
                ++num;
            }
            int n = num;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberofErrors() {
        this.rwLock.readLock().lock();
        try {
            int num = 0;
            for (int n : this.entries.keySet()) {
                if (this.entries.get(n) == null) continue;
                num += this.entries.get((Object)Integer.valueOf((int)n)).errorArray.length;
            }
            int n = num;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntry getCacheEntry(int numberOfParagraph) {
        this.rwLock.readLock().lock();
        try {
            SerialCacheEntry entry = this.entries.get(numberOfParagraph);
            CacheEntry cacheEntry = entry == null ? null : new CacheEntry(entry);
            return cacheEntry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public CacheEntry getUnsafeCacheEntry(int numberOfParagraph) {
        SerialCacheEntry entry = this.entries.get(numberOfParagraph);
        return entry == null ? null : new CacheEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnError(int limit) {
        this.rwLock.readLock().lock();
        try {
            if (this.entries.size() >= limit) {
                boolean bl = true;
                return bl;
            }
            HashSet<Integer> paras = new HashSet<Integer>(this.entries.keySet());
            Iterator iterator = paras.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (this.entries.get((Object)Integer.valueOf((int)n)).errorArray.length <= 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public SerialCacheEntry getSerialCacheEntry(int numberOfParagraph) {
        this.rwLock.readLock().lock();
        try {
            SerialCacheEntry serialCacheEntry = this.entries.get(numberOfParagraph);
            return serialCacheEntry;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleProofreadingError[] getSafeMatches(int numberOfParagraph) {
        this.rwLock.readLock().lock();
        try {
            SerialCacheEntry entry = this.entries.get(numberOfParagraph);
            if (entry == null) {
                SingleProofreadingError[] singleProofreadingErrorArray = null;
                return singleProofreadingErrorArray;
            }
            if (entry.errorArray == null) {
                SingleProofreadingError[] singleProofreadingErrorArray = new SingleProofreadingError[]{};
                return singleProofreadingErrorArray;
            }
            SingleProofreadingError[] singleProofreadingErrorArray = entry.getErrorArray();
            return singleProofreadingErrorArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleProofreadingError[] getMatches(int numberOfParagraph, OfficeTools.LoErrorType errType) {
        this.rwLock.readLock().lock();
        try {
            SerialCacheEntry entry = this.entries.get(numberOfParagraph);
            if (entry == null) {
                SingleProofreadingError[] singleProofreadingErrorArray = null;
                return singleProofreadingErrorArray;
            }
            SingleProofreadingError[] errorArray = entry.getErrorArray();
            if (errType == OfficeTools.LoErrorType.BOTH || errorArray == null || errorArray.length == 0) {
                SingleProofreadingError[] singleProofreadingErrorArray = errorArray;
                return singleProofreadingErrorArray;
            }
            ArrayList<SingleProofreadingError> errorList = new ArrayList<SingleProofreadingError>();
            for (SingleProofreadingError eArray : errorArray) {
                if ((errType != OfficeTools.LoErrorType.GRAMMAR || eArray.nErrorType != 2) && (errType != OfficeTools.LoErrorType.SPELL || eArray.nErrorType != 1)) continue;
                errorList.add(eArray);
            }
            SingleProofreadingError[] singleProofreadingErrorArray = errorList.toArray(new SingleProofreadingError[errorList.size()]);
            return singleProofreadingErrorArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartSentencePosition(int numberOfParagraph, int sentencePosition) {
        this.rwLock.readLock().lock();
        try {
            SerialCacheEntry entry = this.entries.get(numberOfParagraph);
            if (entry == null) {
                int n = 0;
                return n;
            }
            List<Integer> nextSentencePositions = entry.nextSentencePositions;
            if (nextSentencePositions == null || nextSentencePositions.size() < 2) {
                int n = 0;
                return n;
            }
            int startPosition = 0;
            for (int position : nextSentencePositions) {
                if (position >= sentencePosition) {
                    int n = position == sentencePosition ? position : startPosition;
                    return n;
                }
                startPosition = position;
            }
            int n = nextSentencePositions.get(nextSentencePositions.size() - 2);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextSentencePosition(int numberOfParagraph, int sentencePosition) {
        this.rwLock.readLock().lock();
        try {
            SerialCacheEntry entry = this.entries.get(numberOfParagraph);
            if (entry == null) {
                int n = 0;
                return n;
            }
            List<Integer> nextSentencePositions = entry.nextSentencePositions;
            if (nextSentencePositions == null || nextSentencePositions.size() == 0) {
                int n = 0;
                return n;
            }
            for (int position : nextSentencePositions) {
                if (position <= sentencePosition) continue;
                int n = position;
                return n;
            }
            int n = nextSentencePositions.get(nextSentencePositions.size() - 1);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleProofreadingError[] getFromPara(int numberOfParagraph, int startOfSentencePosition, int endOfSentencePosition, OfficeTools.LoErrorType errType) {
        this.rwLock.readLock().lock();
        try {
            SerialCacheEntry entry = this.entries.get(numberOfParagraph);
            if (entry == null) {
                SingleProofreadingError[] singleProofreadingErrorArray = null;
                return singleProofreadingErrorArray;
            }
            ArrayList<SingleProofreadingError> errorList = new ArrayList<SingleProofreadingError>();
            for (SingleProofreadingError eArray : entry.getErrorArray()) {
                if (errType != OfficeTools.LoErrorType.BOTH && (errType != OfficeTools.LoErrorType.GRAMMAR || eArray.nErrorType != 2) && (errType != OfficeTools.LoErrorType.SPELL || eArray.nErrorType != 1) || eArray.nErrorStart < startOfSentencePosition || eArray.nErrorStart >= endOfSentencePosition) continue;
                errorList.add(eArray);
            }
            SingleProofreadingError[] singleProofreadingErrorArray = errorList.toArray(new SingleProofreadingError[0]);
            return singleProofreadingErrorArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public static boolean areDifferentEntries(SerialCacheEntry newEntries, SerialCacheEntry oldEntries) {
        if (newEntries == null || oldEntries == null) {
            return true;
        }
        SingleProofreadingError[] oldErrorArray = oldEntries.getErrorArray();
        SingleProofreadingError[] newErrorArray = newEntries.getErrorArray();
        if (oldErrorArray == null || newErrorArray == null || oldErrorArray.length != newErrorArray.length) {
            return true;
        }
        for (SingleProofreadingError nError : newErrorArray) {
            if (nError.nErrorType == 1) continue;
            boolean found = false;
            for (SingleProofreadingError oError : oldErrorArray) {
                if (nError.nErrorType == 1 || nError.nErrorStart != oError.nErrorStart || nError.nErrorLength != oError.nErrorLength || !nError.aRuleIdentifier.equals(oError.aRuleIdentifier)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmptyEntry(SerialCacheEntry entry) {
        return entry == null || entry.errorArray == null || entry.errorArray.length == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> differenceInCaches(ResultCache oldCache) {
        this.rwLock.readLock().lock();
        try {
            ArrayList<Integer> differentParas = new ArrayList<Integer>();
            boolean isDifferent = true;
            HashSet<Integer> entrySet = new HashSet<Integer>(this.entries.keySet());
            Object object = entrySet.iterator();
            while (object.hasNext()) {
                int nPara = (Integer)object.next();
                if (oldCache != null) {
                    SerialCacheEntry nEntry = this.entries.get(nPara);
                    SerialCacheEntry oEntry = oldCache.entries.get(nPara);
                    isDifferent = ResultCache.areDifferentEntries(nEntry, oEntry);
                }
                if (!isDifferent) continue;
                differentParas.add(nPara);
            }
            object = differentParas;
            return object;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> removeRuleError(String ruleId) {
        this.rwLock.writeLock().lock();
        try {
            ArrayList<Integer> changed = new ArrayList<Integer>();
            Set<Integer> keySet = this.entries.keySet();
            Object object = keySet.iterator();
            while (object.hasNext()) {
                int n = object.next();
                SerialCacheEntry entry = this.entries.get(n);
                SingleProofreadingError[] eArray = entry.getErrorArray();
                int nErr = 0;
                for (SingleProofreadingError sError : eArray) {
                    if (!sError.aRuleIdentifier.equals(ruleId)) continue;
                    ++nErr;
                }
                if (nErr <= 0) continue;
                changed.add(n);
                SingleProofreadingError[] newArray = new SingleProofreadingError[eArray.length - nErr];
                int j = 0;
                for (int i = 0; i < eArray.length && j < newArray.length; ++i) {
                    if (eArray[i].aRuleIdentifier.equals(ruleId)) continue;
                    newArray[j] = eArray[i];
                    ++j;
                }
                this.entries.put(n, new SerialCacheEntry(entry.nextSentencePositions, newArray));
            }
            object = changed;
            return object;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public int getNumberOfParas() {
        this.rwLock.readLock().lock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int getNumberOfEntries() {
        this.rwLock.readLock().lock();
        try {
            int n = this.entries.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfMatches() {
        this.rwLock.readLock().lock();
        try {
            int number = 0;
            for (int n : this.entries.keySet()) {
                number += this.entries.get((Object)Integer.valueOf((int)n)).errorArray.length;
            }
            int n = number;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SingleProofreadingError getErrorAtPosition(int numPara, int numChar) {
        this.rwLock.readLock().lock();
        try {
            SerialCacheEntry entry = this.entries.get(numPara);
            if (entry == null) {
                SingleProofreadingError singleProofreadingError = null;
                return singleProofreadingError;
            }
            SingleProofreadingError error = null;
            for (SingleProofreadingError err : entry.getErrorArray()) {
                if (numChar < err.nErrorStart || numChar > err.nErrorStart + err.nErrorLength || error != null && error.nErrorStart >= err.nErrorStart && (error.nErrorStart != err.nErrorStart || error.nErrorLength <= err.nErrorLength)) continue;
                error = err;
            }
            SingleProofreadingError[] singleProofreadingErrorArray = error;
            return singleProofreadingErrorArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private class SerialPropertyValue
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String name;
        Object value;

        SerialPropertyValue(PropertyValue properties) {
            this.name = properties.Name;
            this.value = properties.Value;
        }

        PropertyValue toPropertyValue() {
            PropertyValue properties = new PropertyValue();
            properties.Name = this.name;
            properties.Value = this.value;
            properties.Handle = -1;
            properties.State = PropertyState.DIRECT_VALUE;
            return properties;
        }
    }

    private class SerialProofreadingError
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int nErrorStart;
        int nErrorLength;
        int nErrorType;
        String aFullComment;
        String aRuleIdentifier;
        String aShortComment;
        String[] aSuggestions;
        SerialPropertyValue[] aProperties = null;

        SerialProofreadingError(SingleProofreadingError error) {
            this.nErrorStart = error.nErrorStart;
            this.nErrorLength = error.nErrorLength;
            this.nErrorType = error.nErrorType;
            this.aFullComment = error.aFullComment;
            this.aRuleIdentifier = error.aRuleIdentifier;
            this.aShortComment = error.aShortComment;
            this.aSuggestions = error.aSuggestions;
            if (error.aProperties != null) {
                this.aProperties = new SerialPropertyValue[error.aProperties.length];
                for (int i = 0; i < error.aProperties.length; ++i) {
                    this.aProperties[i] = new SerialPropertyValue(error.aProperties[i]);
                }
            }
        }

        SingleProofreadingError toSingleProofreadingError() {
            SingleProofreadingError error = new SingleProofreadingError();
            error.nErrorStart = this.nErrorStart;
            error.nErrorLength = this.nErrorLength;
            error.nErrorType = this.nErrorType;
            error.aFullComment = this.aFullComment;
            error.aRuleIdentifier = this.aRuleIdentifier;
            error.aShortComment = this.aShortComment;
            error.aSuggestions = this.aSuggestions;
            if (this.aProperties != null) {
                error.aProperties = new PropertyValue[this.aProperties.length];
                for (int i = 0; i < this.aProperties.length; ++i) {
                    error.aProperties[i] = this.aProperties[i].toPropertyValue();
                }
            } else {
                error.aProperties = null;
            }
            return error;
        }
    }

    class SerialCacheEntry
    implements Serializable {
        private static final long serialVersionUID = 2L;
        SerialProofreadingError[] errorArray;
        List<Integer> nextSentencePositions = null;

        SerialCacheEntry(List<Integer> nextSentencePositions, SingleProofreadingError[] sErrorArray) {
            if (nextSentencePositions != null) {
                this.nextSentencePositions = new ArrayList<Integer>(nextSentencePositions);
            }
            this.errorArray = new SerialProofreadingError[sErrorArray.length];
            for (int i = 0; i < sErrorArray.length; ++i) {
                this.errorArray[i] = new SerialProofreadingError(sErrorArray[i]);
            }
        }

        SingleProofreadingError[] getErrorArray() {
            SingleProofreadingError[] eArray = new SingleProofreadingError[this.errorArray.length];
            for (int i = 0; i < this.errorArray.length; ++i) {
                eArray[i] = this.errorArray[i].toSingleProofreadingError();
            }
            return eArray;
        }

        int getErrorSize() {
            return this.errorArray.length;
        }

        void addErrorArray(SingleProofreadingError[] errors) {
            int i;
            if (errors == null || errors.length == 0) {
                return;
            }
            SerialProofreadingError[] newErrorArray = new SerialProofreadingError[this.errorArray.length + errors.length];
            for (i = 0; i < this.errorArray.length; ++i) {
                newErrorArray[i] = this.errorArray[i];
            }
            for (i = 0; i < errors.length; ++i) {
                newErrorArray[this.errorArray.length + i] = new SerialProofreadingError(errors[i]);
            }
        }
    }

    public static class CacheEntry {
        public SingleProofreadingError[] errorArray;
        public List<Integer> nextSentencePositions = null;

        CacheEntry(SerialCacheEntry entry) {
            if (entry.nextSentencePositions != null) {
                this.nextSentencePositions = new ArrayList<Integer>(entry.nextSentencePositions);
            }
            this.errorArray = new SingleProofreadingError[entry.errorArray.length];
            for (int i = 0; i < entry.errorArray.length; ++i) {
                this.errorArray[i] = entry.errorArray[i].toSingleProofreadingError();
            }
        }

        public SingleProofreadingError[] getErrorArray() {
            return this.errorArray;
        }
    }
}

