/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.awt.XMenuBar;
import com.sun.star.awt.XPopupMenu;
import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XDispatchHelper;
import com.sun.star.frame.XDispatchProvider;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XLayoutManager;
import com.sun.star.frame.XModel;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.linguistic2.XProofreadingIterator;
import com.sun.star.linguistic2.XSearchableDictionaryList;
import com.sun.star.text.XTextDocument;
import com.sun.star.ui.XUIElement;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.openoffice.DocumentCursorTools;
import org.languagetool.openoffice.FlatParagraphTools;
import org.languagetool.openoffice.LtDictionary;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.ViewCursorTools;
import org.languagetool.rules.AbstractStatisticSentenceStyleRule;
import org.languagetool.rules.AbstractStatisticStyleRule;
import org.languagetool.rules.AbstractStyleTooOftenUsedWordRule;
import org.languagetool.rules.ReadabilityRule;
import org.languagetool.rules.Rule;

public class OfficeTools {
    public static final String EXTENSION_MAINTAINER = "Fred Kruse";
    public static final String LT_SERVICE_NAME = "org.languagetool.openoffice.Main";
    public static final String LT_SPELL_SERVICE_NAME = "org.languagetool.openoffice.LanguageToolSpellChecker";
    public static final int PROOFINFO_UNKNOWN = 0;
    public static final int PROOFINFO_GET_PROOFRESULT = 1;
    public static final int PROOFINFO_MARK_PARAGRAPH = 2;
    public static final String END_OF_PARAGRAPH = "\n\n";
    public static final int NUMBER_PARAGRAPH_CHARS = "\n\n".length();
    public static final String SINGLE_END_OF_PARAGRAPH = "\n";
    public static final String MANUAL_LINEBREAK = "\r";
    public static final String ZERO_WIDTH_SPACE = "\u200b";
    public static final char ZERO_WIDTH_SPACE_CHAR = '\u200b';
    public static final String IGNORE_LANGUAGE = "zxx";
    public static final String LOG_LINE_BREAK = System.lineSeparator();
    public static final int MAX_SUGGESTIONS = 25;
    public static final int NUMBER_TEXTLEVEL_CACHE = 4;
    public static final String MULTILINGUAL_LABEL = "99-";
    public static final int CHECK_MULTIPLIKATOR = 40;
    public static final int CHECK_SHAPES_TIME = 1000;
    public static final int SPELL_CHECK_MIN_HEAP = 850;
    public static int TIME_TOLERANCE = 100;
    public static int DEBUG_MODE_SD = 0;
    public static int DEBUG_MODE_SC = 0;
    public static int DEBUG_MODE_CR = 0;
    public static boolean DEBUG_MODE_MD = false;
    public static boolean DEBUG_MODE_DC = false;
    public static boolean DEBUG_MODE_FP = false;
    public static boolean DEBUG_MODE_LM = false;
    public static boolean DEBUG_MODE_TQ = false;
    public static boolean DEBUG_MODE_LD = false;
    public static boolean DEBUG_MODE_CD = false;
    public static boolean DEBUG_MODE_IO = false;
    public static boolean DEBUG_MODE_SR = false;
    public static boolean DEBUG_MODE_TM = false;
    public static boolean DEVELOP_MODE_ST = false;
    public static boolean DEVELOP_MODE = false;
    public static final String CONFIG_FILE = "Languagetool.cfg";
    public static final String OOO_CONFIG_FILE = "Languagetool-ooo.cfg";
    private static final String OLD_CONFIG_FILE = ".languagetool-ooo.cfg";
    private static final String LOG_FILE = "LanguageTool.log";
    public static final String STATISTICAL_ANALYZES_CONFIG_FILE = "LT_Statistical_Analyzes.cfg";
    private static final String VENDOR_ID = "languagetool.org";
    private static final String APPLICATION_ID = "LanguageTool";
    private static final String CACHE_ID = "cache";
    private static String OFFICE_EXTENSION_ID = null;
    private static OfficeProductInfo OFFICE_PRODUCT_INFO = null;
    private static final String MENU_BAR = "private:resource/menubar/menubar";
    private static final String LOG_DELIMITER = ",";
    private static final double LT_HEAP_LIMIT_FACTOR = 0.9;
    private static double MAX_HEAP_SPACE = -1.0;
    private static double LT_HEAP_LIMIT = -1.0;
    private static final int MAX_LO_WAITS = 3000;
    private static int numLoWaits = 0;
    private static Object waitObj = new Object();

    @Nullable
    static XDesktop getDesktop(XComponentContext xContext) {
        try {
            if (xContext == null) {
                return null;
            }
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
            if (xMCF == null) {
                return null;
            }
            Object desktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            if (desktop == null) {
                return null;
            }
            return (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    @Nullable
    public static XComponent getCurrentComponent(XComponentContext xContext) {
        try {
            XDesktop xdesktop = OfficeTools.getDesktop(xContext);
            if (xdesktop == null) {
                return null;
            }
            return xdesktop.getCurrentComponent();
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    @Nullable
    static XTextDocument getCurrentDocument(XComponentContext xContext) {
        try {
            XComponent curComp = OfficeTools.getCurrentComponent(xContext);
            if (curComp == null) {
                return null;
            }
            return (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)curComp);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    static void printPropertySet(Object o) {
        XPropertySet propSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)o);
        if (propSet == null) {
            MessageHandler.printToLogFile("OfficeTools: printPropertySet: XPropertySet == null");
            return;
        }
        XPropertySetInfo propertySetInfo = propSet.getPropertySetInfo();
        MessageHandler.printToLogFile("OfficeTools: printPropertySet: PropertySet:");
        for (Property property : propertySetInfo.getProperties()) {
            MessageHandler.printToLogFile("Name: " + property.Name + ", Type: " + property.Type.getTypeName());
        }
    }

    @Nullable
    static XSearchableDictionaryList getSearchableDictionaryList(XComponentContext xContext) {
        try {
            if (xContext == null) {
                return null;
            }
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
            if (xMCF == null) {
                return null;
            }
            Object dictionaryList = xMCF.createInstanceWithContext("com.sun.star.linguistic2.DictionaryList", xContext);
            if (dictionaryList == null) {
                return null;
            }
            return (XSearchableDictionaryList)UnoRuntime.queryInterface(XSearchableDictionaryList.class, (Object)dictionaryList);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    @Nullable
    static XProofreadingIterator getProofreadingIterator(XComponentContext xContext) {
        try {
            if (xContext == null) {
                return null;
            }
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
            if (xMCF == null) {
                return null;
            }
            Object proofreadingIterator = xMCF.createInstanceWithContext("com.sun.star.linguistic2.ProofreadingIterator", xContext);
            if (proofreadingIterator == null) {
                return null;
            }
            return (XProofreadingIterator)UnoRuntime.queryInterface(XProofreadingIterator.class, (Object)proofreadingIterator);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    static XMenuBar getMenuBar(XComponent xComponent) {
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            if (xModel == null) {
                MessageHandler.printToLogFile("SingleDocument: setDokumentListener: XModel not found!");
                return null;
            }
            XController xController = xModel.getCurrentController();
            if (xController == null) {
                MessageHandler.printToLogFile("SingleDocument: setDokumentListener: XController not found!");
                return null;
            }
            XFrame frame = xController.getFrame();
            if (frame == null) {
                return null;
            }
            XPropertySet propSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)frame);
            if (propSet == null) {
                return null;
            }
            XLayoutManager layoutManager = (XLayoutManager)UnoRuntime.queryInterface(XLayoutManager.class, (Object)propSet.getPropertyValue("LayoutManager"));
            if (layoutManager == null) {
                return null;
            }
            XUIElement oMenuBar = layoutManager.getElement(MENU_BAR);
            XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oMenuBar);
            return (XMenuBar)UnoRuntime.queryInterface(XMenuBar.class, (Object)props.getPropertyValue("XMenuBar"));
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    @Nullable
    static XPopupMenu getPopupMenu(XComponentContext xContext) {
        try {
            if (xContext == null) {
                return null;
            }
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
            if (xMCF == null) {
                return null;
            }
            Object oPopupMenu = xMCF.createInstanceWithContext("com.sun.star.awt.PopupMenu", xContext);
            if (oPopupMenu == null) {
                return null;
            }
            return (XPopupMenu)UnoRuntime.queryInterface(XPopupMenu.class, (Object)oPopupMenu);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    public static boolean dispatchCmd(String cmd, XComponentContext xContext) {
        return OfficeTools.dispatchCmd(cmd, new PropertyValue[0], xContext);
    }

    public static boolean dispatchUnoCmd(String cmd, XComponentContext xContext) {
        return OfficeTools.dispatchCmd(".uno:" + cmd, new PropertyValue[0], xContext);
    }

    public static boolean dispatchCmd(String cmd, PropertyValue[] props, XComponentContext xContext) {
        try {
            if (xContext == null) {
                MessageHandler.printToLogFile("OfficeTools: dispatchCmd: xContext == null");
                return false;
            }
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
            if (xMCF == null) {
                MessageHandler.printToLogFile("OfficeTools: dispatchCmd: xMCF == null");
                return false;
            }
            Object desktop = xMCF.createInstanceWithContext("com.sun.star.frame.Desktop", xContext);
            if (desktop == null) {
                MessageHandler.printToLogFile("OfficeTools: dispatchCmd: desktop == null");
                return false;
            }
            XDesktop xdesktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktop);
            if (xdesktop == null) {
                MessageHandler.printToLogFile("OfficeTools: dispatchCmd: xdesktop == null");
                return false;
            }
            Object helper = xMCF.createInstanceWithContext("com.sun.star.frame.DispatchHelper", xContext);
            if (helper == null) {
                MessageHandler.printToLogFile("OfficeTools: dispatchCmd: helper == null");
                return false;
            }
            XDispatchHelper dispatchHelper = (XDispatchHelper)UnoRuntime.queryInterface(XDispatchHelper.class, (Object)helper);
            if (dispatchHelper == null) {
                MessageHandler.printToLogFile("OfficeTools: dispatchCmd: dispatchHelper == null");
                return false;
            }
            XDispatchProvider provider = (XDispatchProvider)UnoRuntime.queryInterface(XDispatchProvider.class, (Object)xdesktop.getCurrentFrame());
            if (provider == null) {
                MessageHandler.printToLogFile("OfficeTools: dispatchCmd: provider == null");
                return false;
            }
            dispatchHelper.executeDispatch(provider, cmd, "", 0, props);
            return true;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return false;
        }
    }

    static String localeToString(Locale locale) {
        if (locale == null) {
            return null;
        }
        return locale.Language + (locale.Country.isEmpty() ? "" : "-" + locale.Country) + (locale.Variant.isEmpty() ? "" : "-" + locale.Variant);
    }

    static boolean isEqualLocale(Locale locale1, Locale locale2) {
        return locale1.Language.equals(locale2.Language) && locale1.Country.equals(locale2.Country) && locale1.Variant.equals(locale2.Variant);
    }

    static boolean containsLocale(List<Locale> locales, Locale locale) {
        for (Locale loc : locales) {
            if (!OfficeTools.isEqualLocale(loc, locale)) continue;
            return true;
        }
        return false;
    }

    public static File getOldConfigFile() {
        String homeDir = System.getProperty("user.home");
        if (homeDir == null) {
            MessageHandler.showError(new RuntimeException("Could not get home directory"));
            return null;
        }
        return new File(homeDir, OLD_CONFIG_FILE);
    }

    public static File getLOConfigDir() {
        return OfficeTools.getLOConfigDir(null);
    }

    public static File getLOConfigDir(XComponentContext xContext) {
        File directory;
        if (OFFICE_EXTENSION_ID == null) {
            OFFICE_EXTENSION_ID = xContext == null ? "LibreOffice" : OfficeTools.getOfficeProductInfo((XComponentContext)xContext).ooName;
        }
        String userHome = null;
        try {
            userHome = System.getProperty("user.home");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (userHome == null) {
            MessageHandler.showError(new RuntimeException("Could not get home directory"));
            directory = null;
        } else if (SystemUtils.IS_OS_WINDOWS) {
            String path;
            File appDataDir = null;
            try {
                String appData = System.getenv("APPDATA");
                if (!StringUtils.isEmpty(appData)) {
                    appDataDir = new File(appData);
                }
            }
            catch (SecurityException appData) {
                // empty catch block
            }
            if (appDataDir != null && appDataDir.isDirectory()) {
                path = "languagetool.org\\LanguageTool\\" + OFFICE_EXTENSION_ID + "\\";
                directory = new File(appDataDir, path);
            } else {
                path = "Application Data\\languagetool.org\\LanguageTool\\" + OFFICE_EXTENSION_ID + "\\";
                directory = new File(userHome, path);
            }
        } else if (SystemUtils.IS_OS_LINUX) {
            String path;
            File appDataDir = null;
            try {
                String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
                if (!StringUtils.isEmpty(xdgConfigHome) && !(appDataDir = new File(xdgConfigHome)).isAbsolute()) {
                    appDataDir = null;
                }
            }
            catch (SecurityException xdgConfigHome) {
                // empty catch block
            }
            if (appDataDir != null && appDataDir.isDirectory()) {
                path = "LanguageTool/" + OFFICE_EXTENSION_ID + "/";
                directory = new File(appDataDir, path);
            } else {
                path = ".config/LanguageTool/" + OFFICE_EXTENSION_ID + "/";
                directory = new File(userHome, path);
            }
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            String path = "Library/Application Support/LanguageTool/" + OFFICE_EXTENSION_ID + "/";
            directory = new File(userHome, path);
        } else {
            String path = ".LanguageTool/" + OFFICE_EXTENSION_ID + "/";
            directory = new File(userHome, path);
        }
        if (directory != null && !directory.exists()) {
            directory.mkdirs();
        }
        return directory;
    }

    public static String getLogFilePath() {
        return OfficeTools.getLogFilePath(null);
    }

    public static String getLogFilePath(XComponentContext xContext) {
        return new File(OfficeTools.getLOConfigDir(xContext), LOG_FILE).getAbsolutePath();
    }

    public static String getStatisticalConfigFilePath() {
        return new File(OfficeTools.getLOConfigDir(), STATISTICAL_ANALYZES_CONFIG_FILE).getAbsolutePath();
    }

    public static File getCacheDir() {
        return OfficeTools.getCacheDir(null);
    }

    public static File getCacheDir(XComponentContext xContext) {
        File cacheDir = new File(OfficeTools.getLOConfigDir(xContext), CACHE_ID);
        if (cacheDir != null && !cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir;
    }

    public static double getMaxHeapSpace() {
        if (MAX_HEAP_SPACE < 0.0) {
            MAX_HEAP_SPACE = Runtime.getRuntime().maxMemory();
        }
        return MAX_HEAP_SPACE;
    }

    private static double getHeapLimit(double maxHeap) {
        if (LT_HEAP_LIMIT < 0.0) {
            LT_HEAP_LIMIT = maxHeap * 0.9;
        }
        return LT_HEAP_LIMIT;
    }

    public static double getCurrentHeapRatio() {
        return (double)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / LT_HEAP_LIMIT;
    }

    public static boolean isHeapLimitReached() {
        long usedHeap = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
        return LT_HEAP_LIMIT < (double)usedHeap;
    }

    public static String getJavaInformation() {
        return "Java-Version: " + System.getProperty("java.version") + ", max. Heap-Space: " + (int)(OfficeTools.getMaxHeapSpace() / 1048576.0) + " MB, LT Heap Space Limit: " + (int)(OfficeTools.getHeapLimit(OfficeTools.getMaxHeapSpace()) / 1048576.0) + " MB";
    }

    public static String getLtInformation() {
        String txt = JLanguageTool.VERSION;
        if (JLanguageTool.VERSION.contains("SNAPSHOT")) {
            txt = txt + " - " + JLanguageTool.BUILD_DATE + ", " + JLanguageTool.GIT_SHORT_ID;
        }
        return txt;
    }

    public static Image getLtImage() {
        try {
            URL url = OfficeTools.class.getResource("/images/LanguageToolSmall.png");
            return ImageIO.read(url);
        }
        catch (IOException e) {
            MessageHandler.showError(e);
            return null;
        }
    }

    public static ImageIcon getLtImageIcon(boolean big) {
        URL url = big ? OfficeTools.class.getResource("/images/LanguageToolBig.png") : OfficeTools.class.getResource("/images/LanguageToolSmall.png");
        return new ImageIcon(url);
    }

    public static OfficeProductInfo getOfficeProductInfo(XComponentContext xContext) {
        if (OFFICE_PRODUCT_INFO == null) {
            OFFICE_PRODUCT_INFO = OfficeTools.readOfficeProductInfo(xContext);
        }
        return OFFICE_PRODUCT_INFO;
    }

    private static OfficeProductInfo readOfficeProductInfo(XComponentContext xContext) {
        try {
            if (xContext == null) {
                return null;
            }
            XMultiServiceFactory xMSF = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xContext.getServiceManager());
            if (xMSF == null) {
                MessageHandler.printToLogFile("XMultiServiceFactory == null");
                return null;
            }
            Object oConfigProvider = xMSF.createInstance("com.sun.star.configuration.ConfigurationProvider");
            XMultiServiceFactory confMsf = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oConfigProvider);
            String sView = "com.sun.star.configuration.ConfigurationAccess";
            Object[] args = new Object[1];
            PropertyValue aPathArgument = new PropertyValue();
            aPathArgument.Name = "nodepath";
            aPathArgument.Value = "org.openoffice.Setup/Product";
            args[0] = aPathArgument;
            Object oConfigAccess = confMsf.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", args);
            XNameAccess xName = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oConfigAccess);
            aPathArgument.Value = "org.openoffice.Setup/L10N";
            Object oConfigAccess1 = confMsf.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", args);
            XNameAccess xName1 = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)oConfigAccess1);
            return new OfficeProductInfo(xName.getByName("ooName"), xName.getByName("ooSetupVersion"), xName.getByName("ooSetupExtension"), xName.getByName("ooVendor"), xName1.getByName("ooLocale"), (Object)System.getProperty("os.arch"));
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    public static boolean getBooleanValue(Object o) {
        if (o != null && o instanceof Boolean) {
            return (Boolean)o;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForLO() {
        while (DocumentCursorTools.isBusy() || ViewCursorTools.isBusy() || FlatParagraphTools.isBusy()) {
            try {
                Object object = waitObj;
                synchronized (object) {
                    if (++numLoWaits > 3000) {
                        MessageHandler.printToLogFile("waitForLO: Wait for more than 30 seconds, DocumentCursorTools.isBusy: " + DocumentCursorTools.isBusy() + ", ViewCursorTools.isBusy: " + ViewCursorTools.isBusy() + ", FlatParagraphTools.isBusy: " + FlatParagraphTools.isBusy() + ": Free Lock and continue.");
                        if (DocumentCursorTools.isBusy()) {
                            DocumentCursorTools.reset();
                        }
                        if (ViewCursorTools.isBusy()) {
                            ViewCursorTools.reset();
                        }
                        if (FlatParagraphTools.isBusy()) {
                            FlatParagraphTools.reset();
                        }
                    }
                }
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                MessageHandler.printException(e);
            }
        }
    }

    public static void waitForLtDictionary() {
        while (LtDictionary.isActivating()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                MessageHandler.printException(e);
            }
        }
    }

    public static boolean hasStatisticalStyleRules(Language lang) {
        try {
            for (Rule rule : lang.getRelevantRules(JLanguageTool.getMessageBundle(), null, lang, null)) {
                if (!(rule instanceof AbstractStatisticSentenceStyleRule) && !(rule instanceof AbstractStatisticStyleRule) && !(rule instanceof ReadabilityRule) && !(rule instanceof AbstractStyleTooOftenUsedWordRule)) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    static void setLogLevel(String logLevel) {
        if (logLevel != null) {
            String[] levels;
            for (String level : levels = logLevel.split(LOG_DELIMITER)) {
                if (level.equals("1") || level.equals("2") || level.equals("3") || level.startsWith("all:")) {
                    int numLevel;
                    if (level.startsWith("all:")) {
                        String[] levelAll = level.split(":");
                        if (levelAll.length != 2) continue;
                        numLevel = Integer.parseInt(levelAll[1]);
                    } else {
                        numLevel = Integer.parseInt(level);
                    }
                    if (numLevel > 0) {
                        DEBUG_MODE_MD = true;
                        DEBUG_MODE_TQ = true;
                        if (DEBUG_MODE_SD == 0) {
                            DEBUG_MODE_SD = numLevel;
                        }
                        if (DEBUG_MODE_SC == 0) {
                            DEBUG_MODE_SC = numLevel;
                        }
                        if (DEBUG_MODE_CR == 0) {
                            DEBUG_MODE_CR = numLevel;
                        }
                    }
                    if (numLevel > 1) {
                        DEBUG_MODE_DC = true;
                        DEBUG_MODE_LM = true;
                    }
                    if (numLevel <= 2) continue;
                    DEBUG_MODE_FP = true;
                    continue;
                }
                if (level.startsWith("sd:") || level.startsWith("sc:") || level.startsWith("cr:")) {
                    int numLevel;
                    String[] levelSD = level.split(":");
                    if (levelSD.length != 2 || (numLevel = Integer.parseInt(levelSD[1])) <= 0) continue;
                    if (levelSD[0].equals("sd")) {
                        DEBUG_MODE_SD = numLevel;
                        continue;
                    }
                    if (levelSD[0].equals("sc")) {
                        DEBUG_MODE_SC = numLevel;
                        continue;
                    }
                    if (!levelSD[0].equals("cr")) continue;
                    DEBUG_MODE_CR = numLevel;
                    continue;
                }
                if (level.equals("md")) {
                    DEBUG_MODE_MD = true;
                    continue;
                }
                if (level.equals("dc")) {
                    DEBUG_MODE_DC = true;
                    continue;
                }
                if (level.equals("fp")) {
                    DEBUG_MODE_FP = true;
                    continue;
                }
                if (level.equals("lm")) {
                    DEBUG_MODE_LM = true;
                    continue;
                }
                if (level.equals("tq")) {
                    DEBUG_MODE_TQ = true;
                    continue;
                }
                if (level.equals("ld")) {
                    DEBUG_MODE_LD = true;
                    continue;
                }
                if (level.equals("cd")) {
                    DEBUG_MODE_CD = true;
                    continue;
                }
                if (level.equals("io")) {
                    DEBUG_MODE_IO = true;
                    continue;
                }
                if (level.equals("sr")) {
                    DEBUG_MODE_SR = true;
                    continue;
                }
                if (level.startsWith("tm")) {
                    int time;
                    String[] levelTm = level.split(":");
                    if (!levelTm[0].equals("tm")) continue;
                    DEBUG_MODE_TM = true;
                    if (levelTm.length <= 1 || (time = Integer.parseInt(levelTm[1])) < 0) continue;
                    TIME_TOLERANCE = time;
                    continue;
                }
                if (level.equals("st")) {
                    DEVELOP_MODE_ST = true;
                    continue;
                }
                if (!level.equals("dev")) continue;
                DEVELOP_MODE = true;
            }
        }
    }

    public static class OfficeProductInfo {
        public final String ooName;
        public final String ooVersion;
        public final String ooExtension;
        public final String ooVendor;
        public final String ooLocale;
        public final String osArch;

        OfficeProductInfo(Object name, Object version, Object extension, Object vendor, Object locale, Object arch) {
            this.ooName = new String((String)name);
            this.ooVersion = new String((String)version);
            this.ooExtension = new String((String)extension);
            this.ooVendor = new String((String)vendor);
            this.ooLocale = new String((String)locale);
            this.osArch = new String((String)arch);
        }

        OfficeProductInfo(String name, String version, String extension, String vendor, String locale, String arch) {
            this.ooName = new String(name);
            this.ooVersion = new String(version);
            this.ooExtension = new String(extension);
            this.ooVendor = new String(vendor);
            this.ooLocale = new String(locale);
            this.osArch = new String(arch);
        }
    }

    public static enum LoErrorType {
        GRAMMAR,
        SPELL,
        BOTH;

    }

    public static enum RemoteCheck {
        NONE,
        ALL,
        ONLY_SPELL,
        ONLY_GRAMMAR;

    }

    public static enum DocumentType {
        WRITER,
        IMPRESS,
        CALC,
        UNSUPPORTED;

    }
}

