/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheetView;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCell;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeDrawTools;

public class OfficeSpreadsheetTools {
    private static final int MAX_TABLE_ROWS = 50;
    private static final int MAX_TABLE_COLS = 50;

    public static boolean isSpreadsheetDocument(XComponent xComponent) throws Throwable {
        XServiceInfo xInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
        if (xInfo == null) {
            return false;
        }
        return xInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument");
    }

    private static int getFilledColumnCount(XSpreadsheet xSheet, int maxRows) {
        for (int nCol = 49; nCol > 0; --nCol) {
            for (int nRow = 0; nRow < maxRows; ++nRow) {
                String sContent = null;
                try {
                    sContent = xSheet.getCellByPosition(nCol, nRow).getFormula();
                }
                catch (IndexOutOfBoundsException e) {
                    MessageHandler.printException(e);
                }
                if (sContent == null || sContent.isEmpty()) continue;
                return nCol + 1;
            }
        }
        return 1;
    }

    private static int getFilledRowCount(XSpreadsheet xSheet, int maxCols) {
        for (int nRow = 49; nRow > 0; --nRow) {
            for (int nCol = 0; nCol < maxCols; ++nCol) {
                String sContent = null;
                try {
                    sContent = xSheet.getCellByPosition(nCol, nRow).getFormula();
                }
                catch (IndexOutOfBoundsException e) {
                    MessageHandler.printException(e);
                }
                if (sContent == null || sContent.isEmpty()) continue;
                return nRow + 1;
            }
        }
        return 1;
    }

    private static boolean isNotTextFormat(String s) {
        if (!(s = s.trim()).isEmpty()) {
            char ch0 = s.charAt(0);
            if (ch0 == '=') {
                return true;
            }
            if ((Character.isDigit(ch0) || s.length() > 1 && s.charAt(1) == '-' && Character.isDigit(s.charAt(1))) && !s.contains(" ")) {
                return true;
            }
        }
        return false;
    }

    public static OfficeDrawTools.ParagraphContainer getAllParagraphs(XComponent xComponent) {
        ArrayList<String> paragraphs = new ArrayList<String>();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        ArrayList<Integer> pageBegins = new ArrayList<Integer>();
        if (xComponent == null) {
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: OfficeSpreadsheetTools: xComponent == null");
            return new OfficeDrawTools.ParagraphContainer(paragraphs, locales, pageBegins);
        }
        XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
        if (xSpreadsheetDocument == null) {
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: OfficeSpreadsheetTools: xSpreadsheetDocument == null");
            return new OfficeDrawTools.ParagraphContainer(paragraphs, locales, pageBegins);
        }
        XPropertySet xSpreadsheetPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xSpreadsheetDocument);
        try {
            Locale locale = (Locale)xSpreadsheetPropertySet.getPropertyValue("CharLocale");
            XSpreadsheets xSheets = xSpreadsheetDocument.getSheets();
            if (xSheets == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: OfficeSpreadsheetTools: xSheets == null");
                return new OfficeDrawTools.ParagraphContainer(paragraphs, locales, pageBegins);
            }
            XIndexAccess xSheetsIA = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSheets);
            if (xSheetsIA == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: OfficeSpreadsheetTools: xSheetsIA == null");
                return new OfficeDrawTools.ParagraphContainer(paragraphs, locales, pageBegins);
            }
            int nPara = 0;
            for (int i = 0; i < xSheetsIA.getCount(); ++i) {
                XSpreadsheet xSheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xSheetsIA.getByIndex(i));
                if (xSheet == null) {
                    MessageHandler.printToLogFile("OfficeSpreadsheetTools: OfficeSpreadsheetTools: xSheet == null");
                    return new OfficeDrawTools.ParagraphContainer(paragraphs, locales, pageBegins);
                }
                boolean isEmptyText = false;
                int maxRows = OfficeSpreadsheetTools.getFilledRowCount(xSheet, 50);
                int maxCols = OfficeSpreadsheetTools.getFilledColumnCount(xSheet, maxRows);
                for (int nCol = 0; nCol < maxCols; ++nCol) {
                    pageBegins.add(nPara);
                    for (int nRow = 0; nRow < maxRows; ++nRow) {
                        XCell xCell = xSheet.getCellByPosition(nCol, nRow);
                        String text = xCell.getFormula();
                        if (!text.isEmpty() && OfficeSpreadsheetTools.isNotTextFormat(text)) {
                            text = "";
                        }
                        if (text.isEmpty() && !isEmptyText) {
                            isEmptyText = true;
                            if (!pageBegins.contains(nPara)) {
                                pageBegins.add(nPara);
                            }
                        } else if (!text.isEmpty() && isEmptyText) {
                            isEmptyText = false;
                            if (!pageBegins.contains(nPara)) {
                                pageBegins.add(nPara);
                            }
                        }
                        paragraphs.add(text);
                        locales.add(locale);
                        ++nPara;
                    }
                }
            }
            return new OfficeDrawTools.ParagraphContainer(paragraphs, locales, pageBegins);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return new OfficeDrawTools.ParagraphContainer(paragraphs, locales, pageBegins);
        }
    }

    public static void setTextofCell(int nPara, String replace, XComponent xComponent) {
        if (xComponent == null) {
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: setTextofCell: xComponent == null");
            return;
        }
        XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
        if (xSpreadsheetDocument == null) {
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: setTextofCell: xSpreadsheetDocument == null");
            return;
        }
        try {
            XSpreadsheets xSheets = xSpreadsheetDocument.getSheets();
            if (xSheets == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: setTextofCell: xSheets == null");
                return;
            }
            XIndexAccess xSheetsIA = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSheets);
            if (xSheetsIA == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: setTextofCell: xSheetsIA == null");
                return;
            }
            int nParaCount = 0;
            for (int i = 0; i < xSheetsIA.getCount(); ++i) {
                XSpreadsheet xSheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xSheetsIA.getByIndex(i));
                if (xSheet == null) {
                    MessageHandler.printToLogFile("OfficeSpreadsheetTools: setTextofCell: xSheet == null");
                    return;
                }
                int maxRows = OfficeSpreadsheetTools.getFilledRowCount(xSheet, 50);
                int maxCols = OfficeSpreadsheetTools.getFilledColumnCount(xSheet, maxRows);
                for (int nCol = 0; nCol < maxCols; ++nCol) {
                    for (int nRow = 0; nRow < maxRows; ++nRow) {
                        if (nPara == nParaCount) {
                            XCell xCell = xSheet.getCellByPosition(nCol, nRow);
                            xCell.setFormula(replace);
                            return;
                        }
                        ++nParaCount;
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
    }

    public static void setCurrentSheet(int nPara, XComponent xComponent) {
        try {
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
            if (xSpreadsheetDocument == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: setCurrentSheet: xSpreadsheetDocument == null");
                return;
            }
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDocument);
            XController xController = xModel.getCurrentController();
            XSpreadsheetView xSpreadsheetView = (XSpreadsheetView)UnoRuntime.queryInterface(XSpreadsheetView.class, (Object)xController);
            if (xSpreadsheetView == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: setCurrentSheet: xSpreadsheetView == null");
                return;
            }
            XSpreadsheets xSheets = xSpreadsheetDocument.getSheets();
            if (xSheets == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: setCurrentSheet: xSheets == null");
                return;
            }
            XIndexAccess xSheetsIA = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSheets);
            if (xSheetsIA == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: setCurrentSheet: xSheetsIA == null");
                return;
            }
            int nParaCount = 0;
            int nSheets = xSheetsIA.getCount();
            for (int i = 0; i < nSheets; ++i) {
                XSpreadsheet xSheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xSheetsIA.getByIndex(i));
                if (xSheet == null) {
                    MessageHandler.printToLogFile("OfficeSpreadsheetTools: setCurrentSheet: xSheet == null");
                    return;
                }
                if (i == nSheets - 1 || nParaCount == nPara) {
                    xSpreadsheetView.setActiveSheet(xSheet);
                    return;
                }
                int maxRows = OfficeSpreadsheetTools.getFilledRowCount(xSheet, 50);
                int maxCols = OfficeSpreadsheetTools.getFilledColumnCount(xSheet, maxRows);
                for (int nCol = 0; nCol < maxCols; ++nCol) {
                    for (int nRow = 0; nRow < maxRows; ++nRow) {
                        if (nParaCount == nPara) {
                            xSpreadsheetView.setActiveSheet(xSheet);
                            return;
                        }
                        ++nParaCount;
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    public static int getParagraphFromCurrentSheet(XComponent xComponent) {
        try {
            XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
            if (xSpreadsheetDocument == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: getParagraphFromCurrentSheet: xSpreadsheetDocument == null");
                return -1;
            }
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xSpreadsheetDocument);
            XController xController = xModel.getCurrentController();
            XSpreadsheetView xSpreadsheetView = (XSpreadsheetView)UnoRuntime.queryInterface(XSpreadsheetView.class, (Object)xController);
            if (xSpreadsheetView == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: getParagraphFromCurrentSheet: xSpreadsheetView == null");
                return -1;
            }
            XSpreadsheet xCurrentSheet = xSpreadsheetView.getActiveSheet();
            XPropertySet xSheetPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xCurrentSheet);
            String currentSheetName = (String)xSheetPropertySet.getPropertyValue("AbsoluteName");
            XSpreadsheets xSheets = xSpreadsheetDocument.getSheets();
            if (xSheets == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: getParagraphFromCurrentSheet: xSheets == null");
                return -1;
            }
            XIndexAccess xSheetsIA = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSheets);
            if (xSheetsIA == null) {
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: getParagraphFromCurrentSheet: xSheetsIA == null");
                return -1;
            }
            int nParaCount = 0;
            int nSheets = xSheetsIA.getCount();
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: getParagraphFromCurrentSheet: nSheets = " + nSheets);
            for (int i = 0; i < nSheets; ++i) {
                XSpreadsheet xSheet = (XSpreadsheet)UnoRuntime.queryInterface(XSpreadsheet.class, (Object)xSheetsIA.getByIndex(i));
                if (xSheet == null) {
                    MessageHandler.printToLogFile("OfficeSpreadsheetTools: getParagraphFromCurrentSheet: xSheet == null");
                    return -1;
                }
                xSheetPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xSheet);
                String sheetName = (String)xSheetPropertySet.getPropertyValue("AbsoluteName");
                if (currentSheetName.equals(sheetName)) {
                    return nParaCount;
                }
                MessageHandler.printToLogFile("OfficeSpreadsheetTools: getParagraphFromCurrentSheet: xCurrentSheet = " + xCurrentSheet + ", xSheet = " + xSheet);
                int maxRows = OfficeSpreadsheetTools.getFilledRowCount(xSheet, 50);
                int maxCols = OfficeSpreadsheetTools.getFilledColumnCount(xSheet, maxRows);
                for (int nCol = 0; nCol < maxCols; ++nCol) {
                    for (int nRow = 0; nRow < maxRows; ++nRow) {
                        ++nParaCount;
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return -1;
    }

    public static void setLanguageOfSpreadsheet(Locale locale, XComponent xComponent) {
        if (xComponent == null) {
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: setLanguageOfSpreadsheet: xComponent == null");
            return;
        }
        XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
        if (xSpreadsheetDocument == null) {
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: setLanguageOfSpreadsheet: xSpreadsheetDocument == null");
            return;
        }
        XPropertySet xSpreadsheetPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xSpreadsheetDocument);
        try {
            xSpreadsheetPropertySet.setPropertyValue("CharLocale", (Object)locale);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
    }

    public static Locale getDocumentLocale(XComponent xComponent) throws Throwable {
        if (xComponent == null) {
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: getDocumentLocale: xComponent == null");
            return null;
        }
        XSpreadsheetDocument xSpreadsheetDocument = (XSpreadsheetDocument)UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xComponent);
        if (xSpreadsheetDocument == null) {
            MessageHandler.printToLogFile("OfficeSpreadsheetTools: getDocumentLocale: xSpreadsheetDocument == null");
            return null;
        }
        XPropertySet xSpreadsheetPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xSpreadsheetDocument);
        try {
            return (Locale)xSpreadsheetPropertySet.getPropertyValue("CharLocale");
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }
}

