/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XDrawView;
import com.sun.star.drawing.XMasterPageTarget;
import com.sun.star.drawing.XMasterPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.linguistic2.SingleProofreadingError;
import com.sun.star.presentation.XHandoutMasterSupplier;
import com.sun.star.presentation.XPresentationPage;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.languagetool.openoffice.MessageHandler;

public class OfficeDrawTools {
    private static boolean debugMode = false;

    public static int getDrawPageCount(XComponent xComponent) throws Throwable {
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xComponent);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        return xDrawPages.getCount();
    }

    public static XDrawPage getDrawPageByIndex(XComponent xComponent, int nIndex) throws Throwable {
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xComponent);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        return (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(nIndex));
    }

    public static XDrawPage insertNewDrawPageByIndex(XComponent xComponent, int nIndex) throws Throwable {
        XDrawPagesSupplier xDrawPagesSupplier = (XDrawPagesSupplier)UnoRuntime.queryInterface(XDrawPagesSupplier.class, (Object)xComponent);
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        return xDrawPages.insertNewByIndex(nIndex);
    }

    public static Size getPageSize(XDrawPage xDrawPage) throws Throwable {
        XPropertySet xPageProperties = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xDrawPage);
        return new Size(((Integer)xPageProperties.getPropertyValue("Width")).intValue(), ((Integer)xPageProperties.getPropertyValue("Height")).intValue());
    }

    public static int getMasterPageCount(XComponent xComponent) {
        XMasterPagesSupplier xMasterPagesSupplier = (XMasterPagesSupplier)UnoRuntime.queryInterface(XMasterPagesSupplier.class, (Object)xComponent);
        XDrawPages xDrawPages = xMasterPagesSupplier.getMasterPages();
        return xDrawPages.getCount();
    }

    public static XDrawPage getMasterPageByIndex(XComponent xComponent, int nIndex) throws Throwable {
        XMasterPagesSupplier xMasterPagesSupplier = (XMasterPagesSupplier)UnoRuntime.queryInterface(XMasterPagesSupplier.class, (Object)xComponent);
        XDrawPages xDrawPages = xMasterPagesSupplier.getMasterPages();
        return (XDrawPage)UnoRuntime.queryInterface(XDrawPage.class, (Object)xDrawPages.getByIndex(nIndex));
    }

    public static XDrawPage insertNewMasterPageByIndex(XComponent xComponent, int nIndex) throws Throwable {
        XMasterPagesSupplier xMasterPagesSupplier = (XMasterPagesSupplier)UnoRuntime.queryInterface(XMasterPagesSupplier.class, (Object)xComponent);
        XDrawPages xDrawPages = xMasterPagesSupplier.getMasterPages();
        return xDrawPages.insertNewByIndex(nIndex);
    }

    public static void setMasterPage(XDrawPage xDrawPage, XDrawPage xMasterPage) throws Throwable {
        XMasterPageTarget xMasterPageTarget = (XMasterPageTarget)UnoRuntime.queryInterface(XMasterPageTarget.class, (Object)xDrawPage);
        xMasterPageTarget.setMasterPage(xMasterPage);
    }

    public static boolean isImpressDocument(XComponent xComponent) throws Throwable {
        XServiceInfo xInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
        if (xInfo == null) {
            return false;
        }
        return xInfo.supportsService("com.sun.star.presentation.PresentationDocument");
    }

    public static XDrawPage getNotesPage(XDrawPage xDrawPage) throws Throwable {
        XPresentationPage aPresentationPage = (XPresentationPage)UnoRuntime.queryInterface(XPresentationPage.class, (Object)xDrawPage);
        return aPresentationPage.getNotesPage();
    }

    public static XDrawPage getHandoutMasterPage(XComponent xComponent) throws Throwable {
        XHandoutMasterSupplier aHandoutMasterSupplier = (XHandoutMasterSupplier)UnoRuntime.queryInterface(XHandoutMasterSupplier.class, (Object)xComponent);
        return aHandoutMasterSupplier.getHandoutMasterPage();
    }

    public static XShapes getShapes(XDrawPage xPage) throws Throwable {
        return (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xPage);
    }

    private static int getAllParagraphsFromText(int nPara, List<String> paragraphs, List<Locale> locales, XText xText) throws Throwable {
        if (xText != null) {
            XPropertySet xParaPropSet;
            int k;
            XTextCursor xTextCursor = xText.createTextCursor();
            xTextCursor.gotoStart(false);
            String sText = xText.getString();
            int kStart = 0;
            for (k = 0; k < sText.length(); ++k) {
                if (sText.charAt(k) != "\n".charAt(0)) continue;
                paragraphs.add(sText.substring(kStart, k));
                ++nPara;
                xTextCursor.goRight((short)(k - kStart), true);
                xParaPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                locales.add((Locale)xParaPropSet.getPropertyValue("CharLocale"));
                xTextCursor.goRight((short)1, false);
                kStart = k + 1;
            }
            if (k > kStart) {
                paragraphs.add(sText.substring(kStart, k));
                ++nPara;
                xTextCursor.goRight((short)(k - kStart), true);
                xParaPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                locales.add((Locale)xParaPropSet.getPropertyValue("CharLocale"));
            }
        }
        return nPara;
    }

    public static ParagraphContainer getAllParagraphs(XComponent xComponent) {
        ArrayList<String> paragraphs = new ArrayList<String>();
        ArrayList<Locale> locales = new ArrayList<Locale>();
        ArrayList<Integer> pageBegins = new ArrayList<Integer>();
        int nPara = 0;
        try {
            int pageCount = OfficeDrawTools.getDrawPageCount(xComponent);
            for (int i = 0; i < pageCount; ++i) {
                XDrawPage xDrawPage = null;
                for (int n = 0; n < 2; ++n) {
                    xDrawPage = n == 0 ? OfficeDrawTools.getDrawPageByIndex(xComponent, i) : OfficeDrawTools.getNotesPage(xDrawPage);
                    XShapes xShapes = OfficeDrawTools.getShapes(xDrawPage);
                    int nShapes = xShapes.getCount();
                    if (nShapes > 0) {
                        pageBegins.add(nPara);
                    }
                    for (int j = 0; j < nShapes; ++j) {
                        Object oShape = xShapes.getByIndex(j);
                        XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                        if (xShape != null) {
                            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape);
                            nPara = OfficeDrawTools.getAllParagraphsFromText(nPara, paragraphs, locales, xText);
                            continue;
                        }
                        MessageHandler.printToLogFile("OfficeDrawTools: getAllParagraphs: xShape " + j + " is null");
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return new ParagraphContainer(paragraphs, locales, pageBegins);
    }

    private static int changeTextOfParagraphInText(int nParaCount, int nPara, int beginn, int length, String replace, XText xText) throws Throwable {
        if (xText != null) {
            XTextCursor xTextCursor = xText.createTextCursor();
            String sText = xText.getString();
            if (nParaCount == nPara) {
                xTextCursor.gotoStart(false);
                xTextCursor.goRight((short)beginn, false);
                xTextCursor.goRight((short)length, true);
                xTextCursor.setString(replace);
                return -1;
            }
            int lastParaEnd = 0;
            for (int k = 0; k < sText.length(); ++k) {
                if (sText.charAt(k) != "\n".charAt(0)) continue;
                lastParaEnd = k;
                if (++nParaCount != nPara) continue;
                xTextCursor.gotoStart(false);
                xTextCursor.goRight((short)(beginn + k + 1), false);
                xTextCursor.goRight((short)length, true);
                xTextCursor.setString(replace);
                return -1;
            }
            if (lastParaEnd < sText.length() - 1) {
                ++nParaCount;
            }
        }
        return nParaCount;
    }

    public static void changeTextOfParagraph(int nPara, int beginn, int length, String replace, XComponent xComponent) {
        try {
            int nParaCount = 0;
            int pageCount = OfficeDrawTools.getDrawPageCount(xComponent);
            for (int i = 0; i < pageCount; ++i) {
                XDrawPage xDrawPage = null;
                for (int n = 0; n < 2; ++n) {
                    xDrawPage = n == 0 ? OfficeDrawTools.getDrawPageByIndex(xComponent, i) : OfficeDrawTools.getNotesPage(xDrawPage);
                    XShapes xShapes = OfficeDrawTools.getShapes(xDrawPage);
                    int nShapes = xShapes.getCount();
                    for (int j = 0; j < nShapes; ++j) {
                        Object oShape = xShapes.getByIndex(j);
                        XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                        if (xShape != null) {
                            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape);
                            if ((nParaCount = OfficeDrawTools.changeTextOfParagraphInText(nParaCount, nPara, beginn, length, replace, xText)) >= 0) continue;
                            Point p = xShape.getPosition();
                            xShape.setPosition(p);
                            return;
                        }
                        MessageHandler.printToLogFile("OfficeDrawTools: changeTextOfParagraph: xShape " + j + " is null");
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    private static int changeLocaleOfParagraphInText(int nParaCount, int nPara, int beginn, int length, Locale locale, XText xText) throws Throwable {
        if (xText != null) {
            XTextCursor xTextCursor = xText.createTextCursor();
            String sText = xText.getString();
            if (nParaCount == nPara) {
                xTextCursor.gotoStart(false);
                xTextCursor.goRight((short)beginn, false);
                xTextCursor.goRight((short)length, true);
                XPropertySet xParaPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                xParaPropSet.setPropertyValue("CharLocale", (Object)locale);
                return -1;
            }
            int lastParaEnd = 0;
            for (int k = 0; k < sText.length(); ++k) {
                if (sText.charAt(k) != "\n".charAt(0)) continue;
                lastParaEnd = k;
                if (++nParaCount != nPara) continue;
                xTextCursor.gotoStart(false);
                xTextCursor.goRight((short)(beginn + k + 1), false);
                xTextCursor.goRight((short)length, true);
                XPropertySet xParaPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                xParaPropSet.setPropertyValue("CharLocale", (Object)locale);
                return -1;
            }
            if (lastParaEnd < sText.length() - 1) {
                ++nParaCount;
            }
        }
        return nParaCount;
    }

    public static void setLanguageOfParagraph(int nPara, int beginn, int length, Locale locale, XComponent xComponent) {
        try {
            int nParaCount = 0;
            int pageCount = OfficeDrawTools.getDrawPageCount(xComponent);
            for (int i = 0; i < pageCount; ++i) {
                XDrawPage xDrawPage = null;
                for (int n = 0; n < 2; ++n) {
                    xDrawPage = n == 0 ? OfficeDrawTools.getDrawPageByIndex(xComponent, i) : OfficeDrawTools.getNotesPage(xDrawPage);
                    XShapes xShapes = OfficeDrawTools.getShapes(xDrawPage);
                    int nShapes = xShapes.getCount();
                    for (int j = 0; j < nShapes; ++j) {
                        Object oShape = xShapes.getByIndex(j);
                        XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                        if (xShape != null) {
                            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape);
                            if ((nParaCount = OfficeDrawTools.changeLocaleOfParagraphInText(nParaCount, nPara, beginn, length, locale, xText)) >= 0) continue;
                            Point p = xShape.getPosition();
                            xShape.setPosition(p);
                            return;
                        }
                        MessageHandler.printToLogFile("OfficeDrawTools: setLanguageOfParagraph: xShape " + j + " is null");
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    private static int findParaInText(int nParaCount, int nPara, XText xText) throws Throwable {
        if (xText != null) {
            String sText = xText.getString();
            if (nParaCount == nPara && sText.length() > 0) {
                return -1;
            }
            int kStart = 0;
            for (int k = 0; k < sText.length(); ++k) {
                if (sText.charAt(k) != "\n".charAt(0)) continue;
                kStart = k + 1;
                if (++nParaCount != nPara) continue;
                return -1;
            }
            if (kStart < sText.length()) {
                ++nParaCount;
            }
        }
        return nParaCount;
    }

    public static void setCurrentPage(int nPara, XComponent xComponent) {
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            XController xController = xModel.getCurrentController();
            XDrawView xDrawView = (XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)xController);
            int nParaCount = 0;
            int pageCount = OfficeDrawTools.getDrawPageCount(xComponent);
            for (int i = 0; i < pageCount; ++i) {
                XDrawPage xDrawPage = null;
                for (int n = 0; n < 2; ++n) {
                    xDrawPage = n == 0 ? OfficeDrawTools.getDrawPageByIndex(xComponent, i) : OfficeDrawTools.getNotesPage(xDrawPage);
                    XShapes xShapes = OfficeDrawTools.getShapes(xDrawPage);
                    int nShapes = xShapes.getCount();
                    for (int j = 0; j < nShapes; ++j) {
                        Object oShape = xShapes.getByIndex(j);
                        XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                        if (xShape != null) {
                            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape);
                            if ((nParaCount = OfficeDrawTools.findParaInText(nParaCount, nPara, xText)) >= 0) continue;
                            xDrawView.setCurrentPage(xDrawPage);
                            return;
                        }
                        MessageHandler.printToLogFile("OfficeDrawTools: setCurrentPage: xShape " + j + " is null");
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    public static int getParagraphFromCurrentPage(XComponent xComponent) {
        int nParaCount = 0;
        try {
            XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            XController xController = xModel.getCurrentController();
            XDrawView xDrawView = (XDrawView)UnoRuntime.queryInterface(XDrawView.class, (Object)xController);
            XDrawPage xCurrentDrawPage = xDrawView.getCurrentPage();
            int pageCount = OfficeDrawTools.getDrawPageCount(xComponent);
            for (int i = 0; i < pageCount; ++i) {
                XDrawPage xDrawPage = null;
                for (int n = 0; n < 2; ++n) {
                    xDrawPage = n == 0 ? OfficeDrawTools.getDrawPageByIndex(xComponent, i) : OfficeDrawTools.getNotesPage(xDrawPage);
                    if (xDrawPage.equals(xCurrentDrawPage)) {
                        return nParaCount;
                    }
                    XShapes xShapes = OfficeDrawTools.getShapes(xDrawPage);
                    int nShapes = xShapes.getCount();
                    for (int j = 0; j < nShapes; ++j) {
                        Object oShape = xShapes.getByIndex(j);
                        XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                        if (xShape != null) {
                            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape);
                            nParaCount = OfficeDrawTools.findParaInText(nParaCount, -1, xText);
                            continue;
                        }
                        MessageHandler.printToLogFile("OfficeDrawTools: getParagraphFromCurrentPage: xShape " + j + " is null");
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return nParaCount;
    }

    public static boolean isParagraphInNotesPage(int nPara, XComponent xComponent) {
        int nParaCount = 0;
        try {
            int pageCount = OfficeDrawTools.getDrawPageCount(xComponent);
            for (int i = 0; i < pageCount; ++i) {
                XDrawPage xDrawPage = null;
                for (int n = 0; n < 2; ++n) {
                    xDrawPage = n == 0 ? OfficeDrawTools.getDrawPageByIndex(xComponent, i) : OfficeDrawTools.getNotesPage(xDrawPage);
                    XShapes xShapes = OfficeDrawTools.getShapes(xDrawPage);
                    int nShapes = xShapes.getCount();
                    for (int j = 0; j < nShapes; ++j) {
                        Object oShape = xShapes.getByIndex(j);
                        XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                        if (xShape != null) {
                            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape);
                            if ((nParaCount = OfficeDrawTools.findParaInText(nParaCount, nPara, xText)) >= 0) continue;
                            return n != 0;
                        }
                        MessageHandler.printToLogFile("OfficeDrawTools: isParagraphInNotesPage: xShape " + j + " is null");
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return false;
    }

    public static Locale getDocumentLocale(XComponent xComponent) {
        try {
            int pageCount = OfficeDrawTools.getDrawPageCount(xComponent);
            for (int i = 0; i < pageCount; ++i) {
                XDrawPage xDrawPage = null;
                for (int n = 0; n < 2; ++n) {
                    xDrawPage = n == 0 ? OfficeDrawTools.getDrawPageByIndex(xComponent, i) : OfficeDrawTools.getNotesPage(xDrawPage);
                    XShapes xShapes = OfficeDrawTools.getShapes(xDrawPage);
                    int nShapes = xShapes.getCount();
                    for (int j = 0; j < nShapes; ++j) {
                        Object oShape = xShapes.getByIndex(j);
                        XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                        if (xShape != null) {
                            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape);
                            if (xText == null) continue;
                            XTextCursor xTextCursor = xText.createTextCursor();
                            XPropertySet xParaPropSet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                            return (Locale)xParaPropSet.getPropertyValue("CharLocale");
                        }
                        MessageHandler.printToLogFile("OfficeDrawTools: getDocumentLocale: xShape " + j + " is null");
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return null;
    }

    private static void markupOneParagraph(int nParaBeginn, SingleProofreadingError error, UndoMarkupContainer undoMarkUp, XTextCursor xTextCursor) throws Throwable {
        xTextCursor.gotoStart(false);
        xTextCursor.goRight((short)nParaBeginn, false);
        if (error != null) {
            xTextCursor.goRight((short)error.nErrorStart, false);
            undoMarkUp.nStart = error.nErrorStart;
            undoMarkUp.underline = new UndoMarkupContainer.Underline[error.nErrorLength];
            for (int i = 0; i < error.nErrorLength; ++i) {
                int color;
                boolean hasColor;
                short font;
                if (debugMode) {
                    MessageHandler.printToLogFile("OfficeDrawTools: markupOneParagraph: i: " + i);
                }
                xTextCursor.goRight((short)1, true);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                Object o = xPropertySet.getPropertyValue("CharUnderline");
                if (o != null) {
                    font = (Short)o;
                    o = xPropertySet.getPropertyValue("CharUnderlineHasColor");
                    if (o != null) {
                        hasColor = (Boolean)o;
                        o = xPropertySet.getPropertyValue("CharUnderlineColor");
                        color = o != null ? (Integer)o : 0;
                    } else {
                        hasColor = false;
                        color = 0;
                    }
                } else {
                    font = 0;
                    hasColor = false;
                    color = 0;
                }
                undoMarkUp.underline[i] = new UndoMarkupContainer.Underline(font, color, hasColor);
                xPropertySet.setPropertyValue("CharUnderline", (Object)10);
                PropertyValue[] properties = error.aProperties;
                color = -1;
                for (PropertyValue property : properties) {
                    if (!"LineColor".equals(property.Name)) continue;
                    color = (Integer)property.Value;
                }
                if (color < 0) {
                    color = Color.blue.getRGB() & 0xFFFFFF;
                }
                xPropertySet.setPropertyValue("CharUnderlineColor", (Object)color);
                xPropertySet.setPropertyValue("CharUnderlineHasColor", (Object)true);
                xTextCursor.goLeft((short)1, false);
                xTextCursor.goRight((short)1, false);
            }
        } else {
            xTextCursor.goRight((short)undoMarkUp.nStart, false);
            for (int i = 0; i < undoMarkUp.underline.length; ++i) {
                xTextCursor.goRight((short)1, true);
                XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextCursor);
                xPropertySet.setPropertyValue("CharUnderlineColor", (Object)undoMarkUp.underline[i].color);
                xPropertySet.setPropertyValue("CharUnderlineHasColor", (Object)undoMarkUp.underline[i].hasColor);
                xPropertySet.setPropertyValue("CharUnderline", (Object)undoMarkUp.underline[i].font);
                xTextCursor.goLeft((short)1, false);
                xTextCursor.goRight((short)1, false);
            }
        }
    }

    public static void removeMarkup(UndoMarkupContainer undoMarkup, XComponent xComponent) {
        if (undoMarkup != null) {
            OfficeDrawTools.setMarkup(undoMarkup.nPara, null, undoMarkup, xComponent);
        }
    }

    public static void setMarkup(int nPara, SingleProofreadingError error, UndoMarkupContainer undoMarkup, XComponent xComponent) {
        if (undoMarkup == null) {
            MessageHandler.printToLogFile("OfficeDrawTools: markupParagraph: UndoMarkupContainer is null: return");
            return;
        }
        try {
            int nParaCount = 0;
            int pageCount = OfficeDrawTools.getDrawPageCount(xComponent);
            if (error == null) {
                nPara = undoMarkup.nPara;
            }
            for (int i = 0; i < pageCount; ++i) {
                XDrawPage xDrawPage = null;
                for (int n = 0; n < 2; ++n) {
                    xDrawPage = n == 0 ? OfficeDrawTools.getDrawPageByIndex(xComponent, i) : OfficeDrawTools.getNotesPage(xDrawPage);
                    XShapes xShapes = OfficeDrawTools.getShapes(xDrawPage);
                    int nShapes = xShapes.getCount();
                    for (int j = 0; j < nShapes; ++j) {
                        Object oShape = xShapes.getByIndex(j);
                        XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                        if (xShape != null) {
                            XText xText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape);
                            if (xText == null) continue;
                            XTextCursor xTextCursor = xText.createTextCursor();
                            String sText = xText.getString();
                            if (nParaCount == nPara) {
                                if (debugMode) {
                                    MessageHandler.printToLogFile("OfficeDrawTools: markupParagraphs: sText: " + sText);
                                    if (error != null) {
                                        MessageHandler.printToLogFile("OfficeDrawTools: markupParagraphs: error Beginn: " + error.nErrorStart + ", error Length: " + error.nErrorLength);
                                    }
                                }
                                if (error != null) {
                                    undoMarkup.nPara = nPara;
                                }
                                OfficeDrawTools.markupOneParagraph(0, error, undoMarkup, xTextCursor);
                                return;
                            }
                            int lastParaEnd = 0;
                            if (debugMode && nPara < 12) {
                                MessageHandler.printToLogFile("OfficeDrawTools: markupParagraphs: sText: " + sText);
                            }
                            for (int k = 0; k < sText.length(); ++k) {
                                if (sText.charAt(k) != "\n".charAt(0)) continue;
                                ++nParaCount;
                                if (debugMode && nPara < 12) {
                                    MessageHandler.printToLogFile("OfficeDrawTools: markupParagraphs: nPara: " + nPara + ", nParaCount: " + nParaCount);
                                }
                                lastParaEnd = k;
                                if (nParaCount != nPara) continue;
                                if (debugMode) {
                                    MessageHandler.printToLogFile("OfficeDrawTools: markupParagraphs: sText: " + sText);
                                    if (error != null) {
                                        MessageHandler.printToLogFile("OfficeDrawTools: markupParagraphs: error Beginn: " + error.nErrorStart + ", error Length: " + error.nErrorLength);
                                    }
                                }
                                if (error != null) {
                                    undoMarkup.nPara = nPara;
                                }
                                OfficeDrawTools.markupOneParagraph(k + 1, error, undoMarkup, xTextCursor);
                                return;
                            }
                            if (lastParaEnd < sText.length() - 1) {
                                ++nParaCount;
                            }
                            if (!debugMode || nPara >= 12) continue;
                            MessageHandler.printToLogFile("OfficeDrawTools: markupParagraphs: nPara: " + nPara + ", nParaCount: " + nParaCount);
                            continue;
                        }
                        MessageHandler.printToLogFile("OfficeDrawTools: markupParagraph: xShape " + j + " is null");
                    }
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    public static class UndoMarkupContainer {
        int nPara;
        int nStart;
        Underline[] underline;

        UndoMarkupContainer() {
        }

        UndoMarkupContainer(int nPara, int nStart, Underline[] underline) {
            this.nPara = nPara;
            this.nStart = nStart;
            this.underline = underline;
        }

        public static class Underline {
            short font;
            int color;
            boolean hasColor;

            Underline(short font, int color, boolean hasColor) {
                this.font = font;
                this.color = color;
                this.hasColor = hasColor;
            }
        }
    }

    public static class ParagraphContainer {
        public List<String> paragraphs;
        public List<Locale> locales;
        public List<Integer> pageBegins;

        ParagraphContainer(List<String> paragraphs, List<Locale> locales, List<Integer> pageBegins) {
            this.paragraphs = paragraphs;
            this.locales = locales;
            this.pageBegins = pageBegins;
        }
    }
}

