/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.linguistic2.LinguServiceEvent;
import com.sun.star.linguistic2.ProofreadingResult;
import com.sun.star.linguistic2.SingleProofreadingError;
import com.sun.star.linguistic2.XLinguServiceEventListener;
import com.sun.star.linguistic2.XProofreader;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextViewCursor;
import com.sun.star.text.XTextViewCursorSupplier;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.ConfigurationDialog;
import org.languagetool.gui.Tools;
import org.languagetool.openoffice.AboutDialog;
import org.languagetool.openoffice.AnalyzedParagraphsCache;
import org.languagetool.openoffice.ConfigThread;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.KhmerDetector;
import org.languagetool.openoffice.LinguisticServices;
import org.languagetool.openoffice.LtDictionary;
import org.languagetool.openoffice.LtSpellChecker;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MoreInfoDialog;
import org.languagetool.openoffice.OfficeDrawTools;
import org.languagetool.openoffice.OfficeSpreadsheetTools;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.SortedTextRules;
import org.languagetool.openoffice.SpellAndGrammarCheckDialog;
import org.languagetool.openoffice.SwJLanguageTool;
import org.languagetool.openoffice.TamilDetector;
import org.languagetool.openoffice.TextLevelCheckQueue;
import org.languagetool.openoffice.ViewCursorTools;
import org.languagetool.openoffice.stylestatistic.StatAnDialog;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.Rule;

public class MultiDocumentsHandler {
    private static final String LIBREOFFICE_SPECIAL_LANGUAGE_TAG = "qlt";
    private static final ResourceBundle messages = JLanguageTool.getMessageBundle();
    private static final int HEAP_CHECK_INTERVAL = 1000;
    private final List<XLinguServiceEventListener> xEventListeners;
    private boolean docReset = false;
    private static boolean debugMode = false;
    private static boolean debugModeTm = false;
    public final boolean isOpenOffice;
    private SwJLanguageTool lt = null;
    private Language docLanguage = null;
    private Language fixedLanguage = null;
    private Language langForShortName;
    private Locale locale;
    private final XEventListener xEventListener;
    private final XProofreader xProofreader;
    private final File configDir;
    private final File oldConfigFile;
    private String configFile;
    private Configuration config = null;
    private LinguisticServices linguServices = null;
    private SortedTextRules sortedTextRules;
    private Map<String, Set<String>> disabledRulesUI;
    private final List<Rule> extraRemoteRules;
    private SpellAndGrammarCheckDialog.LtCheckDialog ltDialog = null;
    private ConfigurationDialog cfgDialog = null;
    private static AboutDialog aboutDialog = null;
    private static MoreInfoDialog infoDialog = null;
    private boolean dialogIsRunning = false;
    private WaitDialogThread waitDialog = null;
    private XComponentContext xContext;
    private final List<SingleDocument> documents;
    private boolean isDisposed = false;
    private boolean recheck = true;
    private int docNum;
    private int numSinceHeapTest = 0;
    private boolean heapLimitReached = false;
    private boolean noBackgroundCheck = false;
    private boolean useQueue = true;
    private boolean noLtSpeller = false;
    private String menuDocId = null;
    private TextLevelCheckQueue textLevelQueue = null;
    private ShapeChangeCheck shapeChangeCheck = null;
    private boolean doShapeCheck = false;
    private boolean useOrginalCheckDialog = false;
    private boolean checkImpressDocument = false;
    private boolean isNotTextDocument = false;
    private int heapCheckInterval = 1000;
    private boolean testMode = false;
    private boolean javaLookAndFeelIsSet = false;
    private boolean isHelperDisposed = false;
    private boolean statAnDialogRunning = false;

    MultiDocumentsHandler(XComponentContext xContext, XProofreader xProofreader, XEventListener xEventListener) {
        this.xContext = xContext;
        this.xEventListener = xEventListener;
        this.xProofreader = xProofreader;
        this.xEventListeners = new ArrayList<XLinguServiceEventListener>();
        OfficeTools.OfficeProductInfo officeInfo = OfficeTools.getOfficeProductInfo(xContext);
        if (officeInfo == null || officeInfo.ooName.equals("OpenOffice")) {
            this.isOpenOffice = true;
            this.useOrginalCheckDialog = true;
            this.configFile = "Languagetool-ooo.cfg";
        } else {
            this.isOpenOffice = false;
            this.configFile = "Languagetool.cfg";
        }
        this.configDir = OfficeTools.getLOConfigDir(xContext);
        this.oldConfigFile = OfficeTools.getOldConfigFile();
        MessageHandler.init(xContext);
        this.documents = new ArrayList<SingleDocument>();
        this.disabledRulesUI = new HashMap<String, Set<String>>();
        this.extraRemoteRules = new ArrayList<Rule>();
        if (officeInfo == null || officeInfo.osArch.equals("x86") || !LtSpellChecker.runLTSpellChecker(xContext)) {
            this.noLtSpeller = true;
        }
        LtHelper ltHelper = new LtHelper();
        ltHelper.start();
    }

    public final ProofreadingResult doProofreading(String docID, String paraText, Locale locale, int startOfSentencePos, int nSuggestedBehindEndOfSentencePosition, PropertyValue[] propertyValues) {
        ProofreadingResult paRes = new ProofreadingResult();
        paRes.nStartOfSentencePosition = startOfSentencePos;
        paRes.nBehindEndOfSentencePosition = paRes.nStartOfNextSentencePosition = nSuggestedBehindEndOfSentencePosition;
        paRes.xProofreader = this.xProofreader;
        paRes.aLocale = locale;
        paRes.aDocumentIdentifier = docID;
        paRes.aText = paraText;
        paRes.aProperties = propertyValues;
        try {
            paRes = this.getCheckResults(paraText, locale, paRes, propertyValues, this.docReset);
            this.docReset = false;
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return paRes;
    }

    ProofreadingResult getCheckResults(String paraText, Locale locale, ProofreadingResult paRes, PropertyValue[] propertyValues, boolean docReset) throws Throwable {
        if (this.lt == null) {
            this.setJavaLookAndFeel();
        }
        if (!MultiDocumentsHandler.hasLocale(locale)) {
            this.docLanguage = null;
            MessageHandler.printToLogFile("MultiDocumentsHandler: getCheckResults: Sorry, don't have locale: " + OfficeTools.localeToString(locale));
            return paRes;
        }
        if (!this.noBackgroundCheck) {
            boolean isSameLanguage = true;
            if (this.fixedLanguage == null || this.langForShortName == null) {
                this.langForShortName = MultiDocumentsHandler.getLanguage(locale);
                boolean bl = isSameLanguage = this.langForShortName.equals(this.docLanguage) && this.lt != null;
            }
            if (!isSameLanguage || this.recheck || this.checkImpressDocument) {
                boolean initDocs;
                boolean bl = initDocs = this.lt == null || this.recheck || this.checkImpressDocument;
                if (debugMode && initDocs) {
                    MessageHandler.showMessage("initDocs: lt " + (this.lt == null ? "=" : "!") + "= null, recheck: " + this.recheck + ", Impress: " + this.checkImpressDocument);
                }
                this.checkImpressDocument = false;
                if (!isSameLanguage) {
                    this.docLanguage = this.langForShortName;
                    this.locale = locale;
                    this.extraRemoteRules.clear();
                }
                this.lt = this.initLanguageTool(!isSameLanguage);
                this.initCheck(this.lt);
                if (initDocs) {
                    this.initDocuments(true);
                }
            } else if (this.textLevelQueue == null && this.useQueue) {
                this.textLevelQueue = new TextLevelCheckQueue(this);
            }
        }
        if (debugMode) {
            MessageHandler.printToLogFile("MultiDocumentsHandler: getCheckResults: Start getNumDoc!");
        }
        this.docNum = this.getNumDoc(paRes.aDocumentIdentifier, propertyValues);
        if (this.noBackgroundCheck) {
            return paRes;
        }
        if (debugMode) {
            MessageHandler.printToLogFile("MultiDocumentsHandler: getCheckResults: Start testHeapSpace!");
        }
        this.testHeapSpace();
        if (debugMode) {
            MessageHandler.printToLogFile("MultiDocumentsHandler: getCheckResults: Start getCheckResults at single document: " + paraText);
        }
        paRes = this.documents.get(this.docNum).getCheckResults(paraText, locale, paRes, propertyValues, docReset, this.lt, OfficeTools.LoErrorType.GRAMMAR);
        if (this.lt.doReset()) {
            MessageHandler.showMessage(messages.getString("loRemoteSwitchToLocal"));
            this.config.setRemoteCheck(false);
            try {
                this.config.saveConfiguration(this.docLanguage);
            }
            catch (IOException e) {
                MessageHandler.showError(e);
            }
            this.resetDocument();
        }
        if (debugMode) {
            MessageHandler.printToLogFile("MultiDocumentsHandler: getCheckResults: return to LO/OO!");
        }
        return paRes;
    }

    public SingleDocument getCurrentDocument() {
        block10: {
            try {
                XComponent xComponent = OfficeTools.getCurrentComponent(this.xContext);
                this.isNotTextDocument = false;
                if (xComponent == null) break block10;
                for (SingleDocument document : this.documents) {
                    if (!xComponent.equals(document.getXComponent())) continue;
                    return document;
                }
                XTextDocument curDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
                if (curDoc != null) break block10;
                String prefix = null;
                if (OfficeDrawTools.isImpressDocument(xComponent)) {
                    prefix = "I";
                    this.checkImpressDocument = true;
                } else if (OfficeSpreadsheetTools.isSpreadsheetDocument(xComponent)) {
                    prefix = "C";
                }
                if (prefix != null) {
                    String docID = this.createOtherDocId(prefix);
                    try {
                        xComponent.addEventListener(this.xEventListener);
                    }
                    catch (Throwable t1) {
                        MessageHandler.printToLogFile("MultiDocumentsHandler: getCurrentDocument: Error: Document (ID: " + docID + ") has no XComponent -> Internal space will not be deleted when document disposes");
                        xComponent = null;
                    }
                    if (this.config == null) {
                        this.config = this.getConfiguration();
                    }
                    SingleDocument newDocument = new SingleDocument(this.xContext, this.config, docID, xComponent, this, null);
                    this.documents.add(newDocument);
                    MessageHandler.printToLogFile("Document " + (this.documents.size() - 1) + " created; docID = " + docID);
                    return newDocument;
                }
                MessageHandler.printToLogFile("MultiDocumentsHandler: getCurrentDocument: Is document, but not a text document!");
                this.isNotTextDocument = true;
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        }
        return null;
    }

    private String createOtherDocId(String prefix) {
        if (this.documents.size() == 0) {
            return prefix + "1";
        }
        for (int n = 1; n < this.documents.size() + 1; ++n) {
            String docID = prefix + n;
            boolean isValid = true;
            for (SingleDocument document : this.documents) {
                if (!docID.equals(document.getDocID())) continue;
                isValid = false;
                break;
            }
            if (!isValid) continue;
            return docID;
        }
        return prefix + (this.documents.size() + 1);
    }

    boolean isNotTextDocument() {
        return this.isNotTextDocument;
    }

    boolean noLtSpeller() {
        return this.noLtSpeller;
    }

    boolean isCheckImpressDocument() {
        return this.checkImpressDocument;
    }

    void setCheckImpressDocument(boolean checkImpressDocument) {
        this.checkImpressDocument = checkImpressDocument;
    }

    void setRecheck() {
        this.recheck = true;
    }

    void setComponentContext(XComponentContext xContext) {
        if (this.xContext != null && !xContext.equals(this.xContext)) {
            this.setRecheck();
        }
        this.xContext = xContext;
    }

    public void setConfigurationDialog(ConfigurationDialog dialog) {
        this.cfgDialog = dialog;
    }

    public void setLtDialog(SpellAndGrammarCheckDialog.LtCheckDialog dialog) {
        this.ltDialog = dialog;
    }

    public void setLtDialogIsRunning(boolean running) {
        this.dialogIsRunning = running;
    }

    public void setConfigFileName(String name) {
        this.configFile = name;
    }

    public void setStatAnDialogRunning(boolean running) {
        this.statAnDialogRunning = running;
    }

    public boolean useAnalyzedSentencesCache() {
        return !this.config.doRemoteCheck() || this.statAnDialogRunning;
    }

    private void closeDialogs() throws Throwable {
        if (this.ltDialog != null) {
            this.ltDialog.closeDialog();
        }
        if (this.cfgDialog != null) {
            this.cfgDialog.close();
            this.cfgDialog = null;
        }
    }

    private void setContextOfClosedDoc(XComponent xComponent) {
        boolean found = false;
        try {
            for (SingleDocument document : this.documents) {
                if (!xComponent.equals(document.getXComponent())) continue;
                found = true;
                document.dispose(true);
                this.isDisposed = true;
                if (this.documents.size() < 2) {
                    if (this.textLevelQueue != null) {
                        this.textLevelQueue.setStop();
                        this.textLevelQueue = null;
                    }
                    this.isHelperDisposed = true;
                }
                document.removeDokumentListener(xComponent);
                document.setXComponent(this.xContext, null);
                if (!document.getDocumentCache().hasNoContent(false)) continue;
                MessageHandler.printToLogFile("Disposing document has no content: Wait for 1000 milliseconds");
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    MessageHandler.printException(e);
                }
            }
            if (!found) {
                MessageHandler.printToLogFile("MultiDocumentsHandler: setContextOfClosedDoc: Error: Disposed Document not found - Cache not deleted");
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    void addDisabledRule(String langCode, String ruleId) {
        if (this.disabledRulesUI.containsKey(langCode)) {
            this.disabledRulesUI.get(langCode).add(ruleId);
        } else {
            HashSet<String> rulesIds = new HashSet<String>();
            rulesIds.add(ruleId);
            this.disabledRulesUI.put(langCode, rulesIds);
        }
    }

    void removeDisabledRule(String langCode, String ruleId) {
        if (this.disabledRulesUI.containsKey(langCode)) {
            Set<String> rulesIds = this.disabledRulesUI.get(langCode);
            rulesIds.remove(ruleId);
            if (rulesIds.isEmpty()) {
                this.disabledRulesUI.remove(langCode);
            } else {
                this.disabledRulesUI.put(langCode, rulesIds);
            }
        }
    }

    void resetDisabledRules() {
        this.disabledRulesUI = new HashMap<String, Set<String>>();
    }

    Set<String> getDisabledRules(String langCode) {
        if (langCode == null || !this.disabledRulesUI.containsKey(langCode)) {
            return new HashSet<String>();
        }
        return this.disabledRulesUI.get(langCode);
    }

    Map<String, Set<String>> getAllDisabledRules() {
        return this.disabledRulesUI;
    }

    void setAllDisabledRules(Map<String, Set<String>> disabledRulesUI) {
        this.disabledRulesUI = disabledRulesUI;
    }

    Map<String, String> getDisabledRulesMap(String langCode) {
        if (langCode == null) {
            langCode = OfficeTools.localeToString(this.locale);
        }
        HashMap<String, String> disabledRulesMap = new HashMap<String, String>();
        if (langCode != null && this.lt != null && this.config != null) {
            String ruleDesc;
            String disabledRule;
            int i;
            List<Rule> allRules = this.lt.getAllRules();
            ArrayList<String> disabledRules = new ArrayList<String>(this.getDisabledRules(langCode));
            for (i = disabledRules.size() - 1; i >= 0; --i) {
                disabledRule = (String)disabledRules.get(i);
                ruleDesc = null;
                for (Rule rule : allRules) {
                    if (!disabledRule.equals(rule.getId())) continue;
                    if (!rule.isDefaultOff() || rule.isOfficeDefaultOn()) {
                        ruleDesc = rule.getDescription();
                        break;
                    }
                    this.removeDisabledRule(langCode, disabledRule);
                    break;
                }
                if (ruleDesc == null) continue;
                disabledRulesMap.put(disabledRule, ruleDesc);
            }
            disabledRules = new ArrayList<String>(this.config.getDisabledRuleIds());
            for (i = disabledRules.size() - 1; i >= 0; --i) {
                disabledRule = (String)disabledRules.get(i);
                ruleDesc = null;
                for (Rule rule : allRules) {
                    if (!disabledRule.equals(rule.getId())) continue;
                    if (!rule.isDefaultOff() || rule.isOfficeDefaultOn()) {
                        ruleDesc = rule.getDescription();
                        break;
                    }
                    this.config.removeDisabledRuleId(disabledRule);
                    break;
                }
                if (ruleDesc == null) continue;
                disabledRulesMap.put(disabledRule, ruleDesc);
            }
        }
        return disabledRulesMap;
    }

    void setDisabledRules(String langCode, Set<String> ruleIds) {
        this.disabledRulesUI.put(langCode, new HashSet<String>(ruleIds));
    }

    public SwJLanguageTool getLanguageTool() {
        if (this.lt == null) {
            if (this.docLanguage == null) {
                this.docLanguage = this.getCurrentLanguage();
            }
            this.lt = this.initLanguageTool();
        }
        return this.lt;
    }

    Configuration getConfiguration() {
        try {
            if (this.config == null || this.recheck) {
                if (this.docLanguage == null) {
                    this.docLanguage = this.getCurrentLanguage();
                }
                this.initLanguageTool();
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return this.config;
    }

    private void disableLTSpellChecker(XComponentContext xContext, Language lang) {
        try {
            this.config.setUseLtSpellChecker(false);
            this.config.saveConfiguration(lang);
        }
        catch (IOException e) {
            MessageHandler.printToLogFile("Can't read configuration: LT spell checker not used!");
        }
    }

    public LinguisticServices getLinguisticServices() {
        if (this.linguServices == null) {
            this.linguServices = new LinguisticServices(this.xContext);
            MessageHandler.printToLogFile("MultiDocumentsHandler: getLinguisticServices: linguServices set: is " + (this.linguServices == null ? "" : "NOT ") + "null");
            if (this.noLtSpeller) {
                org.languagetool.tools.Tools.setLinguisticServices(this.linguServices);
                MessageHandler.printToLogFile("MultiDocumentsHandler: getLinguisticServices: linguServices set to tools");
            }
        }
        return this.linguServices;
    }

    void setTestMode(boolean mode) {
        this.testMode = mode;
        MessageHandler.setTestMode(mode);
        if (mode) {
            this.configFile = "dummy_xxxx.cfg";
            File dummy = new File(this.configDir, this.configFile);
            if (dummy.exists()) {
                dummy.delete();
            }
        }
    }

    boolean isTestMode() {
        return this.testMode;
    }

    public Language getCurrentLanguage() {
        Locale locale = this.getDocumentLocale();
        if (locale == null || locale.Language.equals("zxx") || !MultiDocumentsHandler.hasLocale(locale)) {
            Language lang;
            SingleDocument document = this.getCurrentDocument();
            if (document != null && (lang = document.getLanguage()) != null) {
                return lang;
            }
            locale = new Locale("en", "US", "");
        }
        return MultiDocumentsHandler.getLanguage(locale);
    }

    @Nullable
    public Locale getDocumentLocale() {
        Locale charLocale;
        if (this.xContext == null) {
            return null;
        }
        XComponent xComponent = OfficeTools.getCurrentComponent(this.xContext);
        if (xComponent == null) {
            return null;
        }
        try {
            if (OfficeDrawTools.isImpressDocument(xComponent)) {
                return OfficeDrawTools.getDocumentLocale(xComponent);
            }
            if (OfficeSpreadsheetTools.isSpreadsheetDocument(xComponent)) {
                return OfficeSpreadsheetTools.getDocumentLocale(xComponent);
            }
            XModel model = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
            if (model == null) {
                return null;
            }
            XTextViewCursorSupplier xViewCursorSupplier = (XTextViewCursorSupplier)UnoRuntime.queryInterface(XTextViewCursorSupplier.class, (Object)model.getCurrentController());
            if (xViewCursorSupplier == null) {
                return null;
            }
            XTextViewCursor xCursor = xViewCursorSupplier.getViewCursor();
            if (xCursor == null) {
                return null;
            }
            XPropertySet xCursorProps = xCursor.isCollapsed() ? (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xCursor) : (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xCursor.getText().createTextCursorByRange(xCursor.getStart()));
            if (new KhmerDetector().isThisLanguage(xCursor.getText().getString())) {
                return new Locale("km", "", "");
            }
            if (new TamilDetector().isThisLanguage(xCursor.getText().getString())) {
                return new Locale("ta", "", "");
            }
            if (xCursorProps == null) {
                return null;
            }
            Object obj = xCursorProps.getPropertyValue("CharLocale");
            if (obj == null) {
                return null;
            }
            charLocale = (Locale)obj;
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
            return null;
        }
        return charLocale;
    }

    static final boolean hasLocale(Locale locale) {
        try {
            for (Language element : Languages.get()) {
                if (locale.Language.equalsIgnoreCase(LIBREOFFICE_SPECIAL_LANGUAGE_TAG) && element.getShortCodeWithCountryAndVariant().equals(locale.Variant)) {
                    return true;
                }
                if (!element.getShortCode().equals(locale.Language)) continue;
                return true;
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return false;
    }

    private void setConfigValues(Configuration config, SwJLanguageTool lt) {
        this.config = config;
        this.lt = lt;
        if (this.textLevelQueue != null && (this.heapLimitReached || config.getNumParasToCheck() == 0 || !config.useTextLevelQueue())) {
            this.textLevelQueue.setStop();
            this.textLevelQueue = null;
        }
        this.useQueue = this.noBackgroundCheck || this.heapLimitReached || this.testMode || config.getNumParasToCheck() == 0 ? false : config.useTextLevelQueue();
        for (SingleDocument document : this.documents) {
            if (document.isDisposed()) continue;
            document.setConfigValues(config);
        }
    }

    public static Language getLanguage(Locale locale) {
        try {
            if (locale.Language.equals("zxx")) {
                return null;
            }
            if (locale.Language.equalsIgnoreCase(LIBREOFFICE_SPECIAL_LANGUAGE_TAG)) {
                return Languages.getLanguageForShortCode(locale.Variant);
            }
            return Languages.getLanguageForShortCode(locale.Language + "-" + locale.Country);
        }
        catch (Throwable e) {
            try {
                return Languages.getLanguageForShortCode(locale.Language);
            }
            catch (Throwable t) {
                return null;
            }
        }
    }

    private int getNumDoc(String docID, PropertyValue[] propertyValues) throws Throwable {
        for (int i = 0; i < this.documents.size(); ++i) {
            int n;
            if (!this.documents.get(i).getDocID().equals(docID)) continue;
            if (!this.testMode && this.documents.get(i).getXComponent() == null) {
                XComponent xComponent = OfficeTools.getCurrentComponent(this.xContext);
                if (xComponent == null) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Error: Document (ID: " + docID + ") has no XComponent -> Internal space will not be deleted when document disposes");
                } else {
                    try {
                        xComponent.addEventListener(this.xEventListener);
                    }
                    catch (Throwable t) {
                        MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Error: Document (ID: " + docID + ") has no XComponent -> Internal space will not be deleted when document disposes");
                        xComponent = null;
                    }
                    if (xComponent != null) {
                        this.documents.get(i).setXComponent(this.xContext, xComponent);
                        MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Fixed: XComponent set for Document (ID: " + docID + ")");
                    }
                }
            }
            if (this.isDisposed && (n = this.removeDoc(docID)) >= 0 && n < i) {
                return i - 1;
            }
            return i;
        }
        XComponent xComponent = null;
        if (!this.testMode) {
            xComponent = OfficeTools.getCurrentComponent(this.xContext);
            if (xComponent == null) {
                MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Error: Document (ID: " + docID + ") has no XComponent -> Internal space will not be deleted when document disposes");
            } else {
                for (int i = 0; i < this.documents.size(); ++i) {
                    if (!xComponent.equals(this.documents.get(i).getXComponent())) continue;
                    MessageHandler.printToLogFile("Different Doc IDs, but same xComponents!");
                    String oldDocId = this.documents.get(i).getDocID();
                    this.documents.get(i).setDocID(docID);
                    this.documents.get(i).setLanguage(this.docLanguage);
                    MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Document ID corrected: old: " + oldDocId + ", new: " + docID);
                    if (this.useQueue && this.textLevelQueue != null) {
                        MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Interrupt text level queue for old document ID: " + oldDocId);
                        this.textLevelQueue.interruptCheck(oldDocId, true);
                        MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Interrupt done");
                    }
                    if (this.documents.get(i).isDisposed()) {
                        this.documents.get(i).dispose(false);
                    }
                    return i;
                }
                try {
                    xComponent.addEventListener(this.xEventListener);
                }
                catch (Throwable e) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Error: Document (ID: " + docID + ") has no XComponent -> Internal space will not be deleted when document disposes");
                    xComponent = null;
                }
            }
        }
        SingleDocument newDocument = new SingleDocument(this.xContext, this.config, docID, xComponent, this, this.docLanguage);
        this.documents.add(newDocument);
        if (this.isDisposed) {
            this.removeDoc(docID);
        }
        MessageHandler.printToLogFile("MultiDocumentsHandler: getNumDoc: Document " + (this.documents.size() - 1) + " created; docID = " + docID);
        return this.documents.size() - 1;
    }

    private int removeDoc(String docID) {
        if (this.isDisposed) {
            this.isDisposed = false;
            for (int i = this.documents.size() - 1; i >= 0; --i) {
                if (docID.equals(this.documents.get(i).getDocID()) || !this.documents.get(i).isDisposed()) continue;
                if (this.useQueue && this.textLevelQueue != null) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: removeDoc: Interrupt text level queue for document " + this.documents.get(i).getDocID());
                    this.textLevelQueue.interruptCheck(this.documents.get(i).getDocID(), true);
                    MessageHandler.printToLogFile("MultiDocumentsHandler: removeDoc: Interrupt done");
                }
                MessageHandler.printToLogFile("Disposed document " + this.documents.get(i).getDocID() + " removed");
                this.documents.remove(i);
                for (int j = 0; j < this.documents.size(); ++j) {
                    if (!this.documents.get(j).isDisposed()) continue;
                    this.isDisposed = true;
                }
                return i;
            }
        }
        return -1;
    }

    public void removeMenuListener(XComponent xComponent) throws Throwable {
        if (xComponent != null) {
            for (int i = 0; i < this.documents.size(); ++i) {
                XComponent docComponent = this.documents.get(i).getXComponent();
                if (docComponent == null || !xComponent.equals(docComponent)) continue;
                this.documents.get(i).getLtMenu().removeListener();
                if (!debugMode) break;
                MessageHandler.printToLogFile("MultiDocumentsHandler: removeMenuListener: Menu listener of document " + this.documents.get(i).getDocID() + " removed");
                break;
            }
        }
    }

    public SwJLanguageTool initLanguageTool() {
        return this.initLanguageTool(null, false);
    }

    public SwJLanguageTool initLanguageTool(boolean setService) {
        return this.initLanguageTool(null, setService);
    }

    public SwJLanguageTool initLanguageTool(Language currentLanguage, boolean setService) {
        SwJLanguageTool lt = null;
        try {
            long runTime;
            File ngramLangDir;
            this.config = new Configuration(this.configDir, this.configFile, this.oldConfigFile, this.docLanguage, true);
            if (this.lt == null) {
                OfficeTools.setLogLevel(this.config.getlogLevel());
                debugMode = OfficeTools.DEBUG_MODE_MD;
                debugModeTm = OfficeTools.DEBUG_MODE_TM;
                if (!this.noLtSpeller && !LtSpellChecker.isEnoughHeap()) {
                    this.noLtSpeller = true;
                    this.disableLTSpellChecker(this.xContext, this.docLanguage);
                    MessageHandler.showMessage(messages.getString("guiSpellCheckerWarning"));
                }
            }
            long startTime = 0L;
            if (debugModeTm) {
                startTime = System.currentTimeMillis();
            }
            this.noBackgroundCheck = this.config.noBackgroundCheck();
            if (this.linguServices == null) {
                this.linguServices = this.getLinguisticServices();
            }
            this.linguServices.setNoSynonymsAsSuggestions(this.config.noSynonymsAsSuggestions() || this.testMode);
            if (currentLanguage == null) {
                this.fixedLanguage = this.config.getDefaultLanguage();
                if (this.fixedLanguage != null) {
                    this.docLanguage = this.fixedLanguage;
                }
                currentLanguage = this.docLanguage;
            }
            lt = new SwJLanguageTool(currentLanguage, this.config.getMotherTongue(), new UserConfig(this.config.getConfigurableValues(), this.linguServices), this.config, this.extraRemoteRules, this.testMode);
            this.config.initStyleCategories(lt.getAllRules());
            File ngramDirectory = this.config.getNgramDirectory();
            if (ngramDirectory != null && (ngramLangDir = new File(this.config.getNgramDirectory(), currentLanguage.getShortCode())).exists()) {
                lt.activateLanguageModelRules(ngramDirectory);
                if (debugMode) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: initLanguageTool: ngram Model activated for language: " + currentLanguage.getShortCode());
                }
            }
            if (this.noLtSpeller) {
                List<Rule> allRules = this.checkImpressDocument ? lt.getAllActiveRules() : lt.getAllActiveOfficeRules();
                for (Rule rule : allRules) {
                    if (!rule.isDictionaryBasedSpellingRule()) continue;
                    lt.disableRule(rule.getId());
                    if (!rule.useInOffice()) continue;
                    rule.setDefaultOff();
                }
            }
            this.recheck = false;
            if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to init Language Tool: " + runTime);
            }
            return lt;
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
            return lt;
        }
    }

    void initCheck(SwJLanguageTool lt) throws Throwable {
        long l;
        Set<String> set;
        Set<String> set2;
        Set<String> disabledCategories;
        Set<String> disabledRuleIds;
        long startTime = 0L;
        if (debugModeTm) {
            startTime = System.currentTimeMillis();
        }
        if (this.config.enableTmpOffRules()) {
            List<Rule> allRules = lt.getAllRules();
            MessageHandler.printToLogFile("initCheck: enableTmpOffRules: true");
            for (Rule rule : allRules) {
                if (!rule.isDefaultTempOff()) continue;
                MessageHandler.printToLogFile("initCheck: enableTmpOffRule: " + rule.getId());
                lt.enableRule(rule.getId());
            }
        }
        if ((disabledRuleIds = this.config.getDisabledRuleIds()) != null) {
            ArrayList<String> list = new ArrayList<String>(disabledRuleIds);
            for (String string : list) {
                lt.disableRule(string);
            }
        }
        if ((disabledCategories = this.config.getDisabledCategoryNames()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>(disabledCategories);
            for (String string : arrayList) {
                lt.disableCategory(new CategoryId(string));
            }
        }
        if ((set2 = this.config.getEnabledRuleIds()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>(set2);
            for (String ruleName : arrayList) {
                lt.enableRule(ruleName);
            }
        }
        if ((set = this.getDisabledRules(lt.getLanguage().getShortCodeWithCountryAndVariant())) != null) {
            for (String id : set) {
                lt.disableRule(id);
            }
        }
        if (debugModeTm && (l = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to init Check: " + l);
        }
    }

    void initDocuments(boolean resetCache) throws Throwable {
        long runTime;
        long startTime = 0L;
        if (debugModeTm) {
            startTime = System.currentTimeMillis();
        }
        this.setConfigValues(this.config, this.lt);
        String langCode = this.lt.getLanguage().getShortCodeWithCountryAndVariant();
        this.sortedTextRules = new SortedTextRules(this.lt, this.config, this.getDisabledRules(langCode), this.checkImpressDocument);
        if (this.useQueue && !this.noBackgroundCheck) {
            if (this.textLevelQueue == null) {
                this.textLevelQueue = new TextLevelCheckQueue(this);
            } else {
                this.textLevelQueue.setReset();
            }
        }
        if (resetCache) {
            this.resetResultCaches(true);
        }
        if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to init Documents: " + runTime);
        }
    }

    void resetIgnoredMatches() {
        for (SingleDocument document : this.documents) {
            document.resetIgnoreOnce();
        }
    }

    void resetResultCaches(boolean withSingleParagraph) {
        for (SingleDocument document : this.documents) {
            document.resetResultCache(withSingleParagraph);
        }
    }

    void resetDocumentCaches() {
        for (SingleDocument document : this.documents) {
            document.resetDocumentCache();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public List<SingleDocument> getDocuments() {
        return this.documents;
    }

    public TextLevelCheckQueue getTextLevelCheckQueue() {
        return this.textLevelQueue;
    }

    public boolean isBackgroundCheckOff() {
        return this.noBackgroundCheck;
    }

    public boolean isJavaLookAndFeelSet() {
        return this.javaLookAndFeelIsSet;
    }

    public boolean toggleNoBackgroundCheck() throws Throwable {
        if (this.docLanguage == null) {
            this.docLanguage = this.getCurrentLanguage();
        }
        if (this.config == null) {
            this.config = new Configuration(this.configDir, this.configFile, this.oldConfigFile, this.docLanguage, true);
        }
        boolean bl = this.noBackgroundCheck = !this.noBackgroundCheck;
        if (!this.noBackgroundCheck && this.textLevelQueue != null) {
            this.textLevelQueue.setStop();
            this.textLevelQueue = null;
        }
        this.setRecheck();
        this.config.saveNoBackgroundCheck(this.noBackgroundCheck, this.docLanguage);
        for (SingleDocument document : this.documents) {
            document.setConfigValues(this.config);
        }
        if (this.noBackgroundCheck) {
            this.resetResultCaches(true);
        }
        return true;
    }

    public void setMenuDocId(String docId) {
        this.menuDocId = docId;
    }

    public void setUseOriginalCheckDialog() {
        this.useOrginalCheckDialog = true;
    }

    public boolean useOriginalCheckDialog() {
        return this.useOrginalCheckDialog;
    }

    public String ignoreOnce() {
        for (SingleDocument document : this.documents) {
            if (!this.menuDocId.equals(document.getDocID())) continue;
            return document.ignoreOnce();
        }
        return null;
    }

    public String ignorePermanent() {
        for (SingleDocument document : this.documents) {
            if (!this.menuDocId.equals(document.getDocID())) continue;
            return document.ignorePermanent();
        }
        return null;
    }

    public void resetIgnorePermanent() {
        this.getCurrentDocument().resetIgnorePermanent();
    }

    public void renewMarkups() {
        for (SingleDocument document : this.documents) {
            if (this.menuDocId == null || !this.menuDocId.equals(document.getDocID())) continue;
            document.renewMarkups();
        }
    }

    public void resetIgnoreOnce() {
        for (SingleDocument document : this.documents) {
            document.resetIgnoreOnce();
        }
    }

    private void changeProfile(String profile) {
        try {
            if (profile == null) {
                profile = "";
            }
            MessageHandler.printToLogFile("change to profile: " + profile);
            String currentProfile = this.config.getCurrentProfile();
            if (currentProfile == null) {
                currentProfile = "";
            }
            if (profile.equals(currentProfile)) {
                MessageHandler.printToLogFile("profile == null or profile equals current profile: Not changed");
                return;
            }
            List<String> definedProfiles = this.config.getDefinedProfiles();
            if (!(profile.isEmpty() || definedProfiles != null && definedProfiles.contains(profile))) {
                MessageHandler.showMessage("profile '" + profile + "' not found");
            } else {
                ArrayList<String> saveProfiles = new ArrayList<String>();
                saveProfiles.addAll(this.config.getDefinedProfiles());
                this.config.initOptions();
                this.config.loadConfiguration(profile == null ? "" : profile);
                this.config.setCurrentProfile(profile);
                this.config.addProfiles(saveProfiles);
                this.config.saveConfiguration(this.getCurrentDocument().getLanguage());
                this.resetConfiguration();
            }
        }
        catch (IOException e) {
            MessageHandler.showError(e);
        }
    }

    public void activateRule(String ruleId) {
        this.activateRule(OfficeTools.localeToString(this.locale), ruleId);
    }

    public void activateRule(String langcode, String ruleId) {
        if (ruleId != null) {
            this.removeDisabledRule(langcode, ruleId);
            this.deactivateRule(ruleId, langcode, true);
            this.resetDocument();
        }
    }

    public void deactivateRule() {
        for (SingleDocument document : this.documents) {
            if (!this.menuDocId.equals(document.getDocID())) continue;
            SingleDocument.RuleDesc ruleDesc = document.getCurrentRule();
            if (ruleDesc != null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: deactivateRule: ruleID = " + ruleDesc.error.aRuleIdentifier + "langCode = " + ruleDesc.langCode);
                }
                this.deactivateRule(ruleDesc.error.aRuleIdentifier, ruleDesc.langCode, false);
            }
            return;
        }
    }

    private void moreInfo() {
        try {
            if (infoDialog != null) {
                infoDialog.close();
                infoDialog = null;
            }
            for (SingleDocument document : this.documents) {
                if (!this.menuDocId.equals(document.getDocID())) continue;
                SingleDocument.RuleDesc ruleDesc = document.getCurrentRule();
                if (ruleDesc != null) {
                    try {
                        if (debugMode) {
                            MessageHandler.printToLogFile("MultiDocumentsHandler: moreInfo: ruleID = " + ruleDesc.error.aRuleIdentifier + "langCode = " + ruleDesc.langCode);
                        }
                        SingleProofreadingError error = ruleDesc.error;
                        for (Rule rule : this.lt.getAllRules()) {
                            if (!error.aRuleIdentifier.equals(rule.getId())) continue;
                            String tmp = error.aShortComment;
                            if (StringUtils.isEmpty(tmp)) {
                                tmp = error.aFullComment;
                            }
                            String msg = Tools.shortenComment(tmp);
                            String sUrl = null;
                            for (PropertyValue prop : error.aProperties) {
                                if (!"FullCommentURL".equals(prop.Name)) continue;
                                sUrl = (String)prop.Value;
                            }
                            URL url = sUrl == null ? null : new URL(sUrl);
                            MoreInfoDialogThread infoThread = new MoreInfoDialogThread(msg, error.aFullComment, rule, url, messages, this.lt.getLanguage().getShortCodeWithCountryAndVariant());
                            infoThread.start();
                            return;
                        }
                    }
                    catch (MalformedURLException e) {
                        MessageHandler.showError(e);
                    }
                }
                return;
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    private void removeRuleError(String ruleId) {
        for (SingleDocument document : this.documents) {
            document.removeRuleError(ruleId);
        }
    }

    public void deactivateRule(String ruleId, String langcode, boolean reactivate) {
        if (ruleId != null) {
            try {
                Configuration confg = new Configuration(this.configDir, this.configFile, this.oldConfigFile, this.docLanguage, true);
                HashSet<String> ruleIds = new HashSet<String>();
                ruleIds.add(ruleId);
                if (reactivate) {
                    confg.removeDisabledRuleIds(ruleIds);
                    this.removeDisabledRule(langcode, ruleId);
                    confg.saveConfiguration(this.docLanguage);
                    this.initDocuments(true);
                    this.resetDocument();
                } else {
                    confg.addDisabledRuleIds(ruleIds);
                    this.addDisabledRule(langcode, ruleId);
                    confg.saveConfiguration(this.docLanguage);
                    this.lt.disableRule(ruleId);
                    this.initDocuments(false);
                    this.removeRuleError(ruleId);
                }
                if (debugMode) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: deactivateRule: Rule " + (reactivate ? "enabled: " : "disabled: ") + (ruleId == null ? "null" : ruleId));
                }
            }
            catch (Throwable e) {
                MessageHandler.printException(e);
            }
        }
    }

    public void resetSortedTextRules(SwJLanguageTool lt) throws Throwable {
        String langCode = lt.getLanguage().getShortCodeWithCountryAndVariant();
        this.sortedTextRules = new SortedTextRules(lt, this.config, this.getDisabledRules(langCode), this.checkImpressDocument);
    }

    public List<Integer> getNumMinToCheckParas() {
        if (this.sortedTextRules == null) {
            return null;
        }
        return this.sortedTextRules.minToCheckParagraph;
    }

    public boolean isSortedRuleForIndex(int index) {
        return index >= 0 && this.sortedTextRules != null && index < this.sortedTextRules.textLevelRules.size() && !this.sortedTextRules.textLevelRules.get(index).isEmpty();
    }

    public void activateTextRulesByIndex(int index, SwJLanguageTool lt) {
        if (this.sortedTextRules != null) {
            this.sortedTextRules.activateTextRulesByIndex(index, lt);
        }
    }

    public void reactivateTextRules(SwJLanguageTool lt) {
        if (this.sortedTextRules != null) {
            this.sortedTextRules.reactivateTextRules(lt);
        }
    }

    public final boolean isSpellChecker() {
        return true;
    }

    public XComponentContext getContext() {
        return this.xContext;
    }

    public void runOptionsDialog() {
        try {
            Configuration config = this.getConfiguration();
            Language lang = config.getDefaultLanguage();
            if (lang == null) {
                lang = this.getCurrentLanguage();
            }
            if (lang == null) {
                return;
            }
            SwJLanguageTool lTool = this.lt;
            if (lTool == null || !lang.equals(this.docLanguage)) {
                this.docLanguage = lang;
                lTool = this.initLanguageTool();
                this.initCheck(lTool);
                config = this.config;
            }
            config.initStyleCategories(lTool.getAllRules());
            ConfigThread configThread = new ConfigThread(lang, config, lTool, this);
            configThread.start();
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    public static final Locale[] getLocales() {
        try {
            ArrayList<Locale> locales = new ArrayList<Locale>();
            Locale locale = null;
            for (Language lang : Languages.get()) {
                if (lang.getCountries().length == 0) {
                    locale = lang.getDefaultLanguageVariant() != null ? (lang.getDefaultLanguageVariant().getVariant() != null ? new Locale(lang.getDefaultLanguageVariant().getShortCode(), lang.getDefaultLanguageVariant().getCountries()[0], lang.getDefaultLanguageVariant().getVariant()) : (lang.getDefaultLanguageVariant().getCountries().length != 0 ? new Locale(lang.getDefaultLanguageVariant().getShortCode(), lang.getDefaultLanguageVariant().getCountries()[0], "") : new Locale(lang.getDefaultLanguageVariant().getShortCode(), "", ""))) : (lang.getVariant() != null ? new Locale(LIBREOFFICE_SPECIAL_LANGUAGE_TAG, "", lang.getShortCodeWithCountryAndVariant()) : new Locale(lang.getShortCode(), "", ""));
                    if (locales == null || OfficeTools.containsLocale(locales, locale)) continue;
                    locales.add(locale);
                    continue;
                }
                for (String country : lang.getCountries()) {
                    locale = lang.getVariant() != null ? new Locale(LIBREOFFICE_SPECIAL_LANGUAGE_TAG, country, lang.getShortCodeWithCountryAndVariant()) : new Locale(lang.getShortCode(), country, "");
                    if (locales == null || OfficeTools.containsLocale(locales, locale)) continue;
                    locales.add(locale);
                }
            }
            return locales == null ? new Locale[]{} : locales.toArray(new Locale[0]);
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
            return new Locale[0];
        }
    }

    public final boolean addLinguServiceEventListener(XLinguServiceEventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        this.xEventListeners.add(eventListener);
        return true;
    }

    public final boolean removeLinguServiceEventListener(XLinguServiceEventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        if (this.xEventListeners.contains(eventListener)) {
            this.xEventListeners.remove(eventListener);
            return true;
        }
        return false;
    }

    public boolean resetCheck() {
        return this.resetCheck((short)8);
    }

    public boolean resetCheck(short eventFlag) {
        if (!this.xEventListeners.isEmpty()) {
            for (XLinguServiceEventListener xEvLis : this.xEventListeners) {
                if (xEvLis == null) continue;
                LinguServiceEvent xEvent = new LinguServiceEvent();
                xEvent.nEvent = eventFlag;
                xEvLis.processLinguServiceEvent(xEvent);
            }
            return true;
        }
        return false;
    }

    void resetConfiguration() {
        this.linguServices = null;
        if (this.config != null) {
            this.noBackgroundCheck = this.config.noBackgroundCheck();
        }
        this.resetIgnoredMatches();
        this.resetResultCaches(true);
        this.resetDocument();
    }

    void resetDocument() {
        this.setRecheck();
        this.resetCheck();
    }

    public void trigger(String sEvent) {
        try {
            long runTime;
            SpellAndGrammarCheckDialog checkDialog;
            if (this.getCurrentDocument() == null) {
                return;
            }
            long startTime = 0L;
            if (debugModeTm) {
                startTime = System.currentTimeMillis();
            }
            if (("checkDialog".equals(sEvent) || "checkAgainDialog".equals(sEvent)) && !this.useOrginalCheckDialog && !this.dialogIsRunning) {
                this.waitDialog = new WaitDialogThread("Please wait", messages.getString("loWaitMessage"));
                this.waitDialog.start();
            }
            if (!this.testDocLanguage(true)) {
                MessageHandler.printToLogFile("Test for document language failed: Can't trigger event: " + sEvent);
                return;
            }
            if ("configure".equals(sEvent)) {
                this.closeDialogs();
                this.runOptionsDialog();
            } else if ("about".equals(sEvent)) {
                if (aboutDialog != null) {
                    aboutDialog.close();
                    aboutDialog = null;
                }
                if (!this.isJavaLookAndFeelSet()) {
                    this.setJavaLookAndFeel();
                }
                AboutDialogThread aboutThread = new AboutDialogThread(messages, this.xContext);
                aboutThread.start();
            } else if ("moreInfo".equals(sEvent)) {
                this.moreInfo();
            } else if ("toggleNoBackgroundCheck".equals(sEvent) || "backgroundCheckOn".equals(sEvent) || "backgroundCheckOff".equals(sEvent)) {
                if (this.toggleNoBackgroundCheck()) {
                    this.resetCheck();
                }
            } else if ("ignoreOnce".equals(sEvent)) {
                this.ignoreOnce();
            } else if ("ignorePermanent".equals(sEvent)) {
                this.ignorePermanent();
            } else if ("resetIgnorePermanent".equals(sEvent)) {
                this.resetIgnorePermanent();
            } else if ("deactivateRule".equals(sEvent)) {
                this.deactivateRule();
            } else if (sEvent.startsWith("activateRule_")) {
                String ruleId = sEvent.substring(13);
                this.activateRule(ruleId);
            } else if (sEvent.startsWith("profileChangeTo_")) {
                String profile = sEvent.substring(16);
                this.changeProfile(profile);
            } else if (sEvent.startsWith("addToDictionary_")) {
                String[] sArray = sEvent.substring(16).split(":");
                LtDictionary.addWordToDictionary(sArray[0], sArray[1], this.xContext);
            } else if ("renewMarkups".equals(sEvent)) {
                this.renewMarkups();
            } else if ("checkDialog".equals(sEvent) || "checkAgainDialog".equals(sEvent)) {
                if (this.useOrginalCheckDialog) {
                    if ("checkDialog".equals(sEvent)) {
                        OfficeTools.dispatchCmd(".uno:SpellingAndGrammarDialog", this.xContext);
                    } else {
                        OfficeTools.dispatchCmd(".uno:RecheckDocument", this.xContext);
                    }
                    return;
                }
                this.closeDialogs();
                if (this.dialogIsRunning) {
                    return;
                }
                if (this.waitDialog == null || this.waitDialog.canceled()) {
                    return;
                }
                this.setLtDialogIsRunning(true);
                checkDialog = new SpellAndGrammarCheckDialog(this.xContext, this, this.docLanguage, this.waitDialog);
                if ("checkAgainDialog".equals(sEvent)) {
                    XComponent currentComponent;
                    SingleDocument document = this.getCurrentDocument();
                    if (document != null && (currentComponent = document.getXComponent()) != null) {
                        if (document.getDocumentType() == OfficeTools.DocumentType.WRITER) {
                            ViewCursorTools viewCursor = new ViewCursorTools(currentComponent);
                            SpellAndGrammarCheckDialog.setTextViewCursor(0, new DocumentCache.TextParagraph(4, 0), viewCursor);
                        } else if (document.getDocumentType() == OfficeTools.DocumentType.IMPRESS) {
                            OfficeDrawTools.setCurrentPage(0, currentComponent);
                        } else {
                            OfficeSpreadsheetTools.setCurrentSheet(0, currentComponent);
                        }
                    }
                    this.resetIgnoredMatches();
                }
                if (debugMode) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: trigger: Start Spell And Grammar Check Dialog");
                }
                checkDialog.start();
            } else if ("nextError".equals(sEvent)) {
                if (this.isBackgroundCheckOff()) {
                    MessageHandler.showMessage(messages.getString("loExtSwitchOffMessage"));
                    return;
                }
                if (this.useOrginalCheckDialog) {
                    OfficeTools.dispatchCmd(".uno:SpellingAndGrammarDialog", this.xContext);
                    return;
                }
                checkDialog = new SpellAndGrammarCheckDialog(this.xContext, this, this.docLanguage, null);
                checkDialog.nextError();
            } else if ("refreshCheck".equals(sEvent)) {
                if (this.ltDialog != null) {
                    this.ltDialog.closeDialog();
                }
                if (this.isBackgroundCheckOff()) {
                    MessageHandler.showMessage(messages.getString("loExtSwitchOffMessage"));
                    return;
                }
                this.resetIgnoredMatches();
                this.resetDocumentCaches();
                this.resetResultCaches(true);
                LtSpellChecker.resetSpellCache();
                this.resetDocument();
            } else if ("statisticalAnalyses".equals(sEvent)) {
                StatAnDialog statAnDialog = new StatAnDialog(this.getCurrentDocument());
                statAnDialog.start();
            } else if (!"offStatisticalAnalyses".equals(sEvent)) {
                if ("writeAnalyzedParagraphs".equals(sEvent)) {
                    new AnalyzedParagraphsCache(this);
                } else if ("remoteHint".equals(sEvent)) {
                    if (this.getConfiguration().useOtherServer()) {
                        MessageHandler.showMessage(MessageFormat.format(messages.getString("loRemoteInfoOtherServer"), this.getConfiguration().getServerUrl()));
                    } else {
                        MessageHandler.showMessage(messages.getString("loRemoteInfoDefaultServer"));
                    }
                } else {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: trigger: Sorry, don't know what to do, sEvent = " + sEvent);
                }
            }
            if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run trigger: " + runTime);
            }
        }
        catch (Throwable e) {
            MessageHandler.showError(e);
        }
    }

    boolean testDocLanguage(boolean showMessage) throws Throwable {
        try {
            if (this.docLanguage == null) {
                OfficeTools.DocumentType docType;
                if (this.linguServices == null) {
                    this.linguServices = this.getLinguisticServices();
                }
                if (this.xContext == null) {
                    if (showMessage) {
                        MessageHandler.showMessage("There may be a installation problem! \nNo xContext!");
                    }
                    return false;
                }
                XComponent xComponent = OfficeTools.getCurrentComponent(this.xContext);
                if (xComponent == null) {
                    if (showMessage) {
                        MessageHandler.showMessage("There may be a installation problem! \nNo xComponent!");
                    }
                    return false;
                }
                if (OfficeDrawTools.isImpressDocument(xComponent)) {
                    docType = OfficeTools.DocumentType.IMPRESS;
                    this.checkImpressDocument = true;
                } else {
                    docType = OfficeSpreadsheetTools.isSpreadsheetDocument(xComponent) ? OfficeTools.DocumentType.CALC : OfficeTools.DocumentType.WRITER;
                }
                Locale locale = docType == OfficeTools.DocumentType.IMPRESS ? OfficeDrawTools.getDocumentLocale(xComponent) : (docType == OfficeTools.DocumentType.CALC ? OfficeSpreadsheetTools.getDocumentLocale(xComponent) : this.getDocumentLocale());
                try {
                    for (int n = 0; locale == null && n < 100; ++n) {
                        Thread.sleep(500L);
                        if (debugMode) {
                            MessageHandler.printToLogFile("MultiDocumentsHandler: testDocLanguage: Try to get locale: n = " + n);
                        }
                        locale = docType == OfficeTools.DocumentType.IMPRESS ? OfficeDrawTools.getDocumentLocale(xComponent) : (docType == OfficeTools.DocumentType.CALC ? OfficeSpreadsheetTools.getDocumentLocale(xComponent) : this.getDocumentLocale());
                    }
                }
                catch (InterruptedException e) {
                    MessageHandler.showError(e);
                }
                if (locale == null) {
                    if (showMessage) {
                        MessageHandler.showMessage("No Locale! LanguageTool can not be started!");
                    } else {
                        MessageHandler.printToLogFile("MultiDocumentsHandler: testDocLanguage: No Locale! LanguageTool can not be started!");
                    }
                    return false;
                }
                if (!MultiDocumentsHandler.hasLocale(locale)) {
                    String message = org.languagetool.tools.Tools.i18n(messages, "language_not_supported", locale.Language);
                    MessageHandler.showMessage(message);
                    return false;
                }
                if (debugMode) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: testDocLanguage: locale: " + locale.Language + "-" + locale.Country);
                }
                if (!this.linguServices.setLtAsGrammarService(this.xContext, locale)) {
                    if (showMessage) {
                        MessageHandler.showMessage("Can not set LT as grammar check service! LanguageTool can not be started!");
                    } else {
                        MessageHandler.printToLogFile("MultiDocumentsHandler: testDocLanguage: Can not set LT as grammar check service! LanguageTool can not be started!");
                    }
                    return false;
                }
                if (docType != OfficeTools.DocumentType.WRITER) {
                    this.langForShortName = MultiDocumentsHandler.getLanguage(locale);
                    if (this.langForShortName != null) {
                        this.docLanguage = this.langForShortName;
                        this.locale = locale;
                        this.extraRemoteRules.clear();
                        this.lt = this.initLanguageTool(true);
                        this.initCheck(this.lt);
                        this.initDocuments(true);
                    }
                    return true;
                }
                this.resetCheck();
                if (showMessage) {
                    MessageHandler.showMessage(messages.getString("loNoGrammarCheckWarning"));
                }
                return false;
            }
            return true;
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
            return false;
        }
    }

    public boolean javaVersionOkay() {
        String version = System.getProperty("java.version");
        if (version != null && (version.startsWith("1.0") || version.startsWith("1.1") || version.startsWith("1.2") || version.startsWith("1.3") || version.startsWith("1.4") || version.startsWith("1.5") || version.startsWith("1.6") || version.startsWith("1.7"))) {
            MessageHandler.showMessage("Error: LanguageTool requires Java 8 or later. Current version: " + version);
            return false;
        }
        return true;
    }

    public void setJavaLookAndFeel() {
        try {
            if (!System.getProperty("os.name").contains("OS X")) {
                if (System.getProperty("os.name").contains("Linux")) {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
            this.javaLookAndFeelIsSet = true;
        }
        catch (AWTError | Exception throwable) {
            // empty catch block
        }
    }

    public boolean heapLimitIsReached() {
        return this.heapLimitReached;
    }

    public boolean isEnoughHeapSpace() {
        try {
            double heapRatio = OfficeTools.getCurrentHeapRatio();
            if (heapRatio >= 1.0) {
                this.heapLimitReached = true;
                this.setConfigValues(this.config, this.lt);
                MessageHandler.showMessage(messages.getString("loExtHeapMessage"));
                for (SingleDocument document : this.documents) {
                    document.resetResultCache(true);
                    document.resetDocumentCache();
                }
                return false;
            }
            if (heapRatio < 0.5) {
                this.heapCheckInterval = 1000;
            } else if (heapRatio > 0.9) {
                this.heapCheckInterval = (int)(1000.0 / (1.0 - (double)this.heapCheckInterval));
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
        return true;
    }

    private void testHeapSpace() {
        if (!this.heapLimitReached && this.config.getNumParasToCheck() != 0) {
            if (this.numSinceHeapTest > this.heapCheckInterval) {
                this.isEnoughHeapSpace();
                this.numSinceHeapTest = 0;
            } else {
                ++this.numSinceHeapTest;
            }
        }
    }

    public void ignoreRule(String ruleId, Locale locale) {
        this.addDisabledRule(OfficeTools.localeToString(locale), ruleId);
        this.setRecheck();
    }

    public void resetIgnoreRules() {
        this.resetDisabledRules();
        this.setRecheck();
        this.resetIgnoreOnce();
        this.docReset = true;
    }

    public static String getServiceDisplayName(Locale locale) {
        return "LanguageTool";
    }

    public void disposing(EventObject source) {
        try {
            XComponent goneComponent = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)source.Source);
            if (goneComponent == null) {
                MessageHandler.printToLogFile("MultiDocumentsHandler: disposing: xComponent of closed document is null");
            } else {
                this.setContextOfClosedDoc(goneComponent);
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    public void runShapeCheck(boolean hasShapes, int where) {
        try {
            if (this.doShapeCheck) {
                if (hasShapes && (this.shapeChangeCheck == null || !this.shapeChangeCheck.isRunning())) {
                    MessageHandler.printToLogFile("MultiDocumentsHandler: runShapeCheck: start");
                    this.shapeChangeCheck = new ShapeChangeCheck();
                    this.shapeChangeCheck.start();
                } else if (!hasShapes && this.shapeChangeCheck != null) {
                    boolean noShapes = true;
                    for (int i = 0; i < this.documents.size() && noShapes; ++i) {
                        if (this.documents.get(i).getDocumentCache().textSize(3) <= 0) continue;
                        noShapes = false;
                    }
                    if (noShapes) {
                        MessageHandler.printToLogFile("MultiDocumentsHandler: runShapeCheck: stop");
                        this.shapeChangeCheck.stopLoop();
                        this.shapeChangeCheck = null;
                    }
                }
            }
        }
        catch (Exception e) {
            MessageHandler.showError(e);
        }
    }

    public class WaitDialogThread
    extends Thread {
        private final String dialogName;
        private final String text;
        private JDialog dialog = null;
        private boolean isCanceled = false;
        JProgressBar progressBar;

        public WaitDialogThread(String dialogName, String text) {
            this.dialogName = dialogName;
            this.text = text;
        }

        @Override
        public void run() {
            try {
                JLabel textLabel = new JLabel(this.text);
                JButton cancelBottom = new JButton(messages.getString("guiCancelButton"));
                cancelBottom.addActionListener(e -> this.close_intern());
                this.progressBar = new JProgressBar();
                this.progressBar.setIndeterminate(true);
                this.dialog = new JDialog();
                Container contentPane = this.dialog.getContentPane();
                this.dialog.setName("InformationThread");
                this.dialog.setTitle(this.dialogName);
                this.dialog.setDefaultCloseOperation(2);
                this.dialog.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        WaitDialogThread.this.close_intern();
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }
                });
                JPanel panel = new JPanel();
                panel.setLayout(new GridBagLayout());
                GridBagConstraints cons = new GridBagConstraints();
                cons.insets = new Insets(16, 24, 16, 24);
                cons.gridx = 0;
                cons.gridy = 0;
                cons.weightx = 1.0;
                cons.weighty = 10.0;
                cons.anchor = 10;
                cons.fill = 1;
                panel.add((Component)textLabel, cons);
                ++cons.gridy;
                panel.add((Component)this.progressBar, cons);
                ++cons.gridy;
                cons.fill = 0;
                panel.add((Component)cancelBottom, cons);
                contentPane.setLayout(new GridBagLayout());
                cons = new GridBagConstraints();
                cons.insets = new Insets(16, 32, 16, 32);
                cons.gridx = 0;
                cons.gridy = 0;
                cons.weightx = 1.0;
                cons.weighty = 1.0;
                cons.anchor = 18;
                cons.fill = 1;
                contentPane.add(panel);
                this.dialog.pack();
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                Dimension frameSize = this.dialog.getSize();
                this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
                this.dialog.setAutoRequestFocus(true);
                this.dialog.setAlwaysOnTop(true);
                this.dialog.toFront();
                if (debugMode) {
                    MessageHandler.printToLogFile("WaitDialogThread: run: Dialog is running");
                }
                this.dialog.setVisible(true);
                if (this.isCanceled) {
                    this.dialog.setVisible(false);
                    this.dialog.dispose();
                }
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        }

        public boolean canceled() {
            return this.isCanceled;
        }

        public void close() {
            this.close_intern();
        }

        private void close_intern() {
            try {
                if (debugMode) {
                    MessageHandler.printToLogFile("WaitDialogThread: close: Dialog closed");
                }
                this.isCanceled = true;
                if (this.dialog != null) {
                    this.dialog.setVisible(false);
                    this.dialog.dispose();
                }
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        }

        public void initializeProgressBar(int min, int max) {
            if (this.progressBar != null) {
                this.progressBar.setMinimum(min);
                this.progressBar.setMaximum(max);
                this.progressBar.setStringPainted(true);
                this.progressBar.setIndeterminate(false);
            }
        }

        public void setValueForProgressBar(int val) {
            if (this.progressBar != null) {
                this.progressBar.setValue(val);
            }
        }
    }

    private class LtHelper
    extends Thread {
        private LtHelper() {
        }

        @Override
        public void run() {
            try {
                SingleDocument currentDocument = null;
                while (!MultiDocumentsHandler.this.isHelperDisposed && currentDocument == null) {
                    Thread.sleep(250L);
                    if (MultiDocumentsHandler.this.isHelperDisposed) {
                        return;
                    }
                    currentDocument = MultiDocumentsHandler.this.getCurrentDocument();
                    if (currentDocument == null || currentDocument.getDocumentType() != OfficeTools.DocumentType.IMPRESS && currentDocument.getDocumentType() != OfficeTools.DocumentType.CALC) continue;
                    if (currentDocument.getDocumentType() == OfficeTools.DocumentType.IMPRESS) {
                        MultiDocumentsHandler.this.checkImpressDocument = true;
                        MultiDocumentsHandler.this.locale = OfficeDrawTools.getDocumentLocale(currentDocument.getXComponent());
                    } else {
                        MultiDocumentsHandler.this.locale = OfficeSpreadsheetTools.getDocumentLocale(currentDocument.getXComponent());
                    }
                    if (MultiDocumentsHandler.this.locale == null) {
                        MultiDocumentsHandler.this.locale = new Locale("en", "US", "");
                    }
                    MessageHandler.printToLogFile("MultiDocumentsHandler: LtHelper: local: " + OfficeTools.localeToString(MultiDocumentsHandler.this.locale));
                    MultiDocumentsHandler.this.langForShortName = MultiDocumentsHandler.getLanguage(MultiDocumentsHandler.this.locale);
                    if (MultiDocumentsHandler.this.langForShortName == null) continue;
                    MultiDocumentsHandler.this.docLanguage = MultiDocumentsHandler.this.langForShortName;
                    MultiDocumentsHandler.this.lt = MultiDocumentsHandler.this.initLanguageTool(true);
                    MultiDocumentsHandler.this.initCheck(MultiDocumentsHandler.this.lt);
                    MultiDocumentsHandler.this.initDocuments(false);
                }
            }
            catch (Throwable e) {
                MessageHandler.showError(e);
            }
        }
    }

    private class ShapeChangeCheck
    extends Thread {
        boolean runLoop = true;

        private ShapeChangeCheck() {
        }

        @Override
        public void run() {
            try {
                while (this.runLoop && MultiDocumentsHandler.this.textLevelQueue != null) {
                    try {
                        for (int i = 0; i < MultiDocumentsHandler.this.documents.size(); ++i) {
                            ((SingleDocument)MultiDocumentsHandler.this.documents.get(i)).addShapeQueueEntries();
                        }
                        Thread.sleep(1000L);
                    }
                    catch (Throwable t) {
                        MessageHandler.printException(t);
                    }
                }
            }
            catch (Throwable e) {
                MessageHandler.showError(e);
            }
            this.runLoop = false;
        }

        public void stopLoop() {
            this.runLoop = false;
        }

        public boolean isRunning() {
            return this.runLoop;
        }
    }

    private class MoreInfoDialogThread
    extends Thread {
        private final String title;
        private final String message;
        private final Rule rule;
        private final URL matchUrl;
        private final ResourceBundle messages;
        private final String lang;

        MoreInfoDialogThread(String title, String message, Rule rule, URL matchUrl, ResourceBundle messages, String lang) {
            this.title = title;
            this.message = message;
            this.rule = rule;
            this.matchUrl = matchUrl;
            this.messages = messages;
            this.lang = lang;
        }

        @Override
        public void run() {
            try {
                infoDialog = new MoreInfoDialog(this.title, this.message, this.rule, this.matchUrl, this.messages, this.lang);
                infoDialog.show();
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        }
    }

    private class AboutDialogThread
    extends Thread {
        private final ResourceBundle messages;
        private final XComponentContext xContext;

        AboutDialogThread(ResourceBundle messages, XComponentContext xContext) {
            this.messages = messages;
            this.xContext = xContext;
        }

        @Override
        public void run() {
            try {
                aboutDialog = new AboutDialog(this.messages);
                aboutDialog.show(this.xContext);
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        }
    }
}

