/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.languagetool.gui.Tools;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.FalseFriendPatternRule;

public class MoreInfoDialog {
    private final JDialog dialog = new JDialog();
    private final String title;
    private final String message;
    private final Rule rule;
    private final URL matchUrl;
    private final ResourceBundle messages;
    private final String lang;

    public MoreInfoDialog(String title, String message, Rule rule, URL matchUrl, ResourceBundle messages, String lang) {
        this.title = title;
        this.message = message;
        this.rule = rule;
        this.matchUrl = matchUrl;
        this.messages = messages;
        this.lang = lang;
    }

    public void show() {
        try {
            int dialogWidth = 320;
            JTextPane textPane = new JTextPane();
            textPane.setEditable(false);
            textPane.setContentType("text/html");
            textPane.setBorder(BorderFactory.createEmptyBorder());
            textPane.setOpaque(false);
            textPane.setBackground(new Color(0, 0, 0, 0));
            Tools.addHyperlinkListener(textPane);
            textPane.setSize(dialogWidth, Short.MAX_VALUE);
            String messageWithBold = this.message.replaceAll("<suggestion>", "<b>").replaceAll("</suggestion>", "</b>");
            String exampleSentences = Tools.getExampleSentences(this.rule, this.messages);
            String url = "http://community.languagetool.org/rule/show/" + Tools.encodeUrl(this.rule) + "?lang=" + this.lang + "&amp;ref=standalone-gui";
            boolean isExternal = this.rule.getCategory().getLocation() == Category.Location.EXTERNAL;
            String ruleDetailLink = this.rule instanceof FalseFriendPatternRule || isExternal ? "" : "<a href='" + url + "'>" + this.messages.getString("ruleDetailsLink") + "</a>";
            textPane.setText("<html>" + messageWithBold + exampleSentences + Tools.formatURL(this.matchUrl) + "<br><br>" + ruleDetailLink + "</html>");
            JScrollPane scrollPane = new JScrollPane(textPane);
            scrollPane.setPreferredSize(new Dimension(dialogWidth, textPane.getPreferredSize().height));
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            String cleanTitle = this.title.replace("<suggestion>", "'").replace("</suggestion>", "'");
            this.dialog.setName(cleanTitle);
            this.dialog.setTitle(cleanTitle);
            this.dialog.setDefaultCloseOperation(2);
            Image ltImage = OfficeTools.getLtImage();
            ((Frame)this.dialog.getOwner()).setIconImage(ltImage);
            this.dialog.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    MoreInfoDialog.this.close();
                }
            });
            JButton close = new JButton(this.messages.getString("guiOOoCloseButton"));
            close.addActionListener(e -> this.close());
            JPanel infoPanel = new JPanel();
            infoPanel.setLayout(new GridBagLayout());
            GridBagConstraints cons = new GridBagConstraints();
            cons.insets = new Insets(6, 0, 0, 15);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.anchor = 17;
            cons.fill = 0;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            infoPanel.add((Component)textPane, cons);
            JPanel closeButtonPanel = new JPanel();
            closeButtonPanel.setLayout(new GridBagLayout());
            cons = new GridBagConstraints();
            cons.insets = new Insets(6, 12, 0, 15);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.anchor = 13;
            cons.fill = 0;
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            closeButtonPanel.add((Component)close, cons);
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 3));
            panel.add(infoPanel);
            panel.add(closeButtonPanel);
            Container contentPane = this.dialog.getContentPane();
            contentPane.setLayout(new GridBagLayout());
            cons = new GridBagConstraints();
            cons.insets = new Insets(8, 8, 8, 8);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.weightx = 10.0;
            cons.weighty = 10.0;
            cons.fill = 1;
            cons.anchor = 18;
            contentPane.add((Component)panel, cons);
            this.dialog.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension frameSize = this.dialog.getSize();
            this.dialog.setLocation(screenSize.width / 2 - frameSize.width / 2, screenSize.height / 2 - frameSize.height / 2);
            this.dialog.setLocationByPlatform(true);
            this.dialog.setAutoRequestFocus(true);
            this.dialog.setVisible(true);
            this.dialog.setAlwaysOnTop(true);
            this.dialog.toFront();
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    public void close() {
        this.dialog.setVisible(false);
    }
}

