/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.uno.XComponentContext;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.languagetool.JLanguageTool;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.tools.Tools;

public class MessageHandler {
    private static final String logLineBreak = System.lineSeparator();
    private static boolean isOpen = false;
    private static boolean isInit = false;
    private static boolean testMode;

    MessageHandler(XComponentContext xContext) {
        MessageHandler.initLogFile(xContext);
    }

    private static void initLogFile(XComponentContext xContext) {
        if (!isInit) {
            isInit = true;
            try (FileOutputStream stream = new FileOutputStream(OfficeTools.getLogFilePath(xContext));
                 OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
                 BufferedWriter br = new BufferedWriter(writer);){
                Date date = new Date();
                OfficeTools.OfficeProductInfo officeInfo = OfficeTools.getOfficeProductInfo(xContext);
                writer.write("LT office integration log from " + date + logLineBreak + logLineBreak);
                writer.write("LanguageTool " + JLanguageTool.VERSION + " (" + JLanguageTool.BUILD_DATE + ", " + JLanguageTool.GIT_SHORT_ID + ")" + logLineBreak);
                writer.write("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " on " + System.getProperty("os.arch") + logLineBreak);
                if (officeInfo != null) {
                    writer.write(officeInfo.ooName + " " + officeInfo.ooVersion + officeInfo.ooExtension + " (" + officeInfo.ooVendor + "), " + officeInfo.ooLocale + logLineBreak);
                }
                writer.write(OfficeTools.getJavaInformation() + logLineBreak + logLineBreak);
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        }
    }

    static void init(XComponentContext xContext) {
        MessageHandler.initLogFile(xContext);
    }

    public static void showError(Throwable e) {
        MessageHandler.printException(e);
        if (testMode) {
            throw new RuntimeException(e);
        }
        String msg = "An error has occurred in LanguageTool " + JLanguageTool.VERSION + " (" + JLanguageTool.BUILD_DATE + "):\n" + e + "\nStacktrace:\n";
        msg = msg + Tools.getFullStackTrace(e);
        String metaInfo = "OS: " + System.getProperty("os.name") + " on " + System.getProperty("os.arch") + ", Java version " + System.getProperty("java.version") + " from " + System.getProperty("java.vm.vendor");
        msg = msg + metaInfo;
        DialogThread dt = new DialogThread(msg, true);
        e.printStackTrace();
        dt.start();
    }

    public static void printToLogFile(String str) {
        try (FileOutputStream stream = new FileOutputStream(OfficeTools.getLogFilePath(), true);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8);
             BufferedWriter br = new BufferedWriter(writer);){
            writer.write(str + logLineBreak);
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    public static void printException(Throwable t) {
        MessageHandler.printToLogFile(Tools.getFullStackTrace(t));
    }

    static void setTestMode(boolean mode) {
        testMode = mode;
    }

    public static void showMessage(String txt) {
        MessageHandler.showMessage(txt, true);
    }

    static void showMessage(String txt, boolean toLogFile) {
        if (toLogFile) {
            MessageHandler.printToLogFile(txt);
        }
        DialogThread dt = new DialogThread(txt, false);
        dt.run();
    }

    public static void showFullStackMessage(String msg) {
        try {
            throw new RuntimeException(msg);
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
            return;
        }
    }

    static void showClosingInformationDialog(String text) {
        ClosingInformationThread informationDialog = new ClosingInformationThread(text);
        informationDialog.start();
    }

    private static class ClosingInformationThread
    extends Thread {
        private final String text;
        JDialog dialog;

        ClosingInformationThread(String text) {
            this.text = text;
        }

        @Override
        public void run() {
            JOptionPane pane = new JOptionPane(this.text, 1);
            this.dialog = pane.createDialog(null, UIManager.getString((Object)"OptionPane.messageDialogTitle", null));
            this.dialog.setModal(false);
            this.dialog.setAutoRequestFocus(true);
            this.dialog.setAlwaysOnTop(true);
            this.dialog.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    dialog.setVisible(false);
                }
            });
            this.dialog.setVisible(true);
        }
    }

    private static class DialogThread
    extends Thread {
        private final String text;
        private boolean isException;

        DialogThread(String text, boolean isException) {
            this.text = text;
            this.isException = isException;
        }

        @Override
        public void run() {
            if (this.isException) {
                if (!isOpen) {
                    isOpen = true;
                    JOptionPane.showMessageDialog(null, this.text);
                    isOpen = false;
                }
            } else {
                JOptionPane.showMessageDialog(null, this.text);
            }
        }
    }
}

