/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XServiceDisplayName;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleComponentFactory;
import com.sun.star.lib.uno.helper.Factory;
import com.sun.star.lib.uno.helper.WeakBase;
import com.sun.star.linguistic2.XSpellAlternatives;
import com.sun.star.linguistic2.XSpellChecker;
import com.sun.star.registry.XRegistryKey;
import com.sun.star.uno.XComponentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.openoffice.CacheIO;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SingletonFactory;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.HunspellRule;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public class LtSpellChecker
extends WeakBase
implements XServiceInfo,
XServiceDisplayName,
XSpellChecker {
    private static final boolean DEBUG_MODE = false;
    private static final int MAX_WRONG = 10000;
    private static final String PROB_CHARS = ".*[~<> ].*";
    private static final String[] SERVICE_NAMES = new String[]{"com.sun.star.linguistic2.SpellChecker", "org.languagetool.openoffice.LanguageToolSpellChecker"};
    private static JLanguageTool lt = null;
    private static Locale lastLocale = null;
    private static SpellingCheckRule spellingCheckRule = null;
    private static MorfologikSpellerRule mSpellRule = null;
    private static HunspellRule hSpellRule = null;
    private static final Map<String, List<String>> lastWrongWords = new HashMap<String, List<String>>();
    private static final Map<String, List<String[]>> lastSuggestions = new HashMap<String, List<String[]>>();
    private static XComponentContext xContext = null;
    private static boolean noLtSpeller = false;

    public LtSpellChecker(XComponentContext xContxt) {
        if (xContext == null) {
            try {
                xContext = xContxt;
                MessageHandler.init(xContext);
                OfficeTools.OfficeProductInfo officeInfo = OfficeTools.getOfficeProductInfo(xContext);
                if (officeInfo == null || officeInfo.osArch.equals("x86") || !LtSpellChecker.isEnoughHeap() || !LtSpellChecker.runLTSpellChecker(xContext)) {
                    noLtSpeller = true;
                } else {
                    CacheIO c = new CacheIO();
                    CacheIO.SpellCache sc = c.new CacheIO.SpellCache();
                    if (sc.read() && sc.getWrongWords() != null && sc.getSuggestions() != null && sc.getWrongWords().size() == sc.getSuggestions().size()) {
                        for (String loc : sc.getWrongWords().keySet()) {
                            if (sc.getWrongWords().get(loc).isEmpty()) continue;
                            List<String> savedLastWords = sc.getWrongWords().get(loc);
                            List<String[]> savedSuggestions = sc.getSuggestions().get(loc);
                            ArrayList<String> lastWords = new ArrayList<String>();
                            ArrayList<String[]> suggestions = new ArrayList<String[]>();
                            for (int i = 0; i < sc.getWrongWords().get(loc).size() && i < 10000; ++i) {
                                lastWords.add(savedLastWords.get(i));
                                suggestions.add(savedSuggestions.get(i));
                            }
                            lastWrongWords.put(loc, lastWords);
                            lastSuggestions.put(loc, suggestions);
                        }
                    }
                }
            }
            catch (Throwable e) {
                MessageHandler.showError(e);
            }
        }
    }

    public static XSingleComponentFactory __getComponentFactory(String sImplName) {
        SingletonFactory xFactory = null;
        if (sImplName.equals(LtSpellChecker.class.getName())) {
            xFactory = new SingletonFactory(true);
        }
        return xFactory;
    }

    public static boolean __writeRegistryServiceInfo(XRegistryKey regKey) {
        return Factory.writeRegistryServiceInfo((String)LtSpellChecker.class.getName(), (String[])LtSpellChecker.getServiceNames(), (XRegistryKey)regKey);
    }

    public Locale[] getLocales() {
        if (noLtSpeller) {
            return new Locale[0];
        }
        return MultiDocumentsHandler.getLocales();
    }

    public boolean hasLocale(Locale locale) {
        return MultiDocumentsHandler.hasLocale(locale);
    }

    public String getImplementationName() {
        return LtSpellChecker.class.getName();
    }

    public String[] getSupportedServiceNames() {
        return LtSpellChecker.getServiceNames();
    }

    static String[] getServiceNames() {
        return SERVICE_NAMES;
    }

    public boolean supportsService(String sServiceName) {
        for (String sName : SERVICE_NAMES) {
            if (!sServiceName.equals(sName)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(String word, Locale locale, PropertyValue[] Properties2) throws IllegalArgumentException {
        try {
            if (noLtSpeller || locale == null || !this.hasLocale(locale)) {
                return false;
            }
            if (word == null || word.trim().isEmpty()) {
                return true;
            }
            String localeStr = OfficeTools.localeToString(locale);
            List<String> wrongWords = lastWrongWords.get(localeStr);
            if (word.matches(PROB_CHARS)) {
                return false;
            }
            if (wrongWords != null && wrongWords.contains(word)) {
                return false;
            }
            this.initSpellChecker(locale);
            if (spellingCheckRule != null) {
                if (!spellingCheckRule.isMisspelled(word)) {
                    return true;
                }
                List<RuleMatch> matches = lt.check(word, true, JLanguageTool.ParagraphHandling.ONLYNONPARA);
                if (matches == null || matches.size() == 0) {
                    return true;
                }
                if (wrongWords == null) {
                    lastWrongWords.put(localeStr, new ArrayList());
                    lastSuggestions.put(localeStr, new ArrayList());
                }
                if (!lastWrongWords.get(localeStr).contains(word)) {
                    lastWrongWords.get(localeStr).add(new String(word));
                    lastSuggestions.get(localeStr).add(this.suggestionsToArray(matches.get(0).getSuggestedReplacements()));
                    if (lastWrongWords.get(localeStr).size() >= 10000) {
                        lastWrongWords.get(localeStr).remove(0);
                        lastSuggestions.get(localeStr).remove(0);
                    }
                }
                return false;
            }
        }
        catch (Throwable e) {
            MessageHandler.showError(e);
        }
        MessageHandler.printToLogFile("LtSpellChecker: isValid: Problem with spelling rule: word: " + (word == null ? "null" : word));
        return false;
    }

    public XSpellAlternatives spell(String word, Locale locale, PropertyValue[] properties) throws IllegalArgumentException {
        LTSpellAlternatives alternatives = new LTSpellAlternatives(word, locale);
        return alternatives;
    }

    private void initSpellChecker(Locale locale) {
        try {
            if (lastLocale == null || !OfficeTools.isEqualLocale(lastLocale, locale)) {
                lastLocale = locale;
                Language lang = MultiDocumentsHandler.getLanguage(locale);
                lt = new JLanguageTool(lang);
                for (Rule rule : lt.getAllRules()) {
                    if (rule.isDictionaryBasedSpellingRule()) {
                        spellingCheckRule = (SpellingCheckRule)rule;
                        if (spellingCheckRule instanceof MorfologikSpellerRule) {
                            mSpellRule = (MorfologikSpellerRule)spellingCheckRule;
                            hSpellRule = null;
                            continue;
                        }
                        if (!(spellingCheckRule instanceof HunspellRule)) continue;
                        hSpellRule = (HunspellRule)spellingCheckRule;
                        mSpellRule = null;
                        continue;
                    }
                    lt.disableRule(rule.getId());
                }
            }
        }
        catch (Throwable e) {
            MessageHandler.showError(e);
        }
    }

    private String[] suggestionsToArray(List<String> suggestions) {
        int numSuggestions = suggestions.size();
        String[] allSuggestions = suggestions.toArray(new String[numSuggestions]);
        if (allSuggestions.length > 25) {
            allSuggestions = Arrays.copyOfRange(allSuggestions, 0, 25);
        }
        return allSuggestions;
    }

    public String getServiceDisplayName(Locale locale) {
        return MultiDocumentsHandler.getServiceDisplayName(locale);
    }

    public static Map<String, List<String>> getWrongWords() {
        return lastWrongWords;
    }

    public static Map<String, List<String[]>> getSuggestions() {
        return lastSuggestions;
    }

    public static boolean runLTSpellChecker(XComponentContext xContext) {
        try {
            Configuration confg = new Configuration(OfficeTools.getLOConfigDir(xContext), "Languagetool.cfg", OfficeTools.getOldConfigFile(), null, true);
            return confg.useLtSpellChecker();
        }
        catch (IOException e) {
            MessageHandler.printToLogFile("Can't read configuration: LT spell checker not used!");
            return false;
        }
    }

    public static boolean isEnoughHeap() {
        boolean ret;
        int maxHeapSpace = (int)(OfficeTools.getMaxHeapSpace() / 1048576.0);
        boolean bl = ret = maxHeapSpace >= 850;
        if (!ret) {
            MessageHandler.printToLogFile("Heap Space (" + maxHeapSpace + ") is too small: LT spell checker not used!\nSet heap space greater than " + 850);
        }
        return ret;
    }

    public static void resetSpellCache() {
        lastWrongWords.clear();
        lastSuggestions.clear();
    }

    class LTSpellAlternatives
    implements XSpellAlternatives {
        Locale locale;
        String word;
        String[] alternatives = null;

        LTSpellAlternatives(String word, Locale locale) {
            try {
                this.word = word;
                this.locale = locale;
                if (noLtSpeller) {
                    this.alternatives = new String[0];
                    return;
                }
                String localeStr = OfficeTools.localeToString(locale);
                if (word == null || word.trim().isEmpty() || localeStr == null || localeStr.isEmpty()) {
                    this.alternatives = new String[0];
                    return;
                }
                List wrongWords = (List)lastWrongWords.get(localeStr);
                List suggestions = (List)lastSuggestions.get(localeStr);
                if (wrongWords != null && suggestions != null && wrongWords.contains(word)) {
                    int num = wrongWords.indexOf(word);
                    this.alternatives = (String[])suggestions.get(num);
                    if (this.alternatives == null) {
                        this.alternatives = new String[0];
                    }
                    return;
                }
                if (word.matches(LtSpellChecker.PROB_CHARS)) {
                    this.alternatives = new String[0];
                    return;
                }
                if (mSpellRule != null) {
                    this.alternatives = mSpellRule.getSpellingSuggestions(word).toArray(new String[0]);
                }
                if (hSpellRule != null) {
                    this.alternatives = hSpellRule.getSuggestions(word).toArray(new String[0]);
                }
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
            if (this.alternatives == null) {
                this.alternatives = new String[0];
            }
        }

        public String[] getAlternatives() {
            return this.alternatives;
        }

        public short getAlternativesCount() {
            return (short)this.alternatives.length;
        }

        public short getFailureType() {
            return 0;
        }

        public Locale getLocale() {
            if (this.locale == null) {
                return lastLocale;
            }
            return this.locale;
        }

        public String getWord() {
            if (this.word == null) {
                return "";
            }
            return this.word;
        }
    }
}

