/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.awt.MenuEvent;
import com.sun.star.awt.XMenuBar;
import com.sun.star.awt.XMenuListener;
import com.sun.star.awt.XPopupMenu;
import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XIndexContainer;
import com.sun.star.frame.XController;
import com.sun.star.frame.XModel;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextRange;
import com.sun.star.ui.ContextMenuExecuteEvent;
import com.sun.star.ui.ContextMenuInterceptorAction;
import com.sun.star.ui.XContextMenuInterception;
import com.sun.star.ui.XContextMenuInterceptor;
import com.sun.star.uno.Any;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.view.XSelectionSupplier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.openoffice.LtDictionary;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.stylestatistic.StatAnDialog;

public class LtMenus {
    public static final String LT_IGNORE_ONCE_COMMAND = "service:org.languagetool.openoffice.Main?ignoreOnce";
    public static final String LT_IGNORE_PERMANENT_COMMAND = "service:org.languagetool.openoffice.Main?ignorePermanent";
    public static final String LT_DEACTIVATE_RULE_COMMAND = "service:org.languagetool.openoffice.Main?deactivateRule";
    public static final String LT_MORE_INFO_COMMAND = "service:org.languagetool.openoffice.Main?moreInfo";
    public static final String LT_ACTIVATE_RULES_COMMAND = "service:org.languagetool.openoffice.Main?activateRules";
    public static final String LT_ACTIVATE_RULE_COMMAND = "service:org.languagetool.openoffice.Main?activateRule_";
    public static final String LT_REMOTE_HINT_COMMAND = "service:org.languagetool.openoffice.Main?remoteHint";
    public static final String LT_RENEW_MARKUPS_COMMAND = "service:org.languagetool.openoffice.Main?renewMarkups";
    public static final String LT_ADD_TO_DICTIONARY_COMMAND = "service:org.languagetool.openoffice.Main?addToDictionary_";
    public static final String LT_NEXT_ERROR_COMMAND = "service:org.languagetool.openoffice.Main?nextError";
    public static final String LT_CHECKDIALOG_COMMAND = "service:org.languagetool.openoffice.Main?checkDialog";
    public static final String LT_CHECKAGAINDIALOG_COMMAND = "service:org.languagetool.openoffice.Main?checkAgainDialog";
    public static final String LT_STATISTICAL_ANALYSES_COMMAND = "service:org.languagetool.openoffice.Main?statisticalAnalyses";
    public static final String LT_OFF_STATISTICAL_ANALYSES_COMMAND = "service:org.languagetool.openoffice.Main?offStatisticalAnalyses";
    public static final String LT_RESET_IGNORE_PERMANENT_COMMAND = "service:org.languagetool.openoffice.Main?resetIgnorePermanent";
    public static final String LT_TOGGLE_BACKGROUND_CHECK_COMMAND = "service:org.languagetool.openoffice.Main?toggleNoBackgroundCheck";
    public static final String LT_BACKGROUND_CHECK_ON_COMMAND = "service:org.languagetool.openoffice.Main?backgroundCheckOn";
    public static final String LT_BACKGROUND_CHECK_OFF_COMMAND = "service:org.languagetool.openoffice.Main?backgroundCheckOff";
    public static final String LT_REFRESH_CHECK_COMMAND = "service:org.languagetool.openoffice.Main?refreshCheck";
    public static final String LT_ABOUT_COMMAND = "service:org.languagetool.openoffice.Main?about";
    public static final String LT_LANGUAGETOOL_COMMAND = "service:org.languagetool.openoffice.Main?lt";
    public static final String LT_OPTIONS_COMMAND = "service:org.languagetool.openoffice.Main?configure";
    public static final String LT_PROFILES_COMMAND = "service:org.languagetool.openoffice.Main?profiles";
    public static final String LT_PROFILE_COMMAND = "service:org.languagetool.openoffice.Main?profileChangeTo_";
    public static final String LT_MENU_REPLACE_COLON = ":";
    private static final ResourceBundle MESSAGES = JLanguageTool.getMessageBundle();
    private static final int SUBMENU_ID_DIFF = 21;
    private static final String TOOLS_COMMAND = ".uno:ToolsMenu";
    private static final String COMMAND_BEFORE_LT_MENU = ".uno:LanguageMenu";
    private static final String IGNORE_ONCE_URL = "slot:201";
    private static final String ADD_TO_DICTIONARY_2 = "slot:2";
    private static final String ADD_TO_DICTIONARY_3 = "slot:3";
    private static final String SPEll_DIALOG_URL = "slot:4";
    private static boolean debugMode;
    private static boolean debugModeTm;
    private static boolean isRunning;
    private XComponentContext xContext;
    private XComponent xComponent;
    private SingleDocument document;
    private Configuration config;
    private boolean isRemote;
    private LTHeadMenu ltHeadMenu;
    private ContextMenuInterceptor ltContextMenu;

    LtMenus(XComponentContext xContext, SingleDocument document, Configuration config) {
        try {
            debugMode = OfficeTools.DEBUG_MODE_LM;
            debugModeTm = OfficeTools.DEBUG_MODE_TM;
            this.document = document;
            this.xContext = xContext;
            this.xComponent = document.getXComponent();
            this.setConfigValues(config);
            if (document.getDocumentType() == OfficeTools.DocumentType.WRITER) {
                this.ltHeadMenu = new LTHeadMenu(this.xComponent);
            }
            this.ltContextMenu = new ContextMenuInterceptor(this.xComponent);
            if (debugMode) {
                MessageHandler.printToLogFile("LanguageToolMenus initialised");
            }
        }
        catch (Throwable t) {
            MessageHandler.showError(t);
        }
    }

    void setConfigValues(Configuration config) {
        this.config = config;
        if (config != null) {
            this.isRemote = config.doRemoteCheck();
        }
    }

    void removeListener() {
        if (this.ltHeadMenu != null) {
            this.ltHeadMenu.removeListener();
        }
    }

    void addListener() {
        if (this.ltHeadMenu != null) {
            this.ltHeadMenu.addListener();
        }
    }

    String replaceColon(String str) {
        return str == null ? null : str.replace(LT_MENU_REPLACE_COLON, LT_MENU_REPLACE_COLON);
    }

    static {
        isRunning = false;
    }

    private class ContextMenuInterceptor
    implements XContextMenuInterceptor {
        public ContextMenuInterceptor() {
        }

        public ContextMenuInterceptor(XComponent xComponent) {
            try {
                XModel xModel = (XModel)UnoRuntime.queryInterface(XModel.class, (Object)xComponent);
                if (xModel == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: ContextMenuInterceptor: XModel not found!");
                    return;
                }
                XController xController = xModel.getCurrentController();
                if (xController == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: ContextMenuInterceptor: xController == null");
                    return;
                }
                XContextMenuInterception xContextMenuInterception = (XContextMenuInterception)UnoRuntime.queryInterface(XContextMenuInterception.class, (Object)xController);
                if (xContextMenuInterception == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: ContextMenuInterceptor: xContextMenuInterception == null");
                    return;
                }
                ContextMenuInterceptor aContextMenuInterceptor = new ContextMenuInterceptor();
                XContextMenuInterceptor xContextMenuInterceptor = (XContextMenuInterceptor)UnoRuntime.queryInterface(XContextMenuInterceptor.class, (Object)aContextMenuInterceptor);
                if (xContextMenuInterceptor == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: ContextMenuInterceptor: xContextMenuInterceptor == null");
                    return;
                }
                xContextMenuInterception.registerContextMenuInterceptor(xContextMenuInterceptor);
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
            }
        }

        public ContextMenuInterceptorAction notifyContextMenuExecute(ContextMenuExecuteEvent aEvent) {
            try {
                long runTime;
                if (isRunning) {
                    MessageHandler.printToLogFile("LanguageToolMenus: notifyContextMenuExecute: is running: no change in Menu");
                    return ContextMenuInterceptorAction.IGNORED;
                }
                isRunning = true;
                long startTime = 0L;
                if (debugModeTm) {
                    startTime = System.currentTimeMillis();
                    MessageHandler.printToLogFile("Generate context menu started");
                }
                XIndexContainer xContextMenu = aEvent.ActionTriggerContainer;
                if (debugMode) {
                    MessageHandler.printToLogFile("LanguageToolMenus: notifyContextMenuExecute: get xContextMenu");
                }
                if (LtMenus.this.document.getDocumentType() == OfficeTools.DocumentType.IMPRESS) {
                    long runTime2;
                    XMultiServiceFactory xMenuElementFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xContextMenu);
                    XPropertySet xNewMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                    xNewMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuGrammarCheck"));
                    xNewMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_CHECKDIALOG_COMMAND);
                    xContextMenu.insertByIndex(0, (Object)xNewMenuEntry);
                    XPropertySet xSeparator = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTriggerSeparator"));
                    xSeparator.setPropertyValue("SeparatorType", (Object)0);
                    xContextMenu.insertByIndex(1, (Object)xSeparator);
                    if (debugModeTm && (runTime2 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                        MessageHandler.printToLogFile("Time to generate context menu (Impress): " + runTime2);
                    }
                    isRunning = false;
                    if (debugMode) {
                        MessageHandler.printToLogFile("LanguageToolMenus: notifyContextMenuExecute: execute modified for Impress");
                    }
                    return ContextMenuInterceptorAction.EXECUTE_MODIFIED;
                }
                int count = xContextMenu.getCount();
                if (debugMode) {
                    for (int i = 0; i < count; ++i) {
                        Any a = (Any)xContextMenu.getByIndex(i);
                        XPropertySet props = (XPropertySet)a.getObject();
                        this.printProperties(props);
                    }
                }
                LtMenus.this.document.setMenuDocId();
                XMultiServiceFactory xMenuElementFactory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xContextMenu);
                for (int i = 0; i < count; ++i) {
                    long runTime3;
                    Any a = (Any)xContextMenu.getByIndex(i);
                    XPropertySet props = (XPropertySet)a.getObject();
                    String str = null;
                    if (props.getPropertySetInfo().hasPropertyByName("CommandURL")) {
                        str = props.getPropertyValue("CommandURL").toString();
                    }
                    if (str == null || !LtMenus.IGNORE_ONCE_URL.equals(str)) continue;
                    boolean isSpellError = false;
                    for (int n = i + 1; n < count; ++n) {
                        a = (Any)xContextMenu.getByIndex(n);
                        XPropertySet tmpProps = (XPropertySet)a.getObject();
                        if (tmpProps.getPropertySetInfo().hasPropertyByName("CommandURL")) {
                            str = tmpProps.getPropertyValue("CommandURL").toString();
                        }
                        if (LtMenus.ADD_TO_DICTIONARY_2.equals(str) || LtMenus.ADD_TO_DICTIONARY_3.equals(str)) {
                            isSpellError = true;
                            String wrongWord = this.getSelectedWord(aEvent);
                            if (debugMode) {
                                MessageHandler.printToLogFile("LanguageToolMenus: notifyContextMenuExecute: wrong word: " + wrongWord);
                            }
                            if (wrongWord == null || wrongWord.isEmpty()) continue;
                            if (wrongWord.charAt(wrongWord.length() - 1) == '.') {
                                wrongWord = wrongWord.substring(0, wrongWord.length() - 1);
                            }
                            if (wrongWord.isEmpty()) continue;
                            XIndexContainer xSubMenuContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTriggerContainer"));
                            int j = 0;
                            for (String dict : LtDictionary.getUserDictionaries(LtMenus.this.xContext)) {
                                XPropertySet xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                                xNewSubMenuEntry.setPropertyValue("Text", (Object)dict);
                                xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)(LtMenus.LT_ADD_TO_DICTIONARY_COMMAND + dict + LtMenus.LT_MENU_REPLACE_COLON + wrongWord));
                                xSubMenuContainer.insertByIndex(j, (Object)xNewSubMenuEntry);
                                ++j;
                            }
                            XPropertySet xNewMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                            xNewMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuAddToDictionary"));
                            xNewMenuEntry.setPropertyValue("SubContainer", (Object)xSubMenuContainer);
                            xContextMenu.removeByIndex(n);
                            xContextMenu.insertByIndex(n, (Object)xNewMenuEntry);
                            continue;
                        }
                        if (!LtMenus.SPEll_DIALOG_URL.equals(str)) continue;
                        XPropertySet xNewMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                        xNewMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("checkTextShortDesc"));
                        xNewMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_CHECKDIALOG_COMMAND);
                        xContextMenu.removeByIndex(n);
                        xContextMenu.insertByIndex(n, (Object)xNewMenuEntry);
                        break;
                    }
                    if (isSpellError) continue;
                    if (LtMenus.this.document.getCurrentNumberOfParagraph() >= 0) {
                        props.setPropertyValue("CommandURL", (Object)LtMenus.LT_IGNORE_ONCE_COMMAND);
                    }
                    XPropertySet xNewMenuEntry3 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                    xNewMenuEntry3.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuIgnorePermanent"));
                    xNewMenuEntry3.setPropertyValue("CommandURL", (Object)LtMenus.LT_IGNORE_PERMANENT_COMMAND);
                    xContextMenu.insertByIndex(i + 1, (Object)xNewMenuEntry3);
                    XPropertySet xNewMenuEntry1 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                    xNewMenuEntry1.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuDeactivateRule"));
                    xNewMenuEntry1.setPropertyValue("CommandURL", (Object)LtMenus.LT_DEACTIVATE_RULE_COMMAND);
                    xContextMenu.insertByIndex(i + 3, (Object)xNewMenuEntry1);
                    int nId = i + 4;
                    Map<String, String> deactivatedRulesMap = LtMenus.this.document.getMultiDocumentsHandler().getDisabledRulesMap(null);
                    if (!deactivatedRulesMap.isEmpty()) {
                        xContextMenu.insertByIndex(nId, (Object)this.createActivateRuleProfileItems(deactivatedRulesMap, xMenuElementFactory));
                        ++nId;
                    }
                    if (LtMenus.this.isRemote) {
                        XPropertySet xNewMenuEntry2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                        xNewMenuEntry2.setPropertyValue("Text", (Object)MESSAGES.getString("loMenuRemoteInfo"));
                        xNewMenuEntry2.setPropertyValue("CommandURL", (Object)LtMenus.LT_REMOTE_HINT_COMMAND);
                        xContextMenu.insertByIndex(nId, (Object)xNewMenuEntry2);
                        ++nId;
                    }
                    XPropertySet xNewMenuEntry4 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                    xNewMenuEntry4.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuRenewMarkups"));
                    xNewMenuEntry4.setPropertyValue("CommandURL", (Object)LtMenus.LT_RENEW_MARKUPS_COMMAND);
                    xContextMenu.insertByIndex(nId, (Object)xNewMenuEntry4);
                    ++nId;
                    List<String> definedProfiles = LtMenus.this.config.getDefinedProfiles();
                    if (definedProfiles.size() > 1) {
                        xContextMenu.insertByIndex(nId, (Object)this.createProfileItems(definedProfiles, xMenuElementFactory));
                        ++nId;
                    }
                    this.addLTMenuEntry(nId, xContextMenu, xMenuElementFactory, false);
                    XPropertySet xNewMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                    xNewMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("guiMore"));
                    xNewMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_MORE_INFO_COMMAND);
                    xContextMenu.insertByIndex(1, (Object)xNewMenuEntry);
                    if (debugModeTm && (runTime3 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                        MessageHandler.printToLogFile("Time to generate context menu (grammar error): " + runTime3);
                    }
                    isRunning = false;
                    if (debugMode) {
                        MessageHandler.printToLogFile("LanguageToolMenus: notifyContextMenuExecute: execute modified for Writer");
                    }
                    return ContextMenuInterceptorAction.EXECUTE_MODIFIED;
                }
                XPropertySet xSeparator = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTriggerSeparator"));
                xSeparator.setPropertyValue("SeparatorType", (Object)0);
                xContextMenu.insertByIndex(count, (Object)xSeparator);
                int nId = count + 1;
                if (LtMenus.this.isRemote) {
                    XPropertySet xNewMenuEntry2 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                    xNewMenuEntry2.setPropertyValue("Text", (Object)MESSAGES.getString("loMenuRemoteInfo"));
                    xNewMenuEntry2.setPropertyValue("CommandURL", (Object)LtMenus.LT_REMOTE_HINT_COMMAND);
                    xContextMenu.insertByIndex(nId, (Object)xNewMenuEntry2);
                    ++nId;
                }
                XPropertySet xNewMenuEntry4 = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                xNewMenuEntry4.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuRenewMarkups"));
                xNewMenuEntry4.setPropertyValue("CommandURL", (Object)LtMenus.LT_RENEW_MARKUPS_COMMAND);
                xContextMenu.insertByIndex(nId, (Object)xNewMenuEntry4);
                this.addLTMenuEntry(++nId, xContextMenu, xMenuElementFactory, true);
                if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                    MessageHandler.printToLogFile("Time to generate context menu (no grammar error): " + runTime);
                }
                isRunning = false;
                if (debugMode) {
                    MessageHandler.printToLogFile("LanguageToolMenus: notifyContextMenuExecute: execute modified for Writer (no grammar error)");
                }
                return ContextMenuInterceptorAction.CONTINUE_MODIFIED;
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
                isRunning = false;
                MessageHandler.printToLogFile("LanguageToolMenus: notifyContextMenuExecute: no change in Menu");
                return ContextMenuInterceptorAction.IGNORED;
            }
        }

        private void addLTMenuEntry(int nId, XIndexContainer xContextMenu, XMultiServiceFactory xMenuElementFactory, boolean showAll) throws Throwable {
            XPropertySet xNewSubMenuEntry;
            XIndexContainer xSubMenuContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTriggerContainer"));
            boolean hasStatisticalStyleRules = LtMenus.this.document.getDocumentType() == OfficeTools.DocumentType.WRITER && !LtMenus.this.document.getMultiDocumentsHandler().isBackgroundCheckOff() ? OfficeTools.hasStatisticalStyleRules(LtMenus.this.document.getLanguage()) : false;
            int j = 0;
            if (showAll) {
                xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("checkTextShortDesc"));
                xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_CHECKDIALOG_COMMAND);
                xSubMenuContainer.insertByIndex(j, (Object)xNewSubMenuEntry);
                ++j;
            }
            if (hasStatisticalStyleRules) {
                xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loStatisticalAnalysis"));
                xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_STATISTICAL_ANALYSES_COMMAND);
                xSubMenuContainer.insertByIndex(j, (Object)xNewSubMenuEntry);
                ++j;
            }
            xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loMenuResetIgnorePermanent"));
            xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_RESET_IGNORE_PERMANENT_COMMAND);
            xSubMenuContainer.insertByIndex(j, (Object)xNewSubMenuEntry);
            ++j;
            xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            if (LtMenus.this.document.getMultiDocumentsHandler().isBackgroundCheckOff()) {
                xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loMenuEnableBackgroundCheck"));
                xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_BACKGROUND_CHECK_ON_COMMAND);
            } else {
                xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loMenuDisableBackgroundCheck"));
                xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_BACKGROUND_CHECK_OFF_COMMAND);
            }
            xSubMenuContainer.insertByIndex(j, (Object)xNewSubMenuEntry);
            xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuRefreshCheck"));
            xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_REFRESH_CHECK_COMMAND);
            xSubMenuContainer.insertByIndex(++j, (Object)xNewSubMenuEntry);
            Map<String, String> deactivatedRulesMap = LtMenus.this.document.getMultiDocumentsHandler().getDisabledRulesMap(null);
            if (showAll && !deactivatedRulesMap.isEmpty()) {
                xSubMenuContainer.insertByIndex(++j, (Object)this.createActivateRuleProfileItems(deactivatedRulesMap, xMenuElementFactory));
            }
            List<String> definedProfiles = LtMenus.this.config.getDefinedProfiles();
            if (showAll && definedProfiles.size() > 1) {
                xSubMenuContainer.insertByIndex(++j, (Object)this.createProfileItems(definedProfiles, xMenuElementFactory));
            }
            xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuOptions"));
            xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_OPTIONS_COMMAND);
            xSubMenuContainer.insertByIndex(++j, (Object)xNewSubMenuEntry);
            xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuAbout"));
            xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_ABOUT_COMMAND);
            xSubMenuContainer.insertByIndex(++j, (Object)xNewSubMenuEntry);
            XPropertySet xNewMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            xNewMenuEntry.setPropertyValue("Text", (Object)"LanguageTool");
            xNewMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_LANGUAGETOOL_COMMAND);
            xNewMenuEntry.setPropertyValue("SubContainer", (Object)xSubMenuContainer);
            xContextMenu.insertByIndex(nId, (Object)xNewMenuEntry);
        }

        private XPropertySet createActivateRuleProfileItems(Map<String, String> deactivatedRulesMap, XMultiServiceFactory xMenuElementFactory) throws Throwable {
            XPropertySet xNewSubMenuEntry;
            XIndexContainer xRuleMenuContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTriggerContainer"));
            int nPos = 0;
            for (String ruleId : deactivatedRulesMap.keySet()) {
                xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                xNewSubMenuEntry.setPropertyValue("Text", (Object)deactivatedRulesMap.get(ruleId));
                xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)(LtMenus.LT_ACTIVATE_RULE_COMMAND + ruleId));
                xRuleMenuContainer.insertByIndex(nPos, (Object)xNewSubMenuEntry);
                ++nPos;
            }
            xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loContextMenuActivateRule"));
            xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_ACTIVATE_RULES_COMMAND);
            xNewSubMenuEntry.setPropertyValue("SubContainer", (Object)xRuleMenuContainer);
            return xNewSubMenuEntry;
        }

        private XPropertySet createProfileItems(List<String> definedProfiles, XMultiServiceFactory xMenuElementFactory) throws Exception {
            definedProfiles.sort(null);
            XIndexContainer xRuleMenuContainer = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTriggerContainer"));
            XPropertySet xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("guiUserProfile"));
            xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_PROFILE_COMMAND);
            xRuleMenuContainer.insertByIndex(0, (Object)xNewSubMenuEntry);
            for (int i = 0; i < definedProfiles.size(); ++i) {
                xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
                xNewSubMenuEntry.setPropertyValue("Text", (Object)definedProfiles.get(i));
                xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)(LtMenus.LT_PROFILE_COMMAND + LtMenus.this.replaceColon(definedProfiles.get(i))));
                xRuleMenuContainer.insertByIndex(i + 1, (Object)xNewSubMenuEntry);
            }
            xNewSubMenuEntry = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMenuElementFactory.createInstance("com.sun.star.ui.ActionTrigger"));
            xNewSubMenuEntry.setPropertyValue("Text", (Object)MESSAGES.getString("loMenuChangeProfiles"));
            xNewSubMenuEntry.setPropertyValue("CommandURL", (Object)LtMenus.LT_PROFILES_COMMAND);
            xNewSubMenuEntry.setPropertyValue("SubContainer", (Object)xRuleMenuContainer);
            return xNewSubMenuEntry;
        }

        private String getSelectedWord(ContextMenuExecuteEvent aEvent) {
            try {
                XSelectionSupplier xSelectionSupplier = aEvent.Selection;
                Object selection = xSelectionSupplier.getSelection();
                XIndexAccess xIndexAccess = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)selection);
                if (xIndexAccess == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: getSelectedWord: xIndexAccess == null");
                    return null;
                }
                XTextRange xTextRange = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xIndexAccess.getByIndex(0));
                if (xTextRange == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: getSelectedWord: xTextRange == null");
                    return null;
                }
                return xTextRange.getString();
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
                return null;
            }
        }

        private void printProperties(XPropertySet props) throws Throwable {
            Property[] propInfo;
            for (Property property : propInfo = props.getPropertySetInfo().getProperties()) {
                MessageHandler.printToLogFile("LanguageToolMenus: Property: Name: " + property.Name + ", Type: " + property.Type);
            }
            if (props.getPropertySetInfo().hasPropertyByName("Text")) {
                MessageHandler.printToLogFile("LanguageToolMenus: Property: Name: " + props.getPropertyValue("Text"));
            }
            if (props.getPropertySetInfo().hasPropertyByName("CommandURL")) {
                MessageHandler.printToLogFile("LanguageToolMenus: Property: CommandURL: " + props.getPropertyValue("CommandURL"));
            }
        }
    }

    private class LTHeadMenu
    implements XMenuListener {
        XPopupMenu ltMenu = null;
        short toolsId = 0;
        short ltId = 0;
        short switchOffId = 0;
        short switchOffPos = 0;
        private XPopupMenu toolsMenu = null;
        private XPopupMenu xProfileMenu = null;
        private XPopupMenu xActivateRuleMenu = null;
        private List<String> definedProfiles = null;
        private String currentProfile = null;

        public LTHeadMenu(XComponent xComponent) {
            try {
                Language lang;
                String command;
                short i;
                XMenuBar menubar = null;
                menubar = OfficeTools.getMenuBar(xComponent);
                if (menubar == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: LTHeadMenu: Menubar is null");
                    return;
                }
                for (i = 0; i < menubar.getItemCount(); i = (short)(i + 1)) {
                    this.toolsId = menubar.getItemId(i);
                    command = menubar.getCommand(this.toolsId);
                    if (!LtMenus.TOOLS_COMMAND.equals(command)) continue;
                    this.toolsMenu = menubar.getPopupMenu(this.toolsId);
                    break;
                }
                if (this.toolsMenu == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: LTHeadMenu: Tools Menu is null");
                    return;
                }
                for (i = 0; i < this.toolsMenu.getItemCount(); i = (short)(i + 1)) {
                    command = this.toolsMenu.getCommand(this.toolsMenu.getItemId(i));
                    if (!LtMenus.COMMAND_BEFORE_LT_MENU.equals(command)) continue;
                    this.ltId = this.toolsMenu.getItemId((short)(i + 1));
                    this.ltMenu = this.toolsMenu.getPopupMenu(this.ltId);
                    break;
                }
                if (this.ltMenu == null) {
                    MessageHandler.printToLogFile("LanguageToolMenus: LTHeadMenu: LT Menu is null");
                    return;
                }
                for (i = 0; i < this.ltMenu.getItemCount(); i = (short)(i + 1)) {
                    command = this.ltMenu.getCommand(this.ltMenu.getItemId(i));
                    if (!LtMenus.LT_OPTIONS_COMMAND.equals(command)) continue;
                    this.switchOffId = (short)102;
                    this.switchOffPos = (short)(i - 1);
                    break;
                }
                if (this.switchOffId == 0) {
                    MessageHandler.printToLogFile("LanguageToolMenus: LTHeadMenu: switchOffId not found");
                    return;
                }
                boolean hasStatisticalStyleRules = false;
                if (LtMenus.this.document.getDocumentType() == OfficeTools.DocumentType.WRITER && !LtMenus.this.document.getMultiDocumentsHandler().isBackgroundCheckOff() && (lang = LtMenus.this.document.getLanguage()) != null) {
                    hasStatisticalStyleRules = OfficeTools.hasStatisticalStyleRules(lang);
                }
                if (hasStatisticalStyleRules) {
                    this.ltMenu.insertItem((short)(this.switchOffId + 1), MESSAGES.getString("loStatisticalAnalysis") + " ...", (short)0, this.switchOffPos);
                    this.ltMenu.setCommand(this.switchOffId, LtMenus.LT_STATISTICAL_ANALYSES_COMMAND);
                    this.switchOffPos = (short)(this.switchOffPos + 1);
                }
                this.ltMenu.insertItem(this.switchOffId, MESSAGES.getString("loMenuResetIgnorePermanent"), (short)0, this.switchOffPos);
                this.ltMenu.setCommand(this.switchOffId, LtMenus.LT_RESET_IGNORE_PERMANENT_COMMAND);
                this.switchOffId = (short)(this.switchOffId - 1);
                this.switchOffPos = (short)(this.switchOffPos + 1);
                this.ltMenu.insertItem(this.switchOffId, MESSAGES.getString("loMenuEnableBackgroundCheck"), (short)0, this.switchOffPos);
                if (LtMenus.this.document.getMultiDocumentsHandler().isBackgroundCheckOff()) {
                    this.ltMenu.setCommand(this.switchOffId, LtMenus.LT_BACKGROUND_CHECK_ON_COMMAND);
                } else {
                    this.ltMenu.setCommand(this.switchOffId, LtMenus.LT_BACKGROUND_CHECK_OFF_COMMAND);
                }
                this.toolsMenu.addMenuListener((XMenuListener)this);
                this.ltMenu.addMenuListener((XMenuListener)this);
                if (debugMode) {
                    MessageHandler.printToLogFile("LanguageToolMenus: LTHeadMenu: Menu listener set");
                }
            }
            catch (Throwable t) {
                MessageHandler.showError(t);
            }
        }

        void removeListener() {
            if (this.toolsMenu != null) {
                this.toolsMenu.removeMenuListener((XMenuListener)this);
            }
        }

        void addListener() {
            if (this.toolsMenu != null) {
                this.toolsMenu.addMenuListener((XMenuListener)this);
            }
        }

        private void setLtMenu() throws Throwable {
            if (LtMenus.this.document.getMultiDocumentsHandler().isBackgroundCheckOff()) {
                this.ltMenu.setItemText(this.switchOffId, MESSAGES.getString("loMenuEnableBackgroundCheck"));
            } else {
                this.ltMenu.setItemText(this.switchOffId, MESSAGES.getString("loMenuDisableBackgroundCheck"));
            }
            short profilesId = (short)(this.switchOffId + 10);
            short profilesPos = (short)(this.switchOffPos + 2);
            if (this.ltMenu.getItemId(profilesPos) != profilesId) {
                this.setProfileMenu(profilesId, profilesPos);
            }
            int nProfileItems = this.setProfileItems();
            this.setActivateRuleMenu((short)(this.switchOffPos + 3), (short)(this.switchOffId + 11), (short)(this.switchOffId + 21 + nProfileItems));
        }

        private void setProfileMenu(short profilesId, short profilesPos) throws Throwable {
            this.ltMenu.insertItem(profilesId, MESSAGES.getString("loMenuChangeProfiles"), (short)4, profilesPos);
            this.xProfileMenu = OfficeTools.getPopupMenu(LtMenus.this.xContext);
            if (this.xProfileMenu == null) {
                MessageHandler.printToLogFile("LanguageToolMenus: setProfileMenu: Profile menu == null");
                return;
            }
            this.xProfileMenu.addMenuListener((XMenuListener)this);
            this.ltMenu.setPopupMenu(profilesId, this.xProfileMenu);
        }

        private int setProfileItems() throws Throwable {
            this.currentProfile = LtMenus.this.config.getCurrentProfile();
            this.definedProfiles = LtMenus.this.config.getDefinedProfiles();
            this.definedProfiles.sort(null);
            if (this.xProfileMenu != null) {
                this.xProfileMenu.removeItem((short)0, this.xProfileMenu.getItemCount());
                short nId = (short)(this.switchOffId + 21);
                short nPos = 0;
                this.xProfileMenu.insertItem(nId, MESSAGES.getString("guiUserProfile"), (short)0, nPos);
                this.xProfileMenu.setCommand(nId, LtMenus.LT_PROFILE_COMMAND);
                if (this.currentProfile == null || this.currentProfile.isEmpty()) {
                    this.xProfileMenu.enableItem(nId, false);
                } else {
                    this.xProfileMenu.enableItem(nId, true);
                }
                if (this.definedProfiles != null) {
                    for (int i = 0; i < this.definedProfiles.size(); ++i) {
                        nId = (short)(nId + 1);
                        nPos = (short)(nPos + 1);
                        this.xProfileMenu.insertItem(nId, this.definedProfiles.get(i), (short)0, nPos);
                        this.xProfileMenu.setCommand(nId, LtMenus.LT_PROFILE_COMMAND + LtMenus.this.replaceColon(this.definedProfiles.get(i)));
                        if (this.currentProfile != null && this.currentProfile.equals(this.definedProfiles.get(i))) {
                            this.xProfileMenu.enableItem(nId, false);
                            continue;
                        }
                        this.xProfileMenu.enableItem(nId, true);
                    }
                }
            }
            return this.definedProfiles == null ? 1 : this.definedProfiles.size() + 1;
        }

        private void runProfileAction(String profile) throws Throwable {
            List<String> definedProfiles = LtMenus.this.config.getDefinedProfiles();
            if (!(profile == null || definedProfiles != null && definedProfiles.contains(profile))) {
                MessageHandler.showMessage("profile '" + profile + "' not found");
            } else {
                try {
                    ArrayList<String> saveProfiles = new ArrayList<String>();
                    saveProfiles.addAll(LtMenus.this.config.getDefinedProfiles());
                    LtMenus.this.config.initOptions();
                    LtMenus.this.config.loadConfiguration(profile == null ? "" : profile);
                    LtMenus.this.config.setCurrentProfile(profile);
                    LtMenus.this.config.addProfiles(saveProfiles);
                    LtMenus.this.config.saveConfiguration(LtMenus.this.document.getLanguage());
                    LtMenus.this.document.getMultiDocumentsHandler().resetConfiguration();
                }
                catch (IOException e) {
                    MessageHandler.showError(e);
                }
            }
        }

        private void setActivateRuleMenu(short pos, short id, short submenuStartId) throws Throwable {
            Map<String, String> deactivatedRulesMap = LtMenus.this.document.getMultiDocumentsHandler().getDisabledRulesMap(null);
            if (!deactivatedRulesMap.isEmpty()) {
                if (this.ltMenu.getItemId(pos) != id) {
                    this.ltMenu.insertItem(id, MESSAGES.getString("loContextMenuActivateRule"), (short)4, pos);
                    this.xActivateRuleMenu = OfficeTools.getPopupMenu(LtMenus.this.xContext);
                    if (this.xActivateRuleMenu == null) {
                        MessageHandler.printToLogFile("LanguageToolMenus: setActivateRuleMenu: activate rule menu == null");
                        return;
                    }
                    this.xActivateRuleMenu.addMenuListener((XMenuListener)this);
                    this.ltMenu.setPopupMenu(id, this.xActivateRuleMenu);
                }
                this.xActivateRuleMenu.removeItem((short)0, this.xActivateRuleMenu.getItemCount());
                short nId = submenuStartId;
                short nPos = 0;
                for (String ruleId : deactivatedRulesMap.keySet()) {
                    this.xActivateRuleMenu.insertItem(nId, deactivatedRulesMap.get(ruleId), (short)0, nPos);
                    this.xActivateRuleMenu.setCommand(nId, LtMenus.LT_ACTIVATE_RULE_COMMAND + ruleId);
                    this.xActivateRuleMenu.enableItem(nId, true);
                    nId = (short)(nId + 1);
                    nPos = (short)(nPos + 1);
                }
            } else if (this.xActivateRuleMenu != null) {
                this.ltMenu.removeItem(pos, (short)1);
                this.xActivateRuleMenu.removeItem((short)0, this.xActivateRuleMenu.getItemCount());
                this.xActivateRuleMenu = null;
            }
        }

        public void disposing(EventObject event) {
        }

        public void itemActivated(MenuEvent event) {
            if (event.MenuId == 0) {
                try {
                    this.setLtMenu();
                }
                catch (Throwable e) {
                    MessageHandler.showError(e);
                }
            }
        }

        public void itemDeactivated(MenuEvent event) {
        }

        public void itemHighlighted(MenuEvent event) {
        }

        public void itemSelected(MenuEvent event) {
            try {
                if (debugMode) {
                    MessageHandler.printToLogFile("LanguageToolMenus: setActivateRuleMenu: event id: " + event.MenuId);
                }
                if (event.MenuId == this.switchOffId) {
                    if (LtMenus.this.document.getMultiDocumentsHandler().toggleNoBackgroundCheck()) {
                        LtMenus.this.document.getMultiDocumentsHandler().resetCheck();
                    }
                } else if (event.MenuId == this.switchOffId + 1) {
                    LtMenus.this.document.resetIgnorePermanent();
                } else {
                    if (event.MenuId == this.switchOffId + 2) {
                        StatAnDialog statAnDialog = new StatAnDialog(LtMenus.this.document);
                        statAnDialog.start();
                        return;
                    }
                    if (event.MenuId == this.switchOffId + 21) {
                        this.runProfileAction(null);
                    } else if (event.MenuId > this.switchOffId + 21 && event.MenuId <= this.switchOffId + 21 + this.definedProfiles.size()) {
                        this.runProfileAction(this.definedProfiles.get(event.MenuId - this.switchOffId - 22));
                    } else if (event.MenuId > this.switchOffId + 21 + this.definedProfiles.size()) {
                        Map<String, String> deactivatedRulesMap = LtMenus.this.document.getMultiDocumentsHandler().getDisabledRulesMap(null);
                        short j = (short)(this.switchOffId + 21 + this.definedProfiles.size() + 1);
                        for (String ruleId : deactivatedRulesMap.keySet()) {
                            if (event.MenuId == j) {
                                if (debugMode) {
                                    MessageHandler.printToLogFile("LanguageToolMenus: setActivateRuleMenu: activate rule: " + ruleId);
                                }
                                LtMenus.this.document.getMultiDocumentsHandler().activateRule(ruleId);
                                return;
                            }
                            j = (short)(j + 1);
                        }
                    }
                }
            }
            catch (Throwable e) {
                MessageHandler.showError(e);
            }
        }
    }
}

