/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.linguistic2.XDictionary;
import com.sun.star.linguistic2.XSearchableDictionaryList;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;

public class LtDictionary {
    private static final String INTERNAL_DICT_PREFIX = "__LT_";
    private static final String DICT_FILE_POSTFIX = ".dic";
    private static String listIgnoredWords = null;
    private static boolean activateDictionary = false;

    public static boolean isActivating() {
        return activateDictionary;
    }

    private static void setListIgnoredWords(XDictionary[] dictionaryList) {
        if (listIgnoredWords != null) {
            return;
        }
        boolean debugMode = OfficeTools.DEBUG_MODE_LD;
        for (XDictionary dictionary : dictionaryList) {
            String name;
            if (!dictionary.isActive() || (name = dictionary.getName()).startsWith(INTERNAL_DICT_PREFIX) || name.endsWith(DICT_FILE_POSTFIX)) continue;
            listIgnoredWords = new String(name);
            if (!debugMode) continue;
            MessageHandler.printToLogFile("dictionary for ignored words found: " + listIgnoredWords);
        }
        if (listIgnoredWords == null) {
            MessageHandler.printToLogFile("WARNING: dictionary for ignored words not found!");
        }
    }

    private static XDictionary getListIgnoredWords(XComponentContext xContext) {
        XSearchableDictionaryList searchableDictionaryList = OfficeTools.getSearchableDictionaryList(xContext);
        if (searchableDictionaryList == null) {
            MessageHandler.printToLogFile("LtDictionary: getListIgnoredWords: searchableDictionaryList == null");
            return null;
        }
        if (listIgnoredWords == null) {
            LtDictionary.setListIgnoredWords(searchableDictionaryList.getDictionaries());
        }
        for (XDictionary dictionary : searchableDictionaryList.getDictionaries()) {
            if (!dictionary.isActive() || !listIgnoredWords.equals(dictionary.getName())) continue;
            return dictionary;
        }
        MessageHandler.printToLogFile("WARNING: dictionary for ignored words not found!");
        return null;
    }

    public static void addIgnoredWord(String word, XComponentContext xContext) {
        XDictionary ignoredWords = LtDictionary.getListIgnoredWords(xContext);
        ignoredWords.add(word, false, "");
    }

    public static void removeIgnoredWord(String word, XComponentContext xContext) {
        XDictionary ignoredWords = LtDictionary.getListIgnoredWords(xContext);
        ignoredWords.remove(word);
    }

    public static void addWordToDictionary(String dictionaryName, String word, XComponentContext xContext) {
        if (word == null) {
            throw new RuntimeException("No word selected to add to dictionary (word == null) ");
        }
        if (dictionaryName == null) {
            throw new RuntimeException("No dictionary selected (dictionaryName == null) ");
        }
        XSearchableDictionaryList searchableDictionaryList = OfficeTools.getSearchableDictionaryList(xContext);
        if (searchableDictionaryList == null) {
            MessageHandler.printToLogFile("LtDictionary: addWordToDictionary: searchableDictionaryList == null");
            return;
        }
        XDictionary dictionary = searchableDictionaryList.getDictionaryByName(dictionaryName);
        if (dictionary == null) {
            throw new RuntimeException("Dictionary not found (dictionaryName: " + dictionaryName + "; word: " + word);
        }
        dictionary.add(word, false, "");
    }

    public static void removeWordFromDictionary(String dictionaryName, String word, XComponentContext xContext) {
        XSearchableDictionaryList searchableDictionaryList = OfficeTools.getSearchableDictionaryList(xContext);
        if (searchableDictionaryList == null) {
            MessageHandler.printToLogFile("LtDictionary: removeWordFromDictionary: searchableDictionaryList == null");
            return;
        }
        XDictionary dictionary = searchableDictionaryList.getDictionaryByName(dictionaryName);
        dictionary.remove(word);
    }

    public static String[] getUserDictionaries(XComponentContext xContext) {
        boolean debugMode = OfficeTools.DEBUG_MODE_LD;
        XSearchableDictionaryList searchableDictionaryList = OfficeTools.getSearchableDictionaryList(xContext);
        if (searchableDictionaryList == null) {
            MessageHandler.printToLogFile("LtDictionary: getUserDictionaries: searchableDictionaryList == null");
            return null;
        }
        XDictionary[] dictionaryList = searchableDictionaryList.getDictionaries();
        LtDictionary.setListIgnoredWords(dictionaryList);
        ArrayList<String> userDictionaries = new ArrayList<String>();
        for (XDictionary dictionary : dictionaryList) {
            String name;
            if (debugMode) {
                MessageHandler.printToLogFile("LtDictionary: getUserDictionaries: dictionary: " + dictionary.getName() + ", isActive: " + dictionary.isActive() + ", Type: " + dictionary.getDictionaryType().getValue());
            }
            if (!dictionary.isActive() || (name = dictionary.getName()).startsWith(INTERNAL_DICT_PREFIX) || name.equals(listIgnoredWords)) continue;
            userDictionaries.add(new String(name));
        }
        return userDictionaries.toArray(new String[userDictionaries.size()]);
    }
}

