/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.linguistic2.XHyphenator;
import com.sun.star.linguistic2.XLinguServiceManager;
import com.sun.star.linguistic2.XMeaning;
import com.sun.star.linguistic2.XPossibleHyphens;
import com.sun.star.linguistic2.XSpellAlternatives;
import com.sun.star.linguistic2.XSpellChecker;
import com.sun.star.linguistic2.XThesaurus;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.rules.Rule;

public class LinguisticServices
extends LinguServices {
    private static boolean isSetLt = false;
    private XComponentContext xContext;
    private Map<String, List<String>> synonymsCache;
    private List<String> thesaurusRelevantRules = null;
    private boolean noSynonymsAsSuggestions = false;

    public LinguisticServices(XComponentContext xContext) {
        this.xContext = xContext;
        this.synonymsCache = new HashMap<String, List<String>>();
    }

    public void setNoSynonymsAsSuggestions(boolean noSynonymsAsSuggestions) {
        this.noSynonymsAsSuggestions = noSynonymsAsSuggestions;
    }

    private static XLinguServiceManager getLinguSvcMgr(XComponentContext xContext) {
        try {
            XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
            if (xMCF == null) {
                MessageHandler.printToLogFile("LinguisticServices: getLinguSvcMgr: XMultiComponentFactory == null");
                return null;
            }
            XPropertySet props = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xMCF);
            if (props == null) {
                MessageHandler.printToLogFile("LinguisticServices: getLinguSvcMgr: XPropertySet == null");
                return null;
            }
            Object defaultContext = props.getPropertyValue("DefaultContext");
            XComponentContext xComponentContext = (XComponentContext)UnoRuntime.queryInterface(XComponentContext.class, (Object)defaultContext);
            if (xComponentContext == null) {
                MessageHandler.printToLogFile("LinguisticServices: getLinguSvcMgr: XComponentContext == null");
                return null;
            }
            Object o = xMCF.createInstanceWithContext("com.sun.star.linguistic2.LinguServiceManager", xComponentContext);
            XLinguServiceManager mxLinguSvcMgr = (XLinguServiceManager)UnoRuntime.queryInterface(XLinguServiceManager.class, (Object)o);
            if (mxLinguSvcMgr == null) {
                MessageHandler.printToLogFile("LinguisticServices: getLinguSvcMgr: XLinguServiceManager2 == null");
                return null;
            }
            return mxLinguSvcMgr;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    private static XPropertySet getLinguProperties(XComponentContext xContext) {
        if (xContext == null) {
            return null;
        }
        XMultiComponentFactory xMCF = (XMultiComponentFactory)UnoRuntime.queryInterface(XMultiComponentFactory.class, (Object)xContext.getServiceManager());
        if (xMCF == null) {
            return null;
        }
        Object linguProperties = null;
        try {
            linguProperties = xMCF.createInstanceWithContext("com.sun.star.linguistic2.LinguProperties", xContext);
        }
        catch (Exception e) {
            MessageHandler.printException(e);
        }
        if (linguProperties == null) {
            return null;
        }
        return (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)linguProperties);
    }

    public void printLinguProperties(XComponentContext xContext) {
        XPropertySet propSet = LinguisticServices.getLinguProperties(xContext);
        XPropertySetInfo propertySetInfo = propSet.getPropertySetInfo();
        MessageHandler.printToLogFile("OfficeTools: printPropertySet: PropertySet:");
        for (Property property : propertySetInfo.getProperties()) {
            MessageHandler.printToLogFile("Name: " + property.Name + ", Type: " + property.Type.getTypeName());
        }
    }

    private XThesaurus getThesaurus(XComponentContext xContext) {
        try {
            XLinguServiceManager mxLinguSvcMgr = LinguisticServices.getLinguSvcMgr(xContext);
            if (mxLinguSvcMgr != null) {
                return mxLinguSvcMgr.getThesaurus();
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        return null;
    }

    private XHyphenator getHyphenator(XComponentContext xContext) {
        try {
            XLinguServiceManager mxLinguSvcMgr = LinguisticServices.getLinguSvcMgr(xContext);
            if (mxLinguSvcMgr != null) {
                return mxLinguSvcMgr.getHyphenator();
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        return null;
    }

    protected XSpellChecker getSpellChecker(XComponentContext xContext) {
        try {
            XLinguServiceManager mxLinguSvcMgr = LinguisticServices.getLinguSvcMgr(xContext);
            if (mxLinguSvcMgr != null) {
                return mxLinguSvcMgr.getSpellChecker();
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        return null;
    }

    public static Locale getLocale(Language lang) {
        if (lang == null) {
            return null;
        }
        Locale locale = new Locale();
        locale.Language = lang.getShortCode();
        locale.Country = (lang.getCountries() == null || lang.getCountries().length != 1) && lang.getDefaultLanguageVariant() != null ? lang.getDefaultLanguageVariant().getCountries()[0] : (lang.getCountries() != null && lang.getCountries().length > 0 ? lang.getCountries()[0] : "");
        locale.Variant = lang.getVariant() == null ? "" : lang.getVariant();
        return locale;
    }

    @Override
    public List<String> getSynonyms(String word, Language lang) {
        return this.getSynonyms(word, LinguisticServices.getLocale(lang));
    }

    public List<String> getSynonyms(String word, Locale locale) {
        try {
            if (this.noSynonymsAsSuggestions) {
                return new ArrayList<String>();
            }
            if (this.synonymsCache.containsKey(word)) {
                return this.synonymsCache.get(word);
            }
            AddSynonymsToCache addSynonymsToCache = new AddSynonymsToCache(word, locale);
            addSynonymsToCache.start();
            long startTime = System.currentTimeMillis();
            long runTime = 0L;
            do {
                Thread.sleep(10L);
                if (!this.synonymsCache.containsKey(word)) continue;
                return this.synonymsCache.get(word);
            } while ((runTime = System.currentTimeMillis() - startTime) < 500L);
        }
        catch (InterruptedException e) {
            MessageHandler.printException(e);
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean isCorrectSpell(String word, Language lang) {
        return this.isCorrectSpell(word, LinguisticServices.getLocale(lang));
    }

    public boolean isCorrectSpell(String word, Locale locale) {
        XSpellChecker spellChecker = this.getSpellChecker(this.xContext);
        if (spellChecker == null) {
            MessageHandler.printToLogFile("LinguisticServices: isCorrectSpell: XSpellChecker == null");
            return false;
        }
        PropertyValue[] properties = new PropertyValue[]{};
        try {
            return spellChecker.isValid(word, locale, properties);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return false;
        }
    }

    public String[] getSpellAlternatives(String word, Language lang) {
        return this.getSpellAlternatives(word, LinguisticServices.getLocale(lang));
    }

    public String[] getSpellAlternatives(String word, Locale locale) {
        XSpellChecker spellChecker = this.getSpellChecker(this.xContext);
        if (spellChecker == null) {
            MessageHandler.printToLogFile("LinguisticServices: getSpellAlternatives: XSpellChecker == null");
            return null;
        }
        PropertyValue[] properties = new PropertyValue[]{};
        try {
            XSpellAlternatives spellAlternatives = spellChecker.spell(word, locale, properties);
            if (spellAlternatives == null) {
                return null;
            }
            return spellAlternatives.getAlternatives();
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    @Override
    public int getNumberOfSyllables(String word, Language lang) {
        return this.getNumberOfSyllables(word, LinguisticServices.getLocale(lang));
    }

    public int getNumberOfSyllables(String word, Locale locale) {
        XHyphenator hyphenator = this.getHyphenator(this.xContext);
        if (hyphenator == null) {
            MessageHandler.printToLogFile("LinguisticServices: getNumberOfSyllables: XHyphenator == null");
            return 1;
        }
        PropertyValue[] properties = new PropertyValue[]{};
        try {
            XPossibleHyphens possibleHyphens = hyphenator.createPossibleHyphens(word, locale, properties);
            if (possibleHyphens == null) {
                return 1;
            }
            short[] numSyllable = possibleHyphens.getHyphenationPositions();
            return numSyllable.length + 1;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return 1;
        }
    }

    public boolean setLtAsGrammarService(XComponentContext xContext, Locale locale) {
        if (xContext != null) {
            Locale[] locales;
            XLinguServiceManager mxLinguSvcMgr = LinguisticServices.getLinguSvcMgr(xContext);
            if (mxLinguSvcMgr == null) {
                MessageHandler.printToLogFile("LinguisticServices: setLtAsGrammarService: XLinguServiceManager == null");
                return false;
            }
            for (Locale loc : locales = MultiDocumentsHandler.getLocales()) {
                if (!OfficeTools.isEqualLocale(locale, loc)) continue;
                String[] serviceNames = mxLinguSvcMgr.getConfiguredServices("com.sun.star.linguistic2.Proofreader", locale);
                if (serviceNames.length == 0) {
                    MessageHandler.printToLogFile("LinguisticServices: setLtAsGrammarService: No configured Service for: " + OfficeTools.localeToString(locale));
                } else {
                    for (String service : serviceNames) {
                        MessageHandler.printToLogFile("Configured Linguistic Service: " + service + ", " + OfficeTools.localeToString(locale));
                    }
                }
                if (serviceNames.length != 1 || !serviceNames[0].equals("org.languagetool.openoffice.Main")) {
                    String[] aServiceNames;
                    for (String service : aServiceNames = mxLinguSvcMgr.getAvailableServices("com.sun.star.linguistic2.Proofreader", locale)) {
                        MessageHandler.printToLogFile("Available Linguistic Service: " + service + ", " + OfficeTools.localeToString(locale));
                    }
                    String[] configuredServices = new String[]{new String("org.languagetool.openoffice.Main")};
                    mxLinguSvcMgr.setConfiguredServices("com.sun.star.linguistic2.Proofreader", locale, configuredServices);
                    MessageHandler.printToLogFile("LT set as configured Service for Language: " + OfficeTools.localeToString(locale));
                }
                return true;
            }
            MessageHandler.printToLogFile("LT doesn't support language: " + OfficeTools.localeToString(locale));
        }
        return false;
    }

    public boolean setLtAsGrammarService(XComponentContext xContext) {
        if (xContext != null) {
            return this.setLtAsGrammarService(LinguisticServices.getLinguSvcMgr(xContext));
        }
        return false;
    }

    private boolean setLtAsGrammarService(XLinguServiceManager mxLinguSvcMgr) {
        Locale[] locales;
        if (isSetLt) {
            return true;
        }
        if (mxLinguSvcMgr == null) {
            MessageHandler.printToLogFile("LinguisticServices: setLtAsGrammarService: XLinguServiceManager == null");
            return false;
        }
        isSetLt = true;
        for (Locale locale : locales = MultiDocumentsHandler.getLocales()) {
            String[] aServiceNames;
            String[] serviceNames = mxLinguSvcMgr.getConfiguredServices("com.sun.star.linguistic2.Proofreader", locale);
            if (serviceNames.length == 1 && serviceNames[0].equals("org.languagetool.openoffice.Main")) continue;
            for (String service : aServiceNames = mxLinguSvcMgr.getAvailableServices("com.sun.star.linguistic2.Proofreader", locale)) {
                MessageHandler.printToLogFile("Available Linguistic Service: " + service + ", " + OfficeTools.localeToString(locale));
            }
            String[] configuredServices = new String[]{new String("org.languagetool.openoffice.Main")};
            mxLinguSvcMgr.setConfiguredServices("com.sun.star.linguistic2.Proofreader", locale, configuredServices);
            MessageHandler.printToLogFile("LT set as configured Service for Language: " + OfficeTools.localeToString(locale));
        }
        return true;
    }

    public static boolean setLtAsSpellService(XComponentContext xContext, boolean activate) {
        if (xContext == null) {
            return false;
        }
        XLinguServiceManager mxLinguSvcMgr = LinguisticServices.getLinguSvcMgr(xContext);
        if (mxLinguSvcMgr == null) {
            MessageHandler.printToLogFile("LinguisticServices: setLtAsSpellService: XLinguServiceManager == null");
            return false;
        }
        Locale[] locales = MultiDocumentsHandler.getLocales();
        MessageHandler.printToLogFile("LinguisticServices: setLtAsSpellService: Number locales: " + locales.length);
        for (Locale locale : locales) {
            String[] serviceNames = mxLinguSvcMgr.getConfiguredServices("com.sun.star.linguistic2.SpellChecker", locale);
            ArrayList<String> serviceList = new ArrayList<String>();
            if (!activate) {
                for (String serviceName : serviceNames) {
                    if ("org.languagetool.openoffice.LanguageToolSpellChecker".equals(serviceName)) continue;
                    serviceList.add(serviceName);
                }
            } else {
                boolean add = false;
                for (String serviceName : serviceNames) {
                    if (!"org.languagetool.openoffice.LanguageToolSpellChecker".equals(serviceName)) {
                        add = true;
                    }
                    serviceList.add(serviceName);
                }
                if (add) {
                    serviceList.add("org.languagetool.openoffice.LanguageToolSpellChecker");
                }
            }
            serviceNames = serviceList.toArray(new String[serviceList.size()]);
            mxLinguSvcMgr.setConfiguredServices("com.sun.star.linguistic2.SpellChecker", locale, serviceNames);
        }
        MessageHandler.printToLogFile("LT spell service (org.languagetool.openoffice.LanguageToolSpellChecker) " + (!activate ? "deactivated" : "activated"));
        return true;
    }

    @Override
    public void setThesaurusRelevantRule(Rule rule) {
        String ruleId;
        if (this.thesaurusRelevantRules == null) {
            this.thesaurusRelevantRules = new ArrayList<String>();
        }
        if (!this.thesaurusRelevantRules.contains(ruleId = rule.getId())) {
            this.thesaurusRelevantRules.add(ruleId);
        }
    }

    public boolean isThesaurusRelevantRule(String ruleId) {
        return !this.noSynonymsAsSuggestions && this.thesaurusRelevantRules != null && this.thesaurusRelevantRules.contains(ruleId);
    }

    private class AddSynonymsToCache
    extends Thread {
        private String word;
        private Locale locale;

        private AddSynonymsToCache(String word, Locale locale) {
            this.word = word;
            this.locale = locale;
        }

        @Override
        public void run() {
            ArrayList synonyms = new ArrayList();
            try {
                XMeaning[] meanings;
                XThesaurus thesaurus = LinguisticServices.this.getThesaurus(LinguisticServices.this.xContext);
                if (thesaurus == null) {
                    MessageHandler.printToLogFile("LinguisticServices: getSynonyms: XThesaurus == null");
                    return;
                }
                if (this.locale == null) {
                    MessageHandler.printToLogFile("LinguisticServices: getSynonyms: Locale == null");
                    return;
                }
                PropertyValue[] properties = new PropertyValue[]{};
                for (XMeaning meaning : meanings = thesaurus.queryMeanings(this.word, this.locale, properties)) {
                    if (synonyms.size() >= 25) break;
                    String[] singleSynonyms = meaning.querySynonyms();
                    Collections.addAll(synonyms, singleSynonyms);
                }
                LinguisticServices.this.synonymsCache.put(this.word, synonyms);
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
            }
        }
    }
}

