/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.LinguServices;
import org.languagetool.UserConfig;
import org.languagetool.gui.Configuration;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.remote.CheckConfiguration;
import org.languagetool.remote.CheckConfigurationBuilder;
import org.languagetool.remote.RemoteConfigurationInfo;
import org.languagetool.remote.RemoteLanguageTool;
import org.languagetool.remote.RemoteResult;
import org.languagetool.remote.RemoteRuleMatch;
import org.languagetool.rules.Category;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;

class LORemoteLanguageTool {
    private static final String BLANK = " ";
    private static final String SERVER_URL = "https://api.languagetool.org";
    private static final String PREMIUM_SERVER_URL = "https://api.languagetoolplus.com";
    private static final int MAX_LIMIT = Integer.MAX_VALUE;
    private static final int SERVER_LIMIT = 20000;
    private final Set<String> enabledRules = new HashSet<String>();
    private final Set<String> disabledRules = new HashSet<String>();
    private final Set<CategoryId> disabledRuleCategories = new HashSet<CategoryId>();
    private final Set<CategoryId> enabledRuleCategories = new HashSet<CategoryId>();
    private final List<Rule> allRules = new ArrayList<Rule>();
    private final List<Rule> spellingRules = new ArrayList<Rule>();
    private final List<String> ruleValues = new ArrayList<String>();
    private final Language language;
    private final Language motherTongue;
    private final RemoteLanguageTool remoteLanguageTool;
    private final UserConfig userConfig;
    private final boolean addSynonyms;
    private final boolean isPremium;
    private final String username;
    private final String apiKey;
    private JLanguageTool lt = null;
    private int maxTextLength = Integer.MAX_VALUE;
    private boolean remoteRun;

    LORemoteLanguageTool(Language language, Language motherTongue, Configuration config, List<Rule> extraRemoteRules, UserConfig userConfig) throws MalformedURLException {
        this.language = language;
        this.motherTongue = motherTongue;
        this.userConfig = userConfig;
        this.addSynonyms = userConfig != null && userConfig.getLinguServices() != null && !config.noSynonymsAsSuggestions();
        String serverUrl = config.getServerUrl();
        this.setRuleValues(config.getConfigurableValues());
        this.username = config.getRemoteUsername();
        this.apiKey = config.getRemoteApiKey();
        boolean bl = this.isPremium = this.username != null && this.apiKey != null && config.isPremium();
        URL serverBaseUrl = new URL(serverUrl == null ? (this.isPremium ? PREMIUM_SERVER_URL : SERVER_URL) : serverUrl);
        this.remoteLanguageTool = new RemoteLanguageTool(serverBaseUrl);
        try {
            String urlParameters = "language=" + language.getShortCodeWithCountryAndVariant();
            RemoteConfigurationInfo configInfo = this.remoteLanguageTool.getConfigurationInfo(urlParameters);
            this.storeAllRules(configInfo.getRemoteRules());
            if (!this.isPremium) {
                this.maxTextLength = this.remoteLanguageTool.getMaxTextLength();
            }
            MessageHandler.printToLogFile("Server Url: " + serverBaseUrl);
            MessageHandler.printToLogFile("Server Limit text length: " + this.maxTextLength);
            this.remoteRun = true;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            this.maxTextLength = 20000;
            MessageHandler.printToLogFile("Server doesn't support maxTextLength, Limit text length set to: " + this.maxTextLength);
            this.remoteRun = false;
        }
    }

    List<RuleMatch> check(String text, JLanguageTool.ParagraphHandling paraMode, OfficeTools.RemoteCheck checkMode) throws IOException {
        int limit;
        HashSet<String> tmpEnabled;
        if (!this.remoteRun) {
            return null;
        }
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (text == null || text.trim().isEmpty()) {
            return ruleMatches;
        }
        CheckConfigurationBuilder configBuilder = new CheckConfigurationBuilder(this.language.getShortCodeWithCountryAndVariant());
        if (this.isPremium) {
            configBuilder.username(this.username);
            configBuilder.apiKey(this.apiKey);
        }
        if (this.motherTongue != null) {
            configBuilder.setMotherTongueLangCode(this.motherTongue.getShortCodeWithCountryAndVariant());
        }
        if (paraMode == JLanguageTool.ParagraphHandling.ONLYPARA) {
            configBuilder.ruleValues(this.ruleValues);
            tmpEnabled = new HashSet<String>();
            if (checkMode == OfficeTools.RemoteCheck.ALL || checkMode == OfficeTools.RemoteCheck.ONLY_GRAMMAR) {
                tmpEnabled.addAll(this.enabledRules);
            }
            if (checkMode == OfficeTools.RemoteCheck.ALL || checkMode == OfficeTools.RemoteCheck.ONLY_SPELL) {
                for (Rule rule : this.spellingRules) {
                    tmpEnabled.add(rule.getId());
                }
            }
            if (tmpEnabled.size() > 0) {
                configBuilder.enabledRuleIds(tmpEnabled.toArray(new String[0]));
                configBuilder.enabledOnly();
            }
            configBuilder.mode("textLevelOnly");
        } else if (checkMode == OfficeTools.RemoteCheck.ALL || checkMode == OfficeTools.RemoteCheck.ONLY_GRAMMAR) {
            HashSet<String> tmpDisabled = new HashSet<String>(this.disabledRules);
            if (checkMode == OfficeTools.RemoteCheck.ALL) {
                for (Rule rule : this.spellingRules) {
                    tmpDisabled.remove(rule.getId());
                }
            }
            configBuilder.enabledRuleIds(this.enabledRules.toArray(new String[0]));
            configBuilder.disabledRuleIds(tmpDisabled.toArray(new String[0]));
            configBuilder.ruleValues(this.ruleValues);
            configBuilder.mode("all");
        } else if (checkMode == OfficeTools.RemoteCheck.ONLY_SPELL) {
            tmpEnabled = new HashSet();
            for (Rule rule : this.spellingRules) {
                tmpEnabled.add(rule.getId());
            }
            if (tmpEnabled.size() > 0) {
                configBuilder.enabledRuleIds(tmpEnabled.toArray(new String[0]));
                configBuilder.enabledOnly();
            }
            configBuilder.mode("allButTextLevelOnly");
        }
        configBuilder.level("default");
        CheckConfiguration remoteConfig = configBuilder.build();
        for (int nStart = 0; text.length() > nStart; nStart += limit) {
            RemoteResult remoteResult;
            String subText;
            if (text.length() <= nStart + this.maxTextLength) {
                subText = text.substring(nStart);
                limit = this.maxTextLength;
            } else {
                int nEnd = text.lastIndexOf("\n\n", nStart + 20000) + OfficeTools.NUMBER_PARAGRAPH_CHARS;
                if (nEnd <= nStart && (nEnd = text.lastIndexOf(BLANK, nStart + 20000) + 1) <= nStart) {
                    nEnd = nStart + 20000;
                }
                subText = text.substring(nStart, nEnd);
                limit = nEnd;
            }
            try {
                remoteResult = this.remoteLanguageTool.check(subText, remoteConfig);
            }
            catch (Throwable t) {
                MessageHandler.printException(t);
                this.remoteRun = false;
                return null;
            }
            ruleMatches.addAll(this.toRuleMatches(text, remoteResult.getMatches(), nStart));
        }
        return ruleMatches;
    }

    Language getLanguage() {
        return this.language;
    }

    List<Rule> getAllRules() {
        return this.allRules;
    }

    boolean remoteRun() {
        return this.remoteRun;
    }

    private boolean ignoreRule(Rule rule) {
        boolean isRuleDisabled;
        Category ruleCategory = rule.getCategory();
        boolean isCategoryDisabled = (this.disabledRuleCategories.contains(ruleCategory.getId()) || rule.getCategory().isDefaultOff()) && !this.enabledRuleCategories.contains(ruleCategory.getId());
        boolean bl = isRuleDisabled = this.disabledRules.contains(rule.getId()) || rule.isDefaultOff() && !this.enabledRules.contains(rule.getId());
        boolean isDisabled = isCategoryDisabled ? !this.enabledRules.contains(rule.getId()) : isRuleDisabled;
        return isDisabled;
    }

    public List<Rule> getAllActiveRules() {
        ArrayList<Rule> rulesActive = new ArrayList<Rule>();
        for (Rule rule : this.allRules) {
            if (this.ignoreRule(rule)) continue;
            rulesActive.add(rule);
        }
        return rulesActive;
    }

    public List<Rule> getAllActiveOfficeRules() {
        ArrayList<Rule> rulesActive = new ArrayList<Rule>();
        for (Rule rule : this.allRules) {
            if (!this.ignoreRule(rule) && !rule.isOfficeDefaultOff()) {
                rulesActive.add(rule);
                continue;
            }
            if (rule.isOfficeDefaultOn() && !this.disabledRules.contains(rule.getId())) {
                rulesActive.add(rule);
                this.enableRule(rule.getId());
                continue;
            }
            if (this.ignoreRule(rule) || !rule.isOfficeDefaultOff() || this.enabledRules.contains(rule.getId())) continue;
            this.disableRule(rule.getId());
        }
        return rulesActive;
    }

    public Set<String> getDisabledRules() {
        return this.disabledRules;
    }

    void enableRule(String ruleId) {
        this.disabledRules.remove(ruleId);
        this.enabledRules.add(ruleId);
    }

    void disableRule(String ruleId) {
        this.disabledRules.add(ruleId);
        this.enabledRules.remove(ruleId);
    }

    public void disableCategory(CategoryId id) {
        this.disabledRuleCategories.add(id);
        this.enabledRuleCategories.remove(id);
    }

    private void setRuleValues(Map<String, Integer> configurableValues) {
        this.ruleValues.clear();
        Set<String> rules = configurableValues.keySet();
        for (String rule : rules) {
            String ruleValueString = rule + ":" + configurableValues.get(rule);
            this.ruleValues.add(ruleValueString);
        }
    }

    public List<String> getSynonymsForWord(String word, LinguServices linguServices) {
        ArrayList<String> synonyms = new ArrayList<String>();
        List<String> rawSynonyms = linguServices.getSynonyms(word, this.language);
        for (String synonym : rawSynonyms) {
            if ((synonym = synonym.replaceAll("\\(.*\\)", "").trim()).isEmpty() || synonyms.contains(synonym)) continue;
            synonyms.add(synonym);
        }
        return synonyms;
    }

    public List<String> getSynonymsForToken(AnalyzedTokenReadings token, LinguServices linguServices) {
        List<String> synonyms = new ArrayList<String>();
        if (linguServices == null || token == null) {
            return synonyms;
        }
        List<AnalyzedToken> readings = token.getReadings();
        for (AnalyzedToken reading : readings) {
            String lemma = reading.getLemma();
            if (lemma == null) continue;
            List<String> newSynonyms = this.getSynonymsForWord(lemma, linguServices);
            for (String synonym : newSynonyms) {
                if (synonyms.contains(synonym)) continue;
                synonyms.add(synonym);
            }
        }
        if (synonyms.isEmpty()) {
            synonyms = this.getSynonymsForWord(token.getToken(), linguServices);
        }
        return synonyms;
    }

    private List<String> getSynonyms(String word) {
        if (!this.addSynonyms) {
            return null;
        }
        if (this.lt == null) {
            this.lt = new JLanguageTool(this.language, this.motherTongue, null, this.userConfig);
        }
        try {
            List<AnalyzedSentence> analyzedSentence = this.lt.analyzeText(word);
            return this.getSynonymsForToken(analyzedSentence.get(0).getTokensWithoutWhitespace()[1], this.userConfig.getLinguServices());
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    private RuleMatch toRuleMatch(String text, RemoteRuleMatch remoteMatch, int nOffset) throws MalformedURLException {
        String word;
        List<String> synonyms;
        Rule matchRule = null;
        for (Rule rule : this.allRules) {
            if (!remoteMatch.getRuleId().equals(rule.getId())) continue;
            matchRule = rule;
        }
        if (matchRule == null) {
            MessageHandler.printToLogFile("WARNING: Rule \"" + remoteMatch.getRuleDescription() + "(ID: " + remoteMatch.getRuleId() + ")\" may be not supported by option panel!");
            matchRule = new RemoteRule(remoteMatch);
            this.allRules.add(matchRule);
        }
        RuleMatch ruleMatch = new RuleMatch(matchRule, null, remoteMatch.getErrorOffset() + nOffset, remoteMatch.getErrorOffset() + remoteMatch.getErrorLength() + nOffset, remoteMatch.getMessage(), remoteMatch.getShortMessage().isPresent() ? remoteMatch.getShortMessage().get() : null);
        if (remoteMatch.getUrl().isPresent()) {
            ruleMatch.setUrl(new URL(remoteMatch.getUrl().get()));
        }
        List<String> replacements = null;
        if (remoteMatch.getReplacements().isPresent()) {
            replacements = remoteMatch.getReplacements().get();
        }
        if (replacements != null && !replacements.isEmpty()) {
            ruleMatch.setSuggestedReplacements(remoteMatch.getReplacements().get());
        } else if (this.addSynonyms && remoteMatch.getRuleId().startsWith("STYLE_REPEATED_WORD_RULE") && (synonyms = this.getSynonyms(word = text.substring(ruleMatch.getFromPos(), ruleMatch.getToPos()))) != null && !synonyms.isEmpty()) {
            ruleMatch.setSuggestedReplacements(synonyms);
        }
        return ruleMatch;
    }

    private List<RuleMatch> toRuleMatches(String text, List<RemoteRuleMatch> remoteRulematches, int nOffset) throws MalformedURLException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        if (remoteRulematches == null || remoteRulematches.isEmpty()) {
            return ruleMatches;
        }
        for (RemoteRuleMatch remoteMatch : remoteRulematches) {
            RuleMatch ruleMatch = this.toRuleMatch(text, remoteMatch, nOffset);
            ruleMatches.add(ruleMatch);
        }
        return ruleMatches;
    }

    private void storeAllRules(List<Map<String, String>> listRuleMaps) {
        this.allRules.clear();
        this.spellingRules.clear();
        for (Map<String, String> ruleMap : listRuleMaps) {
            Rule rule = ruleMap.containsKey("isTextLevelRule") ? new RemoteTextLevelRule(ruleMap) : new RemoteRule(ruleMap);
            if (rule.isDictionaryBasedSpellingRule()) {
                this.spellingRules.add(rule);
            }
            this.allRules.add(rule);
        }
    }

    static class RemoteTextLevelRule
    extends TextLevelRule {
        private final String ruleId;
        private final String description;
        private final boolean hasConfigurableValue;
        private final boolean isDictionaryBasedSpellingRule;
        private final int defaultValue;
        private final int minConfigurableValue;
        private final int maxConfigurableValue;
        private final int minToCheckParagraph;
        private final String configureText;

        RemoteTextLevelRule(Map<String, String> ruleMap) {
            this.ruleId = ruleMap.get("ruleId");
            this.description = ruleMap.get("description");
            if (ruleMap.containsKey("isDefaultOff")) {
                this.setDefaultOff();
            }
            if (ruleMap.containsKey("isOfficeDefaultOn")) {
                this.setOfficeDefaultOn();
            }
            if (ruleMap.containsKey("isOfficeDefaultOff")) {
                this.setOfficeDefaultOff();
            }
            this.isDictionaryBasedSpellingRule = ruleMap.containsKey("isDictionaryBasedSpellingRule");
            if (ruleMap.containsKey("hasConfigurableValue")) {
                this.hasConfigurableValue = true;
                this.defaultValue = Integer.parseInt(ruleMap.get("defaultValue"));
                this.minConfigurableValue = Integer.parseInt(ruleMap.get("minConfigurableValue"));
                this.maxConfigurableValue = Integer.parseInt(ruleMap.get("maxConfigurableValue"));
                this.configureText = ruleMap.get("configureText");
            } else {
                this.hasConfigurableValue = false;
                this.defaultValue = 0;
                this.minConfigurableValue = 0;
                this.maxConfigurableValue = 100;
                this.configureText = "";
            }
            this.minToCheckParagraph = Integer.parseInt(ruleMap.get("minToCheckParagraph"));
            this.setCategory(new Category(new CategoryId(ruleMap.get("categoryId")), ruleMap.get("categoryName")));
            this.setLocQualityIssueType(ITSIssueType.getIssueType(ruleMap.get("locQualityIssueType")));
        }

        @Override
        public String getId() {
            return this.ruleId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDictionaryBasedSpellingRule() {
            return this.isDictionaryBasedSpellingRule;
        }

        @Override
        public boolean hasConfigurableValue() {
            return this.hasConfigurableValue;
        }

        @Override
        public int getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public int getMinConfigurableValue() {
            return this.minConfigurableValue;
        }

        @Override
        public int getMaxConfigurableValue() {
            return this.maxConfigurableValue;
        }

        @Override
        public String getConfigureText() {
            return this.configureText;
        }

        @Override
        public RuleMatch[] match(List<AnalyzedSentence> sentences) {
            return null;
        }

        @Override
        public int minToCheckParagraph() {
            return this.minToCheckParagraph;
        }
    }

    static class RemoteRule
    extends Rule {
        private final String ruleId;
        private final String description;
        private final boolean hasConfigurableValue;
        private final boolean isDictionaryBasedSpellingRule;
        private final int defaultValue;
        private final int minConfigurableValue;
        private final int maxConfigurableValue;
        private final String configureText;

        RemoteRule(Map<String, String> ruleMap) {
            this.ruleId = ruleMap.get("ruleId");
            this.description = ruleMap.get("description");
            if (ruleMap.containsKey("isDefaultOff")) {
                this.setDefaultOff();
            }
            if (ruleMap.containsKey("isOfficeDefaultOn")) {
                this.setOfficeDefaultOn();
            }
            if (ruleMap.containsKey("isOfficeDefaultOff")) {
                this.setOfficeDefaultOff();
            }
            this.isDictionaryBasedSpellingRule = ruleMap.containsKey("isDictionaryBasedSpellingRule");
            if (ruleMap.containsKey("hasConfigurableValue")) {
                this.hasConfigurableValue = true;
                this.defaultValue = Integer.parseInt(ruleMap.get("defaultValue"));
                this.minConfigurableValue = Integer.parseInt(ruleMap.get("minConfigurableValue"));
                this.maxConfigurableValue = Integer.parseInt(ruleMap.get("maxConfigurableValue"));
                this.configureText = ruleMap.get("configureText");
            } else {
                this.hasConfigurableValue = false;
                this.defaultValue = 0;
                this.minConfigurableValue = 0;
                this.maxConfigurableValue = 100;
                this.configureText = "";
            }
            this.setCategory(new Category(new CategoryId(ruleMap.get("categoryId")), ruleMap.get("categoryName")));
            this.setLocQualityIssueType(ITSIssueType.getIssueType(ruleMap.get("locQualityIssueType")));
        }

        RemoteRule(RemoteRuleMatch remoteMatch) {
            String locQualityIssueType;
            this.ruleId = remoteMatch.getRuleId();
            this.description = remoteMatch.getRuleDescription();
            this.isDictionaryBasedSpellingRule = false;
            this.hasConfigurableValue = false;
            this.defaultValue = 0;
            this.minConfigurableValue = 0;
            this.maxConfigurableValue = 100;
            this.configureText = "";
            String categoryId = remoteMatch.getCategoryId().orElse(null);
            String categoryName = remoteMatch.getCategory().orElse(null);
            if (categoryId != null && categoryName != null) {
                this.setCategory(new Category(new CategoryId(categoryId), categoryName));
            }
            if ((locQualityIssueType = (String)remoteMatch.getLocQualityIssueType().orElse(null)) != null) {
                this.setLocQualityIssueType(ITSIssueType.getIssueType(locQualityIssueType));
            }
        }

        @Override
        public String getId() {
            return this.ruleId;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean isDictionaryBasedSpellingRule() {
            return this.isDictionaryBasedSpellingRule;
        }

        @Override
        public boolean hasConfigurableValue() {
            return this.hasConfigurableValue;
        }

        @Override
        public int getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public int getMinConfigurableValue() {
            return this.minConfigurableValue;
        }

        @Override
        public int getMaxConfigurableValue() {
            return this.maxConfigurableValue;
        }

        @Override
        public String getConfigureText() {
            return this.configureText;
        }

        @Override
        public RuleMatch[] match(AnalyzedSentence sentence) {
            return null;
        }
    }
}

