/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.lang.Locale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.languagetool.openoffice.FlatParagraphTools;
import org.languagetool.openoffice.MessageHandler;

public class IgnoredMatches {
    private final Map<Integer, Map<String, Set<Integer>>> ignoredMatches;
    private final Map<Integer, List<LocaleEntry>> spellLocales;

    public IgnoredMatches() {
        this.ignoredMatches = new HashMap<Integer, Map<String, Set<Integer>>>();
        this.spellLocales = new HashMap<Integer, List<LocaleEntry>>();
    }

    public IgnoredMatches(Map<Integer, Map<String, Set<Integer>>> ignoredMatches, Map<Integer, List<LocaleEntry>> spellLocales) {
        this.ignoredMatches = new HashMap<Integer, Map<String, Set<Integer>>>(ignoredMatches);
        this.spellLocales = new HashMap<Integer, List<LocaleEntry>>(spellLocales);
    }

    public IgnoredMatches(IgnoredMatches ignoredMatches) {
        this.ignoredMatches = new HashMap<Integer, Map<String, Set<Integer>>>(ignoredMatches.ignoredMatches);
        this.spellLocales = new HashMap<Integer, List<LocaleEntry>>(ignoredMatches.spellLocales);
    }

    public void setIgnoredMatch(int x, int y, String ruleId) {
        this.setIgnoredMatch(x, y, 0, ruleId, null, null);
    }

    public void setIgnoredMatch(int x, int y, int len, String ruleId, Locale locale, FlatParagraphTools flatPara) {
        Set<Integer> charNums;
        Map<Object, Object> ruleAtX;
        if (this.ignoredMatches.containsKey(y)) {
            ruleAtX = this.ignoredMatches.get(y);
            charNums = ruleAtX.containsKey(ruleId) ? (Set)ruleAtX.get(ruleId) : new HashSet();
        } else {
            ruleAtX = new HashMap();
            charNums = new HashSet<Integer>();
        }
        charNums.add(x);
        ruleAtX.put(ruleId, charNums);
        this.ignoredMatches.put(y, ruleAtX);
        if (locale != null) {
            List<Object> locales = !this.spellLocales.containsKey(y) ? new ArrayList() : this.spellLocales.get(y);
            for (int i = locales.size() - 1; i >= 0; --i) {
                if (((LocaleEntry)locales.get((int)i)).start != x) continue;
                locales.remove(i);
            }
            locales.add(new LocaleEntry(x, len, locale, ruleId));
            this.spellLocales.put(y, locales);
            this.removeSpellingMark(y, x, len, flatPara);
        }
    }

    public void removeIgnoredMatches(int y, FlatParagraphTools flatPara) {
        if (this.ignoredMatches.containsKey(y)) {
            this.ignoredMatches.remove(y);
            if (this.spellLocales.containsKey(y)) {
                List<LocaleEntry> locales = this.spellLocales.get(y);
                for (LocaleEntry entry : locales) {
                    this.resetLocale(y, entry.start, entry.length, entry.locale, flatPara);
                }
                this.spellLocales.remove(y);
            }
        }
    }

    public void removeIgnoredMatches(int y, String ruleId, FlatParagraphTools flatPara) {
        if (this.ignoredMatches.containsKey(y)) {
            Map<String, Set<Integer>> ruleAtX = this.ignoredMatches.get(y);
            if (ruleAtX.containsKey(ruleId)) {
                ruleAtX.remove(ruleId);
            }
            if (ruleAtX.isEmpty()) {
                this.ignoredMatches.remove(y);
            } else {
                this.ignoredMatches.put(y, ruleAtX);
            }
            if (this.spellLocales.containsKey(y)) {
                List<LocaleEntry> locales = this.spellLocales.get(y);
                for (int i = locales.size() - 1; i >= 0; --i) {
                    LocaleEntry entry = locales.get(i);
                    if (!entry.ruleId.equals(ruleId)) continue;
                    this.resetLocale(y, entry.start, entry.length, entry.locale, flatPara);
                    locales.remove(i);
                }
                this.spellLocales.put(y, locales);
            }
        }
    }

    public void removeIgnoredMatch(int x, int y, String ruleId, FlatParagraphTools flatPara) {
        if (this.ignoredMatches.containsKey(y)) {
            Set<Integer> charNums;
            Map<String, Set<Integer>> ruleAtX = this.ignoredMatches.get(y);
            if (ruleAtX.containsKey(ruleId) && (charNums = ruleAtX.get(ruleId)).contains(x)) {
                charNums.remove(x);
                if (charNums.isEmpty()) {
                    ruleAtX.remove(ruleId);
                } else {
                    ruleAtX.put(ruleId, charNums);
                }
                if (ruleAtX.isEmpty()) {
                    this.ignoredMatches.remove(y);
                } else {
                    this.ignoredMatches.put(y, ruleAtX);
                }
            }
            if (this.spellLocales.containsKey(y)) {
                List<LocaleEntry> locales = this.spellLocales.get(y);
                for (int i = locales.size() - 1; i >= 0; --i) {
                    LocaleEntry entry = locales.get(i);
                    if (entry.start != x || !entry.ruleId.equals(ruleId)) continue;
                    this.resetLocale(y, entry.start, entry.length, entry.locale, flatPara);
                    locales.remove(i);
                }
                this.spellLocales.put(y, locales);
            }
        }
    }

    public boolean isIgnored(int xFrom, int xTo, int y, String ruleId) {
        if (this.ignoredMatches.containsKey(y) && this.ignoredMatches.get(y).containsKey(ruleId)) {
            for (int x : this.ignoredMatches.get(y).get(ruleId)) {
                if (x < xFrom || x >= xTo) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsParagraph(int y) {
        return this.ignoredMatches.containsKey(y);
    }

    public boolean isEmpty() {
        return this.ignoredMatches.isEmpty();
    }

    public int size() {
        return this.ignoredMatches.size();
    }

    public Map<String, Set<Integer>> get(int y) {
        return this.ignoredMatches.get(y);
    }

    public Map<Integer, Map<String, Set<Integer>>> getFullIMMap() {
        return this.ignoredMatches;
    }

    public List<LocaleEntry> getLocaleEntries(int y) {
        return this.spellLocales.get(y);
    }

    public Map<Integer, List<LocaleEntry>> getFullSLMap() {
        return this.spellLocales;
    }

    public void put(int y, Map<String, Set<Integer>> ruleAtX) {
        this.ignoredMatches.put(y, ruleAtX);
    }

    public List<Integer> getAllParagraphs() {
        return new ArrayList<Integer>(this.ignoredMatches.keySet());
    }

    void removeSpellingMark(int y, int start, int length, FlatParagraphTools flatPara) {
        if (flatPara != null) {
            flatPara.setLanguageOfParagraph(y, start, length, new Locale("zxx", "", ""));
        }
    }

    private void resetLocale(int y, int start, int length, Locale locale, FlatParagraphTools flatPara) {
        if (flatPara != null) {
            flatPara.setLanguageOfParagraph(y, start, length, locale);
        }
    }

    public void resetAllIgnoredSpellingMarks(FlatParagraphTools flatPara) {
        if (flatPara != null) {
            for (int y : this.spellLocales.keySet()) {
                for (LocaleEntry entry : this.spellLocales.get(y)) {
                    this.removeSpellingMark(y, entry.start, entry.length, flatPara);
                }
            }
        }
    }

    public void resetAllLocale(FlatParagraphTools flatPara) {
        if (flatPara != null) {
            for (int y : this.spellLocales.keySet()) {
                for (LocaleEntry entry : this.spellLocales.get(y)) {
                    this.resetLocale(y, entry.start, entry.length, entry.locale, flatPara);
                }
            }
        } else {
            MessageHandler.printToLogFile("IgnoredMatches: resetAllLocale: flatPara == null");
        }
    }

    public static class LocaleEntry {
        int start;
        int length;
        Locale locale;
        String ruleId;

        LocaleEntry(int start, int length, Locale locale, String ruleId) {
            this.start = start;
            this.length = length;
            this.locale = locale;
            this.ruleId = ruleId;
        }
    }
}

