/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.container.XStringKeyMap;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.linguistic2.SingleProofreadingError;
import com.sun.star.text.XFlatParagraph;
import com.sun.star.text.XFlatParagraphIterator;
import com.sun.star.text.XFlatParagraphIteratorProvider;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SingleCheck;

public class FlatParagraphTools {
    private static boolean debugMode;
    private static int isBusy;
    private XFlatParagraphIterator xFlatParaIter;
    private XFlatParagraph lastFlatPara;
    private XComponent xComponent;

    FlatParagraphTools(XComponent xComponent) {
        debugMode = OfficeTools.DEBUG_MODE_FP;
        this.xComponent = xComponent;
        this.xFlatParaIter = this.getXFlatParagraphIterator(xComponent);
        this.lastFlatPara = this.getCurrentFlatParagraph();
    }

    public void setDisposed() {
        this.xFlatParaIter = null;
        this.lastFlatPara = null;
        this.xComponent = null;
    }

    boolean isValid() {
        return this.xFlatParaIter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private XFlatParagraphIterator getXFlatParagraphIterator(XComponent xComponent) {
        ++isBusy;
        try {
            if (xComponent == null) {
                XFlatParagraphIterator xFlatParagraphIterator = null;
                return xFlatParagraphIterator;
            }
            XFlatParagraphIteratorProvider xFlatParaItPro = (XFlatParagraphIteratorProvider)UnoRuntime.queryInterface(XFlatParagraphIteratorProvider.class, (Object)xComponent);
            if (xFlatParaItPro == null) {
                XFlatParagraphIterator xFlatParagraphIterator = null;
                return xFlatParagraphIterator;
            }
            XFlatParagraphIterator xFlatParagraphIterator = xFlatParaItPro.getFlatParagraphIterator(2, true);
            return xFlatParagraphIterator;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            XFlatParagraphIterator xFlatParagraphIterator = null;
            return xFlatParagraphIterator;
        }
        finally {
            --isBusy;
        }
    }

    public void init() {
        ++isBusy;
        try {
            XFlatParagraphIterator tmpFlatParaIter = this.getXFlatParagraphIterator(this.xComponent);
            if (tmpFlatParaIter != null) {
                this.xFlatParaIter = tmpFlatParaIter;
            }
        }
        finally {
            --isBusy;
        }
    }

    @Nullable
    private XFlatParagraph getCurrentFlatParagraph() {
        ++isBusy;
        try {
            if (this.xFlatParaIter == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getCurrentFlatParagraph: FlatParagraphIterator == null");
                }
                XFlatParagraph xFlatParagraph = null;
                return xFlatParagraph;
            }
            XFlatParagraph tmpFlatPara = this.xFlatParaIter.getNextPara();
            if (tmpFlatPara != null) {
                this.lastFlatPara = tmpFlatPara;
            }
            XFlatParagraph xFlatParagraph = tmpFlatPara;
            return xFlatParagraph;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            XFlatParagraph xFlatParagraph = null;
            return xFlatParagraph;
        }
        finally {
            --isBusy;
        }
    }

    @Nullable
    private XFlatParagraph getLastFlatParagraph() {
        this.getCurrentFlatParagraph();
        return this.lastFlatPara;
    }

    public boolean isFlatParaFromIter() {
        return this.getCurrentFlatParagraph() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XFlatParagraph getFlatParagraphAt(int nPara) {
        OfficeTools.waitForLO();
        ++isBusy;
        try {
            int num;
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getFlatParagraphAt: FlatParagraph == null");
                }
                XFlatParagraph xFlatParagraph = null;
                return xFlatParagraph;
            }
            XFlatParagraph tmpFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                xFlatPara = tmpFlatPara;
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            for (num = 0; xFlatPara != null && num < nPara; ++num) {
                xFlatPara = this.xFlatParaIter.getParaAfter(xFlatPara);
            }
            if (xFlatPara == null) {
                MessageHandler.printToLogFile("FlatParagraphTools: getFlatParagraphAt: FlatParagraph == null; n = " + num + "; nPara = " + nPara);
                XFlatParagraph xFlatParagraph = null;
                return xFlatParagraph;
            }
            XFlatParagraph xFlatParagraph = xFlatPara;
            return xFlatParagraph;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            XFlatParagraph xFlatParagraph = null;
            return xFlatParagraph;
        }
        finally {
            --isBusy;
        }
    }

    public String getCurrentParaText() {
        ++isBusy;
        try {
            XFlatParagraph xFlatPara = this.getCurrentFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getCurrentParaText: FlatParagraph == null");
                }
                String string = null;
                return string;
            }
            String string = new String(xFlatPara.getText());
            return string;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurNumFlatParagraph() {
        ++isBusy;
        try {
            XFlatParagraph xFlatPara = this.getCurrentFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getCurNumFlatParagraph: FlatParagraph == null");
                }
                int n = -1;
                return n;
            }
            int pos = -1;
            XFlatParagraph tmpXFlatPara = xFlatPara;
            while (tmpXFlatPara != null) {
                tmpXFlatPara = this.xFlatParaIter.getParaBefore(tmpXFlatPara);
                ++pos;
            }
            this.xFlatParaIter = this.getXFlatParagraphIterator(this.xComponent);
            int n = pos;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = -1;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FlatParagraphContainer getAllFlatParagraphs(Locale fixedLocale) {
        OfficeTools.waitForLO();
        ++isBusy;
        try {
            int len;
            String text;
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getAllFlatParagraphs: FlatParagraph == null");
                }
                FlatParagraphContainer flatParagraphContainer = null;
                return flatParagraphContainer;
            }
            ArrayList<String> allParas = new ArrayList<String>();
            ArrayList<Locale> locales = new ArrayList<Locale>();
            ArrayList<int[]> footnotePositions = new ArrayList<int[]>();
            XFlatParagraph tmpFlatPara = xFlatPara;
            ArrayList<Integer> sortedTextIds = this.getIntPropertyValue("SortedTextId", tmpFlatPara) == -1 ? null : new ArrayList<Integer>();
            int documentElementsCount = sortedTextIds == null ? -1 : this.getIntPropertyValue("DocumentElementsCount", tmpFlatPara);
            Locale locale = null;
            while (tmpFlatPara != null) {
                text = new String(tmpFlatPara.getText());
                len = text.length();
                allParas.add(0, text);
                footnotePositions.add(0, this.getIntArrayPropertyValue("FootnotePositions", tmpFlatPara));
                locale = FlatParagraphTools.getPrimaryParagraphLanguage(tmpFlatPara, 0, len, fixedLocale, locale, false);
                locales.add(0, locale);
                if (sortedTextIds != null) {
                    sortedTextIds.add(0, this.getIntPropertyValue("SortedTextId", tmpFlatPara));
                }
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            tmpFlatPara = this.xFlatParaIter.getParaAfter(xFlatPara);
            while (tmpFlatPara != null) {
                text = new String(tmpFlatPara.getText());
                len = text.length();
                allParas.add(text);
                footnotePositions.add(this.getIntArrayPropertyValue("FootnotePositions", tmpFlatPara));
                locale = FlatParagraphTools.getPrimaryParagraphLanguage(tmpFlatPara, 0, len, fixedLocale, locale, false);
                locales.add(locale);
                if (debugMode) {
                    this.printPropertyValueInfo(tmpFlatPara);
                }
                if (sortedTextIds != null) {
                    sortedTextIds.add(this.getIntPropertyValue("SortedTextId", tmpFlatPara));
                }
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
            }
            this.xFlatParaIter = this.getXFlatParagraphIterator(this.xComponent);
            FlatParagraphContainer flatParagraphContainer = new FlatParagraphContainer(allParas, locales, footnotePositions, sortedTextIds, documentElementsCount);
            return flatParagraphContainer;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            FlatParagraphContainer flatParagraphContainer = null;
            return flatParagraphContainer;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public List<String> getFlatParagraphs(List<Integer> nParas) {
        OfficeTools.waitForLO();
        ++isBusy;
        try {
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getAllFlatParagraphs: FlatParagraph == null");
                }
                List<String> list = null;
                return list;
            }
            ArrayList<String> sParas = new ArrayList<String>();
            XFlatParagraph tmpFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                xFlatPara = tmpFlatPara;
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            int nFlat = 0;
            int nPara = 0;
            while (xFlatPara != null && nPara < nParas.size()) {
                if (nFlat == nParas.get(nPara)) {
                    String text = new String(xFlatPara.getText());
                    sParas.add(text);
                    ++nPara;
                }
                xFlatPara = this.xFlatParaIter.getParaAfter(xFlatPara);
                ++nFlat;
            }
            ArrayList<String> arrayList = sParas;
            return arrayList;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            List<String> list = null;
            return list;
        }
        finally {
            --isBusy;
        }
    }

    private static Locale getSaveLocale(String language, String country, String variant) {
        return new Locale(new String(language), new String(country), new String(variant));
    }

    private static Locale getParagraphLanguage(XFlatParagraph flatPara, int first, int len) throws IllegalArgumentException {
        Locale locale = flatPara.getLanguageOfText(first, len);
        if (locale == null || locale.Language.isEmpty()) {
            locale = flatPara.getPrimaryLanguageOfText(first, len);
        }
        return FlatParagraphTools.getSaveLocale(locale.Language, locale.Country, locale.Variant);
    }

    private static List<Integer> getLanguagePortions(XFlatParagraph flatPara, int len) throws IllegalArgumentException {
        ArrayList<Integer> langPortions = new ArrayList<Integer>();
        Locale lastLocale = flatPara.getLanguageOfText(0, 1);
        for (int i = 1; i < len; ++i) {
            Locale locale = flatPara.getLanguageOfText(i, 1);
            if (OfficeTools.isEqualLocale(lastLocale, locale)) continue;
            langPortions.add(i);
            lastLocale = locale;
        }
        return langPortions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Locale getPrimaryParagraphLanguage(XFlatParagraph flatPara, int start, int len, Locale fixedLocale, Locale lastLocale, boolean onlyPrimary) throws Throwable {
        ++isBusy;
        try {
            Locale locale;
            if (fixedLocale != null) {
                Locale locale2 = fixedLocale;
                return locale2;
            }
            if (len == 0 && lastLocale != null) {
                Locale locale3 = lastLocale.Variant.startsWith("99-") ? FlatParagraphTools.getSaveLocale(lastLocale.Language, lastLocale.Country, lastLocale.Variant.substring("99-".length())) : lastLocale;
                return locale3;
            }
            if (len < 2) {
                Locale locale4 = FlatParagraphTools.getParagraphLanguage(flatPara, start, len);
                return locale4;
            }
            HashMap<Locale, Integer> locales = new HashMap<Locale, Integer>();
            for (int i = start; i < len; ++i) {
                Locale locale5 = flatPara.getLanguageOfText(i, 1);
                boolean existingLocale = false;
                for (Locale loc : locales.keySet()) {
                    if (!loc.Language.equals(locale5.Language)) continue;
                    locales.put(loc, (Integer)locales.get(loc) + 1);
                    existingLocale = true;
                    break;
                }
                if (existingLocale) continue;
                locales.put(locale5, 1);
            }
            if (locales.keySet().size() == 0) {
                Locale i = lastLocale.Variant.startsWith("99-") ? FlatParagraphTools.getSaveLocale(lastLocale.Language, lastLocale.Country, lastLocale.Variant.substring("99-".length())) : lastLocale;
                return i;
            }
            Locale biggestLocal = null;
            int biggestLocalNumber = 0;
            for (Locale loc : locales.keySet()) {
                int locNum = (Integer)locales.get(loc);
                if (biggestLocal != null && locNum <= biggestLocalNumber) continue;
                biggestLocal = loc;
                biggestLocalNumber = locNum;
            }
            if (biggestLocal == null) {
                locale = lastLocale.Variant.startsWith("99-") ? new Locale(lastLocale.Language, lastLocale.Country, lastLocale.Variant.substring("99-".length())) : lastLocale;
                return locale;
            }
            if (onlyPrimary || locales.keySet().size() == 1) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getPrimaryParagraphLanguage: locale: " + OfficeTools.localeToString(biggestLocal));
                }
                locale = biggestLocal;
                return locale;
            }
            if (debugMode) {
                MessageHandler.printToLogFile("FlatParagraphTools: getPrimaryParagraphLanguage: is multilingual locale: " + OfficeTools.localeToString(biggestLocal));
            }
            locale = FlatParagraphTools.getSaveLocale(biggestLocal.Language, biggestLocal.Country, "99-" + biggestLocal.Variant);
            return locale;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getPrimaryLanguageOfPartOfParagraph(int nPara, int start, int len, Locale lastLocale) throws Throwable {
        ++isBusy;
        try {
            XFlatParagraph flatPara = this.getFlatParagraphAt(nPara);
            if (flatPara == null) {
                Locale locale = lastLocale;
                return locale;
            }
            Locale locale = FlatParagraphTools.getPrimaryParagraphLanguage(flatPara, start, len, null, lastLocale, true);
            return locale;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAllFlatPara() {
        OfficeTools.waitForLO();
        ++isBusy;
        try {
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getNumberOfAllFlatPara: FlatParagraph == null");
                }
                int n = -1;
                return n;
            }
            XFlatParagraph tmpFlatPara = xFlatPara;
            int num = 0;
            while (tmpFlatPara != null) {
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
                ++num;
            }
            tmpFlatPara = xFlatPara;
            --num;
            while (tmpFlatPara != null) {
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
                ++num;
            }
            int n = num;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = -1;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    public int[] getFootnotePosition(XFlatParagraph xFlatPara) {
        return this.getIntArrayPropertyValue("FootnotePositions", xFlatPara);
    }

    private Object getPropertyValueAsObject(String propName, XFlatParagraph xFlatPara) {
        try {
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getPropertyValueAsObject: FlatParagraph == null");
                }
                return null;
            }
            XPropertySet paraProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFlatPara);
            if (paraProps == null) {
                MessageHandler.printToLogFile("FlatParagraphTools: getPropertyValueAsObject: XPropertySet == null");
                return null;
            }
            return paraProps.getPropertyValue(propName);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    private int[] getIntArrayPropertyValue(String propName, XFlatParagraph xFlatPara) {
        try {
            Object propertyValue = this.getPropertyValueAsObject(propName, xFlatPara);
            if (propertyValue == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getIntArrayPropertyValue: propertyValue == null");
                }
                return new int[0];
            }
            if (propertyValue instanceof int[]) {
                return (int[])propertyValue;
            }
            MessageHandler.printToLogFile("FlatParagraphTools: getIntArrayPropertyValue: Not of expected type int[]: " + propertyValue + ": " + propertyValue);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        return new int[0];
    }

    private int getIntPropertyValue(String propName, XFlatParagraph xFlatPara) {
        try {
            Object propertyValue = this.getPropertyValueAsObject(propName, xFlatPara);
            if (propertyValue == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: getIntPropertyValue: propertyValue == null");
                }
                return -1;
            }
            if (propertyValue instanceof Integer) {
                return (Integer)propertyValue;
            }
            if (debugMode) {
                MessageHandler.printToLogFile("FlatParagraphTools: getPropertyValues: Not of expected type int: " + propertyValue + ": " + propertyValue);
            }
            return -1;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return -1;
        }
    }

    private void printPropertyValueInfo(XFlatParagraph xFlatPara) {
        if (xFlatPara == null) {
            MessageHandler.printToLogFile("FlatParagraphTools: printPropertyValues: FlatParagraph == null");
            return;
        }
        XPropertySet paraProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xFlatPara);
        if (paraProps == null) {
            MessageHandler.printToLogFile("XPropertySet == null");
            return;
        }
        MessageHandler.printToLogFile("FlatParagraphTools: Property Value Info:");
        try {
            XPropertySetInfo propertySetInfo = paraProps.getPropertySetInfo();
            for (Property property : propertySetInfo.getProperties()) {
                int nValue = property.Name.equals("FootnotePositions") || property.Name.equals("FieldPositions") ? ((int[])paraProps.getPropertyValue(property.Name)).length : (Integer)paraProps.getPropertyValue(property.Name);
                MessageHandler.printToLogFile("Name : " + property.Name + "; Type : " + property.Type.getTypeName() + "; Value : " + nValue + "; Handle : " + property.Handle);
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlatParasAsChecked(int from, int to, List<Boolean> isChecked) {
        OfficeTools.waitForLO();
        ++isBusy;
        try {
            int num;
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: setFlatParasAsChecked: FlatParagraph == null");
                }
                return;
            }
            if (isChecked == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: setFlatParasAsChecked: List isChecked == null");
                }
                isChecked = new ArrayList<Boolean>();
            }
            XFlatParagraph tmpFlatPara = xFlatPara;
            XFlatParagraph startFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                startFlatPara = tmpFlatPara;
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            tmpFlatPara = startFlatPara;
            for (num = 0; tmpFlatPara != null && num < from; ++num) {
                if (debugMode && num >= isChecked.size()) {
                    MessageHandler.printToLogFile("FlatParagraphTools: setFlatParasAsChecked: List isChecked == null");
                }
                if (num < isChecked.size() && isChecked.get(num).booleanValue()) {
                    tmpFlatPara.setChecked(2, true);
                }
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
            }
            while (tmpFlatPara != null && num < to) {
                tmpFlatPara.setChecked(2, false);
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
                ++num;
            }
            while (tmpFlatPara != null) {
                if (debugMode && num >= isChecked.size()) {
                    MessageHandler.printToLogFile("FlatParagraphTools: setFlatParasAsChecked: List isChecked == null");
                }
                if (num < isChecked.size() && isChecked.get(num).booleanValue()) {
                    tmpFlatPara.setChecked(2, true);
                }
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
                ++num;
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    public void setFlatParasAsChecked() {
        OfficeTools.waitForLO();
        ++isBusy;
        try {
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: setFlatParasAsChecked: FlatParagraph == null");
                }
                return;
            }
            XFlatParagraph tmpFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                tmpFlatPara.setChecked(2, true);
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            tmpFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                tmpFlatPara.setChecked(2, true);
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Boolean> isChecked(List<Integer> changedParas, int nDiv) {
        OfficeTools.waitForLO();
        ++isBusy;
        ArrayList<Boolean> isChecked = new ArrayList<Boolean>();
        try {
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: isChecked: FlatParagraph == null");
                }
                List<Boolean> list = null;
                return list;
            }
            XFlatParagraph tmpFlatPara = xFlatPara;
            XFlatParagraph startFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                startFlatPara = tmpFlatPara;
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            tmpFlatPara = startFlatPara;
            int i = 0;
            while (tmpFlatPara != null) {
                boolean dontCheck = (changedParas == null || !changedParas.contains(i - nDiv)) && tmpFlatPara.isChecked(2);
                isChecked.add(dontCheck);
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
                ++i;
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
        return isChecked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markParagraphs(Map<Integer, List<SingleCheck.SentenceErrors>> changedParas) {
        ++isBusy;
        try {
            if (changedParas == null || changedParas.isEmpty()) {
                return;
            }
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: markParagraphs: FlatParagraph == null");
                }
                return;
            }
            XFlatParagraph tmpFlatPara = xFlatPara;
            XFlatParagraph startFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                startFlatPara = tmpFlatPara;
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            tmpFlatPara = startFlatPara;
            int num = 0;
            int nMarked = 0;
            while (tmpFlatPara != null && nMarked < changedParas.size()) {
                if (changedParas.containsKey(num)) {
                    this.addMarksToOneParagraph(tmpFlatPara, changedParas.get(num));
                    if (debugMode) {
                        MessageHandler.printToLogFile("FlatParagraphTools: mark Paragraph: " + num + ", Text: " + tmpFlatPara.getText());
                    }
                    ++nMarked;
                }
                tmpFlatPara = this.xFlatParaIter.getParaAfter(tmpFlatPara);
                ++num;
            }
            if (debugMode && tmpFlatPara == null) {
                MessageHandler.printToLogFile("FlatParagraphTools: markParagraphs: tmpFlatParagraph == null");
            }
            this.xFlatParaIter = this.getXFlatParagraphIterator(this.xComponent);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    public void markCurrentParagraph(List<SingleCheck.SentenceErrors> errorList) {
        ++isBusy;
        try {
            if (errorList == null || errorList.size() == 0) {
                return;
            }
            XFlatParagraph xFlatPara = this.getCurrentFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: markCurrentParagraph: FlatParagraph == null");
                }
                return;
            }
            this.addMarksToOneParagraph(xFlatPara, errorList);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    private void addMarksToOneParagraph(XFlatParagraph flatPara, List<SingleCheck.SentenceErrors> errorList) throws Throwable {
        boolean isChecked = flatPara.isChecked(2);
        if (debugMode) {
            MessageHandler.printToLogFile("FlatParagraphTools: addMarksToOneParagraph: xMarkingAccess: isChecked = " + isChecked);
        }
        for (SingleCheck.SentenceErrors errors : errorList) {
            for (SingleProofreadingError pError : errors.sentenceErrors) {
                XStringKeyMap props = flatPara.getMarkupInfoContainer();
                PropertyValue[] properties = pError.aProperties;
                int color = -1;
                short type = -1;
                for (PropertyValue property : properties) {
                    if ("LineColor".equals(property.Name)) {
                        color = (Integer)property.Value;
                        continue;
                    }
                    if (!"LineType".equals(property.Name)) continue;
                    type = (Short)property.Value;
                }
                try {
                    if (color >= 0) {
                        props.insertValue("LineColor", (Object)color);
                    }
                    if (type > 0) {
                        props.insertValue("LineType", (Object)type);
                    }
                }
                catch (Throwable t) {
                    MessageHandler.printException(t);
                }
                flatPara.commitStringMarkup(2, pError.aRuleIdentifier, pError.nErrorStart, pError.nErrorLength, props);
            }
        }
        if (isChecked) {
            flatPara.setChecked(2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeTextOfParagraph(int nPara, int nStart, int nLen, String newText) {
        OfficeTools.waitForLO();
        ++isBusy;
        try {
            int num;
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: changeTextOfParagraph: FlatParagraph == null");
                }
                return;
            }
            XFlatParagraph tmpFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                xFlatPara = tmpFlatPara;
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            for (num = 0; xFlatPara != null && num < nPara; ++num) {
                xFlatPara = this.xFlatParaIter.getParaAfter(xFlatPara);
            }
            if (xFlatPara == null) {
                MessageHandler.printToLogFile("FlatParagraphTools: changeTextOfParagraph: FlatParagraph == null; n = " + num + "; nPara = " + nPara);
                return;
            }
            xFlatPara.changeText(nStart, nLen, newText, new PropertyValue[0]);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLanguageOfParagraph(int nPara, int nStart, int nLen, Locale locale) {
        OfficeTools.waitForLO();
        ++isBusy;
        try {
            int num;
            XFlatParagraph xFlatPara = this.getLastFlatParagraph();
            if (xFlatPara == null) {
                if (debugMode) {
                    MessageHandler.printToLogFile("FlatParagraphTools: setLanguageOfParagraph: FlatParagraph == null");
                }
                return;
            }
            XFlatParagraph tmpFlatPara = xFlatPara;
            while (tmpFlatPara != null) {
                xFlatPara = tmpFlatPara;
                tmpFlatPara = this.xFlatParaIter.getParaBefore(tmpFlatPara);
            }
            for (num = 0; xFlatPara != null && num < nPara; ++num) {
                xFlatPara = this.xFlatParaIter.getParaAfter(xFlatPara);
            }
            if (xFlatPara == null) {
                MessageHandler.printToLogFile("FlatParagraphTools: setLanguageOfParagraph: FlatParagraph == null; n = " + num + "; nPara = " + nPara);
                return;
            }
            PropertyValue[] propertyValues = new PropertyValue[]{new PropertyValue("CharLocale", -1, (Object)locale, PropertyState.DIRECT_VALUE)};
            xFlatPara.changeAttributes(nStart, nLen, propertyValues);
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return;
        }
        finally {
            --isBusy;
        }
    }

    public static boolean isBusy() {
        return isBusy > 0;
    }

    public static void reset() {
        isBusy = 0;
    }

    static {
        isBusy = 0;
    }

    public static class FlatParagraphContainer {
        public List<String> paragraphs;
        public List<Locale> locales;
        public List<int[]> footnotePositions;
        public List<Integer> sortedTextIds;
        public int documentElementsCount;

        FlatParagraphContainer(List<String> paragraphs, List<Locale> locales, List<int[]> footnotePositions, List<Integer> sortedTextIds, int documentElementsCount) {
            this.paragraphs = paragraphs;
            this.locales = locales;
            this.footnotePositions = footnotePositions;
            this.sortedTextIds = sortedTextIds;
            this.documentElementsCount = documentElementsCount;
        }
    }
}

