/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.beans.Property;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XEnumerationAccess;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.lang.XComponent;
import com.sun.star.style.XStyleFamiliesSupplier;
import com.sun.star.text.XEndnotesSupplier;
import com.sun.star.text.XFootnote;
import com.sun.star.text.XFootnotesSupplier;
import com.sun.star.text.XMarkingAccess;
import com.sun.star.text.XParagraphCursor;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFramesSupplier;
import com.sun.star.text.XTextRange;
import com.sun.star.text.XTextSection;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.UnoRuntime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.OfficeTools;

public class DocumentCursorTools {
    public static int TEXT_TYPE_NORMAL = -1;
    public static int TEXT_TYPE_AUTOMATIC = -2;
    static final String[] HeaderFooterTypes = new String[]{"HeaderText", "HeaderTextRight", "HeaderTextLeft", "HeaderTextFirst", "FooterText", "FooterTextRight", "FooterTextLeft", "FooterTextFirst"};
    private static int isBusy = 0;
    private boolean isCheckedSortedTextId = false;
    private boolean hasSortedTextId = false;
    private boolean isDisposed = false;
    private XParagraphCursor xPCursor;
    private XTextCursor xTextCursor;
    private XTextDocument curDoc;

    DocumentCursorTools(XComponent xComponent) {
        ++isBusy;
        try {
            if (!this.isDisposed) {
                this.curDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)xComponent);
                OfficeTools.waitForLtDictionary();
                this.xTextCursor = this.getCursor(xComponent);
                this.xPCursor = this.getParagraphCursor(xComponent);
            }
        }
        finally {
            --isBusy;
        }
    }

    public void setDisposed() {
        this.xPCursor = null;
        this.xTextCursor = null;
        this.curDoc = null;
        this.isDisposed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private XTextCursor getCursor(XComponent xComponent) {
        ++isBusy;
        try {
            if (this.curDoc == null) {
                XTextCursor xTextCursor = null;
                return xTextCursor;
            }
            XText xText = this.curDoc.getText();
            if (xText == null) {
                XTextCursor xTextCursor = null;
                return xTextCursor;
            }
            XTextRange xStart = xText.getStart();
            try {
                XTextCursor xTextCursor = xText.createTextCursorByRange(xStart);
                return xTextCursor;
            }
            catch (Throwable t) {
                try {
                    XTextCursor xTextCursor = null;
                    --isBusy;
                    return xTextCursor;
                }
                catch (Throwable t2) {
                    MessageHandler.printException(t2);
                    XTextCursor xTextCursor = null;
                    return xTextCursor;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private XParagraphCursor getParagraphCursor(XComponent xComponent) {
        ++isBusy;
        try {
            if (this.xTextCursor == null) {
                XParagraphCursor xParagraphCursor = null;
                return xParagraphCursor;
            }
            XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)this.xTextCursor);
            return xParagraphCursor;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            XParagraphCursor xParagraphCursor = null;
            return xParagraphCursor;
        }
        finally {
            --isBusy;
        }
    }

    @Nullable
    public XTextCursor getTextCursor() {
        return this.xTextCursor;
    }

    @Nullable
    public XParagraphCursor getParagraphCursor() {
        return this.xPCursor;
    }

    int getNumberOfAllTextParagraphs() {
        ++isBusy;
        try {
            if (this.xPCursor == null) {
                int n = 0;
                return n;
            }
            this.xPCursor.gotoStart(false);
            int nPara = 1;
            while (this.xPCursor.gotoNextParagraph(false)) {
                ++nPara;
            }
            int n = nPara;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = 0;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    private static List<Integer> getDeletedCharacters(XParagraphCursor xPCursor, boolean withDeleted) {
        if (xPCursor == null) {
            MessageHandler.printToLogFile("DocumentCursorTools: Properties: ParagraphCursor == null");
            return null;
        }
        ArrayList<Integer> deletePositions = new ArrayList<Integer>();
        if (!withDeleted) {
            return deletePositions;
        }
        int num = 0;
        try {
            XEnumerationAccess xParaEnumAccess = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)xPCursor);
            if (xParaEnumAccess == null) {
                return null;
            }
            XEnumeration xParaEnum = xParaEnumAccess.createEnumeration();
            if (xParaEnum == null) {
                return null;
            }
            while (xParaEnum.hasMoreElements()) {
                XEnumeration xEnum;
                XEnumerationAccess xEnumAccess = null;
                if (xParaEnum.hasMoreElements()) {
                    xEnumAccess = (XEnumerationAccess)UnoRuntime.queryInterface(XEnumerationAccess.class, (Object)xParaEnum.nextElement());
                }
                if (xEnumAccess == null || (xEnum = xEnumAccess.createEnumeration()) == null) continue;
                boolean isDelete = false;
                while (xEnum.hasMoreElements()) {
                    XPropertySet xTextPortionPropertySet;
                    XTextRange xPortion = (XTextRange)UnoRuntime.queryInterface(XTextRange.class, (Object)xEnum.nextElement());
                    if (xPortion == null || (xTextPortionPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPortion)) == null) continue;
                    String textPortionType = (String)xTextPortionPropertySet.getPropertyValue("TextPortionType");
                    if (textPortionType != null && textPortionType.equals("Redline")) {
                        String redlineType = (String)xTextPortionPropertySet.getPropertyValue("RedlineType");
                        if (redlineType == null || !redlineType.equals("Delete")) continue;
                        isDelete = !isDelete;
                        continue;
                    }
                    int portionLen = xPortion.getString().length();
                    if (isDelete) {
                        for (int i = num; i < num + portionLen; ++i) {
                            deletePositions.add(i);
                        }
                    }
                    num += portionLen;
                }
            }
        }
        catch (Throwable e) {
            MessageHandler.printException(e);
        }
        if (deletePositions.isEmpty()) {
            return null;
        }
        return deletePositions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    DocumentText getAllTextParagraphs(boolean withDeleted) {
        ++isBusy;
        try {
            ArrayList<String> allParas = new ArrayList<String>();
            HashMap<Integer, Integer> headingNumbers = new HashMap<Integer, Integer>();
            ArrayList<Integer> automaticTextParagraphs = new ArrayList<Integer>();
            ArrayList<Integer> sortedTextIds = null;
            ArrayList<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
            if (this.xPCursor == null) {
                DocumentText documentText = null;
                return documentText;
            }
            int paraNum = 0;
            this.xPCursor.gotoStart(false);
            this.xPCursor.gotoStartOfParagraph(false);
            this.xPCursor.gotoEndOfParagraph(true);
            if (sortedTextIds == null && (this.hasSortedTextId || !this.isCheckedSortedTextId)) {
                this.isCheckedSortedTextId = true;
                if (this.hasSortedTextId || this.supportOfSortedTextId(this.xPCursor)) {
                    this.hasSortedTextId = true;
                    sortedTextIds = new ArrayList<Integer>();
                }
            }
            allParas.add(new String(this.xPCursor.getString()));
            deletedCharacters.add(DocumentCursorTools.getDeletedCharacters(this.xPCursor, withDeleted));
            int textType = this.getTextType();
            if (textType >= 0) {
                headingNumbers.put(paraNum, textType);
            } else if (textType == TEXT_TYPE_AUTOMATIC) {
                headingNumbers.put(paraNum, 0);
                automaticTextParagraphs.add(paraNum);
            }
            if (sortedTextIds != null) {
                sortedTextIds.add(DocumentCursorTools.getSortedTextId(this.xPCursor));
            }
            while (this.xPCursor.gotoNextParagraph(false)) {
                this.xPCursor.gotoStartOfParagraph(false);
                this.xPCursor.gotoEndOfParagraph(true);
                allParas.add(new String(this.xPCursor.getString()));
                deletedCharacters.add(DocumentCursorTools.getDeletedCharacters(this.xPCursor, withDeleted));
                ++paraNum;
                textType = this.getTextType();
                if (textType >= 0) {
                    headingNumbers.put(paraNum, textType);
                } else if (textType == TEXT_TYPE_AUTOMATIC) {
                    headingNumbers.put(paraNum, 0);
                    automaticTextParagraphs.add(paraNum);
                }
                if (sortedTextIds == null) continue;
                sortedTextIds.add(DocumentCursorTools.getSortedTextId(this.xPCursor));
            }
            DocumentText documentText = new DocumentText(allParas, headingNumbers, automaticTextParagraphs, sortedTextIds, deletedCharacters);
            return documentText;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            DocumentText documentText = null;
            return documentText;
        }
        finally {
            --isBusy;
        }
    }

    private int getTextType() {
        String paraStyleName = null;
        XPropertySet xParagraphPropertySet = null;
        try {
            xParagraphPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xPCursor.getStart());
            if (xParagraphPropertySet == null) {
                return TEXT_TYPE_NORMAL;
            }
            Object o = xParagraphPropertySet.getPropertyValue("ParaStyleName");
            if (o != null) {
                paraStyleName = (String)o;
            }
        }
        catch (Throwable e) {
            MessageHandler.printException(e);
            return TEXT_TYPE_NORMAL;
        }
        try {
            Object o;
            XTextSection xTextSection = (XTextSection)UnoRuntime.queryInterface(XTextSection.class, (Object)xParagraphPropertySet.getPropertyValue("TextSection"));
            if (xParagraphPropertySet != null && (o = (xParagraphPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextSection)).getPropertyValue("IsProtected")) != null && ((Boolean)o).booleanValue()) {
                return TEXT_TYPE_AUTOMATIC;
            }
        }
        catch (Throwable xTextSection) {
            // empty catch block
        }
        if (paraStyleName == null) {
            return TEXT_TYPE_NORMAL;
        }
        if (paraStyleName.equals("Title") || paraStyleName.equals("Subtitle") || paraStyleName.equals("Heading")) {
            return 0;
        }
        if (paraStyleName.startsWith("Heading")) {
            String numberString = paraStyleName.substring(7).trim();
            if (numberString.isEmpty()) {
                return 0;
            }
            int ret = 0;
            try {
                ret = Integer.parseInt(numberString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return ret;
        }
        if (paraStyleName.startsWith("Contents")) {
            return TEXT_TYPE_AUTOMATIC;
        }
        return TEXT_TYPE_NORMAL;
    }

    void printProperties() {
        Property[] properties;
        if (this.xPCursor == null) {
            MessageHandler.printToLogFile("DocumentCursorTools: Properties: ParagraphCursor == null");
            return;
        }
        XPropertySet xParagraphPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.xPCursor.getStart());
        for (Property property : properties = xParagraphPropertySet.getPropertySetInfo().getProperties()) {
            MessageHandler.printToLogFile("DocumentCursorTools: Properties: Name: " + property.Name + ", Type: " + property.Type);
        }
        try {
            MessageHandler.printToLogFile("DocumentCursorTools: Properties: SortedTextId: " + xParagraphPropertySet.getPropertyValue("SortedTextId") + "\n");
        }
        catch (Throwable e) {
            MessageHandler.printException(e);
        }
    }

    private static int getSortedTextId(XParagraphCursor xPCursor) {
        try {
            if (xPCursor == null) {
                MessageHandler.printToLogFile("DocumentCursorTools: Properties: ParagraphCursor == null");
                return -1;
            }
            XPropertySet xParagraphPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPCursor.getStart());
            return (Integer)xParagraphPropertySet.getPropertyValue("SortedTextId");
        }
        catch (Throwable e) {
            MessageHandler.printException(e);
            return -1;
        }
    }

    private boolean supportOfSortedTextId(XParagraphCursor xPCursor) {
        try {
            if (xPCursor == null) {
                MessageHandler.printToLogFile("DocumentCursorTools: Properties: ParagraphCursor == null");
                return false;
            }
            XPropertySet xParagraphPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPCursor.getStart());
            return xParagraphPropertySet.getPropertyValue("SortedTextId") != null;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private List<Integer> addAllParagraphsOfText(XText xText, List<String> sText, List<List<Integer>> deletedCharacters, List<Integer> sortedTextIds, boolean withDeleted) {
        XTextCursor xTextCursor = xText.createTextCursor();
        XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
        if (xParagraphCursor == null) {
            return sortedTextIds;
        }
        try {
            if (sortedTextIds == null && (this.hasSortedTextId || !this.isCheckedSortedTextId)) {
                this.isCheckedSortedTextId = true;
                if (this.hasSortedTextId || this.supportOfSortedTextId(xParagraphCursor)) {
                    this.hasSortedTextId = true;
                    sortedTextIds = new ArrayList<Integer>();
                }
            }
        }
        catch (Exception e) {
            MessageHandler.printException(e);
        }
        xParagraphCursor.gotoStart(false);
        do {
            xParagraphCursor.gotoStartOfParagraph(false);
            xParagraphCursor.gotoEndOfParagraph(true);
            sText.add(new String(xParagraphCursor.getString()));
            deletedCharacters.add(DocumentCursorTools.getDeletedCharacters(xParagraphCursor, withDeleted));
            if (sortedTextIds == null) continue;
            sortedTextIds.add(DocumentCursorTools.getSortedTextId(xParagraphCursor));
        } while (xParagraphCursor.gotoNextParagraph(false));
        return sortedTextIds;
    }

    private List<String> getAllParagraphsOfText(XText xText) {
        XTextCursor xTextCursor = xText.createTextCursor();
        XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
        ArrayList<String> sText = new ArrayList<String>();
        if (xParagraphCursor == null) {
            return sText;
        }
        xParagraphCursor.gotoStart(false);
        do {
            xParagraphCursor.gotoStartOfParagraph(false);
            xParagraphCursor.gotoEndOfParagraph(true);
            sText.add(new String(xParagraphCursor.getString()));
        } while (xParagraphCursor.gotoNextParagraph(false));
        return sText;
    }

    private static int getNumberOfAllParagraphsOfText(XText xText) {
        int num = 0;
        XTextCursor xTextCursor = xText.createTextCursor();
        XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
        if (xParagraphCursor != null) {
            xParagraphCursor.gotoStart(false);
            do {
                ++num;
            } while (xParagraphCursor.gotoNextParagraph(false));
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentText getTextOfAllFrames(boolean withDeleted) {
        ++isBusy;
        try {
            ArrayList<String> sText = new ArrayList<String>();
            HashMap<Integer, Integer> headingNumbers = new HashMap<Integer, Integer>();
            ArrayList<Integer> hNumbers = new ArrayList<Integer>();
            ArrayList<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
            List<Integer> sortedTextIds = null;
            XTextFramesSupplier xTextFrameSupplier = (XTextFramesSupplier)UnoRuntime.queryInterface(XTextFramesSupplier.class, (Object)this.curDoc);
            XNameAccess xNamedFrames = xTextFrameSupplier.getTextFrames();
            for (String name : xNamedFrames.getElementNames()) {
                int i;
                ArrayList<String> sTxt = new ArrayList<String>();
                ArrayList<List<Integer>> delCharacters = new ArrayList<List<Integer>>();
                Object o = xNamedFrames.getByName(name);
                XText xFrameText = (XText)UnoRuntime.queryInterface(XText.class, (Object)o);
                this.addAllParagraphsOfText(xFrameText, sTxt, delCharacters, sortedTextIds, withDeleted);
                for (i = 0; i < hNumbers.size(); ++i) {
                    hNumbers.set(i, (Integer)hNumbers.get(i) + sTxt.size());
                }
                hNumbers.add(0, 0);
                sText.addAll(0, sTxt);
                deletedCharacters.addAll(0, delCharacters);
                for (i = 0; i < hNumbers.size(); ++i) {
                    headingNumbers.put((Integer)hNumbers.get(i), 0);
                }
            }
            DocumentText documentText = new DocumentText(sText, headingNumbers, new ArrayList<Integer>(), sortedTextIds, deletedCharacters);
            return documentText;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            DocumentText documentText = null;
            return documentText;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAllFrames() {
        ++isBusy;
        try {
            int num = 0;
            if (this.curDoc != null) {
                XTextFramesSupplier xTextFrameSupplier = (XTextFramesSupplier)UnoRuntime.queryInterface(XTextFramesSupplier.class, (Object)this.curDoc);
                XNameAccess xNamedFrames = xTextFrameSupplier.getTextFrames();
                for (String name : xNamedFrames.getElementNames()) {
                    Object o = xNamedFrames.getByName(name);
                    XText xFrameText = (XText)UnoRuntime.queryInterface(XText.class, (Object)o);
                    num += DocumentCursorTools.getNumberOfAllParagraphsOfText(xFrameText);
                }
            }
            int n = num;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = 0;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentText getTextOfAllShapes(boolean withDeleted) {
        ++isBusy;
        try {
            ArrayList<String> sText = new ArrayList<String>();
            HashMap<Integer, Integer> headingNumbers = new HashMap<Integer, Integer>();
            List<Integer> sortedTextIds = null;
            ArrayList<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
            XDrawPageSupplier xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.curDoc);
            if (xDrawPageSupplier == null) {
                MessageHandler.printToLogFile("XDrawPageSupplier == null");
                DocumentText documentText = new DocumentText(sText, headingNumbers, new ArrayList<Integer>(), sortedTextIds, deletedCharacters);
                return documentText;
            }
            XDrawPage xDrawPage = xDrawPageSupplier.getDrawPage();
            if (xDrawPage == null) {
                MessageHandler.printToLogFile("XDrawPage == null");
                DocumentText documentText = new DocumentText(sText, headingNumbers, new ArrayList<Integer>(), sortedTextIds, deletedCharacters);
                return documentText;
            }
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
            int nShapes = xShapes.getCount();
            for (int j = 0; j < nShapes; ++j) {
                XText xShapeText;
                Object oShape = xShapes.getByIndex(j);
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                if (xShape == null || (xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape)) == null) continue;
                sortedTextIds = this.addAllParagraphsOfText(xShapeText, sText, deletedCharacters, sortedTextIds, withDeleted);
                headingNumbers.put(sText.size(), 0);
            }
            DocumentText documentText = new DocumentText(sText, headingNumbers, new ArrayList<Integer>(), sortedTextIds, deletedCharacters);
            return documentText;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            DocumentText documentText = null;
            return documentText;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTextOfShapes(List<Integer> nPara) {
        ++isBusy;
        try {
            ArrayList<String> sText = new ArrayList<String>();
            XDrawPageSupplier xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.curDoc);
            if (xDrawPageSupplier == null) {
                MessageHandler.printToLogFile("XDrawPageSupplier == null");
                ArrayList<String> arrayList = sText;
                return arrayList;
            }
            XDrawPage xDrawPage = xDrawPageSupplier.getDrawPage();
            if (xDrawPage == null) {
                MessageHandler.printToLogFile("XDrawPage == null");
                ArrayList<String> arrayList = sText;
                return arrayList;
            }
            XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
            int nShapes = xShapes.getCount();
            int num = 0;
            for (int j = 0; j < nShapes; ++j) {
                XText xShapeText;
                Object oShape = xShapes.getByIndex(j);
                XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                if (xShape == null || (xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape)) == null) continue;
                List<String> tmpText = this.getAllParagraphsOfText(xShapeText);
                for (String text : tmpText) {
                    if (nPara.contains(num)) {
                        sText.add(text);
                    }
                    ++num;
                }
            }
            ArrayList<String> arrayList = sText;
            return arrayList;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            List<String> list = null;
            return list;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAllShapes() {
        ++isBusy;
        try {
            int num = 0;
            if (this.curDoc != null) {
                XDrawPageSupplier xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.curDoc);
                if (xDrawPageSupplier == null) {
                    MessageHandler.printToLogFile("XDrawPageSupplier == null");
                    int n = 0;
                    return n;
                }
                XDrawPage xDrawPage = xDrawPageSupplier.getDrawPage();
                if (xDrawPage == null) {
                    MessageHandler.printToLogFile("XDrawPage == null");
                    int n = 0;
                    return n;
                }
                XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
                int nShapes = xShapes.getCount();
                for (int j = 0; j < nShapes; ++j) {
                    XText xShapeText;
                    Object oShape = xShapes.getByIndex(j);
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                    if (xShape == null || (xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape)) == null) continue;
                    num += DocumentCursorTools.getNumberOfAllParagraphsOfText(xShapeText);
                }
            }
            int n = num;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = 0;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    private XIndexAccess getIndexAccessOfAllTables() {
        try {
            if (this.curDoc == null) {
                return null;
            }
            XTextTablesSupplier xTableSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)this.curDoc);
            return (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xTableSupplier.getTextTables());
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentText getTextOfAllTables(boolean withDeleted) {
        ++isBusy;
        try {
            ArrayList<String> sText = new ArrayList<String>();
            HashMap<Integer, Integer> headingNumbers = new HashMap<Integer, Integer>();
            List<Integer> sortedTextIds = null;
            XIndexAccess xTables = this.getIndexAccessOfAllTables();
            ArrayList<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
            if (xTables != null) {
                for (int i = 0; i < xTables.getCount(); ++i) {
                    XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                    for (String cellName : xTable.getCellNames()) {
                        XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                        headingNumbers.put(sText.size(), 0);
                        sortedTextIds = this.addAllParagraphsOfText(xTableText, sText, deletedCharacters, sortedTextIds, withDeleted);
                    }
                }
            }
            DocumentText documentText = new DocumentText(sText, headingNumbers, new ArrayList<Integer>(), sortedTextIds, deletedCharacters);
            return documentText;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            DocumentText documentText = null;
            return documentText;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTextOfTables(List<Integer> nPara) {
        ++isBusy;
        try {
            ArrayList<String> sText = new ArrayList<String>();
            XIndexAccess xTables = this.getIndexAccessOfAllTables();
            if (xTables != null) {
                int num = 0;
                for (int i = 0; i < xTables.getCount(); ++i) {
                    XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                    for (String cellName : xTable.getCellNames()) {
                        XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                        List<String> tmpText = this.getAllParagraphsOfText(xTableText);
                        for (String text : tmpText) {
                            if (nPara.contains(num)) {
                                sText.add(text);
                            }
                            ++num;
                        }
                    }
                }
            }
            ArrayList<String> arrayList = sText;
            return arrayList;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            List<String> list = null;
            return list;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAllTables() {
        ++isBusy;
        try {
            int num = 0;
            XIndexAccess xTables = this.getIndexAccessOfAllTables();
            if (xTables != null) {
                for (int i = 0; i < xTables.getCount(); ++i) {
                    XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                    for (String cellName : xTable.getCellNames()) {
                        XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                        num += DocumentCursorTools.getNumberOfAllParagraphsOfText(xTableText);
                    }
                }
            }
            int n = num;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = 0;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentText getTextOfAllFootnotes(boolean withDeleted) {
        ArrayList<String> sText = new ArrayList<String>();
        HashMap<Integer, Integer> headingNumbers = new HashMap<Integer, Integer>();
        List<Integer> sortedTextIds = null;
        ArrayList<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
        ++isBusy;
        try {
            Object xFootnoteSupplier;
            if (this.curDoc != null) {
                xFootnoteSupplier = (XFootnotesSupplier)UnoRuntime.queryInterface(XFootnotesSupplier.class, (Object)this.curDoc);
                XIndexAccess xFootnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xFootnoteSupplier.getFootnotes());
                for (int i = 0; i < xFootnotes.getCount(); ++i) {
                    XFootnote xFootnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xFootnotes.getByIndex(i));
                    XText xFootnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xFootnote);
                    headingNumbers.put(sText.size(), 0);
                    sortedTextIds = this.addAllParagraphsOfText(xFootnoteText, sText, deletedCharacters, sortedTextIds, withDeleted);
                }
            }
            xFootnoteSupplier = new DocumentText(sText, headingNumbers, new ArrayList<Integer>(), sortedTextIds, deletedCharacters);
            return xFootnoteSupplier;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            DocumentText documentText = null;
            return documentText;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAllFootnotes() {
        ++isBusy;
        try {
            int num = 0;
            if (this.curDoc != null) {
                XFootnotesSupplier xFootnoteSupplier = (XFootnotesSupplier)UnoRuntime.queryInterface(XFootnotesSupplier.class, (Object)this.curDoc);
                XIndexAccess xFootnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xFootnoteSupplier.getFootnotes());
                for (int i = 0; i < xFootnotes.getCount(); ++i) {
                    XFootnote xFootnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xFootnotes.getByIndex(i));
                    XText xFootnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xFootnote);
                    num += DocumentCursorTools.getNumberOfAllParagraphsOfText(xFootnoteText);
                }
            }
            int n = num;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = 0;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentText getTextOfAllEndnotes(boolean withDeleted) {
        ArrayList<String> sText = new ArrayList<String>();
        HashMap<Integer, Integer> headingNumbers = new HashMap<Integer, Integer>();
        List<Integer> sortedTextIds = null;
        ArrayList<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
        ++isBusy;
        try {
            Object xEndnoteSupplier;
            if (this.curDoc != null) {
                xEndnoteSupplier = (XEndnotesSupplier)UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)this.curDoc);
                XIndexAccess xEndnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xEndnoteSupplier.getEndnotes());
                for (int i = 0; i < xEndnotes.getCount(); ++i) {
                    XFootnote xEndnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xEndnotes.getByIndex(i));
                    XText xFootnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xEndnote);
                    headingNumbers.put(sText.size(), 0);
                    sortedTextIds = this.addAllParagraphsOfText(xFootnoteText, sText, deletedCharacters, sortedTextIds, withDeleted);
                }
            }
            xEndnoteSupplier = new DocumentText(sText, headingNumbers, new ArrayList<Integer>(), sortedTextIds, deletedCharacters);
            return xEndnoteSupplier;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            DocumentText documentText = null;
            return documentText;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAllEndnotes() {
        ++isBusy;
        try {
            int num = 0;
            if (this.curDoc != null) {
                XEndnotesSupplier xEndnoteSupplier = (XEndnotesSupplier)UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)this.curDoc);
                XIndexAccess xEndnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xEndnoteSupplier.getEndnotes());
                for (int i = 0; i < xEndnotes.getCount(); ++i) {
                    XFootnote xEndnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xEndnotes.getByIndex(i));
                    XText xFootnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xEndnote);
                    num += DocumentCursorTools.getNumberOfAllParagraphsOfText(xFootnoteText);
                }
            }
            int n = num;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = 0;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    private List<XPropertySet> getPagePropertySets() {
        try {
            ArrayList<XPropertySet> propertySets = new ArrayList<XPropertySet>();
            if (this.curDoc == null) {
                return null;
            }
            XStyleFamiliesSupplier xSupplier = (XStyleFamiliesSupplier)UnoRuntime.queryInterface(XStyleFamiliesSupplier.class, (Object)this.curDoc);
            XNameAccess xNameAccess = xSupplier.getStyleFamilies();
            if (xNameAccess == null) {
                return null;
            }
            XNameContainer pageStyleCon = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)xNameAccess.getByName("PageStyles"));
            if (pageStyleCon == null) {
                return null;
            }
            for (String name : pageStyleCon.getElementNames()) {
                XPropertySet xPageStandardProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)pageStyleCon.getByName(name));
                if (xPageStandardProps == null) continue;
                propertySets.add((XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPageStandardProps));
            }
            return propertySets;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentText getTextOfAllHeadersAndFooters(boolean withDeleted) {
        ++isBusy;
        try {
            ArrayList<String> sText = new ArrayList<String>();
            HashMap<Integer, Integer> headingNumbers = new HashMap<Integer, Integer>();
            List<Integer> sortedTextIds = null;
            ArrayList<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
            List<XPropertySet> xPagePropertySets = this.getPagePropertySets();
            if (xPagePropertySets != null) {
                for (XPropertySet xPagePropertySet : xPagePropertySets) {
                    if (xPagePropertySet == null) continue;
                    boolean headerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsOn"));
                    boolean firstIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FirstIsShared"));
                    boolean headerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsShared"));
                    boolean footerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsOn"));
                    boolean footerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsShared"));
                    for (int i = 0; i < HeaderFooterTypes.length; ++i) {
                        XText xHeaderText;
                        if (!(headerIsOn && (i == 0 && headerIsShared || (i == 1 || i == 2) && !headerIsShared || i == 3 && !firstIsShared)) && (!footerIsOn || (i != 4 || !footerIsShared) && (i != 5 && i != 6 || footerIsShared) && (i != 7 || firstIsShared)) || (xHeaderText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPagePropertySet.getPropertyValue(HeaderFooterTypes[i]))) == null || xHeaderText.getString().isEmpty()) continue;
                        if (!headingNumbers.containsKey(sText.size())) {
                            headingNumbers.put(sText.size(), 0);
                        }
                        sortedTextIds = this.addAllParagraphsOfText(xHeaderText, sText, deletedCharacters, sortedTextIds, withDeleted);
                    }
                }
            }
            DocumentText documentText = new DocumentText(sText, headingNumbers, new ArrayList<Integer>(), sortedTextIds, deletedCharacters);
            return documentText;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            DocumentText documentText = null;
            return documentText;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfAllHeadersAndFooters() {
        ++isBusy;
        try {
            int num = 0;
            List<XPropertySet> xPagePropertySets = this.getPagePropertySets();
            if (xPagePropertySets != null) {
                for (XPropertySet xPagePropertySet : xPagePropertySets) {
                    if (xPagePropertySet == null) continue;
                    boolean headerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsOn"));
                    boolean firstIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FirstIsShared"));
                    boolean headerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("HeaderIsShared"));
                    boolean footerIsOn = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsOn"));
                    boolean footerIsShared = OfficeTools.getBooleanValue(xPagePropertySet.getPropertyValue("FooterIsShared"));
                    for (int i = 0; i < HeaderFooterTypes.length; ++i) {
                        XText xHeaderText;
                        if (!(headerIsOn && (i == 0 && headerIsShared || (i == 1 || i == 2) && !headerIsShared || i == 3 && !firstIsShared)) && (!footerIsOn || (i != 4 || !footerIsShared) && (i != 5 && i != 6 || footerIsShared) && (i != 7 || firstIsShared)) || (xHeaderText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPagePropertySet.getPropertyValue(HeaderFooterTypes[i]))) == null || xHeaderText.getString().isEmpty()) continue;
                        num += DocumentCursorTools.getNumberOfAllParagraphsOfText(xHeaderText);
                    }
                }
            }
            int n = num;
            return n;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            int n = 0;
            return n;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XParagraphCursor getParagraphCursor(DocumentCache.TextParagraph textPara) {
        ++isBusy;
        try {
            XDrawPage xDrawPage;
            XDrawPageSupplier xDrawPageSupplier;
            int nPara;
            int type = textPara.type;
            int number = textPara.number;
            if (type == -1) {
                XParagraphCursor xParagraphCursor = null;
                return xParagraphCursor;
            }
            if (type == 4) {
                if (this.xPCursor == null) {
                    XParagraphCursor xParagraphCursor = null;
                    return xParagraphCursor;
                }
                this.xPCursor.gotoStart(false);
                for (nPara = 0; nPara < number && this.xPCursor.gotoNextParagraph(false); ++nPara) {
                }
                XParagraphCursor xParagraphCursor = this.xPCursor;
                return xParagraphCursor;
            }
            if (type == 5) {
                XTextTablesSupplier xTableSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)this.curDoc);
                XIndexAccess xTables = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xTableSupplier.getTextTables());
                if (xTables != null) {
                    for (int i = 0; i < xTables.getCount(); ++i) {
                        XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                        for (String cellName : xTable.getCellNames()) {
                            XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                            XTextCursor xTextCursor = xTableText.createTextCursor();
                            XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                            xParagraphCursor.gotoStart(false);
                            while (nPara < number && xParagraphCursor.gotoNextParagraph(false)) {
                                ++nPara;
                            }
                            if (nPara == number) {
                                XParagraphCursor xParagraphCursor2 = xParagraphCursor;
                                return xParagraphCursor2;
                            }
                            ++nPara;
                        }
                    }
                }
            } else if (type == 1) {
                XFootnotesSupplier xFootnoteSupplier = (XFootnotesSupplier)UnoRuntime.queryInterface(XFootnotesSupplier.class, (Object)this.curDoc);
                XIndexAccess xFootnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xFootnoteSupplier.getFootnotes());
                if (xFootnotes != null) {
                    for (int i = 0; i < xFootnotes.getCount(); ++i) {
                        XFootnote XFootnote2 = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xFootnotes.getByIndex(i));
                        XText xFootnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)XFootnote2);
                        XTextCursor xTextCursor = xFootnoteText.createTextCursor();
                        XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                        xParagraphCursor.gotoStart(false);
                        while (nPara < number && xParagraphCursor.gotoNextParagraph(false)) {
                            ++nPara;
                        }
                        if (nPara == number) {
                            XParagraphCursor cellName = xParagraphCursor;
                            return cellName;
                        }
                        ++nPara;
                    }
                }
            } else if (type == 0) {
                XEndnotesSupplier xEndnotesSupplier = (XEndnotesSupplier)UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)this.curDoc);
                XIndexAccess xEndnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xEndnotesSupplier.getEndnotes());
                if (xEndnotes != null) {
                    for (int i = 0; i < xEndnotes.getCount(); ++i) {
                        XFootnote xEndnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xEndnotes.getByIndex(i));
                        XText xEndnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xEndnote);
                        XTextCursor xTextCursor = xEndnoteText.createTextCursor();
                        XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                        xParagraphCursor.gotoStart(false);
                        while (nPara < number && xParagraphCursor.gotoNextParagraph(false)) {
                            ++nPara;
                        }
                        if (nPara == number) {
                            XParagraphCursor cellName = xParagraphCursor;
                            return cellName;
                        }
                        ++nPara;
                    }
                }
            } else if (type == 2) {
                List<XPropertySet> xPagePropertySets = this.getPagePropertySets();
                Object lastHeaderText = null;
                for (XPropertySet xPagePropertySet : xPagePropertySets) {
                    if (xPagePropertySet == null) continue;
                    for (String headerFooter : HeaderFooterTypes) {
                        XText xHeaderText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPagePropertySet.getPropertyValue(headerFooter));
                        if (xHeaderText == null || xHeaderText.getString().isEmpty() || lastHeaderText != null && lastHeaderText.equals(xHeaderText)) continue;
                        XTextCursor xTextCursor = xHeaderText.createTextCursor();
                        XParagraphCursor xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                        xParagraphCursor.gotoStart(false);
                        while (nPara < number && xParagraphCursor.gotoNextParagraph(false)) {
                            ++nPara;
                        }
                        if (nPara == number) {
                            XParagraphCursor xParagraphCursor3 = xParagraphCursor;
                            return xParagraphCursor3;
                        }
                        ++nPara;
                        lastHeaderText = xHeaderText;
                    }
                }
            } else if (type == 3 && (xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.curDoc)) != null && (xDrawPage = xDrawPageSupplier.getDrawPage()) != null) {
                XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
                int nShapes = xShapes.getCount();
                for (int j = 0; j < nShapes; ++j) {
                    XTextCursor xTextCursor;
                    XParagraphCursor xParagraphCursor;
                    XText xShapeText;
                    Object oShape = xShapes.getByIndex(j);
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                    if (xShape == null || (xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape)) == null || (xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)(xTextCursor = xShapeText.createTextCursor()))) == null) continue;
                    xParagraphCursor.gotoStart(false);
                    while (nPara < number && xParagraphCursor.gotoNextParagraph(false)) {
                        ++nPara;
                    }
                    if (nPara == number) {
                        XParagraphCursor xParagraphCursor4 = xParagraphCursor;
                        return xParagraphCursor4;
                    }
                    ++nPara;
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMarks(List<DocumentCache.TextParagraph> textParas) {
        ++isBusy;
        try {
            int n;
            ArrayList paras = new ArrayList();
            for (n = 0; n < 6; ++n) {
                paras.add(new ArrayList());
            }
            for (int i = 0; i < textParas.size(); ++i) {
                int type = textParas.get((int)i).type;
                if (type < 0 || type >= 6) continue;
                ((List)paras.get(type)).add(textParas.get((int)i).number);
            }
            for (n = 0; n < 6; ++n) {
                if (((List)paras.get(n)).isEmpty()) continue;
                ((List)paras.get(n)).sort(null);
            }
            block8: for (int type = 0; type < 6; ++type) {
                XDrawPage xDrawPage;
                XDrawPageSupplier xDrawPageSupplier;
                XMarkingAccess xMarkingAccess;
                XMarkingAccess xMarkingAccess2;
                XParagraphCursor xParagraphCursor;
                XTextCursor xTextCursor;
                int number;
                if (((List)paras.get(type)).size() <= 0) continue;
                int nPara = 0;
                if (type == 4) {
                    if (this.xPCursor == null) {
                        break;
                    }
                    this.xPCursor.gotoStart(false);
                    for (int i = 0; i < ((List)paras.get(type)).size(); ++i) {
                        int number2 = (Integer)((List)paras.get(type)).get(i);
                        while (nPara < number2 && this.xPCursor.gotoNextParagraph(false)) {
                            ++nPara;
                        }
                        if (this.xPCursor == null) continue;
                        XMarkingAccess xMarkingAccess3 = (XMarkingAccess)UnoRuntime.queryInterface(XMarkingAccess.class, (Object)this.xPCursor);
                        if (xMarkingAccess3 == null) {
                            MessageHandler.printToLogFile("FlatParagraphTools: addMarksToOneParagraph: xMarkingAccess == null");
                            continue;
                        }
                        xMarkingAccess3.invalidateMarkings(2);
                    }
                    continue;
                }
                if (type == 5) {
                    XTextTablesSupplier xTableSupplier = (XTextTablesSupplier)UnoRuntime.queryInterface(XTextTablesSupplier.class, (Object)this.curDoc);
                    XIndexAccess xTables = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xTableSupplier.getTextTables());
                    if (xTables == null) continue;
                    int j = 0;
                    number = (Integer)((List)paras.get(type)).get(j);
                    block11: for (int i = 0; i < xTables.getCount() && j < ((List)paras.get(type)).size(); ++i) {
                        XTextTable xTable = (XTextTable)UnoRuntime.queryInterface(XTextTable.class, (Object)xTables.getByIndex(i));
                        for (String cellName : xTable.getCellNames()) {
                            XText xTableText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xTable.getCellByName(cellName));
                            xTextCursor = xTableText.createTextCursor();
                            xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                            xParagraphCursor.gotoStart(false);
                            do {
                                if (nPara == number) {
                                    xMarkingAccess2 = (XMarkingAccess)UnoRuntime.queryInterface(XMarkingAccess.class, (Object)xParagraphCursor);
                                    if (xMarkingAccess2 == null) {
                                        MessageHandler.printToLogFile("FlatParagraphTools: addMarksToOneParagraph: xMarkingAccess == null");
                                    } else {
                                        xMarkingAccess2.invalidateMarkings(2);
                                    }
                                    if (++j < ((List)paras.get(type)).size()) {
                                        number = (Integer)((List)paras.get(type)).get(j);
                                    }
                                }
                                ++nPara;
                            } while (j < ((List)paras.get(type)).size() && xParagraphCursor.gotoNextParagraph(false));
                            if (j == ((List)paras.get(type)).size()) continue block11;
                        }
                    }
                    continue;
                }
                if (type == 1) {
                    XFootnotesSupplier xFootnoteSupplier = (XFootnotesSupplier)UnoRuntime.queryInterface(XFootnotesSupplier.class, (Object)this.curDoc);
                    XIndexAccess xFootnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xFootnoteSupplier.getFootnotes());
                    if (xFootnotes == null) continue;
                    int j = 0;
                    number = (Integer)((List)paras.get(type)).get(j);
                    for (int i = 0; i < xFootnotes.getCount() && j < ((List)paras.get(type)).size(); ++i) {
                        XFootnote XFootnote2 = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xFootnotes.getByIndex(i));
                        XText xFootnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)XFootnote2);
                        XTextCursor xTextCursor2 = xFootnoteText.createTextCursor();
                        XParagraphCursor xParagraphCursor2 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor2);
                        xParagraphCursor2.gotoStart(false);
                        do {
                            if (nPara == number) {
                                xMarkingAccess = (XMarkingAccess)UnoRuntime.queryInterface(XMarkingAccess.class, (Object)xParagraphCursor2);
                                if (xMarkingAccess == null) {
                                    MessageHandler.printToLogFile("FlatParagraphTools: addMarksToOneParagraph: xMarkingAccess == null");
                                } else {
                                    xMarkingAccess.invalidateMarkings(2);
                                }
                                if (++j < ((List)paras.get(type)).size()) {
                                    number = (Integer)((List)paras.get(type)).get(j);
                                }
                            }
                            ++nPara;
                        } while (j < ((List)paras.get(type)).size() && xParagraphCursor2.gotoNextParagraph(false));
                    }
                    continue;
                }
                if (type == 0) {
                    XEndnotesSupplier xEndnotesSupplier = (XEndnotesSupplier)UnoRuntime.queryInterface(XEndnotesSupplier.class, (Object)this.curDoc);
                    XIndexAccess xEndnotes = (XIndexAccess)UnoRuntime.queryInterface(XIndexAccess.class, (Object)xEndnotesSupplier.getEndnotes());
                    if (xEndnotes == null) continue;
                    int j = 0;
                    number = (Integer)((List)paras.get(type)).get(j);
                    for (int i = 0; i < xEndnotes.getCount() && j < ((List)paras.get(type)).size(); ++i) {
                        XFootnote xEndnote = (XFootnote)UnoRuntime.queryInterface(XFootnote.class, (Object)xEndnotes.getByIndex(i));
                        XText xEndnoteText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xEndnote);
                        XTextCursor xTextCursor3 = xEndnoteText.createTextCursor();
                        XParagraphCursor xParagraphCursor3 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor3);
                        xParagraphCursor3.gotoStart(false);
                        do {
                            if (nPara == number) {
                                xMarkingAccess = (XMarkingAccess)UnoRuntime.queryInterface(XMarkingAccess.class, (Object)xParagraphCursor3);
                                if (xMarkingAccess == null) {
                                    MessageHandler.printToLogFile("FlatParagraphTools: addMarksToOneParagraph: xMarkingAccess == null");
                                } else {
                                    xMarkingAccess.invalidateMarkings(2);
                                }
                                if (++j < ((List)paras.get(type)).size()) {
                                    number = (Integer)((List)paras.get(type)).get(j);
                                }
                            }
                            ++nPara;
                        } while (j < ((List)paras.get(type)).size() && xParagraphCursor3.gotoNextParagraph(false));
                    }
                    continue;
                }
                if (type == 2) {
                    List<XPropertySet> xPagePropertySets = this.getPagePropertySets();
                    Object lastHeaderText = null;
                    int j = 0;
                    number = (Integer)((List)paras.get(type)).get(j);
                    for (XPropertySet xPagePropertySet : xPagePropertySets) {
                        if (xPagePropertySet != null) {
                            for (String headerFooter : HeaderFooterTypes) {
                                XText xHeaderText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xPagePropertySet.getPropertyValue(headerFooter));
                                if (!(xHeaderText == null || xHeaderText.getString().isEmpty() || lastHeaderText != null && lastHeaderText.equals(xHeaderText))) {
                                    xTextCursor = xHeaderText.createTextCursor();
                                    xParagraphCursor = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)xTextCursor);
                                    xParagraphCursor.gotoStart(false);
                                    do {
                                        if (nPara == number) {
                                            xMarkingAccess2 = (XMarkingAccess)UnoRuntime.queryInterface(XMarkingAccess.class, (Object)xParagraphCursor);
                                            if (xMarkingAccess2 == null) {
                                                MessageHandler.printToLogFile("FlatParagraphTools: addMarksToOneParagraph: xMarkingAccess == null");
                                            } else {
                                                xMarkingAccess2.invalidateMarkings(2);
                                            }
                                            if (++j < ((List)paras.get(type)).size()) {
                                                number = (Integer)((List)paras.get(type)).get(j);
                                            }
                                        }
                                        ++nPara;
                                    } while (j < ((List)paras.get(type)).size() && xParagraphCursor.gotoNextParagraph(false));
                                    lastHeaderText = xHeaderText;
                                }
                                if (j == ((List)paras.get(type)).size()) break;
                            }
                        }
                        if (j != ((List)paras.get(type)).size()) continue;
                        continue block8;
                    }
                    continue;
                }
                if (type != 3 || (xDrawPageSupplier = (XDrawPageSupplier)UnoRuntime.queryInterface(XDrawPageSupplier.class, (Object)this.curDoc)) == null || (xDrawPage = xDrawPageSupplier.getDrawPage()) == null) continue;
                XShapes xShapes = (XShapes)UnoRuntime.queryInterface(XShapes.class, (Object)xDrawPage);
                int nShapes = xShapes.getCount();
                int j = 0;
                int number3 = (Integer)((List)paras.get(type)).get(j);
                for (int i = 0; i < nShapes && j < ((List)paras.get(type)).size(); ++i) {
                    XTextCursor xTextCursor4;
                    XParagraphCursor xParagraphCursor4;
                    XText xShapeText;
                    Object oShape = xShapes.getByIndex(i);
                    XShape xShape = (XShape)UnoRuntime.queryInterface(XShape.class, (Object)oShape);
                    if (xShape == null || (xShapeText = (XText)UnoRuntime.queryInterface(XText.class, (Object)xShape)) == null || (xParagraphCursor4 = (XParagraphCursor)UnoRuntime.queryInterface(XParagraphCursor.class, (Object)(xTextCursor4 = xShapeText.createTextCursor()))) == null) continue;
                    xParagraphCursor4.gotoStart(false);
                    do {
                        if (nPara == number3) {
                            XMarkingAccess xMarkingAccess4 = (XMarkingAccess)UnoRuntime.queryInterface(XMarkingAccess.class, (Object)xParagraphCursor4);
                            if (xMarkingAccess4 == null) {
                                MessageHandler.printToLogFile("FlatParagraphTools: addMarksToOneParagraph: xMarkingAccess == null");
                            } else {
                                xMarkingAccess4.invalidateMarkings(2);
                            }
                            if (++j < ((List)paras.get(type)).size()) {
                                number3 = (Integer)((List)paras.get(type)).get(j);
                            }
                        }
                        ++nPara;
                    } while (j < ((List)paras.get(type)).size() && xParagraphCursor4.gotoNextParagraph(false));
                }
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getDeletedCharactersOfTextParagraph(DocumentCache.TextParagraph textPara, boolean withDeleted) {
        ++isBusy;
        try {
            if (!withDeleted) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                return arrayList;
            }
            XParagraphCursor xPCursor = this.getParagraphCursor(textPara);
            if (xPCursor == null) {
                List<Integer> list = null;
                return list;
            }
            xPCursor.gotoStartOfParagraph(false);
            xPCursor.gotoEndOfParagraph(true);
            List<Integer> list = DocumentCursorTools.getDeletedCharacters(xPCursor, withDeleted);
            return list;
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
            List<Integer> list = null;
            return list;
        }
        finally {
            --isBusy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProtectedCharacter(DocumentCache.TextParagraph textPara, short x) {
        ++isBusy;
        try {
            XParagraphCursor xPCursor = this.getParagraphCursor(textPara);
            if (xPCursor == null) {
                boolean bl = false;
                return bl;
            }
            xPCursor.gotoStartOfParagraph(false);
            xPCursor.goRight(x, false);
            XPropertySet xParagraphPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xPCursor.getStart());
            XTextSection xTextSection = (XTextSection)UnoRuntime.queryInterface(XTextSection.class, (Object)xParagraphPropertySet.getPropertyValue("TextSection"));
            xParagraphPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xTextSection);
            if (xParagraphPropertySet != null && ((Boolean)xParagraphPropertySet.getPropertyValue("IsProtected")).booleanValue()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        finally {
            --isBusy;
        }
        return false;
    }

    public static boolean isBusy() {
        return isBusy > 0;
    }

    public static void reset() {
        isBusy = 0;
    }

    public static class DocumentText {
        List<String> paragraphs;
        Map<Integer, Integer> headingNumbers;
        List<Integer> automaticTextParagraphs;
        List<Integer> sortedTextIds;
        List<List<Integer>> deletedCharacters;

        DocumentText() {
            this.paragraphs = new ArrayList<String>();
            this.headingNumbers = new HashMap<Integer, Integer>();
            this.automaticTextParagraphs = new ArrayList<Integer>();
            this.sortedTextIds = null;
            this.deletedCharacters = new ArrayList<List<Integer>>();
        }

        DocumentText(List<String> paragraphs, Map<Integer, Integer> headingNumbers, List<Integer> automaticTextParagraphs, List<Integer> sortedTextIds, List<List<Integer>> deletedCharacters) {
            this.paragraphs = paragraphs;
            this.headingNumbers = headingNumbers;
            this.automaticTextParagraphs = automaticTextParagraphs;
            this.sortedTextIds = sortedTextIds;
            this.deletedCharacters = deletedCharacters;
        }
    }
}

