/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.linguistic2.SingleProofreadingError;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.openoffice.DocumentCursorTools;
import org.languagetool.openoffice.FlatParagraphTools;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeDrawTools;
import org.languagetool.openoffice.OfficeSpreadsheetTools;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.ResultCache;
import org.languagetool.openoffice.SingleCheck;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.SwJLanguageTool;

public class DocumentCache
implements Serializable {
    private static final long serialVersionUID = 13L;
    public static final int CURSOR_TYPE_UNKNOWN = -1;
    public static final int CURSOR_TYPE_ENDNOTE = 0;
    public static final int CURSOR_TYPE_FOOTNOTE = 1;
    public static final int CURSOR_TYPE_HEADER_FOOTER = 2;
    public static final int CURSOR_TYPE_SHAPE = 3;
    public static final int CURSOR_TYPE_TEXT = 4;
    public static final int CURSOR_TYPE_TABLE = 5;
    public static final int NUMBER_CURSOR_TYPES = 6;
    private static final int MAX_NOTE_CHAR = 7;
    private static final int MAX_PRINTED_PARAS = 3;
    private static boolean debugMode;
    private static boolean debugModeTm;
    private final List<String> paragraphs = new ArrayList<String>();
    private final List<List<Integer>> chapterBegins = new ArrayList<List<Integer>>();
    private final List<Integer> automaticParagraphs = new ArrayList<Integer>();
    private final List<SerialLocale> locales = new ArrayList<SerialLocale>();
    private final List<int[]> footnotes = new ArrayList<int[]>();
    private final List<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
    private final List<TextParagraph> toTextMapping = new ArrayList<TextParagraph>();
    protected final List<List<Integer>> toParaMapping = new ArrayList<List<Integer>>();
    private final OfficeTools.DocumentType docType;
    private final Map<Integer, List<AnalyzedSentence>> analyzedParagraphs = new HashMap<Integer, List<AnalyzedSentence>>();
    private List<Integer> sortedTextIds = null;
    private Map<Integer, Integer> headingMap;
    private boolean isReset = false;
    private boolean isDirty = false;
    private int documentElementsCount = -1;
    private int nEndnote = 0;
    private int nFootnote = 0;
    private int nHeaderFooter = 0;
    private int nShape = 0;
    private int nText = 0;
    private int nTable = 0;
    private SerialLocale docLocale;
    private ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    DocumentCache(OfficeTools.DocumentType docType) {
        debugMode = OfficeTools.DEBUG_MODE_DC;
        debugModeTm = OfficeTools.DEBUG_MODE_TM;
        this.docType = docType;
    }

    DocumentCache(SingleDocument document, Locale fixedLocale, Locale docLocale, XComponent xComponent, OfficeTools.DocumentType docType) {
        debugMode = OfficeTools.DEBUG_MODE_DC;
        debugModeTm = OfficeTools.DEBUG_MODE_TM;
        this.docType = docType;
        this.refresh(document, fixedLocale, docLocale, xComponent, 0);
    }

    DocumentCache(DocumentCache in) {
        this.rwLock.writeLock().lock();
        in.rwLock.readLock().lock();
        try {
            this.isReset = true;
            debugMode = OfficeTools.DEBUG_MODE_DC;
            debugModeTm = OfficeTools.DEBUG_MODE_TM;
            if (in.paragraphs != null && in.paragraphs.size() > 0) {
                this.add(in);
            }
            this.docType = in.docType;
            this.docLocale = this.getMostUsedLanguage(this.locales);
        }
        finally {
            this.isReset = false;
            in.rwLock.readLock().unlock();
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setForTest(List<String> paragraphs, List<List<String>> textParagraphs, List<int[]> footnotes, List<List<Integer>> chapterBegins, Locale locale) {
        this.rwLock.writeLock().lock();
        try {
            int i;
            this.isReset = true;
            debugMode = OfficeTools.DEBUG_MODE_DC;
            debugModeTm = OfficeTools.DEBUG_MODE_TM;
            this.clearAnalyzedParagraphs();
            this.paragraphs.addAll(paragraphs);
            this.footnotes.addAll(footnotes);
            this.chapterBegins.addAll(chapterBegins);
            for (i = 0; i < paragraphs.size(); ++i) {
                this.locales.add(new SerialLocale(locale));
            }
            for (i = 0; i < 6; ++i) {
                this.toParaMapping.add(new ArrayList());
            }
            this.nText = textParagraphs.get(4).size();
            this.nTable = textParagraphs.get(5).size();
            this.nShape = textParagraphs.get(3).size();
            this.nFootnote = textParagraphs.get(1).size();
            this.nEndnote = textParagraphs.get(0).size();
            this.nHeaderFooter = textParagraphs.get(2).size();
            this.docLocale = new SerialLocale(locale);
            this.mapParagraphs(this.paragraphs, this.toTextMapping, this.toParaMapping, this.chapterBegins, this.locales, footnotes, textParagraphs, this.deletedCharacters, null);
        }
        finally {
            this.isReset = false;
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(SingleDocument document, Locale fixedLocale, Locale docLocale, XComponent xComponent, int fromWhere) {
        if (this.isReset) {
            MessageHandler.printToLogFile("DocumentCache:refresh: isReset == true: return");
            return;
        }
        this.isReset = true;
        try {
            if (debugMode) {
                MessageHandler.printToLogFile("DocumentCache: refresh: Called from: " + fromWhere);
            }
            this.clearAnalyzedParagraphs();
            if (this.docType != OfficeTools.DocumentType.WRITER) {
                this.refreshImpressCalcCache(xComponent);
            } else {
                this.refreshWriterCache(document, fixedLocale, docLocale, fromWhere);
            }
            this.setSingleParagraphsCacheToNull(document.getParagraphsCache());
        }
        finally {
            this.isReset = false;
        }
    }

    private void refreshWriterCache(SingleDocument document, Locale fixedLocale, Locale docLocale, int fromWhere) {
        int i;
        long startTime = System.currentTimeMillis();
        FlatParagraphTools flatPara = document.getFlatParagraphTools();
        ArrayList<String> paragraphs = new ArrayList<String>();
        ArrayList<List<Integer>> chapterBegins = new ArrayList<List<Integer>>();
        ArrayList<List<Integer>> deletedCharacters = new ArrayList<List<Integer>>();
        ArrayList<SerialLocale> locales = new ArrayList<SerialLocale>();
        ArrayList<int[]> footnotes = new ArrayList<int[]>();
        ArrayList<TextParagraph> toTextMapping = new ArrayList<TextParagraph>();
        ArrayList<List<Integer>> toParaMapping = new ArrayList<List<Integer>>();
        this.clear();
        boolean withDeleted = document.getMultiDocumentsHandler().getConfiguration().includeTrackedChanges();
        for (int i2 = 0; i2 < 6; ++i2) {
            toParaMapping.add(new ArrayList());
        }
        ArrayList<DocumentCursorTools.DocumentText> documentTexts = new ArrayList<DocumentCursorTools.DocumentText>();
        for (int i3 = 0; i3 < 6; ++i3) {
            documentTexts.add(null);
        }
        DocumentCursorTools docCursor = document.getDocumentCursorTools();
        if (docCursor == null) {
            MessageHandler.printToLogFile("DocumentCache: refreshWriterCache: docCursor == null: return");
            return;
        }
        documentTexts.set(4, docCursor.getAllTextParagraphs(withDeleted));
        documentTexts.set(5, docCursor.getTextOfAllTables(withDeleted));
        documentTexts.set(3, docCursor.getTextOfAllShapes(withDeleted));
        documentTexts.set(1, docCursor.getTextOfAllFootnotes(withDeleted));
        documentTexts.set(0, docCursor.getTextOfAllEndnotes(withDeleted));
        documentTexts.set(2, docCursor.getTextOfAllHeadersAndFooters(withDeleted));
        for (i = 0; i < 6; ++i) {
            if (documentTexts.get(i) != null) continue;
            documentTexts.set(i, new DocumentCursorTools.DocumentText());
        }
        this.nText = ((DocumentCursorTools.DocumentText)documentTexts.get((int)4)).paragraphs.size();
        this.nTable = ((DocumentCursorTools.DocumentText)documentTexts.get((int)5)).paragraphs.size();
        this.nShape = ((DocumentCursorTools.DocumentText)documentTexts.get((int)3)).paragraphs.size();
        this.nFootnote = ((DocumentCursorTools.DocumentText)documentTexts.get((int)1)).paragraphs.size();
        this.nEndnote = ((DocumentCursorTools.DocumentText)documentTexts.get((int)0)).paragraphs.size();
        this.nHeaderFooter = ((DocumentCursorTools.DocumentText)documentTexts.get((int)2)).paragraphs.size();
        if (debugMode) {
            for (i = 0; i < 6; ++i) {
                if (documentTexts.get(i) == null) {
                    MessageHandler.printToLogFile("DocumentCache: refresh: CursorType: " + i + "; Document Text is Null!");
                    continue;
                }
                MessageHandler.printToLogFile("DocumentCache: refresh: CursorType: " + i + "; Number of paragraphs: " + ((DocumentCursorTools.DocumentText)documentTexts.get((int)i)).paragraphs.size());
            }
        }
        FlatParagraphTools.FlatParagraphContainer paragraphContainer = null;
        ArrayList<List<List<Integer>>> deletedChars = new ArrayList<List<List<Integer>>>();
        for (DocumentCursorTools.DocumentText documentText : documentTexts) {
            ArrayList<Integer> hNumbers = new ArrayList<Integer>();
            for (int n : documentText.headingNumbers.keySet()) {
                hNumbers.add(n);
            }
            hNumbers.sort(null);
            chapterBegins.add(hNumbers);
            deletedChars.add(documentText.deletedCharacters);
        }
        this.headingMap = ((DocumentCursorTools.DocumentText)documentTexts.get((int)4)).headingNumbers;
        if (flatPara == null) {
            flatPara = document.getFlatParagraphTools();
        }
        if (flatPara == null) {
            MessageHandler.printToLogFile("WARNING: DocumentCache: refresh: flatPara == null - ParagraphCache not initialised");
            return;
        }
        paragraphContainer = flatPara.getAllFlatParagraphs(fixedLocale);
        if (paragraphContainer == null) {
            MessageHandler.printToLogFile("WARNING: DocumentCache: refresh: paragraphContainer == null - ParagraphCache not initialised");
            return;
        }
        if (paragraphContainer.paragraphs == null) {
            MessageHandler.printToLogFile("WARNING: DocumentCache: refresh: paragraphs in paragraphContainer == null - ParagraphCache not initialised");
            return;
        }
        paragraphs.addAll(paragraphContainer.paragraphs);
        for (Locale locale : paragraphContainer.locales) {
            locales.add(new SerialLocale(locale));
        }
        footnotes.addAll(paragraphContainer.footnotePositions);
        List<Integer> sortedTextIds = paragraphContainer.sortedTextIds;
        if (debugMode) {
            int unknown = 0;
            for (DocumentCursorTools.DocumentText documentText : documentTexts) {
                if (documentText == null || documentText.paragraphs == null) continue;
                unknown += documentText.paragraphs.size();
            }
            unknown = paragraphs.size() - unknown;
            MessageHandler.printToLogFile("DocumentCache: refresh: unknown paragraphs: " + unknown);
            if (sortedTextIds == null) {
                MessageHandler.printToLogFile("DocumentCache: refresh: paragraphContainer.sortedTextIds == null");
            } else {
                for (DocumentCursorTools.DocumentText documentText : documentTexts) {
                    if (documentText == null || documentText.sortedTextIds == null) continue;
                    for (int n : documentText.sortedTextIds) {
                        if (sortedTextIds.contains(n)) continue;
                        MessageHandler.printToLogFile("DocumentCache: refresh: sortedTextId not in flatparagraph: " + n);
                    }
                }
                Iterator<Object> iterator = sortedTextIds.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    boolean found = false;
                    for (DocumentCursorTools.DocumentText documentText : documentTexts) {
                        if (documentText == null || documentText.sortedTextIds == null || !documentText.sortedTextIds.contains(n)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    MessageHandler.printToLogFile("DocumentCache: refresh: sortedTextId not in documentText: " + n);
                }
            }
        }
        if (sortedTextIds == null) {
            ArrayList<List<String>> textParas = new ArrayList<List<String>>();
            for (DocumentCursorTools.DocumentText documentText : documentTexts) {
                textParas.add(documentText.paragraphs);
            }
            this.mapParagraphs(paragraphs, toTextMapping, toParaMapping, chapterBegins, locales, footnotes, textParas, deletedCharacters, deletedChars);
        } else {
            this.documentElementsCount = paragraphContainer.documentElementsCount;
            ArrayList<List<Integer>> textSortedTextIds = new ArrayList<List<Integer>>();
            for (DocumentCursorTools.DocumentText documentText : documentTexts) {
                textSortedTextIds.add(documentText.sortedTextIds);
            }
            this.mapParagraphsWNI(paragraphs, toTextMapping, toParaMapping, chapterBegins, locales, footnotes, textSortedTextIds, sortedTextIds, deletedCharacters, deletedChars);
        }
        this.actualizeCache(paragraphs, chapterBegins, locales, footnotes, toTextMapping, toParaMapping, deletedCharacters, ((DocumentCursorTools.DocumentText)documentTexts.get((int)4)).automaticTextParagraphs, sortedTextIds);
        document.getMultiDocumentsHandler().runShapeCheck(this.hasUnsupportedText(), fromWhere);
        if (debugModeTm) {
            long endTime = System.currentTimeMillis();
            MessageHandler.printToLogFile("Time to generate cache(" + fromWhere + "): " + (endTime - startTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void actualizeCache(List<String> paragraphs, List<List<Integer>> chapterBegins, List<SerialLocale> locales, List<int[]> footnotes, List<TextParagraph> toTextMapping, List<List<Integer>> toParaMapping, List<List<Integer>> deletedCharacters, List<Integer> automaticParagraphs, List<Integer> sortedTextIds) {
        this.rwLock.writeLock().lock();
        try {
            this.clearAnalyzedParagraphs();
            this.paragraphs.clear();
            this.paragraphs.addAll(paragraphs);
            this.chapterBegins.clear();
            this.chapterBegins.addAll(chapterBegins);
            this.locales.clear();
            this.locales.addAll(locales);
            this.footnotes.clear();
            this.footnotes.addAll(footnotes);
            this.toTextMapping.clear();
            this.toTextMapping.addAll(toTextMapping);
            this.toParaMapping.addAll(toParaMapping);
            this.deletedCharacters.clear();
            this.deletedCharacters.addAll(deletedCharacters);
            this.automaticParagraphs.addAll(automaticParagraphs);
            if (sortedTextIds != null) {
                if (this.sortedTextIds == null) {
                    this.sortedTextIds = new ArrayList<Integer>();
                } else {
                    this.sortedTextIds.clear();
                }
                this.sortedTextIds.addAll(sortedTextIds);
            }
            this.docLocale = this.getMostUsedLanguage(locales);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private static boolean isEqualTextWithoutZeroSpace(String flatPara, String textPara) {
        if (flatPara.isEmpty() && textPara.isEmpty()) {
            return true;
        }
        flatPara = DocumentCache.removeZeroWidthSpace(flatPara);
        textPara = DocumentCache.removeZeroWidthSpace(textPara);
        if (flatPara.isEmpty() && textPara.isEmpty()) {
            return true;
        }
        if (flatPara.length() != textPara.length()) {
            return false;
        }
        return flatPara.equals(textPara);
    }

    public boolean hasUnsupportedText() {
        if (this.toParaMapping.get(3).size() > 0) {
            return true;
        }
        boolean hasUnsupported = false;
        for (TextParagraph tPara : this.toTextMapping) {
            if (tPara.type == 4) break;
            if (tPara.type != 5) continue;
            hasUnsupported = true;
            break;
        }
        return hasUnsupported;
    }

    public static boolean isEqualText(String flatPara, String textPara, int[] footnotes) {
        int tParaBeg;
        String tPara;
        String fPara;
        if (footnotes == null || footnotes.length == 0) {
            return DocumentCache.isEqualTextWithoutZeroSpace(flatPara, textPara);
        }
        if (footnotes[footnotes.length - 1] >= flatPara.length()) {
            MessageHandler.printToLogFile("DocumentCache: isEqualWithoutFootnotes: footnotes[footnotes.length - 1] >= flatPara.length()");
            return false;
        }
        textPara = DocumentCache.removeZeroWidthSpace(textPara);
        if (footnotes[0] > 0) {
            fPara = flatPara.substring(0, footnotes[0]);
            if (!(fPara = DocumentCache.removeZeroWidthSpace(fPara)).isEmpty()) {
                if (textPara.length() < fPara.length()) {
                    return false;
                }
                tPara = textPara.substring(0, fPara.length());
                if (!tPara.equals(fPara)) {
                    return false;
                }
            }
        }
        if (footnotes[footnotes.length - 1] < flatPara.length() - 1) {
            fPara = flatPara.substring(footnotes[footnotes.length - 1] + 1);
            if (!(fPara = DocumentCache.removeZeroWidthSpace(fPara)).isEmpty()) {
                tParaBeg = textPara.length() - fPara.length();
                if (tParaBeg < 0) {
                    return false;
                }
                tPara = textPara.substring(tParaBeg);
                if (!tPara.equals(fPara)) {
                    return false;
                }
            } else {
                tParaBeg = textPara.length() - 1;
            }
        } else {
            tParaBeg = textPara.length() - 1;
        }
        for (int i = footnotes.length - 2; i >= 0; --i) {
            flatPara = flatPara.substring(0, footnotes[i + 1]);
            textPara = textPara.substring(0, tParaBeg);
            fPara = flatPara.substring(footnotes[i] + 1);
            fPara = DocumentCache.removeZeroWidthSpace(fPara);
            tParaBeg = textPara.length() - fPara.length();
            boolean isEqual = false;
            for (int j = 0; j <= 7 && !isEqual && tParaBeg - j >= 0; ++j) {
                tPara = textPara.substring(tParaBeg - j, textPara.length() - j);
                isEqual = tPara.equals(fPara);
                if (!isEqual) continue;
                tParaBeg -= j;
            }
            if (isEqual) continue;
            return false;
        }
        return true;
    }

    List<Locale> getDifferentLocalesOftext(List<Locale> locales) {
        ArrayList<Locale> differentLocales = new ArrayList<Locale>();
        for (Locale locale : locales) {
            if (locale.Variant.startsWith("99-")) {
                locale = new Locale(locale.Language, locale.Country, locale.Variant.substring("99-".length()));
            }
            boolean isInList = false;
            for (Locale difLoc : differentLocales) {
                if (!OfficeTools.isEqualLocale(locale, difLoc)) continue;
                isInList = true;
                break;
            }
            if (isInList) continue;
            differentLocales.add(locale);
        }
        return differentLocales;
    }

    private static int[] getFootnotes(List<int[]> footnotes, int i) {
        return footnotes != null && i < footnotes.size() ? footnotes.get(i) : null;
    }

    private void correctNegativeNumberEntries(int type, List<List<String>> textParas, List<String> paragraphs, List<List<Integer>> toParaMapping, List<TextParagraph> toTextMapping) {
        int j;
        boolean isRemoved = false;
        for (j = textParas.get(type).size() - 1; j >= 0; --j) {
            if (toParaMapping.get(type).get(j) >= 0) continue;
            boolean isMapped = false;
            for (int i = 0; i < toTextMapping.size() && !isMapped; ++i) {
                if (toTextMapping.get((int)i).type != -1 || !DocumentCache.isEqualText(paragraphs.get(i), textParas.get(type).get(j), DocumentCache.getFootnotes(this.footnotes, i))) continue;
                toParaMapping.get(type).set(j, i);
                toTextMapping.set(i, new TextParagraph(type, j));
                isMapped = true;
            }
            if (isMapped) continue;
            toParaMapping.get(type).remove(j);
            isRemoved = true;
        }
        if (isRemoved) {
            for (j = 0; j < toParaMapping.get(type).size(); ++j) {
                int i = toParaMapping.get(type).get(j);
                if (toTextMapping.get((int)i).number == j) continue;
                toTextMapping.set(i, new TextParagraph(type, j));
            }
        }
    }

    void correctParaMapping(int type, List<List<Integer>> toParaMapping) {
        if (type != 4) {
            for (int i = toParaMapping.get(type).size() - 1; i >= 0; --i) {
                if (toParaMapping.get(type).get(i) >= 0) continue;
                toParaMapping.get(type).remove(i);
            }
        }
    }

    private boolean mapTextParagraphsPerLoop(int type, int nFlat, List<String> paragraphs, List<int[]> footnotes, List<List<String>> textParas, List<TextParagraph> toTextMapping, List<List<Integer>> toParaMapping, List<List<Integer>> nMapped, List<Integer> nNext) {
        if (nMapped.get(type).size() < textParas.get(type).size()) {
            int k;
            for (k = nNext.get(type).intValue(); k < textParas.get(type).size(); ++k) {
                if (nMapped.get(type).contains(k) || !DocumentCache.isEqualText(paragraphs.get(nFlat), textParas.get(type).get(k), DocumentCache.getFootnotes(footnotes, nFlat))) continue;
                toTextMapping.add(new TextParagraph(type, k));
                toParaMapping.get(type).set(k, nFlat);
                nMapped.get(type).add(k);
                nNext.set(type, k < textParas.get(type).size() - 1 ? k + 1 : 0);
                return true;
            }
            for (k = 0; k < nNext.get(type); ++k) {
                if (nMapped.get(type).contains(k) || !DocumentCache.isEqualText(paragraphs.get(nFlat), textParas.get(type).get(k), DocumentCache.getFootnotes(footnotes, nFlat))) continue;
                toTextMapping.add(new TextParagraph(type, k));
                toParaMapping.get(type).set(k, nFlat);
                nMapped.get(type).add(k);
                nNext.set(type, k < textParas.get(type).size() - 1 ? k + 1 : 0);
                return true;
            }
        }
        return false;
    }

    private void mapParagraphs(List<String> paragraphs, List<TextParagraph> toTextMapping, List<List<Integer>> toParaMapping, List<List<Integer>> chapterBegins, List<SerialLocale> locales, List<int[]> footnotes, List<List<String>> textParas, List<List<Integer>> deletedCharacters, List<List<List<Integer>>> deletedChars) {
        if (textParas != null && !textParas.isEmpty()) {
            int i;
            ArrayList<List<Integer>> nMapped = new ArrayList<List<Integer>>();
            ArrayList<Integer> nNext = new ArrayList<Integer>();
            for (int i2 = 0; i2 < textParas.size(); ++i2) {
                nMapped.add(new ArrayList());
                nNext.add(0);
            }
            int nUnknown = 0;
            for (int i3 = 0; i3 < 6; ++i3) {
                nUnknown += textParas.get(i3).size();
            }
            nUnknown = paragraphs.size() - nUnknown;
            int printCount = 0;
            if (debugMode) {
                MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Unknown paragraphs: " + nUnknown);
            }
            for (int j = 0; j < 6; ++j) {
                if (j == 4) continue;
                for (int i4 = 0; i4 < textParas.get(j).size(); ++i4) {
                    toParaMapping.get(j).add(-1);
                }
            }
            if (debugMode) {
                for (int i5 = 0; i5 < 6; ++i5) {
                    for (int j = 0; j < textParas.get(i5).size(); ++j) {
                        MessageHandler.printToLogFile("DocumentCache: mapParagraphs: type: " + i5 + "; text: " + textParas.get(i5).get(j));
                    }
                }
            }
            int numUnknown = 0;
            boolean thirdTextDone = false;
            for (int i6 = 0; i6 < paragraphs.size(); ++i6) {
                int k;
                int n;
                boolean secondTextDone;
                boolean isMapped = false;
                boolean firstTextDone = ((List)nMapped.get(0)).size() == textParas.get(0).size() && ((List)nMapped.get(1)).size() == textParas.get(1).size();
                boolean bl = secondTextDone = firstTextDone && ((List)nMapped.get(3)).size() == textParas.get(3).size() && ((List)nMapped.get(2)).size() == textParas.get(2).size();
                if (!firstTextDone) {
                    for (n = 0; n < 2; ++n) {
                        if (!this.mapTextParagraphsPerLoop(n, i6, paragraphs, footnotes, textParas, toTextMapping, toParaMapping, nMapped, nNext)) continue;
                        isMapped = true;
                        break;
                    }
                    if (isMapped) continue;
                }
                if (!secondTextDone && firstTextDone) {
                    for (n = 2; n < 4; ++n) {
                        if (!this.mapTextParagraphsPerLoop(n, i6, paragraphs, footnotes, textParas, toTextMapping, toParaMapping, nMapped, nNext)) continue;
                        isMapped = true;
                        break;
                    }
                    if (isMapped) continue;
                }
                if (!(secondTextDone && thirdTextDone || !firstTextDone || ((List)nMapped.get(5)).size() >= textParas.get(5).size() || secondTextDone && !textParas.get(4).isEmpty() && DocumentCache.isEqualText(paragraphs.get(i6), textParas.get(4).get(0), DocumentCache.getFootnotes(footnotes, i6)))) {
                    if (this.mapTextParagraphsPerLoop(5, i6, paragraphs, footnotes, textParas, toTextMapping, toParaMapping, nMapped, nNext)) continue;
                    if (secondTextDone) {
                        nNext.set(5, 0);
                        thirdTextDone = true;
                    }
                }
                if (!secondTextDone) {
                    toTextMapping.add(new TextParagraph(-1, -1));
                    ++numUnknown;
                    if (!debugMode) continue;
                    MessageHandler.printToLogFile("WARNING: DocumentCache: Could not map Paragraph(" + i6 + "): '" + paragraphs.get(i6) + "'; secondTextDone: " + secondTextDone);
                    String msg = "DocumentCache: mapParagraphs:\n";
                    for (int k2 = 0; k2 < 6; ++k2) {
                        msg = k2 == 4 ? msg + "Actual Cursor Paragraph (Type " + k2 + "): " + ((Integer)nNext.get(k2) < textParas.get(k2).size() ? textParas.get(k2).get((Integer)nNext.get(k2)) : "no paragraph left") + "\n" : msg + "Actual Cursor Paragraph (Type " + k2 + "): " + (((List)nMapped.get(k2)).size() < textParas.get(k2).size() ? textParas.get(k2).get((Integer)nNext.get(k2)) : "no paragraph left") + "\n";
                    }
                    MessageHandler.printToLogFile(msg);
                    MessageHandler.printToLogFile("Unknown Paragraphs: " + (numUnknown - 1) + " from " + nUnknown);
                    continue;
                }
                int j = (Integer)nNext.get(4);
                if (j == textParas.get(4).size() && ((List)nMapped.get(5)).size() == textParas.get(5).size()) {
                    toTextMapping.add(new TextParagraph(-1, -1));
                    ++numUnknown;
                    if (!debugMode || paragraphs.get(i6).isEmpty() || printCount >= 3) continue;
                    ++printCount;
                    MessageHandler.printToLogFile("Warning: DocumentCache: Could not map Paragraph(" + i6 + "): '" + paragraphs.get(i6) + "'; secondTextDone: " + secondTextDone);
                    continue;
                }
                if (((List)nMapped.get(5)).size() == textParas.get(5).size() && numUnknown >= nUnknown) {
                    toTextMapping.add(new TextParagraph(4, j));
                    toParaMapping.get(4).add(i6);
                    nNext.set(4, j + 1);
                    continue;
                }
                if (j == textParas.get(4).size() && numUnknown >= nUnknown) {
                    int k3;
                    for (k3 = ((Integer)nNext.get(5)).intValue(); k3 < textParas.get(5).size() && !((List)nMapped.get(5)).contains(k3); ++k3) {
                    }
                    if (k3 == textParas.get(5).size()) {
                        for (k3 = 0; k3 < (Integer)nNext.get(5) && !((List)nMapped.get(5)).contains(k3); ++k3) {
                        }
                    }
                    ((List)nMapped.get(5)).add(k3);
                    nNext.set(5, k3 + 1);
                    toTextMapping.add(new TextParagraph(5, k3));
                    toParaMapping.get(5).set(k3, i6);
                    continue;
                }
                for (k = ((Integer)nNext.get(5)).intValue(); k < textParas.get(5).size() && ((List)nMapped.get(5)).contains(k); ++k) {
                }
                if (k < textParas.get(5).size() && DocumentCache.isEqualText(paragraphs.get(i6), textParas.get(5).get(k), DocumentCache.getFootnotes(footnotes, i6))) {
                    boolean equalTable = true;
                    boolean equalText = j < textParas.get(4).size() && DocumentCache.isEqualText(paragraphs.get(i6), textParas.get(4).get(j), DocumentCache.getFootnotes(footnotes, i6));
                    int mk = k;
                    int mj = j;
                    int mi = i6;
                    while (equalTable && equalText && mi < paragraphs.size() - 1) {
                        equalTable = ++mk < textParas.get(5).size() && !((List)nMapped.get(5)).contains(mk) ? DocumentCache.isEqualText(paragraphs.get(++mi), textParas.get(5).get(mk), DocumentCache.getFootnotes(footnotes, mi)) : false;
                        if (++mj < textParas.get(4).size()) {
                            equalText = DocumentCache.isEqualText(paragraphs.get(mi), textParas.get(4).get(mj), DocumentCache.getFootnotes(footnotes, mi));
                            continue;
                        }
                        equalText = false;
                    }
                    if (!equalText) {
                        ((List)nMapped.get(5)).add(k);
                        nNext.set(5, k + 1);
                        toTextMapping.add(new TextParagraph(5, k));
                        toParaMapping.get(5).set(k, i6);
                        continue;
                    }
                    isMapped = true;
                }
                if (!isMapped && j < textParas.get(4).size() && DocumentCache.isEqualText(paragraphs.get(i6), textParas.get(4).get(j), DocumentCache.getFootnotes(footnotes, i6))) {
                    isMapped = true;
                }
                if (isMapped) {
                    toTextMapping.add(new TextParagraph(4, j));
                    toParaMapping.get(4).add(i6);
                    nNext.set(4, j + 1);
                    continue;
                }
                toTextMapping.add(new TextParagraph(-1, -1));
                ++numUnknown;
                if (debugMode && !paragraphs.get(i6).isEmpty() && printCount < 3) {
                    ++printCount;
                    MessageHandler.printToLogFile("Warning: DocumentCache: Could not map Paragraph(" + i6 + "): '" + paragraphs.get(i6) + "'; secondTextDone: " + secondTextDone);
                }
                if (!debugMode) continue;
                if ((Integer)nNext.get(5) >= textParas.get(5).size()) {
                    nNext.set(5, 0);
                }
                String msg = "DocumentCache: mapParagraphs:\n";
                for (int k4 = 0; k4 < 6; ++k4) {
                    msg = k4 == 4 ? msg + "Actual Cursor Paragraph (Type " + k4 + "): " + ((Integer)nNext.get(k4) < textParas.get(k4).size() ? textParas.get(k4).get((Integer)nNext.get(k4)) : "no paragraph left") + "\n" : msg + "Actual Cursor Paragraph (Type " + k4 + "): " + (((List)nMapped.get(k4)).size() < textParas.get(k4).size() ? textParas.get(k4).get((Integer)nNext.get(k4)) : "no paragraph left") + "\n";
                }
                MessageHandler.printToLogFile(msg);
                MessageHandler.printToLogFile("Unknown Paragraphs: " + (numUnknown - 1) + " from " + nUnknown);
            }
            boolean isCorrectNonText = true;
            boolean isCorrectMapping = true;
            int nMap = 0;
            for (i = 0; i < 6; ++i) {
                if (i == 4) continue;
                nMap += ((List)nMapped.get(i)).size();
            }
            if ((nMap += toParaMapping.get(4).size()) == paragraphs.size()) {
                for (i = 0; i < 6; ++i) {
                    this.correctParaMapping(i, toParaMapping);
                }
            } else {
                boolean bl = isCorrectNonText = ((List)nMapped.get(0)).size() == textParas.get(0).size() && ((List)nMapped.get(1)).size() == textParas.get(1).size() && ((List)nMapped.get(3)).size() == textParas.get(3).size() && ((List)nMapped.get(2)).size() == textParas.get(2).size() && ((List)nMapped.get(5)).size() == textParas.get(5).size();
                if (!isCorrectNonText) {
                    for (int k = 0; k < 6; ++k) {
                        if (k == 4 || ((List)nMapped.get(k)).size() >= textParas.get(k).size()) continue;
                        MessageHandler.printToLogFile("Warning: document cache mapping failed: Try to repair mapping of paragraph type " + k);
                        this.correctNegativeNumberEntries(k, textParas, paragraphs, toParaMapping, toTextMapping);
                    }
                    isCorrectNonText = toParaMapping.get(0).size() == textParas.get(0).size() && toParaMapping.get(1).size() == textParas.get(1).size() && toParaMapping.get(3).size() == textParas.get(3).size() && toParaMapping.get(2).size() == textParas.get(2).size() && toParaMapping.get(5).size() == textParas.get(5).size();
                }
                boolean bl2 = isCorrectMapping = isCorrectNonText && toParaMapping.get(4).size() == textParas.get(4).size();
                if (!isCorrectMapping && isCorrectNonText) {
                    MessageHandler.printToLogFile("\nWarning: document cache mapping failed: Try to repair mapping of paragraph type text");
                    printCount = 0;
                    toParaMapping.get(4).clear();
                    for (i = 0; i < paragraphs.size(); ++i) {
                        if (toTextMapping.get((int)i).type != 4) continue;
                        toTextMapping.set(i, new TextParagraph(-1, -1));
                    }
                    boolean allmapped = true;
                    for (int j = 0; j < textParas.get(4).size(); ++j) {
                        boolean ismapped = false;
                        for (int i7 = 0; i7 < paragraphs.size() && !ismapped; ++i7) {
                            if (toTextMapping.get((int)i7).type != -1 || !DocumentCache.isEqualText(paragraphs.get(i7), textParas.get(4).get(j), DocumentCache.getFootnotes(footnotes, i7))) continue;
                            toTextMapping.set(i7, new TextParagraph(4, j));
                            toParaMapping.get(4).add(i7);
                            ismapped = true;
                        }
                        if (ismapped) continue;
                        allmapped = false;
                        if (!debugMode && printCount >= 3) continue;
                        ++printCount;
                        MessageHandler.printToLogFile("Warning: Could not map text paragraph: " + textParas.get(4).get(j));
                    }
                    if (!allmapped) {
                        MessageHandler.printToLogFile("Warning: unknow non empty paragraphs (max. 3 printed):");
                        printCount = 0;
                        for (int i8 = 0; i8 < paragraphs.size() && printCount < 3; ++i8) {
                            if (toTextMapping.get((int)i8).type != -1 || paragraphs.get(i8).isEmpty()) continue;
                            ++printCount;
                            MessageHandler.printToLogFile(i8 + ": " + paragraphs.get(i8));
                            for (int j = 0; j < paragraphs.get(i8).length(); ++j) {
                                if (Character.isLetterOrDigit(paragraphs.get(i8).codePointAt(j)) || paragraphs.get(i8).charAt(j) == ' ' || paragraphs.get(i8).charAt(j) == '\t') continue;
                                MessageHandler.printToLogFile("CharAt(" + j + "): " + paragraphs.get(i8).codePointAt(j));
                            }
                        }
                    }
                }
                boolean bl3 = isCorrectMapping = isCorrectNonText && toParaMapping.get(4).size() == textParas.get(4).size();
            }
            if (!isCorrectMapping) {
                numUnknown = 0;
                for (i = 0; i < 6; ++i) {
                    numUnknown += toParaMapping.get(i).size();
                }
                numUnknown = paragraphs.size() - numUnknown;
                String msg = "An error has occurred in LanguageTool " + JLanguageTool.VERSION + " (" + JLanguageTool.BUILD_DATE + "):\nDocument cache mapping failed:\nParagraphs:\nEndnotes: " + toParaMapping.get(0).size() + " / " + textParas.get(0).size() + "\nFootnotes: " + toParaMapping.get(1).size() + " / " + textParas.get(1).size() + "\nHeaders/Footers: " + toParaMapping.get(2).size() + " / " + textParas.get(2).size() + "\nShapes: " + toParaMapping.get(3).size() + " / " + textParas.get(3).size() + "\nTables: " + toParaMapping.get(5).size() + " / " + textParas.get(5).size() + "\nText: " + toParaMapping.get(4).size() + " / " + textParas.get(4).size() + "\nUnknown: " + numUnknown + " / " + nUnknown;
                MessageHandler.printToLogFile(msg);
            }
            this.nText = toParaMapping.get(4).size();
            this.nTable = toParaMapping.get(5).size();
            this.nShape = toParaMapping.get(3).size();
            this.nFootnote = toParaMapping.get(1).size();
            this.nEndnote = toParaMapping.get(0).size();
            this.nHeaderFooter = toParaMapping.get(2).size();
            this.mapDeletedCharacters(deletedCharacters, paragraphs, deletedChars, toTextMapping);
            this.prepareChapterBeginsForText(chapterBegins, toTextMapping, locales);
            if (debugMode) {
                int n;
                MessageHandler.printToLogFile("\nDocumentCache: mapParagraphs: toParaMapping:");
                for (n = 0; n < 6; ++n) {
                    MessageHandler.printToLogFile("Cursor Type: " + n);
                    for (int i9 = 0; i9 < toParaMapping.get(n).size(); ++i9) {
                        MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Doc: " + i9 + " Flat: " + toParaMapping.get(n).get(i9));
                    }
                }
                MessageHandler.printToLogFile("\nDocumentCache: mapParagraphs: toTextMapping:");
                for (int i10 = 0; i10 < toTextMapping.size(); ++i10) {
                    MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Flat: " + i10 + " Doc: " + toTextMapping.get((int)i10).number + " Type: " + toTextMapping.get((int)i10).type + "; locale: " + locales.get((int)i10).Language + "-" + locales.get((int)i10).Country + "; Deleted Chars size: " + (deletedCharacters.get(i10) == null ? "null" : Integer.valueOf(deletedCharacters.get(i10).size())) + "; '" + paragraphs.get(i10) + "'");
                }
                MessageHandler.printToLogFile("\nDocumentCache: mapParagraphs: headings:");
                for (n = 0; n < 6; ++n) {
                    MessageHandler.printToLogFile("\nDocumentCache: mapParagraphs: Cursor Type: " + n);
                    for (int i11 = 0; i11 < chapterBegins.get(n).size(); ++i11) {
                        MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Num: " + i11 + " Heading: " + chapterBegins.get(n).get(i11));
                    }
                }
                MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of Flat Paragraphs: " + paragraphs.size());
                MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of Text Paragraphs: " + toParaMapping.get(4).size());
                MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of footnotes: " + footnotes.size());
                MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of locales: " + locales.size());
                MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of Deleted Chars: " + deletedCharacters.size());
            }
        }
    }

    private void mapParagraphsWNI(List<String> paragraphs, List<TextParagraph> toTextMapping, List<List<Integer>> toParaMapping, List<List<Integer>> chapterBegins, List<SerialLocale> locales, List<int[]> footnotes, List<List<Integer>> textSortedTextIds, List<Integer> sortedTextIds, List<List<Integer>> deletedCharacters, List<List<List<Integer>>> deletedChars) {
        int j;
        int i;
        this.isDirty = false;
        ArrayList<Integer> nMapped = new ArrayList<Integer>();
        int nUnknown = 0;
        for (i = 0; i < 6; ++i) {
            nMapped.add(0);
            if (textSortedTextIds.get(i) == null) {
                textSortedTextIds.set(i, new ArrayList());
                if (debugMode) {
                    MessageHandler.printToLogFile("Document cache: mapParagraphsWNI: Empty textSortedTextIds for type: " + i);
                }
            }
            nUnknown += textSortedTextIds.get(i).size();
            for (j = 0; j < textSortedTextIds.get(i).size(); ++j) {
                toParaMapping.get(i).add(-1);
            }
        }
        nUnknown = sortedTextIds.size() - nUnknown;
        if (nUnknown < 0) {
            this.isDirty = true;
            if (debugMode) {
                MessageHandler.printToLogFile("WARNING cache is dirty (map on basis of node index); unknown paragraphs:" + nUnknown);
            }
        }
        if (debugMode) {
            for (i = 0; i < 6; ++i) {
                MessageHandler.printToLogFile("\nDocument cache: mapParagraphsWNI: node indexes for type: " + i);
                for (j = 0; j < textSortedTextIds.get(i).size(); ++j) {
                    MessageHandler.printToLogFile("Document cache: mapParagraphsWNI: node index: " + textSortedTextIds.get(i).get(j));
                }
            }
            MessageHandler.printToLogFile("\nDocument cache: mapParagraphsWNI: unknown paragraphs: " + nUnknown);
            MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of Flat Paragraphs: " + paragraphs.size());
            MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of Text Paragraphs: " + toParaMapping.get(4).size());
            MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of footnotes: " + footnotes.size());
            MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of locales: " + locales.size());
            MessageHandler.printToLogFile("DocumentCache: mapParagraphs: Number of Deleted Chars: " + deletedCharacters.size());
        }
        int notMapped = 0;
        for (int n = 0; n < sortedTextIds.size(); ++n) {
            boolean found = false;
            for (int i2 = 0; !found && i2 < 6; ++i2) {
                List<Integer> txtNdIndexes = textSortedTextIds.get(i2);
                for (int j2 = 0; !found && j2 < txtNdIndexes.size(); ++j2) {
                    if (txtNdIndexes.get(j2).intValue() != sortedTextIds.get(n).intValue()) continue;
                    found = true;
                    toParaMapping.get(i2).set(j2, n);
                    toTextMapping.add(new TextParagraph(i2, j2));
                }
            }
            if (found) continue;
            toTextMapping.add(new TextParagraph(-1, -1));
            ++notMapped;
            if (!debugMode) continue;
            MessageHandler.printToLogFile("Document cache: mapParagraphsWNI: Not found node: " + sortedTextIds.get(n));
        }
        if (notMapped > 0 && notMapped != nUnknown && debugMode) {
            MessageHandler.printToLogFile("WARNING not mapped paragraphs (map on basis of node index); notmapped known paragraphs: " + (notMapped - nUnknown) + "; unknown paragraphs: " + nUnknown);
        }
        if (this.isDirty) {
            for (int i3 = 0; i3 < 6; ++i3) {
                for (int j3 = toParaMapping.get(i3).size() - 1; j3 >= 0; --j3) {
                    if (toParaMapping.get(i3).get(j3) >= 0) continue;
                    toParaMapping.get(i3).remove(j3);
                }
            }
            this.nText = toParaMapping.get(4).size();
            this.nTable = toParaMapping.get(5).size();
            this.nShape = toParaMapping.get(3).size();
            this.nFootnote = toParaMapping.get(1).size();
            this.nEndnote = toParaMapping.get(0).size();
            this.nHeaderFooter = toParaMapping.get(2).size();
        }
        this.mapDeletedCharacters(deletedCharacters, paragraphs, deletedChars, toTextMapping);
        this.prepareChapterBeginsForText(chapterBegins, toTextMapping, locales);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshImpressCalcCache(XComponent xComponent) {
        this.rwLock.writeLock().lock();
        try {
            int i;
            OfficeDrawTools.ParagraphContainer container;
            this.isDirty = false;
            if (this.docType == OfficeTools.DocumentType.IMPRESS) {
                container = OfficeDrawTools.getAllParagraphs(xComponent);
            } else if (this.docType == OfficeTools.DocumentType.CALC) {
                container = OfficeSpreadsheetTools.getAllParagraphs(xComponent);
            } else {
                return;
            }
            this.clear();
            this.paragraphs.addAll(container.paragraphs);
            for (int i2 = 0; i2 < 5; ++i2) {
                this.chapterBegins.add(new ArrayList());
            }
            this.chapterBegins.get(4).addAll(container.pageBegins);
            for (Locale locale : container.locales) {
                this.locales.add(new SerialLocale(locale));
            }
            for (i = 0; i < 6; ++i) {
                this.toParaMapping.add(new ArrayList());
            }
            for (i = 0; i < this.paragraphs.size(); ++i) {
                this.toTextMapping.add(new TextParagraph(4, i));
                this.toParaMapping.get(4).add(i);
                this.footnotes.add(new int[0]);
                this.deletedCharacters.add(null);
            }
            this.nText = this.toParaMapping.get(4).size();
            this.nTable = this.toParaMapping.get(5).size();
            this.nShape = this.toParaMapping.get(3).size();
            this.nFootnote = this.toParaMapping.get(1).size();
            this.nEndnote = this.toParaMapping.get(0).size();
            this.nHeaderFooter = this.toParaMapping.get(2).size();
            this.docLocale = this.getMostUsedLanguage(this.locales);
            if (debugMode) {
                MessageHandler.printToLogFile("DocumentCache: reset: isImpress: Number of paragraphse: " + this.paragraphs.size());
                for (i = 0; i < 6; ++i) {
                    MessageHandler.printToLogFile("DocumentCache: reset: CursorType: " + i + "; Number of paragraphs: " + this.toParaMapping.get(i).size());
                }
            }
        }
        catch (Throwable t) {
            this.isDirty = true;
            MessageHandler.showError(t);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void setSingleParagraphsCacheToNull(List<ResultCache> paragraphsCache) {
        for (int i = 0; i < this.paragraphs.size(); ++i) {
            if (!this.isSingleParagraph_intern(i)) continue;
            for (int n = 1; n < paragraphsCache.size(); ++n) {
                paragraphsCache.get(n).put(i, new SingleProofreadingError[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setSingleParagraphsCacheToNull(int numberFlatParagraph, List<ResultCache> paragraphsCache) {
        this.rwLock.readLock().lock();
        try {
            if (this.isSingleParagraph_intern(numberFlatParagraph)) {
                for (int n = 1; n < paragraphsCache.size(); ++n) {
                    paragraphsCache.get(n).put(numberFlatParagraph, new SingleProofreadingError[0]);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean isResetRunning() {
        return this.isReset;
    }

    public boolean isFinished() {
        while (this.isReset) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                MessageHandler.showError(e);
                return false;
            }
        }
        return this.paragraphs != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFlatParagraph(int n) {
        this.rwLock.readLock().lock();
        try {
            String para;
            String string = para = n < 0 || n >= this.paragraphs.size() ? null : this.paragraphs.get(n);
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setFlatParagraph(int n, String sPara) {
        this.rwLock.writeLock().lock();
        try {
            this.removeAnalyzedParagraph(n);
            if (n >= 0 && n < this.paragraphs.size()) {
                this.paragraphs.set(n, sPara);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlatParagraph(int n, String sPara, Locale locale) {
        this.rwLock.writeLock().lock();
        try {
            this.removeAnalyzedParagraph(n);
            if (n >= 0 && n < this.locales.size()) {
                this.locales.set(n, new SerialLocale(locale));
            }
            if (n >= 0 && n < this.paragraphs.size()) {
                this.paragraphs.set(n, sPara);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public boolean isMultilingualFlatParagraph(int n) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.isMultilingualFlatParagraphIntern(n);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private boolean isMultilingualFlatParagraphIntern(int n) {
        return n < 0 || n >= this.locales.size() ? false : this.locales.get((int)n).Variant.startsWith("99-");
    }

    public void setMultilingualFlatParagraph(int n) {
        this.rwLock.writeLock().lock();
        try {
            this.removeAnalyzedParagraph(n);
            if (n >= 0 && n < this.locales.size()) {
                SerialLocale locale = this.locales.get(n);
                if (!locale.Variant.startsWith("99-")) {
                    locale.Variant = "99-" + locale.Variant;
                    this.locales.set(n, locale);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public Locale getFlatParagraphLocale(int n) {
        this.rwLock.readLock().lock();
        try {
            Locale locale = this.locales.get(n).toLocaleWithoutLabel();
            return locale;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setFlatParagraphLocale(int n, Locale locale) {
        this.rwLock.writeLock().lock();
        try {
            this.removeAnalyzedParagraph(n);
            if (n >= 0 && n < this.locales.size()) {
                this.locales.set(n, new SerialLocale(locale));
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public int[] getFlatParagraphFootnotes(int n) {
        this.rwLock.readLock().lock();
        try {
            int[] nArray = this.footnotes.get(n);
            return nArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setFlatParagraphFootnotes(int n, int[] footnotePos) {
        this.rwLock.writeLock().lock();
        try {
            this.removeAnalyzedParagraph(n);
            if (n >= 0 && n < this.footnotes.size()) {
                this.footnotes.set(n, footnotePos);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public List<Integer> getFlatParagraphDeletedCharacters(int n) {
        this.rwLock.readLock().lock();
        try {
            List<Integer> list = this.deletedCharacters.get(n);
            return list;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAutomaticGenerated(int n, boolean alsoIgnore) {
        this.rwLock.readLock().lock();
        try {
            if (n >= 0 && n < this.toTextMapping.size()) {
                if (alsoIgnore && this.locales.get((int)n).Language.equals("zxx")) {
                    boolean bl = true;
                    return bl;
                }
                TextParagraph tPara = this.toTextMapping.get(n);
                if (tPara.type == 4 && this.automaticParagraphs.contains(tPara.number)) {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setFlatParagraphDeletedCharacters(int n, List<Integer> deletedChars) {
        this.rwLock.writeLock().lock();
        try {
            this.removeAnalyzedParagraph(n);
            if (n >= 0 && n < this.deletedCharacters.size()) {
                this.deletedCharacters.set(n, deletedChars);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int correctStartPoint(int nStart, int nFPara) {
        this.rwLock.readLock().lock();
        try {
            int cor = 0;
            for (int i = 0; i < nStart; ++i) {
                if (this.paragraphs.get(nFPara).charAt(i) != '\u200b') continue;
                boolean isFootnote = false;
                for (int n : this.footnotes.get(nFPara)) {
                    if (n != i) continue;
                    isFootnote = true;
                    break;
                }
                if (isFootnote) continue;
                ++cor;
            }
            int n = nStart - cor;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void clear() {
        this.paragraphs.clear();
        this.chapterBegins.clear();
        this.locales.clear();
        this.footnotes.clear();
        this.toTextMapping.clear();
        this.toParaMapping.clear();
        this.deletedCharacters.clear();
        if (this.sortedTextIds != null) {
            this.sortedTextIds.clear();
        }
    }

    private void add(DocumentCache in) {
        this.paragraphs.addAll(in.paragraphs);
        this.chapterBegins.addAll(in.chapterBegins);
        this.locales.addAll(in.locales);
        this.footnotes.addAll(in.footnotes);
        this.toTextMapping.addAll(in.toTextMapping);
        for (int i = 0; i < 6; ++i) {
            this.toParaMapping.add(new ArrayList(in.toParaMapping.get(i)));
        }
        this.deletedCharacters.addAll(in.deletedCharacters);
        if (in.sortedTextIds != null) {
            this.sortedTextIds = new ArrayList<Integer>(in.sortedTextIds);
        }
        if (in.headingMap != null) {
            this.headingMap = new HashMap<Integer, Integer>(in.headingMap);
        }
        this.documentElementsCount = in.documentElementsCount;
        this.nText = in.nText;
        this.nTable = in.nTable;
        this.nShape = in.nShape;
        this.nFootnote = in.nFootnote;
        this.nEndnote = in.nEndnote;
        this.nHeaderFooter = in.nHeaderFooter;
    }

    public void put(DocumentCache in) {
        this.rwLock.writeLock().lock();
        try {
            this.clear();
            this.add(in);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public boolean isEmpty() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.paragraphs == null || this.paragraphs.isEmpty();
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean hasNoContent(boolean lock) {
        if (lock) {
            this.rwLock.readLock().lock();
        }
        try {
            boolean bl = this.paragraphs == null || this.paragraphs.isEmpty() || this.paragraphs.size() == 1 && this.paragraphs.get(0).isEmpty();
            return bl;
        }
        finally {
            if (lock) {
                this.rwLock.readLock().unlock();
            }
        }
    }

    public int size() {
        this.rwLock.readLock().lock();
        try {
            int n = this.paragraphs == null ? 0 : this.paragraphs.size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTextParagraph(TextParagraph textParagraph) {
        this.rwLock.readLock().lock();
        try {
            if (textParagraph.type == -1 || textParagraph.number < 0) {
                String string = new String("");
                return string;
            }
            int nFPara = this.toParaMapping.get(textParagraph.type).get(textParagraph.number);
            String string = nFPara < 0 ? new String("") : this.paragraphs.get(nFPara);
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int getFlatParagraphNumber(TextParagraph textParagraph) {
        this.rwLock.readLock().lock();
        try {
            if (textParagraph.type == -1 || textParagraph.number < 0 || this.toParaMapping.size() < 6 || this.toParaMapping.get(textParagraph.type).size() <= textParagraph.number) {
                int n = -1;
                return n;
            }
            int n = this.toParaMapping.get(textParagraph.type).get(textParagraph.number);
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Locale getTextParagraphLocale(TextParagraph textParagraph) {
        this.rwLock.readLock().lock();
        try {
            if (textParagraph.type == -1 || textParagraph.number < 0) {
                Locale locale = null;
                return locale;
            }
            int nFPara = this.toParaMapping.get(textParagraph.type).get(textParagraph.number);
            Locale locale = nFPara < 0 ? null : this.locales.get(nFPara).toLocaleWithoutLabel();
            return locale;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getTextParagraphDeletedCharacters(TextParagraph textParagraph) {
        this.rwLock.readLock().lock();
        try {
            if (textParagraph.type == -1 || textParagraph.number < 0) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                return arrayList;
            }
            int nFPara = this.toParaMapping.get(textParagraph.type).get(textParagraph.number);
            ArrayList<Integer> arrayList = nFPara < 0 ? new ArrayList<Integer>() : this.deletedCharacters.get(nFPara);
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getTextParagraphFootnotes(TextParagraph textParagraph) {
        this.rwLock.readLock().lock();
        try {
            if (textParagraph.type == -1 || textParagraph.number < 0) {
                int[] nArray = new int[]{};
                return nArray;
            }
            int nFPara = this.toParaMapping.get(textParagraph.type).get(textParagraph.number);
            int[] nArray = nFPara < 0 ? new int[]{} : this.footnotes.get(nFPara);
            return nArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setTextParagraphFootnotes(TextParagraph textParagraph, int[] footnotePos) {
        this.rwLock.writeLock().lock();
        try {
            this.removeAnalyzedTextParagraph(textParagraph);
            if (textParagraph.type != -1 && textParagraph.number >= 0) {
                this.footnotes.set(this.toParaMapping.get(textParagraph.type).get(textParagraph.number), footnotePos);
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public TextParagraph getNumberOfTextParagraph(int numberOfFlatParagraph) {
        this.rwLock.readLock().lock();
        try {
            TextParagraph textParagraph = this.getNumberOfTextParagraph_(numberOfFlatParagraph);
            return textParagraph;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private TextParagraph getNumberOfTextParagraph_(int numberOfFlatParagraph) {
        if (numberOfFlatParagraph < 0 || numberOfFlatParagraph >= this.toTextMapping.size()) {
            return new TextParagraph(-1, -1);
        }
        return this.toTextMapping.get(numberOfFlatParagraph);
    }

    public int getParagraphType(int numberOfFlatParagraph) {
        this.rwLock.readLock().lock();
        try {
            int n = this.toTextMapping.get((int)numberOfFlatParagraph).type;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int textSize(int type) {
        this.rwLock.readLock().lock();
        try {
            int n = type < 0 || type >= this.toParaMapping.size() ? 0 : this.toParaMapping.get(type).size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public int textSize(TextParagraph textParagraph) {
        this.rwLock.readLock().lock();
        try {
            int n = textParagraph.type == -1 || textParagraph.type >= this.toParaMapping.size() ? 0 : this.toParaMapping.get(textParagraph.type).size();
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqual(int n, String text, Locale locale) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = n < 0 || n >= this.locales.size() || this.locales.get(n) == null ? false : (this.isMultilingualFlatParagraphIntern(n) || this.locales.get(n).equalsLocale(locale)) && text.equals(this.paragraphs.get(n));
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEqual(int n, String text, Locale locale, List<Integer> delChars) {
        this.rwLock.readLock().lock();
        try {
            if (n < 0 || n >= this.locales.size() || this.locales.get(n) == null) {
                boolean bl = false;
                return bl;
            }
            if (!this.isMultilingualFlatParagraphIntern(n) && !this.locales.get(n).equalsLocale(locale)) {
                boolean bl = false;
                return bl;
            }
            if (delChars != null && this.deletedCharacters.get(n) == null || delChars == null && this.deletedCharacters.get(n) != null || delChars != null && this.deletedCharacters.get(n) != null && delChars.size() != this.deletedCharacters.get(n).size()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = text.equals(this.paragraphs.get(n));
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean isEqualCacheSize(DocumentCursorTools docCursor) {
        this.rwLock.readLock().lock();
        try {
            if (this.nText != docCursor.getNumberOfAllTextParagraphs()) {
                boolean bl = false;
                return bl;
            }
            if (this.nTable != docCursor.getNumberOfAllTables()) {
                boolean bl = false;
                return bl;
            }
            if (this.nShape != docCursor.getNumberOfAllShapes()) {
                boolean bl = false;
                return bl;
            }
            if (this.nFootnote != docCursor.getNumberOfAllFootnotes()) {
                boolean bl = false;
                return bl;
            }
            if (this.nEndnote != docCursor.getNumberOfAllEndnotes()) {
                boolean bl = false;
                return bl;
            }
            if (this.nHeaderFooter != docCursor.getNumberOfAllHeadersAndFooters()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getChangedUnsupportedParagraphs(DocumentCursorTools docCursor, ResultCache firstResultCache) {
        ArrayList<Integer> nChanged = new ArrayList<Integer>();
        this.rwLock.writeLock().lock();
        try {
            int nFPara;
            int i;
            List<String> fParas;
            if (docCursor == null) {
                ArrayList<Integer> arrayList = nChanged;
                return arrayList;
            }
            if (this.toParaMapping.get(3).isEmpty() && this.toParaMapping.get(5).isEmpty()) {
                List<Integer> list = null;
                return list;
            }
            ArrayList<Integer> nTableParas = new ArrayList<Integer>();
            ArrayList<Integer> nShapeParas = new ArrayList<Integer>();
            for (int i2 = 0; i2 < this.paragraphs.size() && this.toTextMapping.get((int)i2).type != 4; ++i2) {
                if (this.toTextMapping.get((int)i2).type == 3) {
                    nShapeParas.add(this.toTextMapping.get((int)i2).number);
                    continue;
                }
                if (this.toTextMapping.get((int)i2).type != 5) continue;
                nTableParas.add(this.toTextMapping.get((int)i2).number);
            }
            if (!nShapeParas.isEmpty() && (fParas = docCursor.getTextOfShapes(nShapeParas)) != null) {
                for (i = 0; i < fParas.size(); ++i) {
                    nFPara = this.toParaMapping.get(3).get((Integer)nShapeParas.get(i));
                    if (firstResultCache.getCacheEntry(nFPara) != null && this.paragraphs.get(nFPara).equals(fParas.get(i))) continue;
                    this.removeAnalyzedParagraph(nFPara);
                    this.paragraphs.set(nFPara, fParas.get(i));
                    nChanged.add(nFPara);
                }
            }
            if (!nTableParas.isEmpty() && (fParas = docCursor.getTextOfTables(nTableParas)) != null) {
                for (i = 0; i < fParas.size(); ++i) {
                    nFPara = this.toParaMapping.get(5).get((Integer)nTableParas.get(i));
                    if (firstResultCache.getCacheEntry(nFPara) != null && this.paragraphs.get(nFPara).equals(fParas.get(i))) continue;
                    this.removeAnalyzedParagraph(nFPara);
                    this.paragraphs.set(nFPara, fParas.get(i));
                    nChanged.add(nFPara);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
        return nChanged;
    }

    public boolean isSingleParagraph(int numberOfFlatParagraph) {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.isSingleParagraph_intern(numberOfFlatParagraph);
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private boolean isSingleParagraph_intern(int numberOfFlatParagraph) {
        if (numberOfFlatParagraph < 0 || numberOfFlatParagraph >= this.toTextMapping.size()) {
            return true;
        }
        TextParagraph textParagraph = this.toTextMapping.get(numberOfFlatParagraph);
        if (textParagraph.type == -1) {
            return true;
        }
        for (int n = 0; n < this.chapterBegins.get(textParagraph.type).size(); ++n) {
            if (textParagraph.number == 0 || textParagraph.number == this.chapterBegins.get(textParagraph.type).get(n)) {
                if (n != this.chapterBegins.get(textParagraph.type).size() - 1 && this.chapterBegins.get(textParagraph.type).get(n + 1) != textParagraph.number + 1) break;
                return true;
            }
            if (textParagraph.number < this.chapterBegins.get(textParagraph.type).get(n)) break;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartOfParaCheck(TextParagraph textParagraph, int parasToCheck, boolean checkOnlyParagraph, boolean useQueue, boolean addParas) {
        this.rwLock.readLock().lock();
        try {
            int heading;
            if (textParagraph.number < 0 || this.toParaMapping.get(textParagraph.type).size() <= textParagraph.number) {
                int n = -1;
                return n;
            }
            if (parasToCheck < -1) {
                int n = 0;
                return n;
            }
            if (parasToCheck == 0) {
                int n = textParagraph.number;
                return n;
            }
            int headingBefore = 0;
            Iterator<Integer> iterator = this.chapterBegins.get(textParagraph.type).iterator();
            while (iterator.hasNext() && (heading = iterator.next().intValue()) <= textParagraph.number) {
                headingBefore = heading;
            }
            if (headingBefore == textParagraph.number || parasToCheck < 0 || useQueue && !checkOnlyParagraph) {
                int n = headingBefore;
                return n;
            }
            int startPos = textParagraph.number - parasToCheck;
            if (addParas) {
                startPos -= parasToCheck;
            }
            if (startPos < headingBefore) {
                startPos = headingBefore;
            }
            int n = startPos;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEndOfParaCheck(TextParagraph textParagraph, int parasToCheck, boolean checkOnlyParagraph, boolean useQueue, boolean addParas) {
        this.rwLock.readLock().lock();
        try {
            if (textParagraph.number < 0 || this.toParaMapping.get(textParagraph.type).size() <= textParagraph.number) {
                int n = -1;
                return n;
            }
            if (parasToCheck < -1) {
                int n = this.size();
                return n;
            }
            int headingAfter = -1;
            if (parasToCheck == 0) {
                int n = textParagraph.number + 1;
                return n;
            }
            Iterator<Integer> iterator = this.chapterBegins.get(textParagraph.type).iterator();
            while (iterator.hasNext()) {
                int heading;
                headingAfter = heading = iterator.next().intValue();
                if (heading <= textParagraph.number) continue;
                break;
            }
            if (headingAfter <= textParagraph.number || headingAfter > this.toParaMapping.get(textParagraph.type).size()) {
                headingAfter = this.toParaMapping.get(textParagraph.type).size();
            }
            if (parasToCheck < 0 || useQueue && !checkOnlyParagraph) {
                int n = headingAfter;
                return n;
            }
            int endPos = textParagraph.number + 1 + parasToCheck;
            if (!checkOnlyParagraph) {
                endPos += parasToCheck * 40;
            }
            if (addParas) {
                endPos += parasToCheck;
            }
            if (endPos > headingAfter) {
                endPos = headingAfter;
            }
            int n = endPos;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDocAsString(TextParagraph textParagraph, int parasToCheck, boolean checkOnlyParagraph, boolean useQueue, boolean hasFootnotes) {
        this.rwLock.readLock().lock();
        try {
            StringBuilder docText;
            int startPos = this.getStartOfParaCheck(textParagraph, parasToCheck, checkOnlyParagraph, useQueue, true);
            int endPos = this.getEndOfParaCheck(textParagraph, parasToCheck, checkOnlyParagraph, useQueue, true);
            if (parasToCheck < -1) {
                if (startPos < 0 || endPos < 0 || hasFootnotes && this.getFlatParagraph(startPos).isEmpty() && this.getFlatParagraphFootnotes(startPos).length > 0) {
                    String string = "";
                    return string;
                }
                docText = new StringBuilder(DocumentCache.fixLinebreak(SingleCheck.removeFootnotes(this.getFlatParagraph(startPos), hasFootnotes ? this.getFlatParagraphFootnotes(startPos) : null, this.getFlatParagraphDeletedCharacters(startPos))));
                for (int i = startPos + 1; i < endPos; ++i) {
                    docText.append("\n\n").append(DocumentCache.fixLinebreak(SingleCheck.removeFootnotes(this.getFlatParagraph(i), hasFootnotes ? this.getFlatParagraphFootnotes(i) : null, this.getFlatParagraphDeletedCharacters(i))));
                }
            } else {
                TextParagraph startPara = new TextParagraph(textParagraph.type, startPos);
                if (startPos < 0 || endPos < 0 || hasFootnotes && this.getTextParagraph(startPara).isEmpty() && this.getTextParagraphFootnotes(startPara).length > 0) {
                    String string = "";
                    return string;
                }
                docText = new StringBuilder(DocumentCache.fixLinebreak(SingleCheck.removeFootnotes(this.getTextParagraph(startPara), hasFootnotes ? this.getTextParagraphFootnotes(startPara) : null, this.getTextParagraphDeletedCharacters(startPara))));
                for (int i = startPos + 1; i < endPos; ++i) {
                    TextParagraph tPara = new TextParagraph(textParagraph.type, i);
                    docText.append("\n\n").append(DocumentCache.fixLinebreak(SingleCheck.removeFootnotes(this.getTextParagraph(tPara), hasFootnotes ? this.getTextParagraphFootnotes(tPara) : null, this.getTextParagraphDeletedCharacters(tPara))));
                }
            }
            String string = docText.toString();
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public String getDocAsString() {
        this.rwLock.readLock().lock();
        try {
            StringBuilder docText = new StringBuilder(this.paragraphs.get(0));
            for (int i = 1; i < this.paragraphs.size(); ++i) {
                docText.append("\n\n").append(this.paragraphs.get(i));
            }
            String string = docText.toString();
            return string;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public static String fixLinebreak(String text) {
        return text.replaceAll("\n", "\r");
    }

    public static String removeZeroWidthSpace(String text) {
        return text.replaceAll("\u200b", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStartOfParagraph(int nPara, TextParagraph textParagraph, int parasToCheck, boolean checkOnlyParagraph, boolean useQueue, boolean hasFootnotes) {
        this.rwLock.readLock().lock();
        try {
            int i;
            if (nPara < 0 || parasToCheck > -2 && this.toParaMapping.get(textParagraph.type).size() <= nPara || parasToCheck < -1 && this.paragraphs.size() <= nPara) {
                int n = -1;
                return n;
            }
            int startPos = this.getStartOfParaCheck(textParagraph, parasToCheck, checkOnlyParagraph, useQueue, true);
            if (startPos < 0) {
                int n = -1;
                return n;
            }
            int pos = 0;
            if (parasToCheck < -1) {
                for (i = startPos; i < nPara; ++i) {
                    pos += SingleCheck.removeFootnotes(this.getFlatParagraph(i), hasFootnotes ? this.getFlatParagraphFootnotes(i) : null, this.getFlatParagraphDeletedCharacters(i)).length() + OfficeTools.NUMBER_PARAGRAPH_CHARS;
                }
            } else {
                for (i = startPos; i < nPara; ++i) {
                    TextParagraph tPara = new TextParagraph(textParagraph.type, i);
                    pos += SingleCheck.removeFootnotes(this.getTextParagraph(tPara), hasFootnotes ? this.getTextParagraphFootnotes(tPara) : null, this.getTextParagraphDeletedCharacters(tPara)).length() + OfficeTools.NUMBER_PARAGRAPH_CHARS;
                }
            }
            int n = pos;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void mapDeletedCharacters(List<List<Integer>> deletedCharacters, List<String> paragraphs, List<List<List<Integer>>> deletedChars, List<TextParagraph> toTextMapping) {
        if (deletedChars == null) {
            for (int i = 0; i < toTextMapping.size(); ++i) {
                deletedCharacters.add(null);
            }
        } else {
            for (int i = 0; i < toTextMapping.size(); ++i) {
                if (toTextMapping.get((int)i).type == -1) {
                    deletedCharacters.add(null);
                    if (!debugMode && paragraphs.get(i).isEmpty()) continue;
                    MessageHandler.printToLogFile("Warning: CURSOR_TYPE_UNKNOWN at Paragraph " + i + ": deleted Characters set to null");
                    MessageHandler.printToLogFile("         Paragraph : '" + paragraphs.get(i) + "'");
                    continue;
                }
                deletedCharacters.add(deletedChars.get(toTextMapping.get((int)i).type).get(toTextMapping.get((int)i).number));
            }
        }
    }

    private void prepareChapterBeginsForText(List<List<Integer>> chapterBegins, List<TextParagraph> toTextMapping, List<SerialLocale> locales) {
        ArrayList<Integer> prepChBegins = new ArrayList<Integer>((Collection)chapterBegins.get(4));
        for (int begin : chapterBegins.get(4)) {
            if (prepChBegins.contains(begin + 1)) continue;
            prepChBegins.add(begin + 1);
        }
        if (locales.size() > 0) {
            SerialLocale lastLocale = locales.get(0);
            for (int i = 1; i < locales.size(); ++i) {
                if (locales == null || locales.get(i).equalsLocale(lastLocale)) continue;
                TextParagraph nText = toTextMapping.get(i);
                if (nText.type != 4 || nText.number < 0) continue;
                if (!prepChBegins.contains(nText.number)) {
                    prepChBegins.add(nText.number);
                }
                lastLocale = locales.get(i);
                if (!debugMode) continue;
                MessageHandler.printToLogFile("DocumentCache: prepareChapterBeginsForText: Paragraph(" + i + "): Locale changed to: " + lastLocale.Language + (lastLocale.Country == null ? "" : "-" + lastLocale.Country));
            }
        }
        prepChBegins.sort(null);
        chapterBegins.set(4, prepChBegins);
    }

    public TextParagraph createTextParagraph(int type, int paragraph) {
        return new TextParagraph(type, paragraph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangedRange refreshAndCompare(SingleDocument document, Locale fixedLocale, Locale docLocale, XComponent xComponent, int fromWhere) {
        DocumentCache oldCache = new DocumentCache(this);
        this.refresh(document, fixedLocale, docLocale, xComponent, fromWhere);
        this.rwLock.readLock().lock();
        try {
            int from;
            if (this.paragraphs == null || this.paragraphs.isEmpty() || oldCache.paragraphs == null || oldCache.paragraphs.isEmpty()) {
                ChangedRange changedRange = null;
                return changedRange;
            }
            int to = 1;
            if (oldCache.toParaMapping.get(2).size() != this.toParaMapping.get(2).size()) {
                for (from = 0; from < this.paragraphs.size() && from < oldCache.paragraphs.size() && (this.toTextMapping.get((int)from).type != 2 || this.paragraphs.get(from).equals(oldCache.paragraphs.get(from))); ++from) {
                }
                while (to <= this.paragraphs.size() && to <= oldCache.paragraphs.size() && (this.toTextMapping.get((int)(this.paragraphs.size() - to)).type != 2 || this.paragraphs.get(this.paragraphs.size() - to).equals(oldCache.paragraphs.get(oldCache.paragraphs.size() - to)))) {
                    ++to;
                }
            } else {
                while (from < this.paragraphs.size() && from < oldCache.paragraphs.size() && (this.toTextMapping.get((int)from).type == 2 || this.paragraphs.get(from).equals(oldCache.paragraphs.get(from)))) {
                    ++from;
                }
                while (to <= this.paragraphs.size() && to <= oldCache.paragraphs.size() && (this.toTextMapping.get((int)(this.paragraphs.size() - to)).type == 2 || this.paragraphs.get(this.paragraphs.size() - to).equals(oldCache.paragraphs.get(oldCache.paragraphs.size() - to)))) {
                    ++to;
                }
            }
            if ((to = this.paragraphs.size() - to + 1) < from) {
                to = from;
            }
            this.removeAndShiftAnalyzedParagraph(from, to, oldCache.paragraphs.size(), this.paragraphs.size());
            ChangedRange changedRange = new ChangedRange(from, to, oldCache.paragraphs.size(), this.paragraphs.size());
            return changedRange;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public Map<Integer, Integer> getHeadingMap() {
        return this.headingMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNearestSortedTextId(int sortedTextId) {
        this.rwLock.readLock().lock();
        try {
            if (this.sortedTextIds == null) {
                int n = -1;
                return n;
            }
            for (int i = 0; i < this.sortedTextIds.size(); ++i) {
                if (this.sortedTextIds.get(i) != sortedTextId) continue;
                if (i == this.sortedTextIds.size() - 1) {
                    int n = this.sortedTextIds.get(i - 1);
                    return n;
                }
                int n = this.sortedTextIds.get(i + 1);
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlatparagraphFromSortedTextId(int sortedTextId) {
        this.rwLock.readLock().lock();
        try {
            if (this.sortedTextIds == null) {
                int n = -1;
                return n;
            }
            for (int i = 0; i < this.sortedTextIds.size(); ++i) {
                if (this.sortedTextIds.get(i) != sortedTextId) continue;
                int n = i;
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean isActual(int documentElementsCount) {
        this.rwLock.readLock().lock();
        try {
            if (this.isDirty || this.sortedTextIds == null || documentElementsCount == -1 || this.documentElementsCount != documentElementsCount) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private SerialLocale getMostUsedLanguage(List<SerialLocale> locales) {
        HashMap<SerialLocale, Integer> localesMap = new HashMap<SerialLocale, Integer>();
        for (SerialLocale locale : locales) {
            boolean localeExists = false;
            for (SerialLocale loc : localesMap.keySet()) {
                if (!loc.equalsLocale(locale)) continue;
                localesMap.put(loc, (Integer)localesMap.get(loc) + 1);
                localeExists = true;
                break;
            }
            if (localeExists) continue;
            localesMap.put(locale, 1);
        }
        int max = 0;
        SerialLocale maxLocale = null;
        for (SerialLocale loc : localesMap.keySet()) {
            if ((Integer)localesMap.get(loc) <= max || !MultiDocumentsHandler.hasLocale(loc.toLocale())) continue;
            max = (Integer)localesMap.get(loc);
            maxLocale = loc;
        }
        if (maxLocale != null) {
            return maxLocale;
        }
        return null;
    }

    public Locale getDocumentLocale() {
        this.rwLock.readLock().lock();
        try {
            if (this.docLocale == null) {
                Locale locale = null;
                return locale;
            }
            Locale locale = this.docLocale.toLocaleWithoutLabel();
            return locale;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void clearAnalyzedParagraphs() {
        this.analyzedParagraphs.clear();
    }

    public Map<Integer, List<AnalyzedSentence>> getAllAnalyzedParagraphs() {
        return this.analyzedParagraphs;
    }

    public List<AnalyzedSentence> getAnalyzedParagraph(int nFPara) {
        this.rwLock.readLock().lock();
        try {
            List<AnalyzedSentence> list = this.analyzedParagraphs.get(nFPara);
            return list;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public boolean isCorrectAnalyzedParagraphLength(int nFPara, String text) {
        List<AnalyzedSentence> analyzedSentences = this.getAnalyzedParagraph(nFPara);
        if (analyzedSentences == null) {
            return false;
        }
        text = DocumentCache.fixLinebreak(SingleCheck.removeFootnotes(text, this.getFlatParagraphFootnotes(nFPara), this.getFlatParagraphDeletedCharacters(nFPara)));
        int len = 0;
        for (AnalyzedSentence analyzedSentence : analyzedSentences) {
            String sentence = analyzedSentence.getText();
            len += sentence.length();
        }
        return len == text.length();
    }

    private void removeAnalyzedParagraph(int nFPara) {
        this.analyzedParagraphs.remove(nFPara);
    }

    private void removeAnalyzedTextParagraph(TextParagraph textParagraph) {
        if (textParagraph.type != -1 && textParagraph.number >= 0 && textParagraph.number < this.toParaMapping.get(textParagraph.type).size()) {
            this.analyzedParagraphs.remove(this.toParaMapping.get(textParagraph.type).get(textParagraph.number));
        }
    }

    public void putAnalyzedParagraph(int nFPara, List<AnalyzedSentence> analyzedParagraph) {
        this.rwLock.writeLock().lock();
        try {
            this.analyzedParagraphs.put(nFPara, analyzedParagraph);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private void removeAndShiftAnalyzedParagraph(int fromParagraph, int toParagraph, int oldSize, int newSize) {
        if (this.analyzedParagraphs == null || this.analyzedParagraphs.isEmpty()) {
            return;
        }
        int shift = newSize - oldSize;
        if (fromParagraph < 0 && toParagraph >= newSize) {
            return;
        }
        HashMap<Integer, List<AnalyzedSentence>> tmpParagraphs = new HashMap<Integer, List<AnalyzedSentence>>(this.analyzedParagraphs);
        this.analyzedParagraphs.clear();
        if (shift < 0) {
            Iterator iterator = tmpParagraphs.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i < fromParagraph) {
                    this.analyzedParagraphs.put(i, (List<AnalyzedSentence>)tmpParagraphs.get(i));
                    continue;
                }
                if (i < toParagraph - shift) continue;
                this.analyzedParagraphs.put(i + shift, (List<AnalyzedSentence>)tmpParagraphs.get(i));
            }
        } else {
            Iterator iterator = tmpParagraphs.keySet().iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                if (i < fromParagraph - 1) {
                    this.analyzedParagraphs.put(i, (List<AnalyzedSentence>)tmpParagraphs.get(i));
                    continue;
                }
                if (i < toParagraph + 1) continue;
                this.analyzedParagraphs.put(i + shift, (List<AnalyzedSentence>)tmpParagraphs.get(i));
            }
        }
    }

    public List<AnalyzedSentence> createAnalyzedParagraph(int nFPara, SwJLanguageTool lt) throws IOException {
        String paraText = this.getFlatParagraph(nFPara);
        if (paraText == null) {
            return null;
        }
        paraText = SingleCheck.removeFootnotes(paraText, this.getFlatParagraphFootnotes(nFPara), this.getFlatParagraphDeletedCharacters(nFPara));
        return this.createAnalyzedParagraph(nFPara, paraText, lt);
    }

    private List<AnalyzedSentence> createAnalyzedParagraph(int nFPara, String paraText, SwJLanguageTool lt) throws IOException {
        List<AnalyzedSentence> analyzedParagraph = lt.analyzeText(paraText.replace("\u00ad", ""));
        this.putAnalyzedParagraph(nFPara, analyzedParagraph);
        return analyzedParagraph;
    }

    public AnalysedText getOrCreateAnalyzedParagraph(int nFPara, SwJLanguageTool lt) throws IOException {
        String paraText = this.getFlatParagraph(nFPara);
        if (paraText == null) {
            return null;
        }
        paraText = DocumentCache.fixLinebreak(SingleCheck.removeFootnotes(paraText, this.getFlatParagraphFootnotes(nFPara), this.getFlatParagraphDeletedCharacters(nFPara)));
        List<AnalyzedSentence> analyzedSentences = this.getAnalyzedParagraph(nFPara);
        ArrayList<String> sentences = new ArrayList<String>();
        if (analyzedSentences == null) {
            analyzedSentences = this.createAnalyzedParagraph(nFPara, paraText, lt);
        }
        int len = 0;
        for (AnalyzedSentence analyzedSentence : analyzedSentences) {
            String sentence = analyzedSentence.getText();
            len += sentence.length();
            sentences.add(sentence);
        }
        if (len != paraText.length()) {
            analyzedSentences = this.createAnalyzedParagraph(nFPara, paraText, lt);
            sentences.clear();
            for (AnalyzedSentence analyzedSentence : analyzedSentences) {
                sentences.add(analyzedSentence.getText());
            }
        }
        return new AnalysedText(analyzedSentences, sentences, paraText);
    }

    public AnalysedText getAnalyzedParagraphs(TextParagraph from, TextParagraph to, SwJLanguageTool lt) throws IOException {
        ArrayList<AnalyzedSentence> analyzedParagraphs = new ArrayList<AnalyzedSentence>();
        ArrayList<String> sentences = new ArrayList<String>();
        StringBuilder docText = new StringBuilder();
        for (int i = from.number; i < to.number; ++i) {
            int startPos;
            int k;
            AnalyzedTokenReadings[] newTokens;
            int len;
            AnalyzedTokenReadings[] tokens;
            AnalyzedSentence sentence;
            int n = this.getFlatParagraphNumber(new TextParagraph(from.type, i));
            AnalysedText analyzedParagraph = this.getOrCreateAnalyzedParagraph(n, lt);
            if (analyzedParagraph == null) {
                return null;
            }
            if (analyzedParagraph.analyzedSentences.size() == 0) {
                if (analyzedParagraphs.size() > 0) {
                    int last = analyzedParagraphs.size() - 1;
                    sentence = (AnalyzedSentence)analyzedParagraphs.get(last);
                    tokens = sentence.getTokens();
                    len = tokens.length;
                    newTokens = new AnalyzedTokenReadings[len + 2];
                    for (k = 0; k < len; ++k) {
                        newTokens[k] = tokens[k];
                    }
                    startPos = tokens[len - 1].getEndPos();
                    newTokens[len] = new AnalyzedTokenReadings(new AnalyzedToken("\n", null, null), startPos);
                    newTokens[len + 1] = new AnalyzedTokenReadings(new AnalyzedToken("\n", null, null), startPos + 1);
                    sentence = new AnalyzedSentence(newTokens);
                    analyzedParagraphs.set(last, sentence);
                    sentences.set(last, sentence.getText());
                } else {
                    AnalyzedTokenReadings[] newTokens2 = new AnalyzedTokenReadings[]{new AnalyzedTokenReadings(new AnalyzedToken("", "SENT_START", null), 0), new AnalyzedTokenReadings(new AnalyzedToken("\n", null, null), 0), new AnalyzedTokenReadings(new AnalyzedToken("\n", "SENT_END", null), 1)};
                    newTokens2[2].setParagraphEnd();
                    sentence = new AnalyzedSentence(newTokens2);
                    analyzedParagraphs.add(sentence);
                    sentences.add(sentence.getText());
                }
            } else {
                for (int j = 0; j < analyzedParagraph.analyzedSentences.size(); ++j) {
                    sentence = analyzedParagraph.analyzedSentences.get(j);
                    if (j == analyzedParagraph.analyzedSentences.size() - 1 && i < to.number - 1) {
                        tokens = sentence.getTokens();
                        len = tokens.length;
                        newTokens = new AnalyzedTokenReadings[len + 2];
                        for (k = 0; k < len; ++k) {
                            newTokens[k] = tokens[k];
                        }
                        startPos = tokens[len - 1].getEndPos();
                        newTokens[len] = new AnalyzedTokenReadings(new AnalyzedToken("\n", null, null), startPos);
                        newTokens[len + 1] = new AnalyzedTokenReadings(new AnalyzedToken("\n", null, null), startPos + 1);
                        sentence = new AnalyzedSentence(newTokens);
                        sentences.add(sentence.getText());
                    } else {
                        sentences.add(analyzedParagraph.sentences.get(j));
                    }
                    analyzedParagraphs.add(sentence);
                }
            }
            docText.append(analyzedParagraph.text);
            if (i >= to.number - 1) continue;
            docText.append("\n\n");
        }
        return new AnalysedText(analyzedParagraphs, sentences, docText.toString());
    }

    public static class AnalysedText {
        public final List<AnalyzedSentence> analyzedSentences;
        public final List<String> sentences;
        public final String text;

        AnalysedText(List<AnalyzedSentence> analyzedSentences, List<String> sentences, String text) {
            this.analyzedSentences = analyzedSentences;
            this.sentences = sentences;
            this.text = text;
        }
    }

    public static class ChangedRange {
        public final int from;
        public final int to;
        public final int oldSize;
        public final int newSize;

        ChangedRange(int from, int to, int oldSize, int newSize) {
            this.from = from;
            this.to = to;
            this.oldSize = oldSize;
            this.newSize = newSize;
        }
    }

    public static class SerialLocale
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String Country;
        String Language;
        String Variant;

        SerialLocale(Locale locale) {
            this.Country = locale.Country;
            this.Language = locale.Language;
            this.Variant = locale.Variant;
        }

        public String toString() {
            return this.Language + (this.Country.isEmpty() ? "" : "-" + this.Country) + (this.Variant.isEmpty() ? "" : "-" + this.Variant);
        }

        Locale toLocale() {
            return new Locale(this.Language, this.Country, this.Variant);
        }

        Locale toLocaleWithoutLabel() {
            if (this.Variant.startsWith("99-")) {
                return new Locale(this.Language, this.Country, this.Variant.substring("99-".length()));
            }
            return new Locale(this.Language, this.Country, this.Variant);
        }

        boolean equalsLocale(Locale locale) {
            return locale == null || this.Language == null || this.Country == null || this.Variant == null ? false : this.Language.equals(locale.Language) && this.Country.equals(locale.Country) && this.Variant.equals(locale.Variant);
        }

        boolean equalsLocale(SerialLocale locale) {
            return locale == null || this.Language == null || this.Country == null || this.Variant == null ? false : this.Language.equals(locale.Language) && this.Country.equals(locale.Country) && this.Variant.equals(locale.Variant);
        }
    }

    public static class TextParagraph
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int type;
        int number;

        public TextParagraph(int type, int number) {
            this.type = type;
            this.number = number;
        }
    }
}

