/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.gui.ConfigurationDialog;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.SwJLanguageTool;
import org.languagetool.rules.Rule;

class ConfigThread
extends Thread {
    private final Language docLanguage;
    private final Configuration config;
    private final SwJLanguageTool lt;
    private final MultiDocumentsHandler documents;
    private final ConfigurationDialog cfgDialog;

    ConfigThread(Language docLanguage, Configuration config, SwJLanguageTool lt, MultiDocumentsHandler documents) {
        this.docLanguage = config.getDefaultLanguage() == null ? docLanguage : config.getDefaultLanguage();
        this.config = config;
        this.lt = lt;
        this.documents = documents;
        String title = JLanguageTool.getMessageBundle().getString("guiConfigWindowTitle") + " (LT " + OfficeTools.getLtInformation() + ")";
        this.cfgDialog = new ConfigurationDialog(null, true, OfficeTools.getLtImage(), title, config);
    }

    @Override
    public void run() {
        if (!this.documents.javaVersionOkay()) {
            return;
        }
        if (!this.documents.isJavaLookAndFeelSet()) {
            this.documents.setJavaLookAndFeel();
        }
        this.documents.setConfigurationDialog(this.cfgDialog);
        try {
            List<Rule> allRules = this.lt.getAllRules();
            Set<String> disabledRulesUI = this.documents.getDisabledRules(this.docLanguage.getShortCodeWithCountryAndVariant());
            this.config.addDisabledRuleIds(disabledRulesUI);
            boolean configChanged = this.cfgDialog.show(allRules);
            if (configChanged) {
                Set<String> disabledRules = this.config.getDisabledRuleIds();
                HashSet<String> tmpDisabledRules = new HashSet<String>(disabledRulesUI);
                for (String ruleId : tmpDisabledRules) {
                    if (disabledRules.contains(ruleId)) continue;
                    disabledRulesUI.remove(ruleId);
                }
                this.documents.setDisabledRules(this.docLanguage.getShortCodeWithCountryAndVariant(), disabledRulesUI);
                this.config.removeDisabledRuleIds(disabledRulesUI);
                this.config.saveConfiguration(this.docLanguage);
                this.documents.resetDocumentCaches();
                this.documents.resetConfiguration();
            } else {
                this.config.removeDisabledRuleIds(this.documents.getDisabledRules(this.docLanguage.getShortCodeWithCountryAndVariant()));
            }
        }
        catch (Throwable e) {
            MessageHandler.showError(e);
        }
        this.documents.setConfigurationDialog(null);
    }
}

