/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.openoffice;

import com.sun.star.lang.Locale;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XFlatParagraph;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.languagetool.Language;
import org.languagetool.gui.Configuration;
import org.languagetool.openoffice.DocumentCache;
import org.languagetool.openoffice.DocumentCursorTools;
import org.languagetool.openoffice.FlatParagraphTools;
import org.languagetool.openoffice.LinguisticServices;
import org.languagetool.openoffice.MessageHandler;
import org.languagetool.openoffice.MultiDocumentsHandler;
import org.languagetool.openoffice.OfficeTools;
import org.languagetool.openoffice.ResultCache;
import org.languagetool.openoffice.SingleCheck;
import org.languagetool.openoffice.SingleDocument;
import org.languagetool.openoffice.ViewCursorTools;

class CheckRequestAnalysis {
    private static int debugMode;
    private static boolean debugModeTm;
    private final int numParasToCheck;
    private final XComponent xComponent;
    private final String docID;
    private final MultiDocumentsHandler mDocHandler;
    private final SingleDocument singleDocument;
    private final Configuration config;
    private final List<Integer> minToCheckPara;
    private final Language docLanguage;
    private final Language fixedLanguage;
    private final boolean useQueue;
    private final OfficeTools.DocumentType docType;
    private final int proofInfo;
    private final DocumentCache docCache;
    private final Map<Integer, String> changedParas;
    private final Set<Integer> runningParas;
    private final List<ResultCache> paragraphsCache;
    private int numLastVCPara;
    private List<Integer> numLastFlPara;
    private int changeFrom = 0;
    private int changeTo = 0;
    private boolean textIsChanged = false;
    private int numParasToChange = -1;
    private int paraNum;

    CheckRequestAnalysis(int numLastVCPara, List<Integer> numLastFlPara, int proofInfo, int numParasToCheck, Language fixedLanguage, Language docLanguage, SingleDocument singleDocument, List<ResultCache> paragraphsCache, Map<Integer, String> changedParas, Set<Integer> runningParas) {
        debugMode = OfficeTools.DEBUG_MODE_CR;
        debugModeTm = OfficeTools.DEBUG_MODE_TM;
        this.singleDocument = singleDocument;
        this.numLastVCPara = numLastVCPara;
        this.numLastFlPara = numLastFlPara;
        this.proofInfo = proofInfo;
        this.paragraphsCache = paragraphsCache;
        this.changedParas = changedParas;
        this.runningParas = runningParas;
        this.fixedLanguage = fixedLanguage;
        this.docLanguage = docLanguage;
        this.mDocHandler = singleDocument.getMultiDocumentsHandler();
        this.xComponent = singleDocument.getXComponent();
        this.docID = singleDocument.getDocID();
        this.docType = singleDocument.getDocumentType();
        this.minToCheckPara = this.mDocHandler.getNumMinToCheckParas();
        this.docCache = singleDocument.getDocumentCache();
        this.config = this.mDocHandler.getConfiguration();
        this.numParasToCheck = this.mDocHandler.isTestMode() ? 0 : numParasToCheck;
        this.useQueue = numParasToCheck != 0 && proofInfo != 1 && this.config.useTextLevelQueue();
        for (int minPara : this.minToCheckPara) {
            if (minPara <= this.numParasToChange) continue;
            this.numParasToChange = minPara;
        }
    }

    int getNumberOfParagraphFromSortedTextId(int sortedTextId, int documentElementsCount, String paraText, Locale locale, int[] footnotePosition) {
        if (this.docCache == null) {
            return -1;
        }
        if (this.proofInfo != 1 && !this.docCache.isActual(documentElementsCount)) {
            this.handleCacheChanges();
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalyzes: getNumberOfParagraphFromSortedTextId: cache actualized, documentElementsCount: " + documentElementsCount);
            }
        }
        int paraNum = this.docCache.getFlatparagraphFromSortedTextId(sortedTextId);
        if (this.proofInfo == 1) {
            return paraNum;
        }
        if (paraNum < 0) {
            this.handleCacheChanges();
            paraNum = this.docCache.getFlatparagraphFromSortedTextId(sortedTextId);
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalyzes: getNumberOfParagraphFromSortedTextId: paraNum < 0  --> cache actualized, new paraNum: " + paraNum);
            }
        }
        if (paraNum >= 0) {
            List<Integer> deletedChars;
            DocumentCache.TextParagraph tPara = this.docCache.getNumberOfTextParagraph(paraNum);
            DocumentCursorTools docCursor = this.singleDocument.getDocumentCursorTools();
            if (docCursor != null && !this.docCache.isEqual(paraNum, paraText, locale, deletedChars = docCursor.getDeletedCharactersOfTextParagraph(tPara, this.config.includeTrackedChanges()))) {
                this.handleChangedPara(paraNum, paraText, locale, footnotePosition, deletedChars);
            }
        }
        return paraNum;
    }

    int getNumberOfParagraph(int nPara, String chPara, Locale locale, int startPos, int[] footnotePositions) {
        this.paraNum = this.getParaPos(nPara, chPara, locale, startPos, footnotePositions);
        if (this.isDisposed() || this.paraNum >= this.docCache.size()) {
            this.paraNum = -1;
        }
        return this.paraNum;
    }

    void actualizeDocumentCache(int nPara, boolean isIntern) {
        long runTime;
        if (this.isDisposed()) {
            return;
        }
        long startTime = 0L;
        if (debugModeTm) {
            startTime = System.currentTimeMillis();
        }
        if (this.docCache.isEmpty()) {
            this.docCache.refresh(this.singleDocument, LinguisticServices.getLocale(this.fixedLanguage), LinguisticServices.getLocale(this.docLanguage), this.xComponent, 1);
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: actualizeDocumentCache: resetAllParas (docCache is empty): new docCache.size: " + this.docCache.size() + ", docID: " + this.docID + OfficeTools.LOG_LINE_BREAK);
            }
            if (this.docCache.isEmpty()) {
                return;
            }
        } else {
            int nOldParas = this.docCache.size();
            this.changesInNumberOfParagraph(false);
            int numParas = this.docCache.size();
            if (numParas <= 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: actualizeDocumentCache: docCache error!");
                return;
            }
            this.textIsChanged = true;
            if (nOldParas != numParas) {
                if (debugMode > 1) {
                    MessageHandler.printToLogFile("CheckRequestAnalysis: actualizeDocumentCache: Number of Paragraphs has changed: old:" + nOldParas + ", new:" + numParas);
                }
                return;
            }
        }
        FlatParagraphTools flatPara = this.singleDocument.getFlatParagraphTools();
        XFlatParagraph xFlatPara = flatPara.getFlatParagraphAt(nPara);
        if (this.isDisposed() || xFlatPara == null) {
            return;
        }
        String chPara = xFlatPara.getText();
        Locale docLocale = this.docLanguage == null ? null : LinguisticServices.getLocale(this.docLanguage);
        Locale lastLocale = nPara <= 0 ? null : this.docCache.getFlatParagraphLocale(nPara - 1);
        try {
            Locale locale = FlatParagraphTools.getPrimaryParagraphLanguage(xFlatPara, 0, chPara.length(), docLocale, lastLocale, false);
            DocumentCursorTools docCursor = this.singleDocument.getDocumentCursorTools();
            List<Integer> deletedChars = docCursor.getDeletedCharactersOfTextParagraph(this.docCache.getNumberOfTextParagraph(nPara), this.config.includeTrackedChanges());
            if (!this.docCache.isEqual(nPara, chPara, locale, deletedChars)) {
                if (debugMode > 1) {
                    MessageHandler.printToLogFile("ICheckRequestAnalysis: actualizeDocumentCache: Paragraph has changed:\nold:" + chPara + "\nnew:" + this.docCache.getFlatParagraph(nPara));
                }
                this.docCache.setFlatParagraph(nPara, chPara, locale);
                this.singleDocument.removeResultCache(nPara, true);
                this.singleDocument.removeIgnoredMatch(nPara, isIntern);
            }
        }
        catch (Throwable t) {
            MessageHandler.printException(t);
        }
        if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to actualize document cache: " + runTime);
        }
    }

    int getLastParaNumFromViewCursor() {
        return this.numLastVCPara;
    }

    List<Integer> getLastParaNumFromFlatParagraph() {
        return this.numLastFlPara;
    }

    int getFirstParagraphToChange() {
        return this.changeFrom;
    }

    int getLastParagraphToChange() {
        return this.changeTo;
    }

    boolean textIsChanged() {
        return this.textIsChanged;
    }

    private int getParaPos(int nPara, String chPara, Locale locale, int startPos, int[] footnotePositions) {
        long runTime;
        if (this.isDisposed()) {
            return -1;
        }
        long startTime = 0L;
        if (debugModeTm) {
            startTime = System.currentTimeMillis();
        }
        if (debugMode > 0 && this.proofInfo == 1) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: PROOFINFO_GET_PROOFRESULT: analysis started");
        }
        if (this.docType != OfficeTools.DocumentType.WRITER && this.docCache.isEmpty()) {
            if (debugMode > 0 && this.proofInfo == 1) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: start docCache.refresh");
            }
            this.docCache.refresh(this.singleDocument, LinguisticServices.getLocale(this.fixedLanguage), LinguisticServices.getLocale(this.docLanguage), this.xComponent, 3);
        }
        if (nPara >= 0) {
            return nPara;
        }
        if (this.numParasToCheck == 0 || this.xComponent == null) {
            return -1;
        }
        if (debugMode > 0 && this.proofInfo == 1) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: start setFlatParagraphTools");
        }
        if (debugMode > 0 && this.proofInfo == 1) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: test docCache.isEmpty");
        }
        if (this.docCache.isEmpty()) {
            if (debugMode > 0 && this.proofInfo == 1) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: get DocumentCursorTools");
            }
            this.docCache.refresh(this.singleDocument, LinguisticServices.getLocale(this.fixedLanguage), LinguisticServices.getLocale(this.docLanguage), this.xComponent, 4);
            if (debugMode > 0 && this.proofInfo == 1) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: start docCache.refresh");
            }
            if (debugMode > 0 || this.proofInfo == 1) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: resetAllParas (docCache is empty): new docCache.size: " + this.docCache.size() + ", docID: " + this.docID + OfficeTools.LOG_LINE_BREAK);
            }
            if (this.docCache.isEmpty()) {
                return -1;
            }
        }
        if (debugMode > 1) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: proofInfo = " + this.proofInfo);
        }
        if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to run getParaPos initialization: " + runTime);
        }
        if (this.proofInfo == 1) {
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaPos: start getParaFromViewCursorOrDialog");
            }
            return this.getParaFromViewCursorOrDialog(chPara, locale, footnotePositions);
        }
        return this.getParaFromFlatparagraph(chPara, locale, startPos, footnotePositions);
    }

    private int getParaFromFlatparagraph(String chPara, Locale locale, int startPos, int[] footnotePositions) {
        long runTime;
        if (this.isDisposed() || this.docCache.isEmpty()) {
            return -1;
        }
        long startTime = 0L;
        if (debugModeTm) {
            startTime = System.currentTimeMillis();
        }
        if (startPos != 0 && this.proofInfo == 2) {
            long runTime2;
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromFlatparagraph: Number of Paragraph: " + this.numLastFlPara + "; startPos = " + startPos + " (proofInfo == " + 2 + ")" + OfficeTools.LOG_LINE_BREAK);
            }
            if (debugModeTm && (runTime2 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run getParaFromFlatparagraph(numLastFlPara, startPos > 0): " + runTime2);
            }
            return this.numLastFlPara.get(this.numLastFlPara.size() - 1);
        }
        int nPara = this.findNextParaPos(chPara, locale, startPos);
        if (nPara >= 0) {
            long runTime3;
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromFlatparagraph: Number of Paragraph: " + nPara + ", start: " + startPos + OfficeTools.LOG_LINE_BREAK);
            }
            if (debugModeTm && (runTime3 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run getParaFromFlatparagraph(numLastFlPara, startPos == 0): " + runTime3);
            }
            return nPara;
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromFlatparagraph: last Number of Paragraph: " + this.numLastFlPara + ", Type: " + this.docCache.getNumberOfTextParagraph((int)this.numLastFlPara.get((int)(this.numLastFlPara.size() - 1)).intValue()).type);
            MessageHandler.printToLogFile("Old Para: " + this.docCache.getFlatParagraph(this.numLastFlPara.get(this.numLastFlPara.size() - 1)));
            MessageHandler.printToLogFile("New Para: " + chPara);
        }
        nPara = this.changesInNumberOfParagraph(true);
        if (debugMode > 0) {
            MessageHandler.printToLogFile("New Para Number: " + nPara + ", Type: " + this.docCache.getNumberOfTextParagraph((int)nPara).type);
        }
        if (nPara < 0) {
            long runTime4;
            if (debugModeTm && (runTime4 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run getParaFromFlatparagraph(getParaFromViewCursorOrDialog 1): " + runTime4);
            }
            return this.getParaFromViewCursorOrDialog(chPara, locale, footnotePositions);
        }
        if (this.isDisposed()) {
            return -1;
        }
        DocumentCache.TextParagraph nTPara = this.docCache.getNumberOfTextParagraph(nPara);
        if (this.proofInfo == 2 && nTPara.type == -1) {
            long runTime5;
            if (debugModeTm && (runTime5 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run getParaFromFlatparagraph(getPosFromChangedPara 1): " + runTime5);
            }
            return this.getPosFromChangedPara(chPara, locale, nPara, footnotePositions);
        }
        if (!this.isDisposed()) {
            int n;
            FlatParagraphTools flatPara = this.singleDocument.getFlatParagraphTools();
            String curFlatParaText = flatPara.getCurrentParaText();
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromFlatparagraph: curFlatParaText: " + curFlatParaText + OfficeTools.LOG_LINE_BREAK + "chPara: " + chPara + OfficeTools.LOG_LINE_BREAK + "getFlatParagraph: " + this.docCache.getFlatParagraph(nPara) + OfficeTools.LOG_LINE_BREAK);
            }
            if (this.proofInfo == 0) {
                if (curFlatParaText != null && !curFlatParaText.equals(chPara) && curFlatParaText.equals(this.docCache.getFlatParagraph(nPara))) {
                    long runTime6;
                    if (debugModeTm && (runTime6 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                        MessageHandler.printToLogFile("Time to run getParaFromFlatparagraph(getParaFromViewCursorOrDialog 2): " + runTime6);
                    }
                    return this.getParaFromViewCursorOrDialog(chPara, locale, footnotePositions);
                }
                if (curFlatParaText != null) {
                    chPara = curFlatParaText;
                }
            } else if (curFlatParaText != null && !curFlatParaText.equals(this.docCache.getFlatParagraph(nPara)) && (n = this.getParaFromDocCache(chPara, locale, nPara)) >= 0) {
                long runTime7;
                DocumentCache.TextParagraph tPara = this.docCache.getNumberOfTextParagraph(n);
                if (tPara != null && tPara.type != -1 && tPara.number >= 0) {
                    this.numLastFlPara.set(tPara.type, tPara.number);
                }
                this.numLastFlPara.set(this.numLastFlPara.size() - 1, n);
                if (debugMode > 0) {
                    MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromFlatparagraph: From document cache: Number of Paragraph: " + n + ", start: " + startPos + OfficeTools.LOG_LINE_BREAK);
                }
                this.textIsChanged = true;
                if (debugModeTm && (runTime7 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                    MessageHandler.printToLogFile("Time to run getParaFromFlatparagraph: " + runTime7);
                }
                return n;
            }
        }
        if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to run getParaFromFlatparagraph(getPosFromChangedPara 2): " + runTime);
        }
        return this.getPosFromChangedPara(chPara, locale, nPara, footnotePositions);
    }

    private boolean isDisposed() {
        return this.singleDocument.isDisposed();
    }

    private int getParaFromDocCache(String chPara, Locale locale, int nStart) {
        if (!this.isDisposed()) {
            int i;
            for (i = nStart; i < this.docCache.size(); ++i) {
                if (!this.docCache.isEqual(i, chPara, locale)) continue;
                return i;
            }
            for (i = nStart - 1; i >= 0; --i) {
                if (!this.docCache.isEqual(i, chPara, locale)) continue;
                return i;
            }
        }
        return -1;
    }

    ViewCursorTools getViewCursorTools() {
        OfficeTools.waitForLO();
        return new ViewCursorTools(this.xComponent);
    }

    private int getParaFromViewCursorOrDialog(String chParaWithFootnotes, Locale locale, int[] footnotePositions) {
        long runTime;
        int nPara;
        DocumentCache.TextParagraph tPara;
        if (this.isDisposed() || !this.docCache.isFinished() || this.docCache.isEmpty()) {
            return -1;
        }
        long startTime = 0L;
        if (debugModeTm) {
            startTime = System.currentTimeMillis();
        }
        ViewCursorTools viewCursor = new ViewCursorTools(this.xComponent);
        String vcText = SingleCheck.removeFootnotes(viewCursor.getViewCursorParagraphText(), footnotePositions, null);
        String chPara = SingleCheck.removeFootnotes(chParaWithFootnotes, footnotePositions, null);
        if (debugMode > 0) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromViewCursorOrDialog: vcText: " + vcText);
            MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromViewCursorOrDialog: chPara: " + chPara);
        }
        if (chPara.equals(vcText) && (tPara = viewCursor.getViewCursorParagraph()) != null && tPara.type != -1) {
            long runTime2;
            int nPara2;
            this.numLastVCPara = nPara2 = this.docCache.getFlatParagraphNumber(tPara);
            if (this.proofInfo == 2) {
                this.numLastFlPara.set(tPara.type, tPara.number);
                this.numLastFlPara.set(this.numLastFlPara.size() - 1, nPara2);
            }
            if (!this.docCache.isEqual(nPara2, chParaWithFootnotes, locale)) {
                this.actualizeDocumentCache(nPara2, false);
                if (this.docCache.getFlatParagraph(nPara2) == null || !DocumentCache.isEqualText(this.docCache.getFlatParagraph(nPara2), chPara, footnotePositions)) {
                    long runTime3;
                    if (debugMode > 0) {
                        MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromViewCursorOrDialog: cText != chPara: Number of Paragraph: " + nPara2);
                    }
                    if (debugModeTm && (runTime3 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                        MessageHandler.printToLogFile("Time to run getParaFromViewCursorOrDialog: " + runTime3);
                    }
                    return -1;
                }
                this.textIsChanged = true;
            }
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromViewCursorOrDialog: Number of Paragraph: " + nPara2 + OfficeTools.LOG_LINE_BREAK);
            }
            if (debugModeTm && (runTime2 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run getParaFromViewCursorOrDialog: " + runTime2);
            }
            return nPara2;
        }
        if (this.numLastVCPara >= this.docCache.size()) {
            this.numLastVCPara = 0;
        }
        if ((nPara = this.getParaFromDocCache(chPara, locale, this.numLastVCPara)) >= 0) {
            long runTime4;
            this.numLastVCPara = nPara;
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromViewCursorOrDialog: From DocCache: Number of Paragraph: " + nPara + OfficeTools.LOG_LINE_BREAK);
            }
            if (debugModeTm && (runTime4 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run getParaFromViewCursorOrDialog: " + runTime4);
            }
            return nPara;
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: getParaFromViewCursorOrDialog: Paragraph not found: return -1" + OfficeTools.LOG_LINE_BREAK);
        }
        if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to run getParaFromViewCursorOrDialog: " + runTime);
        }
        return -1;
    }

    private boolean handleCacheChanges() {
        DocumentCache.ChangedRange changed;
        if (this.useQueue && this.mDocHandler.getTextLevelCheckQueue() != null) {
            this.mDocHandler.getTextLevelCheckQueue().interruptCheck(this.docID, true);
        }
        if ((changed = this.docCache.refreshAndCompare(this.singleDocument, LinguisticServices.getLocale(this.fixedLanguage), LinguisticServices.getLocale(this.docLanguage), this.xComponent, 5)) == null || this.isDisposed()) {
            return false;
        }
        this.changeFrom = changed.from - this.numParasToChange;
        this.changeTo = changed.to + this.numParasToChange;
        this.singleDocument.removeAndShiftIgnoredMatch(changed.from, changed.to, changed.oldSize, changed.newSize);
        if (debugMode > 0) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: handleCacheChanges: Changed paragraphs: from:" + changed.from + ", to: " + changed.to);
        }
        if (!this.isDisposed()) {
            for (ResultCache cache : this.paragraphsCache) {
                cache.removeAndShift(changed.from, changed.to, changed.oldSize, changed.newSize);
            }
            if (this.useQueue) {
                if (debugMode > 0) {
                    MessageHandler.printToLogFile("CheckRequestAnalysis: handleCacheChanges: Number of Paragraphs has changed: new: " + changed.newSize + ",  old: " + changed.oldSize + ", docID: " + this.docID);
                    if (changed.to - changed.from > 1) {
                        MessageHandler.printToLogFile("CheckRequestAnalysis: handleCacheChanges: Number of Paragraphs has changed: Difference from " + changed.from + " to " + changed.to);
                        MessageHandler.printToLogFile("CheckRequestAnalysis: handleCacheChanges: Old Cache size: " + changed.oldSize);
                        MessageHandler.printToLogFile("CheckRequestAnalysis: handleCacheChanges: new docCache(from): '" + this.docCache.getFlatParagraph(changed.from) + "'");
                    }
                }
                this.changedParas.put(changed.from, this.docCache.getFlatParagraph(changed.from));
                this.changedParas.put(changed.to, this.docCache.getFlatParagraph(changed.to));
                for (int i = 0; i < this.minToCheckPara.size(); ++i) {
                    int n;
                    if (this.minToCheckPara.get(i) == 0) continue;
                    if (changed.newSize - changed.oldSize > 0) {
                        for (n = changed.from; n < changed.to; ++n) {
                            this.docCache.setSingleParagraphsCacheToNull(n, this.paragraphsCache);
                            this.singleDocument.addQueueEntry(n, i, this.minToCheckPara.get(i), this.docID, true);
                        }
                        continue;
                    }
                    if (changed.newSize - changed.oldSize >= 0) continue;
                    for (n = changed.from; n < changed.from + 1; ++n) {
                        this.docCache.setSingleParagraphsCacheToNull(n, this.paragraphsCache);
                        this.singleDocument.addQueueEntry(n, i, this.minToCheckPara.get(i), this.docID, true);
                    }
                }
                if (this.mDocHandler.getTextLevelCheckQueue() != null) {
                    this.mDocHandler.getTextLevelCheckQueue().wakeupQueue(this.docID);
                }
            }
        }
        return true;
    }

    private int changesInNumberOfParagraph(boolean getCurNum) {
        long runTime;
        long startTime = 0L;
        if (debugModeTm) {
            startTime = System.currentTimeMillis();
        }
        if (this.docCache.isEmpty() || this.isDisposed()) {
            return -1;
        }
        int nPara = 0;
        long startTime1 = 0L;
        FlatParagraphTools flatPara = this.singleDocument.getFlatParagraphTools();
        if (getCurNum) {
            long runTime2;
            if (debugModeTm) {
                startTime1 = System.currentTimeMillis();
            }
            nPara = flatPara.getCurNumFlatParagraph();
            if (debugModeTm && (runTime2 = System.currentTimeMillis() - startTime1) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run changesInNumberOfParagraph (getCurNumFlatParagraph): " + runTime2);
            }
            if (nPara < 0) {
                if (debugModeTm && (runTime2 = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                    MessageHandler.printToLogFile("Time to run changesInNumberOfParagraph (return -2): " + runTime2);
                }
                return -2;
            }
        }
        if (debugModeTm) {
            startTime1 = System.currentTimeMillis();
        }
        int nFParas = flatPara.getNumberOfAllFlatPara();
        if (debugModeTm && (runTime = System.currentTimeMillis() - startTime1) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to run changesInNumberOfParagraph (docCache.isEqualCacheSize): " + runTime);
        }
        if (nFParas == this.docCache.size()) {
            if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run changesInNumberOfParagraph (no change): " + runTime);
            }
            return nPara;
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: changesInNumberOfParagraph: resetAllParas: docCache.size: " + this.docCache.size() + ", nPara: " + nPara + ", docID: " + this.docID + OfficeTools.LOG_LINE_BREAK);
        }
        if (this.isDisposed()) {
            return -1;
        }
        if (!this.handleCacheChanges() || this.isDisposed()) {
            return -1;
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: changesInNumberOfParagraph: Number FlatParagraphs: " + this.docCache.size() + "; docID: " + this.docID);
        }
        if (nPara >= this.docCache.size() && ((nPara = flatPara.getCurNumFlatParagraph()) < 0 || nPara >= this.docCache.size())) {
            if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
                MessageHandler.printToLogFile("Time to run changesInNumberOfParagraph (return -1): " + runTime);
            }
            return -1;
        }
        if (getCurNum) {
            this.textIsChanged = true;
        }
        if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to run changesInNumberOfParagraph (cache has changed): " + runTime);
        }
        return nPara;
    }

    private void handleChangedPara(int nPara, String chPara, Locale locale, int[] footnotePos, List<Integer> deletedChars) {
        if (!this.docCache.isAutomaticGenerated(nPara, false)) {
            if (debugMode > 0) {
                MessageHandler.printToLogFile("CheckRequestAnalysis: handleChangedPara: flat praragraph changed: nPara: " + nPara + "; docID: " + this.docID + "; locale: isMultilingual: " + this.docCache.isMultilingualFlatParagraph(nPara) + "; old: " + OfficeTools.localeToString(this.docCache.getFlatParagraphLocale(nPara)) + "; new: " + OfficeTools.localeToString(locale) + OfficeTools.LOG_LINE_BREAK + "old: " + this.docCache.getFlatParagraph(nPara) + OfficeTools.LOG_LINE_BREAK + "new: " + chPara + OfficeTools.LOG_LINE_BREAK);
            }
            this.docCache.setFlatParagraph(nPara, chPara, locale);
            this.docCache.setFlatParagraphFootnotes(nPara, footnotePos);
            this.docCache.setFlatParagraphDeletedCharacters(nPara, deletedChars);
            if (this.useQueue) {
                this.runningParas.add(nPara);
                this.changedParas.put(nPara, chPara);
                this.singleDocument.removeResultCache(nPara, true);
                for (int i = 1; i < this.minToCheckPara.size(); ++i) {
                    this.singleDocument.addQueueEntry(nPara, i, this.minToCheckPara.get(i), this.docID, this.numLastFlPara.get(this.numLastFlPara.size() - 1) >= 0);
                }
            } else {
                this.singleDocument.removeResultCache(nPara, true);
            }
            this.textIsChanged = true;
            this.changeFrom = nPara - this.numParasToChange;
            this.changeTo = nPara + this.numParasToChange + 1;
            this.singleDocument.removeIgnoredMatch(nPara, false);
        }
    }

    private int getPosFromChangedPara(String chPara, Locale locale, int nPara, int[] footnotePos) {
        long runTime;
        if (this.docCache.isEmpty() || nPara < 0 || this.isDisposed()) {
            return -1;
        }
        long startTime = 0L;
        if (debugModeTm) {
            startTime = System.currentTimeMillis();
        }
        DocumentCache.TextParagraph tPara = this.docCache.getNumberOfTextParagraph(nPara);
        DocumentCursorTools docCursor = this.singleDocument.getDocumentCursorTools();
        List<Integer> deletedChars = docCursor.getDeletedCharactersOfTextParagraph(tPara, this.config.includeTrackedChanges());
        if (!this.docCache.isEqual(nPara, chPara, locale, deletedChars)) {
            this.handleChangedPara(nPara, chPara, locale, footnotePos, deletedChars);
        }
        if (debugMode > 0) {
            MessageHandler.printToLogFile("CheckRequestAnalysis: getPosFromChangedPara: Number of Paragraph: " + nPara + OfficeTools.LOG_LINE_BREAK);
        }
        if (tPara != null && tPara.type != -1 && tPara.number >= 0) {
            this.numLastFlPara.set(tPara.type, tPara.number);
        }
        this.numLastFlPara.set(this.numLastFlPara.size() - 1, nPara);
        if (debugModeTm && (runTime = System.currentTimeMillis() - startTime) > (long)OfficeTools.TIME_TOLERANCE) {
            MessageHandler.printToLogFile("Time to run getPosFromChangedPara: " + runTime);
        }
        return nPara;
    }

    private int findNextParaPos(String paraStr, Locale locale, int startPos) {
        if (this.docCache.size() < 1 || this.isDisposed()) {
            return -1;
        }
        int startPara = this.numLastFlPara.get(this.numLastFlPara.size() - 1);
        if (startPos > 0 && startPara >= 0) {
            if (startPara >= 0 && startPara < this.docCache.size() && this.docCache.isEqual(startPara, paraStr, locale)) {
                return startPara;
            }
        } else if (startPos == 0) {
            int docPara;
            int type;
            int n = startPara = startPara >= this.docCache.size() - 1 ? 0 : startPara + 1;
            if (startPara >= 0 && startPara < this.docCache.size() && this.docCache.isEqual(startPara, paraStr, locale)) {
                DocumentCache.TextParagraph tPara = this.docCache.getNumberOfTextParagraph(startPara);
                if (tPara != null && tPara.type != -1 && tPara.number >= 0) {
                    this.numLastFlPara.set(tPara.type, tPara.number);
                    this.numLastFlPara.set(this.numLastFlPara.size() - 1, startPara);
                }
                return startPara;
            }
            for (type = 3; type < this.numLastFlPara.size() - 1; ++type) {
                docPara = this.numLastFlPara.get(type);
                docPara = docPara >= this.docCache.textSize(type) - 1 ? 0 : docPara + 1;
                startPara = this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(type, docPara));
                if (startPara < 0 || startPara >= this.docCache.size() || !this.docCache.isEqual(startPara, paraStr, locale)) continue;
                this.numLastFlPara.set(type, docPara);
                this.numLastFlPara.set(this.numLastFlPara.size() - 1, startPara);
                return startPara;
            }
            for (type = 0; type < 3; ++type) {
                for (docPara = this.numLastFlPara.get(type) + 1; docPara < this.docCache.textSize(type); ++docPara) {
                    startPara = this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(type, docPara));
                    if (startPara < 0 || startPara >= this.docCache.size() || !this.docCache.isEqual(startPara, paraStr, locale)) continue;
                    this.numLastFlPara.set(type, docPara);
                    return startPara;
                }
                for (docPara = 0; docPara < this.numLastFlPara.get(type); ++docPara) {
                    startPara = this.docCache.getFlatParagraphNumber(new DocumentCache.TextParagraph(type, docPara));
                    if (startPara < 0 || startPara >= this.docCache.size() || !this.docCache.isEqual(startPara, paraStr, locale)) continue;
                    this.numLastFlPara.set(type, docPara);
                    return startPara;
                }
            }
        }
        return -1;
    }
}

